/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.i18n.GT;
import org.jmol.popup.GenericPopup;
import org.jmol.popup.PopupResource;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class SwingPopup
extends GenericPopup {
    private static final int MENUITEM_HEIGHT = 20;
    private MenuItemListener mil;
    private CheckboxMenuItemListener cmil;
    private MenuMouseListener mfl;

    public void finalize() {
        System.out.println("SwingPopup Finalize " + this);
    }

    public void dispose() {
        this.clearListeners(this.popupMenu);
        this.clearListeners(this.frankPopup);
        this.popupMenu = null;
        this.frankPopup = null;
    }

    private void clearListeners(Object object) {
        if (object == null) {
            return;
        }
        Component[] componentArray = object instanceof JPopupMenu ? ((JPopupMenu)object).getComponents() : ((JMenu)object).getPopupMenu().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                this.clearListeners(((JMenu)component).getPopupMenu());
                continue;
            }
            try {
                component.removeMouseListener(this.mfl);
                ((AbstractButton)component).removeActionListener(this.mil);
                ((AbstractButton)component).removeItemListener(this.cmil);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void show(int n, int n2) {
        if (!this.viewer.haveDisplay) {
            return;
        }
        this.show(n, n2, false);
        if (n < 0) {
            this.getViewerData();
            this.setFrankMenu(this.currentMenuItemId);
            this.thisx = -n - 50;
            if (this.nFrankList > 1) {
                this.thisy = n2 - this.nFrankList * 20;
                this.showPopupMenu(this.frankPopup, this.thisx, this.thisy);
                return;
            }
        }
        this.restorePopupMenu();
        if (this.asPopup) {
            this.showPopupMenu(this.popupMenu, this.thisx, this.thisy);
        }
    }

    protected void set(Viewer viewer) {
        super.set(viewer);
    }

    protected void initialize(Viewer viewer, PopupResource popupResource) {
        String string = popupResource.getMenuName();
        this.set(viewer);
        this.popupMenu = new JPopupMenu(string);
        this.menuName = string;
        this.build(string, this.popupMenu, popupResource);
    }

    private void updateButton(AbstractButton abstractButton, String string, String string2) {
        String[] stringArray = new String[]{string};
        Object object = this.getEntryIcon(stringArray);
        string = stringArray[0];
        if (object != null) {
            abstractButton.setIcon((ImageIcon)object);
        }
        if (string != null) {
            abstractButton.setText(string);
        }
        if (string2 != null) {
            abstractButton.setActionCommand(string2);
        }
    }

    protected void addButtonGroupItem(Object object) {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        ((ButtonGroup)this.buttonGroup).add((JMenuItem)object);
    }

    protected Object addCheckboxMenuItem(Object object, String string, String string2, String string3, boolean bl, boolean bl2) {
        JMenuItem jMenuItem;
        if (bl2) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            jMenuItem = jRadioButtonMenuItem;
            jRadioButtonMenuItem.setArmed(bl);
        } else {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            jMenuItem = jCheckBoxMenuItem;
            jCheckBoxMenuItem.setState(bl);
        }
        jMenuItem.setSelected(bl);
        jMenuItem.addItemListener(this.cmil);
        jMenuItem.setActionCommand(string2);
        this.updateButton(jMenuItem, string, string2);
        if (string3 != null && string3.startsWith("Focus")) {
            jMenuItem.addMouseListener(this.mfl);
            string3 = ((Component)object).getName() + "." + string3;
        }
        jMenuItem.setName(string3 == null ? ((Component)object).getName() + "." : string3);
        this.addToMenu(object, jMenuItem);
        return jMenuItem;
    }

    protected Object addMenuItem(Object object, String string, String string2, String string3) {
        JMenuItem jMenuItem = new JMenuItem(string);
        this.updateButton(jMenuItem, string, string2);
        jMenuItem.addActionListener(this.mil);
        if (string3 != null && string3.startsWith("Focus")) {
            jMenuItem.addMouseListener(this.mfl);
            string3 = ((Component)object).getName() + "." + string3;
        }
        jMenuItem.setName(string3 == null ? ((Component)object).getName() + "." : string3);
        this.addToMenu(object, jMenuItem);
        return jMenuItem;
    }

    protected void addMenuSeparator(Object object) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).addSeparator();
        } else {
            ((JMenu)object).addSeparator();
        }
    }

    protected void addMenuSubMenu(Object object, Object object2) {
        this.addToMenu(object, object2);
    }

    protected void addToMenu(Object object, Object object2) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).add((JComponent)object2);
        } else if (object instanceof JMenu) {
            ((JMenu)object).add((JComponent)object2);
        } else {
            Logger.warn("cannot add object to menu: " + object);
        }
    }

    protected void enableMenu(Object object, boolean bl) {
        if (object instanceof JMenuItem) {
            this.enableMenuItem(object, bl);
            return;
        }
        try {
            ((JMenu)object).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void enableMenuItem(Object object, boolean bl) {
        try {
            ((JMenuItem)object).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getId(Object object) {
        return ((Component)object).getName();
    }

    protected Object getImageIcon(URL uRL) {
        return new ImageIcon(uRL);
    }

    protected int getMenuItemCount(Object object) {
        return ((JMenu)object).getItemCount();
    }

    protected Object newMenu(String string, String string2) {
        JMenu jMenu = new JMenu(string);
        this.updateButton(jMenu, string, null);
        jMenu.setName(string2);
        jMenu.setAutoscrolls(true);
        return jMenu;
    }

    protected void removeMenuItem(Object object, int n) {
        ((JMenu)object).remove(n);
    }

    protected void removeAll(Object object) {
        ((JMenu)object).removeAll();
    }

    protected void renameMenu(Object object, String string) {
        ((JMenu)object).setText(string);
    }

    protected void setAutoscrolls(Object object) {
        ((JMenu)object).setAutoscrolls(true);
    }

    protected void setCheckBoxState(Object object, boolean bl) {
        if (object instanceof JCheckBoxMenuItem) {
            ((JCheckBoxMenuItem)object).setState(bl);
        } else {
            ((JRadioButtonMenuItem)object).setArmed(bl);
        }
        ((JMenuItem)object).setSelected(bl);
    }

    protected void setCheckBoxValue(Object object) {
        JMenuItem jMenuItem = (JMenuItem)object;
        this.setCheckBoxValue(jMenuItem, jMenuItem.getActionCommand(), jMenuItem.isSelected());
    }

    protected void setLabel(Object object, String string) {
        if (object instanceof JMenuItem) {
            ((JMenuItem)object).setText(string);
        } else {
            ((JMenu)object).setText(string);
        }
    }

    protected void setMenuListeners() {
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
        this.mfl = new MenuMouseListener();
    }

    protected void checkMenuClick(Object object, String string) {
        if (string.equals("clearQ")) {
            for (Object v : this.htCheckbox.values()) {
                JMenuItem jMenuItem = (JMenuItem)v;
                if (jMenuItem.getActionCommand().indexOf(":??") < 0) continue;
                this.setLabel(jMenuItem, "??");
                jMenuItem.setActionCommand("_??P!:");
                jMenuItem.setSelected(false);
                jMenuItem.setArmed(false);
            }
            this.viewer.evalStringQuiet("set picking assignAtom_C");
            return;
        }
        super.checkMenuClick(object, string);
    }

    public void checkMenuFocus(Object object, boolean bl) {
        if (object instanceof JMenuItem) {
            String string = ((JMenuItem)object).getName();
            if (string.indexOf("Focus") < 0) {
                return;
            }
            if (bl) {
                this.viewer.script("selectionHalos ON;" + ((JMenuItem)object).getActionCommand());
            } else {
                this.viewer.script("selectionHalos OFF");
            }
        }
    }

    protected void insertMenuSubMenu(Object object, Object object2, int n) {
        if (object instanceof JPopupMenu) {
            ((JPopupMenu)object).insert((JMenu)object2, n);
        } else {
            ((JMenu)object).insert((JMenu)object2, n);
        }
    }

    protected void createFrankPopup() {
        this.frankPopup = new JPopupMenu("Frank");
    }

    protected void resetFrankMenu() {
        ((JPopupMenu)this.frankPopup).removeAll();
    }

    protected void getMenuAsText(StringBuffer stringBuffer, int n, Object object, String string) {
        String string2 = string;
        Component[] componentArray = object instanceof JPopupMenu ? ((JPopupMenu)object).getComponents() : ((JMenu)object).getPopupMenu().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            String string3;
            JMenuItem jMenuItem;
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                jMenuItem = (JMenu)component;
                string2 = jMenuItem.getName();
                string3 = "enabled:" + jMenuItem.isEnabled();
                SwingPopup.addItemText(stringBuffer, 'M', n, string2, jMenuItem.getText(), null, string3);
                this.getMenuAsText(stringBuffer, n + 1, ((JMenu)component).getPopupMenu(), string2);
                continue;
            }
            if (component instanceof JMenuItem) {
                jMenuItem = (JMenuItem)component;
                string3 = "enabled:" + jMenuItem.isEnabled();
                if (component instanceof JCheckBoxMenuItem) {
                    string3 = string3 + ";checked:" + ((JCheckBoxMenuItem)component).getState();
                }
                String string4 = this.fixScript(jMenuItem.getName(), jMenuItem.getActionCommand());
                SwingPopup.addItemText(stringBuffer, 'I', n, jMenuItem.getName(), jMenuItem.getText(), string4, string3);
                continue;
            }
            SwingPopup.addItemText(stringBuffer, 'S', n, string2, null, null, null);
        }
    }

    protected Object getParent(Object object) {
        return ((JMenu)object).getParent();
    }

    protected int getPosition(Object object) {
        Object object2 = this.getParent(object);
        if (object2 instanceof JPopupMenu) {
            int n = ((JPopupMenu)object2).getComponentCount();
            while (--n >= 0) {
                if (((JPopupMenu)object2).getComponent(n) != object) continue;
                return n;
            }
        } else {
            int n = ((JMenu)object2).getItemCount();
            while (--n >= 0) {
                if (((JMenu)object2).getItem(n) != object) continue;
                return n;
            }
        }
        return -1;
    }

    protected String setCheckBoxOption(Object object, String string, String string2) {
        if (this.isModelKit) {
            String string3 = JOptionPane.showInputDialog(GT._("Element?"), (Object)"");
            if (string3 == null || Elements.elementNumberFromSymbol(string3, true) == 0) {
                return null;
            }
            this.setLabel(object, string3);
            ((JMenuItem)object).setActionCommand("assignAtom_" + string3 + "P!:??");
            return "set picking assignAtom_" + string3;
        }
        return null;
    }

    protected void showPopupMenu(Object object, int n, int n2) {
        try {
            ((JPopupMenu)object).show((Component)this.viewer.getDisplay(), n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            SwingPopup.this.restorePopupMenu();
            SwingPopup.this.setCheckBoxValue(itemEvent.getSource());
            String string = SwingPopup.this.getId(itemEvent.getSource());
            if (string != null) {
                SwingPopup.this.currentMenuItemId = string;
            }
        }
    }

    class MenuMouseListener
    implements MouseListener {
        MenuMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            SwingPopup.this.checkMenuFocus(mouseEvent.getSource(), true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SwingPopup.this.checkMenuFocus(mouseEvent.getSource(), false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingPopup.this.checkMenuClick(actionEvent.getSource(), actionEvent.getActionCommand());
        }
    }
}

