/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.AtomType;
import org.jmol.modelset.Atom;

public class MinAtom {
    int index;
    public String sType;
    public Atom atom;
    public AtomType ffAtomType;
    public int ffType;
    public Integer vdwKey;
    public double[] coord = new double[3];
    public double[] force = new double[3];
    private List<MinBond> bonds = new ArrayList<MinBond>();
    public int nBonds;
    public int hCount;
    public double partialCharge;
    public BitSet bsVdw = new BitSet();
    public BitSet bs14 = new BitSet();
    int[] bondedAtoms;

    public String toString() {
        return "#" + this.index + " " + this.sType;
    }

    MinAtom(int n, Atom atom, double[] dArray, int n2) {
        this.index = n;
        this.atom = atom;
        this.coord = dArray;
        this.bsVdw.set(n + 1, n2);
        this.bsVdw.clear(n);
        this.hCount = atom.getCovalentHydrogenCount();
    }

    void set() {
        this.coord[0] = this.atom.x;
        this.coord[1] = this.atom.y;
        this.coord[2] = this.atom.z;
    }

    public MinBond getBondTo(int n) {
        this.getBondedAtomIndexes();
        for (int i = 0; i < this.nBonds; ++i) {
            if (this.bondedAtoms[i] != n) continue;
            return this.bonds.get(i);
        }
        return null;
    }

    public int[] getBondedAtomIndexes() {
        if (this.bondedAtoms == null) {
            this.bondedAtoms = new int[this.nBonds];
            int n = this.nBonds;
            while (--n >= 0) {
                this.bondedAtoms[n] = this.bonds.get(n).getOtherAtom(this.index);
            }
        }
        return this.bondedAtoms;
    }

    public String getIdentity() {
        return this.atom.getInfo();
    }

    public void addBond(MinBond minBond, int n) {
        this.bonds.add(minBond);
        ++this.nBonds;
        this.bsVdw.clear(n);
    }

    public int getBondIndex(int n) {
        return this.bonds.get((int)n).index;
    }

    public static boolean isLinear(MinAtom minAtom) {
        switch (minAtom.ffType) {
            case 4: 
            case 53: 
            case 61: {
                return true;
            }
        }
        return false;
    }
}

