/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export.UseTable;
import org.jmol.export.__RayTracerExporter;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _TachyonExporter
extends __RayTracerExporter {
    boolean wasPerspectiveDepth;
    String lighting;
    String phong;
    UseTable textures = new UseTable(" ");
    private String textureCode;

    public _TachyonExporter() {
        this.commentChar = "# ";
    }

    @Override
    boolean initializeOutput(Viewer viewer, double d, Graphics3D graphics3D, Object object) {
        this.getLightingInfo();
        return super.initializeOutput(viewer, d, graphics3D, object);
    }

    private void getLightingInfo() {
        this.lighting = " AMBIENT " + _TachyonExporter.round((float)Graphics3D.getAmbientPercent() / 100.0f) + " DIFFUSE " + _TachyonExporter.round((float)Graphics3D.getDiffusePercent() / 100.0f) + " SPECULAR " + _TachyonExporter.round((float)Graphics3D.getSpecularPercent() / 100.0f);
        this.phong = " Phong Plastic 0.5 Phong_size " + Graphics3D.getSpecularExponent();
    }

    @Override
    protected void outputHeader() {
        super.outputHeader();
        this.output("# ******************************************************\n");
        this.output("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("#\n");
        this.output("# This script was generated on " + _TachyonExporter.getExportDate() + "\n");
        this.output("#\n");
        this.output("# Requires Tachyon version 0.98.7 or newer\n");
        this.output("#\n");
        this.output("# Default tachyon rendering command for this scene:\n");
        this.output("#   tachyon  -aasamples 12 %s -format TARGA -o %s.tga\n");
        this.output("#\n");
        this.output("# ******************************************************\n");
        this.output("\n");
        this.output(this.getJmolPerspective());
        this.output("\n");
        this.output("Begin_Scene\n");
        this.output("Resolution " + this.screenWidth + " " + this.screenHeight + "\n");
        this.output("Shader_Mode Medium\n");
        this.output("  Trans_VMD\n");
        this.output("  Fog_VMD\n");
        this.output("End_Shader_Mode\n");
        this.output("Camera\n");
        this.output("  Zoom 3.0\n");
        this.output("  Aspectratio 1\n");
        this.output("  Antialiasing 12\n");
        this.output("  Raydepth 8\n");
        this.output("  Center " + this.triad(this.screenWidth / 2, this.screenHeight / 2, 0.0f) + "\n");
        this.output("  Viewdir 0 0 1\n");
        this.output("  Updir   0 1 0\n");
        this.output("End_Camera\n");
        this.output("Directional_Light Direction " + _TachyonExporter.round(this.lightSource) + " Color 1 1 1\n");
        this.output("\n");
        this.output("Background " + this.rgbFractionalFromColix(this.backgroundColix, ' ') + "\n");
        this.output("\n");
    }

    @Override
    protected void outputFooter() {
        this.output("End_Scene\n");
    }

    @Override
    protected void output(Tuple3f tuple3f) {
        this.output(this.triad(tuple3f));
    }

    private String triad(float f, float f2, float f3) {
        return (int)f + " " + (int)(-f2) + " " + (int)f3;
    }

    private String triad(Tuple3f tuple3f) {
        if (Float.isNaN(tuple3f.x)) {
            return "0 0 0";
        }
        return this.triad(tuple3f.x, tuple3f.y, tuple3f.z);
    }

    private void outputTextureCode() {
        this.output(this.textureCode);
        this.output("\n");
    }

    private void outputTexture(short s, boolean bl) {
        this.outputTexture2(this.rgbFractionalFromColix(s, ' '), _TachyonExporter.opacityFractionalFromColix(s), bl);
    }

    private void outputTexture(int n, boolean bl) {
        this.outputTexture2(_TachyonExporter.rgbFractionalFromArgb(n, ' '), _TachyonExporter.opacityFractionalFromArgb(n), bl);
    }

    private void outputTexture2(String string, String string2, boolean bl) {
        String string3 = this.textureCode = bl ? this.textures.getDef("t" + string + string2) : null;
        if (bl && this.textureCode.startsWith(" ")) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lighting);
        stringBuffer.append(" Opacity " + string2);
        stringBuffer.append(this.phong);
        stringBuffer.append(" Color " + string);
        stringBuffer.append(" TexFunc 0\n");
        if (!bl) {
            this.textureCode = "Texture " + stringBuffer;
            return;
        }
        this.output("TexDef " + this.textureCode);
        this.output(stringBuffer.toString());
        this.textureCode = " " + this.textureCode;
    }

    @Override
    protected void outputCircle(int n, int n2, int n3, float f, short s, boolean bl) {
        this.tempV1.set(0.0f, 0.0f, -1.0f);
        this.outputRing(n, n2, n3, this.tempV1, f, s, bl);
    }

    private void outputRing(int n, int n2, int n3, Vector3f vector3f, float f, short s, boolean bl) {
        this.outputTexture(s, true);
        this.output("Ring Center ");
        this.output(this.triad(n, n2, n3));
        this.output(" Normal " + this.triad(vector3f));
        this.output(" Inner " + _TachyonExporter.round(bl ? 0.0 : (double)f * 0.95));
        this.output(" Outer " + _TachyonExporter.round(f));
        this.outputTextureCode();
    }

    @Override
    protected void outputCone(Point3f point3f, Point3f point3f2, float f, short s, boolean bl) {
        this.viewer.unTransformPoint(point3f, this.tempP1);
        this.viewer.unTransformPoint(point3f2, this.tempP2);
        f = this.viewer.unscaleToScreen(point3f.z, f);
        Matrix3f matrix3f = this.getRotationMatrix(this.tempP1, this.tempP2, f);
        this.jmolRenderer.drawSurface(_TachyonExporter.getConeMesh(this.tempP1, matrix3f, s), s);
    }

    @Override
    protected void outputCylinder(Point3f point3f, Point3f point3f2, float f, short s, boolean bl) {
        this.outputTexture(s, true);
        this.output("FCylinder Base ");
        this.output(this.triad(point3f));
        this.output(" Apex ");
        this.output(this.triad(point3f2));
        this.output(" Rad " + _TachyonExporter.round(f));
        this.outputTextureCode();
        if (bl && f > 1.0f) {
            this.tempV1.sub(point3f, point3f2);
            this.outputRing((int)point3f.x, (int)point3f.y, (int)point3f.z, this.tempV1, f, s, true);
            this.tempV1.scale(-1.0f);
            this.outputRing((int)point3f2.x, (int)point3f2.y, (int)point3f2.z, this.tempV1, f, s, true);
        }
    }

    @Override
    protected void fillConicalCylinder(Point3f point3f, Point3f point3f2, int n, short s, byte by) {
        short s2 = this.viewer.scaleToScreen((int)((point3f.z + point3f2.z) / 2.0f), n);
        this.fillCylinderScreenMad(s, by, s2, point3f, point3f2);
    }

    @Override
    protected void outputCylinderConical(Point3f point3f, Point3f point3f2, float f, float f2, short s) {
    }

    @Override
    protected void outputEllipsoid(Point3f point3f, float f, double[] dArray, short s) {
        this.viewer.transformPoint(point3f, this.tempP1);
        this.outputSphere(this.tempP1.x, this.tempP1.y, this.tempP1.z, f, s);
    }

    @Override
    protected void outputSurface(Point3f[] point3fArray, Vector3f[] vector3fArray, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BitSet bitSet, int n4, short s, List<Short> list, Map<Short, Integer> map, Point3f point3f) {
        int n5;
        int n6;
        int n7;
        if (sArray2 != null) {
            int n8;
            boolean bl = bitSet == null;
            int n9 = n8 = bl ? n2 - 1 : bitSet.nextSetBit(0);
            while (n9 >= 0) {
                _TachyonExporter.setTempVertex(point3fArray[nArray[n9][0]], point3f, this.tempP1);
                _TachyonExporter.setTempVertex(point3fArray[nArray[n9][1]], point3f, this.tempP2);
                _TachyonExporter.setTempVertex(point3fArray[nArray[n9][2]], point3f, this.tempP3);
                this.viewer.transformPoint(this.tempP1, this.tempP1);
                this.viewer.transformPoint(this.tempP2, this.tempP2);
                this.viewer.transformPoint(this.tempP3, this.tempP3);
                this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, s);
                n9 = bl ? n9 - 1 : bitSet.nextSetBit(n9 + 1);
            }
            return;
        }
        this.outputTexture(sArray == null ? s : sArray[0], false);
        this.output("VertexArray  Numverts " + n + "\nCoords\n");
        for (n7 = 0; n7 < n; ++n7) {
            this.outputVertex(point3fArray[n7], point3f);
        }
        this.output("\nNormals\n");
        for (n7 = 0; n7 < n; ++n7) {
            _TachyonExporter.setTempVertex(point3fArray[n7], point3f, this.tempP1);
            this.output(this.triad(this.getScreenNormal(this.tempP1, vector3fArray[n7], 10.0f)) + "\n");
        }
        String string = sArray == null ? this.rgbFractionalFromColix(s, ' ') : null;
        this.output("\nColors\n");
        for (n6 = 0; n6 < n; ++n6) {
            this.output((sArray == null ? string : this.rgbFractionalFromColix(sArray[n6], ' ')) + "\n");
        }
        this.outputTextureCode();
        this.output("\nTriMesh " + n3 + "\n");
        n6 = bitSet == null ? 1 : 0;
        int n10 = n5 = n6 != 0 ? n2 - 1 : bitSet.nextSetBit(0);
        while (n10 >= 0) {
            this.output(nArray[n10][0] + " " + nArray[n10][1] + " " + nArray[n10][2] + "\n");
            if (n4 == 4 && nArray[n10].length == 4) {
                this.output(nArray[n10][0] + " " + nArray[n10][2] + " " + nArray[n10][3] + "\n");
            }
            n10 = n6 != 0 ? n10 - 1 : bitSet.nextSetBit(n10 + 1);
        }
        this.output("\nEnd_VertexArray\n");
    }

    @Override
    protected void outputSphere(float f, float f2, float f3, float f4, short s) {
        this.outputTexture(s, true);
        this.output("Sphere Center ");
        this.output(this.triad(f, f2, f3));
        this.output(" Rad " + _TachyonExporter.round(f4));
        this.outputTextureCode();
    }

    @Override
    protected void outputTextPixel(int n, int n2, int n3, int n4) {
        this.outputTexture(n4, true);
        this.output("Sphere Center ");
        this.output(this.triad(n, n2, n3));
        this.output(" Rad 1");
        this.outputTextureCode();
    }

    @Override
    protected void outputTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, short s) {
        this.outputTexture(s, true);
        this.output("TRI");
        this.output(" V0 " + this.triad(point3f));
        this.output(" V1 " + this.triad(point3f2));
        this.output(" V2 " + this.triad(point3f3));
        this.outputTextureCode();
    }
}

