/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class MdCrdReader
extends AtomSetCollectionReader {
    private List<Point3f[]> trajectorySteps;
    private int ptFloat = 0;
    private int lenLine = 0;

    protected void initializeReader() {
        this.atomSetCollection.addAtom(new Atom());
        this.trajectorySteps = (List)this.htParams.get("trajectorySteps");
        if (this.trajectorySteps == null) {
            this.trajectorySteps = new ArrayList<Point3f[]>();
            this.htParams.put("trajectorySteps", this.trajectorySteps);
        }
    }

    protected boolean checkLine() throws Exception {
        this.readCoordinates();
        Logger.info("Total number of trajectory steps=" + this.trajectorySteps.size());
        this.continuing = false;
        return false;
    }

    private void readCoordinates() throws Exception {
        this.line = null;
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        boolean bl = this.htParams.containsKey("isPeriodic");
        int n2 = this.templateAtomCount * 3 + (bl ? 3 : 0);
        while (true) {
            if (this.doGetModel(++this.modelNumber, null)) {
                Point3f[] point3fArray = new Point3f[n];
                if (!this.getTrajectoryStep(point3fArray, bl)) {
                    return;
                }
                this.trajectorySteps.add(point3fArray);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (!this.skipFloats(n2)) break;
        }
    }

    private float getFloat() throws Exception {
        while (this.line == null || this.ptFloat >= this.lenLine) {
            if (this.readLine() == null) {
                return Float.NaN;
            }
            this.ptFloat = 0;
            this.lenLine = this.line.length();
        }
        this.ptFloat += 8;
        return this.parseFloat(this.line.substring(this.ptFloat - 8, this.ptFloat));
    }

    private Point3f getPoint() throws Exception {
        float f = this.getFloat();
        float f2 = this.getFloat();
        float f3 = this.getFloat();
        return Float.isNaN(f3) ? null : new Point3f(f, f2, f3);
    }

    private boolean getTrajectoryStep(Point3f[] point3fArray, boolean bl) throws Exception {
        int n = point3fArray.length;
        int n2 = -1;
        for (int i = 0; i < this.templateAtomCount; ++i) {
            Point3f point3f = this.getPoint();
            if (point3f == null) {
                return false;
            }
            if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
            if (++n2 == n) {
                return false;
            }
            point3fArray[n2] = point3f;
        }
        if (bl) {
            this.getPoint();
        }
        return this.line != null;
    }

    private boolean skipFloats(int n) throws Exception {
        for (int i = 0; i < n && this.readLine() != null; i += this.getTokens().length) {
        }
        return this.line != null;
    }
}

