/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import org.jmol.util.BoxInfo;
import org.jmol.util.Quadric;
import org.jmol.util.SimpleUnitCell;

class UnitCell
extends SimpleUnitCell {
    private Point3f[] vertices;
    private Point3f cartesianOffset = new Point3f();
    private Point3f fractionalOffset = new Point3f();
    private boolean allFractionalRelative = false;
    private Point3f unitCellMultiplier = null;
    private static final double twoP2 = 19.739208802178716;

    UnitCell(float[] fArray) {
        super(fArray);
        this.calcUnitcellVertices();
    }

    void setOrientation(Matrix3f matrix3f) {
        if (matrix3f == null) {
            return;
        }
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.set(matrix3f);
        this.matrixFractionalToCartesian.mul(matrix4f, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.invert(this.matrixFractionalToCartesian);
        this.calcUnitcellVertices();
    }

    final void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (point3f2 == null) {
            this.matrixCartesianToFractional.transform(point3f);
            switch (this.dimension) {
                case 3: {
                    point3f.z = UnitCell.toFractional(point3f.z);
                }
                case 2: {
                    point3f.y = UnitCell.toFractional(point3f.y);
                }
                case 1: {
                    point3f.x = UnitCell.toFractional(point3f.x);
                }
            }
            this.matrixFractionalToCartesian.transform(point3f);
        } else {
            this.matrixCtoFAbsolute.transform(point3f);
            switch (this.dimension) {
                case 3: {
                    point3f.z = UnitCell.toFractional(point3f.z);
                }
                case 2: {
                    point3f.y = UnitCell.toFractional(point3f.y);
                }
                case 1: {
                    point3f.x = UnitCell.toFractional(point3f.x);
                }
            }
            point3f.add((Tuple3f)point3f2);
            this.matrixFtoCAbsolute.transform(point3f);
        }
    }

    void setAllFractionalRelative(boolean bl) {
        this.allFractionalRelative = bl;
    }

    void setOffset(Point3f point3f) {
        if (point3f == null) {
            return;
        }
        if (point3f.x >= 100.0f || point3f.y >= 100.0f) {
            this.unitCellMultiplier = new Point3f(point3f);
            return;
        }
        if (point3f.x == 0.0f && point3f.y == 0.0f && point3f.z == 0.0f) {
            this.unitCellMultiplier = null;
        }
        this.fractionalOffset.set((Tuple3f)point3f);
        this.matrixCartesianToFractional.m03 = -point3f.x;
        this.matrixCartesianToFractional.m13 = -point3f.y;
        this.matrixCartesianToFractional.m23 = -point3f.z;
        this.cartesianOffset.set((Tuple3f)point3f);
        this.matrixFractionalToCartesian.m03 = 0.0f;
        this.matrixFractionalToCartesian.m13 = 0.0f;
        this.matrixFractionalToCartesian.m23 = 0.0f;
        this.matrixFractionalToCartesian.transform(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFAbsolute.set(this.matrixCartesianToFractional);
            this.matrixFtoCAbsolute.set(this.matrixFractionalToCartesian);
        }
    }

    void setOffset(int n) {
        this.setOffset(UnitCell.ijkToPoint3f((int)n));
    }

    void setMinMaxLatticeParameters(Point3i point3i, Point3i point3i2) {
        if (point3i2.x <= 555 && point3i2.y >= 555) {
            Point3f point3f = new Point3f();
            UnitCell.ijkToPoint3f((int)point3i2.x, (Point3f)point3f, (int)0);
            point3i.x = (int)point3f.x;
            point3i.y = (int)point3f.y;
            point3i.z = (int)point3f.z;
            UnitCell.ijkToPoint3f((int)point3i2.y, (Point3f)point3f, (int)1);
            point3i2.x = (int)point3f.x;
            point3i2.y = (int)point3f.y;
            point3i2.z = (int)point3f.z;
        }
        switch (this.dimension) {
            case 1: {
                point3i.y = 0;
                point3i2.y = 1;
            }
            case 2: {
                point3i.z = 0;
                point3i2.z = 1;
            }
        }
    }

    final String dumpInfo(boolean bl) {
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + (bl ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    Point3f[] getVertices() {
        return this.vertices;
    }

    Point3f getCartesianOffset() {
        return this.cartesianOffset;
    }

    Point3f getFractionalOffset() {
        return this.fractionalOffset;
    }

    Quadric getEllipsoid(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray[0] == 0.0f) {
            float[] fArray2 = new float[3];
            fArray2[1] = fArray2[2] = (float)Math.sqrt(fArray[7]);
            fArray2[0] = fArray2[2];
            return new Quadric(null, fArray2, true);
        }
        double[] dArray = new double[6];
        int n = (int)fArray[6];
        if (n == 12) {
            dArray[0] = (double)fArray[0] * 19.739208802178716;
            dArray[1] = (double)fArray[1] * 19.739208802178716;
            dArray[2] = (double)fArray[2] * 19.739208802178716;
            dArray[3] = (double)fArray[3] * 19.739208802178716 * 2.0;
            dArray[4] = (double)fArray[4] * 19.739208802178716 * 2.0;
            dArray[5] = (double)fArray[5] * 19.739208802178716 * 2.0;
            fArray[7] = (fArray[0] + fArray[1] + fArray[3]) / 3.0f;
        } else {
            boolean bl = n == 4 || n == 5 || n == 8 || n == 9;
            double d = 2 - n % 2;
            double d2 = n == 8 || n == 9 || n == 10 ? 19.739208802178716 : (n == 4 || n == 5 ? 0.25 : (n == 2 || n == 3 ? Math.log(2.0) : 1.0));
            double d3 = (double)fArray[0] * d2 * (bl ? this.a_ * this.a_ : 1.0);
            double d4 = (double)fArray[1] * d2 * (bl ? this.b_ * this.b_ : 1.0);
            double d5 = (double)fArray[2] * d2 * (bl ? this.c_ * this.c_ : 1.0);
            double d6 = (double)fArray[3] * d2 * (bl ? this.a_ * this.b_ : 1.0) * d;
            double d7 = (double)fArray[4] * d2 * (bl ? this.a_ * this.c_ : 1.0) * d;
            double d8 = (double)fArray[5] * d2 * (bl ? this.b_ * this.c_ : 1.0) * d;
            fArray[7] = (float)Math.pow(d3 / 19.739208802178716 / this.a_ / this.a_ * d4 / 19.739208802178716 / this.b_ / this.b_ * d5 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            dArray[0] = (double)(this.a * this.a) * d3 + (double)(this.b * this.b) * this.cosGamma * this.cosGamma * d4 + (double)(this.c * this.c) * this.cosBeta * this.cosBeta * d5 + (double)(this.a * this.b) * this.cosGamma * d6 + (double)(this.b * this.c) * this.cosGamma * this.cosBeta * d8 + (double)(this.a * this.c) * this.cosBeta * d7;
            dArray[1] = (double)(this.b * this.b) * this.sinGamma * this.sinGamma * d4 + (double)(this.c * this.c) * this.cA_ * this.cA_ * d5 + (double)(this.b * this.c) * this.cA_ * this.sinGamma * d8;
            dArray[2] = (double)(this.c * this.c) * this.cB_ * this.cB_ * d5;
            dArray[3] = (double)(2.0f * this.b * this.b) * this.cosGamma * this.sinGamma * d4 + (double)(2.0f * this.c * this.c) * this.cA_ * this.cosBeta * d5 + (double)(this.a * this.b) * this.sinGamma * d6 + (double)(this.b * this.c) * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * d8 + (double)(this.a * this.c) * this.cA_ * d7;
            dArray[4] = (double)(2.0f * this.c * this.c) * this.cB_ * this.cosBeta * d5 + (double)(this.b * this.c) * this.cosGamma * d8 + (double)(this.a * this.c) * this.cB_ * d7;
            dArray[5] = (double)(2.0f * this.c * this.c) * this.cA_ * this.cB_ * d5 + (double)(this.b * this.c) * this.cB_ * this.sinGamma * d8;
        }
        return new Quadric(dArray);
    }

    Point3f[] getCanonicalCopy(float f) {
        Point3f[] point3fArray = new Point3f[8];
        for (int i = 0; i < 8; ++i) {
            point3fArray[i] = new Point3f(BoxInfo.unitCubePoints[i]);
            this.matrixFractionalToCartesian.transform(point3fArray[i]);
        }
        return BoxInfo.getCanonicalCopy((Point3f[])point3fArray, (float)f);
    }

    private static float toFractional(float f) {
        if ((f = (float)((double)f - Math.floor(f))) > 0.9999f || f < 1.0E-4f) {
            f = 0.0f;
        }
        return f;
    }

    private void calcUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFAbsolute = new Matrix4f(this.matrixCartesianToFractional);
        this.matrixFtoCAbsolute = new Matrix4f(this.matrixFractionalToCartesian);
        this.vertices = new Point3f[8];
        int n = 8;
        while (--n >= 0) {
            this.vertices[n] = new Point3f();
            this.matrixFractionalToCartesian.transform(BoxInfo.unitCubePoints[n], this.vertices[n]);
        }
    }

    public boolean checkDistance(Point3f point3f, Point3f point3f2, float f, float f2, int n, int n2, int n3, Point3f point3f3) {
        Point3f point3f4 = new Point3f(point3f);
        this.toCartesian(point3f4, true);
        for (int i = -n; i <= n; ++i) {
            for (int j = -n2; j <= n2; ++j) {
                for (int k = -n3; k <= n3; ++k) {
                    point3f3.set(point3f2.x + (float)i, point3f2.y + (float)j, point3f2.z + (float)k);
                    this.toCartesian(point3f3, true);
                    float f3 = point3f4.distance(point3f3);
                    if (!(f2 > 0.0f ? Math.abs(f3 - f) <= f2 : f3 <= f && f3 > 0.1f)) continue;
                    point3f3.set((float)i, (float)j, (float)k);
                    return true;
                }
            }
        }
        return false;
    }

    public Point3f getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }
}

