/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TriangleData;

class SymmetryOperation
extends Matrix4f {
    String xyzOriginal;
    String xyz;
    boolean doNormalize = true;
    boolean isFinalized;
    int opId;
    private Point3f temp3 = new Point3f();
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
    Point3f atomTest = new Point3f();

    SymmetryOperation() {
    }

    SymmetryOperation(boolean bl, int n) {
        this.doNormalize = bl;
        this.opId = n;
    }

    SymmetryOperation(SymmetryOperation symmetryOperation, Point3f[] point3fArray, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.set(symmetryOperation);
        this.doFinalize();
        if (bl) {
            this.setOffset(point3fArray, n, n2);
        }
    }

    void doFinalize() {
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        this.isFinalized = true;
    }

    String getXyz(boolean bl) {
        return bl || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    void newPoint(Point3f point3f, Point3f point3f2, int n, int n2, int n3) {
        this.temp3.set((Tuple3f)point3f);
        this.transform(this.temp3, this.temp3);
        point3f2.set(this.temp3.x + (float)n, this.temp3.y + (float)n2, this.temp3.z + (float)n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(Matrix4f matrix4f) {
        return new StringBuffer("{\t").append((int)matrix4f.m00).append("\t").append((int)matrix4f.m01).append("\t").append((int)matrix4f.m02).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m03)).append("\t}\n").append("{\t").append((int)matrix4f.m10).append("\t").append((int)matrix4f.m11).append("\t").append((int)matrix4f.m12).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m13)).append("\t}\n").append("{\t").append((int)matrix4f.m20).append("\t").append((int)matrix4f.m21).append("\t").append((int)matrix4f.m22).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m23)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    static final String dumpCanonicalSeitz(Matrix4f matrix4f) {
        return new StringBuffer().append("{\t").append((int)matrix4f.m00).append("\t").append((int)matrix4f.m01).append("\t").append((int)matrix4f.m02).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m03 + 12.0f)).append("\t}\n").append("{\t").append((int)matrix4f.m10).append("\t").append((int)matrix4f.m11).append("\t").append((int)matrix4f.m12).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m13 + 12.0f)).append("\t}\n").append("{\t").append((int)matrix4f.m20).append("\t").append((int)matrix4f.m21).append("\t").append((int)matrix4f.m22).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m23 + 12.0f)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    boolean setMatrixFromXYZ(String string) {
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        float[] fArray = new float[16];
        boolean bl = string.startsWith("!");
        if (bl) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])fArray);
            for (int i = 0; i < 16; ++i) {
                if (Float.isNaN(fArray[i])) {
                    return false;
                }
                float f = fArray[i];
                if (Math.abs(f) < 1.0E-5f) {
                    f = 0.0f;
                }
                if (i % 4 == 3) {
                    f = SymmetryOperation.normalizeTwelfths((f < 0.0f ? -1 : 1) * Math.round(Math.abs(f * 12.0f)), this.doNormalize);
                }
                fArray[i] = f;
            }
            fArray[15] = 1.0f;
            this.set(fArray);
            this.isFinalized = true;
            if (bl) {
                this.invert(this);
            }
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
            return true;
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray((String)string, null, (float[])fArray);
            for (int i = 0; i < 16; ++i) {
                if (!Float.isNaN(fArray[i])) continue;
                return false;
            }
            this.set(fArray);
            this.isFinalized = true;
            if (bl) {
                this.invert(this);
            }
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        String string2 = SymmetryOperation.getMatrixFromString(string, fArray, this.doNormalize, false);
        if (string2 == null) {
            return false;
        }
        this.set(fArray);
        if (bl) {
            this.invert(this);
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        } else {
            this.xyz = string2;
        }
        if (Logger.debugging) {
            Logger.debug((String)("" + (Object)((Object)this)));
        }
        return true;
    }

    static String getMatrixFromString(String string, float[] fArray, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        String string2 = "";
        int n4 = -1;
        float f2 = 1.0f;
        string = string + ",";
        block12: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block12;
                }
                case '-': {
                    bl5 = true;
                    continue block12;
                }
                case '+': {
                    bl5 = false;
                    continue block12;
                }
                case '/': {
                    bl3 = true;
                    continue block12;
                }
                case 'X': 
                case 'x': {
                    int n5 = n = bl5 ? -1 : 1;
                    if (!bl2 || f == 0.0f) break;
                    n = (int)((float)n * f);
                    f = 0.0f;
                    break;
                }
                case 'Y': 
                case 'y': {
                    int n6 = n2 = bl5 ? -1 : 1;
                    if (!bl2 || f == 0.0f) break;
                    n2 = (int)((float)n2 * f);
                    f = 0.0f;
                    break;
                }
                case 'Z': 
                case 'z': {
                    int n7 = n3 = bl5 ? -1 : 1;
                    if (!bl2 || f == 0.0f) break;
                    n3 = (int)((float)n3 * f);
                    f = 0.0f;
                    break;
                }
                case ',': {
                    if (++n4 > 2) {
                        Logger.warn((String)("Symmetry Operation? " + string));
                        return null;
                    }
                    int n8 = n4 * 4;
                    f = SymmetryOperation.normalizeTwelfths(f, bl);
                    fArray[n8++] = n;
                    fArray[n8++] = n2;
                    fArray[n8++] = n3;
                    fArray[n8] = f;
                    String string3 = "";
                    string3 = string3 + (n == 0 ? "" : (n < 0 ? "-x" : (string3.length() == 0 ? "x" : "+x")));
                    string3 = string3 + (n2 == 0 ? "" : (n2 < 0 ? "-y" : (string3.length() == 0 ? "y" : "+y")));
                    string3 = string3 + (n3 == 0 ? "" : (n3 < 0 ? "-z" : (string3.length() == 0 ? "z" : "+z")));
                    string3 = string3 + SymmetryOperation.xyzFraction(f, false, true);
                    string2 = string2 + (string2 == "" ? "" : ",") + string3;
                    if (n4 == 2) {
                        fArray[15] = 1.0f;
                        return string2;
                    }
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    f = 0.0f;
                    break;
                }
                case '.': {
                    bl4 = true;
                    f2 = 1.0f;
                    continue block12;
                }
                case '0': {
                    if (!bl4 && (bl3 || !bl2)) continue block12;
                }
                default: {
                    int n9 = c - 48;
                    if (bl4 && n9 >= 0 && n9 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl5 = true;
                        }
                        f += f2 * (float)n9 * (float)(bl5 ? -1 : 1);
                        continue block12;
                    }
                    if (n9 >= 0 && n9 <= 9) {
                        if (bl3) {
                            f /= (float)n9;
                            break;
                        }
                        f = f * 10.0f + (float)((bl5 ? -1 : 1) * n9);
                        bl5 = false;
                        break;
                    }
                    Logger.warn((String)("symmetry character?" + c));
                }
            }
            bl5 = false;
            bl3 = false;
            bl4 = false;
        }
        return null;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    static final String getXYZFromMatrix(Matrix4f matrix4f, boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            matrix4f.getRow(i, fArray);
            String string2 = "";
            if (fArray[0] != 0.0f) {
                string2 = string2 + (fArray[0] < 0.0f ? "-" : "+") + "x";
            }
            if (fArray[1] != 0.0f) {
                string2 = string2 + (fArray[1] < 0.0f ? "-" : "+") + "y";
            }
            if (fArray[2] != 0.0f) {
                string2 = string2 + (fArray[2] < 0.0f ? "-" : "+") + "z";
            }
            if ((string2 = string2 + SymmetryOperation.xyzFraction(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3)).length() > 0 && string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private static final String twelfthsOf(float f) {
        int n;
        String string = "";
        int n2 = Math.round(f);
        if (n2 == 12) {
            return "1";
        }
        if (n2 == -12) {
            return "-1";
        }
        if (n2 < 0 && (n2 = -n2) % 12 != 0) {
            string = "-";
        }
        if ((n = n2 / 12) < 1) {
            return string + twelfths[n2 % 12];
        }
        int n3 = 0;
        switch (n2 % 12) {
            case 0: {
                return string + n;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                n3 = 12;
                break;
            }
            case 2: 
            case 10: {
                n3 = 6;
                break;
            }
            case 3: 
            case 9: {
                n3 = 4;
                break;
            }
            case 4: 
            case 8: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
            }
        }
        return string + n2 * n3 / 12 + "/" + n3;
    }

    private static final String xyzFraction(float f, boolean bl, boolean bl2) {
        String string;
        if (bl) {
            for (f = (float)Math.round(f); f < 0.0f; f += 12.0f) {
            }
        } else if (bl2 && f > 6.0f) {
            f -= 12.0f;
        }
        return (string = SymmetryOperation.twelfthsOf(f)).charAt(0) == '0' ? "" : (f > 0.0f ? "+" + string : string);
    }

    private void setOffset(Point3f[] point3fArray, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = n3; i < n4; ++i) {
            this.newPoint(point3fArray[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    private void transformCartesian(UnitCell unitCell, Point3f point3f) {
        unitCell.toFractional(point3f, false);
        this.transform(point3f);
        unitCell.toCartesian(point3f, false);
    }

    Vector3f[] rotateEllipsoid(Point3f point3f, Vector3f[] vector3fArray, UnitCell unitCell, Point3f point3f2, Point3f point3f3) {
        Vector3f[] vector3fArray2 = new Vector3f[3];
        point3f3.set((Tuple3f)point3f);
        this.transformCartesian(unitCell, point3f3);
        int n = vector3fArray.length;
        while (--n >= 0) {
            point3f2.set((Tuple3f)point3f);
            point3f2.add((Tuple3f)vector3fArray[n]);
            this.transformCartesian(unitCell, point3f2);
            vector3fArray2[n] = new Vector3f((Tuple3f)point3f2);
            vector3fArray2[n].sub((Tuple3f)point3f3);
        }
        return vector3fArray2;
    }

    public Object[] getDescription(SymmetryInterface symmetryInterface, Point3f point3f, Point3f point3f2, String string) {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        return SymmetryOperation.getDescription(this, this.xyzOriginal, symmetryInterface, point3f, point3f2, string);
    }

    private static Object[] getDescription(SymmetryOperation symmetryOperation, String string, SymmetryInterface symmetryInterface, Point3f point3f, Point3f point3f2, String string2) {
        float f;
        float f2;
        String string3;
        boolean bl;
        boolean bl2;
        Vector3f vector3f = new Vector3f();
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        Point3f point3f5 = new Point3f();
        Point3f point3f6 = new Point3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        String string4 = SymmetryOperation.getXYZFromMatrix(symmetryOperation, false, false, false);
        boolean bl3 = bl2 = string2 == null;
        if (point3f == null || Float.isNaN(point3f.x)) {
            point3f = new Point3f();
        }
        if (point3f2 != null) {
            point3f4.set((Tuple3f)point3f);
            point3f5.set((Tuple3f)point3f2);
            symmetryInterface.toUnitCell(point3f4, point3f3);
            symmetryInterface.toUnitCell(point3f5, point3f3);
            symmetryInterface.toFractional(point3f4, false);
            symmetryOperation.transform(point3f4);
            symmetryInterface.toCartesian(point3f4, false);
            symmetryInterface.toUnitCell(point3f4, point3f3);
            if (point3f4.distance(point3f5) > 0.1f) {
                return null;
            }
            point3f4.set((Tuple3f)point3f);
            point3f5.set((Tuple3f)point3f2);
            symmetryInterface.toFractional(point3f4, false);
            symmetryInterface.toFractional(point3f5, false);
            symmetryOperation.transform(point3f4);
            vector3f3.sub((Tuple3f)point3f5, (Tuple3f)point3f4);
            point3f4.set(0.0f, 0.0f, 0.0f);
            point3f5.set(0.0f, 0.0f, 0.0f);
        }
        point3f6.z = 1.0f;
        point3f5.y = 1.0f;
        point3f4.x = 1.0f;
        point3f4.add((Tuple3f)point3f);
        point3f5.add((Tuple3f)point3f);
        point3f6.add((Tuple3f)point3f);
        Point3f point3f7 = new Point3f(point3f);
        Point3f point3f8 = new Point3f(point3f4);
        Point3f point3f9 = new Point3f(point3f5);
        Point3f point3f10 = new Point3f(point3f6);
        symmetryInterface.toFractional(point3f7, false);
        symmetryInterface.toFractional(point3f8, false);
        symmetryInterface.toFractional(point3f9, false);
        symmetryInterface.toFractional(point3f10, false);
        symmetryOperation.transform(point3f7, point3f7);
        symmetryOperation.transform(point3f8, point3f8);
        symmetryOperation.transform(point3f9, point3f9);
        symmetryOperation.transform(point3f10, point3f10);
        point3f7.add((Tuple3f)vector3f3);
        point3f8.add((Tuple3f)vector3f3);
        point3f9.add((Tuple3f)vector3f3);
        point3f10.add((Tuple3f)vector3f3);
        SymmetryOperation.approx((Tuple3f)vector3f3);
        symmetryInterface.toCartesian(point3f7, false);
        symmetryInterface.toCartesian(point3f8, false);
        symmetryInterface.toCartesian(point3f9, false);
        symmetryInterface.toCartesian(point3f10, false);
        Vector3f vector3f4 = new Vector3f();
        vector3f4.sub((Tuple3f)point3f8, (Tuple3f)point3f7);
        Vector3f vector3f5 = new Vector3f();
        vector3f5.sub((Tuple3f)point3f9, (Tuple3f)point3f7);
        Vector3f vector3f6 = new Vector3f();
        vector3f6.sub((Tuple3f)point3f10, (Tuple3f)point3f7);
        vector3f.cross(vector3f4, vector3f5);
        boolean bl4 = bl = vector3f.dot(vector3f6) < 0.0f;
        if (bl) {
            point3f8.scaleAdd(-2.0f, (Tuple3f)vector3f4, (Tuple3f)point3f8);
            point3f9.scaleAdd(-2.0f, (Tuple3f)vector3f5, (Tuple3f)point3f9);
            point3f10.scaleAdd(-2.0f, (Tuple3f)vector3f6, (Tuple3f)point3f10);
        }
        Object[] objectArray = (Object[])Measure.computeHelicalAxis(null, (int)135266306, (Point3f)point3f, (Point3f)point3f7, (Quaternion)Quaternion.getQuaternionFrame((Point3f)point3f7, (Tuple3f)point3f8, (Tuple3f)point3f9).div(Quaternion.getQuaternionFrame((Point3f)point3f, (Tuple3f)point3f4, (Tuple3f)point3f5)));
        Point3f point3f11 = (Point3f)objectArray[0];
        Vector3f vector3f7 = (Vector3f)objectArray[1];
        int n = (int)Math.abs(SymmetryOperation.approx(((Point3f)objectArray[3]).x, 1.0f));
        float f3 = SymmetryOperation.approx(((Point3f)objectArray[3]).y);
        if (bl) {
            point3f8.scaleAdd(2.0f, (Tuple3f)vector3f4, (Tuple3f)point3f8);
            point3f9.scaleAdd(2.0f, (Tuple3f)vector3f5, (Tuple3f)point3f9);
            point3f10.scaleAdd(2.0f, (Tuple3f)vector3f6, (Tuple3f)point3f10);
        }
        Vector3f vector3f8 = new Vector3f((Tuple3f)point3f7);
        vector3f8.sub((Tuple3f)point3f);
        if (vector3f8.length() < 0.1f) {
            vector3f8 = null;
        }
        Point3f point3f12 = null;
        Point3f point3f13 = null;
        Point3f point3f14 = null;
        boolean bl5 = n == 0;
        boolean bl6 = !bl5;
        boolean bl7 = false;
        boolean bl8 = false;
        if (bl6 || bl) {
            vector3f8 = null;
        }
        if (bl && bl5) {
            point3f13 = new Point3f(point3f);
            point3f13.add((Tuple3f)point3f7);
            point3f13.scale(0.5f);
            point3f12 = point3f7;
            bl7 = true;
        } else if (bl) {
            Vector3f vector3f9 = f3 == 0.0f ? new Vector3f() : vector3f7;
            float f4 = 0.0f;
            switch (n) {
                case 60: {
                    f4 = 0.6666667f;
                    break;
                }
                case 120: {
                    f4 = 2.0f;
                    break;
                }
                case 90: {
                    f4 = 1.0f;
                    break;
                }
                case 180: {
                    point3f14 = new Point3f();
                    point3f14.set((Tuple3f)point3f);
                    point3f14.add((Tuple3f)vector3f9);
                    point3f11.scaleAdd(0.5f, (Tuple3f)vector3f9, (Tuple3f)point3f);
                    if (point3f14.distance(point3f7) > 0.1f) {
                        vector3f8 = new Vector3f((Tuple3f)point3f7);
                        vector3f8.sub((Tuple3f)point3f14);
                        point3f3.set((Tuple3f)vector3f8);
                        symmetryInterface.toFractional(point3f3, false);
                        vector3f2.set((Tuple3f)point3f3);
                    } else {
                        vector3f8 = null;
                    }
                    bl6 = false;
                    bl = false;
                    bl8 = true;
                }
            }
            if (f4 != 0.0f) {
                vector3f.set((Tuple3f)point3f);
                vector3f.sub((Tuple3f)point3f11);
                vector3f.add((Tuple3f)point3f7);
                vector3f.sub((Tuple3f)point3f11);
                vector3f.sub((Tuple3f)vector3f9);
                vector3f.scale(f4);
                point3f11.add((Tuple3f)vector3f);
                point3f13 = new Point3f();
                point3f13.scaleAdd(0.5f, (Tuple3f)vector3f9, (Tuple3f)point3f11);
                point3f12 = new Point3f();
                point3f12.scaleAdd(-2.0f, (Tuple3f)point3f13, (Tuple3f)point3f);
                point3f12.scale(-1.0f);
            }
        } else if (vector3f8 != null) {
            point3f3.set((Tuple3f)vector3f8);
            symmetryInterface.toFractional(point3f3, false);
            if (SymmetryOperation.approx(point3f3.x) == 1.0f) {
                point3f3.x = 0.0f;
            }
            if (SymmetryOperation.approx(point3f3.y) == 1.0f) {
                point3f3.y = 0.0f;
            }
            if (SymmetryOperation.approx(point3f3.z) == 1.0f) {
                point3f3.z = 0.0f;
            }
            vector3f2.set((Tuple3f)point3f3);
            symmetryInterface.toCartesian(point3f3, false);
            vector3f8.set((Tuple3f)point3f3);
        }
        int n2 = n;
        SymmetryOperation.approx0((Tuple3f)vector3f7);
        if (bl6) {
            Point3f point3f15 = new Point3f();
            vector3f.set((Tuple3f)vector3f7);
            int n3 = n;
            if (bl) {
                point3f15.set((Tuple3f)point3f11);
                point3f15.add((Tuple3f)vector3f);
                n3 = (int)Measure.computeTorsion((Tuple3f)point3f12, (Tuple3f)point3f11, (Tuple3f)point3f15, (Tuple3f)point3f7, (boolean)true);
            } else if (f3 == 0.0f) {
                point3f15.set((Tuple3f)point3f11);
                point3f3.scaleAdd(1.0f, (Tuple3f)point3f15, (Tuple3f)vector3f);
                n3 = (int)Measure.computeTorsion((Tuple3f)point3f, (Tuple3f)point3f11, (Tuple3f)point3f3, (Tuple3f)point3f7, (boolean)true);
            } else {
                point3f3.set((Tuple3f)point3f11);
                point3f3.add((Tuple3f)vector3f);
                point3f15.scaleAdd(0.5f, (Tuple3f)vector3f, (Tuple3f)point3f11);
                n3 = (int)Measure.computeTorsion((Tuple3f)point3f, (Tuple3f)point3f11, (Tuple3f)point3f3, (Tuple3f)point3f7, (boolean)true);
            }
            if (n3 != 0) {
                n = n3;
            }
        }
        if (bl6 && !bl && f3 == 0.0f && (vector3f7.z < 0.0f || vector3f7.z == 0.0f && (vector3f7.y < 0.0f || vector3f7.y == 0.0f && vector3f7.x < 0.0f))) {
            vector3f7.scale(-1.0f);
            n = -n;
        }
        String string5 = "identity";
        StringBuffer stringBuffer = new StringBuffer();
        if (bl7) {
            point3f3.set((Tuple3f)point3f13);
            symmetryInterface.toFractional(point3f3, false);
            string5 = "inversion center|" + SymmetryOperation.fcoord((Tuple3f)point3f3);
        } else if (bl6) {
            if (bl) {
                string5 = "" + 360 / n2 + "-bar axis";
            } else if (f3 != 0.0f) {
                string5 = "" + 360 / n2 + "-fold screw axis";
                point3f3.set((Tuple3f)vector3f7);
                symmetryInterface.toFractional(point3f3, false);
                string5 = string5 + "|translation: " + SymmetryOperation.fcoord((Tuple3f)point3f3);
            } else {
                string5 = "C" + 360 / n2 + " axis";
            }
        } else if (vector3f8 != null) {
            string3 = " " + SymmetryOperation.fcoord((Tuple3f)vector3f2);
            if (bl5) {
                string5 = "translation:" + string3;
            } else if (bl8) {
                float f5 = SymmetryOperation.approx(vector3f2.x);
                f2 = SymmetryOperation.approx(vector3f2.y);
                f = SymmetryOperation.approx(vector3f2.z);
                string3 = " " + SymmetryOperation.fcoord((Tuple3f)vector3f2);
                string5 = f5 != 0.0f && f2 != 0.0f && f != 0.0f ? "d-" : (f5 != 0.0f && f2 != 0.0f || f2 != 0.0f && f != 0.0f || f != 0.0f && f5 != 0.0f ? "n-" : (f5 != 0.0f ? "a-" : (f2 != 0.0f ? "b-" : "c-")));
                string5 = string5 + "glide plane |translation:" + string3;
            }
        } else if (bl8) {
            string5 = "mirror plane";
        }
        if (bl && !bl7) {
            point3f3.set((Tuple3f)point3f13);
            symmetryInterface.toFractional(point3f3, false);
            string5 = string5 + "|inversion center at " + SymmetryOperation.fcoord((Tuple3f)point3f3);
        }
        string3 = null;
        if (!bl2) {
            String string6 = "\ndraw ID " + string2 + "_";
            stringBuffer = new StringBuffer();
            stringBuffer.append("// " + string + "|" + string4 + "|" + string5 + "\n");
            stringBuffer.append(string6).append("* delete");
            SymmetryOperation.drawLine(stringBuffer, string6 + "frame1X", 0.15f, point3f, point3f4, "red");
            SymmetryOperation.drawLine(stringBuffer, string6 + "frame1Y", 0.15f, point3f, point3f5, "green");
            SymmetryOperation.drawLine(stringBuffer, string6 + "frame1Z", 0.15f, point3f, point3f6, "blue");
            point3f3.set((Tuple3f)point3f8);
            point3f3.sub((Tuple3f)point3f7);
            point3f3.scaleAdd(0.9f, (Tuple3f)point3f3, (Tuple3f)point3f7);
            SymmetryOperation.drawLine(stringBuffer, string6 + "frame2X", 0.2f, point3f7, point3f3, "red");
            point3f3.set((Tuple3f)point3f9);
            point3f3.sub((Tuple3f)point3f7);
            point3f3.scaleAdd(0.9f, (Tuple3f)point3f3, (Tuple3f)point3f7);
            SymmetryOperation.drawLine(stringBuffer, string6 + "frame2Y", 0.2f, point3f7, point3f3, "green");
            point3f3.set((Tuple3f)point3f10);
            point3f3.sub((Tuple3f)point3f7);
            point3f3.scaleAdd(0.9f, (Tuple3f)point3f3, (Tuple3f)point3f7);
            SymmetryOperation.drawLine(stringBuffer, string6 + "frame2Z", 0.2f, point3f7, point3f3, "purple");
            if (bl6) {
                Point3f point3f16 = new Point3f();
                String string7 = "red";
                n2 = n;
                f = 1.0f;
                vector3f.set((Tuple3f)vector3f7);
                if (bl) {
                    point3f16.set((Tuple3f)point3f11);
                    point3f16.add((Tuple3f)vector3f);
                    if (f3 == 0.0f) {
                        point3f16.set((Tuple3f)point3f13);
                        vector3f.scale(3.0f);
                        point3f3.scaleAdd(-1.0f, (Tuple3f)vector3f, (Tuple3f)point3f11);
                        stringBuffer.append(string6).append("rotVector2 diameter 0.1 ").append(Escape.escape((Tuple3f)point3f11)).append(Escape.escape((Tuple3f)point3f3)).append(" color red");
                    }
                    f = point3f7.distance(point3f16);
                    stringBuffer.append(string6).append("rotLine1 ").append(Escape.escape((Tuple3f)point3f16)).append(Escape.escape((Tuple3f)point3f12)).append(" color red");
                    stringBuffer.append(string6).append("rotLine2 ").append(Escape.escape((Tuple3f)point3f16)).append(Escape.escape((Tuple3f)point3f7)).append(" color red");
                } else if (f3 == 0.0f) {
                    boolean bl9;
                    boolean bl10 = bl9 = point3f.distance(point3f7) < 0.2f;
                    if (!bl9) {
                        stringBuffer.append(string6).append("rotLine1 ").append(Escape.escape((Tuple3f)point3f)).append(Escape.escape((Tuple3f)point3f11)).append(" color red");
                        stringBuffer.append(string6).append("rotLine2 ").append(Escape.escape((Tuple3f)point3f7)).append(Escape.escape((Tuple3f)point3f11)).append(" color red");
                    }
                    vector3f.scale(3.0f);
                    point3f3.scaleAdd(-1.0f, (Tuple3f)vector3f, (Tuple3f)point3f11);
                    stringBuffer.append(string6).append("rotVector2 diameter 0.1 ").append(Escape.escape((Tuple3f)point3f11)).append(Escape.escape((Tuple3f)point3f3)).append(" color red");
                    point3f16.set((Tuple3f)point3f11);
                    if (f3 == 0.0f && (double)point3f.distance(point3f7) < 0.2) {
                        point3f16.scaleAdd(0.5f, (Tuple3f)point3f16, (Tuple3f)vector3f);
                    }
                } else {
                    string7 = "orange";
                    stringBuffer.append(string6).append("rotLine1 ").append(Escape.escape((Tuple3f)point3f)).append(Escape.escape((Tuple3f)point3f11)).append(" color red");
                    point3f3.set((Tuple3f)point3f11);
                    point3f3.add((Tuple3f)vector3f);
                    stringBuffer.append(string6).append("rotLine2 ").append(Escape.escape((Tuple3f)point3f7)).append(Escape.escape((Tuple3f)point3f3)).append(" color red");
                    point3f16.scaleAdd(0.5f, (Tuple3f)vector3f, (Tuple3f)point3f11);
                }
                point3f3.set((Tuple3f)point3f16);
                point3f3.add((Tuple3f)vector3f);
                if (bl && f3 != 0.0f) {
                    stringBuffer.append(string6).append("rotRotLine1").append(Escape.escape((Tuple3f)point3f16)).append(Escape.escape((Tuple3f)point3f12)).append(" color red");
                    stringBuffer.append(string6).append("rotRotLine2").append(Escape.escape((Tuple3f)point3f16)).append(Escape.escape((Tuple3f)point3f7)).append(" color red");
                }
                stringBuffer.append(string6).append("rotRotArrow arrow width 0.10 scale " + f + " arc ").append(Escape.escape((Tuple3f)point3f16)).append(Escape.escape((Tuple3f)point3f3));
                if (bl) {
                    point3f3.set((Tuple3f)point3f12);
                } else {
                    point3f3.set((Tuple3f)point3f);
                }
                if (point3f3.distance(point3f7) < 0.1f) {
                    point3f3.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                stringBuffer.append(Escape.escape((Tuple3f)point3f3));
                point3f3.set(0.0f, (float)n2, 0.0f);
                stringBuffer.append(Escape.escape((Tuple3f)point3f3)).append(" color red");
                stringBuffer.append(string6).append("rotVector1 vector diameter 0.1 ").append(Escape.escape((Tuple3f)point3f11)).append(Escape.escape((Tuple3f)vector3f)).append("color ").append(string7);
            }
            if (bl8) {
                if ((double)point3f.distance(point3f14) > 0.2) {
                    stringBuffer.append(string6).append("planeVector arrow ").append(Escape.escape((Tuple3f)point3f)).append(Escape.escape((Tuple3f)point3f14)).append(" color indigo");
                }
                if (vector3f8 != null) {
                    point3f3.scaleAdd(-1.0f, (Tuple3f)point3f7, (Tuple3f)point3f8);
                    point3f3.add((Tuple3f)point3f14);
                    SymmetryOperation.drawLine(stringBuffer, string6 + "planeFrameX", 0.15f, point3f14, point3f3, "translucent red");
                    point3f3.scaleAdd(-1.0f, (Tuple3f)point3f7, (Tuple3f)point3f9);
                    point3f3.add((Tuple3f)point3f14);
                    SymmetryOperation.drawLine(stringBuffer, string6 + "planeFrameY", 0.15f, point3f14, point3f3, "translucent green");
                    point3f3.scaleAdd(-1.0f, (Tuple3f)point3f7, (Tuple3f)point3f10);
                    point3f3.add((Tuple3f)point3f14);
                    SymmetryOperation.drawLine(stringBuffer, string6 + "planeFrameZ", 0.15f, point3f14, point3f3, "translucent blue");
                }
                String string8 = vector3f8 == null ? "green" : "blue";
                vector3f.set((Tuple3f)vector3f7);
                vector3f.normalize();
                f2 = -vector3f.x * point3f11.x - vector3f.y * point3f11.y - vector3f.z * point3f11.z;
                Point4f point4f = new Point4f(vector3f.x, vector3f.y, vector3f.z, f2);
                ArrayList<Point3f[]> arrayList = new ArrayList<Point3f[]>();
                arrayList.add(symmetryInterface.getCanonicalCopy(1.05f));
                TriangleData.intersectPlane((Point4f)point4f, arrayList, (int)3);
                if (arrayList != null) {
                    int n4 = arrayList.size();
                    while (--n4 >= 0) {
                        Point3f[] point3fArray = (Point3f[])arrayList.get(n4);
                        stringBuffer.append(string6).append("planep").append(n4).append(Escape.escape((Tuple3f)point3fArray[0])).append(Escape.escape((Tuple3f)point3fArray[1]));
                        if (point3fArray.length == 3) {
                            stringBuffer.append(Escape.escape((Tuple3f)point3fArray[2]));
                        }
                        stringBuffer.append(" color translucent ").append(string8);
                    }
                }
                if (arrayList == null || arrayList.size() == 0) {
                    point3f3.set((Tuple3f)point3f11);
                    point3f3.add((Tuple3f)vector3f7);
                    stringBuffer.append(string6).append("planeCircle scale 2.0 circle ").append(Escape.escape((Tuple3f)point3f11)).append(Escape.escape((Tuple3f)point3f3)).append(" color translucent ").append(string8).append(" mesh fill");
                }
            }
            if (bl) {
                stringBuffer.append(string6).append("invPoint diameter 0.4 ").append(Escape.escape((Tuple3f)point3f13));
                stringBuffer.append(string6).append("invArrow arrow ").append(Escape.escape((Tuple3f)point3f)).append(Escape.escape((Tuple3f)point3f12)).append(" color indigo");
                if (!bl7) {
                    point3f3.set((Tuple3f)point3f12);
                    point3f3.add((Tuple3f)point3f);
                    point3f3.sub((Tuple3f)point3f4);
                    SymmetryOperation.drawLine(stringBuffer, string6 + "invFrameX", 0.15f, point3f12, point3f3, "translucent red");
                    point3f3.set((Tuple3f)point3f12);
                    point3f3.add((Tuple3f)point3f);
                    point3f3.sub((Tuple3f)point3f5);
                    SymmetryOperation.drawLine(stringBuffer, string6 + "invFrameY", 0.15f, point3f12, point3f3, "translucent green");
                    point3f3.set((Tuple3f)point3f12);
                    point3f3.add((Tuple3f)point3f);
                    point3f3.sub((Tuple3f)point3f6);
                    SymmetryOperation.drawLine(stringBuffer, string6 + "invFrameZ", 0.15f, point3f12, point3f3, "translucent blue");
                }
            }
            if (vector3f8 != null) {
                if (point3f14 == null) {
                    point3f14 = new Point3f(point3f);
                }
                stringBuffer.append(string6).append("transVector vector ").append(Escape.escape((Tuple3f)point3f14)).append(Escape.escape((Tuple3f)vector3f8));
            }
            stringBuffer.append("\nvar pt00 = " + Escape.escape((Tuple3f)point3f));
            stringBuffer.append("\nvar p0 = " + Escape.escape((Tuple3f)point3f7));
            stringBuffer.append("\nif (within(0.2,p0).length == 0) {");
            stringBuffer.append("\nvar set2 = within(0.2,p0.uxyz.xyz)");
            stringBuffer.append("\nif (set2) {");
            stringBuffer.append(string6).append("cellOffsetVector arrow @p0 @set2 color grey");
            stringBuffer.append(string6).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.escape((Tuple3f)vector3f4)).append("*0.9} color red");
            stringBuffer.append(string6).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.escape((Tuple3f)vector3f5)).append("*0.9} color green");
            stringBuffer.append(string6).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.escape((Tuple3f)vector3f6)).append("*0.9} color purple");
            stringBuffer.append("\n}}\n");
            string3 = stringBuffer.toString();
            stringBuffer = null;
            string6 = null;
        }
        if (vector3f8 == null) {
            vector3f2 = null;
        }
        if (bl6) {
            if (!bl && f3 != 0.0f) {
                vector3f8 = new Vector3f(vector3f7);
                point3f3.set((Tuple3f)vector3f8);
                symmetryInterface.toFractional(point3f3, false);
                vector3f2 = new Vector3f((Tuple3f)point3f3);
            }
            if (!bl || f3 != 0.0f) {
                // empty if block
            }
        }
        if (bl8) {
            if (vector3f8 != null) {
                // empty if block
            }
            n = 0;
        }
        if (bl) {
            if (bl7) {
                point3f11 = null;
                vector3f7 = null;
                vector3f8 = null;
                vector3f2 = null;
            }
        } else if (bl5) {
            point3f11 = null;
            vector3f7 = null;
        }
        if (vector3f7 != null) {
            vector3f7.normalize();
        }
        Matrix4f matrix4f = null;
        if (symmetryOperation != null) {
            matrix4f = new Matrix4f((Matrix4f)symmetryOperation);
            if (vector3f3.length() != 0.0f) {
                matrix4f.m03 += vector3f3.x;
                matrix4f.m13 += vector3f3.y;
                matrix4f.m23 += vector3f3.z;
            }
            string4 = SymmetryOperation.getXYZFromMatrix(matrix4f, false, false, false);
        }
        return new Object[]{string4, string, string5, string3, SymmetryOperation.approx0((Tuple3f)vector3f2), SymmetryOperation.approx0((Tuple3f)vector3f8), SymmetryOperation.approx0((Tuple3f)point3f13), SymmetryOperation.approx0((Tuple3f)point3f11), SymmetryOperation.approx0((Tuple3f)vector3f7), n, matrix4f, vector3f3};
    }

    private static void drawLine(StringBuffer stringBuffer, String string, float f, Point3f point3f, Point3f point3f2, String string2) {
        stringBuffer.append(string).append(" diameter ").append(f).append(Escape.escape((Tuple3f)point3f)).append(Escape.escape((Tuple3f)point3f2)).append(" color ").append(string2);
    }

    static String fcoord(Tuple3f tuple3f) {
        return SymmetryOperation.fc(tuple3f.x) + " " + SymmetryOperation.fc(tuple3f.y) + " " + SymmetryOperation.fc(tuple3f.z);
    }

    private static String fc(float f) {
        String string;
        float f2 = Math.abs(f);
        int n = (int)SymmetryOperation.approx(f2 * 24.0f);
        String string2 = string = f < 0.0f ? "-" : "";
        if (n % 8 != 0) {
            return string + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? string + "1" : string + n / 8 + "/3");
    }

    private static Tuple3f approx0(Tuple3f tuple3f) {
        if (tuple3f != null) {
            if (Math.abs(tuple3f.x) < 1.0E-4f) {
                tuple3f.x = 0.0f;
            }
            if (Math.abs(tuple3f.y) < 1.0E-4f) {
                tuple3f.y = 0.0f;
            }
            if (Math.abs(tuple3f.z) < 1.0E-4f) {
                tuple3f.z = 0.0f;
            }
        }
        return tuple3f;
    }

    private static Tuple3f approx(Tuple3f tuple3f) {
        if (tuple3f != null) {
            tuple3f.x = SymmetryOperation.approx(tuple3f.x);
            tuple3f.y = SymmetryOperation.approx(tuple3f.y);
            tuple3f.z = SymmetryOperation.approx(tuple3f.z);
        }
        return tuple3f;
    }

    private static float approx(float f) {
        return SymmetryOperation.approx(f, 100.0f);
    }

    private static float approx(float f, float f2) {
        return (float)((int)(f * f2 + 0.5f * (float)(f < 0.0f ? -1 : 1))) / f2;
    }

    public static void normalizeTranslation(Matrix4f matrix4f) {
        matrix4f.m03 = ((int)matrix4f.m03 + 12) % 12;
        matrix4f.m13 = ((int)matrix4f.m13 + 12) % 12;
        matrix4f.m23 = ((int)matrix4f.m23 + 12) % 12;
    }
}

