/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;

class IsoSolventReader
extends AtomDataReader {
    private float cavityRadius;
    private float envelopeRadius;
    private Point3f[] dots;
    private boolean doCalculateTroughs;
    private boolean isCavity;
    private boolean isPocket;
    protected float solventRadius;
    private AtomIndexIterator iter;
    private BitSet bsSurfacePoints;
    private BitSet bsSurfaceDone;
    private BitSet[] bsLocale;
    private Map<String, Edge> htEdges;
    private List<Edge> vEdges;
    private Edge[] aEdges;
    private List<Face> vFaces;
    protected Vector3f vTemp = new Vector3f();
    protected Point4f plane = new Point4f();
    protected Point3f ptTemp2 = new Point3f();
    private Point3f ptS1 = new Point3f();
    private Point3f ptS2 = new Point3f();
    protected Vector3f vTemp2 = new Vector3f();
    private Vector3f vTemp3 = new Vector3f();
    private float dPX;
    protected final Point3f p = new Point3f();
    private float maxRadius;
    private BitSet[] bsAtomMinMax;
    private boolean isSurfacePoint;
    private int iAtomSurface;
    private static boolean testLinear = false;
    protected int nTest;

    IsoSolventReader(SurfaceGenerator surfaceGenerator) {
        super(surfaceGenerator);
    }

    protected boolean readVolumeParameters(boolean bl) {
        this.setup(bl);
        this.initializeVolumetricData();
        if (this.isProgressive) {
            this.volumeData.setUnitVectors();
            this.volumeData.getYzCount();
            this.bsAtomMinMax = new BitSet[this.nPointsX];
            this.getAtomMinMax(null, this.bsAtomMinMax);
            this.voxelSource = new int[this.volumeData.nPoints];
        }
        return true;
    }

    protected void setup(boolean bl) {
        super.setup(bl);
        if (this.contactPair == null) {
            this.cavityRadius = this.params.cavityRadius;
            this.envelopeRadius = this.params.envelopeRadius;
            this.solventRadius = this.params.solventRadius;
            this.point = this.params.point;
            this.isCavity = this.params.isCavity && this.meshDataServer != null;
            this.isPocket = this.params.pocket != null && this.meshDataServer != null;
            this.doUseIterator = this.doCalculateTroughs = !bl && this.atomDataServer != null && !this.isCavity && this.solventRadius > 0.0f && (this.dataType == 1195 || this.dataType == 1203);
            this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Float.NaN);
            if (this.isCavity || this.isPocket) {
                this.dots = this.meshDataServer.calculateGeodesicSurface(this.bsMySelected, this.envelopeRadius);
            }
            this.setHeader("solvent/molecular surface", this.params.calculationType);
            if (this.havePlane || !bl) {
                this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax);
                this.volumeData.getYzCount();
                this.margin = this.volumeData.maxGrid * 2.0f;
            }
            if (this.bsNearby != null) {
                this.bsMySelected.or(this.bsNearby);
            }
        } else if (!bl) {
            this.setVolumeData();
        }
        if (!this.doCalculateTroughs) {
            if (bl) {
                this.precalculateVoxelData = false;
                this.volumeData.sr = this;
            } else if (!this.isCavity) {
                this.isXLowToHigh = true;
                this.isProgressive = true;
            }
        }
        if (this.thisAtomSet == null) {
            this.thisAtomSet = BitSetUtil.setAll((int)this.myAtomCount);
        }
    }

    protected void generateCube() {
        if (this.isCavity && this.params.theProperty != null) {
            return;
        }
        this.getMaxRadius();
        if (this.isCavity && this.dataType != 1205 && this.dataType != 1206) {
            this.params.vertexSource = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(this.cavityRadius, this.params.distance);
            this.generateSolventCavity();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markSphereVoxels(0.0f, Float.NaN);
        } else {
            this.voxelSource = new int[this.volumeData.nPoints];
            this.generateSolventCube();
        }
        this.unsetVoxelData();
        List<Object[]> list = this.params.slabInfo;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((Boolean)list.get(i)[2]).booleanValue() || !(list.get(i)[0] instanceof Point4f)) continue;
                this.volumeData.capData((Point4f)list.get(i)[0], this.params.cutoff);
                list.remove(i--);
            }
        }
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, int n, int n2, int n3, int n4, int n5, float[] fArray, Point3f point3f2) {
        int n6 = this.marchingCubes.getLinearOffset(n, n2, n3, n4);
        int n7 = this.marchingCubes.getLinearOffset(n, n2, n3, n5);
        boolean bl2 = this.isSurfacePoint = this.bsSurfaceVoxels != null && (this.bsSurfaceVoxels.get(n6) || this.bsSurfaceVoxels.get(n7));
        if (testLinear || this.voxelSource == null || this.voxelSource[n6] == 0 || this.voxelSource[n6] != this.voxelSource[n7]) {
            return super.getSurfacePointAndFraction(f, bl, f2, f3, point3f, vector3f, n, n2, n3, n6, n7, fArray, point3f2);
        }
        int n8 = Math.abs(f2 < f3 ? this.voxelSource[n6] : this.voxelSource[n7]);
        if (n8 < 1 || n8 - 1 >= this.atomIndex.length) {
            System.out.println("isosolv HHHHHMMMM");
        }
        this.iAtomSurface = this.atomIndex[n8 - 1];
        float f4 = fArray[0] = MeshSurface.getSphericalInterpolationFraction((double)(this.voxelSource[n6] < 0 ? this.solventRadius : this.atomRadius[this.voxelSource[n6] - 1]), (double)f2, (double)f3, (double)vector3f.length());
        point3f2.scaleAdd(f4, (Tuple3f)vector3f, (Tuple3f)point3f);
        float f5 = f3 - f2;
        return f2 + f4 * f5;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        int n2 = super.addVertexCopy(point3f, f, n);
        if (n2 < 0) {
            return n2;
        }
        if (this.isSurfacePoint) {
            this.bsSurfacePoints.set(n2);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource[n2] = this.iAtomSurface;
        }
        return n2;
    }

    public void selectPocket(boolean bl) {
        int n;
        int n2;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        Point3f[] point3fArray = this.meshData.vertices;
        int n3 = this.meshData.vertexCount;
        float[] fArray = this.meshData.vertexValues;
        int n4 = this.dots.length;
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 0; i < n4; ++i) {
                if (!(this.dots[i].distance(point3fArray[n2]) < this.envelopeRadius)) continue;
                fArray[n2] = Float.NaN;
            }
        }
        this.meshData.getSurfaceSet();
        n2 = this.meshData.nSets;
        BitSet bitSet = new BitSet(n2);
        block2: for (n = 0; n < n2; ++n) {
            BitSet bitSet2 = this.meshData.surfaceSet[n];
            if (bitSet2 == null) continue;
            int n5 = bitSet2.nextSetBit(0);
            while (n5 >= 0) {
                if (Float.isNaN(this.meshData.vertexValues[n5])) {
                    bitSet.set(n);
                    continue block2;
                }
                n5 = bitSet2.nextSetBit(n5 + 1);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.meshData.surfaceSet[n] == null || bitSet.get(n) != bl) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (!bl) {
            this.meshData.surfaceSet = null;
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
            this.meshData = new MeshData();
        }
    }

    protected void postProcessVertices() {
        this.setVertexSource();
        if (this.doCalculateTroughs && this.bsSurfacePoints != null) {
            BitSet[] bitSetArray = this.meshData.getSurfaceSet();
            for (int i = 0; i < this.meshData.nSets; ++i) {
                if (bitSetArray[i].intersects(this.bsSurfacePoints)) continue;
                this.meshData.invalidateSurfaceSet(i);
            }
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 3, null);
                this.meshData = new MeshData();
            }
        }
        if (this.params.thePlane != null && this.params.slabInfo == null) {
            this.params.addSlabInfo(MeshSurface.getSlabWithinRange((float)-100.0f, (float)0.0f));
        }
        Logger.checkTimer((String)"solvent surface time");
    }

    private void generateSolventCavity() {
        int n;
        int n2;
        int n3;
        int n4;
        BitSet bitSet = new BitSet(this.nPointsX * this.nPointsY * this.nPointsZ);
        int n5 = 0;
        int n6 = this.dots.length;
        int n7 = 0;
        float f = this.envelopeRadius;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n3 = 0; n3 < this.nPointsY; ++n3) {
                n2 = 0;
                while (n2 < this.nPointsZ) {
                    block9: {
                        float f2;
                        float f3 = this.voxelData[n4][n3][n2];
                        if (f2 < Float.MAX_VALUE && f3 >= this.cavityRadius) {
                            this.volumeData.voxelPtToXYZ(n4, n3, n2, this.ptXyzTemp);
                            for (n = 0; n < n6; ++n) {
                                if (!(this.dots[n].distance(this.ptXyzTemp) < f)) {
                                    continue;
                                }
                                break block9;
                            }
                            bitSet.set(n5);
                            ++n7;
                        }
                    }
                    ++n2;
                    ++n5;
                }
            }
        }
        Logger.info((String)("cavities include " + n7 + " voxel points"));
        this.atomRadius = new float[n7];
        this.atomXyz = new Point3f[n7];
        n3 = 0;
        n2 = 0;
        for (n4 = 0; n4 < this.nPointsX; ++n4) {
            for (n = 0; n < this.nPointsY; ++n) {
                for (int i = 0; i < this.nPointsZ; ++i) {
                    if (!bitSet.get(n3++)) continue;
                    this.atomXyz[n2] = new Point3f();
                    this.volumeData.voxelPtToXYZ(n4, n, i, this.atomXyz[n2]);
                    this.atomRadius[n2++] = this.voxelData[n4][n][i];
                }
            }
        }
        this.myAtomCount = this.firstNearbyAtom = n7;
        this.thisAtomSet = BitSetUtil.setAll((int)this.myAtomCount);
    }

    private void generateSolventCube() {
        if (this.dataType == 1205) {
            return;
        }
        this.params.vertexSource = new int[this.volumeData.nPoints];
        this.bsSurfaceDone = new BitSet();
        this.bsSurfaceVoxels = new BitSet();
        this.bsSurfacePoints = new BitSet();
        if (this.doCalculateTroughs) {
            this.iter = this.atomDataServer.getSelectedAtomIterator(this.bsMySelected, true, false, false);
            this.vEdges = new ArrayList<Edge>();
            this.bsLocale = new BitSet[this.myAtomCount];
            this.htEdges = new Hashtable<String, Edge>();
            this.getEdges();
            Logger.info((String)(this.vEdges.size() + " edges"));
            this.vFaces = new ArrayList<Face>();
            this.getFaces();
            Logger.info((String)(this.vFaces.size() + " faces"));
            this.vEdges = null;
            this.bsLocale = null;
            this.htEdges = null;
            this.iter.release();
            this.iter = null;
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
            this.markFaceVoxels(true);
            this.markToroidVoxels();
            this.aEdges = null;
            this.markFaceVoxels(false);
            this.vFaces = null;
        } else {
            this.newVoxelDataCube();
            this.resetVoxelData(Float.MAX_VALUE);
        }
        this.markSphereVoxels(0.0f, this.doCalculateTroughs ? Float.MAX_VALUE : this.params.distance);
        this.noFaceSpheres = null;
        this.validSpheres = null;
    }

    private void getEdges() {
        for (int i = 0; i < this.myAtomCount; ++i) {
            this.bsLocale[i] = new BitSet();
        }
        float f = this.solventRadius + this.maxRadius;
        for (int i = 0; i < this.myAtomCount; ++i) {
            Point3f point3f = this.atomXyz[i];
            float f2 = this.atomRadius[i] + this.solventRadius;
            this.atomDataServer.setIteratorForAtom(this.iter, this.atomIndex[i], f2 + f);
            while (this.iter.hasNext()) {
                int n = this.iter.next();
                int n2 = this.myIndex[n];
                Point3f point3f2 = this.atomXyz[n2];
                float f3 = this.atomRadius[n2] + this.solventRadius;
                float f4 = point3f.distance(point3f2);
                if (f4 >= f2 + f3) continue;
                Edge edge = new Edge(i, n2);
                this.vEdges.add(edge);
                this.bsLocale[i].set(n2);
                this.bsLocale[n2].set(i);
                this.htEdges.put(edge.toString(), edge);
            }
        }
    }

    protected Edge findEdge(int n, int n2) {
        return this.htEdges.get(n < n2 ? n + "_" + n2 : n2 + "_" + n);
    }

    private void getFaces() {
        int n;
        BitSet bitSet = new BitSet();
        this.validSpheres = new BitSet();
        this.noFaceSpheres = BitSetUtil.setAll((int)this.myAtomCount);
        int n2 = this.vEdges.size();
        while (--n2 >= 0) {
            Edge edge = this.vEdges.get(n2);
            n = edge.ia;
            int n3 = edge.ib;
            bitSet.clear();
            bitSet.or(this.bsLocale[n]);
            bitSet.and(this.bsLocale[n3]);
            int n4 = bitSet.nextSetBit(n3 + 1);
            while (n4 >= 0) {
                if (this.getSolventPoints(n, n3, n4)) {
                    boolean bl = false;
                    Face face = new Face(n, n3, n4, edge, this.ptS1);
                    if (this.validateFace(face)) {
                        this.vFaces.add(face);
                        bl = true;
                    }
                    if (this.validateFace(face = new Face(n, n3, n4, edge, this.ptS2))) {
                        this.vFaces.add(face);
                        bl = true;
                    }
                    if (bl) {
                        this.noFaceSpheres.clear(n);
                        this.noFaceSpheres.clear(n3);
                        this.noFaceSpheres.clear(n4);
                    }
                }
                n4 = bitSet.nextSetBit(n4 + 1);
            }
        }
        BitSet bitSet2 = new BitSet();
        int n5 = this.vEdges.size();
        while (--n5 >= 0) {
            if (this.vEdges.get(n5).getType() < 0) continue;
            bitSet2.set(n5);
        }
        this.aEdges = new Edge[bitSet2.cardinality()];
        n5 = bitSet2.nextSetBit(0);
        n = 0;
        while (n5 >= 0) {
            this.aEdges[n++] = this.vEdges.get(n5);
            n5 = bitSet2.nextSetBit(n5 + 1);
        }
    }

    private boolean getSolventPoints(int n, int n2, int n3) {
        double d = this.getPointP(n, n2);
        Point3f point3f = this.atomXyz[n3];
        float f = this.atomRadius[n3] + this.solventRadius;
        float f2 = Measure.distanceToPlane((Point4f)this.plane, (Point3f)point3f);
        if (Math.abs(f2) >= f) {
            return false;
        }
        double d2 = Math.sqrt(f * f - f2 * f2);
        this.ptTemp.scaleAdd(-f2, (Tuple3f)this.vTemp, (Tuple3f)point3f);
        double d3 = this.p.distance(this.ptTemp);
        float f3 = (float)(d * d);
        double d4 = ((double)f3 + d3 * d3 - d2 * d2) / (2.0 * d * d3);
        if (Math.abs(d4) >= 1.0) {
            return false;
        }
        Vector3f vector3f = this.vTemp2;
        vector3f.set((Tuple3f)this.ptTemp);
        vector3f.sub((Tuple3f)this.p);
        vector3f.normalize();
        this.dPX = (float)(d * d4);
        this.ptTemp.scaleAdd(this.dPX, (Tuple3f)vector3f, (Tuple3f)this.p);
        vector3f.cross(this.vTemp, vector3f);
        vector3f.normalize();
        vector3f.scale((float)(Math.sqrt(1.0 - d4 * d4) * d));
        this.ptS1.set((Tuple3f)this.ptTemp);
        this.ptS1.add((Tuple3f)vector3f);
        this.ptS2.set((Tuple3f)this.ptTemp);
        this.ptS2.sub((Tuple3f)vector3f);
        return true;
    }

    private boolean validateFace(Face face) {
        int n;
        float f = this.solventRadius + this.maxRadius;
        this.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, face.pS, f);
        face.isValid = true;
        while (this.iter.hasNext()) {
            float f2;
            n = this.iter.next();
            int n2 = this.myIndex[n];
            if (n2 == face.ia || n2 == face.ib || n2 == face.ic || !((f2 = this.atomData.atomXyz[n].distance(face.pS)) < this.atomData.atomRadius[n] + this.solventRadius)) continue;
            face.isValid = false;
            break;
        }
        face.setEdges();
        if (!face.isValid) {
            return false;
        }
        for (n = 0; n < 3; ++n) {
            this.validSpheres.set(face.edges[n].ia);
            this.validSpheres.set(face.edges[n].ib);
        }
        face.edges = null;
        return true;
    }

    private void markFaceVoxels(boolean bl) {
        BitSet bitSet = new BitSet();
        int n = this.vFaces.size();
        while (--n >= 0) {
            Face face = this.vFaces.get(n);
            if (!face.isValid) continue;
            this.setGridLimitsForAtom(face.pS, this.solventRadius, this.pt0, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptXyzTemp);
            Point3f point3f = this.atomXyz[face.ia];
            Point3f point3f2 = this.atomXyz[face.ib];
            Point3f point3f3 = this.atomXyz[face.ic];
            Point3f point3f4 = face.pS;
            if (Logger.debugging) {
                face.dump();
            }
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                this.ptY0.set((Tuple3f)this.ptXyzTemp);
                for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                    this.ptZ0.set((Tuple3f)this.ptXyzTemp);
                    for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                        float f = this.solventRadius - this.ptXyzTemp.distance(point3f4);
                        float f2 = this.voxelData[i][j][k];
                        int n2 = this.volumeData.getPointIndex(i, j, k);
                        if (bl && f > 0.0f) {
                            this.bsSurfaceDone.set(n2);
                        }
                        if (Measure.isInTetrahedron((Point3f)this.ptXyzTemp, (Point3f)point3f, (Point3f)point3f2, (Point3f)point3f3, (Point3f)point3f4, (Point4f)this.plane, (Vector3f)this.vTemp, (Vector3f)this.vTemp2, (Vector3f)this.vTemp3, (boolean)false) && (!bl ? !this.bsSurfaceDone.get(n2) && f < 0.0f && f > -this.volumeData.maxGrid * 1.8f && f > f2 == bitSet.get(n2) : f > 0.0f && (f2 < 0.0f || f2 == Float.MAX_VALUE || f > f2 == bitSet.get(n2)))) {
                            bitSet.set(n2);
                            this.setVoxel(i, j, k, n2, f);
                            if (this.voxelSource != null) {
                                this.voxelSource[n2] = -1 - face.ia;
                            }
                            if (f > 0.0f) {
                                this.bsSurfaceVoxels.set(n2);
                            }
                        }
                        this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.scaleAdd(1.0f, (Tuple3f)this.volumetricVectors[1], (Tuple3f)this.ptZ0);
                }
                this.ptXyzTemp.scaleAdd(1.0f, (Tuple3f)this.volumetricVectors[0], (Tuple3f)this.ptY0);
            }
        }
    }

    private void markToroidVoxels() {
        Point3i point3i = new Point3i();
        Point3i point3i2 = new Point3i();
        Point3i point3i3 = new Point3i();
        Point3i point3i4 = new Point3i();
        for (int i = 0; i < this.aEdges.length; ++i) {
            Edge edge = this.aEdges[i];
            int n = edge.ia;
            int n2 = edge.ib;
            Point3f point3f = this.atomXyz[n];
            Point3f point3f2 = this.atomXyz[n2];
            float f = this.atomRadius[n] + this.solventRadius;
            float f2 = this.atomRadius[n2] + this.solventRadius;
            float f3 = point3f2.distance(point3f);
            this.setGridLimitsForAtom(point3f, this.atomRadius[n] + this.solventRadius, point3i, point3i3);
            this.setGridLimitsForAtom(point3f2, this.atomRadius[n2] + this.solventRadius, point3i2, point3i4);
            IsoSolventReader.mergeLimits(point3i, point3i2, this.pt0, null);
            IsoSolventReader.mergeLimits(point3i3, point3i4, null, this.pt1);
            this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptXyzTemp);
            for (int j = this.pt0.x; j < this.pt1.x; ++j) {
                this.ptY0.set((Tuple3f)this.ptXyzTemp);
                for (int k = this.pt0.y; k < this.pt1.y; ++k) {
                    this.ptZ0.set((Tuple3f)this.ptXyzTemp);
                    for (int i2 = this.pt0.z; i2 < this.pt1.z; ++i2) {
                        float f4;
                        float f5 = this.checkSpecialVoxel(point3f, f, point3f2, f2, f3, this.ptXyzTemp);
                        if (!Float.isNaN(f5) && (f4 = this.solventRadius - f5) < this.voxelData[j][k][i2]) {
                            int n3 = this.volumeData.getPointIndex(j, k, i2);
                            this.setVoxel(j, k, i2, n3, f4);
                            if (this.voxelSource != null) {
                                this.voxelSource[n3] = -1 - n;
                            }
                        }
                        this.ptXyzTemp.add((Tuple3f)this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.scaleAdd(1.0f, (Tuple3f)this.volumetricVectors[1], (Tuple3f)this.ptZ0);
                }
                this.ptXyzTemp.scaleAdd(1.0f, (Tuple3f)this.volumetricVectors[0], (Tuple3f)this.ptY0);
            }
        }
        this.validSpheres.or(this.noFaceSpheres);
    }

    protected void unsetVoxelData() {
        if (!this.havePlane) {
            super.unsetVoxelData();
            return;
        }
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] < 0.001f) continue;
                this.thisPlane[i] = 0.001f;
            }
        } else {
            for (int i = 0; i < this.nPointsX; ++i) {
                for (int j = 0; j < this.nPointsY; ++j) {
                    for (int k = 0; k < this.nPointsZ; ++k) {
                        if (this.voxelData[i][j][k] < 0.001f) continue;
                        this.voxelData[i][j][k] = 0.001f;
                    }
                }
            }
        }
    }

    void getMaxRadius() {
        this.maxRadius = 0.0f;
        for (int i = 0; i < this.myAtomCount; ++i) {
            float f = this.atomRadius[i];
            if (!(f > this.maxRadius)) continue;
            this.maxRadius = f;
        }
    }

    private static void mergeLimits(Point3i point3i, Point3i point3i2, Point3i point3i3, Point3i point3i4) {
        if (point3i3 != null) {
            point3i3.x = Math.min(point3i.x, point3i2.x);
            point3i3.y = Math.min(point3i.y, point3i2.y);
            point3i3.z = Math.min(point3i.z, point3i2.z);
        }
        if (point3i4 != null) {
            point3i4.x = Math.max(point3i.x, point3i2.x);
            point3i4.y = Math.max(point3i.y, point3i2.y);
            point3i4.z = Math.max(point3i.z, point3i2.z);
        }
    }

    private float checkSpecialVoxel(Point3f point3f, float f, Point3f point3f2, float f2, float f3, Point3f point3f3) {
        float f4;
        float f5 = point3f.distance(point3f3);
        float f6 = point3f2.distance(point3f3);
        float f7 = f / f5;
        if (f7 > 1.0f) {
            this.p.set(point3f.x + (point3f3.x - point3f.x) * f7, point3f.y + (point3f3.y - point3f.y) * f7, point3f.z + (point3f3.z - point3f.z) * f7);
            if (point3f2.distance(this.p) >= f2) {
                return Float.NaN;
            }
            float f8 = this.solventDistance(f, f2, f3, f5, f6);
            return IsoSolventReader.voxelIsInTrough(f8, f * f, f2, f3, f5) ? f8 : Float.NaN;
        }
        f7 = f2 / f6;
        if (f4 > 1.0f) {
            this.p.set(point3f2.x + (point3f3.x - point3f2.x) * f7, point3f2.y + (point3f3.y - point3f2.y) * f7, point3f2.z + (point3f3.z - point3f2.z) * f7);
            if (point3f.distance(this.p) >= f) {
                return Float.NaN;
            }
            float f9 = this.solventDistance(f2, f, f3, f6, f5);
            return IsoSolventReader.voxelIsInTrough(f9, f2 * f2, f, f3, f6) ? f9 : Float.NaN;
        }
        return Float.NaN;
    }

    private static boolean voxelIsInTrough(float f, float f2, float f3, float f4, float f5) {
        float f6 = (f2 + f3 * f3 - f4 * f4) / f3;
        float f7 = (f2 + f * f - f5 * f5) / f;
        return f6 < f7;
    }

    private float solventDistance(float f, float f2, float f3, float f4, float f5) {
        double d = f4 * f4;
        double d2 = f * f;
        double d3 = f3 * f3;
        double d4 = Math.acos((d + d3 - (double)(f5 * f5)) / (double)(2.0f * f4 * f3));
        double d5 = Math.acos((d3 + d2 - (double)(f2 * f2)) / (double)(2.0f * f3 * f));
        float f6 = (float)Math.sqrt(d2 + d - (double)(2.0f * f * f4) * Math.cos(d5 - d4));
        return f6;
    }

    protected double getPointP(int n, int n2) {
        Point3f point3f = this.atomXyz[n];
        Point3f point3f2 = this.atomXyz[n2];
        float f = this.atomRadius[n] + this.solventRadius;
        float f2 = this.atomRadius[n2] + this.solventRadius;
        this.vTemp.set((Tuple3f)point3f2);
        this.vTemp.sub((Tuple3f)point3f);
        float f3 = this.vTemp.length();
        this.vTemp.normalize();
        double d = f * f;
        double d2 = f3 * f3;
        double d3 = (d2 + d - (double)(f2 * f2)) / (double)(2.0f * f3 * f);
        double d4 = Math.acos(d3);
        this.p.scaleAdd((float)(d3 * (double)f), (Tuple3f)this.vTemp, (Tuple3f)point3f);
        Measure.getPlaneThroughPoint((Point3f)this.p, (Vector3f)this.vTemp, (Point4f)this.plane);
        return Math.sin(d4) * (double)f;
    }

    void dumpLine(Point3f point3f, Tuple3f tuple3f, String string, String string2) {
        this.sg.log("draw ID \"" + string + this.nTest++ + "\" @{point" + new Point3f(point3f) + "} @{point" + new Point3f(tuple3f) + "} color " + string2);
    }

    void dumpLine2(Point3f point3f, Point3f point3f2, String string, float f, String string2, String string3) {
        Vector3f vector3f = new Vector3f();
        vector3f.set((Tuple3f)point3f2);
        vector3f.sub((Tuple3f)point3f);
        vector3f.normalize();
        vector3f.scale(f);
        vector3f.add((Tuple3f)point3f);
        this.sg.log("draw ID \"" + string + this.nTest++ + "\" @{point" + new Point3f(point3f) + "} @{point" + new Point3f((Tuple3f)vector3f) + "} color " + string2);
        this.sg.log("draw ID \"" + string + this.nTest++ + "\" @{point" + new Point3f((Tuple3f)vector3f) + "} @{point" + new Point3f(point3f2) + "} color " + string3);
    }

    void dumpPoint(Point3f point3f, String string, String string2) {
        this.sg.log("draw ID \"" + string + this.nTest++ + "\" @{point" + new Point3f(point3f) + "} color " + string2);
    }

    public float getValueAtPoint(Point3f point3f) {
        if (this.contactPair != null) {
            return point3f.distance((Point3f)this.contactPair.myAtoms[1]) - this.contactPair.radii[1];
        }
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.firstNearbyAtom; ++i) {
            float f2 = point3f.distance(this.atomXyz[i]) - this.atomRadius[i] - this.solventRadius;
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f == Float.MAX_VALUE ? Float.NaN : f;
    }

    public float[] getPlane(int n) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        this.thisX = n;
        this.thisPlane = this.yzPlanes[n % 2];
        if (this.contactPair == null) {
            this.resetPlane(Float.MAX_VALUE);
            this.thisAtomSet = this.bsAtomMinMax[n];
            this.markSphereVoxels(0.0f, this.params.distance);
            this.unsetVoxelData();
        } else {
            this.markPlaneVoxels((Point3f)this.contactPair.myAtoms[0], this.contactPair.radii[0]);
        }
        return this.thisPlane;
    }

    private class Face {
        int ia;
        int ib;
        int ic;
        boolean isValid;
        Point3f pS;
        Edge[] edges = new Edge[3];

        Face(int n, int n2, int n3, Edge edge, Point3f point3f) {
            this.ia = n;
            this.ib = n2;
            this.ic = n3;
            this.pS = new Point3f(point3f);
            this.edges[0] = edge;
        }

        void setEdges() {
            if (this.edges[1] == null) {
                this.edges[1] = IsoSolventReader.this.findEdge(this.ib, this.ic);
                this.edges[2] = IsoSolventReader.this.findEdge(this.ic, this.ia);
            }
            Face face = this.isValid ? this : null;
            for (int i = 0; i < 3; ++i) {
                this.edges[i].addFace(face);
            }
        }

        protected void dump() {
        }
    }

    private class Edge {
        int ia;
        int ib;
        int nFaces;
        int nInvalid;

        Edge(int n, int n2) {
            this.ia = Math.min(n, n2);
            this.ib = Math.max(n, n2);
        }

        void addFace(Face face) {
            if (face == null) {
                ++this.nInvalid;
                return;
            }
            ++this.nFaces;
        }

        int getType() {
            return this.nFaces > 0 ? this.nFaces : (this.nInvalid > 0 ? -this.nInvalid : 0);
        }

        public String toString() {
            return this.ia + "_" + this.ib;
        }
    }
}

