/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javax.vecmath.Vector3f;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class CastepDensityReader
extends VolumeFileReader {
    private int nFilePoints;
    private int nSkip;

    CastepDensityReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isProgressive = false;
        this.canDownsample = false;
        this.isAngstroms = true;
    }

    protected void readParameters() throws Exception {
        int n;
        this.jvxlFileHeaderBuffer = new StringBuffer();
        while (this.readLine() != null && this.line.indexOf(".") < 0) {
        }
        for (n = 0; n < 3; ++n) {
            Vector3f vector3f = this.volumetricVectors[n];
            vector3f.set(this.parseFloat(this.line), this.parseFloat(), this.parseFloat());
            this.readLine();
        }
        this.nSurfaces = this.parseInt(this.readLine());
        this.readLine();
        this.nPointsX = this.parseInt(this.line);
        this.voxelCounts[0] = this.nPointsX + 1;
        this.nPointsY = this.parseInt();
        this.voxelCounts[1] = this.nPointsY + 1;
        this.nPointsZ = this.parseInt();
        this.voxelCounts[2] = this.nPointsZ + 1;
        this.nFilePoints = this.nPointsX++ * this.nPointsY++ * this.nPointsZ++;
        for (n = 0; n < 3; ++n) {
            this.volumetricVectors[n].scale(1.0f / (float)(this.voxelCounts[n] - 1));
            if (!this.isAnisotropic) continue;
            this.setVectorAnisotropy(this.volumetricVectors[n]);
        }
        while (this.readLine().trim().length() > 0) {
        }
    }

    protected void gotoData(int n, int n2) throws Exception {
        this.nSkip = n;
    }

    protected void readSurfaceData(boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        this.initializeSurfaceData();
        this.voxelData = new float[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.readLine();
        String[] stringArray = this.getTokens();
        if (this.nSkip > 0 && stringArray.length < 3 + this.nSurfaces) {
            for (n4 = 0; n4 < this.nSkip; ++n4) {
                for (n3 = 0; n3 < this.nFilePoints; ++n3) {
                    this.readLine();
                }
            }
            this.nSkip = 0;
        }
        for (n4 = 0; n4 < this.nFilePoints; ++n4) {
            n3 = this.parseInt(this.line) - 1;
            n2 = this.parseInt() - 1;
            n = this.parseInt() - 1;
            if (this.nSkip > 0) {
                this.skipPoints(this.nSkip);
            }
            this.voxelData[n3][n2][n] = this.recordData(this.parseFloat());
            this.readLine();
        }
        n4 = this.nPointsX - 1;
        for (n3 = 0; n3 < this.nPointsY; ++n3) {
            for (n2 = 0; n2 < this.nPointsZ; ++n2) {
                this.voxelData[n4][n3][n2] = this.voxelData[0][n3][n2];
            }
        }
        n4 = this.nPointsY - 1;
        for (n3 = 0; n3 < this.nPointsX; ++n3) {
            for (n2 = 0; n2 < this.nPointsZ; ++n2) {
                this.voxelData[n3][n4][n2] = this.voxelData[n3][0][n2];
            }
        }
        n4 = this.nPointsZ - 1;
        for (n3 = 0; n3 < this.nPointsX; ++n3) {
            for (n2 = 0; n2 < this.nPointsY; ++n2) {
                this.voxelData[n3][n2][n4] = this.voxelData[n3][n2][0];
            }
        }
        if (bl && this.volumeData.hasPlane()) {
            this.volumeData.setVoxelMap();
            for (n3 = 0; n3 < this.nPointsX; ++n3) {
                for (n2 = 0; n2 < this.nPointsY; ++n2) {
                    for (n = 0; n < this.nPointsZ; ++n) {
                        float f = this.volumeData.getToPlaneParameter();
                        if (!this.volumeData.isNearPlane(n3, n2, n, f)) continue;
                        this.volumeData.setVoxelMapValue(n3, n2, n, this.voxelData[n3][n2][n]);
                    }
                }
            }
            this.voxelData = null;
        }
        this.volumeData.setVoxelData(this.voxelData);
        if (this.dataMin > this.params.cutoff) {
            this.params.cutoff = 2.0f * this.dataMin;
        }
    }

    private void skipPoints(int n) {
        int n2 = this.next[0];
        for (int i = 0; i < n; ++i) {
            while (n2 < this.line.length() && Character.isWhitespace(this.line.charAt(n2++))) {
            }
            while (n2 < this.line.length() && !Character.isWhitespace(this.line.charAt(n2++))) {
            }
        }
        this.next[0] = n2;
    }
}

