/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.AtomShape;
import org.jmol.util.Escape;
import org.jmol.util.Quadric;
import org.jmol.viewer.StateManager;

public class Ellipsoids
extends AtomShape {
    Map<String, Ellipsoid> htEllipsoids = new Hashtable<String, Ellipsoid>();
    boolean haveEllipsoids;
    short[][] colixset;
    byte[][] paletteIDset;
    short[][] madset;
    Ellipsoid ellipsoid;
    private int iSelect;

    public boolean getProperty(String string, Object[] objectArray) {
        return super.getProperty(string, objectArray);
    }

    public int getIndexFromName(String string) {
        this.ellipsoid = this.htEllipsoids.get(string);
        return this.ellipsoid == null ? -1 : 1;
    }

    protected void setSize(int n, BitSet bitSet) {
        super.setSize(n, bitSet);
        this.checkSets();
        this.madset[this.iSelect] = this.mads;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            if (n != 0) {
                this.atoms[n2].scaleEllipsoid(n, this.iSelect);
            }
            boolean bl = this.madset[0] != null && this.madset[0].length > n2 && this.madset[0][n2] > 0 || this.madset[1] != null && this.madset[1].length > n2 && this.madset[1][n2] > 0 || this.madset[2] != null && this.madset[2].length > n2 && this.madset[2][n2] > 0;
            this.bsSizeSet.set(n2, bl);
            this.atoms[n2].setShapeVisibility(this.myVisibilityFlag, bl);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (string == "thisID") {
            Ellipsoid ellipsoid = this.ellipsoid = object == null ? null : this.htEllipsoids.get(object);
            if (object == null) {
                return;
            }
            if (this.ellipsoid == null) {
                String string2 = (String)object;
                this.ellipsoid = new Ellipsoid(string2, this.viewer.getCurrentModelIndex());
                this.htEllipsoids.put(string2, this.ellipsoid);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Iterator<Ellipsoid> iterator = this.htEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                Ellipsoid ellipsoid = iterator.next();
                if (ellipsoid.modelIndex > n) {
                    --ellipsoid.modelIndex;
                    continue;
                }
                if (ellipsoid.modelIndex != n) continue;
                iterator.remove();
            }
            this.ellipsoid = null;
            return;
        }
        if (this.ellipsoid != null) {
            this.haveEllipsoids = true;
            if ("delete" == string) {
                this.htEllipsoids.remove(this.ellipsoid.id);
                return;
            }
            if ("modelindex" == string) {
                this.ellipsoid.modelIndex = (Integer)object;
                return;
            }
            if ("on" == string) {
                this.ellipsoid.isOn = (Boolean)object;
                return;
            }
            if ("axes" == string) {
                int n;
                this.ellipsoid.isValid = false;
                this.ellipsoid.axes = (Vector3f[])object;
                this.ellipsoid.lengths = new float[3];
                this.ellipsoid.scale = 1.0f;
                for (n = 0; n < 2; ++n) {
                    if (!(this.ellipsoid.axes[n].length() > this.ellipsoid.axes[n + 1].length())) continue;
                    Vector3f vector3f = this.ellipsoid.axes[n];
                    this.ellipsoid.axes[n] = this.ellipsoid.axes[n + 1];
                    this.ellipsoid.axes[n + 1] = vector3f;
                    if (n != 1) continue;
                    n = -1;
                }
                for (n = 0; n < 3; ++n) {
                    this.ellipsoid.lengths[n] = this.ellipsoid.axes[n].length();
                    if (this.ellipsoid.lengths[n] == 0.0f) {
                        return;
                    }
                    this.ellipsoid.axes[n].normalize();
                }
                if (Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f) {
                    return;
                }
                this.updateEquation(this.ellipsoid);
                return;
            }
            if ("equation" == string) {
                this.ellipsoid.coef = (double[])object;
                this.ellipsoid.axes = new Vector3f[3];
                this.ellipsoid.lengths = new float[3];
                Quadric.getAxesForEllipsoid((double[])this.ellipsoid.coef, (Vector3f[])this.ellipsoid.axes, (float[])this.ellipsoid.lengths);
                return;
            }
            if ("center" == string) {
                this.ellipsoid.center = (Point3f)object;
                this.updateEquation(this.ellipsoid);
                return;
            }
            if ("scale" == string) {
                float f = ((Float)object).floatValue();
                if (f <= 0.0f || this.ellipsoid.lengths == null) {
                    this.ellipsoid.isValid = false;
                } else {
                    int n = 0;
                    while (n < 3) {
                        int n2 = n++;
                        this.ellipsoid.lengths[n2] = this.ellipsoid.lengths[n2] * (f / this.ellipsoid.scale);
                    }
                    this.ellipsoid.scale = f;
                    this.updateEquation(this.ellipsoid);
                }
                return;
            }
            if ("color" == string) {
                this.ellipsoid.colix = Graphics3D.getColix((Object)object);
                return;
            }
            if ("translucentLevel" == string) {
                super.setProperty(string, object, bitSet);
                return;
            }
            if ("translucency" == string) {
                boolean bl = object.equals("translucent");
                this.ellipsoid.colix = Graphics3D.getColixTranslucent((short)this.ellipsoid.colix, (boolean)bl, (float)this.translucentLevel);
                return;
            }
        }
        if ("select" == string) {
            this.iSelect = (Integer)object - 1;
            this.checkSets();
            this.colixes = this.colixset[this.iSelect];
            this.paletteIDs = this.paletteIDset[this.iSelect];
            this.mads = this.madset[this.iSelect];
            return;
        }
        super.setProperty(string, object, bitSet);
        if (this.colixset != null && ("color" == string || "translucency" == string || "deleteModelAtoms" == string)) {
            this.colixset[this.iSelect] = this.colixes;
            this.paletteIDset[this.iSelect] = this.paletteIDs;
            this.madset[this.iSelect] = this.mads;
        }
    }

    private void checkSets() {
        if (this.colixset == null) {
            this.colixset = new short[3][];
            this.paletteIDset = new byte[3][];
            this.madset = new short[3][];
        }
    }

    private void updateEquation(Ellipsoid ellipsoid) {
        if (ellipsoid.axes == null || ellipsoid.lengths == null) {
            return;
        }
        Matrix3f matrix3f = new Matrix3f();
        Matrix3f matrix3f2 = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        ellipsoid.coef = new double[10];
        Quadric.getEquationForQuadricWithCenter((float)ellipsoid.center.x, (float)ellipsoid.center.y, (float)ellipsoid.center.z, (Matrix3f)matrix3f, (Vector3f)vector3f, (Matrix3f)matrix3f2, (double[])ellipsoid.coef, null);
        ellipsoid.isValid = true;
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getStateID(stringBuffer);
        this.getStateAtoms(stringBuffer);
        return stringBuffer.toString();
    }

    private void getStateID(StringBuffer stringBuffer) {
        if (!this.isActive || this.madset == null) {
            return;
        }
        Iterator<Ellipsoid> iterator = this.htEllipsoids.values().iterator();
        Vector3f vector3f = new Vector3f();
        while (iterator.hasNext()) {
            Ellipsoid ellipsoid = iterator.next();
            if (ellipsoid.axes == null || ellipsoid.lengths == null) continue;
            stringBuffer.append("  Ellipsoid ID ").append(ellipsoid.id).append(" modelIndex ").append(ellipsoid.modelIndex).append(" center ").append(Escape.escape((Tuple3f)ellipsoid.center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                vector3f.set((Tuple3f)ellipsoid.axes[i]);
                vector3f.scale(ellipsoid.lengths[i]);
                stringBuffer.append(" ").append(Escape.escape((Tuple3f)vector3f));
            }
            stringBuffer.append(" " + this.getColorCommand("", ellipsoid.colix));
            if (!ellipsoid.isOn) {
                stringBuffer.append(" off");
            }
            stringBuffer.append(";\n");
        }
    }

    private void getStateAtoms(StringBuffer stringBuffer) {
        for (int i = 0; i < 3; ++i) {
            int n;
            if (this.madset == null || this.madset[i] == null) continue;
            StateManager.appendCmd((StringBuffer)stringBuffer, (String)("Ellipsoids set " + (i + 1) + "\n"));
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            if (this.bsSizeSet != null) {
                n = this.bsSizeSet.nextSetBit(0);
                while (n >= 0) {
                    Ellipsoids.setStateInfo(hashtable, (int)n, (String)("Ellipsoids " + this.madset[i][n]));
                    n = this.bsSizeSet.nextSetBit(n + 1);
                }
            }
            if (this.bsColixSet != null && this.colixset[i] != null) {
                n = this.bsColixSet.nextSetBit(0);
                while (n >= 0) {
                    Ellipsoids.setStateInfo(hashtable2, (int)n, (String)this.getColorCommand("Ellipsoids", this.paletteIDset[i][n], this.colixset[i][n]));
                    n = this.bsColixSet.nextSetBit(n + 1);
                }
            }
            stringBuffer.append(Ellipsoids.getShapeCommands(hashtable, hashtable2));
        }
    }

    public void setVisibilityFlags(BitSet bitSet) {
        for (Ellipsoid ellipsoid : this.htEllipsoids.values()) {
            ellipsoid.visible = ellipsoid.isOn && (ellipsoid.modelIndex < 0 || bitSet.get(ellipsoid.modelIndex));
        }
    }

    static class Ellipsoid {
        String id;
        Vector3f[] axes;
        float[] lengths;
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        double[] coef;
        short colix = (short)23;
        int modelIndex;
        float scale = 1.0f;
        boolean visible;
        boolean isValid;
        boolean isOn = true;

        Ellipsoid(String string, int n) {
            this.id = string;
            this.modelIndex = n;
        }
    }
}

