#!/usr/bin/env python

# Set this to True to enable building extensions using Cython.
# Set it to False to build extensions from the CPP file (that
# was previously created using Cython).
# Set it to 'auto' to build with Cython if available, otherwise
# from the CPP file.
# Warning: I can notice some runtime errors with cython 0.15 that disappear with 0.17
#USE_CYTHON = False
USE_CYTHON = 'auto'


from sage.env import SAGE_LOCAL,SAGE_SRC
import os

from distutils.core import setup
from distutils.extension import Extension

if USE_CYTHON:
    try:
        from Cython.Distutils import build_ext
    except ImportError:
        if USE_CYTHON=='auto':
            USE_CYTHON=False
        else:
            raise

cmdclass = { }
ext_modules = [ ]

conf = {'CXXFLAGS' : [], 'LDFLAGS' : []}

libraries=['giac']
library_dirs=[SAGE_LOCAL+'/lib']
# in sage 6.7 cimport Integer needs ccobject.h but it was moved to SAGE_SRC/sage/ext
# But in sage 6.8>= the function sage_include_directories was introduced to gives the includes.
try:
    # Sage >= 6.8
    from sage.env import sage_include_directories
except ImportError:
    # Sage < 6.8
    def sage_include_directories():
        return [
            os.path.join(SAGE_LOCAL, "include"),
            os.path.join(SAGE_LOCAL, "include", "csage"),
            os.path.join(SAGE_SRC),
            os.path.join(SAGE_SRC, "sage", "ext"),
            ]
    # (on sage 6.7 without csage gives undefined symbols _signals)
    libraries.append('csage')
###

include_dirs=sage_include_directories()

if USE_CYTHON:
    ext_modules+=[Extension(
                   "giacpy",                 # name of extension
                   ["giacpy.pyx"], #  our Cython source
                   libraries=libraries,
                   library_dirs=library_dirs,
                   include_dirs=include_dirs,
                   extra_compile_args=conf["CXXFLAGS"],
                   extra_link_args=conf["LDFLAGS"],
                   language="c++")]
    cmdclass={'build_ext': build_ext}

else:
    ext_modules+=[Extension(
                   "giacpy",                 # name of extension
                   ["giacpy.cpp"], #  the cpp file already created by Cython
                   library_dirs=library_dirs,
                   libraries=libraries,
                   include_dirs=include_dirs,
                   extra_compile_args=conf["CXXFLAGS"],
                   extra_link_args=conf["LDFLAGS"],
                   language="c++")]

setup(


    name='giacpy',
    version='0.5.1',
    description='A Cython frontend to the c++ library giac. (Computer Algebra System)',
    author='Frederic Han',
    author_email="frederic.han@imj-prg.fr",
    url='http://www.math.jussieu.fr/~han/xcas/giacpy/',
    long_description=open('README.txt').read(),
    license='GPLv2 or above',
    ext_modules=ext_modules,
    cmdclass=cmdclass
    )
