#############################################################################
##
#W  atlasprm.g           GAP 4 package AtlasRep                 Thomas Breuer
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file is the primary file of the GAP interface for the
##  Atlas of Group Representations.
##  It contains the data that is needed to access the representations and
##  straight line programs.
##
##  This file is the only one in the AtlasRep package that must be changed
##  when new information is added to the database.
##


#############################################################################
##
##  Establish the bijection between the group names used in the filenames of
##  the ATLAS database and the names used to access the groups in GAP.
##

# names that are not really supported (but we want to avoid error messages)

# alternating and related groups
AGR.GNAN("A5","A5");
AGR.GNAN("A5.2","S5");
AGR.GNAN("2.A5","2A5");
AGR.GNAN("2.A5.2","2S5");
AGR.GNAN("Isoclinic(2.A5.2)","2S5i");
AGR.GNAN("A6","A6");
AGR.GNAN("2.A6","2A6");
AGR.GNAN("3.A6","3A6");
AGR.GNAN("6.A6","6A6");
AGR.GNAN("A6.2_1","S6");
AGR.GNAN("A6.2_2","PGL29");
AGR.GNAN("A6.2_3","M10");
AGR.GNAN("A6.2^2","A6V4");
AGR.GNAN("2.A6.2_1","2S6");
AGR.GNAN("3.A6.2_1","3S6");
AGR.GNAN("6.A6.2_1","6S6");
AGR.GNAN("A7","A7");
AGR.GNAN("A7.2","S7");
AGR.GNAN("2.A7","2A7");
AGR.GNAN("2.A7.2","2S7");
AGR.GNAN("Isoclinic(2.A7.2)","2S7i");
AGR.GNAN("3.A7","3A7");
AGR.GNAN("3.A7.2","3S7");
AGR.GNAN("6.A7","6A7");
AGR.GNAN("6.A7.2","6S7");
AGR.GNAN("A8","A8");
AGR.GNAN("A8.2","S8");
AGR.GNAN("2.A8","2A8");
AGR.GNAN("2.A8.2","2S8");
AGR.GNAN("Isoclinic(2.A8.2)","2S8i");
AGR.GNAN("A9","A9");
AGR.GNAN("A9.2","S9");
AGR.GNAN("2.A9","2A9");
AGR.GNAN("2.A9.2","2S9");
AGR.GNAN("A10","A10");
AGR.GNAN("A10.2","S10");
AGR.GNAN("2.A10","2A10");
AGR.GNAN("2.A10.2","2S10");
AGR.GNAN("A11","A11");
AGR.GNAN("A11.2","S11");
AGR.GNAN("2.A11","2A11");
AGR.GNAN("2.A11.2","2S11");
AGR.GNAN("A12","A12");
AGR.GNAN("A12.2","S12");
AGR.GNAN("2.A12","2A12");
AGR.GNAN("2.A12.2","2S12");
AGR.GNAN("A13","A13");
AGR.GNAN("A13.2","S13");
AGR.GNAN("2.A13","2A13");
AGR.GNAN("2.A13.2","2S13");
AGR.GNAN("A14","A14");
AGR.GNAN("A14.2","S14");
AGR.GNAN("2.A14","2A14");
AGR.GNAN("2.A14.2","2S14");
AGR.GNAN("Isoclinic(2.A14.2)","2S14i");
AGR.GNAN("A15","A15");
AGR.GNAN("A15.2","S15");
AGR.GNAN("A16","A16");
AGR.GNAN("A16.2","S16");
AGR.GNAN("A17","A17");
AGR.GNAN("A17.2","S17");
AGR.GNAN("A18","A18");
AGR.GNAN("A18.2","S18");
AGR.GNAN("A19","A19");
AGR.GNAN("A19.2","S19");
AGR.GNAN("A20","A20");
AGR.GNAN("A20.2","S20");
AGR.GNAN("A21","A21");
AGR.GNAN("A21.2","S21");
AGR.GNAN("A22","A22");
AGR.GNAN("A22.2","S22");
AGR.GNAN("A23","A23");
AGR.GNAN("A23.2","S23");
AGR.GNAN("M20","M20");
AGR.GNAN("2aM20","2aM20");
AGR.GNAN("2bM20","2bM20");
AGR.GNAN("2cM20","2cM20");
AGR.GNAN("4bM20","4bM20");

# symplectic and related groups
AGR.GNAN("S4(4)","S44");
AGR.GNAN("S4(4).2","S44d2");
AGR.GNAN("S4(4).4","S44d4");
AGR.GNAN("S4(5)","S45");
AGR.GNAN("S4(5).2","S45d2");
AGR.GNAN("2.S4(5)","2S45");
AGR.GNAN("S4(7)","S47");
AGR.GNAN("S4(7).2","S47d2");
AGR.GNAN("2.S4(7)","2S47");
AGR.GNAN("2.S4(7).2","2S47d2");
AGR.GNAN("S4(9)","S49");
AGR.GNAN("2.S4(9)","2S49");
AGR.GNAN("S4(11)","S411");
AGR.GNAN("2.S4(11)","2S411");
AGR.GNAN("S4(13)","S413");
AGR.GNAN("2.S4(13)","2S413");
AGR.GNAN("S4(17)","S417");
AGR.GNAN("2.S4(17)","2S417");
AGR.GNAN("S4(19)","S419");
AGR.GNAN("2.S4(19)","2S419");
AGR.GNAN("S6(2)","S62");
AGR.GNAN("2.S6(2)","2S62");
AGR.GNAN("S6(3)","S63");
AGR.GNAN("S6(3).2","S63d2");
AGR.GNAN("2.S6(3)","2S63");
AGR.GNAN("2.S6(3).2","2S63d2");
AGR.GNAN("S6(5)","S65");
AGR.GNAN("S8(2)","S82");
AGR.GNAN("S8(3)","S83");
AGR.GNAN("S10(2)","S102");

# orthogonal and related groups
AGR.GNAN("O7(3)","O73");
AGR.GNAN("O7(3).2","O73d2");
AGR.GNAN("2.O7(3)","2O73");
AGR.GNAN("2.O7(3).2","2O73d2");
AGR.GNAN("3.O7(3)","3O73");
AGR.GNAN("3.O7(3).2","3O73d2");
AGR.GNAN("6.O7(3)","6O73");
AGR.GNAN("6.O7(3).2","6O73d2");
AGR.GNAN("O8-(2)","O8m2");
AGR.GNAN("O8-(2).2","O8m2d2");
AGR.GNAN("O8+(2)","O8p2");
AGR.GNAN("O8+(2).2","O8p2d2");
AGR.GNAN("O8+(2).3","O8p2d3");
AGR.GNAN("2.O8+(2)","2O8p2");
AGR.GNAN("2.O8+(2).2","2O8p2d2");
AGR.GNAN("O8-(3)","O8m3");
AGR.GNAN("O8-(3).2_1","O8m3d2a");
AGR.GNAN("O8-(3).2_2","O8m3d2b");
AGR.GNAN("O8-(3).2_3","O8m3d2c");
AGR.GNAN("O8-(3).2^2","O8m3V4");
AGR.GNAN("O8-(3).D8","O8m3D8"); # a double cover of `O8-(3).2^2'
AGR.GNAN("2.O8-(3)","2O8m3");
AGR.GNAN("2.O8-(3).2_1","2O8m3d2a");
AGR.GNAN("O8+(3)","O8p3");
AGR.GNAN("O8+(3).S4","O8p3S4");
AGR.GNAN("2.O8+(3)","2O8p3");
AGR.GNAN("2^2.O8+(3).S4","4O8p3S4");
AGR.GNAN("O9(3)","O93");
AGR.GNAN("O9(3).2","O93d2");
AGR.GNAN("2.O9(3)","2O93");
AGR.GNAN("2.O9(3).2","2O93d2");
AGR.GNAN("O10-(2)","O10m2");
AGR.GNAN("O10-(2).2","O10m2d2");
AGR.GNAN("O10+(2)","O10p2");
AGR.GNAN("O10+(2).2","O10p2d2");

# projective special unitary and related groups
AGR.GNAN("U3(3)","U33");
AGR.GNAN("U3(3).2","U33d2");
AGR.GNAN("U3(4)","U34");
AGR.GNAN("U3(4).2","U34d2");
AGR.GNAN("U3(4).4","U34d4");
AGR.GNAN("U3(5)","U35");
AGR.GNAN("U3(5).2","U35d2");
AGR.GNAN("U3(5).3","U35d3");
AGR.GNAN("U3(7)","U37");
AGR.GNAN("U3(8)","U38");
AGR.GNAN("U3(8).2","U38d2");
AGR.GNAN("U3(8).3_1","U38d3a");
AGR.GNAN("U3(8).3_2","U38d3b");
AGR.GNAN("U3(8).3_3","U38d3c");
AGR.GNAN("U3(8).6","U38d6");
AGR.GNAN("U3(8).3^2","U38E9");
AGR.GNAN("U3(8).S3","U38S3");
AGR.GNAN("U3(8).(S3x3)","U38S3x3");
AGR.GNAN("3.U3(8)","3U38");
AGR.GNAN("U3(9)","U39");
AGR.GNAN("U3(11)","U311");
AGR.GNAN("U3(11).2","U311d2");
AGR.GNAN("3.U3(11)","3U311");
AGR.GNAN("3.U3(11).2","3U311d2");
AGR.GNAN("U3(13)","U313");
AGR.GNAN("U3(16)","U316");
AGR.GNAN("U4(2)","U42");
AGR.GNAN("U4(2).2","U42d2");
AGR.GNAN("2.U4(2)","2U42");
AGR.GNAN("2.U4(2).2","2U42d2");
AGR.GNAN("U4(3)","U43");
AGR.GNAN("U4(3).2_1","U43d21");
AGR.GNAN("U4(3).2_2","U43d22");
AGR.GNAN("U4(3).2_3","U43d23");
AGR.GNAN("U4(3).4","U43d4");
AGR.GNAN("U4(3).D8","U43D8");
AGR.GNAN("2.U4(3).D8","2U43D8");
AGR.GNAN("3^2.U4(3).D8","9U43D8");
AGR.GNAN("U4(4)","U44");
AGR.GNAN("U4(5)","U45");
AGR.GNAN("U5(2)","U52");
AGR.GNAN("U5(2).2","U52d2");
AGR.GNAN("U5(3)","U53");
AGR.GNAN("U5(4)","U54");
AGR.GNAN("U6(2)","U62");
AGR.GNAN("U6(2).2","U62d2");
AGR.GNAN("U6(2).3","U62d3");
AGR.GNAN("U6(2).S3","U62S3");
AGR.GNAN("2.U6(2)","2U62");
AGR.GNAN("3.U6(2)","3U62");
AGR.GNAN("6.U6(2)","6U62");
AGR.GNAN("2^2.U6(2)","4U62");
AGR.GNAN("(2^2x3).U6(2)","12U62");
AGR.GNAN("U6(3)","U63");
AGR.GNAN("U7(2)","U72");
AGR.GNAN("2^14.U7(2)","214U72");
AGR.GNAN("U8(2)","U82");

# exceptional and related groups
AGR.GNAN("E6(2)","E62");
AGR.GNAN("E6(4)","E64");
AGR.GNAN("E6(4).2","E64d2");
AGR.GNAN("3.E6(4)","3E64");
AGR.GNAN("3.E6(4).2","3E64d2");
AGR.GNAN("E7(2)","E72");
AGR.GNAN("E7(4)","E74");
AGR.GNAN("E8(2)","E82");
AGR.GNAN("E8(5)","E85");
AGR.GNAN("F4(2)","F42");
AGR.GNAN("F4(2).2","F42d2");
AGR.GNAN("2.F4(2)","2F42");
AGR.GNAN("2.F4(2).2","2F42d2");
AGR.GNAN("2.(2xF4(2)).2","2F42d4i");
AGR.GNAN("G2(3)","G23");
AGR.GNAN("G2(3).2","G23d2");
AGR.GNAN("3.G2(3)","3G23");
AGR.GNAN("3.G2(3).2","3G23d2");
AGR.GNAN("G2(4)","G24");
AGR.GNAN("G2(4).2","G24d2");
AGR.GNAN("2.G2(4)","2G24");
AGR.GNAN("2.G2(4).2","2G24d2");
AGR.GNAN("Isoclinic(2.G2(4).2)","2G24d2i");
AGR.GNAN("G2(5)","G25");
AGR.GNAN("R(27)","R27");
AGR.GNAN("R(27).3","R27d3");
AGR.GNAN("Sz(32)","Sz32");
AGR.GNAN("Sz(32).5","Sz32d5");
AGR.GNAN("Sz(8)","Sz8");
AGR.GNAN("Sz(8).3","Sz8d3");
AGR.GNAN("2.Sz(8)","2Sz8");
AGR.GNAN("2^2.Sz(8).3","4Sz8d3");

# twisted and related groups
AGR.GNAN("3D4(2)","TD42");
AGR.GNAN("3D4(2).3","TD42d3");
AGR.GNAN("3D4(3)","TD43");
AGR.GNAN("2E6(2)","TE62");
AGR.GNAN("2E6(2).2","TE62d2");
AGR.GNAN("2E6(2).3","TE62d3");
AGR.GNAN("2E6(2).S3","TE62S3");
AGR.GNAN("2.2E6(2)","2TE62");
AGR.GNAN("2.2E6(2).2","2TE62d2");
AGR.GNAN("2^2.2E6(2)","4TE62");
AGR.GNAN("3.2E6(2)","3TE62");
AGR.GNAN("3.2E6(2).2","3TE62d2");
AGR.GNAN("3.2E6(2).3","3TE62d3");
AGR.GNAN("3.2E6(2).S3","3TE62S3");
AGR.GNAN("2F4(2)'","TF42");
AGR.GNAN("2F4(2)'.2","TF42d2");

# projective special linear and related groups
AGR.GNAN("L2(8)","L28");
AGR.GNAN("L2(8).3","L28d3");
AGR.GNAN("L2(11)","L211");
AGR.GNAN("L2(11).2","L211d2");
AGR.GNAN("2.L2(11)","2L211");
AGR.GNAN("L2(13)","L213");
AGR.GNAN("L2(13).2","L213d2");
AGR.GNAN("2.L2(13)","2L213");
AGR.GNAN("2.L2(13).2","2L213d2");
AGR.GNAN("L2(16)","L216");
AGR.GNAN("L2(16).2","L216d2");
AGR.GNAN("L2(16).4","L216d4");
AGR.GNAN("L2(17)","L217");
AGR.GNAN("L2(17).2","L217d2");
AGR.GNAN("2.L2(17)","2L217");
AGR.GNAN("2.L2(17).2","2L217d2");
AGR.GNAN("L2(19)","L219");
AGR.GNAN("L2(19).2","L219d2");
AGR.GNAN("2.L2(19)","2L219");
AGR.GNAN("Isoclinic(2.L2(19).2)","2L219d2i");
AGR.GNAN("L2(23)","L223");
AGR.GNAN("L2(23).2","L223d2");
AGR.GNAN("2.L2(23)","2L223");
AGR.GNAN("Isoclinic(2.L2(23).2)","2L223d2i");
AGR.GNAN("L2(25)","L225");
AGR.GNAN("L2(25).2_1","L225d21");
AGR.GNAN("L2(25).2_2","L225d22");
AGR.GNAN("L2(25).2_3","L225d23");
AGR.GNAN("2.L2(25)","2L225");
AGR.GNAN("L2(27)","L227");
AGR.GNAN("L2(27).2","L227d2");
AGR.GNAN("L2(27).3","L227d3");
AGR.GNAN("L2(27).6","L227d6");
AGR.GNAN("2.L2(27)","2L227");
AGR.GNAN("L2(29)","L229");
AGR.GNAN("L2(29).2","L229d2");
AGR.GNAN("2.L2(29)","2L229");
AGR.GNAN("L2(31)","L231");
AGR.GNAN("L2(31).2","L231d2");
AGR.GNAN("2.L2(31)","2L231");
AGR.GNAN("L2(32)","L232");
AGR.GNAN("L2(32).5","L232d5");
AGR.GNAN("L2(37)","L237");
AGR.GNAN("2.L2(37)","2L237");
AGR.GNAN("L2(41)","L241");
AGR.GNAN("2.L2(41)","2L241");
AGR.GNAN("L2(43)","L243");
AGR.GNAN("2.L2(43)","2L243");
AGR.GNAN("L2(47)","L247");
AGR.GNAN("2.L2(47)","2L247");
AGR.GNAN("L2(49)","L249");
AGR.GNAN("2.L2(49)","2L249");
AGR.GNAN("L2(53)","L253");
AGR.GNAN("2.L2(53)","2L253");
AGR.GNAN("L2(59)","L259");
AGR.GNAN("2.L2(59)","2L259");
AGR.GNAN("L2(61)","L261");
AGR.GNAN("2.L2(61)","2L261");
AGR.GNAN("L2(64)","L264");
AGR.GNAN("L2(67)","L267");
AGR.GNAN("2.L2(67)","2L267");
AGR.GNAN("L2(71)","L271");
AGR.GNAN("2.L2(71)","2L271");
AGR.GNAN("L2(73)","L273");
AGR.GNAN("2.L2(73)","2L273");
AGR.GNAN("L2(79)","L279");
AGR.GNAN("2.L2(79)","2L279");
AGR.GNAN("L2(81)","L281");
AGR.GNAN("L2(83)","L283");
AGR.GNAN("2.L2(83)","2L283");
AGR.GNAN("L2(89)","L289");
AGR.GNAN("2.L2(89)","2L289");
AGR.GNAN("L2(97)","L297");
AGR.GNAN("2.L2(97)","2L297");
AGR.GNAN("L2(101)","L2101");
AGR.GNAN("2.L2(101)","2L2101");
AGR.GNAN("L2(103)","L2103");
AGR.GNAN("2.L2(103)","2L2103");
AGR.GNAN("L2(107)","L2107");
AGR.GNAN("2.L2(107)","2L2107");
AGR.GNAN("L2(109)","L2109");
AGR.GNAN("2.L2(109)","2L2109");
AGR.GNAN("L2(113)","L2113");
AGR.GNAN("2.L2(113)","2L2113");
AGR.GNAN("L2(127)","L2127");
AGR.GNAN("2.L2(127)","2L2127");
AGR.GNAN("2.L2(131)","2L2131");
AGR.GNAN("L2(128)","L2128");
AGR.GNAN("L2(131)","L2131");
AGR.GNAN("L2(137)","L2137");
AGR.GNAN("2.L2(137)","2L2137");
AGR.GNAN("L2(139)","L2139");
AGR.GNAN("2.L2(139)","2L2139");
AGR.GNAN("L2(149)","L2149");
AGR.GNAN("2.L2(149)","2L2149");
AGR.GNAN("L2(151)","L2151");
AGR.GNAN("2.L2(151)","2L2151");
AGR.GNAN("L2(157)","L2157");
AGR.GNAN("2.L2(157)","2L2157");
AGR.GNAN("L2(163)","L2163");
AGR.GNAN("2.L2(163)","2L2163");
AGR.GNAN("L2(167)","L2167");
AGR.GNAN("2.L2(167)","2L2167");
AGR.GNAN("L2(173)","L2173");
AGR.GNAN("2.L2(173)","2L2173");
AGR.GNAN("L2(179)","L2179");
AGR.GNAN("2.L2(179)","2L2179");
AGR.GNAN("L2(181)","L2181");
AGR.GNAN("2.L2(181)","2L2181");
AGR.GNAN("L2(191)","L2191");
AGR.GNAN("2.L2(191)","2L2191");
AGR.GNAN("L2(193)","L2193");
AGR.GNAN("2.L2(193)","2L2193");
AGR.GNAN("L2(197)","L2197");
AGR.GNAN("2.L2(197)","2L2197");
AGR.GNAN("L2(199)","L2199");
AGR.GNAN("2.L2(199)","2L2199");
AGR.GNAN("L2(211)","L2211");
AGR.GNAN("2.L2(211)","2L2211");
AGR.GNAN("L2(223)","L2223");
AGR.GNAN("2.L2(223)","2L2223");
AGR.GNAN("L2(227)","L2227");
AGR.GNAN("2.L2(227)","2L2227");
AGR.GNAN("L2(229)","L2229");
AGR.GNAN("2.L2(229)","2L2229");
AGR.GNAN("L2(233)","L2233");
AGR.GNAN("2.L2(233)","2L2233");
AGR.GNAN("L2(239)","L2239");
AGR.GNAN("2.L2(239)","2L2239");
AGR.GNAN("L2(241)","L2241");
AGR.GNAN("2.L2(241)","2L2241");
AGR.GNAN("L3(2)","L27");
AGR.GNAN("L3(2).2","L27d2");
AGR.GNAN("2.L3(2)","2L27");
AGR.GNAN("2.L3(2).2","2L27d2");
AGR.GNAN("Isoclinic(2.L3(2).2)","2L27d2i");
AGR.GNAN("L3(3)","L33");
AGR.GNAN("L3(3).2","L33d2");
AGR.GNAN("L3(4)","L34");
AGR.GNAN("L3(4).2_1","L34d2a");
AGR.GNAN("L3(4).2_2","L34d2b");
AGR.GNAN("L3(4).2_3","L34d2c");
AGR.GNAN("L3(4).3","L34d3");
AGR.GNAN("L3(4).6","L34d6");
AGR.GNAN("L3(4).2^2","L34V4");
AGR.GNAN("L3(4).D12","L34D12");
AGR.GNAN("2.L3(4)","2L34");
AGR.GNAN("2.L3(4).2_1","2L34d2a");
AGR.GNAN("3.L3(4)","3L34");
AGR.GNAN("3.L3(4).2_1","3L34d2a");
AGR.GNAN("2^2.L3(4)","4L34");
AGR.GNAN("2^2.L3(4).2_2","4L34d2b");
AGR.GNAN("4_1.L3(4)","4aL34");
AGR.GNAN("4_1.L3(4).2_1","4aL34d2a");
AGR.GNAN("4_2.L3(4)","4bL34");
AGR.GNAN("4_2.L3(4).2_1","4bL34d2a");
AGR.GNAN("6.L3(4)","6L34");
AGR.GNAN("6.L3(4).2_1","6L34d2a");
AGR.GNAN("12_1.L3(4)","12aL34");
AGR.GNAN("12_1.L3(4).2_1","12aL34d2a");
AGR.GNAN("12_2.L3(4)","12bL34");
AGR.GNAN("12_2.L3(4).2_1","12bL34d2a");
AGR.GNAN("L3(5)","L35");
AGR.GNAN("L3(5).2","L35d2");
AGR.GNAN("L3(7)","L37");
AGR.GNAN("L3(7).2","L37d2");
AGR.GNAN("L3(7).3","L37d3");
AGR.GNAN("3.L3(7)","3L37");
AGR.GNAN("3.L3(7).2","3L37d2");
AGR.GNAN("L3(8)","L38");
AGR.GNAN("L3(8).2","L38d2");
AGR.GNAN("L3(8).3","L38d3");
AGR.GNAN("L3(8).6","L38d6");
AGR.GNAN("L3(9)","L39");
AGR.GNAN("L3(9).2_1","L39d21");
AGR.GNAN("L3(9).2_2","L39d22");
AGR.GNAN("L3(9).2_3","L39d23");
AGR.GNAN("L3(11)","L311");
AGR.GNAN("L3(13)","L313");
AGR.GNAN("L4(3)","L43");
AGR.GNAN("L4(3).2_1","L43d21");
AGR.GNAN("L4(3).2_2","L43d22");
AGR.GNAN("L4(3).2_3","L43d23");
AGR.GNAN("L4(4)","L44");
AGR.GNAN("L4(5)","L45");
AGR.GNAN("L5(2)","L52");
AGR.GNAN("L5(2).2","L52d2");
AGR.GNAN("L5(3)","L53");
AGR.GNAN("L6(2)","L62");
AGR.GNAN("L6(2).2","L62d2");
AGR.GNAN("L7(2)","L72");
AGR.GNAN("L7(2).2","L72d2");
AGR.GNAN("2^4.A8","24A8");
AGR.GNAN("2^5.L5(2)","25L52");
AGR.GNAN("5^3.L3(5)","53L35");

# sporadic simple and related groups
AGR.GNAN("B","B");
AGR.GNAN("2.B","2B");
AGR.GNAN("Co1","Co1");
AGR.GNAN("2.Co1","2Co1");
AGR.GNAN("Co2","Co2");
AGR.GNAN("Co3","Co3");
AGR.GNAN("Fi22","F22");
AGR.GNAN("Fi22.2","F22d2");
AGR.GNAN("2.Fi22","2F22");
AGR.GNAN("2.Fi22.2","2F22d2");
AGR.GNAN("Isoclinic(2.Fi22.2)","2F22d2i");
AGR.GNAN("3.Fi22","3F22");
AGR.GNAN("3.Fi22.2","3F22d2");
AGR.GNAN("6.Fi22","6F22");
AGR.GNAN("6.Fi22.2","6F22d2");
AGR.GNAN("Isoclinic(6.Fi22.2)","6F22d2i");
AGR.GNAN("Fi23","F23");
AGR.GNAN("3.Fi24'","3F24");
AGR.GNAN("3.Fi24'.2","3F24d2");
AGR.GNAN("Fi24'","F24");
AGR.GNAN("Fi24'.2","F24d2");
AGR.GNAN("HN","HN");
AGR.GNAN("HN.2","HNd2");
AGR.GNAN("HS","HS");
AGR.GNAN("HS.2","HSd2");
AGR.GNAN("2.HS","2HS");
AGR.GNAN("2.HS.2","2HSd2");
AGR.GNAN("Isoclinic(2.HS.2)","2HSd2i");
AGR.GNAN("He","He");
AGR.GNAN("He.2","Hed2");
AGR.GNAN("J1","J1");
AGR.GNAN("J2","J2");
AGR.GNAN("J2.2","J2d2");
AGR.GNAN("2.J2","2J2");
AGR.GNAN("2.J2.2","2J2d2");
AGR.GNAN("Isoclinic(2.J2.2)","2J2d2i");
AGR.GNAN("J3","J3");
AGR.GNAN("J3.2","J3d2");
AGR.GNAN("3.J3","3J3");
AGR.GNAN("3.J3.2","3J3d2");
AGR.GNAN("J4","J4");
AGR.GNAN("Ly","Ly");
AGR.GNAN("M","M");
AGR.GNAN("M11","M11");
AGR.GNAN("M12","M12");
AGR.GNAN("M12.2","M12d2");
AGR.GNAN("2.M12","2M12");
AGR.GNAN("2.M12.2","2M12d2");
AGR.GNAN("Isoclinic(2.M12.2)","2M12d2i");
AGR.GNAN("M22","M22");
AGR.GNAN("M22.2","M22d2");
AGR.GNAN("2.M22","2M22");
AGR.GNAN("2.M22.2","2M22d2");
AGR.GNAN("Isoclinic(2.M22.2)","2M22d2i");
AGR.GNAN("3.M22","3M22");
AGR.GNAN("3.M22.2","3M22d2");
AGR.GNAN("4.M22","4M22");
AGR.GNAN("4.M22.2","4M22d2");
AGR.GNAN("Isoclinic(4.M22.2)","4M22d2i");
AGR.GNAN("6.M22","6M22");
AGR.GNAN("6.M22.2","6M22d2");
AGR.GNAN("Isoclinic(6.M22.2)","6M22d2i");
AGR.GNAN("12.M22","12M22");
AGR.GNAN("12.M22.2","12M22d2");
AGR.GNAN("Isoclinic(12.M22.2)","12M22d2i");
AGR.GNAN("M23","M23");
AGR.GNAN("M24","M24");
AGR.GNAN("McL","McL");
AGR.GNAN("McL.2","McLd2");
AGR.GNAN("3.McL","3McL");
AGR.GNAN("3.McL.2","3McLd2");
AGR.GNAN("ON","ON");
AGR.GNAN("ON.2","ONd2");
AGR.GNAN("ON.4","ONd4");
AGR.GNAN("3.ON","3ON");
AGR.GNAN("3.ON.2","3ONd2");
AGR.GNAN("Ru","Ru");
AGR.GNAN("2.Ru","2Ru");
AGR.GNAN("Suz","Suz");
AGR.GNAN("Suz.2","Suzd2");
AGR.GNAN("2.Suz","2Suz");
AGR.GNAN("2.Suz.2","2Suzd2");
AGR.GNAN("Isoclinic(2.Suz.2)","2Suzd2i");
AGR.GNAN("3.Suz","3Suz");
AGR.GNAN("3.Suz.2","3Suzd2");
AGR.GNAN("6.Suz","6Suz");
AGR.GNAN("6.Suz.2","6Suzd2");
AGR.GNAN("Isoclinic(6.Suz.2)","6Suzd2i");
AGR.GNAN("Th","Th");

# maximal subgroups of the Monster
AGR.GNAN("2^(1+24).Co1","Mmax2");
AGR.GNAN("2^2.2E6(2).S3","Mmax4");
AGR.GNAN("2^(10+16).O10+(2)","Mmax5");
AGR.GNAN("2^(2+11+22).(M24xS3)","Mmax6");
AGR.GNAN("3^(1+12):6.Suz.2","M3max7");
AGR.GNAN("3^(1+12):2.Suz.2","Mmax7");
AGR.GNAN("2^(5+10+20).(S3xL5(2))","Mmax8");
AGR.GNAN("S3xTh","Mmax9");
AGR.GNAN("2^[39].(L3(2)x3.S6)","Mmax10");
AGR.GNAN("3^8.O8-(3).2_3","Mmax11");
AGR.GNAN("(D10xHN).2","Mmax12");
AGR.GNAN("(3^2:2xO8+(3)).S4","Mmax13");
AGR.GNAN("3^(2+5+10).(M11x2S4)","Mmax14");
AGR.GNAN("3^(3+2+6+6):(L3(3)xSD16)","Mmax15");
AGR.GNAN("3^(2+6+6):(L3(3)xSD16)","Mmax15q1");
AGR.GNAN("3^(6+6):(L3(3)xSD16)","Mmax15q2");
AGR.GNAN("3^6:(L3(3)xSD16)","Mmax15q3");
AGR.GNAN("5^(1+6):2.J2.4","Mmax16");
AGR.GNAN("(7:3xHe):2","Mmax17");
AGR.GNAN("(A5xA12):2","Mmax18");
AGR.GNAN("5^(3+3).(2xL3(5))","Mmax19");
AGR.GNAN("(A6xA6xA6).(2xS4)","Mmax20");
AGR.GNAN("(A5xU3(8):3):2","Mmax21");
AGR.GNAN("5^(2+2+4):(S3xGL2(5))","Mmax22");
AGR.GNAN("(L3(2)xS4(4):2).2","Mmax23");
AGR.GNAN("7^(1+4):(3x2.S7)","Mmax24");
AGR.GNAN("(5^2:[2^4]xU3(5)).S3","Mmax25");
AGR.GNAN("(L2(11)xM12):2","Mmax26");
AGR.GNAN("(A7x(A5xA5).4).2","Mmax27");
AGR.GNAN("5^4:(3x2.L2(25)).2","Mmax28");
AGR.GNAN("7^(2+1+2):GL2(7)","Mmax29");
AGR.GNAN("M11xA6.2^2","Mmax30");
AGR.GNAN("(S5xS5xS5):S3","Mmax31");
AGR.GNAN("(L2(11)xL2(11)):4","Mmax32");
AGR.GNAN("13^2:2.L2(13).4","Mmax33");
AGR.GNAN("(7^2:(3x2A4)xL2(7)).2","Mmax34");
AGR.GNAN("(13:6xL3(3)).2","Mmax35");
AGR.GNAN("13^(1+2):(3x4S4)","Mmax36");
AGR.GNAN("11^2:(5x2A5)","Mmax39");
AGR.GNAN("7^2:2.L2(7)","Mmax41");
AGR.GNAN("41:40","Mmax43");

# miscellaneous groups
AGR.GNAN("W(F4)","WF4");


#############################################################################
##
##  Bind the list of names in display order.
##
AGR.SetGAPnamesSortDisp();


#############################################################################
##
##  Store group orders.
##
AGR.GRS("(13:6xL3(3)).2",876096);
AGR.GRS("(2^2x3).U6(2)",110361968640);
AGR.GRS("(3^2:2xO8+(3)).S4",2139341679820800);
AGR.GRS("(5^2:[2^4]xU3(5)).S3",302400000);
AGR.GRS("(7:3xHe):2",169276262400);
AGR.GRS("(7^2:(3x2A4)xL2(7)).2",1185408);
AGR.GRS("(A5xA12):2",28740096000);
AGR.GRS("(A5xU3(8):3):2",1985679360);
AGR.GRS("(A6xA6xA6).(2xS4)",2239488000);
AGR.GRS("(A7x(A5xA5).4).2",72576000);
AGR.GRS("(D10xHN).2",5460618240000000);
AGR.GRS("(L2(11)xL2(11)):4",1742400);
AGR.GRS("(L2(11)xM12):2",125452800);
AGR.GRS("(L3(2)xS4(4):2).2",658022400);
AGR.GRS("(S5xS5xS5):S3",10368000);
AGR.GRS("11^2:(5x2A5)",72600);
AGR.GRS("12.M22",5322240);
AGR.GRS("12.M22.2",10644480);
AGR.GRS("12_1.L3(4)",241920);
AGR.GRS("12_1.L3(4).2_1",483840);
AGR.GRS("12_2.L3(4)",241920);
AGR.GRS("12_2.L3(4).2_1",483840);
AGR.GRS("13^(1+2):(3x4S4)",632736);
AGR.GRS("13^2:2.L2(13).4",1476384);
AGR.GRS("2.(2xF4(2)).2",26489012826931200);
AGR.GRS("2.2E6(2)",153064959367549707878400);
AGR.GRS("2.2E6(2).2",306129918735099415756800);
AGR.GRS("2.A10",3628800);
AGR.GRS("2.A10.2",7257600);
AGR.GRS("2.A11",39916800);
AGR.GRS("2.A11.2",79833600);
AGR.GRS("2.A12",479001600);
AGR.GRS("2.A12.2",958003200);
AGR.GRS("2.A13",6227020800);
AGR.GRS("2.A13.2",12454041600);
AGR.GRS("2.A14",87178291200);
AGR.GRS("2.A14.2",174356582400);
AGR.GRS("2.A5",120);
AGR.GRS("2.A5.2",240);
AGR.GRS("2.A6",720);
AGR.GRS("2.A6.2_1",1440);
AGR.GRS("2.A7",5040);
AGR.GRS("2.A7.2",10080);
AGR.GRS("2.A8",40320);
AGR.GRS("2.A8.2",80640);
AGR.GRS("2.A9",362880);
AGR.GRS("2.A9.2",725760);
AGR.GRS("2.B",8309562962452852382355161088000000);
AGR.GRS("2.Co1",8315553613086720000);
AGR.GRS("2.F4(2)",6622253206732800);
AGR.GRS("2.F4(2).2",13244506413465600);
AGR.GRS("2.Fi22",129123503308800);
AGR.GRS("2.Fi22.2",258247006617600);
AGR.GRS("2.G2(4)",503193600);
AGR.GRS("2.G2(4).2",1006387200);
AGR.GRS("2.HS",88704000);
AGR.GRS("2.HS.2",177408000);
AGR.GRS("2.J2",1209600);
AGR.GRS("2.J2.2",2419200);
AGR.GRS("2.L2(101)",1030200);
AGR.GRS("2.L2(103)",1092624);
AGR.GRS("2.L2(107)",1224936);
AGR.GRS("2.L2(109)",1294920);
AGR.GRS("2.L2(11)",1320);
AGR.GRS("2.L2(113)",1442784);
AGR.GRS("2.L2(127)",2048256);
AGR.GRS("2.L2(13)",2184);
AGR.GRS("2.L2(13).2",4368);
AGR.GRS("2.L2(131)",2247960);
AGR.GRS("2.L2(137)",2571216);
AGR.GRS("2.L2(139)",2685480);
AGR.GRS("2.L2(149)",3307800);
AGR.GRS("2.L2(151)",3442800);
AGR.GRS("2.L2(157)",3869736);
AGR.GRS("2.L2(163)",4330584);
AGR.GRS("2.L2(167)",4657296);
AGR.GRS("2.L2(17)",4896);
AGR.GRS("2.L2(17).2",9792);
AGR.GRS("2.L2(173)",5177544);
AGR.GRS("2.L2(179)",5735160);
AGR.GRS("2.L2(181)",5929560);
AGR.GRS("2.L2(19)",6840);
AGR.GRS("2.L2(191)",6967680);
AGR.GRS("2.L2(193)",7188864);
AGR.GRS("2.L2(197)",7645176);
AGR.GRS("2.L2(199)",7880400);
AGR.GRS("2.L2(211)",9393720);
AGR.GRS("2.L2(223)",11089344);
AGR.GRS("2.L2(227)",11696856);
AGR.GRS("2.L2(229)",12008760);
AGR.GRS("2.L2(23)",12144);
AGR.GRS("2.L2(233)",12649104);
AGR.GRS("2.L2(239)",13651680);
AGR.GRS("2.L2(241)",13997280);
AGR.GRS("2.L2(25)",15600);
AGR.GRS("2.L2(27)",19656);
AGR.GRS("2.L2(29)",24360);
AGR.GRS("2.L2(31)",29760);
AGR.GRS("2.L2(37)",50616);
AGR.GRS("2.L2(41)",68880);
AGR.GRS("2.L2(43)",79464);
AGR.GRS("2.L2(47)",103776);
AGR.GRS("2.L2(49)",117600);
AGR.GRS("2.L2(53)",148824);
AGR.GRS("2.L2(59)",205320);
AGR.GRS("2.L2(61)",226920);
AGR.GRS("2.L2(67)",300696);
AGR.GRS("2.L2(71)",357840);
AGR.GRS("2.L2(73)",388944);
AGR.GRS("2.L2(79)",492960);
AGR.GRS("2.L2(83)",571704);
AGR.GRS("2.L2(89)",704880);
AGR.GRS("2.L2(97)",912576);
AGR.GRS("2.L3(2)",336);
AGR.GRS("2.L3(2).2",672);
AGR.GRS("2.L3(4)",40320);
AGR.GRS("2.L3(4).2_1",80640);
AGR.GRS("2.M12",190080);
AGR.GRS("2.M12.2",380160);
AGR.GRS("2.M22",887040);
AGR.GRS("2.M22.2",1774080);
AGR.GRS("2.O7(3)",9170703360);
AGR.GRS("2.O7(3).2",18341406720);
AGR.GRS("2.O8+(2)",348364800);
AGR.GRS("2.O8+(2).2",696729600);
AGR.GRS("2.O8+(3)",9904359628800);
AGR.GRS("2.O8-(3)",20303937239040);
AGR.GRS("2.O8-(3).2_1",40607874478080);
AGR.GRS("2.O9(3)",131569513308979200);
AGR.GRS("2.O9(3).2",263139026617958400);
AGR.GRS("2.Ru",291852288000);
AGR.GRS("2.S4(11)",25721308800);
AGR.GRS("2.S4(13)",137037962880);
AGR.GRS("2.S4(17)",2008994088960);
AGR.GRS("2.S4(19)",6114035779200);
AGR.GRS("2.S4(5)",9360000);
AGR.GRS("2.S4(7)",276595200);
AGR.GRS("2.S4(7).2",553190400);
AGR.GRS("2.S4(9)",3443212800);
AGR.GRS("2.S6(2)",2903040);
AGR.GRS("2.S6(3)",9170703360);
AGR.GRS("2.S6(3).2",18341406720);
AGR.GRS("2.Suz",896690995200);
AGR.GRS("2.Suz.2",1793381990400);
AGR.GRS("2.Sz(8)",58240);
AGR.GRS("2.U4(2)",51840);
AGR.GRS("2.U4(2).2",103680);
AGR.GRS("2.U4(3).D8",52254720);
AGR.GRS("2.U6(2)",18393661440);
AGR.GRS("2E6(2)",76532479683774853939200);
AGR.GRS("2E6(2).2",153064959367549707878400);
AGR.GRS("2E6(2).3",229597439051324561817600);
AGR.GRS("2E6(2).S3",459194878102649123635200);
AGR.GRS("2F4(2)'",17971200);
AGR.GRS("2F4(2)'.2",35942400);
AGR.GRS("2^(1+24).Co1",139511839126336328171520000);
AGR.GRS("2^(10+16).O10+(2)",1577011055923770163200);
AGR.GRS("2^(2+11+22).(M24xS3)",50472333605150392320);
AGR.GRS("2^(5+10+20).(S3xL5(2))",2061452360684666880);
AGR.GRS("2^14.U7(2)",3732063900024176640);
AGR.GRS("2^2.2E6(2)",306129918735099415756800);
AGR.GRS("2^2.2E6(2).S3",1836779512410596494540800);
AGR.GRS("2^2.L3(4)",80640);
AGR.GRS("2^2.L3(4).2_2",161280);
AGR.GRS("2^2.O8+(3).S4",475409262182400);
AGR.GRS("2^2.Sz(8).3",349440);
AGR.GRS("2^2.U6(2)",36787322880);
AGR.GRS("2^4.A8",322560);
AGR.GRS("2^5.L5(2)",319979520);
AGR.GRS("2^[39].(L3(2)x3.S6)",199495389743677440);
AGR.GRS("2aM20",1920);
AGR.GRS("2bM20",1920);
AGR.GRS("2cM20",1920);
AGR.GRS("3.2E6(2)",229597439051324561817600);
AGR.GRS("3.2E6(2).2",459194878102649123635200);
AGR.GRS("3.2E6(2).3",688792317153973685452800);
AGR.GRS("3.2E6(2).S3",1377584634307947370905600);
AGR.GRS("3.A6",1080);
AGR.GRS("3.A6.2_1",2160);
AGR.GRS("3.A7",7560);
AGR.GRS("3.A7.2",15120);
AGR.GRS("3.E6(4)",85528710781342640103833619055142765466746880000);
AGR.GRS("3.E6(4).2",171057421562685280207667238110285530933493760000);
AGR.GRS("3.Fi22",193685254963200);
AGR.GRS("3.Fi22.2",387370509926400);
AGR.GRS("3.Fi24'",3765617127571985163878400);
AGR.GRS("3.Fi24'.2",7531234255143970327756800);
AGR.GRS("3.G2(3)",12737088);
AGR.GRS("3.G2(3).2",25474176);
AGR.GRS("3.J3",150698880);
AGR.GRS("3.J3.2",301397760);
AGR.GRS("3.L3(4)",60480);
AGR.GRS("3.L3(4).2_1",120960);
AGR.GRS("3.L3(7)",5630688);
AGR.GRS("3.L3(7).2",11261376);
AGR.GRS("3.M22",1330560);
AGR.GRS("3.M22.2",2661120);
AGR.GRS("3.McL",2694384000);
AGR.GRS("3.McL.2",5388768000);
AGR.GRS("3.O7(3)",13756055040);
AGR.GRS("3.O7(3).2",27512110080);
AGR.GRS("3.ON",1382446517760);
AGR.GRS("3.ON.2",2764893035520);
AGR.GRS("3.Suz",1345036492800);
AGR.GRS("3.Suz.2",2690072985600);
AGR.GRS("3.U3(11)",212747040);
AGR.GRS("3.U3(11).2",425494080);
AGR.GRS("3.U3(8)",16547328);
AGR.GRS("3.U6(2)",27590492160);
AGR.GRS("3D4(2)",211341312);
AGR.GRS("3D4(2).3",634023936);
AGR.GRS("3D4(3)",20560831566912);
AGR.GRS("3^(1+12):2.Suz.2",2859230155080499200);
AGR.GRS("3^(1+12):6.Suz.2",8577690465241497600);
AGR.GRS("3^(2+5+10).(M11x2S4)",49093924366080);
AGR.GRS("3^(2+6+6):(L3(3)xSD16)",429778462464);
AGR.GRS("3^(3+2+6+6):(L3(3)xSD16)",11604018486528);
AGR.GRS("3^(6+6):(L3(3)xSD16)",47753162496);
AGR.GRS("3^2.U4(3).D8",235146240);
AGR.GRS("3^6:(L3(3)xSD16)",65505024);
AGR.GRS("3^8.O8-(3).2_3",133214132225341440);
AGR.GRS("4.M22",1774080);
AGR.GRS("4.M22.2",3548160);
AGR.GRS("41:40",1640);
AGR.GRS("4_1.L3(4)",80640);
AGR.GRS("4_1.L3(4).2_1",161280);
AGR.GRS("4_2.L3(4)",80640);
AGR.GRS("4_2.L3(4).2_1",161280);
AGR.GRS("4bM20",3840);
AGR.GRS("5^(1+6):2.J2.4",378000000000);
AGR.GRS("5^(2+2+4):(S3xGL2(5))",1125000000);
AGR.GRS("5^(3+3).(2xL3(5))",11625000000);
AGR.GRS("5^3.L3(5)",46500000);
AGR.GRS("5^4:(3x2.L2(25)).2",58500000);
AGR.GRS("6.A6",2160);
AGR.GRS("6.A6.2_1",4320);
AGR.GRS("6.A7",15120);
AGR.GRS("6.A7.2",30240);
AGR.GRS("6.Fi22",387370509926400);
AGR.GRS("6.Fi22.2",774741019852800);
AGR.GRS("6.L3(4)",120960);
AGR.GRS("6.L3(4).2_1",241920);
AGR.GRS("6.M22",2661120);
AGR.GRS("6.M22.2",5322240);
AGR.GRS("6.O7(3)",27512110080);
AGR.GRS("6.O7(3).2",55024220160);
AGR.GRS("6.Suz",2690072985600);
AGR.GRS("6.Suz.2",5380145971200);
AGR.GRS("6.U6(2)",55180984320);
AGR.GRS("7^(1+4):(3x2.S7)",508243680);
AGR.GRS("7^(2+1+2):GL2(7)",33882912);
AGR.GRS("7^2:2.L2(7)",16464);
AGR.GRS("A10",1814400);
AGR.GRS("A10.2",3628800);
AGR.GRS("A11",19958400);
AGR.GRS("A11.2",39916800);
AGR.GRS("A12",239500800);
AGR.GRS("A12.2",479001600);
AGR.GRS("A13",3113510400);
AGR.GRS("A13.2",6227020800);
AGR.GRS("A14",43589145600);
AGR.GRS("A14.2",87178291200);
AGR.GRS("A15",653837184000);
AGR.GRS("A15.2",1307674368000);
AGR.GRS("A16",10461394944000);
AGR.GRS("A16.2",20922789888000);
AGR.GRS("A17",177843714048000);
AGR.GRS("A17.2",355687428096000);
AGR.GRS("A18",3201186852864000);
AGR.GRS("A18.2",6402373705728000);
AGR.GRS("A19",60822550204416000);
AGR.GRS("A19.2",121645100408832000);
AGR.GRS("A20",1216451004088320000);
AGR.GRS("A20.2",2432902008176640000);
AGR.GRS("A21",25545471085854720000);
AGR.GRS("A21.2",51090942171709440000);
AGR.GRS("A22",562000363888803840000);
AGR.GRS("A22.2",1124000727777607680000);
AGR.GRS("A23",12926008369442488320000);
AGR.GRS("A23.2",25852016738884976640000);
AGR.GRS("A5",60);
AGR.GRS("A5.2",120);
AGR.GRS("A6",360);
AGR.GRS("A6.2^2",1440);
AGR.GRS("A6.2_1",720);
AGR.GRS("A6.2_2",720);
AGR.GRS("A6.2_3",720);
AGR.GRS("A7",2520);
AGR.GRS("A7.2",5040);
AGR.GRS("A8",20160);
AGR.GRS("A8.2",40320);
AGR.GRS("A9",181440);
AGR.GRS("A9.2",362880);
AGR.GRS("B",4154781481226426191177580544000000);
AGR.GRS("Co1",4157776806543360000);
AGR.GRS("Co2",42305421312000);
AGR.GRS("Co3",495766656000);
AGR.GRS("E6(2)",214841575522005575270400);
AGR.GRS("E6(4)",28509570260447546701277873018380921822248960000);
AGR.GRS("E6(4).2",57019140520895093402555746036761843644497920000);
AGR.GRS("E7(2)",337804753143634806261388190614085595079991692242467651576160959909068800000);
AGR.GRS("E7(4)",191797292142671717754639757897512906421357507604216557533558287598236977154127870984484770345340348298409697395609822849492217656441474908160000000000);
AGR.GRS("E8(2)",337804753143634806261388190614085595079991692242467651576160959909068800000);
AGR.GRS("E8(5)",212241934165081789939135106539938909320143178249948373703932419194549992287718687106371625640393677463164945340423628294956870377063751220703125000000000000000000000000000000);
AGR.GRS("F4(2)",3311126603366400);
AGR.GRS("F4(2).2",6622253206732800);
AGR.GRS("Fi22",64561751654400);
AGR.GRS("Fi22.2",129123503308800);
AGR.GRS("Fi23",4089470473293004800);
AGR.GRS("Fi24'",1255205709190661721292800);
AGR.GRS("Fi24'.2",2510411418381323442585600);
AGR.GRS("G2(3)",4245696);
AGR.GRS("G2(3).2",8491392);
AGR.GRS("G2(4)",251596800);
AGR.GRS("G2(4).2",503193600);
AGR.GRS("G2(5)",5859000000);
AGR.GRS("HN",273030912000000);
AGR.GRS("HN.2",546061824000000);
AGR.GRS("HS",44352000);
AGR.GRS("HS.2",88704000);
AGR.GRS("He",4030387200);
AGR.GRS("He.2",8060774400);
AGR.GRS("Isoclinic(12.M22.2)",10644480);
AGR.GRS("Isoclinic(2.A14.2)",174356582400);
AGR.GRS("Isoclinic(2.A5.2)",240);
AGR.GRS("Isoclinic(2.A7.2)",10080);
AGR.GRS("Isoclinic(2.A8.2)",80640);
AGR.GRS("Isoclinic(2.Fi22.2)",258247006617600);
AGR.GRS("Isoclinic(2.G2(4).2)",1006387200);
AGR.GRS("Isoclinic(2.HS.2)",177408000);
AGR.GRS("Isoclinic(2.J2.2)",2419200);
AGR.GRS("Isoclinic(2.L2(19).2)",13680);
AGR.GRS("Isoclinic(2.L2(23).2)",24288);
AGR.GRS("Isoclinic(2.L3(2).2)",672);
AGR.GRS("Isoclinic(2.M12.2)",380160);
AGR.GRS("Isoclinic(2.M22.2)",1774080);
AGR.GRS("Isoclinic(2.Suz.2)",1793381990400);
AGR.GRS("Isoclinic(4.M22.2)",3548160);
AGR.GRS("Isoclinic(6.Fi22.2)",774741019852800);
AGR.GRS("Isoclinic(6.M22.2)",5322240);
AGR.GRS("Isoclinic(6.Suz.2)",5380145971200);
AGR.GRS("J1",175560);
AGR.GRS("J2",604800);
AGR.GRS("J2.2",1209600);
AGR.GRS("J3",50232960);
AGR.GRS("J3.2",100465920);
AGR.GRS("J4",86775571046077562880);
AGR.GRS("L2(101)",515100);
AGR.GRS("L2(103)",546312);
AGR.GRS("L2(107)",612468);
AGR.GRS("L2(109)",647460);
AGR.GRS("L2(11)",660);
AGR.GRS("L2(11).2",1320);
AGR.GRS("L2(113)",721392);
AGR.GRS("L2(127)",1024128);
AGR.GRS("L2(128)",2097024);
AGR.GRS("L2(13)",1092);
AGR.GRS("L2(13).2",2184);
AGR.GRS("L2(131)",1123980);
AGR.GRS("L2(137)",1285608);
AGR.GRS("L2(139)",1342740);
AGR.GRS("L2(149)",1653900);
AGR.GRS("L2(151)",1721400);
AGR.GRS("L2(157)",1934868);
AGR.GRS("L2(16)",4080);
AGR.GRS("L2(16).2",8160);
AGR.GRS("L2(16).4",16320);
AGR.GRS("L2(163)",2165292);
AGR.GRS("L2(167)",2328648);
AGR.GRS("L2(17)",2448);
AGR.GRS("L2(17).2",4896);
AGR.GRS("L2(173)",2588772);
AGR.GRS("L2(179)",2867580);
AGR.GRS("L2(181)",2964780);
AGR.GRS("L2(19)",3420);
AGR.GRS("L2(19).2",6840);
AGR.GRS("L2(191)",3483840);
AGR.GRS("L2(193)",3594432);
AGR.GRS("L2(197)",3822588);
AGR.GRS("L2(199)",3940200);
AGR.GRS("L2(211)",4696860);
AGR.GRS("L2(223)",5544672);
AGR.GRS("L2(227)",5848428);
AGR.GRS("L2(229)",6004380);
AGR.GRS("L2(23)",6072);
AGR.GRS("L2(23).2",12144);
AGR.GRS("L2(233)",6324552);
AGR.GRS("L2(239)",6825840);
AGR.GRS("L2(241)",6998640);
AGR.GRS("L2(25)",7800);
AGR.GRS("L2(25).2_1",15600);
AGR.GRS("L2(25).2_2",15600);
AGR.GRS("L2(25).2_3",15600);
AGR.GRS("L2(27)",9828);
AGR.GRS("L2(27).2",19656);
AGR.GRS("L2(27).3",29484);
AGR.GRS("L2(27).6",58968);
AGR.GRS("L2(29)",12180);
AGR.GRS("L2(29).2",24360);
AGR.GRS("L2(31)",14880);
AGR.GRS("L2(31).2",29760);
AGR.GRS("L2(32)",32736);
AGR.GRS("L2(32).5",163680);
AGR.GRS("L2(37)",25308);
AGR.GRS("L2(41)",34440);
AGR.GRS("L2(43)",39732);
AGR.GRS("L2(47)",51888);
AGR.GRS("L2(49)",58800);
AGR.GRS("L2(53)",74412);
AGR.GRS("L2(59)",102660);
AGR.GRS("L2(61)",113460);
AGR.GRS("L2(64)",262080);
AGR.GRS("L2(67)",150348);
AGR.GRS("L2(71)",178920);
AGR.GRS("L2(73)",194472);
AGR.GRS("L2(79)",246480);
AGR.GRS("L2(8)",504);
AGR.GRS("L2(8).3",1512);
AGR.GRS("L2(81)",265680);
AGR.GRS("L2(83)",285852);
AGR.GRS("L2(89)",352440);
AGR.GRS("L2(97)",456288);
AGR.GRS("L3(11)",212427600);
AGR.GRS("L3(13)",270178272);
AGR.GRS("L3(2)",168);
AGR.GRS("L3(2).2",336);
AGR.GRS("L3(3)",5616);
AGR.GRS("L3(3).2",11232);
AGR.GRS("L3(4)",20160);
AGR.GRS("L3(4).2^2",80640);
AGR.GRS("L3(4).2_1",40320);
AGR.GRS("L3(4).2_2",40320);
AGR.GRS("L3(4).2_3",40320);
AGR.GRS("L3(4).3",60480);
AGR.GRS("L3(4).6",120960);
AGR.GRS("L3(4).D12",241920);
AGR.GRS("L3(5)",372000);
AGR.GRS("L3(5).2",744000);
AGR.GRS("L3(7)",1876896);
AGR.GRS("L3(7).2",3753792);
AGR.GRS("L3(7).3",5630688);
AGR.GRS("L3(8)",16482816);
AGR.GRS("L3(8).2",32965632);
AGR.GRS("L3(8).3",49448448);
AGR.GRS("L3(8).6",98896896);
AGR.GRS("L3(9)",42456960);
AGR.GRS("L3(9).2_1",84913920);
AGR.GRS("L3(9).2_2",84913920);
AGR.GRS("L3(9).2_3",84913920);
AGR.GRS("L4(3)",6065280);
AGR.GRS("L4(3).2_1",12130560);
AGR.GRS("L4(3).2_2",12130560);
AGR.GRS("L4(3).2_3",12130560);
AGR.GRS("L4(4)",987033600);
AGR.GRS("L4(5)",7254000000);
AGR.GRS("L5(2)",9999360);
AGR.GRS("L5(2).2",19998720);
AGR.GRS("L5(3)",237783237120);
AGR.GRS("L6(2)",20158709760);
AGR.GRS("L6(2).2",40317419520);
AGR.GRS("L7(2)",163849992929280);
AGR.GRS("L7(2).2",327699985858560);
AGR.GRS("Ly",51765179004000000);
AGR.GRS("M",808017424794512875886459904961710757005754368000000000);
AGR.GRS("M11",7920);
AGR.GRS("M11xA6.2^2",11404800);
AGR.GRS("M12",95040);
AGR.GRS("M12.2",190080);
AGR.GRS("M20",960);
AGR.GRS("M22",443520);
AGR.GRS("M22.2",887040);
AGR.GRS("M23",10200960);
AGR.GRS("M24",244823040);
AGR.GRS("McL",898128000);
AGR.GRS("McL.2",1796256000);
AGR.GRS("O10+(2)",23499295948800);
AGR.GRS("O10+(2).2",46998591897600);
AGR.GRS("O10-(2)",25015379558400);
AGR.GRS("O10-(2).2",50030759116800);
AGR.GRS("O7(3)",4585351680);
AGR.GRS("O7(3).2",9170703360);
AGR.GRS("O8+(2)",174182400);
AGR.GRS("O8+(2).2",348364800);
AGR.GRS("O8+(2).3",522547200);
AGR.GRS("O8+(3)",4952179814400);
AGR.GRS("O8+(3).S4",118852315545600);
AGR.GRS("O8-(2)",197406720);
AGR.GRS("O8-(2).2",394813440);
AGR.GRS("O8-(3)",10151968619520);
AGR.GRS("O8-(3).2^2",40607874478080);
AGR.GRS("O8-(3).2_1",20303937239040);
AGR.GRS("O8-(3).2_2",20303937239040);
AGR.GRS("O8-(3).2_3",20303937239040);
AGR.GRS("O8-(3).D8",81215748956160);
AGR.GRS("O9(3)",65784756654489600);
AGR.GRS("O9(3).2",131569513308979200);
AGR.GRS("ON",460815505920);
AGR.GRS("ON.2",921631011840);
AGR.GRS("ON.4",1843262023680);
AGR.GRS("R(27)",10073444472);
AGR.GRS("R(27).3",30220333416);
AGR.GRS("Ru",145926144000);
AGR.GRS("S10(2)",24815256521932800);
AGR.GRS("S3xTh",544475663327232000);
AGR.GRS("S4(11)",12860654400);
AGR.GRS("S4(13)",68518981440);
AGR.GRS("S4(17)",1004497044480);
AGR.GRS("S4(19)",3057017889600);
AGR.GRS("S4(4)",979200);
AGR.GRS("S4(4).2",1958400);
AGR.GRS("S4(4).4",3916800);
AGR.GRS("S4(5)",4680000);
AGR.GRS("S4(5).2",9360000);
AGR.GRS("S4(7)",138297600);
AGR.GRS("S4(7).2",276595200);
AGR.GRS("S4(9)",1721606400);
AGR.GRS("S6(2)",1451520);
AGR.GRS("S6(3)",4585351680);
AGR.GRS("S6(3).2",9170703360);
AGR.GRS("S6(5)",228501000000000);
AGR.GRS("S8(2)",47377612800);
AGR.GRS("S8(3)",65784756654489600);
AGR.GRS("Suz",448345497600);
AGR.GRS("Suz.2",896690995200);
AGR.GRS("Sz(32)",32537600);
AGR.GRS("Sz(32).5",162688000);
AGR.GRS("Sz(8)",29120);
AGR.GRS("Sz(8).3",87360);
AGR.GRS("Th",90745943887872000);
AGR.GRS("U3(11)",70915680);
AGR.GRS("U3(11).2",141831360);
AGR.GRS("U3(13)",811273008);
AGR.GRS("U3(16)",4279234560);
AGR.GRS("U3(3)",6048);
AGR.GRS("U3(3).2",12096);
AGR.GRS("U3(4)",62400);
AGR.GRS("U3(4).2",124800);
AGR.GRS("U3(4).4",249600);
AGR.GRS("U3(5)",126000);
AGR.GRS("U3(5).2",252000);
AGR.GRS("U3(5).3",378000);
AGR.GRS("U3(7)",5663616);
AGR.GRS("U3(8)",5515776);
AGR.GRS("U3(8).(S3x3)",99283968);
AGR.GRS("U3(8).2",11031552);
AGR.GRS("U3(8).3^2",49641984);
AGR.GRS("U3(8).3_1",16547328);
AGR.GRS("U3(8).3_2",16547328);
AGR.GRS("U3(8).3_3",16547328);
AGR.GRS("U3(8).6",33094656);
AGR.GRS("U3(8).S3",33094656);
AGR.GRS("U3(9)",42573600);
AGR.GRS("U4(2)",25920);
AGR.GRS("U4(2).2",51840);
AGR.GRS("U4(3)",3265920);
AGR.GRS("U4(3).2_1",6531840);
AGR.GRS("U4(3).2_2",6531840);
AGR.GRS("U4(3).2_3",6531840);
AGR.GRS("U4(3).4",13063680);
AGR.GRS("U4(3).D8",26127360);
AGR.GRS("U4(4)",1018368000);
AGR.GRS("U4(5)",14742000000);
AGR.GRS("U5(2)",13685760);
AGR.GRS("U5(2).2",27371520);
AGR.GRS("U5(3)",258190571520);
AGR.GRS("U5(4)",53443952640000);
AGR.GRS("U6(2)",9196830720);
AGR.GRS("U6(2).2",18393661440);
AGR.GRS("U6(2).3",27590492160);
AGR.GRS("U6(2).S3",55180984320);
AGR.GRS("U6(3)",22837472432087040);
AGR.GRS("U7(2)",227787103272960);
AGR.GRS("U8(2)",7434971050829414400);
AGR.GRS("W(F4)",1152);


#############################################################################
##
##  Store numbers of classes of maximal subgroups.
##
AGR.MXN("(2^2x3).U6(2)",16);
AGR.MXN("12.M22",8);
AGR.MXN("12.M22.2",7);
AGR.MXN("12_1.L3(4)",9);
AGR.MXN("12_1.L3(4).2_1",10);
AGR.MXN("12_2.L3(4)",9);
AGR.MXN("12_2.L3(4).2_1",10);
AGR.MXN("2.A10",7);
AGR.MXN("2.A10.2",8);
AGR.MXN("2.A11",7);
AGR.MXN("2.A11.2",7);
AGR.MXN("2.A12",11);
AGR.MXN("2.A12.2",11);
AGR.MXN("2.A13",9);
AGR.MXN("2.A13.2",8);
AGR.MXN("2.A5",3);
AGR.MXN("2.A5.2",4);
AGR.MXN("2.A6",5);
AGR.MXN("2.A6.2_1",6);
AGR.MXN("2.A7",5);
AGR.MXN("2.A7.2",5);
AGR.MXN("2.A8",6);
AGR.MXN("2.A8.2",7);
AGR.MXN("2.A9",8);
AGR.MXN("2.A9.2",7);
AGR.MXN("2.B",30);
AGR.MXN("2.Co1",22);
AGR.MXN("2.Fi22",14);
AGR.MXN("2.Fi22.2",13);
AGR.MXN("2.G2(4)",8);
AGR.MXN("2.HS",12);
AGR.MXN("2.HS.2",10);
AGR.MXN("2.J2",9);
AGR.MXN("2.J2.2",10);
AGR.MXN("2.L2(11)",4);
AGR.MXN("2.L2(13)",4);
AGR.MXN("2.L2(13).2",5);
AGR.MXN("2.L2(17)",5);
AGR.MXN("2.L2(19)",5);
AGR.MXN("2.L2(23)",5);
AGR.MXN("2.L2(25)",5);
AGR.MXN("2.L2(27)",4);
AGR.MXN("2.L2(29)",5);
AGR.MXN("2.L2(31)",7);
AGR.MXN("2.L2(49)",7);
AGR.MXN("2.L3(2)",3);
AGR.MXN("2.L3(2).2",4);
AGR.MXN("2.L3(4)",9);
AGR.MXN("2.L3(4).2_1",10);
AGR.MXN("2.M12",11);
AGR.MXN("2.M12.2",9);
AGR.MXN("2.M22",8);
AGR.MXN("2.M22.2",7);
AGR.MXN("2.O7(3)",15);
AGR.MXN("2.O8+(2)",17);
AGR.MXN("2.O8+(3)",27);
AGR.MXN("2.Ru",15);
AGR.MXN("2.S4(5)",8);
AGR.MXN("2.S6(2)",8);
AGR.MXN("2.S6(3)",11);
AGR.MXN("2.Suz",17);
AGR.MXN("2.Suz.2",16);
AGR.MXN("2.Sz(8)",4);
AGR.MXN("2.U4(2)",5);
AGR.MXN("2.U4(2).2",6);
AGR.MXN("2.U6(2)",16);
AGR.MXN("2F4(2)'",8);
AGR.MXN("2F4(2)'.2",7);
AGR.MXN("2^2.L3(4)",9);
AGR.MXN("2^2.L3(4).2_2",6);
AGR.MXN("2^2.Sz(8).3",5);
AGR.MXN("2^2.U6(2)",16);
AGR.MXN("3.A6",5);
AGR.MXN("3.A6.2_1",6);
AGR.MXN("3.A7",5);
AGR.MXN("3.A7.2",5);
AGR.MXN("3.Fi22",14);
AGR.MXN("3.Fi22.2",13);
AGR.MXN("3.Fi24'",25);
AGR.MXN("3.Fi24'.2",21);
AGR.MXN("3.G2(3)",10);
AGR.MXN("3.G2(3).2",6);
AGR.MXN("3.J3",9);
AGR.MXN("3.J3.2",9);
AGR.MXN("3.L3(4)",9);
AGR.MXN("3.L3(4).2_1",10);
AGR.MXN("3.L3(7)",8);
AGR.MXN("3.M22",8);
AGR.MXN("3.M22.2",7);
AGR.MXN("3.McL",12);
AGR.MXN("3.McL.2",10);
AGR.MXN("3.O7(3)",15);
AGR.MXN("3.ON",13);
AGR.MXN("3.ON.2",10);
AGR.MXN("3.Suz",17);
AGR.MXN("3.Suz.2",16);
AGR.MXN("3.U3(11)",11);
AGR.MXN("3.U3(8)",7);
AGR.MXN("3.U6(2)",16);
AGR.MXN("3D4(2)",9);
AGR.MXN("4.M22",8);
AGR.MXN("4.M22.2",7);
AGR.MXN("4_1.L3(4)",9);
AGR.MXN("4_1.L3(4).2_1",10);
AGR.MXN("4_2.L3(4)",9);
AGR.MXN("4_2.L3(4).2_1",10);
AGR.MXN("6.A6",5);
AGR.MXN("6.A6.2_1",6);
AGR.MXN("6.A7",5);
AGR.MXN("6.A7.2",5);
AGR.MXN("6.Fi22",14);
AGR.MXN("6.Fi22.2",13);
AGR.MXN("6.L3(4)",9);
AGR.MXN("6.L3(4).2_1",10);
AGR.MXN("6.M22",8);
AGR.MXN("6.M22.2",7);
AGR.MXN("6.O7(3)",15);
AGR.MXN("6.Suz",17);
AGR.MXN("6.Suz.2",16);
AGR.MXN("6.U6(2)",16);
AGR.MXN("A10",7);
AGR.MXN("A10.2",8);
AGR.MXN("A11",7);
AGR.MXN("A11.2",7);
AGR.MXN("A12",11);
AGR.MXN("A12.2",11);
AGR.MXN("A13",9);
AGR.MXN("A13.2",8);
AGR.MXN("A5",3);
AGR.MXN("A5.2",4);
AGR.MXN("A6",5);
AGR.MXN("A6.2^2",6);
AGR.MXN("A6.2_1",6);
AGR.MXN("A6.2_2",4);
AGR.MXN("A6.2_3",4);
AGR.MXN("A7",5);
AGR.MXN("A7.2",5);
AGR.MXN("A8",6);
AGR.MXN("A8.2",7);
AGR.MXN("A9",8);
AGR.MXN("A9.2",7);
AGR.MXN("B",30);
AGR.MXN("Co1",22);
AGR.MXN("Co2",11);
AGR.MXN("Co3",14);
AGR.MXN("Fi22",14);
AGR.MXN("Fi22.2",13);
AGR.MXN("Fi23",14);
AGR.MXN("Fi24'",25);
AGR.MXN("Fi24'.2",21);
AGR.MXN("G2(3)",10);
AGR.MXN("G2(3).2",6);
AGR.MXN("G2(4)",8);
AGR.MXN("HN",14);
AGR.MXN("HN.2",13);
AGR.MXN("HS",12);
AGR.MXN("HS.2",10);
AGR.MXN("He",11);
AGR.MXN("He.2",12);
AGR.MXN("Isoclinic(12.M22.2)",7);
AGR.MXN("Isoclinic(2.A5.2)",4);
AGR.MXN("Isoclinic(2.A7.2)",5);
AGR.MXN("Isoclinic(2.A8.2)",7);
AGR.MXN("Isoclinic(2.Fi22.2)",13);
AGR.MXN("Isoclinic(2.HS.2)",10);
AGR.MXN("Isoclinic(2.J2.2)",10);
AGR.MXN("Isoclinic(2.L3(2).2)",4);
AGR.MXN("Isoclinic(2.M12.2)",9);
AGR.MXN("Isoclinic(2.M22.2)",7);
AGR.MXN("Isoclinic(2.Suz.2)",16);
AGR.MXN("Isoclinic(4.M22.2)",7);
AGR.MXN("Isoclinic(6.Fi22.2)",13);
AGR.MXN("Isoclinic(6.M22.2)",7);
AGR.MXN("Isoclinic(6.Suz.2)",16);
AGR.MXN("J1",7);
AGR.MXN("J2",9);
AGR.MXN("J2.2",10);
AGR.MXN("J3",9);
AGR.MXN("J3.2",9);
AGR.MXN("J4",13);
AGR.MXN("L2(101)",5);
AGR.MXN("L2(103)",5);
AGR.MXN("L2(107)",4);
AGR.MXN("L2(109)",5);
AGR.MXN("L2(11)",4);
AGR.MXN("L2(11).2",5);
AGR.MXN("L2(113)",5);
AGR.MXN("L2(13)",4);
AGR.MXN("L2(13).2",5);
AGR.MXN("L2(16)",4);
AGR.MXN("L2(16).2",5);
AGR.MXN("L2(16).4",5);
AGR.MXN("L2(17)",5);
AGR.MXN("L2(19)",5);
AGR.MXN("L2(23)",5);
AGR.MXN("L2(25)",5);
AGR.MXN("L2(25).2_2",6);
AGR.MXN("L2(27)",4);
AGR.MXN("L2(29)",5);
AGR.MXN("L2(31)",7);
AGR.MXN("L2(32)",3);
AGR.MXN("L2(32).5",4);
AGR.MXN("L2(37)",4);
AGR.MXN("L2(41)",7);
AGR.MXN("L2(43)",4);
AGR.MXN("L2(47)",5);
AGR.MXN("L2(49)",7);
AGR.MXN("L2(53)",4);
AGR.MXN("L2(59)",5);
AGR.MXN("L2(61)",5);
AGR.MXN("L2(64)",5);
AGR.MXN("L2(67)",4);
AGR.MXN("L2(71)",7);
AGR.MXN("L2(73)",5);
AGR.MXN("L2(79)",7);
AGR.MXN("L2(8)",3);
AGR.MXN("L2(8).3",4);
AGR.MXN("L2(81)",5);
AGR.MXN("L2(83)",4);
AGR.MXN("L2(89)",7);
AGR.MXN("L2(97)",5);
AGR.MXN("L3(11)",6);
AGR.MXN("L3(2)",3);
AGR.MXN("L3(2).2",4);
AGR.MXN("L3(3)",4);
AGR.MXN("L3(3).2",5);
AGR.MXN("L3(4)",9);
AGR.MXN("L3(4).2^2",8);
AGR.MXN("L3(4).2_1",10);
AGR.MXN("L3(4).2_2",6);
AGR.MXN("L3(4).2_3",6);
AGR.MXN("L3(4).3",5);
AGR.MXN("L3(4).6",6);
AGR.MXN("L3(4).D12",8);
AGR.MXN("L3(5)",5);
AGR.MXN("L3(7)",8);
AGR.MXN("L3(8)",5);
AGR.MXN("L3(9)",7);
AGR.MXN("L4(3)",8);
AGR.MXN("L5(2)",5);
AGR.MXN("Ly",9);
AGR.MXN("M11",5);
AGR.MXN("M12",11);
AGR.MXN("M12.2",9);
AGR.MXN("M22",8);
AGR.MXN("M22.2",7);
AGR.MXN("M23",7);
AGR.MXN("M24",9);
AGR.MXN("McL",12);
AGR.MXN("McL.2",10);
AGR.MXN("O7(3)",15);
AGR.MXN("O8+(2)",17);
AGR.MXN("O8+(3)",27);
AGR.MXN("O8-(2)",8);
AGR.MXN("ON",13);
AGR.MXN("ON.2",10);
AGR.MXN("Ru",15);
AGR.MXN("S4(4)",7);
AGR.MXN("S4(4).2",8);
AGR.MXN("S4(5)",8);
AGR.MXN("S6(2)",8);
AGR.MXN("S6(3)",11);
AGR.MXN("S8(2)",11);
AGR.MXN("Suz",17);
AGR.MXN("Suz.2",16);
AGR.MXN("Sz(32)",4);
AGR.MXN("Sz(8)",4);
AGR.MXN("Sz(8).3",5);
AGR.MXN("Th",16);
AGR.MXN("U3(11)",11);
AGR.MXN("U3(3)",4);
AGR.MXN("U3(3).2",5);
AGR.MXN("U3(4)",4);
AGR.MXN("U3(4).2",5);
AGR.MXN("U3(5)",8);
AGR.MXN("U3(5).2",6);
AGR.MXN("U3(5).3",6);
AGR.MXN("U3(7)",5);
AGR.MXN("U3(8)",7);
AGR.MXN("U3(9)",5);
AGR.MXN("U4(2)",5);
AGR.MXN("U4(2).2",6);
AGR.MXN("U4(3)",16);
AGR.MXN("U4(3).2_1",13);
AGR.MXN("U4(3).2_3",11);
AGR.MXN("U5(2)",6);
AGR.MXN("U6(2)",16);


#############################################################################
##
##  Store orders of maximal subgroups.
##
AGR.MXO("(2^2x3).U6(2)",[164229120,159252480,123863040,78382080,78382080,78382080,17694720,17418240,17418240,17418240,5322240,5322240,5322240,1866240,1119744,483840]);
AGR.MXO("12.M22",[241920,69120,30240,30240,23040,16128,8640,7920]);
AGR.MXO("12.M22.2",[5322240,483840,138240,46080,32256,17280,15840]);
AGR.MXO("12_1.L3(4)",[11520,11520,4320,4320,4320,2016,2016,2016,864]);
AGR.MXO("12_1.L3(4).2_1",[241920,8640,8640,8640,4608,4032,4032,4032,1728,1440]);
AGR.MXO("12_2.L3(4)",[11520,11520,4320,4320,4320,2016,2016,2016,864]);
AGR.MXO("12_2.L3(4).2_1",[241920,8640,8640,8640,4608,4032,4032,4032,1728,1440]);
AGR.MXO("2.2E6(2)",[,,6622253206732800,6622253206732800,6622253206732800,,129123503308800,129123503308800,129123503308800]);
AGR.MXO("2.A10",[362880,80640,30240,28800,17280,3840,1440]);
AGR.MXO("2.A10.2",[3628800,725760,161280,60480,57600,34560,7680,2880]);
AGR.MXO("2.A11",[3628800,725760,241920,120960,86400,15840,15840]);
AGR.MXO("2.A11.2",[39916800,7257600,1451520,483840,241920,172800,220]);
AGR.MXO("2.A12",[39916800,7257600,2177280,1036800,967680,604800,190080,190080,82944,46080,31104]);
AGR.MXO("2.A12.2",[479001600,79833600,14515200,4354560,2073600,1935360,1209600,165888,92160,62208,2640]);
AGR.MXO("2.A13",[479001600,79833600,21772800,8709120,4838400,3628800,11232,11232,156]);
AGR.MXO("2.A13.2",[6227020800,958003200,159667200,43545600,17418240,9676800,7257600,312]);
AGR.MXO("2.A14.2",[,12454041600]);
AGR.MXO("2.A5",[24,20,12]);
AGR.MXO("2.A5.2",[120,48,40,24]);
AGR.MXO("2.A6",[120,120,72,48,48]);
AGR.MXO("2.A6.2_1",[720,240,240,144,96,96]);
AGR.MXO("2.A7",[720,336,336,240,144]);
AGR.MXO("2.A7.2",[5040,1440,480,288,84]);
AGR.MXO("2.A8",[5040,2688,2688,1440,1152,720]);
AGR.MXO("2.A8.2",[40320,10080,2880,2304,1440,768,672]);
AGR.MXO("2.A9",[40320,10080,4320,3024,3024,2880,1296,432]);
AGR.MXO("2.A9.2",[362880,80640,20160,8640,5760,2592,864]);
AGR.MXO("2.B",[612259837470198831513600,709767191322427392000,8178940946586009600,3179457774039859200,181491887775744000,52978025653862400,45717693482926080,21473462090465280,1549482039705600,1385384650997760,1092123648000000,237704631091200,261213880320,3762339840,3548160000,1725235200,408146688,212889600,116121600,93000000,48000000,4147200,576000,235200,29760,15840,11232,9792,2640,2162]);
AGR.MXO("2.Co1",[84610842624000,5380145971200,1002795171840,991533312000,178362777600,110361968640,12076646400,3963617280,1698693120,470292480,277136640,145152000,50388480,8709120,5038848,2177280,1693440,288000,120000,120000,7056,6000]);
AGR.MXO("2.F4(2)",[95126814720,95126814720,94755225600,94755225600]);
AGR.MXO("2.Fi22",[36787322880,9170703360,9170703360,2090188800,908328960,185794560,106168320,78382080,35942400,35389440,10077696,7257600,7257600,190080]);
AGR.MXO("2.Fi22.2",[129123503308800,73574645760,4180377600,1816657920,371589120,212336640,156764160,71884800,70778880,50388480,20155392,16982784,380160]);
AGR.MXO("2.G2(4)",[1209600,368640,368640,249600,241920,24192,7200,2184]);
AGR.MXO("2.G2(4).2",[503193600,2419200]);
AGR.MXO("2.HS",[887040,504000,504000,80640,80640,23040,21504,15840,15840,15360,5760,2400]);
AGR.MXO("2.HS.2",[88704000,1774080,161280,161280,46080,43008,30720,11520,8000,4800]);
AGR.MXO("2.J2",[12096,4320,3840,2304,1440,1200,672,600,120]);
AGR.MXO("2.J2.2",[1209600,24192,8640,7680,4608,2880,2400,1344,1200,240]);
AGR.MXO("2.L2(11)",[120,120,110,24]);
AGR.MXO("2.L2(13)",[156,28,24,24]);
AGR.MXO("2.L2(13).2",[2184,312,56,48,48]);
AGR.MXO("2.L2(17)",[272,48,48,36,32]);
AGR.MXO("2.L2(17).2",[,544]);
AGR.MXO("2.L2(19)",[342,120,120,40,36]);
AGR.MXO("2.L2(23)",[506,48,48,48,44]);
AGR.MXO("2.L2(25)",[600,240,240,52,48]);
AGR.MXO("2.L2(27)",[702,56,52,24]);
AGR.MXO("2.L2(29)",[812,120,120,60,56]);
AGR.MXO("2.L2(31)",[930,120,120,64,60,48,48]);
AGR.MXO("2.L2(49)",[2352,672,672,120,120,100,96]);
AGR.MXO("2.L3(2)",[48,48,42]);
AGR.MXO("2.L3(2).2",[336,84,32,24]);
AGR.MXO("2.L3(4)",[1920,1920,720,720,720,336,336,336,144]);
AGR.MXO("2.L3(4).2_1",[40320,1440,1440,1440,768,672,672,672,288,240]);
AGR.MXO("2.M12",[15840,15840,2880,2880,1320,864,864,480,384,384,144]);
AGR.MXO("2.M12.2",[190080,2640,2640,960,768,768,432,288,240]);
AGR.MXO("2.M22",[40320,11520,5040,5040,3840,2688,1440,1320]);
AGR.MXO("2.M22.2",[887040,80640,23040,7680,5376,2880,2640]);
AGR.MXO("2.O7(3)",[26127360,25194240,24261120,8491392,8491392,8188128,2903040,2903040,2519424,725760,725760,414720,322560,34560,27648]);
AGR.MXO("2.O8+(2)",[2903040,2903040,2903040,2580480,2580480,2580480,362880,362880,362880,311040,311040,311040,221184,31104,28800,28800,28800]);
AGR.MXO("2.O8+(2).2",[,5806080]);
AGR.MXO("2.O8+(3)",[9170703360,9170703360,9170703360,9170703360,9170703360,9170703360,8843178240,8843178240,8843178240,348364800,348364800,348364800,348364800,272097792,52254720,52254720,52254720,1244160,1244160,1244160,1244160,1244160,1244160,1036800,1036800,1036800,663552]);
AGR.MXO("2.O8-(3)",[,18341406720,18341406720,,,,2488320,2488320,1062720]);
AGR.MXO("2.Ru",[71884800,1548288,698880,688128,504000,491520,62400,40320,24360,24000,8640,8000,4368,2880,2400]);
AGR.MXO("2.S4(5)",[60000,60000,31200,28800,1920,1440,960,720]);
AGR.MXO("2.S6(2)",[103680,80640,46080,24192,21504,9216,8640,3024]);
AGR.MXO("2.S6(3)",[25194240,8188128,2519424,1244160,82944,58968,48384,22464,2184,2184,120]);
AGR.MXO("2.S6(3).2",[50388480]);
AGR.MXO("2.Suz",[503193600,39191040,27371520,6635520,3849120,2419200,2211840,967680,737280,380160,279936,86400,51840,22464,22464,15600,5040]);
AGR.MXO("2.Suz.2",[896690995200,1006387200,78382080,54743040,13271040,7698240,4838400,4423680,1935360,1474560,760320,559872,172800,103680,31200,10080]);
AGR.MXO("2.Sz(8)",[896,104,40,28]);
AGR.MXO("2.U4(2)",[1920,1440,1296,1296,1152]);
AGR.MXO("2.U4(2).2",[51840,3840,2880,2592,2592,2304]);
AGR.MXO("2.U6(2)",[27371520,26542080,20643840,13063680,13063680,13063680,2949120,2903040,2903040,2903040,887040,887040,887040,311040,186624,80640]);
AGR.MXO("2E6(2)",[,,3311126603366400,3311126603366400,3311126603366400,,64561751654400,64561751654400,64561751654400]);
AGR.MXO("2F4(2)'",[11232,11232,10240,7800,6144,1440,1440,1200]);
AGR.MXO("2F4(2)'.2",[17971200,20480,15600,12288,2400,432,156]);
AGR.MXO("2^2.2E6(2)",[,,13244506413465600,13244506413465600,13244506413465600,,258247006617600,258247006617600,258247006617600]);
AGR.MXO("2^2.L3(4)",[3840,3840,1440,1440,1440,672,672,672,288]);
AGR.MXO("2^2.L3(4).2_2",[80640,7680,7680,2880,1344,576]);
AGR.MXO("2^2.Sz(8).3",[116480,5376,624,240,168]);
AGR.MXO("2^2.U6(2)",[54743040,53084160,41287680,26127360,26127360,26127360,5898240,5806080,5806080,5806080,1774080,1774080,1774080,622080,373248,161280]);
AGR.MXO("3.2E6(2)",[,,9933379810099200,9933379810099200,9933379810099200,,193685254963200,193685254963200,193685254963200]);
AGR.MXO("3.A6",[180,180,108,72,72]);
AGR.MXO("3.A6.2_1",[1080,360,360,216,144,144]);
AGR.MXO("3.A7",[1080,504,504,360,216]);
AGR.MXO("3.A7.2",[7560,2160,720,432,126]);
AGR.MXO("3.Fi22",[55180984320,13756055040,13756055040,3135283200,1362493440,278691840,159252480,117573120,53913600,53084160,15116544,10886400,10886400,285120]);
AGR.MXO("3.Fi22.2",[193685254963200,110361968640,6270566400,2724986880,557383680,318504960,235146240,107827200,106168320,75582720,30233088,25474176,570240]);
AGR.MXO("3.Fi24'",[12268411419879014400,774741019852800,267417709977600,75046138675200,30084492372480,14546347960320,1504192757760,662171811840,481579499520,53722307808,41324852160,37623398400,24182323200,24182323200,5945425920,5945425920,458535168,65318400,1632960,317520,36288,36288,6552,6552,1218]);
AGR.MXO("3.Fi24'.2",[3765617127571985163878400,24536822839758028800,1549482039705600,534835419955200,150092277350400,60168984744960,29092695920640,3008385515520,1324343623680,963158999040,107444615616,82649704320,75246796800,11890851840,11890851840,917070336,130636800,3265920,635040,74088,2436]);
AGR.MXO("3.G2(3)",[36288,36288,34992,34992,33696,33696,4536,4032,3276,1728]);
AGR.MXO("3.G2(3).2",[12737088,17496,9072,8064,6552,3456]);
AGR.MXO("3.J3",[24480,10260,10260,8640,7344,6480,5832,5760,3456]);
AGR.MXO("3.J3.2",[150698880,48960,17280,14688,12960,11664,11520,6912,1026]);
AGR.MXO("3.L3(4)",[2880,2880,1080,1080,1080,504,504,504,216]);
AGR.MXO("3.L3(4).2_1",[60480,2160,2160,2160,1152,1008,1008,1008,432,360]);
AGR.MXO("3.L3(7)",[98784,98784,1008,1008,1008,216,216,171]);
AGR.MXO("3.M22",[60480,17280,7560,7560,5760,4032,2160,1980]);
AGR.MXO("3.M22.2",[1330560,120960,34560,11520,8064,4320,3960]);
AGR.MXO("3.McL",[9797760,1330560,1330560,378000,174960,174960,120960,120960,120960,120960,23760,9000]);
AGR.MXO("3.McL.2",[2694384000,19595520,756000,349920,349920,241920,241920,47520,18000,6912]);
AGR.MXO("3.O7(3)",[39191040,37791360,36391680,12737088,12737088,12282192,4354560,4354560,3779136,1088640,1088640,622080,483840,51840,41472]);
AGR.MXO("3.ON",[11261376,11261376,526680,483840,77760,77760,44640,44640,32256,23760,23760,7560,7560]);
AGR.MXO("3.ON.2",[1382446517760,1053360,967680,155520,155520,64512,49392,2790,2160,1008]);
AGR.MXO("3.Suz",[754790400,58786560,41057280,9953280,5773680,3628800,3317760,1451520,1105920,570240,419904,129600,77760,33696,33696,23400,7560]);
AGR.MXO("3.Suz.2",[1345036492800,1509580800,117573120,82114560,19906560,11547360,7257600,6635520,2903040,2211840,1140480,839808,259200,155520,46800,15120]);
AGR.MXO("3.U3(11)",[159720,15840,3960,3960,3960,1080,1080,1080,864,333,216]);
AGR.MXO("3.U3(8)",[32256,4536,648,648,648,486,171]);
AGR.MXO("3.U6(2)",[41057280,39813120,30965760,19595520,19595520,19595520,4423680,4354560,4354560,4354560,1330560,1330560,1330560,466560,279936,120960]);
AGR.MXO("3D4(2)",[258048,86016,12096,3024,2352,1296,1176,216,52]);
AGR.MXO("3D4(2).3",[211341312]);
AGR.MXO("4.M22",[80640,23040,10080,10080,7680,5376,2880,2640]);
AGR.MXO("4.M22.2",[1774080,161280,46080,15360,10752,5760,5280]);
AGR.MXO("4_1.L3(4)",[3840,3840,1440,1440,1440,672,672,672,288]);
AGR.MXO("4_1.L3(4).2_1",[80640,2880,2880,2880,1536,1344,1344,1344,576,480]);
AGR.MXO("4_2.L3(4)",[3840,3840,1440,1440,1440,672,672,672,288]);
AGR.MXO("4_2.L3(4).2_1",[80640,2880,2880,2880,1536,1344,1344,1344,576,480]);
AGR.MXO("5^3.L3(5)",[]);
AGR.MXO("6.A6",[360,360,216,144,144]);
AGR.MXO("6.A6.2_1",[2160,720,720,432,288,288]);
AGR.MXO("6.A7",[2160,1008,1008,720,432]);
AGR.MXO("6.A7.2",[15120,4320,1440,864,252]);
AGR.MXO("6.Fi22",[110361968640,27512110080,27512110080,6270566400,2724986880,557383680,318504960,235146240,107827200,106168320,30233088,21772800,21772800,570240]);
AGR.MXO("6.Fi22.2",[387370509926400,220723937280,12541132800,5449973760,1114767360,637009920,470292480,215654400,212336640,151165440,60466176,50948352,1140480]);
AGR.MXO("6.L3(4)",[5760,5760,2160,2160,2160,1008,1008,1008,432]);
AGR.MXO("6.L3(4).2_1",[120960,4320,4320,4320,2304,2016,2016,2016,864,720]);
AGR.MXO("6.M22",[120960,34560,15120,15120,11520,8064,4320,3960]);
AGR.MXO("6.M22.2",[2661120,241920,69120,23040,16128,8640,7920]);
AGR.MXO("6.O7(3)",[78382080,75582720,72783360,25474176,25474176,24564384,8709120,8709120,7558272,2177280,2177280,1244160,967680,103680,82944]);
AGR.MXO("6.Suz",[1509580800,117573120,82114560,19906560,11547360,7257600,6635520,2903040,2211840,1140480,839808,259200,155520,67392,67392,46800,15120]);
AGR.MXO("6.Suz.2",[2690072985600,3019161600,235146240,164229120,39813120,23094720,14515200,13271040,5806080,4423680,2280960,1679616,518400,311040,93600,30240]);
AGR.MXO("6.U6(2)",[82114560,79626240,61931520,39191040,39191040,39191040,8847360,8709120,8709120,8709120,2661120,2661120,2661120,933120,559872,241920]);
AGR.MXO("A10",[181440,40320,15120,14400,8640,1920,720]);
AGR.MXO("A10.2",[1814400,362880,80640,30240,28800,17280,3840,1440]);
AGR.MXO("A11",[1814400,362880,120960,60480,43200,7920,7920]);
AGR.MXO("A11.2",[19958400,3628800,725760,241920,120960,86400,110]);
AGR.MXO("A12",[19958400,3628800,1088640,518400,483840,302400,95040,95040,41472,23040,15552]);
AGR.MXO("A12.2",[239500800,39916800,7257600,2177280,1036800,967680,604800,82944,46080,31104,1320]);
AGR.MXO("A13",[239500800,39916800,10886400,4354560,2419200,1814400,5616,5616,78]);
AGR.MXO("A13.2",[3113510400,479001600,79833600,21772800,8709120,4838400,3628800,156]);
AGR.MXO("A14",[3113510400]);
AGR.MXO("A14.2",[,6227020800]);
AGR.MXO("A5",[12,10,6]);
AGR.MXO("A5.2",[60,24,20,12]);
AGR.MXO("A6",[60,60,36,24,24]);
AGR.MXO("A6.2^2",[720,720,720,144,40,32]);
AGR.MXO("A6.2_1",[360,120,120,72,48,48]);
AGR.MXO("A6.2_2",[360,72,20,16]);
AGR.MXO("A6.2_3",[360,72,20,16]);
AGR.MXO("A7",[360,168,168,120,72]);
AGR.MXO("A7.2",[2520,720,240,144,42]);
AGR.MXO("A8",[2520,1344,1344,720,576,360]);
AGR.MXO("A8.2",[20160,5040,1440,1152,720,384,336]);
AGR.MXO("A9",[20160,5040,2160,1512,1512,1440,648,216]);
AGR.MXO("A9.2",[181440,40320,10080,4320,2880,1296,432]);
AGR.MXO("B",[306129918735099415756800,354883595661213696000,4089470473293004800,1589728887019929600,90745943887872000,26489012826931200,22858846741463040,10736731045232640,774741019852800,692692325498880,546061824000000,118852315545600,130606940160,1881169920,1774080000,862617600,204073344,106444800,58060800,46500000,24000000,2073600,288000,117600,14880,7920,5616,4896,1320,1081]);
AGR.MXO("Co1",[42305421312000,2690072985600,501397585920,495766656000,89181388800,55180984320,6038323200,1981808640,849346560,235146240,138568320,72576000,25194240,4354560,2519424,1088640,846720,144000,60000,60000,3528,3000]);
AGR.MXO("Co2",[18393661440,908328960,898128000,743178240,88704000,41287680,26127360,11796480,10200960,933120,12000]);
AGR.MXO("Co3",[1796256000,44352000,13063680,10200960,3849120,2903040,756000,699840,322560,241920,190080,27648,9072,1440]);
AGR.MXO("F4(2)",[47563407360,47563407360,47377612800,47377612800]);
AGR.MXO("Fi22",[18393661440,4585351680,4585351680,1045094400,454164480,92897280,53084160,39191040,17971200,17694720,5038848,3628800,3628800,95040]);
AGR.MXO("Fi22.2",[64561751654400,36787322880,2090188800,908328960,185794560,106168320,78382080,35942400,35389440,25194240,10077696,8491392,190080]);
AGR.MXO("Fi23",[129123503308800,29713078886400,73574645760,47377612800,27512110080,20891566080,3265173504,663238368,479001600,318504960,247726080,34836480,3916800,6072]);
AGR.MXO("Fi24'",[4089470473293004800,258247006617600,89139236659200,25015379558400,10028164124160,4848782653440,501397585920,220723937280,160526499840,17907435936,13774950720,12541132800,8060774400,8060774400,1981808640,1981808640,152845056,21772800,544320,105840,12096,12096,2184,2184,406]);
AGR.MXO("Fi24'.2",[1255205709190661721292800,8178940946586009600,516494013235200,178278473318400,50030759116800,20056328248320,9697565306880,1002795171840,441447874560,321052999680,35814871872,27549901440,25082265600,3963617280,3963617280,305690112,43545600,1088640,211680,24696,812]);
AGR.MXO("G2(3)",[12096,12096,11664,11664,11232,11232,1512,1344,1092,576]);
AGR.MXO("G2(3).2",[4245696,5832,3024,2688,2184,1152]);
AGR.MXO("G2(4)",[604800,184320,184320,124800,120960,12096,3600,1092]);
AGR.MXO("G2(4).2",[251596800,1209600]);
AGR.MXO("G2(5)",[1500000,1500000,756000,744000,14400,12096,1344]);
AGR.MXO("HN",[239500800,177408000,16547328,3686400,2520000,2000000,1658880,1036800,1032192,750000,190080,190080,93312,58320]);
AGR.MXO("HN.2",[273030912000000,479001600,354816000,33094656,7372800,5040000,4000000,3317760,2073600,2064384,1500000,186624,116640]);
AGR.MXO("HS",[443520,252000,252000,40320,40320,11520,10752,7920,7920,7680,2880,1200]);
AGR.MXO("HS.2",[44352000,887040,80640,80640,23040,21504,15360,5760,4000,2400]);
AGR.MXO("He",[1958400,483840,138240,138240,21504,16464,15120,6174,4032,3528,1200]);
AGR.MXO("He.2",[4030387200,3916800,967680,43008,32928,30240,28800,18432,12348,8064,7056,2400]);
AGR.MXO("Isoclinic(12.M22.2)",[5322240,483840,138240,46080,32256,17280,15840]);
AGR.MXO("Isoclinic(2.A14.2)",[,12454041600]);
AGR.MXO("Isoclinic(2.A5.2)",[120,48,40,24]);
AGR.MXO("Isoclinic(2.A7.2)",[5040,1440,480,288,84]);
AGR.MXO("Isoclinic(2.A8.2)",[40320,10080,2880,2304,1440,768,672]);
AGR.MXO("Isoclinic(2.Fi22.2)",[129123503308800,73574645760,4180377600,1816657920,371589120,212336640,156764160,71884800,70778880,50388480,20155392,16982784,380160]);
AGR.MXO("Isoclinic(2.G2(4).2)",[503193600,2419200]);
AGR.MXO("Isoclinic(2.HS.2)",[88704000,1774080,161280,161280,46080,43008,30720,11520,8000,4800]);
AGR.MXO("Isoclinic(2.J2.2)",[1209600,24192,8640,7680,4608,2880,2400,1344,1200,240]);
AGR.MXO("Isoclinic(2.L2(19).2)",[,684]);
AGR.MXO("Isoclinic(2.L3(2).2)",[336,84,32,24]);
AGR.MXO("Isoclinic(2.M12.2)",[190080,2640,2640,960,768,768,432,288,240]);
AGR.MXO("Isoclinic(2.M22.2)",[887040,80640,23040,7680,5376,2880,2640]);
AGR.MXO("Isoclinic(2.Suz.2)",[896690995200,1006387200,78382080,54743040,13271040,7698240,4838400,4423680,1935360,1474560,760320,559872,172800,103680,31200,10080]);
AGR.MXO("Isoclinic(4.M22.2)",[1774080,161280,46080,15360,10752,5760,5280]);
AGR.MXO("Isoclinic(6.Fi22.2)",[387370509926400,220723937280,12541132800,5449973760,1114767360,637009920,470292480,215654400,212336640,151165440,60466176,50948352,1140480]);
AGR.MXO("Isoclinic(6.M22.2)",[2661120,241920,69120,23040,16128,8640,7920]);
AGR.MXO("Isoclinic(6.Suz.2)",[2690072985600,3019161600,235146240,164229120,39813120,23094720,14515200,13271040,5806080,4423680,2280960,1679616,518400,311040,93600,30240]);
AGR.MXO("J1",[660,168,120,114,110,60,42]);
AGR.MXO("J2",[6048,2160,1920,1152,720,600,336,300,60]);
AGR.MXO("J2.2",[604800,12096,4320,3840,2304,1440,1200,672,600,120]);
AGR.MXO("J3",[8160,3420,3420,2880,2448,2160,1944,1920,1152]);
AGR.MXO("J3.2",[50232960,16320,5760,4896,4320,3888,3840,2304,342]);
AGR.MXO("J4",[501397585920,21799895040,10239344640,660602880,141831360,887040,319440,163680,12144,6048,812,602,444]);
AGR.MXO("L2(101)",[5050,102,100,60,60]);
AGR.MXO("L2(103)",[5253,104,102,24,24]);
AGR.MXO("L2(107)",[5671,108,106,12]);
AGR.MXO("L2(109)",[5886,110,108,60,60]);
AGR.MXO("L2(11)",[60,60,55,12]);
AGR.MXO("L2(11).2",[660,110,24,24,20]);
AGR.MXO("L2(113)",[6328,114,112,24,24]);
AGR.MXO("L2(13)",[78,14,12,12]);
AGR.MXO("L2(13).2",[1092,156,28,24,24]);
AGR.MXO("L2(16)",[240,60,34,30]);
AGR.MXO("L2(16).2",[4080,480,120,68,60]);
AGR.MXO("L2(16).4",[8160,960,240,136,120]);
AGR.MXO("L2(17)",[136,24,24,18,16]);
AGR.MXO("L2(17).2",[,272]);
AGR.MXO("L2(19)",[171,60,60,20,18]);
AGR.MXO("L2(19).2",[,342]);
AGR.MXO("L2(23)",[253,24,24,24,22]);
AGR.MXO("L2(25)",[300,120,120,26,24]);
AGR.MXO("L2(25).2_2",[7800,600,240,240,52,48]);
AGR.MXO("L2(27)",[351,28,26,12]);
AGR.MXO("L2(29)",[406,60,60,30,28]);
AGR.MXO("L2(29).2",[,812]);
AGR.MXO("L2(31)",[465,60,60,32,30,24,24]);
AGR.MXO("L2(32)",[992,66,62]);
AGR.MXO("L2(32).5",[32736,4960,330,310]);
AGR.MXO("L2(37)",[666,38,36,12]);
AGR.MXO("L2(41)",[820,60,60,42,40,24,24]);
AGR.MXO("L2(43)",[903,44,42,12]);
AGR.MXO("L2(47)",[1081,48,46,24,24]);
AGR.MXO("L2(49)",[1176,336,336,60,60,50,48]);
AGR.MXO("L2(53)",[1378,54,52,12]);
AGR.MXO("L2(59)",[1711,60,60,60,58]);
AGR.MXO("L2(61)",[1830,62,60,60,60]);
AGR.MXO("L2(64)",[4032,504,130,126,60]);
AGR.MXO("L2(67)",[2211,68,66,12]);
AGR.MXO("L2(71)",[2485,72,70,60,60,24,24]);
AGR.MXO("L2(73)",[2628,74,72,24,24]);
AGR.MXO("L2(79)",[3081,80,78,60,60,24,24]);
AGR.MXO("L2(8)",[56,18,14]);
AGR.MXO("L2(8).3",[504,168,54,42]);
AGR.MXO("L2(81)",[3240,720,720,82,80]);
AGR.MXO("L2(83)",[3403,84,82,12]);
AGR.MXO("L2(89)",[3916,90,88,60,60,24,24]);
AGR.MXO("L2(97)",[4656,98,96,24,24]);
AGR.MXO("L3(11)",[1597200,1597200,1320,600,399,168]);
AGR.MXO("L3(2)",[24,24,21]);
AGR.MXO("L3(2).2",[168,42,16,12]);
AGR.MXO("L3(3)",[432,432,39,24]);
AGR.MXO("L3(3).2",[5616,216,96,78,48]);
AGR.MXO("L3(4)",[960,960,360,360,360,168,168,168,72]);
AGR.MXO("L3(4).2^2",[40320,40320,40320,1440,768,672,288,240]);
AGR.MXO("L3(4).2_1",[20160,720,720,720,384,336,336,336,144,120]);
AGR.MXO("L3(4).2_2",[20160,1920,1920,720,336,144]);
AGR.MXO("L3(4).2_3",[20160,720,384,336,144,120]);
AGR.MXO("L3(4).3",[20160,2880,2880,216,63]);
AGR.MXO("L3(4).6",[60480,40320,1152,432,360,126]);
AGR.MXO("L3(4).D12",[120960,120960,120960,80640,2304,864,720,252]);
AGR.MXO("L3(5)",[12000,12000,120,96,93]);
AGR.MXO("L3(5).2",[372000,4000,960,240,192,186]);
AGR.MXO("L3(7)",[32928,32928,336,336,336,72,72,57]);
AGR.MXO("L3(8)",[225792,225792,294,219,168]);
AGR.MXO("L3(8).2",[16482816]);
AGR.MXO("L3(8).3",[16482816,677376,677376,882,657,504]);
AGR.MXO("L3(8).6",[49448448,32965632,150528,21168,1764,1314,1008]);
AGR.MXO("L3(9)",[466560,466560,6048,5616,720,384,273]);
AGR.MXO("L4(3)",[151632,151632,51840,51840,46656,2880,720,576]);
AGR.MXO("L5(2)",[322560,322560,64512,64512,155]);
AGR.MXO("L5(2).2",[9999360]);
AGR.MXO("L7(2).2",[163849992929280]);
AGR.MXO("Ly",[5859000000,5388768000,46500000,39916800,9000000,3849120,699840,1474,666]);
AGR.MXO("M",[8309562962452852382355161088000000,139511839126336328171520000,7531234255143970327756800,1836779512410596494540800,,,,,544475663327232000,,,,,,,378000000000,,,,,,,,508243680,,,72576000,,,,,,,,,632736,,,72600,,,,1640]);
AGR.MXO("M11",[720,660,144,120,48]);
AGR.MXO("M12",[7920,7920,1440,1440,660,432,432,240,192,192,72]);
AGR.MXO("M12.2",[95040,1320,1320,480,384,384,216,144,120]);
AGR.MXO("M22",[20160,5760,2520,2520,1920,1344,720,660]);
AGR.MXO("M22.2",[443520,40320,11520,3840,2688,1440,1320]);
AGR.MXO("M23",[443520,40320,40320,20160,7920,5760,253]);
AGR.MXO("M24",[10200960,887040,322560,190080,138240,120960,64512,6072,168]);
AGR.MXO("McL",[3265920,443520,443520,126000,58320,58320,40320,40320,40320,40320,7920,3000]);
AGR.MXO("McL.2",[898128000,6531840,252000,116640,116640,80640,80640,15840,6000,2304]);
AGR.MXO("O10+(2)",[47377612800,44590694400,10239344640,10239344640]);
AGR.MXO("O10-(2)",[50536120320]);
AGR.MXO("O7(3)",[13063680,12597120,12130560,4245696,4245696,4094064,1451520,1451520,1259712,362880,362880,207360,161280,17280,13824]);
AGR.MXO("O8+(2)",[1451520,1451520,1451520,1290240,1290240,1290240,181440,181440,181440,155520,155520,155520,110592,15552,14400,14400,14400]);
AGR.MXO("O8+(2).2",[,2903040]);
AGR.MXO("O8+(3)",[4585351680,4585351680,4585351680,4585351680,4585351680,4585351680,4421589120,4421589120,4421589120,174182400,174182400,174182400,174182400,136048896,26127360,26127360,26127360,622080,622080,622080,622080,622080,622080,518400,518400,518400,331776]);
AGR.MXO("O8-(2)",[1658880,1451520,258048,184320,120960,8160,4320,168]);
AGR.MXO("O8-(3)",[,9170703360,9170703360,,,,1244160,1244160,531360]);
AGR.MXO("O8-(3).2_1",[,,18341406720,18341406720,,,97044480,,,1062720]);
AGR.MXO("ON",[3753792,3753792,175560,161280,25920,25920,14880,14880,10752,7920,7920,2520,2520]);
AGR.MXO("ON.2",[460815505920,351120,322560,51840,51840,21504,16464,930,720,336]);
AGR.MXO("R(27)",[511758,19656,1512,222,168,114]);
AGR.MXO("R(27).3",[10073444472,1535274,,,666,168]);
AGR.MXO("Ru",[35942400,774144,349440,344064,252000,245760,31200,20160,12180,12000,4320,4000,2184,1440,1200]);
AGR.MXO("S4(4)",[11520,11520,8160,8160,7200,7200,720]);
AGR.MXO("S4(4).2",[979200,23040,23040,16320,16320,14400,14400,1440]);
AGR.MXO("S4(5)",[30000,30000,15600,14400,960,720,480,360]);
AGR.MXO("S6(2)",[51840,40320,23040,12096,10752,4608,4320,1512]);
AGR.MXO("S6(3)",[12597120,4094064,1259712,622080,41472,29484,24192,11232,1092,1092,60]);
AGR.MXO("S6(3).2",[25194240]);
AGR.MXO("S8(2)",[394813440,348364800,185794560,20643840,8847360,8709120,4128768,3628800,1958400,1036800,2448]);
AGR.MXO("Suz",[251596800,19595520,13685760,3317760,1924560,1209600,1105920,483840,368640,190080,139968,43200,25920,11232,11232,7800,2520]);
AGR.MXO("Suz.2",[448345497600,503193600,39191040,27371520,6635520,3849120,2419200,2211840,967680,737280,380160,279936,86400,51840,15600,5040]);
AGR.MXO("Sz(32)",[31744,164,100,62]);
AGR.MXO("Sz(8)",[448,52,20,14]);
AGR.MXO("Sz(8).3",[29120,1344,156,60,42]);
AGR.MXO("Th",[634023936,319979520,92897280,33094656,25474176,944784,944784,349920,12000,12000,7056,6840,5616,720,465,120]);
AGR.MXO("U3(11)",[53240,5280,1320,1320,1320,360,360,360,288,111,72]);
AGR.MXO("U3(3)",[216,168,96,96]);
AGR.MXO("U3(3).2",[6048,432,336,192,192]);
AGR.MXO("U3(4)",[960,300,150,39]);
AGR.MXO("U3(4).2",[62400,1920,600,300,78]);
AGR.MXO("U3(4).4",[124800,3840,1200,600,156]);
AGR.MXO("U3(5)",[2520,2520,2520,1000,720,720,720,240]);
AGR.MXO("U3(5).2",[126000,5040,2000,1440,480,336]);
AGR.MXO("U3(5).3",[126000,3000,720,216,216,63]);
AGR.MXO("U3(7)",[16464,2688,384,336,129]);
AGR.MXO("U3(8)",[10752,1512,216,216,216,162,57]);
AGR.MXO("U3(9)",[58320,7200,720,600,219]);
AGR.MXO("U4(2)",[960,720,648,648,576]);
AGR.MXO("U4(2).2",[25920,1920,1440,1296,1296,1152]);
AGR.MXO("U4(3)",[29160,25920,25920,20160,20160,11664,6048,5760,5760,2520,2520,2520,2520,1152,720,720]);
AGR.MXO("U4(3).2_1",[3265920,58320,51840,51840,40320,40320,23328,12096,11520,11520,2304,1440,1440]);
AGR.MXO("U4(3).2_3",[3265920,58320,40320,40320,23328,12096,2304,1440,1440,1440,768]);
AGR.MXO("U5(2)",[82944,77760,46080,9720,3888,660]);
AGR.MXO("U5(2).2",[13685760,165888,155520,92160,19440,,1320]);
AGR.MXO("U6(2)",[13685760,13271040,10321920,6531840,6531840,6531840,1474560,1451520,1451520,1451520,443520,443520,443520,155520,93312,40320]);
AGR.MXO("U6(2).2",[,27371520,,,,,,887040]);
AGR.MXO("U7(2)",[84085309440,82771476480,,,,,3674160]);


#############################################################################
##
##  Store structures of maximal subgroups.
##
AGR.MXS("(2^2x3).U6(2)",[,,"2^10:6.L3(4)","2x6_1.U4(3).2_2","2x6_1.U4(3).2_2","2x6_1.U4(3).2_2",,"2^2x3xS6(2)","2^2x3xS6(2)","2^2x3xS6(2)","2x6.M22","2x6.M22","2x6.M22"]);
AGR.MXS("12.M22",["12_1.L3(4)","2.2^5:3A6","2.(2x3.A7)","2.(2x3.A7)","3x2.(2^5:S5)","3x2.(2x2^3:L3(2))","(4x3.A6).2_3","3x2.(2xL2(11))"]);
AGR.MXS("2.2E6(2)",[,,"2xF4(2)","2.F4(2)","2.F4(2)",,"2xFi22","2.Fi22","2.Fi22"]);
AGR.MXS("2.A10",["2.A9","Isoclinic(2.A8.2)","(2.A7x3).2","2.(A5xA5).4","2.(A6xA4).2","2^(1+4).S5","M10x2"]);
AGR.MXS("2.A11",["2.A10","Isoclinic(2.A9.2)","(2.A8x3).2","2.(A7xA4).2","2.(A6xA5).2","2xM11","2xM11"]);
AGR.MXS("2.A12",[,,,,,,"2.M12","2.M12"]);
AGR.MXS("2.A5",["2.L2(3)","2.D10","2.S3"]);
AGR.MXS("2.A6",["2.A5","2.A5","3^2:8","2.S4","2.S4"]);
AGR.MXS("2.A7",["2.A6","2.L3(2)","2.L3(2)","Isoclinic(2.A5.2)","(2.A4x3).2"]);
AGR.MXS("2.A8",["2.A7","2^(1+3):L3(2)","2^(1+3):L3(2)","2.A6.2_1","2(A4xA4).2^2","(2.A5x3).2"]);
AGR.MXS("2.A9",["2.A8","Isoclinic(2.A7.2)","(2.A6x3).2_1","2xL2(8).3","2xL2(8).3","2.(A5xA4).2","(2x3^3).S4","2x3^2:2A4"]);
AGR.MXS("2.B",["2^2.2E6(2).2",,"2xFi23",,"2xTh",,,,"(S3x2.Fi22).2",,,,,,,,,,,,,,,,,"2xM11",,,,"2x47:23"]);
AGR.MXS("2.Co1",[,,"2.2^11:M24"]);
AGR.MXS("2.Fi22",[,"2xO7(3)","2xO7(3)","O8+(2):S3x2","2^11.M22",,,"S3x2.U4(3).2_2"]);
AGR.MXS("2.G2(4)",["2.J2","2.2^(2+8).(3xA5)","2.2^(4+6).(A5x3)","Isoclinic(2xU3(4).2)","Isoclinic(6.L3(4).2_3)","Isoclinic(2xU3(3).2)","2.A5xA5","2.L2(13)"]);
AGR.MXS("2.HS",["2.M22","Isoclinic(U3(5).2x2)","Isoclinic(U3(5).2x2)","Isoclinic(2.L3(4).2_1)","Isoclinic(S8x2)","2.2^4.S6","2.4^3.L3(2)","2xM11","2xM11","2.4.2^4.S5","2.(2xA6.2^2)","5:4x2.A5"]);
AGR.MXS("2.HS.2",[,,,,,,,,"5^(1+2)_+:[2^6]"]);
AGR.MXS("2.J2",["2xU3(3)","(2x3.A6).2","2^(1+4)_-:2A5","2^(3+4):(3xS3)","2A4xA5","2A5xD10","(2xL3(2)).2","2.(5^2:D12)","2.A5"]);
AGR.MXS("2.J2.2",[,"Isoclinic(2xU3(3).2)",,,,,"(2.A5xD10).2"]);
AGR.MXS("2.L2(11)",["2.A5","2.A5","2x11:5","2.(S3x2)"]);
AGR.MXS("2.L2(13)",["(2x13).6","2.D14","2.D12","2.L2(3)"]);
AGR.MXS("2.L2(17)",["(2x17).8","2.S4","2.S4","2.D18","2.D16"]);
AGR.MXS("2.L2(19)",["2x19:9","2.A5","2.A5","2.D20","2.D18"]);
AGR.MXS("2.L2(23)",["2x23:11","2.S4","2.S4","2.D24","2.D22"]);
AGR.MXS("2.L2(25)",["(2x5^2).12","Isoclinic(2.A5.2)","Isoclinic(2.A5.2)","2.D26","2.D24"]);
AGR.MXS("2.L2(27)",["2x3^3:13","2.D28","2.D26","2.L2(3)"]);
AGR.MXS("2.L2(29)",["(2x29).14","2.A5","2.A5","2.D30","2.D28"]);
AGR.MXS("2.L2(31)",["2x31:15","2.A5","2.A5","2.D32","2.D30","2.S4","2.S4"]);
AGR.MXS("2.L3(2)",["2.S4","2.S4","2x7:3"]);
AGR.MXS("2.L3(4)",["2^5:A5","2^5:A5","2xA6","2xA6","2xA6","2xL3(2)","2xL3(2)","2xL3(2)","Isoclinic(2x3^2:Q8)"]);
AGR.MXS("2.M12",["2xM11","2xM11","A6.D8","A6.D8","2.L2(11)","2x3^2.2.S4","2x3^2.2.S4","4Y(2xA5):2","(2xQ8).S4","2.(4^2:D12)","2.A4xS3"]);
AGR.MXS("2.M12.2",[,"2xL2(11).2"]);
AGR.MXS("2.M22",["2.L3(4)","2^5:A6","2xA7","2xA7","2^5:S5","2x2^3:L3(2)","(2xA6).2_3","2xL2(11)"]);
AGR.MXS("2.O7(3)",["4.U4(3).2_2","(2x3^5).U4(2).2","2.L4(3).2_2","2xG2(3)","2xG2(3)","2x3^(3+3):L3(3)","2.S6(2)","2.S6(2)","2.3^(1+6)_+.(2A4xA4).2","Isoclinic(2.A9.2)","Isoclinic(2.A9.2)","2.(2^2xU4(2)).2","2^(1+6)_+:A7","2.(S6xS4)","2.(A4x2(A4xA4).2).2"]);
AGR.MXS("2.O8+(2)",["2xS6(2)","2.S6(2)","2.S6(2)","2^7.A8","2^(1+6)_+.A8","2^(1+6)_+.A8","2xA9","2.A9","2.A9","(6xU4(2)):2","(3x2.U4(2)):2","2.O8+(2)M11","2.2^(1+8)_+:(S3xS3xS3)","(2x3^4:2^3).S4","(A5xA5).(2x4)","2.(A5xA5).2^2","2.(A5xA5).2^2"]);
AGR.MXS("2.Ru",["(2x2F4(2)').2","2.2^6:u3(3):2","2.(2^2xSz(8)):3","2.2^3+8:L3(2)",,"2.2.2^4+6:S5"]);
AGR.MXS("2.S6(2)",["2.U4(2).2","Isoclinic(2.A8.2)","2.(2^5:S6)","2xU3(3).2","2.2^6.L3(2)","2^2.[2^6].(S3xS3)","2.(S3xS6)","L2(8):3x2"]);
AGR.MXS("2.Suz",["2.G2(4)","Isoclinic(6_2.U4(3).2_3')","2xU5(2)","2.2^(1+6)_-.U4(2)","2x3^5:M11","2.J2.2","(2.2^4.2^6):3A6","2.(A4xL3(4)).2","2.(2^(2+8):(A5xS3))","Isoclinic(2.M12.2)","2.(3^(2+4):2(A4x2^2).2)","(A6x2.A5).2","(3^2:4x2.A6).2","(2xL3(3)).2","(2xL3(3)).2","2.L2(25)","2.A7"]);
AGR.MXS("2.Sz(8)",["2.2^(3+3):7","2x13:4","2x5:4","2xD14"]);
AGR.MXS("2.U4(2)",["2.(2^4:A5)","2.A6.2_1","2x3^(1+2)+:2A4","(2x3^3).S4","2.(2.(A4xA4).2)"]);
AGR.MXS("2.U4(2).2",["2.U4(2)","2.(2^4:S5)","2.(S6x2)","2.(3^3:(S4x2))","2.(3^(1+2)+:2S4)","2.(2.(A4xA4).2.2)"]);
AGR.MXS("2.U6(2)",["2xU5(2)","2.2^(1+8)_+:U4(2)","2^10:L3(4)","2xU4(3).2_2","2.U4(3).2_2","2.U4(3).2_2","2.2^(4+8):(S3xA5)","2xS6(2)","2xS6(2)","2xS6(2)","2xM22","2.M22","2.M22","2xS3xU4(2)","2.(3^(1+4).[2^7.3])","2.L3(4).2_1"]);
AGR.MXS("2E6(2)",[,,"F4(2)","F4(2)","F4(2)",,"Fi22","Fi22","Fi22"]);
AGR.MXS("2F4(2)'",["L3(3).2","L3(3).2","2.[2^8]:5:4","L2(25)","2^2.[2^8]:S3","A6.2^2","A6.2^2","5^2:4A4"]);
AGR.MXS("2F4(2)'.2",["2F4(2)'","2.[2^9]:5:4","L2(25).2_3","2^2.[2^9]:S3","5^2:4S4","3^(1+2):SD16","13:12"]);
AGR.MXS("2^2.2E6(2)",[,,"2x2.F4(2)","2x2.F4(2)","2x2.F4(2)",,"2x2.Fi22","2x2.Fi22","2x2.Fi22"]);
AGR.MXS("2^2.L3(4)",["2^6.A5","2^6.A5","2^2xA6","2^2xA6","2^2xA6","2^2xL2(7)","2^2xL2(7)","2^2xL2(7)","2^2.(3^2:Q8)"]);
AGR.MXS("2^2.L3(4).2_2",["2^2.L3(4)","2^2.2^4.S5","2^2.2^4.S5","2^2.S6","2^2.(L2(7)x2)","2^2.(3^2:Q8.2)"]);
AGR.MXS("2^2.U6(2)",[,,"2^10:2.L3(4)","2x2.U4(3).2_2","2x2.U4(3).2_2","2x2.U4(3).2_2",,"2^2xS6(2)","2^2xS6(2)","2^2xS6(2)","2x2.M22","2x2.M22","2x2.M22"]);
AGR.MXS("3.2E6(2)",[,,"3xF4(2)","3xF4(2)","3xF4(2)",,"3.Fi22","3.Fi22","3.Fi22"]);
AGR.MXS("3.A6",["3xA5","3xA5","3^(1+2):4","3xS4","3xS4"]);
AGR.MXS("3.A7",["3.A6","3xL3(2)","3xL3(2)","3xA5.2","3.(A4x3):2"]);
AGR.MXS("3.Fi22",[,,,"3xO8+(2):S3","2^10:3M22"]);
AGR.MXS("3.Fi24'",["3xFi23"]);
AGR.MXS("3.Fi24'.2",[,,"(S3x2.Fi22).2"]);
AGR.MXS("3.G2(3)",["3xU3(3).2","3xU3(3).2","3.(3^(1+2)+x3^2):2S4","3.(3^(1+2)+x3^2):2S4","3xL3(3).2","3xL3(3).2","3xL2(8).3","3x2^3.L3(2)","3xL2(13)","3.2^(1+4)+:3^2.2"]);
AGR.MXS("3.J3",[,,,"3x2^4:(3xA5)"]);
AGR.MXS("3.L3(4)",["3x2^4:A5","3x2^4:A5","3.A6","3.A6","3.A6","3xL3(2)","3xL3(2)","3xL3(2)","3^(1+2)_+:Q8"]);
AGR.MXS("3.L3(7)",["3x7^2:2.L2(7).2","3x7^2:2.L2(7).2","3xL3(2).2","3xL3(2).2","3xL3(2).2","3.(A4x3):2","3^(1+2)_+:Q8","3x19:3"]);
AGR.MXS("3.M22",["3.L3(4)","2^4:3A6","3.A7","3.A7","3x2^4:S5","3x2^3:L3(2)","3.A6.2_3","3xL2(11)"]);
AGR.MXS("3.McL",["3_2.U4(3)","3.M22","3.M22","3.U3(5)","3.3^(1+4):2S5","3.3^4:M10","3xL3(4).2_2","3x2.A8","3.2^4:A7","3.2^4:A7","3xM11","3x5^(1+2):3:8"]);
AGR.MXS("3.McL.2",[,,,"3.3^(1+4):4S5"]);
AGR.MXS("3.O7(3)",["6_1.U4(3).2_2","3.3^5:U4(2):2","3xL4(3).2_2","3.G2(3)","3.G2(3)","3.(3^(3+3):L3(3))","3xS6(2)","3xS6(2)","3.3^(1+6)_+.(2A4xA4).2","3xS9","3xS9","3x(2^2xU4(2)):2","2^6:3A7","3xS6xS4","3.(A4x2(A4xA4).2).2"]);
AGR.MXS("3.ON",[,,,,"3.(3^2:4xA6).2","3^(1+4)_+:2^(1+4)_-D10"]);
AGR.MXS("3.Suz",["3xG2(4)","3^2.U4(3).2_3'","3xU5(2)","3x2^(1+6)_-.U4(2)","3^6.M11","3xJ2.2","3x2^(4+6).3A6","(A4x3.L3(4)).2","3x2^(2+8):(A5xS3)","3xM12.2","3.3^(2+4):2(A4x2^2).2","(3.A6xA5):2","(3^(1+2):4xA6).2","3xL3(3).2","3xL3(3).2","3xL2(25)","3.A7"]);
AGR.MXS("3.Suz.2",["3.Suz","(3xG2(4)).2","3^2.U4(3).(2^2)_(133)","(3xU5(2)).2","(3x2^(1+6)_-.U4(2)).2","3^6:(M11x2)","S3xJ2.2","(3x2^(4+6):3A6).2","(A4x3.L3(4).2_3).2","(3x2^(2+8):(A5xS3)).2","S3xM12.2","3.3^(2+4):2(S4xD8)","(3.A6.2_2xA5):2","(3^(1+2):8xA6).2","(3xL2(25)).2_2","3.A7.2"]);
AGR.MXS("3.U6(2)",["3xU5(2)","3x2^(1+8)_+:U4(2)","2^9:3.L3(4)","3_1.U4(3).2_2","3_1.U4(3).2_2","3_1.U4(3).2_2","3x2^(4+8):(S3xA5)","3xS6(2)","3xS6(2)","3xS6(2)","3.M22","3.M22","3.M22","3xS3xU4(2)","3.(3^(1+4).[2^7.3])","3.L3(4).2_1"]);
AGR.MXS("3D4(2)",[,,"U3(3).2",,,,,,"13:4"]);
AGR.MXS("3D4(2).3",["3D4(2)"]);
AGR.MXS("4.M22",["4_1.L3(4)","2.2^5:A6","2.(2xA7)","2.(2xA7)","2.(2^5:S5)","2.(2x2^3:L3(2))","(4xA6).2_3","2.(2xL2(11))"]);
AGR.MXS("6.A6",["3x2.A5","3x2.A5","3^(1+2)_+:8","3x2.S4","3x2.S4"]);
AGR.MXS("6.A7",["6.A6","3x2.L3(2)","3x2.L3(2)","3xIsoclinic(2.A5.2)","6.(A4x3).2"]);
AGR.MXS("6.Fi22",[,"2x3.O7(3)","2x3.O7(3)","6xO8+(2):S3","2^11.3M22"]);
AGR.MXS("6.L3(4)",[,,,,,,"6xL3(2)","6xL3(2)"]);
AGR.MXS("6.M22",["6.L3(4)","2^5:3A6","2x(3.A7)","2x(3.A7)","3x2^5:S5","6x2^3:L3(2)","(2x3.A6).2_3","6xL2(11)"]);
AGR.MXS("6.M22.2",[,"6.L3(4).2_2"]);
AGR.MXS("6.O7(3)",["12_1.U4(3).2_2","6.(3^5:U4(2):2)","3x2.L4(3).2_2","2x3.G2(3)","2x3.G2(3)","2x3.(3^(3+3):L3(3))","3x2.S6(2)","3x2.S6(2)","6.3^(1+6)_+.(2A4xA4).2","3xIsoclinic(2.A9.2)","3xIsoclinic(2.A9.2)","3x2.(2^2xU4(2)).2","2^(1+6)_+:3A7","3x2.(S6xS4)","6.(A4x2(A4xA4).2).2"]);
AGR.MXS("6.Suz",["3x2.G2(4)","Isoclinic((3^2x2).U4(3).2_3')","6xU5(2)","3x2.2^(1+6)_-.U4(2)","2x3^6.M11","3x2.J2.2","3x(2.2^4.2^6):3A6","2.(A4x3.L3(4)).2","3x2.(2^(2+8):(A5xS3))","3xIsoclinic(2.M12.2)","6.(3^(2+4):2(A4x2^2).2)","(3.A6x2.A5).2","(3^(1+2):4x2.A6).2","3x(2xL3(3)).2","3x(2xL3(3)).2","3x2.L2(25)","6.A7"]);
AGR.MXS("6.U6(2)",["6xU5(2)","3x2.2^(1+8)_+:U4(2)","2^10:3.L3(4)","2x3_1.U4(3).2_2","6_1.U4(3).2_2","6_1.U4(3).2_2","3x2.2^(4+8):(S3xA5)","6xS6(2)","6xS6(2)","6xS6(2)","2x3.M22","6.M22","6.M22","6xS3xU4(2)","6.(3^(1+4).[2^7.3])","6.L3(4).2_1"]);
AGR.MXS("A10",["A9","A8.2","(A7x3).2","(A5xA5):4","(A6xA4).2","2^5:S5","A6.2_3"]);
AGR.MXS("A10.2",["A10","A9.2","S8x2","S7xS3","(S5xS5):2","S6xS4","2^5:S5","A6.2^2"]);
AGR.MXS("A11",["A10","A9.2","(A8x3).2","(A7xA4):2","(A6xA5):2","M11","M11"]);
AGR.MXS("A11.2",["A11","A10.2","S9x2","S8xS3","S7xS4","S6xS5","11:10"]);
AGR.MXS("A12",["A11","A10.2","(A9x3):2","(A6xA6):2^2","(A8xA4):2","(A7xA5):2","M12","M12","2^6:3^3:S4","2^5:S6","3^4:2^3.S4"]);
AGR.MXS("A13",["A12","A11.2","(A10x3):2","(A9xA4):2","(A8xA5):2","(A7xA6):2","L3(3)","L3(3)","13:6"]);
AGR.MXS("A13.2",["A13","A12.2","S11x2","S10xS3","S9xS4","S8xS5","S7xS6","13:12"]);
AGR.MXS("A14",["A13"]);
AGR.MXS("A14.2",[,"A13.2"]);
AGR.MXS("A5",["A4","D10","S3"]);
AGR.MXS("A5.2",["A5","S4","5:4","S3x2"]);
AGR.MXS("A6",["A5","A5","3^2:4","S4","S4"]);
AGR.MXS("A6.2_1",["A6","A5.2","A5.2","3^2:D8","2xS4","S4x2"]);
AGR.MXS("A7",["A6","L3(2)","L3(2)","A5.2","(A4x3):2"]);
AGR.MXS("A7.2",["A7","A6.2_1","2xS5","S4xS3","7:6"]);
AGR.MXS("A8",["A7","2^3:L3(2)","2^3:L3(2)","A6.2_1","2^4:(S3xS3)","(A5x3):2"]);
AGR.MXS("A8.2",["A8","A7.2","S6x2","(S4xS4):2","S5xS3","2^4:S4","L3(2).2"]);
AGR.MXS("A9",["A8","A7.2","(3xA6).2_1","L2(8).3","L2(8).3","(A4xA5):2","3^3.S4","3^2:2A4"]);
AGR.MXS("A9.2",["A9","A8.2","S7x2","S3xS6","S5xS4","3^3:(S4x2)","3^2.2.S4"]);
AGR.MXS("B",["2.2E6(2).2","2^(1+22).Co2","Fi23","2^(9+16).S8(2)","Th","(2^2xF4(2)):2","2^(2+10+20).(M22.2xS3)","[2^30].L5(2)","S3xFi22.2","[2^35].(S5xL3(2))","HN.2","O8+(3).S4","3^(1+8).2^(1+6).U4(2).2","(3^2:D8xU4(3).2^2).2","5:4xHS.2","S4x2F4(2)'.2","3^2.3^3.3^6.(S4x2S4)","A5.2xM22.2","(S6xL3(4).2).2","5^3.L3(5)","5^(1+4).2^(1+4).A5.4","(S6xS6).4","5^2:4S4xS5","L2(49).2_3","L2(31)","M11","L3(3)","L2(17).2","L2(11).2","47:23"]);
AGR.MXS("Co1",["Co2","3.Suz.2","2^11:M24","Co3","2^(1+8)+.O8+(2)","U6(2).3.2","(A4xG2(4)):2","2^(2+12):(A8xS3)","2^(4+12).(S3x3S6)","3^2.U4(3).D8","3^6:2M12","(A5xJ2):2","3^(1+4).2U4(2).2","(A6xU3(3)):2","3^(3+4):2(S4xS4)","A9xS3","(A7xL2(7)):2","(D10x(A5xA5).2).2","5^(1+2):GL2(5)","5^3:(4xA5).2","7^2:(3x2A4)","5^2:2A5"]);
AGR.MXS("Co2",["U6(2).2","2^10:M22:2","McL","2^(1+8)_+:S6(2)","HS.2","(2^(1+6)_+x2^4).A8","U4(3).D8","2^(4+10)(S5xS3)","M23","3^(1+4)_+:2^(1+4)_-.S5","5^(1+2):4S4"]);
AGR.MXS("Co3",["McL.2","HS","U4(3).(2^2)_(133)","M23","3^5:(2xM11)","2.S6(2)","U3(5).3.2","3^(1+4)_+:4S6","2^4.A8","L3(4).D12","2xM12","2^2.[2^7.3^2].S3","S3xL2(8).3","A4xS5"]);
AGR.MXS("F4(2)",["(2^(1+8)x2^6):S6(2)","(2^(1+8)x2^6):S6(2)","S8(2)","S8(2)"]);
AGR.MXS("Fi22",["2.U6(2)","O7(3)","O7(3)","O8+(2).3.2","2^10:M22","2^6:S6(2)","(2x2^(1+8)):U4(2):2","S3xU4(3).2_2","2F4(2)'","2^(5+8):(S3xA6)","3^(1+6):2^(3+4):3^2:2","A10.2","A10.2","M12"]);
AGR.MXS("Fi22.2",["Fi22","2.U6(2).2","O8+(2):S3x2","2^10:M22:2","2^7:S6(2)","(2x2^(1+8)):(U4(2):2x2)","S3xU4(3).(2^2)_(122)","2F4(2)'.2","2^(5+8):(S3xS6)","3^5:(2xU4(2).2)","3^(1+6)_+:2^(3+4):(S3xS3)","G2(3).2","M12.2"]);
AGR.MXS("Fi23",["2.Fi22","O8+(3).3.2","2^2.U6(2).2","S8(2)","S3xO7(3)","2^11.M23","3^(1+8).2^(1+6).3^(1+2).2S4","3^3.[3^7].(2xL3(3))","A12.2","(2^2x2^(1+8)).(3xU4(2)).2","2^(6+8):(A7xS3)","S4xS6(2)","S4(4).4","L2(23)"]);
AGR.MXS("Fi24'",["Fi23","2.Fi22.2","(3xO8+(3):3):2","O10-(2)","3^7.O7(3)","3^(1+10):U5(2):2","2^11.M24","2^2.U6(2).3.2","2^(1+12).3_1.U4(3).2_2'","3^3.[3^10].GL3(3)","3^2.3^4.3^8.(A5x2A4).2","(A4xO8+(2).3).2","He.2","He.2","2^(3+12).(L3(2)xA6)","2^(6+8).(S3xA8)","(3^2:2xG2(3)).2","(A5xA9):2","A6xL2(8):3","7:6xA7","U3(3).2","U3(3).2","L2(13).2","L2(13).2","29:14"]);
AGR.MXS("Fi24'.2",["F3+","2xFi23","2^2.Fi22.2","S3xO8+(3):S3","O10-(2).2","3^7.O7(3):2","3^(1+10):(2xU5(2):2)","2^12.M24","2^2.U6(2):S3x2","2^(1+12)_+.3_1.U4(3).2^2_(122)","3^3.[3^10].(L3(3)x2^2)","3^2.3^4.3^8.(S5x2S4)","S4xO8+(2):S3","2^(3+12).(L3(2)xS6)","2^(7+8).(S3xA8)","(S3xS3xG2(3)):2","S5xS9","S6xL2(8):3","7:6xS7","7^(1+2)_+:(6xS3).2","29:28"]);
AGR.MXS("G2(3)",["U3(3).2","U3(3).2","(3^(1+2)+x3^2):2S4","(3^(1+2)+x3^2):2S4","L3(3).2","L3(3).2","L2(8).3","2^3.L3(2)","L2(13)","2^(1+4)+:3^2.2"]);
AGR.MXS("G2(3).2",["G2(3)","3^2.(3x3^(1+2)+):D8","L2(8):3x2","2^3.L3(2):2","L2(13).2","2^(1+4)+.(S3xS3)"]);
AGR.MXS("G2(4)",["J2","2^(2+8):(3xA5)","2^(4+6):(A5x3)","U3(4).2","3.L3(4).2_3","U3(3).2","A5xA5","L2(13)"]);
AGR.MXS("G2(4).2",["G2(4)","J2.2"]);
AGR.MXS("G2(5)",["5^(1+4):GL(2,5)",,"3.U3(5).2","L3(5).2","2.(A5xA5).2","U3(3).2","2^3.L3(2)"]);
AGR.MXS("HN",["A12","2.HS.2","U3(8).3_1","2^(1+8).(A5xA5).2","(D10xU3(5)).2","5^(1+4):2^(1+4).5.4","2^6.U4(2)","(A6xA6).D8","2^3.2^2.2^6.(3xL3(2))","5^2.5.5^2.4A5","M12.2","M12.2","3^4:2(A4xA4).4","3^(1+4):4A5"]);
AGR.MXS("HN.2",["HN","A12.2","4.HS.2","U3(8).6","2^(1+8)_+.(A5xA5).2^2","5:4xU3(5):2","5^(1+4)_+:(4Y2^(1+4)_-.5.4)","2^6.U4(2).2","(S6xS6).2^2","2^3.2^2.2^6.(S3xL3(2))","5^2.5.5^2.4S5","3^4:2(S4xS4).2","3^(1+4)_+:4S5"]);
AGR.MXS("HS",["M22","U3(5).2","U3(5).2","L3(4).2_1","A8.2","2^4.S6","4^3:L3(2)","M11","M11","4.2^4.S5","2xA6.2^2","5:4xA5"]);
AGR.MXS("HS.2",["HS","M22.2","L3(4).2^2","S8x2","2^5.S6","4^3:(L3(2)x2)","2^(1+6)_+:S5","(2xA6.2^2).2","5^(1+2)_+:[2^5]","5:4xS5"]);
AGR.MXS("He",["S4(4).2","2^2.L3(4).S3","2^6:3.S6","2^6:3.S6","2^(1+6)_+.L3(2)","7^2:2L2(7)","3.A7.2","7^(1+2):(S3x3)","S4xL3(2)","7:3xL3(2)","5^2:4A4"]);
AGR.MXS("He.2",["He","S4(4).4","2^2.L3(4).D12","2^(1+6)_+.L3(2).2","7^2:2.L2(7).2","3.S7x2","(S5xS5):2","2^(4+4).(S3xS3).2","7^(1+2):(S3x6)","S4xL3(2).2","7:6xL3(2)","5^2:4S4"]);
AGR.MXS("J1",["L2(11)","2^3.7.3","2xA5","19:6","11:10","D6xD10","7:6"]);
AGR.MXS("J2",["U3(3)","3.A6.2_2","2^(1+4)_-:A5","2^(2+4):(3xS3)","A4xA5","A5xD10","L3(2).2","5^2:D12","A5"]);
AGR.MXS("J2.2",["J2","U3(3).2","3.A6.2^2","2^(1+4).S5","2^(2+4):(S3xS3)","(A4xA5):2","(A5xD10).2","L3(2).2x2","5^2:(4xS3)","A5.2"]);
AGR.MXS("J3",["L2(16).2","L2(19)","L2(19)","2^4:(3xA5)","L2(17)","(3xA6):2_2","3^2.3^(1+2):8","2^(1+4)_-:A5","2^(2+4):(3xS3)"]);
AGR.MXS("J3.2",["J3","L2(16).4","2^4:(3xA5).2","L2(17)x2","(3xM10):2","3^2.3^(1+2):8.2","2^(1+4).S5","2^(2+4):(S3xS3)","19:18"]);
AGR.MXS("J4",["2^11:M24","2^(1+12)_+.3M22.2","2^10:L5(2)","2^(3+12).(S5xL3(2))","U3(11).2","M22.2","11+^(1+2):(5x2S4)","L2(32).5","L2(23).2","U3(3)","29:28","43:14","37:12"]);
AGR.MXS("L2(109)",["109:54","D110","D108","A5","A5"]);
AGR.MXS("L2(11)",["A5","A5","11:5","S3x2"]);
AGR.MXS("L2(11).2",["L2(11)","11:10","D24","S4","D20"]);
AGR.MXS("L2(113)",["113:56","D114","D112","S4","S4"]);
AGR.MXS("L2(13)",["13:6","D14","S3x2","A4"]);
AGR.MXS("L2(16).2",[,,,,"D6xD10"]);
AGR.MXS("L2(17)",["17:8","S4","S4","D18","D16"]);
AGR.MXS("L2(17).2",[,"17:16"]);
AGR.MXS("L2(19)",["19:9","A5","A5","D20","D18"]);
AGR.MXS("L2(19).2",[,"19:18"]);
AGR.MXS("L2(23)",["23:11","S4","S4","D24","D22"]);
AGR.MXS("L2(25)",["5^2:12","A5.2","A5.2","D26","D24"]);
AGR.MXS("L2(27)",["3^3:13","D28","D26","A4"]);
AGR.MXS("L2(29)",["29:14","A5","A5","D30","D28"]);
AGR.MXS("L2(29).2",[,"29:28"]);
AGR.MXS("L2(31)",["31:15","A5","A5","D32","D30","S4","S4"]);
AGR.MXS("L3(11)",["11^2:(5x2L2(11).2)","11^2:(5x2L2(11).2)","L2(11).2","10^2:S3","133:3","L3(2)"]);
AGR.MXS("L3(2)",["S4","S4","7:3"]);
AGR.MXS("L3(3)",["3^2.2.S4","3^2.2.S4","13:3","S4"]);
AGR.MXS("L3(4)",["2^4:A5","2^4:A5","A6","A6","A6","L3(2)","L3(2)","L3(2)","3^2:Q8"]);
AGR.MXS("L3(4).D12",["L3(4).3.2_3","L3(4).6","L3(4).3.2_2","L3(4).2^2","2^(2+4):(S3xS3)","2x3^2.2.S4","S5xS3","S3x7:6"]);
AGR.MXS("L3(5)",["5^2:4S5","5^2:4S5","A5.2","4^2:S3","31:3"]);
AGR.MXS("L3(7)",["7^2:2.L2(7).2","7^2:2.L2(7).2","L3(2).2","L3(2).2","L3(2).2","(A4x3):2","3^2:Q8","19:3"]);
AGR.MXS("L3(8)",["2^6:(7xL2(8))","2^6:(7xL2(8))","7^2:S3","73:3","L3(2)"]);
AGR.MXS("L3(9)",["3^4:GL2(9)","3^4:GL2(9)","U3(3)","L3(3)","A6.2_2","8^2:S3","91:3"]);
AGR.MXS("L4(3)",["3^3:L3(3)","3^3:L3(3)","U4(2).2","U4(2).2","3^4:2(A4xA4).2","(4xA6):2","A6.2_2","S4xS4"]);
AGR.MXS("L5(2)",["2^4:A8","2^4:A8","2^6:(L3(2)xS3)","2^6:(L3(2)xS3)","31:5"]);
AGR.MXS("L5(2).2",["L5(2)"]);
AGR.MXS("L7(2).2",["L7(2)"]);
AGR.MXS("Ly",["G2(5)","3.McL.2","5^3.L3(5)","2.A11","5^(1+4):4S6","3^5:(2xM11)","3^(2+4):2A5.D8","67:22","37:18"]);
AGR.MXS("M",["2.B","2^(1+24).Co1","3.F3+.2","2^2.2E6(2).3.2",,,,,"S3xTh",,,,,,,"5^(1+6):2.J2.4",,,,,,,,"7^(1+4):(3x2.S7)",,,"(A7x(A5xA5):2^2):2",,,,,,,,,"13^(1+2):(3x4S4)",,,"11^2:(5x2.A5)",,,,"41:40"]);
AGR.MXS("M11",["A6.2_3","L2(11)","3^2:Q8.2","A5.2","2.S4"]);
AGR.MXS("M12",["M11","M11","A6.2^2","A6.2^2","L2(11)","3^2.2.S4","3^2.2.S4","2xS5","M8.S4","4^2:D12","A4xS3"]);
AGR.MXS("M12.2",["M12","L2(11).2","L2(11).2","(2^2xA5):2","D8.(S4x2)","4^2:D12.2","3^(1+2):D8","S4xS3","A5.2"]);
AGR.MXS("M22",["L3(4)","2^4:A6","A7","A7","2^4:S5","2^3:L3(2)","A6.2_3","L2(11)"]);
AGR.MXS("M22.2",["M22","L3(4).2_2","2^4:S6","2^5:S5","2x2^3:L3(2)","A6.2^2","L2(11).2"]);
AGR.MXS("M23",["M22","L3(4).2_2","2^4:A7","A8","M11","2^4:(3xA5).2","23:11"]);
AGR.MXS("M24",["M23","M22.2","2^4:A8","M12.2","2^6:3.S6","L3(4).3.2_2","2^6:(L3(2)xS3)","L2(23)","L3(2)"]);
AGR.MXS("McL",["U4(3)","M22","M22","U3(5)","3^(1+4):2S5","3^4:M10","L3(4).2_2","2.A8","2^4:A7","2^4:A7","M11","5^(1+2):3:8"]);
AGR.MXS("McL.2",["McL","U4(3).2_3","U3(5).2","3^(1+4):4S5","3^4:(M10x2)","L3(4).2^2","Isoclinic(2.A8.2)","2xM11","5^(1+2):(24:2)","2^(2+4):(S3xS3)"]);
AGR.MXS("O10+(2)",["S8(2)","2^8:O8+(2)","2^10:L5(2)"]);
AGR.MXS("O10-(2)",["2^8:O8-(2)"]);
AGR.MXS("O7(3)",["2.U4(3).2_2","3^5:U4(2):2","L4(3).2_2","G2(3)","G2(3)","3^(3+3):L3(3)","S6(2)","S6(2)","3^(1+6)_+:(2A4xA4).2","A9.2","A9.2","(2^2xU4(2)):2","2^6:A7","S6xS4","(A4x2(A4xA4).2).2"]);
AGR.MXS("O8+(2)",["S6(2)","S6(2)","S6(2)","2^6:A8","2^6:A8","2^6:A8","A9","A9","A9","(3xU4(2)):2","(3xU4(2)):2","(3xU4(2)):2","2^(1+8)_+:(S3xS3xS3)","3^4:2^3.S4","(A5xA5):2^2","(A5xA5):2^2","(A5xA5):2^2"]);
AGR.MXS("O8+(2).2",[,"2xS6(2)"]);
AGR.MXS("O8+(3)",["O7(3)","O7(3)","O7(3)","O7(3)","O7(3)","O7(3)","3^6:L4(3)","3^6:L4(3)","3^6:L4(3)","O8+(2)","O8+(2)","O8+(2)","O8+(2)","3^(1+8)_+:2(A4xA4xA4).2","2.U4(3).(2^2)_(122)","2.U4(3).(2^2)_(122)","2.U4(3).(2^2)_(122)","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A4xU4(2)):2","(A6xA6):2^2","(A6xA6):2^2","(A6xA6):2^2","2((A4wr2^2):2)"]);
AGR.MXS("O8-(2)",["2^6:U4(2)"]);
AGR.MXS("O8-(3)",[,"O7(3).2","O7(3).2",,,,"S4xU4(2).2","S4xU4(2).2","L2(81).2_1"]);
AGR.MXS("O8-(3).2_1",[,,"O7(3).2x2","O7(3).2x2",,,"D8xL4(3).2_2",,,"L2(81).4_1"]);
AGR.MXS("ON",["L3(7).2","L3(7).2","J1","4_2.L3(4).2_1","(3^2:4xA6).2","3^4:2^(1+4)D10","L2(31)","L2(31)","4^3.L3(2)","M11","M11","A7","A7"]);
AGR.MXS("ON.2",["ON","J1x2","4_2.L3(4).(2^2)_(12*3)","(3^2:4xA6).2^2","3^4:2^(1+4).(5:4)","4^3.(L3(2)x2)","7^(1+2)_+:(3xD16)","31:30","A6.2_2","L3(2).2"]);
AGR.MXS("Ru",["2F4(2)'.2","(2^6:U3(3)):2","(2^2xSz(8)):3","2^3+8:L3(2)","U3(5).2","2.2^(4+6):S5","L2(25).2^2","A8","L2(29)","5^2:4S5","3.A6.2^2","5^1+2:(2^5)","L2(13).2","A6.2^2","5:4xA5"]);
AGR.MXS("S4(4)",["2^6:(3xA5)","2^6:(3xA5)","L2(16).2","L2(16).2","(A5xA5):2","(A5xA5):2","A6.2_1"]);
AGR.MXS("S4(4).2",["S4(4)","2^6:(3xA5):2","2^6:(3xA5):2","L2(16).4","L2(16).4","(A5xA5):2^2","(A5xA5):2^2","S6x2"]);
AGR.MXS("S4(5)",["5^(1+2)+:4A5","5^3:(2xA5).2","L2(25).2_2","2.(A5xA5).2","2^4:A5","S5xS3","(2^2xA5):2","A6"]);
AGR.MXS("S6(2)",["U4(2).2","A8.2","2^5:S6","U3(3).2","2^6:L3(2)","2.[2^6]:(S3xS3)","S3xS6","L2(8).3"]);
AGR.MXS("S6(3)",["3^(1+4).2U4(2)","3^6:L3(3)","3^(3+4):2(S4xA4)","2.(A4xU4(2))","2^(2+6):3^3:S3","L2(27).3","2xU3(3).2","L3(3).2","L2(13)","L2(13)","A5"]);
AGR.MXS("S6(3).2",["3^(1+4).2U4(2).2"]);
AGR.MXS("S8(2)",["O8-(2).2","O8+(2).2","2^7:S6(2)","2^10.A8","2^(3+8):(S3xS6)","S3xS6(2)","2^(6+6):(S3xL3(2))","A10.2","S4(4).2","(S6xS6):2","L2(17)"]);
AGR.MXS("Suz",["G2(4)","3_2.U4(3).2_3'","U5(2)","2^(1+6)_-.U4(2)","3^5:M11","J2.2","2^(4+6):3A6","(A4xL3(4)):2_1","2^(2+8):(A5xS3)","M12.2","3^(2+4):2(A4x2^2).2","(A6xA5).2","(3^2:4xA6).2","L3(3).2","L3(3).2","L2(25)","A7"]);
AGR.MXS("Suz.2",["Suz","G2(4).2","3_2.U4(3).(2^2)_(133)","U5(2).2","2^(1+6)_-.U4(2).2","3^5:(M11x2)","J2.2x2","2^(4+6):3S6","(A4xL3(4):2_3):2","2^(2+8):(S5xS3)","M12.2x2","3^(2+4):2(S4xD8)","(A6:2_2xA5).2","(3^2:8xA6).2","L2(25).2_2","A7.2"]);
AGR.MXS("Sz(32)",["2^(5+5):31","41:4","25:4","D62"]);
AGR.MXS("Sz(8)",["2^(3+3):7","13:4","5:4","D14"]);
AGR.MXS("Sz(8).3",["Sz(8)","2^(3+3):7:3","13:12","5:4x3","7:6"]);
AGR.MXS("Th",["3D4(2).3","2^5.L5(2)","2^(1+8)_+.A9","U3(8).6","(3xG2(3)):2","[3^9].2S4","3^2.[3^7].2S4","3^5:2S6","5^(1+2):4S4","5^2:4S5","7^2:(3x2S4)","L2(19).2","L3(3)","A6.2_3","31:15","A5.2"]);
AGR.MXS("U3(11)",["11^(1+2)+:40","2(L2(11)x2).2","L2(11).2","L2(11).2","L2(11).2","A6","A6","A6","(4^2x3):S3","37:3","3^2:Q8"]);
AGR.MXS("U3(3).2",["U3(3)","3^(1+2):SD16","L3(2).2","2^(1+4).S3","4^2:D12"]);
AGR.MXS("U3(4)",["2^(2+4):15","5xA5","5^2:S3","13:3"]);
AGR.MXS("U3(4).2",["U3(4)","2^(2+4):(3xD10)","A5xD10","5^2:D12","13:6"]);
AGR.MXS("U3(5)",["A7","A7","A7","5^(1+2)+:8","A6.2_3","A6.2_3","A6.2_3","2.A5.2"]);
AGR.MXS("U3(5).2",["U3(5)","A7.2","5^(1+2):(8.2)","A6.2^2","2S5.2","L3(2).2"]);
AGR.MXS("U3(5).3",["U3(5)","5^(1+2)+:24","3x2S5","3^2:2A4","6^2:S3","7:3x3"]);
AGR.MXS("U3(7)",["7^(1+2):48","2(L2(7)x4).2","8^2:S3","L3(2).2","43:3"]);
AGR.MXS("U3(8)",["2^(3+6):21","3xL2(8)","3^2:2A4","3^2:2A4","3^2:2A4","(9x3).S3","19:3"]);
AGR.MXS("U3(9)",["3^(2+4):80","5xIsoclinic(2.A6.2_2)","A6.2_2","10^2:S3","73:3"]);
AGR.MXS("U4(2)",["2^4:A5","A6.2_1","3^(1+2)+:2A4","3^3:S4","2.(A4xA4).2"]);
AGR.MXS("U4(2).2",["U4(2)","2^5:S5","S6x2","3^(1+2)+:2S4","3^3:(S4x2)","W(F4)"]);
AGR.MXS("U4(3)",["3^4:A6","U4(2)","U4(2)","L3(4)","L3(4)","3^(1+4)_+.2S4","U3(3)","2^4:A6","2^4:A6","A7","A7","A7","A7","2(A4xA4).2^2","A6.2_3","A6.2_3"]);
AGR.MXS("U4(3).2_1",["U4(3)","3^4:(2xA6)","U4(2).2","U4(2).2","L3(4).2_2","L3(4).2_2","3^(1+4)+.4S4","2xU3(3)","2^4.S6","2^4.S6","4(A4xA4).4","A6.2^2","A6.2^2"]);
AGR.MXS("U4(3).2_3",["U4(3)","3^4:M10","L3(4).2_3","L3(4).2_1","3^(1+4):4S4","U3(3).2","2(A4xA4).4.2","M10x2","A6.2^2","A6.2^2","(4^2x2)S4"]);
AGR.MXS("U5(2)",["2^(1+6):3^(1+2):2A4","3xU4(2)","2^(4+4):(3xA5)","3^4:S5","S3x3^(1+2)+:2A4","L2(11)"]);
AGR.MXS("U6(2)",["U5(2)","2^(1+8)_+:U4(2)","2^9.L3(4)","U4(3).2_2","U4(3).2_2","U4(3).2_2","2^(4+8):(S3xA5)","S6(2)","S6(2)","S6(2)","M22","M22","M22","S3xU4(2)","3^(1+4).2^(1+1+2+2).S3","L3(4).2_1"]);
AGR.MXS("U6(2).2",[,"U5(2).2",,,,,,"M22.2"]);


#############################################################################
##
##  Store information about generators of kernels.
##
AGR.KERPRG("12.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("12.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[1,-1,2,-1,1,1,2,1],[3,1,3,1],[4,1,4,1],[6,1,7,1],[[8,3],[5,4]]]]);
AGR.KERPRG("12_1.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("12_2.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("2.A14.2",[1,"A14.2",[[2,1,1,1],[1,1,3,1],[3,2],[4,1,5,1],[1,1,2,1],[2,1,7,1],[7,2],[8,1,9,1],[6,1,10,1],[[11,2]]]]);
AGR.KERPRG("2.A5",[1,"A5",[[[1,2]]]]);
AGR.KERPRG("2.A5.2",[1,"A5.2",[[[2,4]]]]);
AGR.KERPRG("2.A6",[1,"A6",[[[1,2]]]]);
AGR.KERPRG("2.A6.2_1",[1,"A6.2_1",[[1,1,2,1],[[3,6]]]]);
AGR.KERPRG("2.Fi22",[1,"Fi22",[[1,1,2,1],[3,1,2,1],[[4,21]]]]);
AGR.KERPRG("2.Fi22.2",[1,"Fi22.2",[[1,-1,2,-1,1,1,2,1],[[3,3]]]]);
AGR.KERPRG("2.HS",[1,"HS",[[1,1,2,1],[3,1,2,1],[[4,10]]]]);
AGR.KERPRG("2.HS.2",[1,"HS.2",[[1,-1,2,-1,1,1,2,1],[[3,3]]]]);
AGR.KERPRG("2.J2",[1,"J2",[[[1,2]]]]);
AGR.KERPRG("2.L2(11)",[1,"L2(11)",[[[1,2]]]]);
AGR.KERPRG("2.L3(2)",[1,"L3(2)",[[[1,2]]]]);
AGR.KERPRG("2.L3(2).2",[1,"L3(2).2",[[[1,2]]]]);
AGR.KERPRG("2.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("2.M12",[1,"M12",[[[2,3]]]]);
AGR.KERPRG("2.M12.2",[1,"M12.2",[[1,1,2,1],[[3,12]]]]);
AGR.KERPRG("2.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("2.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[3,1,3,1],[4,1,4,1],[5,1,6,1],[[7,3]]]]);
AGR.KERPRG("2.S6(2)",[1,"S6(2)",[[[1,2]]]]);
AGR.KERPRG("2.Sz(8)",[1,"Sz(8)",[[2,1,1,1],[1,1,3,1],[2,2],[5,1,1,1],[4,1,6,1],[2,-1],[1,1,2,1],[8,1,9,1],[6,1,10,1],[7,1,11,1],[1,1,5,1],[13,2],[8,1,1,1],[1,1,15,1],[3,1,5,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,8,1],[13,1,24,1],[18,1,25,1],[23,1,26,1],[[20,1,27,1]]]]);
AGR.KERPRG("2.U4(2)",[1,"U4(2)",[[1,-1],[2,-1],[3,1,4,1],[5,2],[1,1,2,1],[7,2],[6,1,8,1],[[9,2]]]]);
AGR.KERPRG("2^2.Sz(8).3",[1,"Sz(8).3",[[1,-1],[3,1,2,1],[2,-1],[3,1,5,1],[4,1,6,1],[2,1,3,1],[3,1,8,1],[6,1,9,1],[7,1,10,1],[5,1,3,1],[12,2],[2,1,6,1],[8,1,14,1],[13,1,15,1],[11,1,16,1],[1,1,2,1],[1,1,5,1],[18,1,19,1],[2,1,1,1],[1,1,21,1],[19,1,22,1],[20,1,23,1],[5,1,1,1],[21,1,25,1],[2,1,19,1],[21,1,27,1],[26,1,28,1],[24,1,29,1],[17,1,30,1],[[1,1,2,1],3],[[2,1,1,1],4],[[1,1,4,1],5],[[3,1,5,1],6],[[2,1,3,1],7],[[7,1,5,1],8],[[6,1,8,1],9],[[2,-1],10],[[1,1,10,1],11],[[2,1,11,1],12],[[10,1,1,1],13],[[1,1,13,1],14],[[12,1,14,1],15],[[10,1,11,1],16],[[16,1,5,1],17],[[15,1,17,1],18],[[9,1,18,1],19],[[4,1,7,1],20],[[14,1,7,1],21],[[20,1,21,1],22],[[5,1,16,1],23],[[14,1,16,1],24],[[23,1,24,1],25],[[22,1,25,1],26],[[19,1,26,1],27],[[31,1],[27,1]]]]);
AGR.KERPRG("3.A6",[1,"A6",[[1,1,2,1],[[3,5]]]]);
AGR.KERPRG("3.A6.2_1",[1,"A6.2_1",[[1,1,2,1],[2,1,3,1],[1,-1,4,-1,1,1,4,1],[[5,2]]]]);
AGR.KERPRG("3.Fi22",[1,"Fi22",[[1,1,2,1],[[3,11]]]]);
AGR.KERPRG("3.Fi22.2",[1,"Fi22.2",[[1,1,2,1],[2,-1],[1,1,4,1],[5,1,4,1],[3,1,6,1],[7,1,4,1],[[8,8]]]]);
AGR.KERPRG("3.G2(3)",[1,"G2(3)",[[1,1,2,1],[3,1,3,1],[3,3],[2,-1],[1,1,6,1],[5,1,7,1],[8,1,8,1],[9,1,4,1],[10,1,7,1],[11,1,7,1],[[12,2]]]]);
AGR.KERPRG("3.J3",[1,"J3",[[1,1,2,1],[3,2],[2,1,1,1],[1,1,5,1],[3,1,6,1],[4,1,7,1],[2,1,3,1],[5,1,9,1],[10,1,7,1],[8,1,11,1],[5,2],[13,1,10,1],[7,1,10,1],[14,1,15,1],[[12,1,16,1]]]]);
AGR.KERPRG("3.J3.2",[1,"J3.2",[[1,-1],[2,-1],[4,1,3,1],[3,1,5,1],[2,1,3,1],[7,2],[6,1,8,1],[3,1,4,1],[4,1,10,1],[10,2],[11,1,12,1],[9,1,13,1],[2,1,1,1],[1,1,15,1],[15,2],[16,1,17,1],[1,1,4,1],[2,1,19,1],[1,1,2,1],[19,1,21,1],[20,1,22,1],[18,1,23,1],[14,1,24,1],[[25,2]]]]);
AGR.KERPRG("3.L3(4)",[1,"L3(4)",[[2,1,1,1],[1,1,3,1],[3,2],[4,1,5,1],[1,1,2,1],[2,1,7,1],[7,2],[8,1,9,1],[[6,1,10,1]]]]);
AGR.KERPRG("3.M22",[1,"M22",[[1,1,2,1],[[3,11]]]]);
AGR.KERPRG("3.M22.2",[1,"M22.2",[[1,-1,2,-1,1,1,2,1],[[3,4]]]]);
AGR.KERPRG("3.McL",[1,"McL",[[1,1,2,1],[[3,11]]]]);
AGR.KERPRG("3.McL.2",[1,"McL.2",[[1,1,2,1],[2,-1],[1,1,4,1],[3,1,5,1],[2,1,6,1],[7,1,1,1],[8,1,8,1],[9,1,2,1],[5,1,5,1],[10,1,11,1],[[1,-1,12,-1,1,1,12,1]]]]);
AGR.KERPRG("3.U3(8)",[1,"U3(8)",[[1,1,2,1],[3,3],[2,-1],[1,1,5,1],[4,1,6,1],[7,3],[8,1,6,1],[9,1,3,1],[6,3],[10,1,11,1],[12,1,3,1],[13,1,6,1],[[14,1,6,1]]]]);
AGR.KERPRG("4.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("4.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[3,1,3,1],[4,1,4,1],[5,1,6,1],[[7,3]]]]);
AGR.KERPRG("4_1.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("4_2.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("6.A6",[1,"A6",[[1,1,2,1],[[3,5],[1,2]]]]);
AGR.KERPRG("6.A6.2_1",[1,"A6.2_1",[[1,1,2,1],[2,1,3,1],[1,-1,4,-1,1,1,4,1],[[5,2]]]]);
AGR.KERPRG("6.Fi22",[1,"2.Fi22",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,1,3,1],[7,1,5,1],[6,1,8,1],[4,1,7,1],[5,1,7,1],[10,1,11,1],[[9,1,12,1]]]]);
AGR.KERPRG("6.Fi22",[1,"Fi22",[[1,1,2,1],[3,1,2,1],[[3,11],[4,21]]]]);
AGR.KERPRG("6.Fi22.2",[1,"3.Fi22.2",[[1,-1],[2,-1],[4,1,1,1],[3,1,5,1],[3,1,4,1],[2,1,7,1],[6,1,8,1],[2,1,3,1],[1,1,10,1],[1,1,2,1],[4,1,12,1],[11,1,13,1],[[9,1,14,1]]]]);
AGR.KERPRG("6.Fi22.2",[1,"Fi22.2",[[1,1,2,1],[1,-1,2,-1,1,1,2,1],[2,-1],[1,1,5,1],[6,1,5,1],[3,1,7,1],[8,1,5,1],[[9,8],[4,3]]]]);
AGR.KERPRG("6.L3(4)",[1,"L3(4)",[[1,1,2,1],[2,1,1,1],[1,1,4,1],[3,1,5,1],[2,2],[7,1,1,1],[2,-1],[9,1,3,1],[8,1,10,1],[6,1,11,1],[1,1,7,1],[3,1,13,1],[9,1,1,1],[1,1,15,1],[2,1,3,1],[16,1,17,1],[14,1,18,1],[12,1,19,1],[13,1,16,1],[17,1,13,1],[21,1,22,1],[1,1,9,1],[24,1,5,1],[4,1,7,1],[26,1,24,1],[25,1,27,1],[23,1,28,1],[[20,1,29,1]]]]);
AGR.KERPRG("6.M22",[1,"M22",[[1,1,2,1],[3,1,3,1],[2,-1],[1,1,5,1],[4,1,6,1],[[7,5]]]]);
AGR.KERPRG("6.M22.2",[1,"M22.2",[[1,1,2,1],[3,1,2,1],[1,-1,2,-1,1,1,2,1],[3,1,3,1],[4,1,4,1],[6,1,7,1],[[5,4],[8,3]]]]);
AGR.KERPRG("Isoclinic(2.A14.2)",[1,"A14.2",[[[1,2]]]]);
AGR.KERPRG("Isoclinic(2.A5.2)",[1,"A5.2",[[[1,2]]]]);
AGR.KERPRG("Isoclinic(2.L3(2).2)",[1,"L3(2).2",[[1,1,2,1],[[3,8]]]]);
AGR.KERPRG("Isoclinic(2.M12.2)",[1,"M12.2",[[[1,2]]]]);


#############################################################################
##
##  In the following, the table of contents is built
##  using `AGR.GRP' and `AGR.TOC'.
##  This part of the file is created by the function
##  `RecomputeAtlasTableOfContents',
##  do not edit below this line!
##
# 2A10
AGR.GRP("alt","A10","2A10");
AGR.TOC("matff","2A10G1-f3r16B0.m",2);
AGR.TOC("matff","2A10G1-f5r8B0.m",2);
AGR.TOC("matff","2A10G1-f5r56B0.m",2);
AGR.TOC("matff","2A10G1-f7r16B0.m",2);

# A10
AGR.GRP("alt","A10","A10");
AGR.TOC("perm","A10G1-p10B0.m",2);
AGR.TOC("perm","A10G1-p45B0.m",2);
AGR.TOC("perm","A10G1-p120B0.m",2);
AGR.TOC("perm","A10G1-p126B0.m",2);
AGR.TOC("perm","A10G1-p210B0.m",2);
AGR.TOC("perm","A10G1-p945B0.m",2);
AGR.TOC("perm","A10G1-p2520B0.m",2);
AGR.TOC("matff","A10G1-f2r8B0.m",2);
AGR.TOC("matff","A10G1-f2r16B0.m",2);
AGR.TOC("matff","A10G1-f2r26B0.m",2);
AGR.TOC("matff","A10G1-f2r48B0.m",2);
AGR.TOC("matff","A10G1-f2r64aB0.m",2);
AGR.TOC("matff","A10G1-f2r64bB0.m",2);
AGR.TOC("matff","A10G1-f2r160B0.m",2);
AGR.TOC("matff","A10G1-f2r198B0.m",2);
AGR.TOC("matff","A10G1-f2r200B0.m",2);
AGR.TOC("matff","A10G1-f3r9B0.m",2);
AGR.TOC("matff","A10G1-f3r34B0.m",2);
AGR.TOC("matff","A10G1-f3r36B0.m",2);
AGR.TOC("matff","A10G1-f3r41B0.m",2);
AGR.TOC("matff","A10G1-f3r84B0.m",2);
AGR.TOC("matff","A10G1-f3r90B0.m",2);
AGR.TOC("matff","A10G1-f3r126B0.m",2);
AGR.TOC("matff","A10G1-f3r224B0.m",2);
AGR.TOC("matff","A10G1-f3r279B0.m",2);
AGR.TOC("matff","A10G1-f3r567B0.m",2);
AGR.TOC("matff","A10G1-f4r384aB0.m",2);
AGR.TOC("matff","A10G1-f5r8B0.m",2);
AGR.TOC("matff","A10G1-f5r28B0.m",2);
AGR.TOC("matff","A10G1-f5r34B0.m",2);
AGR.TOC("matff","A10G1-f5r35aB0.m",2);
AGR.TOC("matff","A10G1-f5r35bB0.m",2);
AGR.TOC("matff","A10G1-f5r35cB0.m",2);
AGR.TOC("matff","A10G1-f5r55B0.m",2);
AGR.TOC("matff","A10G1-f5r56B0.m",2);
AGR.TOC("matff","A10G1-f5r75B0.m",2);
AGR.TOC("matff","A10G1-f5r133aB0.m",2);
AGR.TOC("matff","A10G1-f5r133bB0.m",2);
AGR.TOC("matff","A10G1-f5r155B0.m",2);
AGR.TOC("matff","A10G1-f5r160B0.m",2);
AGR.TOC("matff","A10G1-f5r217B0.m",2);
AGR.TOC("matff","A10G1-f5r225B0.m",2);
AGR.TOC("matff","A10G1-f5r300B0.m",2);
AGR.TOC("matff","A10G1-f5r350B0.m",2);
AGR.TOC("matff","A10G1-f5r450B0.m",2);
AGR.TOC("matff","A10G1-f5r525B0.m",2);
AGR.TOC("matff","A10G1-f7r9B0.m",2);
AGR.TOC("matff","A10G1-f7r35B0.m",2);
AGR.TOC("matff","A10G1-f7r36B0.m",2);
AGR.TOC("matff","A10G1-f7r66B0.m",2);
AGR.TOC("matff","A10G1-f7r84B0.m",2);
AGR.TOC("matff","A10G1-f7r89B0.m",2);
AGR.TOC("matff","A10G1-f7r124B0.m",2);
AGR.TOC("matff","A10G1-f7r126B0.m",2);
AGR.TOC("matff","A10G1-f7r315B0.m",2);
AGR.TOC("matint","A10G1-Zr9B0.g");
AGR.TOC("matint","A10G1-Zr35B0.g");
AGR.TOC("matint","A10G1-Zr36B0.g");
AGR.TOC("matint","A10G1-Zr42B0.g");
AGR.TOC("matint","A10G1-Zr75B0.g");
AGR.TOC("matint","A10G1-Zr84B0.g");
AGR.TOC("matint","A10G1-Zr90B0.g");
AGR.TOC("matint","A10G1-Zr126B0.g");
AGR.TOC("matint","A10G1-Zr160B0.g");
AGR.TOC("matint","A10G1-Zr210B0.g");
AGR.TOC("matint","A10G1-Zr224aB0.g");
AGR.TOC("matint","A10G1-Zr224bB0.g");
AGR.TOC("matint","A10G1-Zr225B0.g");
AGR.TOC("check","A10G1-check1");

# S10
AGR.GRP("alt","A10","S10");
AGR.TOC("perm","S10G1-p10B0.m",2);

# 2A11
AGR.GRP("alt","A11","2A11");
AGR.TOC("perm","2A11G1-p5040B0.m",2);
AGR.TOC("matff","2A11G1-f3r16aB0.m",2);
AGR.TOC("matff","2A11G1-f3r16bB0.m",2);
AGR.TOC("matff","2A11G1-f3r144B0.m",2);
AGR.TOC("matff","2A11G1-f5r16aB0.m",2);
AGR.TOC("matff","2A11G1-f5r16bB0.m",2);
AGR.TOC("matff","2A11G1-f5r56aB0.m",2);
AGR.TOC("matff","2A11G1-f5r56bB0.m",2);
AGR.TOC("matff","2A11G1-f7r32B0.m",2);
AGR.TOC("matff","2A11G1-f7r144B0.m",2);
AGR.TOC("matff","2A11G1-f11r16B0.m",2);
AGR.TOC("matff","2A11G1-f11r128B0.m",2);
AGR.TOC("matff","2A11G1-f49r16aB0.m",2);
AGR.TOC("matff","2A11G1-f49r16bB0.m",2);

# 2S11
AGR.GRP("alt","A11","2S11");
AGR.TOC("matff","2S11G1-f3r32B0.m",2);
AGR.TOC("matff","2S11G1-f5r32B0.m",2);
AGR.TOC("matff","2S11G1-f7r32B0.m",2);
AGR.TOC("matff","2S11G1-f11r16B0.m",2);

# A11
AGR.GRP("alt","A11","A11");
AGR.TOC("perm","A11G1-p11B0.m",2);
AGR.TOC("perm","A11G1-p55B0.m",2);
AGR.TOC("perm","A11G1-p165B0.m",2);
AGR.TOC("perm","A11G1-p330B0.m",2);
AGR.TOC("perm","A11G1-p462B0.m",2);
AGR.TOC("perm","A11G1-p2520aB0.m",2);
AGR.TOC("perm","A11G1-p2520bB0.m",2);
AGR.TOC("matff","A11G1-f2r10B0.m",2);
AGR.TOC("matff","A11G1-f2r32B0.m",2);
AGR.TOC("matff","A11G1-f2r44B0.m",2);
AGR.TOC("matff","A11G1-f2r100B0.m",2);
AGR.TOC("matff","A11G1-f2r144B0.m",2);
AGR.TOC("matff","A11G1-f2r164B0.m",2);
AGR.TOC("matff","A11G1-f2r186B0.m",2);
AGR.TOC("matff","A11G1-f2r198B0.m",2);
AGR.TOC("matff","A11G1-f2r416B0.m",2);
AGR.TOC("matff","A11G1-f2r848B0.m",2);
AGR.TOC("matff","A11G1-f3r10B0.m",2);
AGR.TOC("matff","A11G1-f3r34B0.m",2);
AGR.TOC("matff","A11G1-f3r45B0.m",2);
AGR.TOC("matff","A11G1-f3r109B0.m",2);
AGR.TOC("matff","A11G1-f3r120B0.m",2);
AGR.TOC("matff","A11G1-f3r126aB0.m",2);
AGR.TOC("matff","A11G1-f3r126bB0.m",2);
AGR.TOC("matff","A11G1-f3r131B0.m",2);
AGR.TOC("matff","A11G1-f4r16aB0.m",2);
AGR.TOC("matff","A11G1-f4r16bB0.m",2);
AGR.TOC("matff","A11G1-f4r584aB0.m",2);
AGR.TOC("matff","A11G1-f5r10B0.m",2);
AGR.TOC("matff","A11G1-f5r43B0.m",2);
AGR.TOC("matff","A11G1-f5r45B0.m",2);
AGR.TOC("matff","A11G1-f5r55B0.m",2);
AGR.TOC("matff","A11G1-f5r89B0.m",2);
AGR.TOC("matff","A11G1-f5r110B0.m",2);
AGR.TOC("matff","A11G1-f5r120B0.m",2);
AGR.TOC("matff","A11G1-f7r10B0.m",2);
AGR.TOC("matff","A11G1-f7r44B0.m",2);
AGR.TOC("matff","A11G1-f7r45B0.m",2);
AGR.TOC("matff","A11G1-f7r66B0.m",2);
AGR.TOC("matff","A11G1-f11r9B0.m",2);
AGR.TOC("matff","A11G1-f11r36B0.m",2);
AGR.TOC("matff","A11G1-f11r44B0.m",2);
AGR.TOC("matff","A11G1-f11r84B0.m",2);
AGR.TOC("matint","A11G1-Zr10B0.g");
AGR.TOC("matint","A11G1-Zr44B0.g");
AGR.TOC("matint","A11G1-Zr45B0.g");
AGR.TOC("matint","A11G1-Zr110B0.g");
AGR.TOC("matint","A11G1-Zr120B0.g");
AGR.TOC("matint","A11G1-Zr132B0.g");
AGR.TOC("matint","A11G1-Zr165B0.g");
AGR.TOC("matint","A11G1-Zr210B0.g");
AGR.TOC("matint","A11G1-Zr231B0.g");
AGR.TOC("matint","A11G1-Zr252B0.g");
AGR.TOC("check","A11G1-check1");

# S11
AGR.GRP("alt","A11","S11");
AGR.TOC("perm","S11G1-p11B0.m",2);
AGR.TOC("matff","S11G1-f2r32B0.m",2);

# 2A12
AGR.GRP("alt","A12","2A12");
AGR.TOC("matff","2A12G1-f3r16aB0.m",2);
AGR.TOC("matff","2A12G1-f3r16bB0.m",2);
AGR.TOC("matff","2A12G1-f5r32B0.m",2);
AGR.TOC("matff","2A12G1-f7r32B0.m",2);
AGR.TOC("matff","2A12G1-f11r32B0.m",2);

# A12
AGR.GRP("alt","A12","A12");
AGR.TOC("perm","A12G1-p12B0.m",2);
AGR.TOC("perm","A12G1-p66B0.m",2);
AGR.TOC("perm","A12G1-p220B0.m",2);
AGR.TOC("perm","A12G1-p462B0.m",2);
AGR.TOC("perm","A12G1-p495B0.m",2);
AGR.TOC("perm","A12G1-p792B0.m",2);
AGR.TOC("perm","A12G1-p2520B0.m",2);
AGR.TOC("matff","A12G1-f2r10B0.m",2);
AGR.TOC("matff","A12G1-f2r44B0.m",2);
AGR.TOC("matff","A12G1-f2r100B0.m",2);
AGR.TOC("matff","A12G1-f3r10B0.m",2);
AGR.TOC("matff","A12G1-f3r45B0.m",2);
AGR.TOC("matff","A12G1-f3r54B0.m",2);
AGR.TOC("matff","A12G1-f4r16aB0.m",2);
AGR.TOC("matff","A12G1-f4r16bB0.m",2);
AGR.TOC("matff","A12G1-f5r11B0.m",2);
AGR.TOC("matff","A12G1-f5r43B0.m",2);
AGR.TOC("matff","A12G1-f5r55B0.m",2);
AGR.TOC("matff","A12G1-f5r89B0.m",2);
AGR.TOC("matint","A12G1-Zr11B0.g");
AGR.TOC("matint","A12G1-Zr54B0.g");
AGR.TOC("matint","A12G1-Zr55B0.g");
AGR.TOC("matint","A12G1-Zr132B0.g");
AGR.TOC("matint","A12G1-Zr154B0.g");
AGR.TOC("matint","A12G1-Zr165B0.g");
AGR.TOC("check","A12G1-check1");

# S12
AGR.GRP("alt","A12","S12");
AGR.TOC("perm","S12G1-p12B0.m",2);
AGR.TOC("perm","S12G1-p66B0.m",2);
AGR.TOC("perm","S12G1-p220B0.m",2);
AGR.TOC("perm","S12G1-p462B0.m",2);
AGR.TOC("perm","S12G1-p495B0.m",2);
AGR.TOC("perm","S12G1-p792B0.m",2);
AGR.TOC("perm","S12G1-p5040B0.m",2);
AGR.TOC("perm","S12G1-p5775B0.m",2);
AGR.TOC("perm","S12G1-p10395B0.m",2);
AGR.TOC("perm","S12G1-p15400B0.m",2);

# 2A13
AGR.GRP("alt","A13","2A13");
AGR.TOC("matff","2A13G1-f3r32aB0.m",2);
AGR.TOC("matff","2A13G1-f3r32bB0.m",2);
AGR.TOC("matff","2A13G1-f5r64B0.m",2);
AGR.TOC("matff","2A13G1-f7r64B0.m",2);
AGR.TOC("matff","2A13G1-f11r64B0.m",2);
AGR.TOC("matff","2A13G1-f13r32B0.m",2);
AGR.TOC("matff","2A13G1-f25r32aB0.m",2);
AGR.TOC("matff","2A13G1-f25r32bB0.m",2);
AGR.TOC("matff","2A13G1-f49r32aB0.m",2);
AGR.TOC("matff","2A13G1-f49r32bB0.m",2);
AGR.TOC("matff","2A13G1-f121r32aB0.m",2);
AGR.TOC("matff","2A13G1-f121r32bB0.m",2);

# A13
AGR.GRP("alt","A13","A13");
AGR.TOC("perm","A13G1-p13B0.m",2);
AGR.TOC("perm","A13G1-p78B0.m",2);
AGR.TOC("matff","A13G1-f2r64B0.m",2);
AGR.TOC("matff","A13G1-f4r32aB0.m",2);
AGR.TOC("matff","A13G1-f4r32bB0.m",2);
AGR.TOC("matint","A13G1-Zr12B0.g");
AGR.TOC("matint","A13G1-Zr65B0.g");
AGR.TOC("matint","A13G1-Zr66B0.g");
AGR.TOC("matint","A13G1-Zr208B0.g");
AGR.TOC("matint","A13G1-Zr220B0.g");
AGR.TOC("check","A13G1-check1");

# S13
AGR.GRP("alt","A13","S13");
AGR.TOC("perm","S13G1-p13B0.m",2);
AGR.TOC("perm","S13G1-p78B0.m",2);

# 2A14
AGR.GRP("alt","A14","2A14");
AGR.TOC("matff","2A14G1-f3r64B0.m",2);
AGR.TOC("matff","2A14G1-f5r64B0.m",2);
AGR.TOC("matff","2A14G1-f7r64B0.m",2);
AGR.TOC("matff","2A14G1-f11r64B0.m",2);
AGR.TOC("matff","2A14G1-f13r64B0.m",2);
AGR.TOC("matff","2A14G1-f49r32aB0.m",2);
AGR.TOC("matff","2A14G1-f49r32bB0.m",2);
AGR.TOC("pres","2A14G1-P1");

# 2S14
AGR.GRP("alt","A14","2S14");
AGR.TOC("matff","2S14G1-f7r64B0.m",2);
AGR.TOC("pres","2S14G1-P1");

# 2S14i
AGR.GRP("alt","A14","2S14i");
AGR.TOC("matff","2S14iG1-f7r64B0.m",2);
AGR.TOC("pres","2S14iG1-P1");

# A14
AGR.GRP("alt","A14","A14");
AGR.TOC("perm","A14G1-p14B0.m",2);
AGR.TOC("perm","A14G1-p91B0.m",2);
AGR.TOC("perm","A14G1-p364B0.m",2);
AGR.TOC("perm","A14G1-p1001B0.m",2);
AGR.TOC("perm","A14G1-p1716B0.m",2);
AGR.TOC("perm","A14G1-p2002B0.m",2);
AGR.TOC("perm","A14G1-p3003B0.m",2);
AGR.TOC("matff","A14G1-f2r12B0.m",2);
AGR.TOC("matff","A14G1-f2r64aB0.m",2);
AGR.TOC("matff","A14G1-f2r64bB0.m",2);
AGR.TOC("matff","A14G1-f3r13B0.m",2);
AGR.TOC("matff","A14G1-f3r64B0.m",2);
AGR.TOC("matff","A14G1-f3r78B0.m",2);
AGR.TOC("matff","A14G1-f5r13B0.m",2);
AGR.TOC("matff","A14G1-f5r77B0.m",2);
AGR.TOC("matff","A14G1-f5r78B0.m",2);
AGR.TOC("matff","A14G1-f7r12B0.m",2);
AGR.TOC("matff","A14G1-f7r66B0.m",2);
AGR.TOC("matff","A14G1-f7r77B0.m",2);
AGR.TOC("matff","A14G1-f11r13B0.m",2);
AGR.TOC("matff","A14G1-f11r77B0.m",2);
AGR.TOC("matff","A14G1-f11r78B0.m",2);
AGR.TOC("matff","A14G1-f13r13B0.m",2);
AGR.TOC("matff","A14G1-f13r76B0.m",2);
AGR.TOC("matff","A14G1-f13r78B0.m",2);
AGR.TOC("matint","A14G1-Zr13B0.g");
AGR.TOC("matint","A14G1-Zr77B0.g");
AGR.TOC("matint","A14G1-Zr78B0.g");
AGR.TOC("check","A14G1-check1");
AGR.TOC("pres","A14G1-P1");

# S14
AGR.GRP("alt","A14","S14");
AGR.TOC("perm","S14G1-p14B0.m",2);
AGR.TOC("perm","S14G1-p91B0.m",2);
AGR.TOC("perm","S14G1-p364B0.m",2);
AGR.TOC("perm","S14G1-p1001B0.m",2);
AGR.TOC("perm","S14G1-p1716B0.m",2);
AGR.TOC("perm","S14G1-p2002B0.m",2);
AGR.TOC("perm","S14G1-p3003B0.m",2);
AGR.TOC("matff","S14G1-f2r12B0.m",2);
AGR.TOC("matff","S14G1-f2r64aB0.m",2);
AGR.TOC("matff","S14G1-f2r64bB0.m",2);
AGR.TOC("matff","S14G1-f7r12B0.m",2);
AGR.TOC("pres","S14G1-P1");

# A15
AGR.GRP("alt","A15","A15");
AGR.TOC("perm","A15G1-p15B0.m",2);
AGR.TOC("perm","A15G1-p105B0.m",2);
AGR.TOC("perm","A15G1-p455B0.m",2);
AGR.TOC("perm","A15G1-p1365B0.m",2);
AGR.TOC("matint","A15G1-Zr14B0.g");
AGR.TOC("matint","A15G1-Zr90B0.g");
AGR.TOC("matint","A15G1-Zr91B0.g");
AGR.TOC("matint","A15G1-Zr350B0.g");
AGR.TOC("matint","A15G1-Zr364B0.g");
AGR.TOC("check","A15G1-check1");

# S15
AGR.GRP("alt","A15","S15");
AGR.TOC("perm","S15G1-p15B0.m",2);
AGR.TOC("perm","S15G1-p105B0.m",2);
AGR.TOC("perm","S15G1-p455B0.m",2);
AGR.TOC("perm","S15G1-p1365B0.m",2);
AGR.TOC("matint","S15G1-Zr14B0.g");
AGR.TOC("matint","S15G1-Zr90B0.g");
AGR.TOC("matint","S15G1-Zr91B0.g");
AGR.TOC("matint","S15G1-Zr350B0.g");
AGR.TOC("matint","S15G1-Zr364B0.g");

# A16
AGR.GRP("alt","A16","A16");
AGR.TOC("perm","A16G1-p16B0.m",2);
AGR.TOC("perm","A16G1-p120B0.m",2);
AGR.TOC("perm","A16G1-p560B0.m",2);
AGR.TOC("perm","A16G1-p1820B0.m",2);
AGR.TOC("matint","A16G1-Zr15B0.g");
AGR.TOC("matint","A16G1-Zr104B0.g");
AGR.TOC("matint","A16G1-Zr105B0.g");
AGR.TOC("matint","A16G1-Zr440B0.g");
AGR.TOC("matint","A16G1-Zr455B0.g");
AGR.TOC("check","A16G1-check1");

# S16
AGR.GRP("alt","A16","S16");
AGR.TOC("perm","S16G1-p16B0.m",2);
AGR.TOC("perm","S16G1-p120B0.m",2);
AGR.TOC("perm","S16G1-p560B0.m",2);
AGR.TOC("perm","S16G1-p1820B0.m",2);
AGR.TOC("matint","S16G1-Zr15B0.g");
AGR.TOC("matint","S16G1-Zr104B0.g");
AGR.TOC("matint","S16G1-Zr105B0.g");
AGR.TOC("matint","S16G1-Zr440B0.g");
AGR.TOC("matint","S16G1-Zr455B0.g");

# A17
AGR.GRP("alt","A17","A17");
AGR.TOC("perm","A17G1-p17B0.m",2);
AGR.TOC("perm","A17G1-p136B0.m",2);
AGR.TOC("perm","A17G1-p680B0.m",2);
AGR.TOC("perm","A17G1-p2380B0.m",2);
AGR.TOC("matint","A17G1-Zr16B0.g");
AGR.TOC("matint","A17G1-Zr119B0.g");
AGR.TOC("matint","A17G1-Zr120B0.g");
AGR.TOC("matint","A17G1-Zr544B0.g");
AGR.TOC("matint","A17G1-Zr560B0.g");
AGR.TOC("check","A17G1-check1");

# S17
AGR.GRP("alt","A17","S17");
AGR.TOC("perm","S17G1-p17B0.m",2);
AGR.TOC("perm","S17G1-p136B0.m",2);
AGR.TOC("perm","S17G1-p680B0.m",2);
AGR.TOC("perm","S17G1-p2380B0.m",2);
AGR.TOC("matint","S17G1-Zr16B0.g");
AGR.TOC("matint","S17G1-Zr119B0.g");
AGR.TOC("matint","S17G1-Zr120B0.g");
AGR.TOC("matint","S17G1-Zr544B0.g");
AGR.TOC("matint","S17G1-Zr560B0.g");

# A18
AGR.GRP("alt","A18","A18");
AGR.TOC("perm","A18G1-p18B0.m",2);
AGR.TOC("perm","A18G1-p153B0.m",2);
AGR.TOC("perm","A18G1-p816B0.m",2);
AGR.TOC("perm","A18G1-p3060B0.m",2);
AGR.TOC("matint","A18G1-Zr17B0.g");
AGR.TOC("matint","A18G1-Zr135B0.g");
AGR.TOC("matint","A18G1-Zr136B0.g");
AGR.TOC("check","A18G1-check1");

# S18
AGR.GRP("alt","A18","S18");
AGR.TOC("perm","S18G1-p18B0.m",2);
AGR.TOC("perm","S18G1-p153B0.m",2);
AGR.TOC("perm","S18G1-p816B0.m",2);
AGR.TOC("perm","S18G1-p3060B0.m",2);
AGR.TOC("matint","S18G1-Zr17B0.g");
AGR.TOC("matint","S18G1-Zr135B0.g");
AGR.TOC("matint","S18G1-Zr136B0.g");

# A19
AGR.GRP("alt","A19","A19");
AGR.TOC("perm","A19G1-p19B0.m",2);
AGR.TOC("perm","A19G1-p171B0.m",2);
AGR.TOC("perm","A19G1-p969B0.m",2);
AGR.TOC("matint","A19G1-Zr18B0.g");
AGR.TOC("matint","A19G1-Zr152B0.g");
AGR.TOC("matint","A19G1-Zr153B0.g");
AGR.TOC("check","A19G1-check1");

# S19
AGR.GRP("alt","A19","S19");
AGR.TOC("perm","S19G1-p19B0.m",2);
AGR.TOC("perm","S19G1-p171B0.m",2);
AGR.TOC("perm","S19G1-p969B0.m",2);
AGR.TOC("matint","S19G1-Zr18B0.g");
AGR.TOC("matint","S19G1-Zr152B0.g");
AGR.TOC("matint","S19G1-Zr153B0.g");

# A20
AGR.GRP("alt","A20","A20");
AGR.TOC("perm","A20G1-p20B0.m",2);
AGR.TOC("perm","A20G1-p190B0.m",2);
AGR.TOC("matint","A20G1-Zr19B0.g");
AGR.TOC("matint","A20G1-Zr170B0.g");
AGR.TOC("matint","A20G1-Zr171B0.g");
AGR.TOC("check","A20G1-check1");

# S20
AGR.GRP("alt","A20","S20");
AGR.TOC("perm","S20G1-p20B0.m",2);
AGR.TOC("perm","S20G1-p190B0.m",2);
AGR.TOC("matint","S20G1-Zr19B0.g");
AGR.TOC("matint","S20G1-Zr170B0.g");
AGR.TOC("matint","S20G1-Zr171B0.g");

# A21
AGR.GRP("alt","A21","A21");
AGR.TOC("perm","A21G1-p21B0.m",2);
AGR.TOC("perm","A21G1-p210B0.m",2);
AGR.TOC("matint","A21G1-Zr20B0.g");
AGR.TOC("matint","A21G1-Zr189B0.g");
AGR.TOC("matint","A21G1-Zr190B0.g");
AGR.TOC("check","A21G1-check1");

# S21
AGR.GRP("alt","A21","S21");
AGR.TOC("perm","S21G1-p21B0.m",2);
AGR.TOC("perm","S21G1-p210B0.m",2);
AGR.TOC("matint","S21G1-Zr20B0.g");
AGR.TOC("matint","S21G1-Zr189B0.g");
AGR.TOC("matint","S21G1-Zr190B0.g");

# A22
AGR.GRP("alt","A22","A22");
AGR.TOC("perm","A22G1-p22B0.m",2);
AGR.TOC("perm","A22G1-p231B0.m",2);
AGR.TOC("matint","A22G1-Zr21B0.g");
AGR.TOC("matint","A22G1-Zr209B0.g");
AGR.TOC("matint","A22G1-Zr210B0.g");
AGR.TOC("check","A22G1-check1");

# S22
AGR.GRP("alt","A22","S22");
AGR.TOC("perm","S22G1-p22B0.m",2);
AGR.TOC("perm","S22G1-p231B0.m",2);
AGR.TOC("matint","S22G1-Zr21B0.g");
AGR.TOC("matint","S22G1-Zr209B0.g");
AGR.TOC("matint","S22G1-Zr210B0.g");

# A23
AGR.GRP("alt","A23","A23");
AGR.TOC("perm","A23G1-p23B0.m",2);
AGR.TOC("perm","A23G1-p253B0.m",2);
AGR.TOC("matint","A23G1-Zr22B0.g");
AGR.TOC("matint","A23G1-Zr230B0.g");
AGR.TOC("matint","A23G1-Zr231B0.g");
AGR.TOC("check","A23G1-check1");

# S23
AGR.GRP("alt","A23","S23");
AGR.TOC("perm","S23G1-p23B0.m",2);
AGR.TOC("perm","S23G1-p253B0.m",2);
AGR.TOC("matint","S23G1-Zr22B0.g");
AGR.TOC("matint","S23G1-Zr230B0.g");
AGR.TOC("matint","S23G1-Zr231B0.g");

# 2A5
AGR.GRP("alt","A5","2A5");
AGR.TOC("perm","2A5G1-p24B0.m",2);
AGR.TOC("perm","2A5G1-p40B0.m",2);
AGR.TOC("matff","2A5G1-f2r8B0.m",2);
AGR.TOC("matff","2A5G1-f2r9B0.m",2);
AGR.TOC("matff","2A5G1-f2r10B0.m",2);
AGR.TOC("matff","2A5G1-f3r4B0.m",2);
AGR.TOC("matff","2A5G1-f3r6B0.m",2);
AGR.TOC("matff","2A5G1-f4r5aB0.m",2);
AGR.TOC("matff","2A5G1-f4r5bB0.m",2);
AGR.TOC("matff","2A5G1-f5r2B0.m",2);
AGR.TOC("matff","2A5G1-f5r4B0.m",2);
AGR.TOC("matff","2A5G1-f7r4aB0.m",2);
AGR.TOC("matff","2A5G1-f7r4bB0.m",2);
AGR.TOC("matff","2A5G1-f7r6B0.m",2);
AGR.TOC("matff","2A5G1-f9r2aB0.m",2);
AGR.TOC("matff","2A5G1-f9r2bB0.m",2);
AGR.TOC("matff","2A5G1-f49r2aB0.m",2);
AGR.TOC("matff","2A5G1-f49r2bB0.m",2);
AGR.TOC("matint","2A5G1-Zr8bB0.g");
AGR.TOC("matint","2A5G1-Zr12B0.g");
AGR.TOC("matalg","2A5G1-Ar2aB0.g");
AGR.TOC("matalg","2A5G1-Ar4aB0.g");
AGR.TOC("matalg","2A5G1-Ar4aB2.g");
AGR.TOC("matalg","2A5G1-Ar6B0.g");
AGR.TOC("matalg","2A5G1-Ar6B1.g");
AGR.TOC("quat","2A5G1-Hr1aB0.g");
AGR.TOC("pres","2A5G1-P1");

# 2S5
AGR.GRP("alt","A5","2S5");
AGR.TOC("perm","2S5G1-p40aB0.m",2);
AGR.TOC("perm","2S5G1-p40bB0.m",2);
AGR.TOC("perm","2S5G1-p48B0.m",2);
AGR.TOC("matff","2S5G1-f3r4B0.m",2);
AGR.TOC("matff","2S5G1-f3r6B0.m",2);
AGR.TOC("matff","2S5G1-f5r4bB0.m",2);
AGR.TOC("matff","2S5G1-f5r8B0.m",2);
AGR.TOC("matff","2S5G1-f25r2B0.m",2);
AGR.TOC("matff","2S5G1-f25r4aB0.m",2);
AGR.TOC("matint","2S5G1-Zr8aB0.g");
AGR.TOC("matalg","2S5G1-Ar4bB0.g");
AGR.TOC("pres","2S5G1-P1");

# 2S5i
AGR.GRP("alt","A5","2S5i");
AGR.TOC("perm","2S5iG1-p48B0.m",2);
AGR.TOC("perm","2S5iG1-p80B0.m",2);
AGR.TOC("matff","2S5iG1-f3r4B0.m",2);
AGR.TOC("matff","2S5iG1-f3r12B0.m",2);
AGR.TOC("matff","2S5iG1-f5r4bB0.m",2);
AGR.TOC("matff","2S5iG1-f5r8B0.m",2);
AGR.TOC("matff","2S5iG1-f9r6B0.m",2);
AGR.TOC("matff","2S5iG1-f25r2B0.m",2);
AGR.TOC("matff","2S5iG1-f25r4aB0.m",2);
AGR.TOC("matalg","2S5iG1-Ar4aB1.g");
AGR.TOC("matalg","2S5iG1-Ar4aB2.g");
AGR.TOC("pres","2S5iG1-P1");

# A5
AGR.GRP("alt","A5","A5");
AGR.TOC("perm","A5G1-p5B0.m",2);
AGR.TOC("perm","A5G1-p6B0.m",2);
AGR.TOC("perm","A5G1-p10B0.m",2);
AGR.TOC("matff","A5G1-f2r4aB0.m",2);
AGR.TOC("matff","A5G1-f2r4bB0.m",2);
AGR.TOC("matff","A5G1-f3r4B0.m",2);
AGR.TOC("matff","A5G1-f3r6B0.m",2);
AGR.TOC("matff","A5G1-f4r2aB0.m",2);
AGR.TOC("matff","A5G1-f4r2bB0.m",2);
AGR.TOC("matff","A5G1-f5r3B0.m",2);
AGR.TOC("matff","A5G1-f5r5B0.m",2);
AGR.TOC("matff","A5G1-f9r3aB0.m",2);
AGR.TOC("matff","A5G1-f9r3bB0.m",2);
AGR.TOC("matint","A5G1-Zr4B0.g");
AGR.TOC("matint","A5G1-Zr5B0.g");
AGR.TOC("matint","A5G1-Zr6B0.g");
AGR.TOC("matalg","A5G1-Ar3aB0.g");
AGR.TOC("matalg","A5G1-Ar3bB0.g");
AGR.TOC("maxes","A5G1-max1W1");
AGR.TOC("maxes","A5G1-max2W1");
AGR.TOC("maxes","A5G1-max3W1");
AGR.TOC("check","A5G1-check1");
AGR.TOC("pres","A5G1-P1");

# S5
AGR.GRP("alt","A5","S5");
AGR.TOC("perm","S5G1-p5B0.m",2);
AGR.TOC("perm","S5G1-p6B0.m",2);
AGR.TOC("perm","S5G1-p10B0.m",2);
AGR.TOC("matff","S5G1-f2r4aB0.m",2);
AGR.TOC("matff","S5G1-f2r4bB0.m",2);
AGR.TOC("matff","S5G1-f3r4B0.m",2);
AGR.TOC("matff","S5G1-f3r6B0.m",2);
AGR.TOC("matff","S5G1-f5r3B0.m",2);
AGR.TOC("matff","S5G1-f5r5B0.m",2);
AGR.TOC("maxes","S5G1-max1W1");
AGR.TOC("maxes","S5G1-max2W1");
AGR.TOC("maxes","S5G1-max3W1");
AGR.TOC("maxes","S5G1-max4W1");
AGR.TOC("pres","S5G1-P1");

# 2A6
AGR.GRP("alt","A6","2A6");
AGR.TOC("perm","2A6G1-p80B0.m",2);
AGR.TOC("perm","2A6G1-p144B0.m",2);
AGR.TOC("perm","2A6G1-p240aB0.m",2);
AGR.TOC("perm","2A6G1-p240bB0.m",2);
AGR.TOC("matff","2A6G1-f3r4B0.m",2);
AGR.TOC("matff","2A6G1-f3r12B0.m",2);
AGR.TOC("matff","2A6G1-f5r4aB0.m",2);
AGR.TOC("matff","2A6G1-f5r4bB0.m",2);
AGR.TOC("matff","2A6G1-f5r20B0.m",2);
AGR.TOC("matff","2A6G1-f9r2aB0.m",2);
AGR.TOC("matff","2A6G1-f9r2bB0.m",2);
AGR.TOC("matff","2A6G1-f9r6aB0.m",2);
AGR.TOC("matff","2A6G1-f9r6bB0.m",2);
AGR.TOC("matff","2A6G1-f25r10aB0.m",2);
AGR.TOC("matff","2A6G1-f25r10bB0.m",2);
AGR.TOC("matalg","2A6G1-Ar4B0.g");
AGR.TOC("matalg","2A6G1-Ar4aB0.g");
AGR.TOC("quat","2A6G1-Hr2aB0.g");

# 2S6
AGR.GRP("alt","A6","2S6");
AGR.TOC("perm","2S6G1-p80B0.m",2);
AGR.TOC("perm","2S6G1-p240aB0.m",2);
AGR.TOC("perm","2S6G1-p288B0.m",2);

# 3A6
AGR.GRP("alt","A6","3A6");
AGR.TOC("perm","3A6G1-p18aB0.m",2);
AGR.TOC("perm","3A6G1-p18bB0.m",2);
AGR.TOC("perm","3A6G1-p45aB0.m",2);
AGR.TOC("perm","3A6G1-p45bB0.m",2);
AGR.TOC("matff","3A6G1-f2r6aB0.m",2);
AGR.TOC("matff","3A6G1-f2r6bB0.m",2);
AGR.TOC("matff","3A6G1-f2r18B0.m",2);
AGR.TOC("matff","3A6G1-f4r3aB0.m",2);
AGR.TOC("matff","3A6G1-f4r3bB0.m",2);
AGR.TOC("matff","3A6G1-f4r9aB0.m",2);
AGR.TOC("matff","3A6G1-f5r6bB0.m",2);
AGR.TOC("matff","3A6G1-f5r12B0.m",2);
AGR.TOC("matff","3A6G1-f5r30B0.m",2);
AGR.TOC("matff","3A6G1-f25r3aB0.m",2);
AGR.TOC("matff","3A6G1-f25r6aB0.m",2);
AGR.TOC("matff","3A6G1-f25r15aB0.m",2);
AGR.TOC("matalg","3A6G1-Ar3aB0.g");
AGR.TOC("matalg","3A6G1-Ar6B0.g");
AGR.TOC("matalg","3A6G1-Ar9B0.g");
AGR.TOC("matalg","3A6G1-Ar15B0.g");

# 3S6
AGR.GRP("alt","A6","3S6");
AGR.TOC("perm","3S6G1-p18aB0.m",2);
AGR.TOC("perm","3S6G1-p18bB0.m",2);
AGR.TOC("perm","3S6G1-p45aB0.m",2);
AGR.TOC("perm","3S6G1-p45bB0.m",2);

# 6A6
AGR.GRP("alt","A6","6A6");
AGR.TOC("perm","6A6G1-p432B0.m",2);
AGR.TOC("perm","6A6G1-p720aB0.m",2);
AGR.TOC("matff","6A6G1-f5r12aB0.m",2);
AGR.TOC("matff","6A6G1-f5r12bB0.m",2);
AGR.TOC("matff","6A6G1-f9r6aB0.m",2);
AGR.TOC("matff","6A6G1-f25r6aB0.m",2);
AGR.TOC("matff","6A6G1-f25r6bB0.m",2);
AGR.TOC("matalg","6A6G1-Ar12B0.g");

# 6S6
AGR.GRP("alt","A6","6S6");
AGR.TOC("perm","6S6G1-p720aB0.m",2);

# A6
AGR.GRP("alt","A6","A6");
AGR.TOC("perm","A6G1-p6aB0.m",2);
AGR.TOC("perm","A6G1-p6bB0.m",2);
AGR.TOC("perm","A6G1-p10B0.m",2);
AGR.TOC("perm","A6G1-p15aB0.m",2);
AGR.TOC("perm","A6G1-p15bB0.m",2);
AGR.TOC("matff","A6G1-f2r4aB0.m",2);
AGR.TOC("matff","A6G1-f2r4bB0.m",2);
AGR.TOC("matff","A6G1-f2r16B0.m",2);
AGR.TOC("matff","A6G1-f3r4B0.m",2);
AGR.TOC("matff","A6G1-f3r6B0.m",2);
AGR.TOC("matff","A6G1-f3r9B0.m",2);
AGR.TOC("matff","A6G1-f4r8aB0.m",2);
AGR.TOC("matff","A6G1-f4r8bB0.m",2);
AGR.TOC("matff","A6G1-f5r5aB0.m",2);
AGR.TOC("matff","A6G1-f5r5bB0.m",2);
AGR.TOC("matff","A6G1-f5r8B0.m",2);
AGR.TOC("matff","A6G1-f5r10B0.m",2);
AGR.TOC("matff","A6G1-f9r3aB0.m",2);
AGR.TOC("matff","A6G1-f9r3bB0.m",2);
AGR.TOC("matint","A6G1-Zr5aB0.g");
AGR.TOC("matint","A6G1-Zr5bB0.g");
AGR.TOC("matint","A6G1-Zr9B0.g");
AGR.TOC("matint","A6G1-Zr10B0.g");
AGR.TOC("matint","A6G1-Zr16B0.g");
AGR.TOC("matalg","A6G1-Ar8aB0.g");
AGR.TOC("matalg","A6G1-Ar8bB0.g");
AGR.TOC("maxes","A6G1-max1W1");
AGR.TOC("maxes","A6G1-max2W1");
AGR.TOC("maxes","A6G1-max3W1");
AGR.TOC("maxes","A6G1-max4W1");
AGR.TOC("maxes","A6G1-max5W1");
AGR.TOC("check","A6G1-check1");
AGR.TOC("pres","A6G1-P1");

# A6V4
AGR.GRP("alt","A6","A6V4");
AGR.TOC("perm","A6V4G1-p10B0.m",2);
AGR.TOC("pres","A6V4G1-P1");

# M10
AGR.GRP("alt","A6","M10");
AGR.TOC("perm","M10G1-p10B0.m",2);
AGR.TOC("pres","M10G1-P1");

# PGL29
AGR.GRP("alt","A6","PGL29");
AGR.TOC("perm","PGL29G1-p10B0.m",2);
AGR.TOC("pres","PGL29G1-P1");

# S6
AGR.GRP("alt","A6","S6");
AGR.TOC("perm","S6G1-p6aB0.m",2);
AGR.TOC("perm","S6G1-p6bB0.m",2);
AGR.TOC("perm","S6G1-p10B0.m",2);
AGR.TOC("perm","S6G1-p15aB0.m",2);
AGR.TOC("perm","S6G1-p15bB0.m",2);
AGR.TOC("maxes","S6G1-max1W1");
AGR.TOC("maxes","S6G1-max2W1");
AGR.TOC("maxes","S6G1-max3W1");
AGR.TOC("maxes","S6G1-max4W1");
AGR.TOC("maxes","S6G1-max5W1");
AGR.TOC("maxes","S6G1-max6W1");
AGR.TOC("pres","S6G1-P1");

# 2A7
AGR.GRP("alt","A7","2A7");
AGR.TOC("perm","2A7G1-p240B0.m",2);
AGR.TOC("matff","2A7G1-f3r8B0.m",2);
AGR.TOC("matff","2A7G1-f3r12B0.m",2);
AGR.TOC("matff","2A7G1-f3r36B0.m",2);
AGR.TOC("matff","2A7G1-f5r8B0.m",2);
AGR.TOC("matff","2A7G1-f5r20aB0.m",2);
AGR.TOC("matff","2A7G1-f5r20bB0.m",2);
AGR.TOC("matff","2A7G1-f5r28B0.m",2);
AGR.TOC("matff","2A7G1-f7r4B0.m",2);
AGR.TOC("matff","2A7G1-f7r14aB0.m",2);
AGR.TOC("matff","2A7G1-f7r14bB0.m",2);
AGR.TOC("matff","2A7G1-f7r16B0.m",2);
AGR.TOC("matff","2A7G1-f7r20B0.m",2);
AGR.TOC("matff","2A7G1-f9r4aB0.m",2);
AGR.TOC("matff","2A7G1-f9r4bB0.m",2);
AGR.TOC("matff","2A7G1-f9r6aB0.m",2);
AGR.TOC("matff","2A7G1-f9r6bB0.m",2);
AGR.TOC("matff","2A7G1-f25r4aB0.m",2);
AGR.TOC("matff","2A7G1-f25r4bB0.m",2);
AGR.TOC("matff","2A7G1-f25r14aB0.m",2);
AGR.TOC("matff","2A7G1-f25r14bB0.m",2);
AGR.TOC("matalg","2A7G1-Ar4aB0.g");
AGR.TOC("matalg","2A7G1-Ar4bB0.g");
AGR.TOC("matalg","2A7G1-Ar20aB0.g");

# 2S7
AGR.GRP("alt","A7","2S7");
AGR.TOC("matff","2S7G1-f7r8B0.m",2);
AGR.TOC("matff","2S7G1-f7r28B0.m",2);
AGR.TOC("matff","2S7G1-f7r32B0.m",2);
AGR.TOC("matff","2S7G1-f7r40B0.m",2);
AGR.TOC("matff","2S7G1-f49r4aB0.m",2);
AGR.TOC("matff","2S7G1-f49r16aB0.m",2);
AGR.TOC("matff","2S7G1-f49r20aB0.m",2);

# 2S7i
AGR.GRP("alt","A7","2S7i");
AGR.TOC("matff","2S7iG1-f3r8B0.m",2);
AGR.TOC("matff","2S7iG1-f3r12B0.m",2);
AGR.TOC("matff","2S7iG1-f3r36aB0.m",2);
AGR.TOC("matff","2S7iG1-f5r8B0.m",2);
AGR.TOC("matff","2S7iG1-f5r20B0.m",2);
AGR.TOC("matff","2S7iG1-f5r28B0.m",2);
AGR.TOC("matff","2S7iG1-f5r40B0.m",2);
AGR.TOC("matff","2S7iG1-f7r4aB0.m",2);
AGR.TOC("matff","2S7iG1-f7r16aB0.m",2);
AGR.TOC("matff","2S7iG1-f7r20aB0.m",2);
AGR.TOC("matff","2S7iG1-f7r28B0.m",2);
AGR.TOC("matff","2S7iG1-f25r20aB0.m",2);

# 3A7
AGR.GRP("alt","A7","3A7");
AGR.TOC("perm","3A7G1-p45aB0.m",2);
AGR.TOC("perm","3A7G1-p45bB0.m",2);
AGR.TOC("perm","3A7G1-p63B0.m",2);
AGR.TOC("perm","3A7G1-p315B0.m",2);
AGR.TOC("matff","3A7G1-f2r12B0.m",2);
AGR.TOC("matff","3A7G1-f2r30B0.m",2);
AGR.TOC("matff","3A7G1-f2r48aB0.m",2);
AGR.TOC("matff","3A7G1-f2r48bB0.m",2);
AGR.TOC("matff","3A7G1-f4r6B0.m",2);
AGR.TOC("matff","3A7G1-f4r15B0.m",2);
AGR.TOC("matff","3A7G1-f4r24aB0.m",2);
AGR.TOC("matff","3A7G1-f4r24bB0.m",2);
AGR.TOC("matff","3A7G1-f5r6B0.m",2);
AGR.TOC("matff","3A7G1-f5r12B0.m",2);
AGR.TOC("matff","3A7G1-f5r30aB0.m",2);
AGR.TOC("matff","3A7G1-f5r30bB0.m",2);
AGR.TOC("matff","3A7G1-f5r36B0.m",2);
AGR.TOC("matff","3A7G1-f5r42B0.m",2);
AGR.TOC("matff","3A7G1-f7r6B0.m",2);
AGR.TOC("matff","3A7G1-f7r9B0.m",2);
AGR.TOC("matff","3A7G1-f7r15B0.m",2);
AGR.TOC("matff","3A7G1-f7r21aB0.m",2);
AGR.TOC("matff","3A7G1-f7r21bB0.m",2);
AGR.TOC("matff","3A7G1-f25r3B0.m",2);
AGR.TOC("matff","3A7G1-f25r6B0.m",2);
AGR.TOC("matff","3A7G1-f25r15aB0.m",2);
AGR.TOC("matff","3A7G1-f25r15bB0.m",2);
AGR.TOC("matff","3A7G1-f25r18B0.m",2);
AGR.TOC("matff","3A7G1-f25r21B0.m",2);
AGR.TOC("matalg","3A7G1-Ar6B0.g");
AGR.TOC("matalg","3A7G1-Ar15aB0.g");
AGR.TOC("matalg","3A7G1-Ar15bB0.g");
AGR.TOC("matalg","3A7G1-Ar21aB0.g");
AGR.TOC("matalg","3A7G1-Ar21bB0.g");

# 3S7
AGR.GRP("alt","A7","3S7");
AGR.TOC("perm","3S7G1-p63B0.m",2);
AGR.TOC("perm","3S7G1-p90B0.m",2);
AGR.TOC("matff","3S7G1-f2r12B0.m",2);
AGR.TOC("matff","3S7G1-f2r30B0.m",2);
AGR.TOC("matff","3S7G1-f2r96B0.m",2);
AGR.TOC("matff","3S7G1-f5r6B0.m",2);
AGR.TOC("matff","3S7G1-f5r12B0.m",2);
AGR.TOC("matff","3S7G1-f5r30aB0.m",2);
AGR.TOC("matff","3S7G1-f5r30bB0.m",2);
AGR.TOC("matff","3S7G1-f5r36B0.m",2);
AGR.TOC("matff","3S7G1-f5r42B0.m",2);
AGR.TOC("matff","3S7G1-f7r12B0.m",2);
AGR.TOC("matff","3S7G1-f7r18B0.m",2);
AGR.TOC("matff","3S7G1-f7r30B0.m",2);
AGR.TOC("matff","3S7G1-f7r42aB0.m",2);
AGR.TOC("matff","3S7G1-f7r42bB0.m",2);

# 6A7
AGR.GRP("alt","A7","6A7");
AGR.TOC("perm","6A7G1-p720B0.m",2);
AGR.TOC("matff","6A7G1-f5r12aB0.m",2);
AGR.TOC("matff","6A7G1-f5r12bB0.m",2);
AGR.TOC("matff","6A7G1-f5r24B0.m",2);
AGR.TOC("matff","6A7G1-f5r48B0.m",2);
AGR.TOC("matff","6A7G1-f7r6aB0.m",2);
AGR.TOC("matff","6A7G1-f7r6bB0.m",2);
AGR.TOC("matff","6A7G1-f7r24B0.m",2);
AGR.TOC("matff","6A7G1-f25r6aB0.m",2);
AGR.TOC("matff","6A7G1-f25r6bB0.m",2);
AGR.TOC("matff","6A7G1-f25r12B0.m",2);
AGR.TOC("matff","6A7G1-f25r24B0.m",2);

# 6S7
AGR.GRP("alt","A7","6S7");
AGR.TOC("matff","6S7G1-f7r12B0.m",2);
AGR.TOC("matff","6S7G1-f7r48B0.m",2);

# A7
AGR.GRP("alt","A7","A7");
AGR.TOC("perm","A7G1-p7B0.m",2);
AGR.TOC("matff","A7G1-f2r4aB0.m",2);
AGR.TOC("matff","A7G1-f2r4bB0.m",2);
AGR.TOC("matff","A7G1-f2r6B0.m",2);
AGR.TOC("matff","A7G1-f2r14B0.m",2);
AGR.TOC("matff","A7G1-f2r20B0.m",2);
AGR.TOC("matff","A7G1-f3r6B0.m",2);
AGR.TOC("matff","A7G1-f3r13B0.m",2);
AGR.TOC("matff","A7G1-f3r15B0.m",2);
AGR.TOC("matff","A7G1-f3r20B0.m",2);
AGR.TOC("matff","A7G1-f5r6B0.m",2);
AGR.TOC("matff","A7G1-f5r8B0.m",2);
AGR.TOC("matff","A7G1-f5r13B0.m",2);
AGR.TOC("matff","A7G1-f5r15B0.m",2);
AGR.TOC("matff","A7G1-f5r20B0.m",2);
AGR.TOC("matff","A7G1-f5r35B0.m",2);
AGR.TOC("matff","A7G1-f7r5B0.m",2);
AGR.TOC("matff","A7G1-f7r10B0.m",2);
AGR.TOC("matff","A7G1-f7r14aB0.m",2);
AGR.TOC("matff","A7G1-f7r14bB0.m",2);
AGR.TOC("matff","A7G1-f7r21B0.m",2);
AGR.TOC("matff","A7G1-f7r35B0.m",2);
AGR.TOC("matff","A7G1-f9r10aB0.m",2);
AGR.TOC("matff","A7G1-f9r10bB0.m",2);
AGR.TOC("matff","A7G1-f25r10aB0.m",2);
AGR.TOC("matff","A7G1-f25r10bB0.m",2);
AGR.TOC("matint","A7G1-Zr6B0.g");
AGR.TOC("matint","A7G1-Zr14aB0.g");
AGR.TOC("matint","A7G1-Zr14bB0.g");
AGR.TOC("matint","A7G1-Zr15B0.g");
AGR.TOC("matint","A7G1-Zr20B0.g");
AGR.TOC("matint","A7G1-Zr21B0.g");
AGR.TOC("matint","A7G1-Zr35B0.g");
AGR.TOC("maxes","A7G1-max1W1");
AGR.TOC("maxes","A7G1-max2W1");
AGR.TOC("check","A7G1-check1");

# S7
AGR.GRP("alt","A7","S7");
AGR.TOC("perm","S7G1-p7B0.m",2);
AGR.TOC("perm","S7G1-p21B0.m",2);
AGR.TOC("perm","S7G1-p30B0.m",2);
AGR.TOC("perm","S7G1-p35B0.m",2);
AGR.TOC("perm","S7G1-p120B0.m",2);
AGR.TOC("matff","S7G1-f2r6B0.m",2);
AGR.TOC("matff","S7G1-f2r8B0.m",2);
AGR.TOC("matff","S7G1-f2r14B0.m",2);
AGR.TOC("matff","S7G1-f2r20B0.m",2);
AGR.TOC("matff","S7G1-f3r6aB0.m",2);
AGR.TOC("matff","S7G1-f3r13aB0.m",2);
AGR.TOC("matff","S7G1-f3r15aB0.m",2);
AGR.TOC("matff","S7G1-f3r20B0.m",2);
AGR.TOC("matff","S7G1-f5r6aB0.m",2);
AGR.TOC("matff","S7G1-f5r8aB0.m",2);
AGR.TOC("matff","S7G1-f5r13aB0.m",2);
AGR.TOC("matff","S7G1-f5r15aB0.m",2);
AGR.TOC("matff","S7G1-f5r20B0.m",2);
AGR.TOC("matff","S7G1-f5r35aB0.m",2);
AGR.TOC("matff","S7G1-f7r5aB0.m",2);
AGR.TOC("matff","S7G1-f7r10aB0.m",2);
AGR.TOC("matff","S7G1-f7r14aB0.m",2);
AGR.TOC("matff","S7G1-f7r14bB0.m",2);
AGR.TOC("matff","S7G1-f7r21aB0.m",2);
AGR.TOC("matff","S7G1-f7r35aB0.m",2);
AGR.TOC("maxes","S7G1-max1W1");
AGR.TOC("maxes","S7G1-max2W1");
AGR.TOC("maxes","S7G1-max3W1");
AGR.TOC("maxes","S7G1-max4W1");
AGR.TOC("maxes","S7G1-max5W1");

# 2A8
AGR.GRP("alt","A8","2A8");
AGR.TOC("perm","2A8G1-p240aB0.m",2);
AGR.TOC("perm","2A8G1-p240bB0.m",2);
AGR.TOC("perm","2A8G1-p240cB0.m",2);
AGR.TOC("matff","2A8G1-f3r8B0.m",2);
AGR.TOC("matff","2A8G1-f3r48aB0.m",2);
AGR.TOC("matff","2A8G1-f3r48bB0.m",2);
AGR.TOC("matff","2A8G1-f5r8B0.m",2);
AGR.TOC("matff","2A8G1-f5r48aB0.m",2);
AGR.TOC("matff","2A8G1-f5r48bB0.m",2);
AGR.TOC("matff","2A8G1-f5r64B0.m",2);
AGR.TOC("matff","2A8G1-f7r8B0.m",2);
AGR.TOC("matff","2A8G1-f7r16B0.m",2);
AGR.TOC("matff","2A8G1-f7r48B0.m",2);
AGR.TOC("matff","2A8G1-f7r56aB0.m",2);
AGR.TOC("matff","2A8G1-f7r56bB0.m",2);
AGR.TOC("matff","2A8G1-f7r112B0.m",2);
AGR.TOC("matff","2A8G1-f9r24aB0.m",2);
AGR.TOC("matff","2A8G1-f9r24bB0.m",2);
AGR.TOC("matff","2A8G1-f25r24aB0.m",2);
AGR.TOC("matff","2A8G1-f25r24bB0.m",2);
AGR.TOC("matff","2A8G1-f25r32aB0.m",2);
AGR.TOC("matff","2A8G1-f25r32bB0.m",2);
AGR.TOC("matff","2A8G1-f49r56cB0.m",2);
AGR.TOC("matff","2A8G1-f49r56dB0.m",2);
AGR.TOC("matint","2A8G1-Zr8B0.g");
AGR.TOC("matmodn","2A8G1-Z4r4aB0.g");

# A8
AGR.GRP("alt","A8","A8");
AGR.TOC("perm","A8G1-p8B0.m",2);
AGR.TOC("perm","A8G1-p15aB0.m",2);
AGR.TOC("perm","A8G1-p15bB0.m",2);
AGR.TOC("matff","A8G1-f2r4aB0.m",2);
AGR.TOC("matff","A8G1-f2r4bB0.m",2);
AGR.TOC("matff","A8G1-f2r6B0.m",2);
AGR.TOC("matff","A8G1-f2r14B0.m",2);
AGR.TOC("matff","A8G1-f2r20aB0.m",2);
AGR.TOC("matff","A8G1-f2r20bB0.m",2);
AGR.TOC("matff","A8G1-f2r64B0.m",2);
AGR.TOC("matint","A8G1-Zr7B0.g");
AGR.TOC("matint","A8G1-Zr14B0.g");
AGR.TOC("matint","A8G1-Zr20B0.g");
AGR.TOC("matint","A8G1-Zr21aB0.g");
AGR.TOC("matint","A8G1-Zr28B0.g");
AGR.TOC("matint","A8G1-Zr35B0.g");
AGR.TOC("matint","A8G1-Zr42B0.g");
AGR.TOC("matint","A8G1-Zr56B0.g");
AGR.TOC("matint","A8G1-Zr64B0.g");
AGR.TOC("matint","A8G1-Zr70B0.g");
AGR.TOC("matint","A8G1-Zr90B0.g");
AGR.TOC("check","A8G1-check1");

# S8
AGR.GRP("alt","A8","S8");
AGR.TOC("perm","S8G1-p8B0.m",2);
AGR.TOC("matff","S8G1-f2r6B0.m",2);
AGR.TOC("matff","S8G1-f2r8B0.m",2);
AGR.TOC("matff","S8G1-f2r14B0.m",2);
AGR.TOC("matff","S8G1-f2r40B0.m",2);
AGR.TOC("matff","S8G1-f2r64B0.m",2);

# 2A9
AGR.GRP("alt","A9","2A9");
AGR.TOC("matff","2A9G1-f3r8B0.m",2);
AGR.TOC("matff","2A9G1-f3r48B0.m",2);
AGR.TOC("matff","2A9G1-f3r104B0.m",2);
AGR.TOC("matff","2A9G1-f5r8aB0.m",2);
AGR.TOC("matff","2A9G1-f5r8bB0.m",2);
AGR.TOC("matff","2A9G1-f7r8aB0.m",2);
AGR.TOC("matff","2A9G1-f7r8bB0.m",2);
AGR.TOC("matalg","2A9G1-Ar8aB0.g");

# A9
AGR.GRP("alt","A9","A9");
AGR.TOC("perm","A9G1-p9B0.m",2);
AGR.TOC("perm","A9G1-p36B0.m",2);
AGR.TOC("perm","A9G1-p84B0.m",2);
AGR.TOC("perm","A9G1-p120aB0.m",2);
AGR.TOC("perm","A9G1-p120bB0.m",2);
AGR.TOC("perm","A9G1-p126B0.m",2);
AGR.TOC("perm","A9G1-p280B0.m",2);
AGR.TOC("perm","A9G1-p840B0.m",2);
AGR.TOC("matff","A9G1-f2r8aB0.m",2);
AGR.TOC("matff","A9G1-f2r8bB0.m",2);
AGR.TOC("matff","A9G1-f2r8cB0.m",2);
AGR.TOC("matff","A9G1-f2r20aB0.m",2);
AGR.TOC("matff","A9G1-f2r20bB0.m",2);
AGR.TOC("matff","A9G1-f2r26B0.m",2);
AGR.TOC("matff","A9G1-f2r48B0.m",2);
AGR.TOC("matff","A9G1-f2r78B0.m",2);
AGR.TOC("matff","A9G1-f2r160B0.m",2);
AGR.TOC("matff","A9G1-f3r7B0.m",2);
AGR.TOC("matff","A9G1-f3r21B0.m",2);
AGR.TOC("matff","A9G1-f3r27B0.m",2);
AGR.TOC("matff","A9G1-f3r35B0.m",2);
AGR.TOC("matff","A9G1-f3r41B0.m",2);
AGR.TOC("matff","A9G1-f3r162B0.m",2);
AGR.TOC("matff","A9G1-f3r189B0.m",2);
AGR.TOC("matff","A9G1-f5r8B0.m",2);
AGR.TOC("matff","A9G1-f5r21B0.m",2);
AGR.TOC("matff","A9G1-f5r27B0.m",2);
AGR.TOC("matff","A9G1-f5r28B0.m",2);
AGR.TOC("matff","A9G1-f5r34B0.m",2);
AGR.TOC("matff","A9G1-f5r35aB0.m",2);
AGR.TOC("matff","A9G1-f5r35bB0.m",2);
AGR.TOC("matff","A9G1-f5r56B0.m",2);
AGR.TOC("matff","A9G1-f5r83B0.m",2);
AGR.TOC("matff","A9G1-f5r105B0.m",2);
AGR.TOC("matff","A9G1-f5r120B0.m",2);
AGR.TOC("matff","A9G1-f5r133B0.m",2);
AGR.TOC("matff","A9G1-f5r134B0.m",2);
AGR.TOC("matff","A9G1-f7r8B0.m",2);
AGR.TOC("matff","A9G1-f7r19B0.m",2);
AGR.TOC("matff","A9G1-f7r28B0.m",2);
AGR.TOC("matff","A9G1-f7r35aB0.m",2);
AGR.TOC("matff","A9G1-f7r35bB0.m",2);
AGR.TOC("matff","A9G1-f7r42B0.m",2);
AGR.TOC("matff","A9G1-f7r47B0.m",2);
AGR.TOC("matff","A9G1-f7r56B0.m",2);
AGR.TOC("matff","A9G1-f7r84B0.m",2);
AGR.TOC("matff","A9G1-f7r101B0.m",2);
AGR.TOC("matff","A9G1-f7r105B0.m",2);
AGR.TOC("matff","A9G1-f7r115B0.m",2);
AGR.TOC("matff","A9G1-f7r168B0.m",2);
AGR.TOC("matff","A9G1-f7r189B0.m",2);
AGR.TOC("matff","A9G1-f49r21aB0.m",2);
AGR.TOC("matff","A9G1-f49r21bB0.m",2);
AGR.TOC("matint","A9G1-Zr8B0.g");
AGR.TOC("matint","A9G1-Zr27B0.g");
AGR.TOC("matint","A9G1-Zr28B0.g");
AGR.TOC("matint","A9G1-Zr35aB0.g");
AGR.TOC("matint","A9G1-Zr35bB0.g");
AGR.TOC("matint","A9G1-Zr42B0.g");
AGR.TOC("matint","A9G1-Zr48B0.g");
AGR.TOC("matint","A9G1-Zr56B0.g");
AGR.TOC("matint","A9G1-Zr84B0.g");
AGR.TOC("matint","A9G1-Zr105B0.g");
AGR.TOC("matint","A9G1-Zr120B0.g");
AGR.TOC("matint","A9G1-Zr162B0.g");
AGR.TOC("matint","A9G1-Zr168B0.g");
AGR.TOC("matint","A9G1-Zr189B0.g");
AGR.TOC("matint","A9G1-Zr216B0.g");
AGR.TOC("check","A9G1-check1");

# S9
AGR.GRP("alt","A9","S9");
AGR.TOC("perm","S9G1-p9B0.m",2);

# O10m2
AGR.GRP("clas","O10m2","O10m2");
AGR.TOC("perm","O10m2G1-p495B0.m",2);
AGR.TOC("perm","O10m2G1-p528B0.m",2);
AGR.TOC("matff","O10m2G1-f2r10B0.m",2);
AGR.TOC("matff","O10m2G1-f2r44B0.m",2);
AGR.TOC("matff","O10m2G1-f2r100B0.m",2);
AGR.TOC("matff","O10m2G1-f2r164B0.m",2);
AGR.TOC("matff","O10m2G1-f2r670B0.m",2);
AGR.TOC("matff","O10m2G1-f4r16aB0.m",2);
AGR.TOC("matff","O10m2G1-f4r16bB0.m",2);
AGR.TOC("matint","O10m2G1-Zr154B0.g");
AGR.TOC("matint","O10m2G1-Zr187B0.g");

# O10m2d2
AGR.GRP("clas","O10m2","O10m2d2");
AGR.TOC("perm","O10m2d2G1-p495B0.m",2);
AGR.TOC("perm","O10m2d2G1-p528B0.m",2);
AGR.TOC("perm","O10m2d2G1-p104448B0.m",2);
AGR.TOC("matff","O10m2d2G1-f2r10B0.m",2);
AGR.TOC("matff","O10m2d2G1-f2r32B0.m",2);
AGR.TOC("matff","O10m2d2G1-f2r44B0.m",2);
AGR.TOC("matff","O10m2d2G1-f2r100B0.m",2);
AGR.TOC("matff","O10m2d2G1-f2r164B0.m",2);
AGR.TOC("matff","O10m2d2G1-f2r670B0.m",2);

# O10p2
AGR.GRP("clas","O10p2","O10p2");
AGR.TOC("perm","O10p2G1-p496B0.m",2);
AGR.TOC("perm","O10p2G1-p527B0.m",2);
AGR.TOC("perm","O10p2G1-p2295aB0.m",2);
AGR.TOC("perm","O10p2G1-p2295bB0.m",2);
AGR.TOC("perm","O10p2G1-p19840B0.m",2);
AGR.TOC("perm","O10p2G1-p23715B0.m",2);
AGR.TOC("perm","O10p2G1-p39680B0.m",2);
AGR.TOC("matff","O10p2G1-f2r10B0.m",2);
AGR.TOC("matff","O10p2G1-f2r16aB0.m",2);
AGR.TOC("matff","O10p2G1-f2r16bB0.m",2);
AGR.TOC("matff","O10p2G1-f2r44B0.m",2);
AGR.TOC("matff","O10p2G1-f2r100B0.m",2);
AGR.TOC("matff","O10p2G1-f2r144aB0.m",2);
AGR.TOC("matff","O10p2G1-f2r144bB0.m",2);
AGR.TOC("matff","O10p2G1-f2r164B0.m",2);
AGR.TOC("matff","O10p2G1-f2r320B0.m",2);
AGR.TOC("matff","O10p2G1-f2r416aB0.m",2);
AGR.TOC("matff","O10p2G1-f2r416bB0.m",2);
AGR.TOC("matff","O10p2G1-f2r670B0.m",2);
AGR.TOC("matff","O10p2G1-f3r155B0.m",2);
AGR.TOC("matff","O10p2G1-f3r185B0.m",2);
AGR.TOC("matff","O10p2G1-f3r868B0.m",2);
AGR.TOC("matint","O10p2G1-Zr155B0.g");
AGR.TOC("matint","O10p2G1-Zr186B0.g");
AGR.TOC("maxes","O10p2G1-max1W1");
AGR.TOC("maxes","O10p2G1-max2W1");
AGR.TOC("maxes","O10p2G1-max3W1");
AGR.TOC("maxes","O10p2G1-max4W1");
AGR.TOC("out","O10p2G1-aW1");

# O10p2d2
AGR.GRP("clas","O10p2","O10p2d2");
AGR.TOC("perm","O10p2d2G1-p496B0.m",2);
AGR.TOC("perm","O10p2d2G1-p527B0.m",2);
AGR.TOC("perm","O10p2d2G1-p4590B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r10B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r32B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r44B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r100B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r164B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r288B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r320B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r670B0.m",2);
AGR.TOC("matff","O10p2d2G1-f2r832B0.m",2);
AGR.TOC("pres","O10p2d2G1-P1");

# 2O73
AGR.GRP("clas","O73","2O73");
AGR.TOC("perm","2O73G1-p2160B0.m",2);
AGR.TOC("matff","2O73G1-f3r8B0.m",2);

# 3O73
AGR.GRP("clas","O73","3O73");
AGR.TOC("matff","3O73G1-f4r27aB0.m",2);

# 3O73d2
AGR.GRP("clas","O73","3O73d2");
AGR.TOC("matff","3O73d2G1-f2r54B0.m",2);

# O73
AGR.GRP("clas","O73","O73");
AGR.TOC("perm","O73G1-p351B0.m",2);
AGR.TOC("perm","O73G1-p364B0.m",2);
AGR.TOC("perm","O73G1-p378B0.m",2);
AGR.TOC("perm","O73G1-p1080aB0.m",2);
AGR.TOC("perm","O73G1-p1080bB0.m",2);
AGR.TOC("perm","O73G1-p1120B0.m",2);
AGR.TOC("perm","O73G1-p3640B0.m",2);
AGR.TOC("matff","O73G1-f2r78B0.m",2);
AGR.TOC("matff","O73G1-f2r90B0.m",2);
AGR.TOC("matff","O73G1-f2r104B0.m",2);
AGR.TOC("matff","O73G1-f2r260aB0.m",2);
AGR.TOC("matff","O73G1-f2r260bB0.m",2);
AGR.TOC("matff","O73G1-f3r7B0.m",2);
AGR.TOC("matff","O73G1-f3r21B0.m",2);
AGR.TOC("matff","O73G1-f3r27B0.m",2);
AGR.TOC("matff","O73G1-f3r35B0.m",2);
AGR.TOC("matff","O73G1-f3r63B0.m",2);
AGR.TOC("matff","O73G1-f3r189aB0.m",2);
AGR.TOC("matff","O73G1-f3r309B0.m",2);
AGR.TOC("matff","O73G1-f5r78B0.m",2);
AGR.TOC("matff","O73G1-f7r78B0.m",2);
AGR.TOC("matff","O73G1-f13r78B0.m",2);
AGR.TOC("matint","O73G1-Zr78B0.g");
AGR.TOC("matint","O73G1-Zr91B0.g");
AGR.TOC("matint","O73G1-Zr105B0.g");
AGR.TOC("matint","O73G1-Zr168B0.g");
AGR.TOC("matint","O73G1-Zr182B0.g");
AGR.TOC("matint","O73G1-Zr195B0.g");

# O73d2
AGR.GRP("clas","O73","O73d2");
AGR.TOC("perm","O73d2G1-p351B0.m",2);
AGR.TOC("matff","O73d2G1-f2r78B0.m",2);
AGR.TOC("matff","O73d2G1-f3r7B0.m",2);

# O8m2
AGR.GRP("clas","O8m2","O8m2");
AGR.TOC("perm","O8m2G1-p119B0.m",2);
AGR.TOC("perm","O8m2G1-p136B0.m",2);
AGR.TOC("perm","O8m2G1-p765B0.m",2);
AGR.TOC("perm","O8m2G1-p1071B0.m",2);
AGR.TOC("perm","O8m2G1-p1632B0.m",2);
AGR.TOC("perm","O8m2G1-p24192B0.m",2);
AGR.TOC("perm","O8m2G1-p45696B0.m",2);
AGR.TOC("matff","O8m2G1-f2r8B0.m",2);
AGR.TOC("matff","O8m2G1-f2r26B0.m",2);
AGR.TOC("matff","O8m2G1-f2r48B0.m",2);
AGR.TOC("matff","O8m2G1-f3r34B0.m",2);
AGR.TOC("matff","O8m2G1-f3r50B0.m",2);
AGR.TOC("matff","O8m2G1-f4r8bB0.m",2);
AGR.TOC("matff","O8m2G1-f4r8cB0.m",2);
AGR.TOC("matff","O8m2G1-f4r48bB0.m",2);
AGR.TOC("matff","O8m2G1-f4r48cB0.m",2);
AGR.TOC("matff","O8m2G1-f5r34B0.m",2);
AGR.TOC("matff","O8m2G1-f5r51B0.m",2);
AGR.TOC("matff","O8m2G1-f5r84B0.m",2);
AGR.TOC("matff","O8m2G1-f7r33B0.m",2);
AGR.TOC("matff","O8m2G1-f7r51B0.m",2);
AGR.TOC("matff","O8m2G1-f7r84B0.m",2);
AGR.TOC("matff","O8m2G1-f17r34B0.m",2);
AGR.TOC("matff","O8m2G1-f17r51B0.m",2);
AGR.TOC("matff","O8m2G1-f17r83B0.m",2);
AGR.TOC("matint","O8m2G1-Zr34B0.g");
AGR.TOC("matint","O8m2G1-Zr51B0.g");
AGR.TOC("matint","O8m2G1-Zr84B0.g");
AGR.TOC("matint","O8m2G1-Zr204aB0.g");
AGR.TOC("matint","O8m2G1-Zr204bB0.g");
AGR.TOC("cyclic","O8m2G1-cycW1");
AGR.TOC("cyc2ccl","O8m2G1cycW1-cclsW1");

# O8m2d2
AGR.GRP("clas","O8m2","O8m2d2");
AGR.TOC("perm","O8m2d2G1-p119B0.m",2);
AGR.TOC("matff","O8m2d2G1-f2r8B0.m",2);
AGR.TOC("matff","O8m2d2G1-f3r34B0.m",2);
AGR.TOC("matff","O8m2d2G1-f3r50B0.m",2);
AGR.TOC("cyclic","O8m2d2G1-cycW1");
AGR.TOC("cyc2ccl","O8m2d2G1cycW1-cclsW1");

# 2O8m3
AGR.GRP("clas","O8m3","2O8m3");
AGR.TOC("matff","2O8m3G1-f3r16B0.m",2);
AGR.TOC("matff","2O8m3G1-f9r8aB0.m",2);
AGR.TOC("matff","2O8m3G1-f9r8bB0.m",2);

# 2O8m3d2a
AGR.GRP("clas","O8m3","2O8m3d2a");
AGR.TOC("matff","2O8m3d2aG1-f3r16B0.m",2);

# O8m3
AGR.GRP("clas","O8m3","O8m3");
AGR.TOC("perm","O8m3G1-p1066B0.m",2);
AGR.TOC("matff","O8m3G1-f3r8B0.m",2);
AGR.TOC("matint","O8m3G1-Zr246B0.g");

# O8m3D8
AGR.GRP("clas","O8m3","O8m3D8");
AGR.TOC("matff","O8m3D8G1-f3r8B0.m",2);

# O8m3V4
AGR.GRP("clas","O8m3","O8m3V4");
AGR.TOC("perm","O8m3V4G1-p1066B0.m",2);
AGR.TOC("matff","O8m3V4G1-f3r16B0.m",2);

# O8m3d2a
AGR.GRP("clas","O8m3","O8m3d2a");
AGR.TOC("perm","O8m3d2aG1-p1066B0.m",2);
AGR.TOC("matff","O8m3d2aG1-f3r8B0.m",2);

# O8m3d2c
AGR.GRP("clas","O8m3","O8m3d2c");
AGR.TOC("perm","O8m3d2cG1-p1066B0.m",2);
AGR.TOC("perm","O8m3d2cG2-p1066B0.m",2);
AGR.TOC("matff","O8m3d2cG1-f3r8aB0.m",2);

# O8p2
AGR.GRP("clas","O8p2","O8p2");
AGR.TOC("matint","O8p2G1-Zr28B0.g");
AGR.TOC("matint","O8p2G1-Zr35aB0.g");
AGR.TOC("matint","O8p2G1-Zr35bB0.g");
AGR.TOC("matint","O8p2G1-Zr35cB0.g");
AGR.TOC("matint","O8p2G1-Zr50B0.g");
AGR.TOC("matint","O8p2G1-Zr84aB0.g");
AGR.TOC("matint","O8p2G1-Zr84bB0.g");
AGR.TOC("matint","O8p2G1-Zr84cB0.g");
AGR.TOC("matint","O8p2G1-Zr175B0.g");
AGR.TOC("matint","O8p2G1-Zr210B0.g");
AGR.TOC("matint","O8p2G1-Zr210aB0.g");
AGR.TOC("matint","O8p2G1-Zr210bB0.g");
AGR.TOC("matint","O8p2G1-Zr210cB0.g");

# O8p2d2
AGR.GRP("clas","O8p2","O8p2d2");
AGR.TOC("pres","O8p2d2G1-P1");

# 2O8p3
AGR.GRP("clas","O8p3","2O8p3");
AGR.TOC("perm","2O8p3G1-p2160aB0.m",2);
AGR.TOC("perm","2O8p3G1-p2160bB0.m",2);
AGR.TOC("perm","2O8p3G1-p2240B0.m",2);
AGR.TOC("matff","2O8p3G1-f3r8B0.m",2);
AGR.TOC("matff","2O8p3G1-f3r56B0.m",2);
AGR.TOC("matff","2O8p3G1-f3r104B0.m",2);
AGR.TOC("matff","2O8p3G1-f3r224aB0.m",2);
AGR.TOC("matff","2O8p3G1-f3r224bB0.m",2);
AGR.TOC("matff","2O8p3G1-f3r384B0.m",2);

# 4O8p3S4
AGR.GRP("clas","O8p3","4O8p3S4");
AGR.TOC("matff","4O8p3S4G2-f3r24B0.m",2);

# O8p3
AGR.GRP("clas","O8p3","O8p3");
AGR.TOC("perm","O8p3G1-p1080aB0.m",2);
AGR.TOC("perm","O8p3G1-p1080bB0.m",2);
AGR.TOC("perm","O8p3G1-p1080cB0.m",2);
AGR.TOC("perm","O8p3G1-p1080dB0.m",2);
AGR.TOC("perm","O8p3G1-p1080eB0.m",2);
AGR.TOC("perm","O8p3G1-p1080fB0.m",2);
AGR.TOC("perm","O8p3G1-p1120aB0.m",2);
AGR.TOC("perm","O8p3G1-p1120bB0.m",2);
AGR.TOC("perm","O8p3G1-p1120cB0.m",2);
AGR.TOC("perm","O8p3G1-p28431aB0.m",2);
AGR.TOC("perm","O8p3G1-p28431bB0.m",2);
AGR.TOC("perm","O8p3G1-p28431cB0.m",2);
AGR.TOC("perm","O8p3G1-p28431dB0.m",2);
AGR.TOC("perm","O8p3G1-p36400B0.m",2);
AGR.TOC("matff","O8p3G1-f2r298B0.m",2);
AGR.TOC("matff","O8p3G1-f3r28B0.m",2);
AGR.TOC("matff","O8p3G1-f3r35aB0.m",2);
AGR.TOC("matff","O8p3G1-f3r35bB0.m",2);
AGR.TOC("matff","O8p3G1-f3r35cB0.m",2);
AGR.TOC("matff","O8p3G1-f3r195B0.m",2);
AGR.TOC("matff","O8p3G1-f3r322B0.m",2);
AGR.TOC("matff","O8p3G1-f3r518aB0.m",2);
AGR.TOC("matff","O8p3G1-f3r518bB0.m",2);
AGR.TOC("matff","O8p3G1-f3r518cB0.m",2);
AGR.TOC("matff","O8p3G1-f3r567aB0.m",2);
AGR.TOC("matff","O8p3G1-f3r567bB0.m",2);
AGR.TOC("matff","O8p3G1-f3r567cB0.m",2);
AGR.TOC("matff","O8p3G1-f5r300B0.m",2);
AGR.TOC("matff","O8p3G1-f7r299B0.m",2);
AGR.TOC("matff","O8p3G1-f13r300B0.m",2);
AGR.TOC("maxes","O8p3G1-max1W1");
AGR.TOC("maxes","O8p3G1-max2W1");
AGR.TOC("maxes","O8p3G1-max7W1");
AGR.TOC("maxes","O8p3G1-max10W1");
AGR.TOC("maxes","O8p3G1-max11W1");
AGR.TOC("maxes","O8p3G1-max12W1");
AGR.TOC("maxes","O8p3G1-max13W1");

# O8p3S4
AGR.GRP("clas","O8p3","O8p3S4");
AGR.TOC("perm","O8p3S4G2-p3360B0.m",2);
AGR.TOC("perm","O8p3S4G2-p6480B0.m",2);

# 2O93
AGR.GRP("clas","O93","2O93");
AGR.TOC("matff","2O93G1-f3r16B0.m",2);

# 2O93d2
AGR.GRP("clas","O93","2O93d2");
AGR.TOC("matff","2O93d2G1-f3r16B0.m",2);

# O93
AGR.GRP("clas","O93","O93");
AGR.TOC("matff","O93G1-f3r9B0.m",2);

# O93d2
AGR.GRP("clas","O93","O93d2");
AGR.TOC("matff","O93d2G1-f3r9B0.m",2);

# S102
AGR.GRP("clas","S102","S102");
AGR.TOC("perm","S102G1-p496B0.m",2);
AGR.TOC("perm","S102G1-p528B0.m",2);
AGR.TOC("perm","S102G1-p992B0.m",2);
AGR.TOC("perm","S102G1-p1023B0.m",2);
AGR.TOC("perm","S102G1-p1056B0.m",2);
AGR.TOC("matff","S102G1-f2r10B0.m",2);
AGR.TOC("matff","S102G1-f2r32B0.m",2);
AGR.TOC("matff","S102G1-f2r44B0.m",2);
AGR.TOC("matff","S102G1-f2r100B0.m",2);
AGR.TOC("matff","S102G1-f2r164B0.m",2);
AGR.TOC("matff","S102G1-f3r155B0.m",2);
AGR.TOC("matff","S102G1-f5r155B0.m",2);
AGR.TOC("matff","S102G1-f7r155B0.m",2);
AGR.TOC("matff","S102G1-f11r155B0.m",2);
AGR.TOC("matff","S102G1-f17r155B0.m",2);
AGR.TOC("matff","S102G1-f31r155B0.m",2);
AGR.TOC("matint","S102G1-Zr155B0.g");
AGR.TOC("matint","S102G1-Zr187B0.g");
AGR.TOC("matint","S102G1-Zr341B0.g");
AGR.TOC("find","S102G1-find1");
AGR.TOC("check","S102G1-check1");
AGR.TOC("pres","S102G1-P1");

# 2S411
AGR.GRP("clas","S411","2S411");
AGR.TOC("matff","2S411G1-f11r4B0.m",2);

# S411
AGR.GRP("clas","S411","S411");
AGR.TOC("matint","S411G1-Zr122B0.g");

# 2S413
AGR.GRP("clas","S413","2S413");
AGR.TOC("matff","2S413G1-f13r4B0.m",2);

# S413
AGR.GRP("clas","S413","S413");
AGR.TOC("matint","S413G1-Zr170B0.g");

# 2S417
AGR.GRP("clas","S417","2S417");
AGR.TOC("matff","2S417G1-f17r4B0.m",2);

# S417
AGR.GRP("clas","S417","S417");
AGR.TOC("matint","S417G1-Zr290B0.g");
AGR.TOC("find","S417G1-find1");
AGR.TOC("check","S417G1-check1");

# 2S419
AGR.GRP("clas","S419","2S419");
AGR.TOC("matff","2S419G1-f19r4B0.m",2);

# S419
AGR.GRP("clas","S419","S419");
AGR.TOC("matint","S419G1-Zr362B0.g");

# S44
AGR.GRP("clas","S44","S44");
AGR.TOC("perm","S44G1-p85aB0.m",2);
AGR.TOC("perm","S44G1-p120bB0.m",2);
AGR.TOC("matff","S44G1-f3r18B0.m",2);
AGR.TOC("matff","S44G1-f4r4cB0.m",2);
AGR.TOC("matff","S44G1-f5r18B0.m",2);
AGR.TOC("matff","S44G1-f5r33bB0.m",2);
AGR.TOC("matff","S44G1-f17r18B0.m",2);
AGR.TOC("matint","S44G1-Zr18B0.g");
AGR.TOC("matint","S44G1-Zr34aB0.g");
AGR.TOC("matint","S44G1-Zr34bB0.g");
AGR.TOC("matint","S44G1-Zr50B0.g");
AGR.TOC("matint","S44G1-Zr50aB0.g");
AGR.TOC("matint","S44G1-Zr85B0.g");
AGR.TOC("matint","S44G1-Zr85aB0.g");
AGR.TOC("matint","S44G1-Zr85bB0.g");
AGR.TOC("matint","S44G1-Zr102B0.g");
AGR.TOC("matint","S44G1-Zr102aB0.g");
AGR.TOC("matint","S44G1-Zr102bB0.g");
AGR.TOC("matint","S44G1-Zr153B0.g");
AGR.TOC("matint","S44G1-Zr408aB0.g");
AGR.TOC("matint","S44G1-Zr408bB0.g");
AGR.TOC("matint","S44G1-Zr900B0.g");
AGR.TOC("matalg","S44G1-Ar51aB0.g");
AGR.TOC("matalg","S44G1-Ar51bB0.g");
AGR.TOC("matalg","S44G1-Ar204aB0.g");
AGR.TOC("matalg","S44G1-Ar204bB0.g");
AGR.TOC("maxes","S44G1-max1W1");
AGR.TOC("maxes","S44G1-max2W1");
AGR.TOC("maxes","S44G1-max3W1");
AGR.TOC("maxes","S44G1-max4W1");
AGR.TOC("maxes","S44G1-max5W1");
AGR.TOC("maxes","S44G1-max6W1");
AGR.TOC("maxes","S44G1-max7W1");
AGR.TOC("check","S44G1-check1");

# S44d2
AGR.GRP("clas","S44","S44d2");
AGR.TOC("matff","S44d2G1-f2r8aB0.m",2);

# S44d4
AGR.GRP("clas","S44","S44d4");
AGR.TOC("perm","S44d4G1-p170B0.m",2);
AGR.TOC("matff","S44d4G1-f2r16B0.m",2);

# 2S45
AGR.GRP("clas","S45","2S45");
AGR.TOC("perm","2S45G1-p624B0.m",2);
AGR.TOC("matff","2S45G1-f5r4B0.m",2);

# S45
AGR.GRP("clas","S45","S45");
AGR.TOC("perm","S45G1-p156aB0.m",2);
AGR.TOC("perm","S45G1-p156bB0.m",2);
AGR.TOC("perm","S45G1-p300B0.m",2);
AGR.TOC("perm","S45G1-p325B0.m",2);
AGR.TOC("matff","S45G1-f4r12aB0.m",2);
AGR.TOC("matff","S45G1-f5r5B0.m",2);
AGR.TOC("matff","S45G1-f9r13B0.m",2);
AGR.TOC("matint","S45G1-Zr40B0.g");
AGR.TOC("matint","S45G1-Zr65aB0.g");
AGR.TOC("matint","S45G1-Zr65bB0.g");
AGR.TOC("matint","S45G1-Zr90B0.g");
AGR.TOC("matint","S45G1-Zr104aB0.g");
AGR.TOC("matint","S45G1-Zr104bB0.g");
AGR.TOC("matint","S45G1-Zr104cB0.g");
AGR.TOC("matint","S45G1-Zr130B0.g");
AGR.TOC("matint","S45G1-Zr156B0.g");
AGR.TOC("matint","S45G1-Zr416B0.g");
AGR.TOC("matalg","S45G1-Ar13aB0.g");
AGR.TOC("matalg","S45G1-Ar13bB0.g");
AGR.TOC("maxes","S45G1-max1W1");
AGR.TOC("maxes","S45G1-max2W1");
AGR.TOC("maxes","S45G1-max3W1");
AGR.TOC("maxes","S45G1-max4W1");
AGR.TOC("maxes","S45G1-max5W1");
AGR.TOC("maxes","S45G1-max6W1");
AGR.TOC("maxes","S45G1-max7W1");
AGR.TOC("maxes","S45G1-max8W1");
AGR.TOC("check","S45G1-check1");

# S45d2
AGR.GRP("clas","S45","S45d2");
AGR.TOC("matff","S45d2G1-f2r24B0.m",2);
AGR.TOC("matff","S45d2G1-f2r40B0.m",2);
AGR.TOC("matff","S45d2G1-f2r64B0.m",2);
AGR.TOC("matff","S45d2G1-f2r104aB0.m",2);
AGR.TOC("matff","S45d2G1-f2r104bB0.m",2);
AGR.TOC("matff","S45d2G1-f3r26B0.m",2);
AGR.TOC("matff","S45d2G1-f5r5B0.m",2);

# 2S47
AGR.GRP("clas","S47","2S47");
AGR.TOC("matff","2S47G1-f7r4B0.m",2);

# 2S47d2
AGR.GRP("clas","S47","2S47d2");
AGR.TOC("matff","2S47d2G1-f7r4B0.m",2);

# S47
AGR.GRP("clas","S47","S47");
AGR.TOC("perm","S47G1-p400aB0.m",2);
AGR.TOC("perm","S47G1-p400bB0.m",2);
AGR.TOC("perm","S47G1-p1176B0.m",2);
AGR.TOC("perm","S47G1-p1225B0.m",2);
AGR.TOC("matff","S47G1-f7r5B0.m",2);
AGR.TOC("matint","S47G1-Zr126B0.g");
AGR.TOC("matint","S47G1-Zr175aB0.g");
AGR.TOC("matint","S47G1-Zr175bB0.g");
AGR.TOC("matint","S47G1-Zr224B0.g");
AGR.TOC("matalg","S47G1-Ar25aB0.g");
AGR.TOC("matalg","S47G1-Ar25bB0.g");
AGR.TOC("check","S47G1-check1");

# S47d2
AGR.GRP("clas","S47","S47d2");
AGR.TOC("perm","S47d2G1-p400aB0.m",2);
AGR.TOC("perm","S47d2G1-p400bB0.m",2);
AGR.TOC("matff","S47d2G1-f7r5B0.m",2);

# 2S49
AGR.GRP("clas","S49","2S49");
AGR.TOC("matff","2S49G1-f9r4B0.m",2);

# S49
AGR.GRP("clas","S49","S49");
AGR.TOC("matint","S49G1-Zr41aB0.g");
AGR.TOC("matint","S49G1-Zr41bB0.g");
AGR.TOC("check","S49G1-check1");

# 2S62
AGR.GRP("clas","S62","2S62");
AGR.TOC("perm","2S62G1-p240aB0.m",2);
AGR.TOC("perm","2S62G1-p240bB0.m",2);
AGR.TOC("perm","2S62G1-p480B0.m",2);
AGR.TOC("perm","2S62G1-p1920B0.m",2);
AGR.TOC("perm","2S62G1-p2160B0.m",2);
AGR.TOC("matff","2S62G1-f3r8B0.m",2);
AGR.TOC("matff","2S62G1-f3r48B0.m",2);
AGR.TOC("matff","2S62G1-f3r56aB0.m",2);
AGR.TOC("matff","2S62G1-f3r56bB0.m",2);
AGR.TOC("matff","2S62G1-f3r104B0.m",2);
AGR.TOC("matff","2S62G1-f3r272B0.m",2);
AGR.TOC("matint","2S62G1-Zr8B0.g");
AGR.TOC("pres","2S62G1-P1");

# S62
AGR.GRP("clas","S62","S62");
AGR.TOC("perm","S62G1-p28B0.m",2);
AGR.TOC("perm","S62G1-p36B0.m",2);
AGR.TOC("perm","S62G1-p56B0.m",2);
AGR.TOC("perm","S62G1-p63B0.m",2);
AGR.TOC("perm","S62G1-p72B0.m",2);
AGR.TOC("perm","S62G1-p120B0.m",2);
AGR.TOC("perm","S62G1-p126B0.m",2);
AGR.TOC("perm","S62G1-p135B0.m",2);
AGR.TOC("perm","S62G1-p240B0.m",2);
AGR.TOC("perm","S62G1-p288B0.m",2);
AGR.TOC("perm","S62G1-p315B0.m",2);
AGR.TOC("perm","S62G1-p336B0.m",2);
AGR.TOC("perm","S62G1-p378aB0.m",2);
AGR.TOC("perm","S62G1-p378bB0.m",2);
AGR.TOC("perm","S62G1-p960B0.m",2);
AGR.TOC("matff","S62G1-f2r6B0.m",2);
AGR.TOC("matff","S62G1-f2r8B0.m",2);
AGR.TOC("matff","S62G1-f2r14B0.m",2);
AGR.TOC("matff","S62G1-f2r48B0.m",2);
AGR.TOC("matff","S62G1-f2r64B0.m",2);
AGR.TOC("matff","S62G1-f2r112B0.m",2);
AGR.TOC("matff","S62G1-f2r512B0.m",2);
AGR.TOC("matff","S62G1-f3r7B0.m",2);
AGR.TOC("matff","S62G1-f3r14B0.m",2);
AGR.TOC("matff","S62G1-f3r21B0.m",2);
AGR.TOC("matff","S62G1-f3r27B0.m",2);
AGR.TOC("matff","S62G1-f3r34B0.m",2);
AGR.TOC("matff","S62G1-f3r35B0.m",2);
AGR.TOC("matff","S62G1-f3r49B0.m",2);
AGR.TOC("matff","S62G1-f3r91B0.m",2);
AGR.TOC("matff","S62G1-f3r98B0.m",2);
AGR.TOC("matff","S62G1-f3r189aB0.m",2);
AGR.TOC("matff","S62G1-f3r189bB0.m",2);
AGR.TOC("matff","S62G1-f3r189cB0.m",2);
AGR.TOC("matff","S62G1-f3r196B0.m",2);
AGR.TOC("matff","S62G1-f3r405B0.m",2);
AGR.TOC("matint","S62G1-Zr7B0.g");
AGR.TOC("matint","S62G1-Zr15B0.g");
AGR.TOC("matint","S62G1-Zr21aB0.g");
AGR.TOC("matint","S62G1-Zr21bB0.g");
AGR.TOC("matint","S62G1-Zr27B0.g");
AGR.TOC("matint","S62G1-Zr35aB0.g");
AGR.TOC("matint","S62G1-Zr35bB0.g");
AGR.TOC("matint","S62G1-Zr56B0.g");
AGR.TOC("matint","S62G1-Zr70B0.g");
AGR.TOC("matint","S62G1-Zr84B0.g");
AGR.TOC("matint","S62G1-Zr105aB0.g");
AGR.TOC("matint","S62G1-Zr105bB0.g");
AGR.TOC("matint","S62G1-Zr105cB0.g");
AGR.TOC("matint","S62G1-Zr120B0.g");
AGR.TOC("matint","S62G1-Zr168B0.g");
AGR.TOC("matint","S62G1-Zr189aB0.g");
AGR.TOC("matint","S62G1-Zr189bB0.g");
AGR.TOC("matint","S62G1-Zr189cB0.g");
AGR.TOC("matint","S62G1-Zr210aB0.g");
AGR.TOC("matint","S62G1-Zr210bB0.g");
AGR.TOC("matint","S62G1-Zr216B0.g");
AGR.TOC("maxes","S62G1-max1W1");
AGR.TOC("maxes","S62G1-max2W1");
AGR.TOC("maxes","S62G1-max3W1");
AGR.TOC("maxes","S62G1-max4W1");
AGR.TOC("maxes","S62G1-max5W1");
AGR.TOC("maxes","S62G1-max6W1");
AGR.TOC("maxes","S62G1-max7W1");
AGR.TOC("maxes","S62G1-max8W1");
AGR.TOC("classes","S62G1-cclsW1");
AGR.TOC("cyclic","S62G1-cycW1");
AGR.TOC("cyc2ccl","S62G1cycW1-cclsW1");
AGR.TOC("check","S62G1-check1");
AGR.TOC("pres","S62G1-P1");

# 2S63
AGR.GRP("clas","S63","2S63");
AGR.TOC("matff","2S63G1-f3r6B0.m",2);

# 2S63d2
AGR.GRP("clas","S63","2S63d2");
AGR.TOC("perm","2S63d2G1-p728B0.m",2);
AGR.TOC("matff","2S63d2G1-f3r6B0.m",2);

# S63
AGR.GRP("clas","S63","S63");
AGR.TOC("perm","S63G1-p364B0.m",2);
AGR.TOC("perm","S63G1-p1120B0.m",2);
AGR.TOC("perm","S63G1-p3640B0.m",2);
AGR.TOC("perm","S63G1-p7371B0.m",2);
AGR.TOC("matff","S63G1-f2r78B0.m",2);
AGR.TOC("matff","S63G1-f4r13aB0.m",2);
AGR.TOC("matff","S63G1-f7r13aB0.m",2);
AGR.TOC("matff","S63G1-f25r13aB0.m",2);
AGR.TOC("matint","S63G1-Zr105B0.g");
AGR.TOC("matint","S63G1-Zr168B0.g");
AGR.TOC("matint","S63G1-Zr195B0.g");
AGR.TOC("matalg","S63G1-Ar13aB0.g");
AGR.TOC("matalg","S63G1-Ar13bB0.g");
AGR.TOC("matalg","S63G1-Ar78B0.g");
AGR.TOC("matalg","S63G1-Ar91aB0.g");
AGR.TOC("matalg","S63G1-Ar91bB0.g");
AGR.TOC("maxes","S63G1-max1W1");
AGR.TOC("maxes","S63G1-max2W1");
AGR.TOC("maxes","S63G1-max4W1");
AGR.TOC("maxes","S63G1-max5W1");
AGR.TOC("maxes","S63G1-max6W1");
AGR.TOC("maxes","S63G1-max7W1");
AGR.TOC("maxes","S63G1-max8W1");
AGR.TOC("maxes","S63G1-max9W1");
AGR.TOC("maxes","S63G1-max10W1");
AGR.TOC("maxes","S63G1-max11W1");

# S63d2
AGR.GRP("clas","S63","S63d2");
AGR.TOC("perm","S63d2G1-p364B0.m",2);
AGR.TOC("perm","S63d2G1-p1120B0.m",2);
AGR.TOC("perm","S63d2G1-p3640B0.m",2);
AGR.TOC("perm","S63d2G1-p7371B0.m",2);
AGR.TOC("matff","S63d2G1-f2r26B0.m",2);
AGR.TOC("matff","S63d2G1-f3r13B0.m",2);

# S65
AGR.GRP("clas","S65","S65");
AGR.TOC("perm","S65G1-p3906B0.m",2);

# S82
AGR.GRP("clas","S82","S82");
AGR.TOC("perm","S82G1-p120B0.m",2);
AGR.TOC("perm","S82G1-p136B0.m",2);
AGR.TOC("perm","S82G1-p240B0.m",2);
AGR.TOC("perm","S82G1-p255B0.m",2);
AGR.TOC("perm","S82G1-p272B0.m",2);
AGR.TOC("perm","S82G1-p2295B0.m",2);
AGR.TOC("perm","S82G1-p5355B0.m",2);
AGR.TOC("matff","S82G1-f2r8B0.m",2);
AGR.TOC("matff","S82G1-f2r16B0.m",2);
AGR.TOC("matff","S82G1-f2r26B0.m",2);
AGR.TOC("matff","S82G1-f2r48B0.m",2);
AGR.TOC("matff","S82G1-f3r35B0.m",2);
AGR.TOC("matff","S82G1-f3r50B0.m",2);
AGR.TOC("matff","S82G1-f5r35B0.m",2);
AGR.TOC("matff","S82G1-f5r51B0.m",2);
AGR.TOC("matff","S82G1-f7r35B0.m",2);
AGR.TOC("matff","S82G1-f7r51B0.m",2);
AGR.TOC("matff","S82G1-f17r35B0.m",2);
AGR.TOC("matff","S82G1-f17r51B0.m",2);
AGR.TOC("matint","S82G1-Zr35B0.g");
AGR.TOC("matint","S82G1-Zr51B0.g");
AGR.TOC("matint","S82G1-Zr85B0.g");
AGR.TOC("matint","S82G1-Zr119B0.g");
AGR.TOC("matint","S82G1-Zr135B0.g");

# S83
AGR.GRP("clas","S83","S83");
AGR.TOC("perm","S83G1-p3280B0.m",2);

# 3U311
AGR.GRP("clas","U311","3U311");
AGR.TOC("matff","3U311G1-f121r3aB0.m",2);

# 3U311d2
AGR.GRP("clas","U311","3U311d2");
AGR.TOC("matff","3U311d2G1-f11r6B0.m",2);

# U311
AGR.GRP("clas","U311","U311");
AGR.TOC("perm","U311G1-p1332B0.m",2);
AGR.TOC("matff","U311G1-f2r110B0.m",2);
AGR.TOC("matff","U311G1-f2r370aB0.m",2);
AGR.TOC("matff","U311G1-f2r370bB0.m",2);
AGR.TOC("matff","U311G1-f2r370cB0.m",2);
AGR.TOC("matff","U311G1-f11r8B0.m",2);
AGR.TOC("matff","U311G1-f121r10aB0.m",2);
AGR.TOC("matint","U311G1-Zr111aB0.g");
AGR.TOC("maxes","U311G1-max1W1");

# U311d2
AGR.GRP("clas","U311","U311d2");
AGR.TOC("perm","U311d2G1-p1332B0.m",2);
AGR.TOC("matff","U311d2G1-f2r110B0.m",2);
AGR.TOC("matff","U311d2G1-f11r8B0.m",2);

# U313
AGR.GRP("clas","U313","U313");
AGR.TOC("perm","U313G1-p2198B0.m",2);

# U316
AGR.GRP("clas","U316","U316");
AGR.TOC("perm","U316G1-p4097B0.m",2);

# U33
AGR.GRP("clas","U33","U33");
AGR.TOC("perm","U33G1-p28B0.m",2);
AGR.TOC("perm","U33G1-p36B0.m",2);
AGR.TOC("perm","U33G1-p63aB0.m",2);
AGR.TOC("perm","U33G1-p63bB0.m",2);
AGR.TOC("matff","U33G1-f2r6B0.m",2);
AGR.TOC("matff","U33G1-f2r14B0.m",2);
AGR.TOC("matff","U33G1-f2r32aB0.m",2);
AGR.TOC("matff","U33G1-f2r32bB0.m",2);
AGR.TOC("matff","U33G1-f3r7B0.m",2);
AGR.TOC("matff","U33G1-f3r27B0.m",2);
AGR.TOC("matff","U33G1-f7r6B0.m",2);
AGR.TOC("matff","U33G1-f7r7aB0.m",2);
AGR.TOC("matff","U33G1-f7r14B0.m",2);
AGR.TOC("matff","U33G1-f7r21aB0.m",2);
AGR.TOC("matff","U33G1-f7r26B0.m",2);
AGR.TOC("matff","U33G1-f9r3bB0.m",2);
AGR.TOC("matff","U33G1-f9r6bB0.m",2);
AGR.TOC("matff","U33G1-f9r15bB0.m",2);
AGR.TOC("matff","U33G1-f49r7bB0.m",2);
AGR.TOC("matff","U33G1-f49r21bB0.m",2);
AGR.TOC("matff","U33G1-f49r28aB0.m",2);
AGR.TOC("matint","U33G1-Zr7aB0.g");
AGR.TOC("matint","U33G1-Zr14aB0.g");
AGR.TOC("matint","U33G1-Zr14bB0.g");
AGR.TOC("matint","U33G1-Zr21aB0.g");
AGR.TOC("matint","U33G1-Zr27B0.g");
AGR.TOC("matint","U33G1-Zr42B0.g");
AGR.TOC("matint","U33G1-Zr56B0.g");
AGR.TOC("matint","U33G1-Zr64B0.g");
AGR.TOC("matalg","U33G1-Ar6B0.g");
AGR.TOC("matalg","U33G1-Ar7bB0.g");
AGR.TOC("matalg","U33G1-Ar7cB0.g");
AGR.TOC("matalg","U33G1-Ar21bB0.g");
AGR.TOC("matalg","U33G1-Ar21cB0.g");
AGR.TOC("matalg","U33G1-Ar28aB0.g");
AGR.TOC("matalg","U33G1-Ar28bB0.g");
AGR.TOC("maxes","U33G1-max1W1");
AGR.TOC("maxes","U33G1-max2W1");
AGR.TOC("maxes","U33G1-max4W1");

# U33d2
AGR.GRP("clas","U33","U33d2");
AGR.TOC("perm","U33d2G1-p63bB0.m",2);
AGR.TOC("matff","U33d2G1-f2r6B0.m",2);
AGR.TOC("matff","U33d2G1-f2r14B0.m",2);
AGR.TOC("matff","U33d2G1-f2r64B0.m",2);
AGR.TOC("matff","U33d2G1-f3r6B0.m",2);
AGR.TOC("matff","U33d2G1-f3r7B0.m",2);
AGR.TOC("matff","U33d2G1-f3r12B0.m",2);
AGR.TOC("matff","U33d2G1-f3r27B0.m",2);
AGR.TOC("matff","U33d2G1-f3r30B0.m",2);
AGR.TOC("maxes","U33d2G1-max1W1");

# U34
AGR.GRP("clas","U34","U34");
AGR.TOC("perm","U34G1-p65B0.m",2);
AGR.TOC("perm","U34G1-p208B0.m",2);
AGR.TOC("perm","U34G1-p416B0.m",2);
AGR.TOC("perm","U34G1-p1600B0.m",2);
AGR.TOC("matff","U34G1-f2r12B0.m",2);
AGR.TOC("matff","U34G1-f2r16B0.m",2);
AGR.TOC("matff","U34G1-f2r36B0.m",2);
AGR.TOC("matff","U34G1-f2r64B0.m",2);
AGR.TOC("matff","U34G1-f2r96B0.m",2);
AGR.TOC("matff","U34G1-f3r12B0.m",2);
AGR.TOC("matff","U34G1-f3r52eB0.m",2);
AGR.TOC("matff","U34G1-f3r64B0.m",2);
AGR.TOC("matff","U34G1-f3r75aB0.m",2);
AGR.TOC("matff","U34G1-f3r75bB0.m",2);
AGR.TOC("matff","U34G1-f3r75cB0.m",2);
AGR.TOC("matff","U34G1-f3r75dB0.m",2);
AGR.TOC("matff","U34G1-f3r78B0.m",2);
AGR.TOC("matff","U34G1-f3r208B0.m",2);
AGR.TOC("matff","U34G1-f4r6aB0.m",2);
AGR.TOC("matff","U34G1-f4r6bB0.m",2);
AGR.TOC("matff","U34G1-f4r8aB0.m",2);
AGR.TOC("matff","U34G1-f4r8bB0.m",2);
AGR.TOC("matff","U34G1-f4r18aB0.m",2);
AGR.TOC("matff","U34G1-f4r18bB0.m",2);
AGR.TOC("matff","U34G1-f4r48aB0.m",2);
AGR.TOC("matff","U34G1-f4r48bB0.m",2);
AGR.TOC("matff","U34G1-f5r12B0.m",2);
AGR.TOC("matff","U34G1-f5r39B0.m",2);
AGR.TOC("matff","U34G1-f5r65B0.m",2);
AGR.TOC("matff","U34G1-f5r300B0.m",2);
AGR.TOC("matff","U34G1-f13r12B0.m",2);
AGR.TOC("matff","U34G1-f13r52eB0.m",2);
AGR.TOC("matff","U34G1-f13r63B0.m",2);
AGR.TOC("matff","U34G1-f13r65aB0.m",2);
AGR.TOC("matff","U34G1-f13r78B0.m",2);
AGR.TOC("matff","U34G1-f13r208B0.m",2);
AGR.TOC("matff","U34G1-f13r260B0.m",2);
AGR.TOC("matff","U34G1-f16r3aB0.m",2);
AGR.TOC("matff","U34G1-f16r3bB0.m",2);
AGR.TOC("matff","U34G1-f16r3cB0.m",2);
AGR.TOC("matff","U34G1-f16r3dB0.m",2);
AGR.TOC("matff","U34G1-f16r9aB0.m",2);
AGR.TOC("matff","U34G1-f16r9bB0.m",2);
AGR.TOC("matff","U34G1-f16r9cB0.m",2);
AGR.TOC("matff","U34G1-f16r9dB0.m",2);
AGR.TOC("matff","U34G1-f16r24aB0.m",2);
AGR.TOC("matff","U34G1-f16r24bB0.m",2);
AGR.TOC("matff","U34G1-f16r24cB0.m",2);
AGR.TOC("matff","U34G1-f16r24dB0.m",2);
AGR.TOC("matff","U34G1-f25r150aB0.m",2);
AGR.TOC("matff","U34G1-f25r150bB0.m",2);
AGR.TOC("matint","U34G1-Zr64B0.g");
AGR.TOC("matint","U34G1-Zr65aB0.g");
AGR.TOC("matint","U34G1-Zr260B0.g");
AGR.TOC("matint","U34G1-Zr300B0.g");
AGR.TOC("matalg","U34G1-Ar12B0.g");
AGR.TOC("matalg","U34G1-Ar13aB0.g");
AGR.TOC("matalg","U34G1-Ar13bB0.g");
AGR.TOC("matalg","U34G1-Ar13cB0.g");
AGR.TOC("matalg","U34G1-Ar13dB0.g");
AGR.TOC("matalg","U34G1-Ar52aB0.g");
AGR.TOC("matalg","U34G1-Ar52bB0.g");
AGR.TOC("matalg","U34G1-Ar52cB0.g");
AGR.TOC("matalg","U34G1-Ar52dB0.g");
AGR.TOC("maxes","U34G1-max1W1");
AGR.TOC("maxes","U34G1-max2W1");
AGR.TOC("maxes","U34G1-max3W1");
AGR.TOC("maxes","U34G1-max4W1");
AGR.TOC("out","U34G1-a4W1");
AGR.TOC("pres","U34G1-P1");

# U34d2
AGR.GRP("clas","U34","U34d2");
AGR.TOC("perm","U34d2G1-p65B0.m",2);
AGR.TOC("perm","U34d2G1-p208B0.m",2);
AGR.TOC("perm","U34d2G1-p416B0.m",2);
AGR.TOC("perm","U34d2G1-p1600B0.m",2);
AGR.TOC("maxes","U34d2G1-max1W1");
AGR.TOC("maxes","U34d2G1-max2W1");
AGR.TOC("maxes","U34d2G1-max3W1");
AGR.TOC("maxes","U34d2G1-max4W1");
AGR.TOC("maxes","U34d2G1-max5W1");
AGR.TOC("pres","U34d2G1-P1");

# U34d4
AGR.GRP("clas","U34","U34d4");
AGR.TOC("perm","U34d4G1-p65B0.m",2);
AGR.TOC("perm","U34d4G1-p208B0.m",2);
AGR.TOC("perm","U34d4G1-p416B0.m",2);
AGR.TOC("perm","U34d4G1-p1600B0.m",2);
AGR.TOC("matff","U34d4G1-f2r12B0.m",2);
AGR.TOC("matff","U34d4G1-f2r16B0.m",2);
AGR.TOC("matff","U34d4G1-f2r36B0.m",2);
AGR.TOC("matff","U34d4G1-f2r64B0.m",2);
AGR.TOC("matff","U34d4G1-f2r96B0.m",2);
AGR.TOC("matff","U34d4G1-f3r24aB0.m",2);
AGR.TOC("matff","U34d4G1-f3r52B0.m",2);
AGR.TOC("matff","U34d4G1-f3r64aB0.m",2);
AGR.TOC("matff","U34d4G1-f3r78aB0.m",2);
AGR.TOC("matff","U34d4G1-f3r208B0.m",2);
AGR.TOC("matff","U34d4G1-f3r300B0.m",2);
AGR.TOC("matff","U34d4G1-f5r12aB0.m",2);
AGR.TOC("matff","U34d4G1-f5r39aB0.m",2);
AGR.TOC("matff","U34d4G1-f5r65aB0.m",2);
AGR.TOC("matff","U34d4G1-f5r300B0.m",2);
AGR.TOC("matff","U34d4G1-f9r12aB0.m",2);
AGR.TOC("matff","U34d4G1-f13r12aB0.m",2);
AGR.TOC("matff","U34d4G1-f13r52B0.m",2);
AGR.TOC("matff","U34d4G1-f13r63aB0.m",2);
AGR.TOC("matff","U34d4G1-f13r65aB0.m",2);
AGR.TOC("matff","U34d4G1-f13r78aB0.m",2);
AGR.TOC("matff","U34d4G1-f13r208B0.m",2);
AGR.TOC("matff","U34d4G1-f13r260B0.m",2);
AGR.TOC("maxes","U34d4G1-max1W1");
AGR.TOC("maxes","U34d4G1-max2W1");
AGR.TOC("maxes","U34d4G1-max3W1");
AGR.TOC("maxes","U34d4G1-max4W1");
AGR.TOC("maxes","U34d4G1-max5W1");
AGR.TOC("pres","U34d4G1-P1");

# U35
AGR.GRP("clas","U35","U35");
AGR.TOC("perm","U35G1-p50B0.m",2);
AGR.TOC("matint","U35G1-Zr21B0.g");
AGR.TOC("matint","U35G1-Zr28aB0.g");
AGR.TOC("matint","U35G1-Zr28bB0.g");
AGR.TOC("matint","U35G1-Zr28cB0.g");
AGR.TOC("matint","U35G1-Zr84B0.g");
AGR.TOC("matint","U35G1-Zr105B0.g");
AGR.TOC("matint","U35G1-Zr125B0.g");
AGR.TOC("matint","U35G1-Zr126aB0.g");
AGR.TOC("matint","U35G1-Zr252B0.g");
AGR.TOC("matint","U35G1-Zr288B0.g");
AGR.TOC("pres","U35G1-P1");

# U35d2
AGR.GRP("clas","U35","U35d2");
AGR.TOC("perm","U35d2G1-p50B0.m",2);
AGR.TOC("perm","U35d2G1-p126B0.m",2);
AGR.TOC("perm","U35d2G1-p175B0.m",2);
AGR.TOC("perm","U35d2G1-p525B0.m",2);
AGR.TOC("perm","U35d2G1-p750B0.m",2);
AGR.TOC("matff","U35d2G1-f2r20B0.m",2);
AGR.TOC("matff","U35d2G1-f2r28B0.m",2);
AGR.TOC("matff","U35d2G1-f2r56B0.m",2);
AGR.TOC("matff","U35d2G1-f2r104B0.m",2);
AGR.TOC("matff","U35d2G1-f2r288B0.m",2);
AGR.TOC("matff","U35d2G1-f3r20aB0.m",2);
AGR.TOC("matff","U35d2G1-f3r21aB0.m",2);
AGR.TOC("matff","U35d2G1-f3r28aB0.m",2);
AGR.TOC("matff","U35d2G1-f3r56B0.m",2);
AGR.TOC("matff","U35d2G1-f3r84aB0.m",2);
AGR.TOC("matff","U35d2G1-f3r126aB0.m",2);
AGR.TOC("matff","U35d2G1-f3r252B0.m",2);
AGR.TOC("matff","U35d2G1-f3r288B0.m",2);
AGR.TOC("matff","U35d2G1-f5r8aB0.m",2);
AGR.TOC("matff","U35d2G1-f5r19aB0.m",2);
AGR.TOC("matff","U35d2G1-f5r20B0.m",2);
AGR.TOC("matff","U35d2G1-f5r63aB0.m",2);
AGR.TOC("matff","U35d2G1-f5r70B0.m",2);
AGR.TOC("matff","U35d2G1-f5r125aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r20aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r21aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r28aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r56B0.m",2);
AGR.TOC("matff","U35d2G1-f7r84aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r105aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r124aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r126aB0.m",2);
AGR.TOC("matff","U35d2G1-f7r252B0.m",2);
AGR.TOC("maxes","U35d2G1-max2W1");
AGR.TOC("maxes","U35d2G1-max2W2");
AGR.TOC("maxes","U35d2G1-max3W1");
AGR.TOC("maxes","U35d2G1-max4W1");
AGR.TOC("maxes","U35d2G1-max5W1");
AGR.TOC("maxes","U35d2G1-max6W1");
AGR.TOC("pres","U35d2G1-P1");

# U37
AGR.GRP("clas","U37","U37");
AGR.TOC("perm","U37G1-p344B0.m",2);
AGR.TOC("perm","U37G1-p688B0.m",2);
AGR.TOC("perm","U37G1-p1032B0.m",2);
AGR.TOC("perm","U37G1-p1376B0.m",2);
AGR.TOC("perm","U37G1-p2064B0.m",2);
AGR.TOC("perm","U37G1-p2107B0.m",2);
AGR.TOC("perm","U37G1-p14749B0.m",2);
AGR.TOC("perm","U37G1-p16856B0.m",2);
AGR.TOC("perm","U37G1-p43904B0.m",2);
AGR.TOC("matff","U37G1-f2r42B0.m",2);
AGR.TOC("matff","U37G1-f2r258B0.m",2);
AGR.TOC("matff","U37G1-f2r344B0.m",2);
AGR.TOC("matff","U37G1-f3r42B0.m",2);
AGR.TOC("matff","U37G1-f3r43aB0.m",2);
AGR.TOC("matff","U37G1-f7r6cB0.m",2);
AGR.TOC("matff","U37G1-f7r8B0.m",2);
AGR.TOC("matff","U37G1-f7r12B0.m",2);
AGR.TOC("matff","U37G1-f7r20B0.m",2);
AGR.TOC("matff","U37G1-f7r27B0.m",2);
AGR.TOC("matff","U37G1-f7r30aB0.m",2);
AGR.TOC("matff","U37G1-f7r30bB0.m",2);
AGR.TOC("matff","U37G1-f7r37B0.m",2);
AGR.TOC("matff","U37G1-f7r42cB0.m",2);
AGR.TOC("matff","U37G1-f7r48B0.m",2);
AGR.TOC("matff","U37G1-f43r42B0.m",2);
AGR.TOC("matff","U37G1-f43r43aB0.m",2);
AGR.TOC("matint","U37G1-Zr43aB0.g");
AGR.TOC("maxes","U37G1-max1W1");
AGR.TOC("maxes","U37G1-max2W1");
AGR.TOC("maxes","U37G1-max3W1");
AGR.TOC("maxes","U37G1-max4W1");
AGR.TOC("maxes","U37G1-max5W1");
AGR.TOC("out","U37G1-aW1");
AGR.TOC("pres","U37G1-P1");

# 3U38
AGR.GRP("clas","U38","3U38");
AGR.TOC("perm","3U38G1-p4617B0.m",2);
AGR.TOC("perm","3U38G1-p32832B0.m",2);
AGR.TOC("matff","3U38G1-f64r3aB0.m",2);

# U38
AGR.GRP("clas","U38","U38");
AGR.TOC("perm","U38G1-p513B0.m",2);
AGR.TOC("perm","U38G1-p3648B0.m",2);
AGR.TOC("matff","U38G1-f3r56B0.m",2);
AGR.TOC("matint","U38G1-Zr114B0.g");
AGR.TOC("matint","U38G1-Zr133aB0.g");
AGR.TOC("matint","U38G1-Zr133bB0.g");
AGR.TOC("matint","U38G1-Zr133cB0.g");
AGR.TOC("pres","U38G1-P1");

# U38E9
AGR.GRP("clas","U38","U38E9");
AGR.TOC("perm","U38E9G1-p513B0.m",2);
AGR.TOC("perm","U38E9G1-p3648B0.m",2);

# U38S3
AGR.GRP("clas","U38","U38S3");
AGR.TOC("perm","U38S3G1-p513B0.m",2);
AGR.TOC("perm","U38S3G1-p3648B0.m",2);

# U38S3x3
AGR.GRP("clas","U38","U38S3x3");
AGR.TOC("perm","U38S3x3G1-p513B0.m",2);
AGR.TOC("perm","U38S3x3G1-p3648B0.m",2);

# U38d2
AGR.GRP("clas","U38","U38d2");
AGR.TOC("perm","U38d2G1-p513B0.m",2);
AGR.TOC("perm","U38d2G1-p3648B0.m",2);

# U38d3a
AGR.GRP("clas","U38","U38d3a");
AGR.TOC("perm","U38d3aG1-p513B0.m",2);
AGR.TOC("perm","U38d3aG1-p3648B0.m",2);

# U38d3b
AGR.GRP("clas","U38","U38d3b");
AGR.TOC("perm","U38d3bG1-p513B0.m",2);
AGR.TOC("perm","U38d3bG1-p3648B0.m",2);

# U38d3c
AGR.GRP("clas","U38","U38d3c");
AGR.TOC("perm","U38d3cG1-p513B0.m",2);
AGR.TOC("perm","U38d3cG1-p3648B0.m",2);

# U38d6
AGR.GRP("clas","U38","U38d6");
AGR.TOC("perm","U38d6G1-p513B0.m",2);
AGR.TOC("perm","U38d6G1-p3648B0.m",2);
AGR.TOC("matff","U38d6G1-f2r24B0.m",2);
AGR.TOC("matff","U38d6G1-f2r54aB0.m",2);
AGR.TOC("matff","U38d6G1-f2r54bB0.m",2);
AGR.TOC("matff","U38d6G1-f2r192B0.m",2);
AGR.TOC("matff","U38d6G1-f2r432B0.m",2);
AGR.TOC("matff","U38d6G1-f2r512B0.m",2);
AGR.TOC("matff","U38d6G1-f3r56aB0.m",2);
AGR.TOC("matff","U38d6G1-f3r133aB0.m",2);
AGR.TOC("matff","U38d6G1-f3r266B0.m",2);

# U39
AGR.GRP("clas","U39","U39");
AGR.TOC("perm","U39G1-p730B0.m",2);
AGR.TOC("matint","U39G1-Zr73aB0.g");

# 2U42
AGR.GRP("clas","U42","2U42");
AGR.TOC("perm","2U42G1-p80B0.m",2);
AGR.TOC("perm","2U42G1-p240B0.m",2);
AGR.TOC("matff","2U42G1-f3r4B0.m",2);
AGR.TOC("matff","2U42G1-f3r16B0.m",2);
AGR.TOC("matff","2U42G1-f3r40B0.m",2);
AGR.TOC("matint","2U42G1-Zr8B0.g");
AGR.TOC("matalg","2U42G1-Ar4aB0.g");
AGR.TOC("matalg","2U42G1-Ar4bB0.g");
AGR.TOC("matalg","2U42G1-Ar20aB0.g");
AGR.TOC("matalg","2U42G1-Ar20bB0.g");
AGR.TOC("matalg","2U42G1-Ar20cB0.g");
AGR.TOC("matalg","2U42G1-Ar36aB0.g");
AGR.TOC("matalg","2U42G1-Ar36bB0.g");
AGR.TOC("matalg","2U42G1-Ar60bB0.g");

# 2U42d2
AGR.GRP("clas","U42","2U42d2");
AGR.TOC("perm","2U42d2G1-p240B0.m",2);
AGR.TOC("matff","2U42d2G1-f3r4B0.m",2);

# U42
AGR.GRP("clas","U42","U42");
AGR.TOC("perm","U42G1-p27B0.m",2);
AGR.TOC("perm","U42G1-p36B0.m",2);
AGR.TOC("perm","U42G1-p40aB0.m",2);
AGR.TOC("perm","U42G1-p40bB0.m",2);
AGR.TOC("perm","U42G1-p45B0.m",2);
AGR.TOC("matff","U42G1-f3r5B0.m",2);
AGR.TOC("matff","U42G1-f3r10B0.m",2);
AGR.TOC("matff","U42G1-f3r14B0.m",2);
AGR.TOC("matff","U42G1-f3r25B0.m",2);
AGR.TOC("matff","U42G1-f3r81B0.m",2);
AGR.TOC("matff","U42G1-f4r4aB0.m",2);
AGR.TOC("matff","U42G1-f5r6B0.m",2);
AGR.TOC("matff","U42G1-f25r5aB0.m",2);
AGR.TOC("matff","U42G1-f25r10bB0.m",2);
AGR.TOC("matint","U42G1-Zr6B0.g");
AGR.TOC("matint","U42G1-Zr15aB0.g");
AGR.TOC("matint","U42G1-Zr15bB0.g");
AGR.TOC("matint","U42G1-Zr20B0.g");
AGR.TOC("matint","U42G1-Zr24B0.g");
AGR.TOC("matint","U42G1-Zr30aB0.g");
AGR.TOC("matint","U42G1-Zr60B0.g");
AGR.TOC("matint","U42G1-Zr64B0.g");
AGR.TOC("matint","U42G1-Zr80B0.g");
AGR.TOC("matint","U42G1-Zr81B0.g");
AGR.TOC("matalg","U42G1-Ar5aB0.g");
AGR.TOC("matalg","U42G1-Ar5bB0.g");
AGR.TOC("matalg","U42G1-Ar10B0.g");
AGR.TOC("matalg","U42G1-Ar10aB0.g");
AGR.TOC("matalg","U42G1-Ar10bB0.g");
AGR.TOC("matalg","U42G1-Ar30bB0.g");
AGR.TOC("matalg","U42G1-Ar30cB0.g");
AGR.TOC("matalg","U42G1-Ar40aB0.g");
AGR.TOC("matalg","U42G1-Ar40bB0.g");
AGR.TOC("matalg","U42G1-Ar45aB0.g");
AGR.TOC("matalg","U42G1-Ar45bB0.g");
AGR.TOC("cyclic","U42G1-cycW1");
AGR.TOC("cyc2ccl","U42G1cycW1-cclsW1");
AGR.TOC("check","U42G1-check1");
AGR.TOC("pres","U42G1-P1");

# U42d2
AGR.GRP("clas","U42","U42d2");
AGR.TOC("perm","U42d2G1-p27B0.m",2);
AGR.TOC("perm","U42d2G1-p36B0.m",2);
AGR.TOC("perm","U42d2G1-p40aB0.m",2);
AGR.TOC("perm","U42d2G1-p40bB0.m",2);
AGR.TOC("perm","U42d2G1-p45B0.m",2);
AGR.TOC("matff","U42d2G1-f2r6B0.m",2);
AGR.TOC("matff","U42d2G1-f2r8B0.m",2);
AGR.TOC("matff","U42d2G1-f2r14B0.m",2);
AGR.TOC("matff","U42d2G1-f2r40B0.m",2);
AGR.TOC("matff","U42d2G1-f2r64B0.m",2);
AGR.TOC("matff","U42d2G1-f3r5B0.m",2);
AGR.TOC("cyclic","U42d2G1-cycW1");
AGR.TOC("cyc2ccl","U42d2G1cycW1-cclsW1");

# 2U43D8
AGR.GRP("clas","U43","2U43D8");
AGR.TOC("matff","2U43D8G1-f3r6B0.m",2);

# 9U43D8
AGR.GRP("clas","U43","9U43D8");
AGR.TOC("perm","9U43D8G1-p756aB0.m",2);
AGR.TOC("perm","9U43D8G1-p756bB0.m",2);
AGR.TOC("perm","9U43D8G1-p972B0.m",2);

# U43
AGR.GRP("clas","U43","U43");
AGR.TOC("matint","U43G1-Zr21B0.g");
AGR.TOC("matint","U43G1-Zr35aB0.g");
AGR.TOC("matint","U43G1-Zr35bB0.g");
AGR.TOC("matint","U43G1-Zr90B0.g");
AGR.TOC("matint","U43G1-Zr140B0.g");
AGR.TOC("matint","U43G1-Zr189B0.g");
AGR.TOC("matint","U43G1-Zr210B0.g");

# U43D8
AGR.GRP("clas","U43","U43D8");
AGR.TOC("perm","U43D8G1-p112B0.m",2);
AGR.TOC("perm","U43D8G1-p252B0.m",2);
AGR.TOC("perm","U43D8G1-p280B0.m",2);
AGR.TOC("perm","U43D8G1-p324B0.m",2);
AGR.TOC("perm","U43D8G1-p540B0.m",2);
AGR.TOC("perm","U43D8G1-p1134B0.m",2);
AGR.TOC("perm","U43D8G1-p2835B0.m",2);
AGR.TOC("perm","U43D8G1-p4536B0.m",2);
AGR.TOC("perm","U43D8G1-p5184B0.m",2);
AGR.TOC("perm","U43D8G1-p8505B0.m",2);
AGR.TOC("perm","U43D8G1-p9072B0.m",2);

# U44
AGR.GRP("clas","U44","U44");
AGR.TOC("perm","U44G1-p325B0.m",2);
AGR.TOC("perm","U44G1-p1040B0.m",2);
AGR.TOC("perm","U44G1-p1105B0.m",2);
AGR.TOC("perm","U44G1-p3264B0.m",2);
AGR.TOC("matint","U44G1-Zr52B0.g");
AGR.TOC("matint","U44G1-Zr442B0.g");
AGR.TOC("find","U44G1-find1");
AGR.TOC("check","U44G1-check1");

# U45
AGR.GRP("clas","U45","U45");
AGR.TOC("perm","U45G1-p756B0.m",2);
AGR.TOC("perm","U45G1-p1575B0.m",2);
AGR.TOC("matint","U45G1-Zr105B0.g");

# U52
AGR.GRP("clas","U52","U52");
AGR.TOC("perm","U52G1-p165B0.m",2);
AGR.TOC("perm","U52G1-p176B0.m",2);
AGR.TOC("perm","U52G1-p297B0.m",2);
AGR.TOC("perm","U52G1-p1408B0.m",2);
AGR.TOC("perm","U52G1-p3520B0.m",2);
AGR.TOC("perm","U52G1-p20736B0.m",2);
AGR.TOC("matff","U52G1-f2r24B0.m",2);
AGR.TOC("matff","U52G1-f2r74B0.m",2);
AGR.TOC("matff","U52G1-f3r10B0.m",2);
AGR.TOC("matff","U52G1-f3r44B0.m",2);
AGR.TOC("matff","U52G1-f3r55B0.m",2);
AGR.TOC("matff","U52G1-f3r100B0.m",2);
AGR.TOC("matff","U52G1-f3r110B0.m",2);
AGR.TOC("matff","U52G1-f4r5aB0.m",2);
AGR.TOC("matff","U52G1-f4r5bB0.m",2);
AGR.TOC("matff","U52G1-f4r10aB0.m",2);
AGR.TOC("matff","U52G1-f4r10bB0.m",2);
AGR.TOC("matff","U52G1-f5r43B0.m",2);
AGR.TOC("matff","U52G1-f5r55aB0.m",2);
AGR.TOC("matff","U52G1-f5r120B0.m",2);
AGR.TOC("matff","U52G1-f5r176B0.m",2);
AGR.TOC("matff","U52G1-f11r44B0.m",2);
AGR.TOC("matff","U52G1-f11r119B0.m",2);
AGR.TOC("matff","U52G1-f11r176B0.m",2);
AGR.TOC("matint","U52G1-Zr55B0.g");
AGR.TOC("matint","U52G1-Zr120B0.g");
AGR.TOC("matint","U52G1-Zr165B0.g");
AGR.TOC("matint","U52G1-Zr176B0.g");
AGR.TOC("matalg","U52G1-Ar66aB0.g");
AGR.TOC("matalg","U52G1-Ar66bB0.g");
AGR.TOC("maxes","U52G1-max1W1");
AGR.TOC("maxes","U52G1-max2W1");
AGR.TOC("maxes","U52G1-max2W2");
AGR.TOC("maxes","U52G1-max3W1");
AGR.TOC("maxes","U52G1-max4W1");
AGR.TOC("maxes","U52G1-max6W1");
AGR.TOC("cyclic","U52G1-cycW1");
AGR.TOC("cyc2ccl","U52G1cycW1-cclsW1");
AGR.TOC("out","U52G1-aW1");
AGR.TOC("out","U52G1-aW2");
AGR.TOC("pres","U52G1-P1");

# U52d2
AGR.GRP("clas","U52","U52d2");
AGR.TOC("perm","U52d2G1-p165B0.m",2);
AGR.TOC("perm","U52d2G1-p176B0.m",2);
AGR.TOC("perm","U52d2G1-p297B0.m",2);
AGR.TOC("perm","U52d2G1-p1408B0.m",2);
AGR.TOC("perm","U52d2G1-p3520B0.m",2);
AGR.TOC("perm","U52d2G1-p20736B0.m",2);
AGR.TOC("matff","U52d2G1-f2r10B0.m",2);
AGR.TOC("matff","U52d2G1-f2r20B0.m",2);
AGR.TOC("matff","U52d2G1-f2r24B0.m",2);
AGR.TOC("matff","U52d2G1-f2r74B0.m",2);
AGR.TOC("matff","U52d2G1-f2r80aB0.m",2);
AGR.TOC("matff","U52d2G1-f2r80bB0.m",2);
AGR.TOC("matff","U52d2G1-f2r320B0.m",2);
AGR.TOC("matff","U52d2G1-f2r560B0.m",2);
AGR.TOC("matff","U52d2G1-f2r1024B0.m",2);
AGR.TOC("matff","U52d2G1-f3r10aB0.m",2);
AGR.TOC("maxes","U52d2G1-max1W1");
AGR.TOC("maxes","U52d2G1-max1W2");
AGR.TOC("maxes","U52d2G1-max2W1");
AGR.TOC("maxes","U52d2G1-max3W1");
AGR.TOC("maxes","U52d2G1-max4W1");
AGR.TOC("maxes","U52d2G1-max5W1");
AGR.TOC("maxes","U52d2G1-max7W1");
AGR.TOC("cyclic","U52d2G1-cycW1");
AGR.TOC("cyc2ccl","U52d2G1cycW1-cclsW1");
AGR.TOC("switch","U52d2G2-G1W1");
AGR.TOC("pres","U52d2G1-P1");

# U53
AGR.GRP("clas","U53","U53");
AGR.TOC("matff","U53G1-f3r10cB0.m",2);
AGR.TOC("matff","U53G1-f3r20B0.m",2);
AGR.TOC("matff","U53G1-f3r24B0.m",2);
AGR.TOC("matff","U53G1-f3r30cB0.m",2);
AGR.TOC("matff","U53G1-f3r51B0.m",2);
AGR.TOC("matff","U53G1-f9r5aB0.m",2);
AGR.TOC("matff","U53G1-f9r5bB0.m",2);
AGR.TOC("matff","U53G1-f9r10aB0.m",2);
AGR.TOC("matff","U53G1-f9r10bB0.m",2);
AGR.TOC("matff","U53G1-f9r15aB0.m",2);
AGR.TOC("matff","U53G1-f9r15bB0.m",2);
AGR.TOC("matff","U53G1-f9r30aB0.m",2);
AGR.TOC("matff","U53G1-f9r30bB0.m",2);
AGR.TOC("maxes","U53G1-max2W1");
AGR.TOC("out","U53G1-a2W1");

# U54
AGR.GRP("clas","U54","U54");
AGR.TOC("perm","U54G1-p17425B0.m",2);
AGR.TOC("perm","U54G1-p52480B0.m",2);

# 12U62
AGR.GRP("clas","U62","12U62");
AGR.TOC("perm","12U62G1-p4704B0.m",2);
AGR.TOC("perm","12U62G1-p8064B0.m",2);
AGR.TOC("matff","12U62G1-f4r27aB0.m",2);

# 2U62
AGR.GRP("clas","U62","2U62");
AGR.TOC("perm","2U62G1-p1344B0.m",2);
AGR.TOC("perm","2U62G1-p2816aB0.m",2);
AGR.TOC("perm","2U62G1-p2816bB0.m",2);
AGR.TOC("perm","2U62G1-p5632B0.m",2);
AGR.TOC("perm","2U62G1-p12672aB0.m",2);
AGR.TOC("perm","2U62G1-p12672bB0.m",2);
AGR.TOC("perm","2U62G1-p12672cB0.m",2);
AGR.TOC("perm","2U62G1-p41472B0.m",2);
AGR.TOC("matff","2U62G1-f3r56B0.m",2);
AGR.TOC("matff","2U62G1-f3r120B0.m",2);
AGR.TOC("matff","2U62G1-f3r560B0.m",2);
AGR.TOC("matff","2U62G1-f5r56B0.m",2);
AGR.TOC("matff","2U62G1-f5r176B0.m",2);
AGR.TOC("matff","2U62G1-f5r616B0.m",2);
AGR.TOC("matff","2U62G1-f7r56B0.m",2);
AGR.TOC("matff","2U62G1-f7r176B0.m",2);
AGR.TOC("matff","2U62G1-f7r616B0.m",2);
AGR.TOC("matff","2U62G1-f11r56B0.m",2);
AGR.TOC("matff","2U62G1-f11r176B0.m",2);
AGR.TOC("matff","2U62G1-f11r616B0.m",2);

# 3U62
AGR.GRP("clas","U62","3U62");
AGR.TOC("perm","3U62G1-p2016B0.m",2);
AGR.TOC("perm","3U62G1-p2079B0.m",2);
AGR.TOC("perm","3U62G1-p18711B0.m",2);
AGR.TOC("perm","3U62G1-p19008aB0.m",2);
AGR.TOC("perm","3U62G1-p19008bB0.m",2);
AGR.TOC("perm","3U62G1-p19008cB0.m",2);
AGR.TOC("matff","3U62G1-f4r6aB0.m",2);
AGR.TOC("matff","3U62G1-f4r15aB0.m",2);
AGR.TOC("matff","3U62G1-f4r84aB0.m",2);
AGR.TOC("matff","3U62G1-f4r90aB0.m",2);
AGR.TOC("matff","3U62G1-f4r204aB0.m",2);
AGR.TOC("matff","3U62G1-f4r384aB0.m",2);
AGR.TOC("matff","3U62G1-f4r720aB0.m",2);
AGR.TOC("matff","3U62G1-f4r924aB0.m",2);
AGR.TOC("matff","3U62G1-f7r21aB0.m",2);
AGR.TOC("matff","3U62G1-f7r210aB0.m",2);
AGR.TOC("matff","3U62G1-f7r231aB0.m",2);
AGR.TOC("matff","3U62G1-f7r462aB0.m",2);
AGR.TOC("matff","3U62G1-f25r21aB0.m",2);
AGR.TOC("matff","3U62G1-f25r210aB0.m",2);
AGR.TOC("matff","3U62G1-f25r231aB0.m",2);
AGR.TOC("matff","3U62G1-f25r462aB0.m",2);
AGR.TOC("matff","3U62G1-f121r21aB0.m",2);
AGR.TOC("matff","3U62G1-f121r210aB0.m",2);
AGR.TOC("matff","3U62G1-f121r231aB0.m",2);
AGR.TOC("matff","3U62G1-f121r462aB0.m",2);

# 4U62
AGR.GRP("clas","U62","4U62");
AGR.TOC("perm","4U62G1-p2688B0.m",2);

# 6U62
AGR.GRP("clas","U62","6U62");
AGR.TOC("perm","6U62G1-p4032B0.m",2);
AGR.TOC("perm","6U62G1-p38016aB0.m",2);
AGR.TOC("perm","6U62G1-p38016bB0.m",2);
AGR.TOC("perm","6U62G1-p38016cB0.m",2);
AGR.TOC("matff","6U62G1-f4r27aB0.m",2);
AGR.TOC("matff","6U62G1-f7r120aB0.m",2);
AGR.TOC("matff","6U62G1-f25r120aB0.m",2);
AGR.TOC("matff","6U62G1-f121r120aB0.m",2);

# U62
AGR.GRP("clas","U62","U62");
AGR.TOC("perm","U62G1-p672B0.m",2);
AGR.TOC("perm","U62G1-p693B0.m",2);
AGR.TOC("perm","U62G1-p891B0.m",2);
AGR.TOC("perm","U62G1-p1408aB0.m",2);
AGR.TOC("perm","U62G1-p1408bB0.m",2);
AGR.TOC("perm","U62G1-p1408cB0.m",2);
AGR.TOC("perm","U62G1-p2816aB0.m",2);
AGR.TOC("perm","U62G1-p2816bB0.m",2);
AGR.TOC("perm","U62G1-p2816cB0.m",2);
AGR.TOC("perm","U62G1-p6237B0.m",2);
AGR.TOC("perm","U62G1-p6336aB0.m",2);
AGR.TOC("perm","U62G1-p6336bB0.m",2);
AGR.TOC("perm","U62G1-p6336cB0.m",2);
AGR.TOC("perm","U62G1-p12474B0.m",2);
AGR.TOC("perm","U62G1-p20736aB0.m",2);
AGR.TOC("perm","U62G1-p20736bB0.m",2);
AGR.TOC("perm","U62G1-p20736cB0.m",2);
AGR.TOC("perm","U62G1-p59136B0.m",2);
AGR.TOC("matff","U62G1-f2r20B0.m",2);
AGR.TOC("matff","U62G1-f2r34B0.m",2);
AGR.TOC("matff","U62G1-f2r140B0.m",2);
AGR.TOC("matff","U62G1-f2r154B0.m",2);
AGR.TOC("matff","U62G1-f2r400B0.m",2);
AGR.TOC("matff","U62G1-f3r21B0.m",2);
AGR.TOC("matff","U62G1-f3r210B0.m",2);
AGR.TOC("matff","U62G1-f3r229B0.m",2);
AGR.TOC("matff","U62G1-f3r364B0.m",2);
AGR.TOC("matff","U62G1-f4r70aB0.m",2);
AGR.TOC("matff","U62G1-f4r70bB0.m",2);
AGR.TOC("matff","U62G1-f4r896aB0.m",2);
AGR.TOC("matff","U62G1-f5r22B0.m",2);
AGR.TOC("matff","U62G1-f5r231B0.m",2);
AGR.TOC("matff","U62G1-f5r252B0.m",2);
AGR.TOC("matff","U62G1-f5r440B0.m",2);
AGR.TOC("matff","U62G1-f5r616B0.m",2);
AGR.TOC("matff","U62G1-f7r22B0.m",2);
AGR.TOC("matff","U62G1-f7r231B0.m",2);
AGR.TOC("matff","U62G1-f7r252B0.m",2);
AGR.TOC("matff","U62G1-f7r439B0.m",2);
AGR.TOC("matff","U62G1-f7r616B0.m",2);
AGR.TOC("matff","U62G1-f11r22B0.m",2);
AGR.TOC("matff","U62G1-f11r231B0.m",2);
AGR.TOC("matff","U62G1-f11r251B0.m",2);
AGR.TOC("matff","U62G1-f11r440B0.m",2);
AGR.TOC("matff","U62G1-f11r616B0.m",2);
AGR.TOC("matint","U62G1-Zr22B0.g");
AGR.TOC("matint","U62G1-Zr231B0.g");
AGR.TOC("maxes","U62G1-max1W1");
AGR.TOC("maxes","U62G1-max1W2");
AGR.TOC("maxes","U62G1-max2W1");
AGR.TOC("maxes","U62G1-max3W1");
AGR.TOC("maxes","U62G1-max4W1");
AGR.TOC("maxes","U62G1-max4W2");
AGR.TOC("maxes","U62G1-max5W1");
AGR.TOC("maxes","U62G1-max6W1");
AGR.TOC("maxes","U62G1-max7W1");
AGR.TOC("maxes","U62G1-max8W1");
AGR.TOC("maxes","U62G1-max8W2");
AGR.TOC("maxes","U62G1-max9W1");
AGR.TOC("maxes","U62G1-max10W1");
AGR.TOC("maxes","U62G1-max11W1");
AGR.TOC("maxes","U62G1-max11W2");
AGR.TOC("maxes","U62G1-max12W1");
AGR.TOC("maxes","U62G1-max13W1");
AGR.TOC("maxes","U62G1-max14W1");
AGR.TOC("maxes","U62G1-max15W1");
AGR.TOC("maxes","U62G1-max16W1");
AGR.TOC("out","U62G1-a2W1");
AGR.TOC("out","U62G1-a3W1");

# U62S3
AGR.GRP("clas","U62","U62S3");
AGR.TOC("perm","U62S3G1-p693B0.m",2);
AGR.TOC("perm","U62S3G1-p891B0.m",2);
AGR.TOC("matff","U62S3G1-f2r20B0.m",2);
AGR.TOC("matff","U62S3G1-f2r34B0.m",2);
AGR.TOC("matff","U62S3G1-f2r140a0B0.m",2);
AGR.TOC("matff","U62S3G1-f2r140a1B0.m",2);
AGR.TOC("matff","U62S3G1-f2r140a2B0.m",2);
AGR.TOC("matff","U62S3G1-f2r154B0.m",2);
AGR.TOC("matff","U62S3G1-f2r400B0.m",2);
AGR.TOC("matff","U62S3G1-f3r21aB0.m",2);
AGR.TOC("matff","U62S3G1-f3r210aB0.m",2);
AGR.TOC("matff","U62S3G1-f3r229aB0.m",2);
AGR.TOC("matff","U62S3G1-f3r364aB0.m",2);
AGR.TOC("matff","U62S3G1-f5r22aB0.m",2);
AGR.TOC("matff","U62S3G1-f7r22aB0.m",2);
AGR.TOC("matff","U62S3G1-f11r22aB0.m",2);

# U62d2
AGR.GRP("clas","U62","U62d2");
AGR.TOC("perm","U62d2G1-p672B0.m",2);
AGR.TOC("perm","U62d2G1-p693B0.m",2);
AGR.TOC("perm","U62d2G1-p891B0.m",2);
AGR.TOC("perm","U62d2G1-p1408B0.m",2);
AGR.TOC("perm","U62d2G1-p6237B0.m",2);
AGR.TOC("perm","U62d2G1-p6336B0.m",2);
AGR.TOC("perm","U62d2G1-p20736B0.m",2);
AGR.TOC("matff","U62d2G1-f2r20B0.m",2);
AGR.TOC("matff","U62d2G1-f2r34B0.m",2);
AGR.TOC("matff","U62d2G1-f2r140B0.m",2);
AGR.TOC("matff","U62d2G1-f2r154B0.m",2);
AGR.TOC("matff","U62d2G1-f2r400B0.m",2);
AGR.TOC("matff","U62d2G1-f3r21aB0.m",2);
AGR.TOC("matff","U62d2G1-f3r210aB0.m",2);
AGR.TOC("matff","U62d2G1-f3r229aB0.m",2);
AGR.TOC("matff","U62d2G1-f3r364aB0.m",2);
AGR.TOC("matff","U62d2G1-f5r22aB0.m",2);
AGR.TOC("matff","U62d2G1-f7r22aB0.m",2);
AGR.TOC("matff","U62d2G1-f11r22aB0.m",2);

# U63
AGR.GRP("clas","U63","U63");
AGR.TOC("perm","U63G1-p22204B0.m",2);
AGR.TOC("perm","U63G1-p44226B0.m",2);

# U72
AGR.GRP("clas","U72","U72");
AGR.TOC("perm","U72G1-p2709B0.m",2);
AGR.TOC("perm","U72G1-p2752B0.m",2);
AGR.TOC("matff","U72G1-f4r7aB0.m",2);
AGR.TOC("matff","U72G1-f4r7bB0.m",2);
AGR.TOC("maxes","U72G1-max1W1");
AGR.TOC("maxes","U72G1-max2W1");
AGR.TOC("maxes","U72G1-max7W1");
AGR.TOC("out","U72G1-a2W1");
AGR.TOC("pres","U72G1-P1");

# U82
AGR.GRP("clas","U82","U82");
AGR.TOC("perm","U82G1-p10880B0.m",2);
AGR.TOC("perm","U82G1-p10965B0.m",2);

# E62
AGR.GRP("exc","E62","E62");
AGR.TOC("matff","E62G0-f2r27aB0.m",2);
AGR.TOC("matff","E62G1-f2r27aB0.m",2);
AGR.TOC("matff","E62G0-f2r27bB0.m",2);
AGR.TOC("matff","E62G1-f2r27bB0.m",2);
AGR.TOC("matff","E62G0-f2r78B0.m",2);
AGR.TOC("matff","E62G1-f2r78B0.m",2);
AGR.TOC("switch","E62G0-G1W1");

# 3E64
AGR.GRP("exc","E64","3E64");
AGR.TOC("matff","3E64G0-f4r27B0.m",2);

# 3E64d2
AGR.GRP("exc","E64","3E64d2");
AGR.TOC("matff","3E64d2G0-f4r54B0.m",2);

# E64
AGR.GRP("exc","E64","E64");
AGR.TOC("matff","E64G0-f4r78B0.m",2);

# E72
AGR.GRP("exc","E72","E72");
AGR.TOC("matff","E72G0-f2r56B0.m",2);
AGR.TOC("matff","E72G0-f2r132B0.m",2);

# E74
AGR.GRP("exc","E74","E74");
AGR.TOC("matff","E74G0-f4r56aB0.m",2);
AGR.TOC("matff","E74G0-f4r132aB0.m",2);
AGR.TOC("matff","E74G0-f4r248aB0.m",2);

# E82
AGR.GRP("exc","E82","E82");
AGR.TOC("matff","E82G0-f2r248B0.m",2);
AGR.TOC("matff","E82G1-f2r248B0.m",9);

# E85
AGR.GRP("exc","E85","E85");
AGR.TOC("matff","E85G0-f5r248B0.m",2);

# 2F42
AGR.GRP("exc","F42","2F42");
AGR.TOC("perm","2F42G1-p139776B0.m",2);
AGR.TOC("matff","2F42G1-f3r52B0.m",2);
AGR.TOC("matff","2F42G1-f3r2380B0.m",2);
AGR.TOC("matff","2F42G1-f5r52B0.m",2);
AGR.TOC("matff","2F42G1-f37r52B0.m",2);
AGR.TOC("matint","2F42G1-Zr52B0.g");

# 2F42d2
AGR.GRP("exc","F42","2F42d2");
AGR.TOC("matff","2F42d2G1-f25r52B0.m",2);

# 2F42d4i
AGR.GRP("exc","F42","2F42d4i");
AGR.TOC("matff","2F42d4iG1-f5r52B0.m",2);

# F42
AGR.GRP("exc","F42","F42");
AGR.TOC("perm","F42G1-p69888aB0.m",2);
AGR.TOC("matff","F42G1-f2r26aB0.m",2);
AGR.TOC("maxes","F42G1-max3W1");
AGR.TOC("out","F42G1-aW1");

# F42d2
AGR.GRP("exc","F42","F42d2");
AGR.TOC("matff","F42d2G1-f2r52B0.m",2);

# 3G23
AGR.GRP("exc","G23","3G23");
AGR.TOC("perm","3G23G1-p1134B0.m",2);
AGR.TOC("matff","3G23G1-f4r27B0.m",2);
AGR.TOC("matff","3G23G1-f7r27B0.m",2);
AGR.TOC("matff","3G23G1-f13r27B0.m",2);

# 3G23d2
AGR.GRP("exc","G23","3G23d2");
AGR.TOC("matff","3G23d2G1-f2r54B0.m",2);

# G23
AGR.GRP("exc","G23","G23");
AGR.TOC("matff","G23G1-f2r14B0.m",2);
AGR.TOC("matff","G23G1-f2r78B0.m",2);
AGR.TOC("matff","G23G1-f2r90aB0.m",2);
AGR.TOC("matff","G23G1-f2r90bB0.m",2);
AGR.TOC("matff","G23G1-f2r90cB0.m",2);
AGR.TOC("matff","G23G1-f2r378B0.m",2);
AGR.TOC("matff","G23G1-f3r7aB0.m",2);
AGR.TOC("matff","G23G1-f3r7bB0.m",2);
AGR.TOC("matff","G23G1-f3r27aB0.m",2);
AGR.TOC("matff","G23G1-f3r27bB0.m",2);
AGR.TOC("matff","G23G1-f3r49B0.m",2);
AGR.TOC("matff","G23G1-f3r189aB0.m",2);
AGR.TOC("matff","G23G1-f3r189bB0.m",2);
AGR.TOC("matff","G23G1-f3r729B0.m",2);
AGR.TOC("matff","G23G1-f4r64aB0.m",2);
AGR.TOC("matint","G23G1-Zr14B0.g");
AGR.TOC("matint","G23G1-Zr78B0.g");
AGR.TOC("matint","G23G1-Zr91aB0.g");
AGR.TOC("matint","G23G1-Zr91bB0.g");
AGR.TOC("matint","G23G1-Zr91cB0.g");
AGR.TOC("matint","G23G1-Zr104B0.g");
AGR.TOC("matint","G23G1-Zr128B0.g");
AGR.TOC("matint","G23G1-Zr168B0.g");
AGR.TOC("matint","G23G1-Zr182aB0.g");
AGR.TOC("matint","G23G1-Zr182bB0.g");
AGR.TOC("maxes","G23G1-max1W1");
AGR.TOC("maxes","G23G1-max2W1");
AGR.TOC("maxes","G23G1-max3W1");
AGR.TOC("maxes","G23G1-max4W1");
AGR.TOC("maxes","G23G1-max5W1");
AGR.TOC("maxes","G23G1-max6W1");
AGR.TOC("maxes","G23G1-max7W1");
AGR.TOC("maxes","G23G1-max8W1");
AGR.TOC("maxes","G23G1-max9W1");
AGR.TOC("maxes","G23G1-max10W1");
AGR.TOC("cyclic","G23G1-cycW1");
AGR.TOC("cyc2ccl","G23G1cycW1-cclsW1");
AGR.TOC("out","G23G1-aW1");
AGR.TOC("pres","G23G1-P1");

# G23d2
AGR.GRP("exc","G23","G23d2");
AGR.TOC("perm","G23d2G1-p756B0.m",2);
AGR.TOC("matff","G23d2G1-f2r14B0.m",2);
AGR.TOC("matff","G23d2G1-f3r14B0.m",2);
AGR.TOC("matff","G23d2G1-f7r14B0.m",2);
AGR.TOC("matff","G23d2G1-f13r14B0.m",2);
AGR.TOC("matff","G23d2G1-f13r434aB0.m",2);
AGR.TOC("matalg","G23d2G1-Ar14B0.g");
AGR.TOC("cyclic","G23d2G1-cycW1");
AGR.TOC("cyc2ccl","G23d2G1cycW1-cclsW1");

# 2G24
AGR.GRP("exc","G24","2G24");
AGR.TOC("matff","2G24G1-f3r12B0.m",2);
AGR.TOC("matff","2G24G1-f5r12B0.m",2);
AGR.TOC("matff","2G24G1-f5r92B0.m",2);
AGR.TOC("matff","2G24G1-f7r12B0.m",2);
AGR.TOC("matff","2G24G1-f13r12B0.m",2);
AGR.TOC("matalg","2G24G1-Ar12B0.g");

# 2G24d2
AGR.GRP("exc","G24","2G24d2");
AGR.TOC("matff","2G24d2G1-f7r12B0.m",2);
AGR.TOC("matff","2G24d2G1-f9r12B0.m",2);
AGR.TOC("matff","2G24d2G1-f25r12B0.m",2);
AGR.TOC("matff","2G24d2G1-f169r12B0.m",2);

# 2G24d2i
AGR.GRP("exc","G24","2G24d2i");
AGR.TOC("matff","2G24d2iG1-f3r12B0.m",2);

# G24
AGR.GRP("exc","G24","G24");
AGR.TOC("perm","G24G1-p416B0.m",2);
AGR.TOC("perm","G24G1-p1365aB0.m",2);
AGR.TOC("perm","G24G1-p1365bB0.m",2);
AGR.TOC("perm","G24G1-p2016B0.m",2);
AGR.TOC("perm","G24G1-p2080B0.m",2);
AGR.TOC("perm","G24G1-p20800B0.m",2);
AGR.TOC("matff","G24G1-f2r36B0.m",2);
AGR.TOC("matff","G24G1-f2r196B0.m",2);
AGR.TOC("matff","G24G1-f3r64B0.m",2);
AGR.TOC("matff","G24G1-f3r78B0.m",2);
AGR.TOC("matff","G24G1-f3r286B0.m",2);
AGR.TOC("matff","G24G1-f4r6aB0.m",2);
AGR.TOC("matff","G24G1-f4r6bB0.m",2);
AGR.TOC("matff","G24G1-f4r14aB0.m",2);
AGR.TOC("matff","G24G1-f4r14bB0.m",2);
AGR.TOC("matff","G24G1-f4r64aB0.m",2);
AGR.TOC("matff","G24G1-f4r64bB0.m",2);
AGR.TOC("matff","G24G1-f4r84aB0.m",2);
AGR.TOC("matff","G24G1-f4r84bB0.m",2);
AGR.TOC("matff","G24G1-f4r384aB0.m",2);
AGR.TOC("matff","G24G1-f4r896aB0.m",2);
AGR.TOC("matff","G24G1-f5r65B0.m",2);
AGR.TOC("matff","G24G1-f5r78B0.m",2);
AGR.TOC("matff","G24G1-f5r350B0.m",2);
AGR.TOC("matff","G24G1-f5r363aB0.m",2);
AGR.TOC("matff","G24G1-f5r650B0.m",2);
AGR.TOC("matff","G24G1-f7r65B0.m",2);
AGR.TOC("matff","G24G1-f7r78B0.m",2);
AGR.TOC("matff","G24G1-f13r65B0.m",2);
AGR.TOC("matff","G24G1-f13r78B0.m",2);
AGR.TOC("matint","G24G1-Zr65B0.g");
AGR.TOC("matint","G24G1-Zr78B0.g");
AGR.TOC("matint","G24G1-Zr350B0.g");
AGR.TOC("maxes","G24G1-max1W1");
AGR.TOC("maxes","G24G1-max2W1");
AGR.TOC("maxes","G24G1-max3W1");
AGR.TOC("maxes","G24G1-max4W1");
AGR.TOC("maxes","G24G1-max5W1");
AGR.TOC("maxes","G24G1-max6W1");
AGR.TOC("maxes","G24G1-max7W1");
AGR.TOC("maxes","G24G1-max8W1");
AGR.TOC("cyclic","G24G1-cycW1");
AGR.TOC("cyc2ccl","G24G1cycW1-cclsW1");
AGR.TOC("out","G24G1-aW1");

# G24d2
AGR.GRP("exc","G24","G24d2");
AGR.TOC("matff","G24d2G1-f2r12B0.m",2);
AGR.TOC("matff","G24d2G1-f2r28B0.m",2);
AGR.TOC("matff","G24d2G1-f2r36B0.m",2);
AGR.TOC("matff","G24d2G1-f2r128B0.m",2);
AGR.TOC("matff","G24d2G1-f2r168B0.m",2);
AGR.TOC("matff","G24d2G1-f2r196B0.m",2);
AGR.TOC("matff","G24d2G1-f2r768B0.m",2);
AGR.TOC("matff","G24d2G1-f3r64B0.m",2);
AGR.TOC("matff","G24d2G1-f5r65B0.m",2);
AGR.TOC("matff","G24d2G1-f13r65B0.m",2);
AGR.TOC("maxes","G24d2G1-max1W1");
AGR.TOC("cyclic","G24d2G1-cycW1");
AGR.TOC("cyc2ccl","G24d2G1cycW1-cclsW1");

# G25
AGR.GRP("exc","G25","G25");
AGR.TOC("perm","G25G1-p3906aB0.m",2);
AGR.TOC("perm","G25G1-p3906bB0.m",2);
AGR.TOC("perm","G25G1-p7750B0.m",2);
AGR.TOC("perm","G25G1-p7875B0.m",2);
AGR.TOC("matff","G25G1-f2r124B0.m",2);
AGR.TOC("matff","G25G1-f3r124B0.m",2);
AGR.TOC("matff","G25G1-f3r651B0.m",2);
AGR.TOC("matff","G25G1-f5r7B0.m",2);
AGR.TOC("matff","G25G1-f5r14B0.m",2);
AGR.TOC("matff","G25G1-f5r27B0.m",2);
AGR.TOC("matff","G25G1-f5r64B0.m",2);
AGR.TOC("matff","G25G1-f5r77aB0.m",2);
AGR.TOC("matff","G25G1-f5r77bB0.m",2);
AGR.TOC("matff","G25G1-f5r97B0.m",2);
AGR.TOC("matff","G25G1-f5r182B0.m",2);
AGR.TOC("matff","G25G1-f5r189B0.m",2);
AGR.TOC("matff","G25G1-f5r196B0.m",2);
AGR.TOC("matff","G25G1-f5r371B0.m",2);
AGR.TOC("matff","G25G1-f5r469B0.m",2);
AGR.TOC("matff","G25G1-f5r483B0.m",2);
AGR.TOC("matff","G25G1-f5r721B0.m",2);
AGR.TOC("matff","G25G1-f5r792B0.m",2);
AGR.TOC("maxes","G25G1-max1W1");
AGR.TOC("maxes","G25G1-max2W1");
AGR.TOC("maxes","G25G1-max3W1");
AGR.TOC("maxes","G25G1-max4W1");
AGR.TOC("maxes","G25G1-max5W1");
AGR.TOC("maxes","G25G1-max6W1");
AGR.TOC("maxes","G25G1-max7W1");
AGR.TOC("cyc2ccl","G25G1cycW1-cclsW1");

# R27
AGR.GRP("exc","R27","R27");
AGR.TOC("perm","R27G1-p19684B0.m",2);
AGR.TOC("matff","R27G1-f2r702B0.m",2);
AGR.TOC("matff","R27G1-f27r7aB0.m",2);
AGR.TOC("maxes","R27G1-max1W1");
AGR.TOC("maxes","R27G1-max2W1");
AGR.TOC("maxes","R27G1-max3W1");
AGR.TOC("maxes","R27G1-max4W1");
AGR.TOC("maxes","R27G1-max5W1");
AGR.TOC("maxes","R27G1-max6W1");
AGR.TOC("cyclic","R27G1-cycW1");
AGR.TOC("cyc2ccl","R27G1cycW1-cclsW1");
AGR.TOC("out","R27G1-a3W1");

# R27d3
AGR.GRP("exc","R27","R27d3");
AGR.TOC("perm","R27d3G1-p19684B0.m",2);
AGR.TOC("matff","R27d3G1-f2r702B0.m",2);
AGR.TOC("matff","R27d3G1-f3r21B0.m",2);
AGR.TOC("matff","R27d3G1-f4r741B0.m",2);
AGR.TOC("maxes","R27d3G1-max1W1");
AGR.TOC("maxes","R27d3G1-max2W1");
AGR.TOC("maxes","R27d3G1-max5W1");
AGR.TOC("maxes","R27d3G1-max6W1");
AGR.TOC("cyclic","R27d3G1-cycW1");
AGR.TOC("switch","R27d3G2-G1W1");

# Sz32
AGR.GRP("exc","Sz32","Sz32");
AGR.TOC("perm","Sz32G1-p1025B0.m",2);
AGR.TOC("perm","Sz32G1-p198400B0.m",2);
AGR.TOC("matff","Sz32G1-f5r124aB0.m",2);
AGR.TOC("matff","Sz32G1-f32r4aB0.m",2);
AGR.TOC("matff","Sz32G1-f41r124bB0.m",2);
AGR.TOC("maxes","Sz32G1-max1W1");
AGR.TOC("maxes","Sz32G1-max2W1");
AGR.TOC("maxes","Sz32G1-max3W1");
AGR.TOC("maxes","Sz32G1-max4W1");
AGR.TOC("cyclic","Sz32G1-cycW1");
AGR.TOC("cyc2ccl","Sz32G1cycW1-cclsW1");

# Sz32d5
AGR.GRP("exc","Sz32","Sz32d5");
AGR.TOC("perm","Sz32d5G1-p1025B0.m",2);
AGR.TOC("matff","Sz32d5G1-f2r20B0.m",2);
AGR.TOC("matff","Sz32d5G1-f5r124B0.m",2);
AGR.TOC("matff","Sz32d5G1-f5r248B0.m",2);
AGR.TOC("matff","Sz32d5G1-f41r124B0.m",2);
AGR.TOC("cyclic","Sz32d5G1-cycW1");

# 2Sz8
AGR.GRP("exc","Sz8","2Sz8");
AGR.TOC("perm","2Sz8G1-p1040B0.m",2);
AGR.TOC("matff","2Sz8G1-f2r128B0.m",2);
AGR.TOC("matff","2Sz8G1-f5r8B0.m",2);
AGR.TOC("matff","2Sz8G1-f7r40B0.m",2);
AGR.TOC("matff","2Sz8G1-f13r16B0.m",2);
AGR.TOC("matff","2Sz8G1-f13r24B0.m",2);
AGR.TOC("pres","2Sz8G1-P1");

# 4Sz8d3
AGR.GRP("exc","Sz8","4Sz8d3");
AGR.TOC("perm","4Sz8d3G1-p2080B0.m",2);
AGR.TOC("matff","4Sz8d3G1-f7r120B0.m",2);
AGR.TOC("matff","4Sz8d3G1-f13r48B0.m",2);
AGR.TOC("pres","4Sz8d3G1-P1");

# Sz8
AGR.GRP("exc","Sz8","Sz8");
AGR.TOC("perm","Sz8G1-p65B0.m",2);
AGR.TOC("perm","Sz8G1-p520B0.m",2);
AGR.TOC("perm","Sz8G1-p560B0.m",2);
AGR.TOC("perm","Sz8G1-p1456B0.m",2);
AGR.TOC("perm","Sz8G1-p2080B0.m",2);
AGR.TOC("matff","Sz8G1-f2r64B0.m",2);
AGR.TOC("matff","Sz8G1-f5r14aB0.m",2);
AGR.TOC("matff","Sz8G1-f5r14bB0.m",2);
AGR.TOC("matff","Sz8G1-f5r35aB0.m",2);
AGR.TOC("matff","Sz8G1-f5r35bB0.m",2);
AGR.TOC("matff","Sz8G1-f5r35cB0.m",2);
AGR.TOC("matff","Sz8G1-f5r63B0.m",2);
AGR.TOC("matff","Sz8G1-f5r195B0.m",2);
AGR.TOC("matff","Sz8G1-f7r64B0.m",2);
AGR.TOC("matff","Sz8G1-f7r91B0.m",2);
AGR.TOC("matff","Sz8G1-f7r105B0.m",2);
AGR.TOC("matff","Sz8G1-f8r4aB0.m",2);
AGR.TOC("matff","Sz8G1-f8r16aB0.m",2);
AGR.TOC("matff","Sz8G1-f13r14aB0.m",2);
AGR.TOC("matff","Sz8G1-f13r14bB0.m",2);
AGR.TOC("matff","Sz8G1-f13r35B0.m",2);
AGR.TOC("matff","Sz8G1-f13r65aB0.m",2);
AGR.TOC("matff","Sz8G1-f13r65bB0.m",2);
AGR.TOC("matff","Sz8G1-f13r65cB0.m",2);
AGR.TOC("matff","Sz8G1-f13r91B0.m",2);
AGR.TOC("matff","Sz8G1-f49r14aB0.m",2);
AGR.TOC("matff","Sz8G1-f125r65aB0.m",2);
AGR.TOC("matff","Sz8G1-f125r65bB0.m",2);
AGR.TOC("matff","Sz8G1-f125r65cB0.m",2);
AGR.TOC("matint","Sz8G1-Zr64B0.g");
AGR.TOC("matint","Sz8G1-Zr91B0.g");
AGR.TOC("matalg","Sz8G1-Ar14aB0.g");
AGR.TOC("matalg","Sz8G1-Ar14bB0.g");
AGR.TOC("matalg","Sz8G1-Ar65aB0.g");
AGR.TOC("matalg","Sz8G1-Ar65bB0.g");
AGR.TOC("matalg","Sz8G1-Ar65cB0.g");
AGR.TOC("maxes","Sz8G1-max1W1");
AGR.TOC("maxes","Sz8G1-max2W1");
AGR.TOC("maxes","Sz8G1-max3W1");
AGR.TOC("maxes","Sz8G1-max4W1");
AGR.TOC("classes","Sz8G1-cclsW1");
AGR.TOC("cyclic","Sz8G1-cycW1");
AGR.TOC("out","Sz8G1-a3W1");
AGR.TOC("pres","Sz8G1-P1");
AGR.TOC("pres","Sz8G1-P2");

# Sz8d3
AGR.GRP("exc","Sz8","Sz8d3");
AGR.TOC("perm","Sz8d3G1-p65B0.m",2);
AGR.TOC("perm","Sz8d3G1-p520B0.m",2);
AGR.TOC("perm","Sz8d3G1-p560B0.m",2);
AGR.TOC("perm","Sz8d3G1-p1456B0.m",2);
AGR.TOC("perm","Sz8d3G1-p2080B0.m",2);
AGR.TOC("matff","Sz8d3G1-f2r12B0.m",2);
AGR.TOC("matff","Sz8d3G1-f2r48B0.m",2);
AGR.TOC("matff","Sz8d3G1-f2r64B0.m",2);
AGR.TOC("matff","Sz8d3G1-f5r14B0.m",2);
AGR.TOC("matff","Sz8d3G1-f5r63B0.m",2);
AGR.TOC("matff","Sz8d3G1-f5r105B0.m",2);
AGR.TOC("matff","Sz8d3G1-f5r195B0.m",2);
AGR.TOC("matff","Sz8d3G1-f13r14B0.m",2);
AGR.TOC("matff","Sz8d3G1-f49r14B0.m",2);
AGR.TOC("maxes","Sz8d3G1-max1W1");
AGR.TOC("maxes","Sz8d3G1-max1W2");
AGR.TOC("maxes","Sz8d3G1-max2W1");
AGR.TOC("maxes","Sz8d3G1-max3W1");
AGR.TOC("maxes","Sz8d3G1-max4W1");
AGR.TOC("maxes","Sz8d3G1-max5W1");
AGR.TOC("classes","Sz8d3G1-cclsW1");
AGR.TOC("cyclic","Sz8d3G1-cycW1");
AGR.TOC("switch","Sz8d3G2-G1W1");
AGR.TOC("pres","Sz8d3G1-P1");

# TD42
AGR.GRP("exc","TD42","TD42");
AGR.TOC("perm","TD42G1-p819B0.m",2);
AGR.TOC("matff","TD42G1-f2r26B0.m",2);
AGR.TOC("matff","TD42G1-f3r25B0.m",2);
AGR.TOC("matff","TD42G1-f3r52B0.m",2);
AGR.TOC("matff","TD42G1-f3r196B0.m",2);
AGR.TOC("matff","TD42G1-f3r324B0.m",2);
AGR.TOC("matff","TD42G1-f3r441B0.m",2);
AGR.TOC("matff","TD42G1-f3r1053B0.m",2);
AGR.TOC("matff","TD42G1-f7r26B0.m",2);
AGR.TOC("matff","TD42G1-f7r298B0.m",2);
AGR.TOC("matff","TD42G1-f8r8aB0.m",2);
AGR.TOC("matff","TD42G1-f13r26B0.m",2);
AGR.TOC("matff","TD42G1-f27r351aB0.m",2);
AGR.TOC("matff","TD42G1-f27r351bB0.m",2);
AGR.TOC("matff","TD42G1-f27r351cB0.m",2);
AGR.TOC("matint","TD42G1-Zr26B0.g");
AGR.TOC("matint","TD42G1-Zr52B0.g");
AGR.TOC("matint","TD42G1-Zr196B0.g");
AGR.TOC("maxes","TD42G1-max1W1");
AGR.TOC("maxes","TD42G1-max2W1");
AGR.TOC("maxes","TD42G1-max3W1");
AGR.TOC("maxes","TD42G1-max4W1");
AGR.TOC("maxes","TD42G1-max5W1");
AGR.TOC("maxes","TD42G1-max6W1");
AGR.TOC("maxes","TD42G1-max7W1");
AGR.TOC("maxes","TD42G1-max8W1");
AGR.TOC("maxes","TD42G1-max9W1");
AGR.TOC("cyclic","TD42G1-cycW1");
AGR.TOC("cyc2ccl","TD42G1cycW1-cclsW1");
AGR.TOC("out","TD42G1-a3W1");

# TD42d3
AGR.GRP("exc","TD42","TD42d3");
AGR.TOC("matff","TD42d3G1-f2r24B0.m",2);
AGR.TOC("matff","TD42d3G1-f2r26B0.m",2);
AGR.TOC("matff","TD42d3G1-f2r144B0.m",2);
AGR.TOC("matff","TD42d3G1-f2r246aB0.m",2);
AGR.TOC("matff","TD42d3G1-f2r480B0.m",2);
AGR.TOC("matff","TD42d3G1-f3r52B0.m",2);
AGR.TOC("matff","TD42d3G1-f3r196B0.m",2);
AGR.TOC("matff","TD42d3G1-f7r26aB0.m",2);
AGR.TOC("matff","TD42d3G1-f7r52aB0.m",2);
AGR.TOC("matff","TD42d3G1-f7r273aB0.m",2);
AGR.TOC("matff","TD42d3G1-f7r298aB0.m",2);
AGR.TOC("matff","TD42d3G1-f7r467aB0.m",2);
AGR.TOC("matff","TD42d3G1-f13r26aB0.m",2);
AGR.TOC("maxes","TD42d3G1-max4W1");
AGR.TOC("cyclic","TD42d3G1-cycW1");
AGR.TOC("cyc2ccl","TD42d3G1cycW1-cclsW1");

# TD43
AGR.GRP("exc","TD43","TD43");
AGR.TOC("perm","TD43G1-p26572B0.m",2);
AGR.TOC("matff","TD43G1-f2r218B0.m",2);
AGR.TOC("matff","TD43G1-f27r8aB0.m",2);

# 2TE62
AGR.GRP("exc","TE62","2TE62");
AGR.TOC("matff","2TE62G1-f2r1704B0.m",2);

# 2TE62d2
AGR.GRP("exc","TE62","2TE62d2");
AGR.TOC("matff","2TE62d2G1-f2r1705B0.m",2);
AGR.TOC("matff","2TE62d2G1-f3r2432B0.m",2);

# 3TE62
AGR.GRP("exc","TE62","3TE62");
AGR.TOC("matff","3TE62G1-f4r27B0.m",2);

# 3TE62S3
AGR.GRP("exc","TE62","3TE62S3");
AGR.TOC("matff","3TE62S3G0-f2r54B0.m",2);

# 3TE62d2
AGR.GRP("exc","TE62","3TE62d2");
AGR.TOC("matff","3TE62d2G1-f2r54B0.m",2);

# 3TE62d3
AGR.GRP("exc","TE62","3TE62d3");
AGR.TOC("matff","3TE62d3G0-f4r27B0.m",2);

# 4TE62
AGR.GRP("exc","TE62","4TE62");
AGR.TOC("matff","4TE62G1-f2r1706B0.m",2);

# TE62
AGR.GRP("exc","TE62","TE62");
AGR.TOC("matff","TE62G1-f2r78B0.m",2);
AGR.TOC("matff","TE62G1-f2r1705aB0.m",2);
AGR.TOC("out","TE62G1-a2W1");
AGR.TOC("out","TE62G1-a3W1");

# TE62S3
AGR.GRP("exc","TE62","TE62S3");
AGR.TOC("matff","TE62S3G0-f2r78B0.m",2);

# TE62d2
AGR.GRP("exc","TE62","TE62d2");
AGR.TOC("matff","TE62d2G1-f2r78B0.m",2);
AGR.TOC("matff","TE62d2G1-f3r1938B0.m",2);

# TE62d3
AGR.GRP("exc","TE62","TE62d3");
AGR.TOC("matff","TE62d3G0-f2r78B0.m",2);

# TF42
AGR.GRP("exc","TF42","TF42");
AGR.TOC("perm","TF42G1-p1600B0.m",2);
AGR.TOC("perm","TF42G1-p1755B0.m",2);
AGR.TOC("perm","TF42G1-p2304B0.m",2);
AGR.TOC("perm","TF42G1-p2925B0.m",2);
AGR.TOC("perm","TF42G1-p12480B0.m",2);
AGR.TOC("perm","TF42G1-p14976B0.m",2);
AGR.TOC("matff","TF42G1-f2r26B0.m",2);
AGR.TOC("matff","TF42G1-f2r246B0.m",2);
AGR.TOC("matff","TF42G1-f3r26aB0.m",2);
AGR.TOC("matff","TF42G1-f3r26bB0.m",2);
AGR.TOC("matff","TF42G1-f3r54B0.m",2);
AGR.TOC("matff","TF42G1-f3r77B0.m",2);
AGR.TOC("matff","TF42G1-f3r124aB0.m",2);
AGR.TOC("matff","TF42G1-f3r124bB0.m",2);
AGR.TOC("matff","TF42G1-f4r2048aB0.m",2);
AGR.TOC("matff","TF42G1-f5r27aB0.m",2);
AGR.TOC("matff","TF42G1-f5r27bB0.m",2);
AGR.TOC("matff","TF42G1-f5r52B0.m",2);
AGR.TOC("matff","TF42G1-f5r78B0.m",2);
AGR.TOC("matff","TF42G1-f5r218B0.m",2);
AGR.TOC("matff","TF42G1-f9r27aB0.m",2);
AGR.TOC("matff","TF42G1-f9r27bB0.m",2);
AGR.TOC("matff","TF42G1-f13r27aB0.m",2);
AGR.TOC("matff","TF42G1-f13r27bB0.m",2);
AGR.TOC("matff","TF42G1-f13r52B0.m",2);
AGR.TOC("matff","TF42G1-f13r78B0.m",2);
AGR.TOC("matff","TF42G1-f25r26aB0.m",2);
AGR.TOC("matff","TF42G1-f25r26bB0.m",2);
AGR.TOC("matff","TF42G1-f25r109aB0.m",2);
AGR.TOC("matff","TF42G1-f25r109bB0.m",2);
AGR.TOC("matff","TF42G1-f169r26B0.m",2);
AGR.TOC("matint","TF42G1-Zr52B0.g");
AGR.TOC("matint","TF42G1-Zr78B0.g");
AGR.TOC("maxes","TF42G1-max1W1");
AGR.TOC("maxes","TF42G1-max2W1");
AGR.TOC("maxes","TF42G1-max3W1");
AGR.TOC("maxes","TF42G1-max4W1");
AGR.TOC("maxes","TF42G1-max5W1");
AGR.TOC("maxes","TF42G1-max6W1");
AGR.TOC("maxes","TF42G1-max7W1");
AGR.TOC("maxes","TF42G1-max8W1");
AGR.TOC("cyclic","TF42G1-cycW1");
AGR.TOC("cyc2ccl","TF42G1cycW1-cclsW1");
AGR.TOC("pres","TF42G1-P1");

# TF42d2
AGR.GRP("exc","TF42","TF42d2");
AGR.TOC("perm","TF42d2G1-p1755B0.m",2);
AGR.TOC("perm","TF42d2G1-p2304B0.m",2);
AGR.TOC("matff","TF42d2G1-f2r26B0.m",2);
AGR.TOC("matff","TF42d2G1-f2r246B0.m",2);
AGR.TOC("matff","TF42d2G1-f3r52B0.m",2);
AGR.TOC("matff","TF42d2G1-f3r77B0.m",2);
AGR.TOC("matff","TF42d2G1-f5r27B0.m",2);
AGR.TOC("matff","TF42d2G1-f5r52B0.m",2);
AGR.TOC("matff","TF42d2G1-f5r78B0.m",2);
AGR.TOC("matff","TF42d2G1-f5r218B0.m",2);
AGR.TOC("matff","TF42d2G1-f13r27aB0.m",2);
AGR.TOC("matff","TF42d2G1-f13r27bB0.m",2);
AGR.TOC("matff","TF42d2G1-f13r78B0.m",2);
AGR.TOC("matff","TF42d2G1-f13r1374B0.m",2);
AGR.TOC("maxes","TF42d2G1-max1W1");
AGR.TOC("pres","TF42d2G1-P1");

# 2L2101
AGR.GRP("lin","L2101","2L2101");
AGR.TOC("matalg","2L2101G1-Ar102aB0.g");

# L2101
AGR.GRP("lin","L2101","L2101");
AGR.TOC("matint","L2101G1-Zr101B0.g");
AGR.TOC("matalg","L2101G1-Ar102aB0.g");
AGR.TOC("maxes","L2101G1-max1W1");
AGR.TOC("maxes","L2101G1-max2W1");
AGR.TOC("maxes","L2101G1-max3W1");
AGR.TOC("maxes","L2101G1-max4W1");
AGR.TOC("maxes","L2101G1-max5W1");
AGR.TOC("out","L2101G1-a2W1");

# 2L2103
AGR.GRP("lin","L2103","2L2103");
AGR.TOC("matalg","2L2103G1-Ar104aB0.g");

# L2103
AGR.GRP("lin","L2103","L2103");
AGR.TOC("matint","L2103G1-Zr103B0.g");
AGR.TOC("matalg","L2103G1-Ar104aB0.g");
AGR.TOC("maxes","L2103G1-max1W1");
AGR.TOC("maxes","L2103G1-max2W1");
AGR.TOC("maxes","L2103G1-max3W1");
AGR.TOC("maxes","L2103G1-max4W1");
AGR.TOC("maxes","L2103G1-max5W1");
AGR.TOC("out","L2103G1-a2W1");

# 2L2107
AGR.GRP("lin","L2107","2L2107");
AGR.TOC("matalg","2L2107G1-Ar108aB0.g");

# L2107
AGR.GRP("lin","L2107","L2107");
AGR.TOC("matint","L2107G1-Zr107B0.g");
AGR.TOC("matalg","L2107G1-Ar108aB0.g");
AGR.TOC("maxes","L2107G1-max1W1");
AGR.TOC("maxes","L2107G1-max2W1");
AGR.TOC("maxes","L2107G1-max3W1");
AGR.TOC("maxes","L2107G1-max4W1");
AGR.TOC("out","L2107G1-a2W1");

# 2L2109
AGR.GRP("lin","L2109","2L2109");
AGR.TOC("matalg","2L2109G1-Ar110aB0.g");

# L2109
AGR.GRP("lin","L2109","L2109");
AGR.TOC("matint","L2109G1-Zr109B0.g");
AGR.TOC("matalg","L2109G1-Ar110aB0.g");
AGR.TOC("maxes","L2109G1-max1W1");
AGR.TOC("maxes","L2109G1-max2W1");
AGR.TOC("maxes","L2109G1-max3W1");
AGR.TOC("maxes","L2109G1-max4W1");
AGR.TOC("maxes","L2109G1-max5W1");
AGR.TOC("out","L2109G1-a2W1");

# 2L211
AGR.GRP("lin","L211","2L211");
AGR.TOC("matff","2L211G1-f11r2B0.m",2);
AGR.TOC("matff","2L211G1-f11r4B0.m",2);
AGR.TOC("matff","2L211G1-f11r6B0.m",2);
AGR.TOC("matff","2L211G1-f11r8B0.m",2);
AGR.TOC("matff","2L211G1-f11r10B0.m",2);

# L211
AGR.GRP("lin","L211","L211");
AGR.TOC("perm","L211G1-p11aB0.m",2);
AGR.TOC("perm","L211G1-p11bB0.m",2);
AGR.TOC("perm","L211G1-p12B0.m",2);
AGR.TOC("perm","L211G1-p55B0.m",2);
AGR.TOC("matff","L211G1-f2r10B0.m",2);
AGR.TOC("matff","L211G1-f2r10bB0.m",2);
AGR.TOC("matff","L211G1-f2r24B0.m",2);
AGR.TOC("matff","L211G1-f3r5aB0.m",2);
AGR.TOC("matff","L211G1-f3r5bB0.m",2);
AGR.TOC("matff","L211G1-f3r10B0.m",2);
AGR.TOC("matff","L211G1-f3r24B0.m",2);
AGR.TOC("matff","L211G1-f4r5aB0.m",2);
AGR.TOC("matff","L211G1-f4r5bB0.m",2);
AGR.TOC("matff","L211G1-f4r12aB0.m",2);
AGR.TOC("matff","L211G1-f4r12bB0.m",2);
AGR.TOC("matff","L211G1-f5r5aB0.m",2);
AGR.TOC("matff","L211G1-f5r5bB0.m",2);
AGR.TOC("matff","L211G1-f5r10aB0.m",2);
AGR.TOC("matff","L211G1-f5r10bB0.m",2);
AGR.TOC("matff","L211G1-f5r11B0.m",2);
AGR.TOC("matff","L211G1-f9r12aB0.m",2);
AGR.TOC("matff","L211G1-f9r12bB0.m",2);
AGR.TOC("matff","L211G1-f11r3B0.m",2);
AGR.TOC("matff","L211G1-f11r5B0.m",2);
AGR.TOC("matff","L211G1-f11r7B0.m",2);
AGR.TOC("matff","L211G1-f11r9B0.m",2);
AGR.TOC("matff","L211G1-f11r11B0.m",2);
AGR.TOC("matint","L211G1-Zr10aB0.g");
AGR.TOC("matint","L211G1-Zr10bB0.g");
AGR.TOC("matint","L211G1-Zr10cB0.g");
AGR.TOC("matint","L211G1-Zr11B0.g");
AGR.TOC("matalg","L211G1-Ar5aB0.g");
AGR.TOC("matalg","L211G1-Ar5bB0.g");
AGR.TOC("matalg","L211G1-Ar12aB0.g");
AGR.TOC("matalg","L211G1-Ar12bB0.g");
AGR.TOC("maxes","L211G1-max1W1");
AGR.TOC("maxes","L211G1-max2W1");
AGR.TOC("maxes","L211G1-max3W1");
AGR.TOC("maxes","L211G1-max4W1");
AGR.TOC("cyclic","L211G1-cycW1");
AGR.TOC("cyc2ccl","L211G1cycW1-cclsW1");
AGR.TOC("check","L211G1-check1");
AGR.TOC("pres","L211G1-P1");

# L211d2
AGR.GRP("lin","L211","L211d2");
AGR.TOC("perm","L211d2G1-p12B0.m",2);
AGR.TOC("perm","L211d2G1-p22B0.m",2);
AGR.TOC("perm","L211d2G1-p55aB0.m",2);
AGR.TOC("perm","L211d2G1-p55bB0.m",2);
AGR.TOC("perm","L211d2G1-p66B0.m",2);
AGR.TOC("matff","L211d2G1-f2r10aB0.m",2);
AGR.TOC("matff","L211d2G1-f2r10bB0.m",2);
AGR.TOC("matff","L211d2G1-f4r12aB0.m",2);
AGR.TOC("matff","L211d2G1-f4r12bB0.m",2);
AGR.TOC("matff","L211d2G1-f11r3B0.m",2);
AGR.TOC("matff","L211d2G1-f11r5B0.m",2);
AGR.TOC("matff","L211d2G1-f11r7B0.m",2);
AGR.TOC("matff","L211d2G1-f11r9B0.m",2);
AGR.TOC("matff","L211d2G1-f11r11B0.m",2);
AGR.TOC("maxes","L211d2G1-max1W1");
AGR.TOC("maxes","L211d2G1-max2W1");
AGR.TOC("maxes","L211d2G1-max3W1");
AGR.TOC("maxes","L211d2G1-max4W1");
AGR.TOC("maxes","L211d2G1-max5W1");
AGR.TOC("cyclic","L211d2G1-cycW1");
AGR.TOC("cyc2ccl","L211d2G1cycW1-cclsW1");
AGR.TOC("check","L211d2G1-check1");
AGR.TOC("pres","L211d2G1-P1");

# 2L2113
AGR.GRP("lin","L2113","2L2113");
AGR.TOC("matalg","2L2113G1-Ar114aB0.g");

# L2113
AGR.GRP("lin","L2113","L2113");
AGR.TOC("matint","L2113G1-Zr113B0.g");
AGR.TOC("matalg","L2113G1-Ar114aB0.g");
AGR.TOC("maxes","L2113G1-max1W1");
AGR.TOC("maxes","L2113G1-max2W1");
AGR.TOC("maxes","L2113G1-max3W1");
AGR.TOC("maxes","L2113G1-max4W1");
AGR.TOC("maxes","L2113G1-max5W1");
AGR.TOC("out","L2113G1-a2W1");

# 2L2127
AGR.GRP("lin","L2127","2L2127");
AGR.TOC("matalg","2L2127G1-Ar128aB0.g");

# L2127
AGR.GRP("lin","L2127","L2127");
AGR.TOC("matint","L2127G1-Zr127B0.g");
AGR.TOC("matalg","L2127G1-Ar128aB0.g");
AGR.TOC("maxes","L2127G1-max1W1");
AGR.TOC("maxes","L2127G1-max2W1");
AGR.TOC("maxes","L2127G1-max3W1");
AGR.TOC("maxes","L2127G1-max4W1");
AGR.TOC("maxes","L2127G1-max5W1");
AGR.TOC("out","L2127G1-a2W1");

# L2128
AGR.GRP("lin","L2128","L2128");
AGR.TOC("matint","L2128G1-Zr128B0.g");
AGR.TOC("matalg","L2128G1-Ar129aB0.g");

# 2L213
AGR.GRP("lin","L213","2L213");
AGR.TOC("matff","2L213G1-f3r6aB0.m",2);
AGR.TOC("matff","2L213G1-f3r6bB0.m",2);
AGR.TOC("matff","2L213G1-f3r14B0.m",2);
AGR.TOC("matff","2L213G1-f7r14aB0.m",2);
AGR.TOC("matff","2L213G1-f13r2B0.m",2);
AGR.TOC("matff","2L213G1-f13r4B0.m",2);
AGR.TOC("matff","2L213G1-f13r6B0.m",2);
AGR.TOC("matff","2L213G1-f13r8B0.m",2);
AGR.TOC("matff","2L213G1-f13r10B0.m",2);
AGR.TOC("matff","2L213G1-f13r12B0.m",2);
AGR.TOC("matff","2L213G1-f27r12aB0.m",2);
AGR.TOC("matff","2L213G1-f27r12bB0.m",2);
AGR.TOC("matff","2L213G1-f27r12cB0.m",2);
AGR.TOC("matff","2L213G1-f49r6aB0.m",2);
AGR.TOC("matff","2L213G1-f49r6bB0.m",2);
AGR.TOC("matff","2L213G1-f49r14bB0.m",2);
AGR.TOC("matff","2L213G1-f49r14cB0.m",2);

# 2L213d2
AGR.GRP("lin","L213","2L213d2");
AGR.TOC("matff","2L213d2G1-f3r12aB0.m",2);

# L213
AGR.GRP("lin","L213","L213");
AGR.TOC("perm","L213G1-p14B0.m",2);
AGR.TOC("matff","L213G1-f2r14B0.m",2);
AGR.TOC("matff","L213G1-f3r13B0.m",2);
AGR.TOC("matff","L213G1-f4r6aB0.m",2);
AGR.TOC("matff","L213G1-f4r6bB0.m",2);
AGR.TOC("matff","L213G1-f7r12B0.m",2);
AGR.TOC("matff","L213G1-f8r12aB0.m",2);
AGR.TOC("matff","L213G1-f8r12bB0.m",2);
AGR.TOC("matff","L213G1-f8r12cB0.m",2);
AGR.TOC("matff","L213G1-f13r3B0.m",2);
AGR.TOC("matff","L213G1-f13r5B0.m",2);
AGR.TOC("matff","L213G1-f13r7B0.m",2);
AGR.TOC("matff","L213G1-f13r9B0.m",2);
AGR.TOC("matff","L213G1-f13r11B0.m",2);
AGR.TOC("matff","L213G1-f13r13B0.m",2);
AGR.TOC("matint","L213G1-Zr13B0.g");
AGR.TOC("matint","L213G1-Zr14aB0.g");
AGR.TOC("matint","L213G1-Zr14bB0.g");
AGR.TOC("matint","L213G1-Zr14cB0.g");
AGR.TOC("matint","L213G1-Zr36B0.g");
AGR.TOC("matalg","L213G1-Ar12aB0.g");
AGR.TOC("matalg","L213G1-Ar12bB0.g");
AGR.TOC("matalg","L213G1-Ar12cB0.g");
AGR.TOC("cyclic","L213G1-cycW1");
AGR.TOC("cyc2ccl","L213G1cycW1-cclsW1");
AGR.TOC("out","L213G1-a2W1");
AGR.TOC("check","L213G1-check1");

# L213d2
AGR.GRP("lin","L213","L213d2");
AGR.TOC("perm","L213d2G1-p14B0.m",2);
AGR.TOC("perm","L213d2G1-p78B0.m",2);
AGR.TOC("perm","L213d2G1-p91aB0.m",2);
AGR.TOC("matff","L213d2G1-f2r12aB0.m",2);
AGR.TOC("matff","L213d2G1-f2r14B0.m",2);
AGR.TOC("matff","L213d2G1-f13r3aB0.m",2);
AGR.TOC("cyclic","L213d2G1-cycW1");
AGR.TOC("cyc2ccl","L213d2G1cycW1-cclsW1");

# 2L2131
AGR.GRP("lin","L2131","2L2131");
AGR.TOC("matalg","2L2131G1-Ar132aB0.g");

# L2131
AGR.GRP("lin","L2131","L2131");
AGR.TOC("matint","L2131G1-Zr131B0.g");
AGR.TOC("matalg","L2131G1-Ar132aB0.g");
AGR.TOC("maxes","L2131G1-max1W1");
AGR.TOC("maxes","L2131G1-max2W1");
AGR.TOC("maxes","L2131G1-max3W1");
AGR.TOC("maxes","L2131G1-max4W1");
AGR.TOC("maxes","L2131G1-max5W1");
AGR.TOC("out","L2131G1-a2W1");

# 2L2137
AGR.GRP("lin","L2137","2L2137");
AGR.TOC("matalg","2L2137G1-Ar138aB0.g");

# L2137
AGR.GRP("lin","L2137","L2137");
AGR.TOC("matint","L2137G1-Zr137B0.g");
AGR.TOC("matalg","L2137G1-Ar138aB0.g");
AGR.TOC("maxes","L2137G1-max1W1");
AGR.TOC("maxes","L2137G1-max2W1");
AGR.TOC("maxes","L2137G1-max3W1");
AGR.TOC("maxes","L2137G1-max4W1");
AGR.TOC("maxes","L2137G1-max5W1");
AGR.TOC("out","L2137G1-a2W1");

# 2L2139
AGR.GRP("lin","L2139","2L2139");
AGR.TOC("matalg","2L2139G1-Ar140aB0.g");

# L2139
AGR.GRP("lin","L2139","L2139");
AGR.TOC("matint","L2139G1-Zr139B0.g");
AGR.TOC("matalg","L2139G1-Ar140aB0.g");
AGR.TOC("maxes","L2139G1-max1W1");
AGR.TOC("maxes","L2139G1-max2W1");
AGR.TOC("maxes","L2139G1-max3W1");
AGR.TOC("maxes","L2139G1-max4W1");
AGR.TOC("maxes","L2139G1-max5W1");
AGR.TOC("out","L2139G1-a2W1");

# 2L2149
AGR.GRP("lin","L2149","2L2149");
AGR.TOC("matalg","2L2149G1-Ar150aB0.g");

# L2149
AGR.GRP("lin","L2149","L2149");
AGR.TOC("matint","L2149G1-Zr149B0.g");
AGR.TOC("matalg","L2149G1-Ar150aB0.g");
AGR.TOC("maxes","L2149G1-max1W1");
AGR.TOC("maxes","L2149G1-max2W1");
AGR.TOC("maxes","L2149G1-max3W1");
AGR.TOC("maxes","L2149G1-max4W1");
AGR.TOC("maxes","L2149G1-max5W1");
AGR.TOC("out","L2149G1-a2W1");

# 2L2151
AGR.GRP("lin","L2151","2L2151");
AGR.TOC("matalg","2L2151G1-Ar152aB0.g");

# L2151
AGR.GRP("lin","L2151","L2151");
AGR.TOC("matint","L2151G1-Zr151B0.g");
AGR.TOC("matalg","L2151G1-Ar152aB0.g");
AGR.TOC("maxes","L2151G1-max1W1");
AGR.TOC("maxes","L2151G1-max2W1");
AGR.TOC("maxes","L2151G1-max3W1");
AGR.TOC("maxes","L2151G1-max4W1");
AGR.TOC("maxes","L2151G1-max5W1");
AGR.TOC("maxes","L2151G1-max6W1");
AGR.TOC("maxes","L2151G1-max7W1");
AGR.TOC("out","L2151G1-a2W1");

# 2L2157
AGR.GRP("lin","L2157","2L2157");
AGR.TOC("matalg","2L2157G1-Ar158aB0.g");

# L2157
AGR.GRP("lin","L2157","L2157");
AGR.TOC("matint","L2157G1-Zr157B0.g");
AGR.TOC("matalg","L2157G1-Ar158aB0.g");
AGR.TOC("maxes","L2157G1-max1W1");
AGR.TOC("maxes","L2157G1-max2W1");
AGR.TOC("maxes","L2157G1-max3W1");
AGR.TOC("maxes","L2157G1-max4W1");
AGR.TOC("out","L2157G1-a2W1");

# L216
AGR.GRP("lin","L216","L216");
AGR.TOC("perm","L216G1-p17B0.m",2);
AGR.TOC("matff","L216G1-f3r16B0.m",2);
AGR.TOC("matff","L216G1-f5r16B0.m",2);
AGR.TOC("matff","L216G1-f9r17aB0.m",2);
AGR.TOC("matff","L216G1-f9r17bB0.m",2);
AGR.TOC("matff","L216G1-f16r2aB0.m",2);
AGR.TOC("matff","L216G1-f17r15B0.m",2);
AGR.TOC("matff","L216G1-f17r17B0.m",2);
AGR.TOC("matff","L216G1-f17r34B0.m",2);
AGR.TOC("matff","L216G1-f17r68B0.m",2);
AGR.TOC("matint","L216G1-Zr16B0.g");
AGR.TOC("matint","L216G1-Zr17aB0.g");
AGR.TOC("matint","L216G1-Zr34B0.g");
AGR.TOC("matint","L216G1-Zr68B0.g");
AGR.TOC("matint","L216G1-Zr120B0.g");
AGR.TOC("cyclic","L216G1-cycW1");
AGR.TOC("cyc2ccl","L216G1cycW1-cclsW1");
AGR.TOC("out","L216G1-a2W1");
AGR.TOC("out","L216G1-a4W1");
AGR.TOC("check","L216G1-check1");

# L216d2
AGR.GRP("lin","L216","L216d2");
AGR.TOC("matff","L216d2G1-f4r4aB0.m",2);
AGR.TOC("cyclic","L216d2G1-cycW1");
AGR.TOC("cyc2ccl","L216d2G1cycW1-cclsW1");

# L216d4
AGR.GRP("lin","L216","L216d4");
AGR.TOC("matff","L216d4G1-f2r8aB0.m",2);
AGR.TOC("matff","L216d4G1-f2r8bB0.m",2);
AGR.TOC("matff","L216d4G1-f2r16aB0.m",2);
AGR.TOC("matff","L216d4G1-f2r16bB0.m",2);
AGR.TOC("matff","L216d4G1-f2r32B0.m",2);
AGR.TOC("matff","L216d4G1-f3r16aB0.m",2);
AGR.TOC("matff","L216d4G1-f5r16aB0.m",2);
AGR.TOC("matff","L216d4G1-f5r17aB0.m",2);
AGR.TOC("matff","L216d4G1-f9r60aB0.m",2);
AGR.TOC("matff","L216d4G1-f9r60bB0.m",2);
AGR.TOC("matff","L216d4G1-f17r15aB0.m",2);
AGR.TOC("matff","L216d4G1-f17r17aB0.m",2);
AGR.TOC("matff","L216d4G1-f17r34aB0.m",2);
AGR.TOC("matff","L216d4G1-f17r68B0.m",2);
AGR.TOC("matff","L216d4G1-f25r60aB0.m",2);
AGR.TOC("matff","L216d4G1-f25r60bB0.m",2);
AGR.TOC("cyclic","L216d4G1-cycW1");
AGR.TOC("cyc2ccl","L216d4G1cycW1-cclsW1");

# 2L2163
AGR.GRP("lin","L2163","2L2163");
AGR.TOC("matalg","2L2163G1-Ar164aB0.g");

# L2163
AGR.GRP("lin","L2163","L2163");
AGR.TOC("matint","L2163G1-Zr163B0.g");
AGR.TOC("matalg","L2163G1-Ar164aB0.g");
AGR.TOC("maxes","L2163G1-max1W1");
AGR.TOC("maxes","L2163G1-max2W1");
AGR.TOC("maxes","L2163G1-max3W1");
AGR.TOC("maxes","L2163G1-max4W1");
AGR.TOC("out","L2163G1-a2W1");

# 2L2167
AGR.GRP("lin","L2167","2L2167");
AGR.TOC("matalg","2L2167G1-Ar168aB0.g");

# L2167
AGR.GRP("lin","L2167","L2167");
AGR.TOC("matint","L2167G1-Zr167B0.g");
AGR.TOC("matalg","L2167G1-Ar168aB0.g");
AGR.TOC("maxes","L2167G1-max1W1");
AGR.TOC("maxes","L2167G1-max2W1");
AGR.TOC("maxes","L2167G1-max3W1");
AGR.TOC("maxes","L2167G1-max4W1");
AGR.TOC("maxes","L2167G1-max5W1");
AGR.TOC("out","L2167G1-a2W1");

# 2L217
AGR.GRP("lin","L217","2L217");
AGR.TOC("matff","2L217G1-f9r8aB0.m",2);
AGR.TOC("matff","2L217G1-f9r8bB0.m",2);
AGR.TOC("matff","2L217G1-f17r2B0.m",2);
AGR.TOC("matff","2L217G1-f17r4B0.m",2);
AGR.TOC("matff","2L217G1-f17r6B0.m",2);
AGR.TOC("matff","2L217G1-f17r8B0.m",2);
AGR.TOC("matff","2L217G1-f17r10B0.m",2);
AGR.TOC("matff","2L217G1-f17r12B0.m",2);
AGR.TOC("matff","2L217G1-f17r14B0.m",2);
AGR.TOC("matff","2L217G1-f17r16B0.m",2);

# 2L217d2
AGR.GRP("lin","L217","2L217d2");
AGR.TOC("matff","2L217d2G1-f3r16B0.m",2);

# L217
AGR.GRP("lin","L217","L217");
AGR.TOC("perm","L217G1-p18B0.m",2);
AGR.TOC("matff","L217G1-f2r8aB0.m",2);
AGR.TOC("matff","L217G1-f2r8bB0.m",2);
AGR.TOC("matff","L217G1-f2r16aB0.m",2);
AGR.TOC("matff","L217G1-f2r48B0.m",2);
AGR.TOC("matff","L217G1-f3r16B0.m",2);
AGR.TOC("matff","L217G1-f3r18aB0.m",2);
AGR.TOC("matff","L217G1-f8r16bB0.m",2);
AGR.TOC("matff","L217G1-f8r16cB0.m",2);
AGR.TOC("matff","L217G1-f8r16dB0.m",2);
AGR.TOC("matff","L217G1-f9r9aB0.m",2);
AGR.TOC("matff","L217G1-f9r9bB0.m",2);
AGR.TOC("matff","L217G1-f9r18bB0.m",2);
AGR.TOC("matff","L217G1-f9r18cB0.m",2);
AGR.TOC("matff","L217G1-f17r3B0.m",2);
AGR.TOC("matff","L217G1-f17r5B0.m",2);
AGR.TOC("matff","L217G1-f17r7B0.m",2);
AGR.TOC("matff","L217G1-f17r9B0.m",2);
AGR.TOC("matff","L217G1-f17r11B0.m",2);
AGR.TOC("matff","L217G1-f17r13B0.m",2);
AGR.TOC("matff","L217G1-f17r15B0.m",2);
AGR.TOC("matff","L217G1-f17r17B0.m",2);
AGR.TOC("matint","L217G1-Zr16aB0.g");
AGR.TOC("matint","L217G1-Zr17B0.g");
AGR.TOC("matint","L217G1-Zr18aB0.g");
AGR.TOC("matint","L217G1-Zr18dB0.g");
AGR.TOC("matint","L217G1-Zr48B0.g");
AGR.TOC("matalg","L217G1-Ar9aB0.g");
AGR.TOC("matalg","L217G1-Ar9bB0.g");
AGR.TOC("cyclic","L217G1-cycW1");
AGR.TOC("cyc2ccl","L217G1cycW1-cclsW1");
AGR.TOC("check","L217G1-check1");

# L217d2
AGR.GRP("lin","L217","L217d2");
AGR.TOC("perm","L217d2G1-p18B0.m",2);
AGR.TOC("matff","L217d2G1-f17r3B0.m",2);

# 2L2173
AGR.GRP("lin","L2173","2L2173");
AGR.TOC("matalg","2L2173G1-Ar174aB0.g");

# L2173
AGR.GRP("lin","L2173","L2173");
AGR.TOC("matint","L2173G1-Zr173B0.g");
AGR.TOC("matalg","L2173G1-Ar174aB0.g");
AGR.TOC("maxes","L2173G1-max1W1");
AGR.TOC("maxes","L2173G1-max2W1");
AGR.TOC("maxes","L2173G1-max3W1");
AGR.TOC("maxes","L2173G1-max4W1");
AGR.TOC("out","L2173G1-a2W1");

# 2L2179
AGR.GRP("lin","L2179","2L2179");
AGR.TOC("matalg","2L2179G1-Ar180aB0.g");

# L2179
AGR.GRP("lin","L2179","L2179");
AGR.TOC("matint","L2179G1-Zr179B0.g");
AGR.TOC("matalg","L2179G1-Ar180aB0.g");
AGR.TOC("maxes","L2179G1-max1W1");
AGR.TOC("maxes","L2179G1-max2W1");
AGR.TOC("maxes","L2179G1-max3W1");
AGR.TOC("maxes","L2179G1-max4W1");
AGR.TOC("maxes","L2179G1-max5W1");
AGR.TOC("out","L2179G1-a2W1");

# 2L2181
AGR.GRP("lin","L2181","2L2181");
AGR.TOC("matalg","2L2181G1-Ar182aB0.g");

# L2181
AGR.GRP("lin","L2181","L2181");
AGR.TOC("matint","L2181G1-Zr181B0.g");
AGR.TOC("matalg","L2181G1-Ar182aB0.g");
AGR.TOC("maxes","L2181G1-max1W1");
AGR.TOC("maxes","L2181G1-max2W1");
AGR.TOC("maxes","L2181G1-max3W1");
AGR.TOC("maxes","L2181G1-max4W1");
AGR.TOC("maxes","L2181G1-max5W1");
AGR.TOC("out","L2181G1-a2W1");

# 2L219
AGR.GRP("lin","L219","2L219");
AGR.TOC("perm","2L219G1-p40B0.m",2);
AGR.TOC("matff","2L219G1-f19r2B0.m",2);

# 2L219d2i
AGR.GRP("lin","L219","2L219d2i");
AGR.TOC("matff","2L219d2iG1-f3r20B0.m",2);
AGR.TOC("matff","2L219d2iG1-f5r20B0.m",2);
AGR.TOC("matff","2L219d2iG1-f19r2aB0.m",2);

# L219
AGR.GRP("lin","L219","L219");
AGR.TOC("perm","L219G1-p20B0.m",2);
AGR.TOC("perm","L219G1-p57aB0.m",2);
AGR.TOC("perm","L219G1-p57bB0.m",2);
AGR.TOC("perm","L219G1-p171B0.m",2);
AGR.TOC("perm","L219G1-p190B0.m",2);
AGR.TOC("matff","L219G1-f2r20aB0.m",2);
AGR.TOC("matff","L219G1-f3r19B0.m",2);
AGR.TOC("matff","L219G1-f4r9aB0.m",2);
AGR.TOC("matff","L219G1-f4r9bB0.m",2);
AGR.TOC("matff","L219G1-f4r18aB0.m",2);
AGR.TOC("matff","L219G1-f4r18bB0.m",2);
AGR.TOC("matff","L219G1-f5r9aB0.m",2);
AGR.TOC("matff","L219G1-f5r9bB0.m",2);
AGR.TOC("matff","L219G1-f5r18B0.m",2);
AGR.TOC("matff","L219G1-f5r20aB0.m",2);
AGR.TOC("matff","L219G1-f8r20bB0.m",2);
AGR.TOC("matff","L219G1-f8r20cB0.m",2);
AGR.TOC("matff","L219G1-f8r20dB0.m",2);
AGR.TOC("matff","L219G1-f9r9aB0.m",2);
AGR.TOC("matff","L219G1-f9r9bB0.m",2);
AGR.TOC("matff","L219G1-f9r18aB0.m",2);
AGR.TOC("matff","L219G1-f9r18bB0.m",2);
AGR.TOC("matff","L219G1-f9r18cB0.m",2);
AGR.TOC("matff","L219G1-f9r18dB0.m",2);
AGR.TOC("matff","L219G1-f19r3B0.m",2);
AGR.TOC("matff","L219G1-f19r5B0.m",2);
AGR.TOC("matff","L219G1-f19r7B0.m",2);
AGR.TOC("matff","L219G1-f19r9B0.m",2);
AGR.TOC("matff","L219G1-f19r11B0.m",2);
AGR.TOC("matff","L219G1-f19r13B0.m",2);
AGR.TOC("matff","L219G1-f19r15B0.m",2);
AGR.TOC("matff","L219G1-f19r17B0.m",2);
AGR.TOC("matff","L219G1-f19r19B0.m",2);
AGR.TOC("matff","L219G1-f125r20bB0.m",2);
AGR.TOC("matff","L219G1-f125r20cB0.m",2);
AGR.TOC("matff","L219G1-f125r20dB0.m",2);
AGR.TOC("matint","L219G1-Zr18eB0.g");
AGR.TOC("matint","L219G1-Zr19B0.g");
AGR.TOC("matint","L219G1-Zr20aB0.g");
AGR.TOC("matint","L219G1-Zr36aB0.g");
AGR.TOC("cyclic","L219G1-cycW1");
AGR.TOC("cyc2ccl","L219G1cycW1-cclsW1");
AGR.TOC("check","L219G1-check1");

# L219d2
AGR.GRP("lin","L219","L219d2");
AGR.TOC("perm","L219d2G1-p20B0.m",2);
AGR.TOC("perm","L219d2G1-p114B0.m",2);
AGR.TOC("perm","L219d2G1-p171B0.m",2);
AGR.TOC("perm","L219d2G1-p190B0.m",2);
AGR.TOC("perm","L219d2G1-p285B0.m",2);
AGR.TOC("matff","L219d2G1-f19r3B0.m",2);
AGR.TOC("cyclic","L219d2G1-cycW1");
AGR.TOC("cyc2ccl","L219d2G1cycW1-cclsW1");

# 2L2191
AGR.GRP("lin","L2191","2L2191");
AGR.TOC("matalg","2L2191G1-Ar192aB0.g");

# L2191
AGR.GRP("lin","L2191","L2191");
AGR.TOC("matint","L2191G1-Zr191B0.g");
AGR.TOC("matalg","L2191G1-Ar192aB0.g");
AGR.TOC("maxes","L2191G1-max1W1");
AGR.TOC("maxes","L2191G1-max2W1");
AGR.TOC("maxes","L2191G1-max3W1");
AGR.TOC("maxes","L2191G1-max4W1");
AGR.TOC("maxes","L2191G1-max5W1");
AGR.TOC("maxes","L2191G1-max6W1");
AGR.TOC("maxes","L2191G1-max7W1");
AGR.TOC("out","L2191G1-a2W1");

# 2L2193
AGR.GRP("lin","L2193","2L2193");
AGR.TOC("matalg","2L2193G1-Ar194aB0.g");

# L2193
AGR.GRP("lin","L2193","L2193");
AGR.TOC("matint","L2193G1-Zr193B0.g");
AGR.TOC("matalg","L2193G1-Ar194aB0.g");
AGR.TOC("maxes","L2193G1-max1W1");
AGR.TOC("maxes","L2193G1-max2W1");
AGR.TOC("maxes","L2193G1-max3W1");
AGR.TOC("maxes","L2193G1-max4W1");
AGR.TOC("maxes","L2193G1-max5W1");
AGR.TOC("out","L2193G1-a2W1");

# 2L2197
AGR.GRP("lin","L2197","2L2197");
AGR.TOC("matalg","2L2197G1-Ar198aB0.g");

# L2197
AGR.GRP("lin","L2197","L2197");
AGR.TOC("matint","L2197G1-Zr197B0.g");
AGR.TOC("matalg","L2197G1-Ar198aB0.g");
AGR.TOC("maxes","L2197G1-max1W1");
AGR.TOC("maxes","L2197G1-max2W1");
AGR.TOC("maxes","L2197G1-max3W1");
AGR.TOC("maxes","L2197G1-max4W1");
AGR.TOC("out","L2197G1-a2W1");

# 2L2199
AGR.GRP("lin","L2199","2L2199");
AGR.TOC("matalg","2L2199G1-Ar200aB0.g");

# L2199
AGR.GRP("lin","L2199","L2199");
AGR.TOC("matint","L2199G1-Zr199B0.g");
AGR.TOC("matalg","L2199G1-Ar200aB0.g");
AGR.TOC("maxes","L2199G1-max1W1");
AGR.TOC("maxes","L2199G1-max2W1");
AGR.TOC("maxes","L2199G1-max3W1");
AGR.TOC("maxes","L2199G1-max4W1");
AGR.TOC("maxes","L2199G1-max5W1");
AGR.TOC("maxes","L2199G1-max6W1");
AGR.TOC("maxes","L2199G1-max7W1");
AGR.TOC("out","L2199G1-a2W1");

# 2L2211
AGR.GRP("lin","L2211","2L2211");
AGR.TOC("matalg","2L2211G1-Ar212aB0.g");

# L2211
AGR.GRP("lin","L2211","L2211");
AGR.TOC("matint","L2211G1-Zr211B0.g");
AGR.TOC("matalg","L2211G1-Ar212aB0.g");
AGR.TOC("maxes","L2211G1-max1W1");
AGR.TOC("maxes","L2211G1-max2W1");
AGR.TOC("maxes","L2211G1-max3W1");
AGR.TOC("maxes","L2211G1-max4W1");
AGR.TOC("maxes","L2211G1-max5W1");
AGR.TOC("out","L2211G1-a2W1");

# 2L2223
AGR.GRP("lin","L2223","2L2223");
AGR.TOC("matalg","2L2223G1-Ar224aB0.g");

# L2223
AGR.GRP("lin","L2223","L2223");
AGR.TOC("matint","L2223G1-Zr223B0.g");
AGR.TOC("matalg","L2223G1-Ar224aB0.g");
AGR.TOC("maxes","L2223G1-max1W1");
AGR.TOC("maxes","L2223G1-max2W1");
AGR.TOC("maxes","L2223G1-max3W1");
AGR.TOC("maxes","L2223G1-max4W1");
AGR.TOC("maxes","L2223G1-max5W1");
AGR.TOC("out","L2223G1-a2W1");

# 2L2227
AGR.GRP("lin","L2227","2L2227");
AGR.TOC("matalg","2L2227G1-Ar228aB0.g");

# L2227
AGR.GRP("lin","L2227","L2227");
AGR.TOC("matint","L2227G1-Zr227B0.g");
AGR.TOC("matalg","L2227G1-Ar228aB0.g");
AGR.TOC("maxes","L2227G1-max1W1");
AGR.TOC("maxes","L2227G1-max2W1");
AGR.TOC("maxes","L2227G1-max3W1");
AGR.TOC("maxes","L2227G1-max4W1");
AGR.TOC("out","L2227G1-a2W1");

# 2L2229
AGR.GRP("lin","L2229","2L2229");
AGR.TOC("matalg","2L2229G1-Ar230aB0.g");

# L2229
AGR.GRP("lin","L2229","L2229");
AGR.TOC("matint","L2229G1-Zr229B0.g");
AGR.TOC("matalg","L2229G1-Ar230aB0.g");
AGR.TOC("maxes","L2229G1-max1W1");
AGR.TOC("maxes","L2229G1-max2W1");
AGR.TOC("maxes","L2229G1-max3W1");
AGR.TOC("maxes","L2229G1-max4W1");
AGR.TOC("maxes","L2229G1-max5W1");
AGR.TOC("out","L2229G1-a2W1");

# 2L223
AGR.GRP("lin","L223","2L223");
AGR.TOC("matff","2L223G1-f23r2B0.m",2);

# 2L223d2i
AGR.GRP("lin","L223","2L223d2i");
AGR.TOC("matff","2L223d2iG1-f23r2B0.m",2);

# L223
AGR.GRP("lin","L223","L223");
AGR.TOC("perm","L223G1-p24B0.m",2);
AGR.TOC("matff","L223G1-f2r11aB0.m",2);
AGR.TOC("matff","L223G1-f2r11bB0.m",2);
AGR.TOC("matff","L223G1-f2r22B0.m",2);
AGR.TOC("matff","L223G1-f3r22aB0.m",2);
AGR.TOC("matff","L223G1-f11r23B0.m",2);
AGR.TOC("matff","L223G1-f23r3B0.m",2);
AGR.TOC("matff","L223G1-f23r5B0.m",2);
AGR.TOC("matff","L223G1-f23r7B0.m",2);
AGR.TOC("matff","L223G1-f23r9B0.m",2);
AGR.TOC("matff","L223G1-f23r11B0.m",2);
AGR.TOC("matff","L223G1-f23r13B0.m",2);
AGR.TOC("matff","L223G1-f23r15B0.m",2);
AGR.TOC("matff","L223G1-f23r17B0.m",2);
AGR.TOC("matff","L223G1-f23r19B0.m",2);
AGR.TOC("matff","L223G1-f23r21B0.m",2);
AGR.TOC("matff","L223G1-f23r23B0.m",2);
AGR.TOC("matff","L223G1-f32r24aB0.m",2);
AGR.TOC("matff","L223G1-f32r24bB0.m",2);
AGR.TOC("matff","L223G1-f32r24cB0.m",2);
AGR.TOC("matff","L223G1-f32r24dB0.m",2);
AGR.TOC("matff","L223G1-f32r24eB0.m",2);
AGR.TOC("matint","L223G1-Zr22aB0.g");
AGR.TOC("matint","L223G1-Zr22bB0.g");
AGR.TOC("matint","L223G1-Zr22cB0.g");
AGR.TOC("matint","L223G1-Zr23B0.g");
AGR.TOC("matalg","L223G1-Ar24aB0.g");
AGR.TOC("matalg","L223G1-Ar24bB0.g");
AGR.TOC("matalg","L223G1-Ar24cB0.g");
AGR.TOC("matalg","L223G1-Ar24dB0.g");
AGR.TOC("matalg","L223G1-Ar24eB0.g");
AGR.TOC("cyclic","L223G1-cycW1");
AGR.TOC("cyc2ccl","L223G1cycW1-cclsW1");
AGR.TOC("out","L223G1-a2W1");
AGR.TOC("check","L223G1-check1");

# L223d2
AGR.GRP("lin","L223","L223d2");
AGR.TOC("matff","L223d2G1-f2r22aB0.m",2);
AGR.TOC("matff","L223d2G1-f23r3aB0.m",2);
AGR.TOC("cyclic","L223d2G1-cycW1");
AGR.TOC("cyc2ccl","L223d2G1cycW1-cclsW1");

# 2L2233
AGR.GRP("lin","L2233","2L2233");
AGR.TOC("matalg","2L2233G1-Ar234aB0.g");

# L2233
AGR.GRP("lin","L2233","L2233");
AGR.TOC("matint","L2233G1-Zr233B0.g");
AGR.TOC("matalg","L2233G1-Ar234aB0.g");
AGR.TOC("maxes","L2233G1-max1W1");
AGR.TOC("maxes","L2233G1-max2W1");
AGR.TOC("maxes","L2233G1-max3W1");
AGR.TOC("maxes","L2233G1-max4W1");
AGR.TOC("maxes","L2233G1-max5W1");
AGR.TOC("out","L2233G1-a2W1");

# 2L2239
AGR.GRP("lin","L2239","2L2239");
AGR.TOC("matalg","2L2239G1-Ar240aB0.g");

# L2239
AGR.GRP("lin","L2239","L2239");
AGR.TOC("matint","L2239G1-Zr239B0.g");
AGR.TOC("matalg","L2239G1-Ar240aB0.g");
AGR.TOC("maxes","L2239G1-max1W1");
AGR.TOC("maxes","L2239G1-max2W1");
AGR.TOC("maxes","L2239G1-max3W1");
AGR.TOC("maxes","L2239G1-max4W1");
AGR.TOC("maxes","L2239G1-max5W1");
AGR.TOC("maxes","L2239G1-max6W1");
AGR.TOC("maxes","L2239G1-max7W1");
AGR.TOC("out","L2239G1-a2W1");

# 2L2241
AGR.GRP("lin","L2241","2L2241");
AGR.TOC("matalg","2L2241G1-Ar242aB0.g");

# L2241
AGR.GRP("lin","L2241","L2241");
AGR.TOC("matint","L2241G1-Zr241B0.g");
AGR.TOC("matalg","L2241G1-Ar242aB0.g");
AGR.TOC("maxes","L2241G1-max1W1");
AGR.TOC("maxes","L2241G1-max2W1");
AGR.TOC("maxes","L2241G1-max3W1");
AGR.TOC("maxes","L2241G1-max4W1");
AGR.TOC("maxes","L2241G1-max5W1");
AGR.TOC("maxes","L2241G1-max6W1");
AGR.TOC("maxes","L2241G1-max7W1");
AGR.TOC("out","L2241G1-a2W1");

# L225
AGR.GRP("lin","L225","L225");
AGR.TOC("check","L225G1-check1");

# 2L227
AGR.GRP("lin","L227","2L227");
AGR.TOC("matff","2L227G1-f27r2aB0.m",2);
AGR.TOC("matff","2L227G1-f27r2bB0.m",2);
AGR.TOC("matff","2L227G1-f27r2cB0.m",2);

# L227
AGR.GRP("lin","L227","L227");
AGR.TOC("perm","L227G1-p28B0.m",2);
AGR.TOC("matff","L227G1-f3r27B0.m",2);
AGR.TOC("matff","L227G1-f4r13aB0.m",2);
AGR.TOC("matff","L227G1-f4r13bB0.m",2);
AGR.TOC("matff","L227G1-f7r26B0.m",2);
AGR.TOC("matff","L227G1-f13r27B0.m",2);
AGR.TOC("matff","L227G1-f27r3aB0.m",2);
AGR.TOC("matint","L227G1-Zr26gB0.g");
AGR.TOC("matint","L227G1-Zr27B0.g");
AGR.TOC("matint","L227G1-Zr78aB0.g");
AGR.TOC("matalg","L227G1-Ar13aB0.g");
AGR.TOC("matalg","L227G1-Ar13bB0.g");
AGR.TOC("matalg","L227G1-Ar28aB0.g");
AGR.TOC("matalg","L227G1-Ar28bB0.g");
AGR.TOC("matalg","L227G1-Ar28cB0.g");
AGR.TOC("matalg","L227G1-Ar28dB0.g");
AGR.TOC("matalg","L227G1-Ar28eB0.g");
AGR.TOC("matalg","L227G1-Ar28fB0.g");
AGR.TOC("cyclic","L227G1-cycW1");
AGR.TOC("cyc2ccl","L227G1cycW1-cclsW1");
AGR.TOC("check","L227G1-check1");

# 2L229
AGR.GRP("lin","L229","2L229");
AGR.TOC("matff","2L229G1-f29r2B0.m",2);

# L229
AGR.GRP("lin","L229","L229");
AGR.TOC("perm","L229G1-p30B0.m",2);
AGR.TOC("matff","L229G1-f3r28aB0.m",2);
AGR.TOC("matff","L229G1-f4r14aB0.m",2);
AGR.TOC("matff","L229G1-f4r14bB0.m",2);
AGR.TOC("matff","L229G1-f5r28bB0.m",2);
AGR.TOC("matff","L229G1-f7r29B0.m",2);
AGR.TOC("matff","L229G1-f29r3B0.m",2);
AGR.TOC("matff","L229G1-f29r5B0.m",2);
AGR.TOC("matff","L229G1-f29r7B0.m",2);
AGR.TOC("matff","L229G1-f29r9B0.m",2);
AGR.TOC("matff","L229G1-f29r11B0.m",2);
AGR.TOC("matff","L229G1-f29r13B0.m",2);
AGR.TOC("matff","L229G1-f29r15B0.m",2);
AGR.TOC("matff","L229G1-f29r17B0.m",2);
AGR.TOC("matff","L229G1-f29r19B0.m",2);
AGR.TOC("matff","L229G1-f29r21B0.m",2);
AGR.TOC("matff","L229G1-f29r23B0.m",2);
AGR.TOC("matff","L229G1-f29r25B0.m",2);
AGR.TOC("matff","L229G1-f29r27B0.m",2);
AGR.TOC("matff","L229G1-f29r29B0.m",2);
AGR.TOC("matint","L229G1-Zr28aB0.g");
AGR.TOC("matint","L229G1-Zr29B0.g");
AGR.TOC("matint","L229G1-Zr30gB0.g");
AGR.TOC("matint","L229G1-Zr56B0.g");
AGR.TOC("matint","L229G1-Zr112B0.g");
AGR.TOC("matalg","L229G1-Ar30aB0.g");
AGR.TOC("matalg","L229G1-Ar30bB0.g");
AGR.TOC("matalg","L229G1-Ar30cB0.g");
AGR.TOC("matalg","L229G1-Ar30dB0.g");
AGR.TOC("matalg","L229G1-Ar30eB0.g");
AGR.TOC("matalg","L229G1-Ar30fB0.g");
AGR.TOC("cyclic","L229G1-cycW1");
AGR.TOC("cyc2ccl","L229G1cycW1-cclsW1");
AGR.TOC("check","L229G1-check1");

# 2L231
AGR.GRP("lin","L231","2L231");
AGR.TOC("matff","2L231G1-f5r16aB0.m",2);
AGR.TOC("matff","2L231G1-f31r2B0.m",2);
AGR.TOC("matalg","2L231G1-Ar32aB0.g");

# L231
AGR.GRP("lin","L231","L231");
AGR.TOC("perm","L231G1-p32B0.m",2);
AGR.TOC("matff","L231G1-f2r15aB0.m",2);
AGR.TOC("matff","L231G1-f2r15bB0.m",2);
AGR.TOC("matff","L231G1-f2r32B0.m",2);
AGR.TOC("matff","L231G1-f3r31B0.m",2);
AGR.TOC("matff","L231G1-f4r32bB0.m",2);
AGR.TOC("matff","L231G1-f4r32cB0.m",2);
AGR.TOC("matff","L231G1-f5r31B0.m",2);
AGR.TOC("matff","L231G1-f16r32dB0.m",2);
AGR.TOC("matff","L231G1-f16r32eB0.m",2);
AGR.TOC("matff","L231G1-f16r32fB0.m",2);
AGR.TOC("matff","L231G1-f16r32gB0.m",2);
AGR.TOC("matff","L231G1-f31r3B0.m",2);
AGR.TOC("matff","L231G1-f31r31B0.m",2);
AGR.TOC("matint","L231G1-Zr30aB0.g");
AGR.TOC("matint","L231G1-Zr30hB0.g");
AGR.TOC("matint","L231G1-Zr31B0.g");
AGR.TOC("matint","L231G1-Zr32aB0.g");
AGR.TOC("matint","L231G1-Zr60B0.g");
AGR.TOC("matint","L231G1-Zr120B0.g");
AGR.TOC("matalg","L231G1-Ar32aB0.g");
AGR.TOC("matalg","L231G1-Ar32bB0.g");
AGR.TOC("matalg","L231G1-Ar32cB0.g");
AGR.TOC("matalg","L231G1-Ar32dB0.g");
AGR.TOC("matalg","L231G1-Ar32eB0.g");
AGR.TOC("matalg","L231G1-Ar32fB0.g");
AGR.TOC("matalg","L231G1-Ar32gB0.g");
AGR.TOC("cyclic","L231G1-cycW1");
AGR.TOC("cyc2ccl","L231G1cycW1-cclsW1");
AGR.TOC("check","L231G1-check1");

# L231d2
AGR.GRP("lin","L231","L231d2");
AGR.TOC("matff","L231d2G1-f2r30B0.m",2);

# L232
AGR.GRP("lin","L232","L232");
AGR.TOC("perm","L232G1-p33B0.m",2);
AGR.TOC("perm","L232G1-p496B0.m",2);
AGR.TOC("perm","L232G1-p528B0.m",2);
AGR.TOC("matff","L232G1-f3r31aB0.m",2);
AGR.TOC("matff","L232G1-f11r31bB0.m",2);
AGR.TOC("matff","L232G1-f31r32B0.m",2);
AGR.TOC("matff","L232G1-f32r2aB0.m",2);
AGR.TOC("matint","L232G1-Zr31aB0.g");
AGR.TOC("matint","L232G1-Zr32B0.g");
AGR.TOC("matint","L232G1-Zr155B0.g");
AGR.TOC("matint","L232G1-Zr310B0.g");
AGR.TOC("matalg","L232G1-Ar33aB0.g");
AGR.TOC("matalg","L232G1-Ar33bB0.g");
AGR.TOC("matalg","L232G1-Ar33cB0.g");
AGR.TOC("matalg","L232G1-Ar33dB0.g");
AGR.TOC("matalg","L232G1-Ar33eB0.g");
AGR.TOC("matalg","L232G1-Ar33fB0.g");
AGR.TOC("matalg","L232G1-Ar33gB0.g");
AGR.TOC("matalg","L232G1-Ar33hB0.g");
AGR.TOC("matalg","L232G1-Ar33iB0.g");
AGR.TOC("matalg","L232G1-Ar33jB0.g");
AGR.TOC("matalg","L232G1-Ar33kB0.g");
AGR.TOC("matalg","L232G1-Ar33lB0.g");
AGR.TOC("matalg","L232G1-Ar33mB0.g");
AGR.TOC("matalg","L232G1-Ar33nB0.g");
AGR.TOC("matalg","L232G1-Ar33oB0.g");
AGR.TOC("maxes","L232G1-max1W1");
AGR.TOC("maxes","L232G1-max1W2");
AGR.TOC("maxes","L232G1-max2W1");
AGR.TOC("maxes","L232G1-max3W1");
AGR.TOC("cyclic","L232G1-cycW1");
AGR.TOC("cyc2ccl","L232G1cycW1-cclsW1");
AGR.TOC("out","L232G1-a5W1");
AGR.TOC("check","L232G1-check1");
AGR.TOC("pres","L232G1-P1");

# L232d5
AGR.GRP("lin","L232","L232d5");
AGR.TOC("perm","L232d5G1-p33B0.m",2);
AGR.TOC("perm","L232d5G1-p496B0.m",2);
AGR.TOC("perm","L232d5G1-p528B0.m",2);
AGR.TOC("matff","L232d5G1-f2r10B0.m",2);
AGR.TOC("matff","L232d5G1-f2r20aB0.m",2);
AGR.TOC("matff","L232d5G1-f2r20bB0.m",2);
AGR.TOC("matff","L232d5G1-f2r32B0.m",2);
AGR.TOC("matff","L232d5G1-f2r40aB0.m",2);
AGR.TOC("matff","L232d5G1-f2r40bB0.m",2);
AGR.TOC("matff","L232d5G1-f2r80B0.m",2);
AGR.TOC("maxes","L232d5G1-max1W1");
AGR.TOC("maxes","L232d5G1-max2W1");
AGR.TOC("maxes","L232d5G1-max2W2");
AGR.TOC("maxes","L232d5G1-max3W1");
AGR.TOC("maxes","L232d5G1-max3W2");
AGR.TOC("maxes","L232d5G1-max4W1");
AGR.TOC("maxes","L232d5G1-max4W2");
AGR.TOC("cyclic","L232d5G1-cycW1");
AGR.TOC("cyc2ccl","L232d5G1cycW1-cclsW1");
AGR.TOC("pres","L232d5G1-P1");

# 2L237
AGR.GRP("lin","L237","2L237");
AGR.TOC("matalg","2L237G1-Ar38aB0.g");

# L237
AGR.GRP("lin","L237","L237");
AGR.TOC("matint","L237G1-Zr37B0.g");
AGR.TOC("matalg","L237G1-Ar38aB0.g");
AGR.TOC("maxes","L237G1-max1W1");
AGR.TOC("maxes","L237G1-max2W1");
AGR.TOC("maxes","L237G1-max3W1");
AGR.TOC("maxes","L237G1-max4W1");
AGR.TOC("out","L237G1-a2W1");

# 2L241
AGR.GRP("lin","L241","2L241");
AGR.TOC("matalg","2L241G1-Ar42aB0.g");

# L241
AGR.GRP("lin","L241","L241");
AGR.TOC("matint","L241G1-Zr41B0.g");
AGR.TOC("matalg","L241G1-Ar42aB0.g");
AGR.TOC("maxes","L241G1-max1W1");
AGR.TOC("maxes","L241G1-max2W1");
AGR.TOC("maxes","L241G1-max3W1");
AGR.TOC("maxes","L241G1-max4W1");
AGR.TOC("maxes","L241G1-max5W1");
AGR.TOC("maxes","L241G1-max6W1");
AGR.TOC("maxes","L241G1-max7W1");
AGR.TOC("out","L241G1-a2W1");

# 2L243
AGR.GRP("lin","L243","2L243");
AGR.TOC("matalg","2L243G1-Ar44aB0.g");

# L243
AGR.GRP("lin","L243","L243");
AGR.TOC("matint","L243G1-Zr43B0.g");
AGR.TOC("matalg","L243G1-Ar44aB0.g");
AGR.TOC("maxes","L243G1-max1W1");
AGR.TOC("maxes","L243G1-max2W1");
AGR.TOC("maxes","L243G1-max3W1");
AGR.TOC("maxes","L243G1-max4W1");
AGR.TOC("out","L243G1-a2W1");

# 2L247
AGR.GRP("lin","L247","2L247");
AGR.TOC("matalg","2L247G1-Ar48aB0.g");

# L247
AGR.GRP("lin","L247","L247");
AGR.TOC("matint","L247G1-Zr47B0.g");
AGR.TOC("matalg","L247G1-Ar48aB0.g");
AGR.TOC("maxes","L247G1-max1W1");
AGR.TOC("maxes","L247G1-max2W1");
AGR.TOC("maxes","L247G1-max3W1");
AGR.TOC("maxes","L247G1-max4W1");
AGR.TOC("maxes","L247G1-max5W1");
AGR.TOC("out","L247G1-a2W1");

# 2L249
AGR.GRP("lin","L249","2L249");
AGR.TOC("matff","2L249G1-f49r2aB0.m",2);
AGR.TOC("matff","2L249G1-f49r2bB0.m",2);

# L249
AGR.GRP("lin","L249","L249");
AGR.TOC("perm","L249G1-p50B0.m",2);
AGR.TOC("perm","L249G1-p175aB0.m",2);
AGR.TOC("perm","L249G1-p175bB0.m",2);
AGR.TOC("perm","L249G1-p980aB0.m",2);
AGR.TOC("perm","L249G1-p980bB0.m",2);
AGR.TOC("perm","L249G1-p1176B0.m",2);
AGR.TOC("perm","L249G1-p1225B0.m",2);
AGR.TOC("matff","L249G1-f7r4B0.m",2);
AGR.TOC("matff","L249G1-f49r3aB0.m",2);
AGR.TOC("matff","L249G1-f49r3bB0.m",2);

# 2L253
AGR.GRP("lin","L253","2L253");
AGR.TOC("matalg","2L253G1-Ar54aB0.g");

# L253
AGR.GRP("lin","L253","L253");
AGR.TOC("matint","L253G1-Zr53B0.g");
AGR.TOC("matalg","L253G1-Ar54aB0.g");
AGR.TOC("maxes","L253G1-max1W1");
AGR.TOC("maxes","L253G1-max2W1");
AGR.TOC("maxes","L253G1-max3W1");
AGR.TOC("maxes","L253G1-max4W1");
AGR.TOC("out","L253G1-a2W1");

# 2L259
AGR.GRP("lin","L259","2L259");
AGR.TOC("matalg","2L259G1-Ar60aB0.g");

# L259
AGR.GRP("lin","L259","L259");
AGR.TOC("matint","L259G1-Zr59B0.g");
AGR.TOC("matalg","L259G1-Ar60aB0.g");
AGR.TOC("maxes","L259G1-max1W1");
AGR.TOC("maxes","L259G1-max2W1");
AGR.TOC("maxes","L259G1-max3W1");
AGR.TOC("maxes","L259G1-max4W1");
AGR.TOC("maxes","L259G1-max5W1");
AGR.TOC("out","L259G1-a2W1");

# 2L261
AGR.GRP("lin","L261","2L261");
AGR.TOC("matalg","2L261G1-Ar62aB0.g");

# L261
AGR.GRP("lin","L261","L261");
AGR.TOC("matint","L261G1-Zr61B0.g");
AGR.TOC("matalg","L261G1-Ar62aB0.g");
AGR.TOC("maxes","L261G1-max1W1");
AGR.TOC("maxes","L261G1-max2W1");
AGR.TOC("maxes","L261G1-max3W1");
AGR.TOC("maxes","L261G1-max4W1");
AGR.TOC("maxes","L261G1-max5W1");
AGR.TOC("out","L261G1-a2W1");

# L264
AGR.GRP("lin","L264","L264");
AGR.TOC("matint","L264G1-Zr64B0.g");
AGR.TOC("matalg","L264G1-Ar65aB0.g");

# 2L267
AGR.GRP("lin","L267","2L267");
AGR.TOC("matalg","2L267G1-Ar68aB0.g");

# L267
AGR.GRP("lin","L267","L267");
AGR.TOC("matint","L267G1-Zr67B0.g");
AGR.TOC("matalg","L267G1-Ar68aB0.g");
AGR.TOC("maxes","L267G1-max1W1");
AGR.TOC("maxes","L267G1-max2W1");
AGR.TOC("maxes","L267G1-max3W1");
AGR.TOC("maxes","L267G1-max4W1");
AGR.TOC("out","L267G1-a2W1");

# 2L27
AGR.GRP("lin","L27","2L27");
AGR.TOC("perm","2L27G1-p16B0.m",2);
AGR.TOC("perm","2L27G1-p48B0.m",2);
AGR.TOC("perm","2L27G1-p112B0.m",2);
AGR.TOC("perm","2L27G1-p336B0.m",2);
AGR.TOC("matff","2L27G1-f3r8B0.m",2);
AGR.TOC("matff","2L27G1-f3r12B0.m",2);
AGR.TOC("matff","2L27G1-f7r2B0.m",2);
AGR.TOC("matff","2L27G1-f7r4B0.m",2);
AGR.TOC("matff","2L27G1-f7r6B0.m",2);
AGR.TOC("matff","2L27G1-f9r4aB0.m",2);
AGR.TOC("matff","2L27G1-f9r4bB0.m",2);
AGR.TOC("matff","2L27G1-f9r6aB0.m",2);
AGR.TOC("matff","2L27G1-f9r6bB0.m",2);
AGR.TOC("pres","2L27G1-P1");

# 2L27d2
AGR.GRP("lin","L27","2L27d2");
AGR.TOC("perm","2L27d2G1-p32B0.m",2);
AGR.TOC("perm","2L27d2G1-p96B0.m",2);
AGR.TOC("perm","2L27d2G1-p224B0.m",2);
AGR.TOC("perm","2L27d2G1-p672B0.m",2);

# 2L27d2i
AGR.GRP("lin","L27","2L27d2i");
AGR.TOC("perm","2L27d2iG1-p16aB0.m",2);
AGR.TOC("perm","2L27d2iG1-p16bB0.m",2);
AGR.TOC("perm","2L27d2iG1-p32B0.m",2);
AGR.TOC("perm","2L27d2iG1-p48aB0.m",2);
AGR.TOC("perm","2L27d2iG1-p48bB0.m",2);
AGR.TOC("perm","2L27d2iG1-p96B0.m",2);
AGR.TOC("perm","2L27d2iG1-p112aB0.m",2);
AGR.TOC("perm","2L27d2iG1-p112bB0.m",2);
AGR.TOC("perm","2L27d2iG1-p224B0.m",2);
AGR.TOC("perm","2L27d2iG1-p336B0.m",2);
AGR.TOC("perm","2L27d2iG1-p672B0.m",2);

# L27
AGR.GRP("lin","L27","L27");
AGR.TOC("perm","L27G1-p7aB0.m",2);
AGR.TOC("perm","L27G1-p7bB0.m",2);
AGR.TOC("perm","L27G1-p8B0.m",2);
AGR.TOC("perm","L27G1-p14aB0.m",2);
AGR.TOC("perm","L27G1-p14bB0.m",2);
AGR.TOC("perm","L27G1-p21B0.m",2);
AGR.TOC("perm","L27G1-p24B0.m",2);
AGR.TOC("perm","L27G1-p28B0.m",2);
AGR.TOC("perm","L27G1-p42aB0.m",2);
AGR.TOC("perm","L27G1-p42bB0.m",2);
AGR.TOC("perm","L27G1-p42cB0.m",2);
AGR.TOC("perm","L27G1-p56B0.m",2);
AGR.TOC("perm","L27G1-p84B0.m",2);
AGR.TOC("perm","L27G1-p168B0.m",2);
AGR.TOC("matff","L27G1-f2r3aB0.m",2);
AGR.TOC("matff","L27G1-f2r3bB0.m",2);
AGR.TOC("matff","L27G1-f2r8B0.m",2);
AGR.TOC("matff","L27G1-f3r6aB0.m",2);
AGR.TOC("matff","L27G1-f3r6bB0.m",2);
AGR.TOC("matff","L27G1-f3r7B0.m",2);
AGR.TOC("matff","L27G1-f7r3B0.m",2);
AGR.TOC("matff","L27G1-f7r5B0.m",2);
AGR.TOC("matff","L27G1-f7r7B0.m",2);
AGR.TOC("matff","L27G1-f9r3aB0.m",2);
AGR.TOC("matff","L27G1-f9r3bB0.m",2);
AGR.TOC("matint","L27G1-Zr6aB0.g");
AGR.TOC("matint","L27G1-Zr6bB0.g");
AGR.TOC("matint","L27G1-Zr7B0.g");
AGR.TOC("matint","L27G1-Zr8B0.g");
AGR.TOC("matalg","L27G1-Ar3aB0.g");
AGR.TOC("matalg","L27G1-Ar3bB0.g");
AGR.TOC("maxes","L27G1-max1W1");
AGR.TOC("maxes","L27G1-max1W2");
AGR.TOC("maxes","L27G1-max1W3");
AGR.TOC("maxes","L27G1-max2W1");
AGR.TOC("maxes","L27G1-max2W2");
AGR.TOC("maxes","L27G1-max2W3");
AGR.TOC("maxes","L27G1-max3W1");
AGR.TOC("maxes","L27G1-max3W2");
AGR.TOC("maxes","L27G1-max3W3");
AGR.TOC("check","L27G1-check1");
AGR.TOC("pres","L27G1-P1");

# L27d2
AGR.GRP("lin","L27","L27d2");
AGR.TOC("perm","L27d2G1-p8B0.m",2);
AGR.TOC("perm","L27d2G1-p14B0.m",2);
AGR.TOC("perm","L27d2G1-p16B0.m",2);
AGR.TOC("perm","L27d2G1-p21B0.m",2);
AGR.TOC("perm","L27d2G1-p24B0.m",2);
AGR.TOC("perm","L27d2G1-p28B0.m",2);
AGR.TOC("perm","L27d2G1-p28bB0.m",2);
AGR.TOC("perm","L27d2G1-p42aB0.m",2);
AGR.TOC("perm","L27d2G1-p42bB0.m",2);
AGR.TOC("perm","L27d2G1-p42cB0.m",2);
AGR.TOC("perm","L27d2G1-p48B0.m",2);
AGR.TOC("perm","L27d2G1-p56aB0.m",2);
AGR.TOC("perm","L27d2G1-p56bB0.m",2);
AGR.TOC("perm","L27d2G1-p56cB0.m",2);
AGR.TOC("perm","L27d2G1-p84aB0.m",2);
AGR.TOC("perm","L27d2G1-p84bB0.m",2);
AGR.TOC("perm","L27d2G1-p84cB0.m",2);
AGR.TOC("perm","L27d2G1-p112B0.m",2);
AGR.TOC("perm","L27d2G1-p168aB0.m",2);
AGR.TOC("perm","L27d2G1-p168bB0.m",2);
AGR.TOC("perm","L27d2G1-p336B0.m",2);
AGR.TOC("maxes","L27d2G1-max1W1");
AGR.TOC("maxes","L27d2G1-max1W2");
AGR.TOC("maxes","L27d2G1-max2W1");
AGR.TOC("maxes","L27d2G1-max3W1");
AGR.TOC("maxes","L27d2G1-max4W1");
AGR.TOC("switch","L27d2G2-G1W1");
AGR.TOC("switch","L27d2G2-G1W2");
AGR.TOC("pres","L27d2G1-P1");

# 2L271
AGR.GRP("lin","L271","2L271");
AGR.TOC("matalg","2L271G1-Ar72aB0.g");

# L271
AGR.GRP("lin","L271","L271");
AGR.TOC("matint","L271G1-Zr71B0.g");
AGR.TOC("matalg","L271G1-Ar72aB0.g");
AGR.TOC("maxes","L271G1-max1W1");
AGR.TOC("maxes","L271G1-max2W1");
AGR.TOC("maxes","L271G1-max3W1");
AGR.TOC("maxes","L271G1-max4W1");
AGR.TOC("maxes","L271G1-max5W1");
AGR.TOC("maxes","L271G1-max6W1");
AGR.TOC("maxes","L271G1-max7W1");
AGR.TOC("out","L271G1-a2W1");

# 2L273
AGR.GRP("lin","L273","2L273");
AGR.TOC("matalg","2L273G1-Ar74aB0.g");

# L273
AGR.GRP("lin","L273","L273");
AGR.TOC("matint","L273G1-Zr73B0.g");
AGR.TOC("matalg","L273G1-Ar74aB0.g");
AGR.TOC("maxes","L273G1-max1W1");
AGR.TOC("maxes","L273G1-max2W1");
AGR.TOC("maxes","L273G1-max3W1");
AGR.TOC("maxes","L273G1-max4W1");
AGR.TOC("maxes","L273G1-max5W1");
AGR.TOC("out","L273G1-a2W1");

# 2L279
AGR.GRP("lin","L279","2L279");
AGR.TOC("matalg","2L279G1-Ar80aB0.g");

# L279
AGR.GRP("lin","L279","L279");
AGR.TOC("matint","L279G1-Zr79B0.g");
AGR.TOC("matalg","L279G1-Ar80aB0.g");
AGR.TOC("maxes","L279G1-max1W1");
AGR.TOC("maxes","L279G1-max2W1");
AGR.TOC("maxes","L279G1-max3W1");
AGR.TOC("maxes","L279G1-max4W1");
AGR.TOC("maxes","L279G1-max5W1");
AGR.TOC("maxes","L279G1-max6W1");
AGR.TOC("maxes","L279G1-max7W1");
AGR.TOC("out","L279G1-a2W1");

# L28
AGR.GRP("lin","L28","L28");
AGR.TOC("perm","L28G1-p9B0.m",2);
AGR.TOC("perm","L28G1-p28B0.m",2);
AGR.TOC("perm","L28G1-p36B0.m",2);
AGR.TOC("matff","L28G1-f2r6B0.m",2);
AGR.TOC("matff","L28G1-f2r8B0.m",2);
AGR.TOC("matff","L28G1-f2r12B0.m",2);
AGR.TOC("matff","L28G1-f3r7B0.m",2);
AGR.TOC("matff","L28G1-f3r27B0.m",2);
AGR.TOC("matff","L28G1-f7r7aB0.m",2);
AGR.TOC("matff","L28G1-f7r8B0.m",2);
AGR.TOC("matff","L28G1-f7r21B0.m",2);
AGR.TOC("matff","L28G1-f8r2aB0.m",2);
AGR.TOC("matff","L28G1-f8r2bB0.m",2);
AGR.TOC("matff","L28G1-f8r2cB0.m",2);
AGR.TOC("matff","L28G1-f8r4aB0.m",2);
AGR.TOC("matff","L28G1-f8r4bB0.m",2);
AGR.TOC("matff","L28G1-f8r4cB0.m",2);
AGR.TOC("matff","L28G1-f27r9aB0.m",2);
AGR.TOC("matff","L28G1-f27r9bB0.m",2);
AGR.TOC("matff","L28G1-f27r9cB0.m",2);
AGR.TOC("matint","L28G1-Zr7aB0.g");
AGR.TOC("matint","L28G1-Zr8B0.g");
AGR.TOC("matint","L28G1-Zr27B0.g");
AGR.TOC("matalg","L28G1-Ar7bB0.g");
AGR.TOC("matalg","L28G1-Ar7cB0.g");
AGR.TOC("matalg","L28G1-Ar7dB0.g");
AGR.TOC("matalg","L28G1-Ar9aB0.g");
AGR.TOC("matalg","L28G1-Ar9bB0.g");
AGR.TOC("matalg","L28G1-Ar9cB0.g");
AGR.TOC("maxes","L28G1-max1W1");
AGR.TOC("maxes","L28G1-max2W1");
AGR.TOC("maxes","L28G1-max3W1");
AGR.TOC("classes","L28G1-cclsW1");
AGR.TOC("cyclic","L28G1-cycW1");
AGR.TOC("cyc2ccl","L28G1cycW1-cclsW1");
AGR.TOC("check","L28G1-check1");

# L28d3
AGR.GRP("lin","L28","L28d3");
AGR.TOC("perm","L28d3G1-p9B0.m",2);
AGR.TOC("perm","L28d3G1-p28B0.m",2);
AGR.TOC("perm","L28d3G1-p36B0.m",2);
AGR.TOC("matff","L28d3G1-f2r6B0.m",2);
AGR.TOC("matff","L28d3G1-f2r8B0.m",2);
AGR.TOC("matff","L28d3G1-f2r12B0.m",2);
AGR.TOC("matff","L28d3G1-f3r7B0.m",2);
AGR.TOC("matff","L28d3G1-f3r27B0.m",2);
AGR.TOC("matff","L28d3G1-f7r7B0.m",2);
AGR.TOC("matff","L28d3G1-f7r8B0.m",2);
AGR.TOC("matff","L28d3G1-f7r21B0.m",2);
AGR.TOC("matint","L28d3G1-Zr7B0.g");
AGR.TOC("matint","L28d3G1-Zr8B0.g");
AGR.TOC("matint","L28d3G1-Zr21B0.g");
AGR.TOC("matint","L28d3G1-Zr27B0.g");
AGR.TOC("classes","L28d3G1-cclsW1");
AGR.TOC("cyclic","L28d3G1-cycW1");
AGR.TOC("cyc2ccl","L28d3G1cycW1-cclsW1");

# 2L283
AGR.GRP("lin","L283","2L283");
AGR.TOC("matalg","2L283G1-Ar84aB0.g");

# L283
AGR.GRP("lin","L283","L283");
AGR.TOC("matint","L283G1-Zr83B0.g");
AGR.TOC("matalg","L283G1-Ar84aB0.g");
AGR.TOC("maxes","L283G1-max1W1");
AGR.TOC("maxes","L283G1-max2W1");
AGR.TOC("maxes","L283G1-max3W1");
AGR.TOC("maxes","L283G1-max4W1");
AGR.TOC("out","L283G1-a2W1");

# 2L289
AGR.GRP("lin","L289","2L289");
AGR.TOC("matalg","2L289G1-Ar90aB0.g");

# L289
AGR.GRP("lin","L289","L289");
AGR.TOC("matint","L289G1-Zr89B0.g");
AGR.TOC("matalg","L289G1-Ar90aB0.g");
AGR.TOC("maxes","L289G1-max1W1");
AGR.TOC("maxes","L289G1-max2W1");
AGR.TOC("maxes","L289G1-max3W1");
AGR.TOC("maxes","L289G1-max4W1");
AGR.TOC("maxes","L289G1-max5W1");
AGR.TOC("maxes","L289G1-max6W1");
AGR.TOC("maxes","L289G1-max7W1");
AGR.TOC("out","L289G1-a2W1");

# 2L297
AGR.GRP("lin","L297","2L297");
AGR.TOC("matalg","2L297G1-Ar98aB0.g");

# L297
AGR.GRP("lin","L297","L297");
AGR.TOC("matint","L297G1-Zr97B0.g");
AGR.TOC("matalg","L297G1-Ar98aB0.g");
AGR.TOC("maxes","L297G1-max1W1");
AGR.TOC("maxes","L297G1-max2W1");
AGR.TOC("maxes","L297G1-max3W1");
AGR.TOC("maxes","L297G1-max4W1");
AGR.TOC("maxes","L297G1-max5W1");
AGR.TOC("out","L297G1-a2W1");

# L311
AGR.GRP("lin","L311","L311");
AGR.TOC("perm","L311G1-p133B0.m",2);
AGR.TOC("matff","L311G1-f2r132B0.m",2);
AGR.TOC("matff","L311G1-f3r132B0.m",2);
AGR.TOC("matff","L311G1-f5r132B0.m",2);
AGR.TOC("matff","L311G1-f7r131B0.m",2);
AGR.TOC("matff","L311G1-f11r3aB0.m",2);
AGR.TOC("matff","L311G1-f19r131B0.m",2);
AGR.TOC("matint","L311G1-Zr132B0.g");
AGR.TOC("matint","L311G1-Zr133aB0.g");
AGR.TOC("matint","L311G1-Zr532aB0.g");
AGR.TOC("matint","L311G1-Zr532bB0.g");
AGR.TOC("matalg","L311G1-Ar133bB0.g");
AGR.TOC("matalg","L311G1-Ar133cB0.g");
AGR.TOC("matalg","L311G1-Ar133dB0.g");
AGR.TOC("matalg","L311G1-Ar133eB0.g");
AGR.TOC("matalg","L311G1-Ar133fB0.g");
AGR.TOC("matalg","L311G1-Ar133gB0.g");
AGR.TOC("matalg","L311G1-Ar133hB0.g");
AGR.TOC("matalg","L311G1-Ar133iB0.g");
AGR.TOC("check","L311G1-check1");

# L313
AGR.GRP("lin","L313","L313");
AGR.TOC("perm","L313G1-p183aB0.m",2);
AGR.TOC("perm","L313G1-p183bB0.m",2);
AGR.TOC("matint","L313G1-Zr182B0.g");
AGR.TOC("matint","L313G1-Zr183aB0.g");
AGR.TOC("matint","L313G1-Zr366B0.g");
AGR.TOC("matalg","L313G1-Ar183bB0.g");
AGR.TOC("matalg","L313G1-Ar183cB0.g");
AGR.TOC("check","L313G1-check1");

# L33
AGR.GRP("lin","L33","L33");
AGR.TOC("perm","L33G1-p13aB0.m",2);
AGR.TOC("perm","L33G1-p13bB0.m",2);
AGR.TOC("perm","L33G1-p144B0.m",2);
AGR.TOC("perm","L33G1-p234B0.m",2);
AGR.TOC("matff","L33G1-f2r12B0.m",2);
AGR.TOC("matff","L33G1-f2r26B0.m",2);
AGR.TOC("matff","L33G1-f3r3aB0.m",2);
AGR.TOC("matff","L33G1-f3r3bB0.m",2);
AGR.TOC("matff","L33G1-f3r6aB0.m",2);
AGR.TOC("matff","L33G1-f3r6bB0.m",2);
AGR.TOC("matff","L33G1-f3r7B0.m",2);
AGR.TOC("matff","L33G1-f3r15aB0.m",2);
AGR.TOC("matff","L33G1-f3r15bB0.m",2);
AGR.TOC("matff","L33G1-f3r27B0.m",2);
AGR.TOC("matff","L33G1-f13r11B0.m",2);
AGR.TOC("matff","L33G1-f13r13B0.m",2);
AGR.TOC("matff","L33G1-f13r16B0.m",2);
AGR.TOC("matff","L33G1-f13r26aB0.m",2);
AGR.TOC("matff","L33G1-f13r39B0.m",2);
AGR.TOC("matff","L33G1-f16r16aB0.m",2);
AGR.TOC("matff","L33G1-f169r26bB0.m",2);
AGR.TOC("matff","L33G1-f169r26cB0.m",2);
AGR.TOC("matint","L33G1-Zr12B0.g");
AGR.TOC("matint","L33G1-Zr13B0.g");
AGR.TOC("matint","L33G1-Zr26aB0.g");
AGR.TOC("matint","L33G1-Zr27B0.g");
AGR.TOC("matint","L33G1-Zr39B0.g");
AGR.TOC("matint","L33G1-Zr52B0.g");
AGR.TOC("matint","L33G1-Zr64B0.g");
AGR.TOC("matalg","L33G1-Ar26bB0.g");
AGR.TOC("matalg","L33G1-Ar26cB0.g");
AGR.TOC("check","L33G1-check1");

# L33d2
AGR.GRP("lin","L33","L33d2");
AGR.TOC("perm","L33d2G1-p26B0.m",2);
AGR.TOC("perm","L33d2G1-p52B0.m",2);
AGR.TOC("perm","L33d2G1-p117B0.m",2);
AGR.TOC("perm","L33d2G1-p144B0.m",2);
AGR.TOC("perm","L33d2G1-p234B0.m",2);
AGR.TOC("matff","L33d2G1-f2r12B0.m",2);
AGR.TOC("matff","L33d2G1-f2r26B0.m",2);
AGR.TOC("matff","L33d2G1-f3r6B0.m",2);
AGR.TOC("matff","L33d2G1-f3r7aB0.m",2);
AGR.TOC("matff","L33d2G1-f3r12B0.m",2);
AGR.TOC("matff","L33d2G1-f3r27aB0.m",2);
AGR.TOC("matff","L33d2G1-f3r30B0.m",2);
AGR.TOC("matff","L33d2G1-f4r32aB0.m",2);
AGR.TOC("matff","L33d2G1-f4r32bB0.m",2);
AGR.TOC("matff","L33d2G1-f13r11a1B0.m",2);
AGR.TOC("matff","L33d2G1-f13r13a1B0.m",2);
AGR.TOC("matff","L33d2G1-f13r16a1B0.m",2);
AGR.TOC("matff","L33d2G1-f13r26a1B0.m",2);
AGR.TOC("matff","L33d2G1-f13r39a1B0.m",2);
AGR.TOC("matff","L33d2G1-f13r52B0.m",2);

# 12aL34
AGR.GRP("lin","L34","12aL34");
AGR.TOC("perm","12aL34G1-p1440B0.m",2);

# 12aL34d2a
AGR.GRP("lin","L34","12aL34d2a");
AGR.TOC("matff","12aL34d2aG1-f7r48aB0.m",2);
AGR.TOC("matff","12aL34d2aG1-f7r96aB0.m",2);
AGR.TOC("matff","12aL34d2aG1-f7r96bB0.m",2);
AGR.TOC("matff","12aL34d2aG1-f25r48aB0.m",2);
AGR.TOC("matff","12aL34d2aG1-f25r48bB0.m",2);
AGR.TOC("matff","12aL34d2aG1-f25r240aB0.m",2);

# 12bL34
AGR.GRP("lin","L34","12bL34");
AGR.TOC("perm","12bL34G1-p1440B0.m",2);
AGR.TOC("matff","12bL34G1-f49r12aB0.m",2);
AGR.TOC("matff","12bL34G1-f49r36aB0.m",2);
AGR.TOC("matff","12bL34G1-f49r48aB0.m",2);
AGR.TOC("matff","12bL34G1-f49r84aB0.m",2);

# 12bL34d2a
AGR.GRP("lin","L34","12bL34d2a");
AGR.TOC("matff","12bL34d2aG1-f7r24aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f7r72aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f7r96aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f7r168aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f25r72aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f25r96aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f25r120aB0.m",2);
AGR.TOC("matff","12bL34d2aG1-f25r120bB0.m",2);

# 2L34
AGR.GRP("lin","L34","2L34");
AGR.TOC("perm","2L34G1-p112aB0.m",2);
AGR.TOC("perm","2L34G1-p112bB0.m",2);
AGR.TOC("perm","2L34G1-p112cB0.m",2);
AGR.TOC("perm","2L34G1-p240aB0.m",2);
AGR.TOC("perm","2L34G1-p240bB0.m",2);
AGR.TOC("perm","2L34G1-p240cB0.m",2);
AGR.TOC("matff","2L34G1-f3r6B0.m",2);
AGR.TOC("matff","2L34G1-f3r20B0.m",2);
AGR.TOC("matff","2L34G1-f3r36B0.m",2);
AGR.TOC("matff","2L34G1-f3r44B0.m",2);
AGR.TOC("matff","2L34G1-f3r90B0.m",2);
AGR.TOC("matff","2L34G1-f5r20B0.m",2);
AGR.TOC("matff","2L34G1-f5r28B0.m",2);
AGR.TOC("matff","2L34G1-f5r36B0.m",2);
AGR.TOC("matff","2L34G1-f5r70B0.m",2);
AGR.TOC("matff","2L34G1-f5r90B0.m",2);
AGR.TOC("matff","2L34G1-f7r10B0.m",2);
AGR.TOC("matff","2L34G1-f7r26B0.m",2);
AGR.TOC("matff","2L34G1-f7r56B0.m",2);
AGR.TOC("matff","2L34G1-f7r64B0.m",2);
AGR.TOC("matff","2L34G1-f7r70B0.m",2);
AGR.TOC("matff","2L34G1-f9r10aB0.m",2);
AGR.TOC("matff","2L34G1-f9r10bB0.m",2);
AGR.TOC("matff","2L34G1-f9r22aB0.m",2);
AGR.TOC("matff","2L34G1-f9r22bB0.m",2);
AGR.TOC("matff","2L34G1-f25r10aB0.m",2);
AGR.TOC("matff","2L34G1-f25r10bB0.m",2);
AGR.TOC("matff","2L34G1-f49r28aB0.m",2);
AGR.TOC("matff","2L34G1-f49r28bB0.m",2);

# 2L34d2a
AGR.GRP("lin","L34","2L34d2a");
AGR.TOC("matff","2L34d2aG1-f3r20aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f3r36aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f3r44aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f5r20aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f5r28aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f5r36aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f7r10aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f7r26aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f7r56aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f7r64aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f7r70aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f9r6aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f9r90aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f25r70aB0.m",2);
AGR.TOC("matff","2L34d2aG1-f25r90aB0.m",2);

# 3L34
AGR.GRP("lin","L34","3L34");
AGR.TOC("perm","3L34G1-p63aB0.m",2);
AGR.TOC("perm","3L34G1-p63bB0.m",2);
AGR.TOC("perm","3L34G1-p360aB0.m",2);
AGR.TOC("perm","3L34G1-p360bB0.m",2);
AGR.TOC("perm","3L34G1-p360cB0.m",2);
AGR.TOC("matff","3L34G1-f2r6aB0.m",2);
AGR.TOC("matff","3L34G1-f2r6bB0.m",2);
AGR.TOC("matff","3L34G1-f2r18B0.m",2);
AGR.TOC("matff","3L34G1-f2r48aB0.m",2);
AGR.TOC("matff","3L34G1-f2r48bB0.m",2);
AGR.TOC("matff","3L34G1-f4r3aB0.m",2);
AGR.TOC("matff","3L34G1-f4r3bB0.m",2);
AGR.TOC("matff","3L34G1-f4r9aB0.m",2);
AGR.TOC("matff","3L34G1-f4r24aB0.m",2);
AGR.TOC("matff","3L34G1-f4r24bB0.m",2);
AGR.TOC("matff","3L34G1-f5r42B0.m",2);
AGR.TOC("matff","3L34G1-f7r15aB0.m",2);
AGR.TOC("matff","3L34G1-f7r15bB0.m",2);
AGR.TOC("matff","3L34G1-f7r15cB0.m",2);
AGR.TOC("matff","3L34G1-f7r21aB0.m",2);
AGR.TOC("matff","3L34G1-f7r84aB0.m",2);
AGR.TOC("matff","3L34G1-f7r126aB0.m",2);
AGR.TOC("matff","3L34G1-f25r21aB0.m",2);
AGR.TOC("matff","3L34G1-f49r63aB0.m",2);
AGR.TOC("matff","3L34G1-f49r63bB0.m",2);

# 3L34d2a
AGR.GRP("lin","L34","3L34d2a");
AGR.TOC("matff","3L34d2aG1-f4r6aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f4r9aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f4r48aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f7r15aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f7r15bB0.m",2);
AGR.TOC("matff","3L34d2aG1-f7r15cB0.m",2);
AGR.TOC("matff","3L34d2aG1-f7r21aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f7r126aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f25r15aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f25r15bB0.m",2);
AGR.TOC("matff","3L34d2aG1-f25r15cB0.m",2);
AGR.TOC("matff","3L34d2aG1-f25r21aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f25r63aB0.m",2);
AGR.TOC("matff","3L34d2aG1-f25r90aB0.m",2);

# 4aL34
AGR.GRP("lin","L34","4aL34");
AGR.TOC("perm","4aL34G1-p224B0.m",2);
AGR.TOC("perm","4aL34G1-p480B0.m",2);

# 4aL34d2a
AGR.GRP("lin","L34","4aL34d2a");
AGR.TOC("matff","4aL34d2aG1-f3r16aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f3r16bB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f3r48aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f3r48bB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f3r80aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f5r16aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f5r112aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f7r16aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f7r16bB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f7r112aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f7r128aB0.m",2);
AGR.TOC("matff","4aL34d2aG1-f25r160aB0.m",2);

# 4bL34
AGR.GRP("lin","L34","4bL34");
AGR.TOC("perm","4bL34G1-p224B0.m",2);
AGR.TOC("perm","4bL34G1-p480B0.m",2);
AGR.TOC("matff","4bL34G1-f3r8B0.m",2);
AGR.TOC("matff","4bL34G1-f3r32B0.m",2);
AGR.TOC("matff","4bL34G1-f3r56aB0.m",2);
AGR.TOC("matff","4bL34G1-f3r56bB0.m",2);
AGR.TOC("matff","4bL34G1-f3r72B0.m",2);
AGR.TOC("matff","4bL34G1-f3r120B0.m",2);
AGR.TOC("matff","4bL34G1-f5r20aB0.m",2);
AGR.TOC("matff","4bL34G1-f5r28aB0.m",2);
AGR.TOC("matff","4bL34G1-f5r36aB0.m",2);
AGR.TOC("matff","4bL34G1-f5r160aB0.m",2);
AGR.TOC("matff","4bL34G1-f7r40B0.m",2);
AGR.TOC("matff","4bL34G1-f7r56aB0.m",2);
AGR.TOC("matff","4bL34G1-f7r56bB0.m",2);
AGR.TOC("matff","4bL34G1-f7r72B0.m",2);
AGR.TOC("matff","4bL34G1-f7r88B0.m",2);
AGR.TOC("matff","4bL34G1-f9r4aB0.m",2);
AGR.TOC("matff","4bL34G1-f9r16aB0.m",2);
AGR.TOC("matff","4bL34G1-f9r28aB0.m",2);
AGR.TOC("matff","4bL34G1-f9r28bB0.m",2);
AGR.TOC("matff","4bL34G1-f9r36aB0.m",2);
AGR.TOC("matff","4bL34G1-f9r60aB0.m",2);
AGR.TOC("matff","4bL34G1-f25r80aB0.m",2);
AGR.TOC("matff","4bL34G1-f25r80bB0.m",2);
AGR.TOC("matff","4bL34G1-f49r20aB0.m",2);
AGR.TOC("matff","4bL34G1-f49r28aB0.m",2);
AGR.TOC("matff","4bL34G1-f49r28bB0.m",2);
AGR.TOC("matff","4bL34G1-f49r36aB0.m",2);
AGR.TOC("matff","4bL34G1-f49r44aB0.m",2);

# 4bL34d2a
AGR.GRP("lin","L34","4bL34d2a");
AGR.TOC("matff","4bL34d2aG1-f3r8aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f3r32aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f3r56aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f3r56bB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f3r72aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f3r120aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f5r40aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f5r56aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f5r72aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f7r40aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f7r56aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f7r56bB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f7r72aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f7r88aB0.m",2);
AGR.TOC("matff","4bL34d2aG1-f25r160aB0.m",2);

# 6L34
AGR.GRP("lin","L34","6L34");
AGR.TOC("perm","6L34G1-p720aB0.m",2);
AGR.TOC("perm","6L34G1-p720bB0.m",2);
AGR.TOC("perm","6L34G1-p720cB0.m",2);
AGR.TOC("matalg","6L34G1-Ar6aB0.g");

# 6L34d2a
AGR.GRP("lin","L34","6L34d2a");
AGR.TOC("matff","6L34d2aG1-f7r6aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f7r36aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f7r54aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f7r84aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f25r6aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f25r36aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f25r90aB0.m",2);
AGR.TOC("matff","6L34d2aG1-f25r120aB0.m",2);

# L34
AGR.GRP("lin","L34","L34");
AGR.TOC("perm","L34G1-p21aB0.m",2);
AGR.TOC("perm","L34G1-p21bB0.m",2);
AGR.TOC("perm","L34G1-p56aB0.m",2);
AGR.TOC("perm","L34G1-p56bB0.m",2);
AGR.TOC("perm","L34G1-p56cB0.m",2);
AGR.TOC("perm","L34G1-p120aB0.m",2);
AGR.TOC("perm","L34G1-p120bB0.m",2);
AGR.TOC("perm","L34G1-p120cB0.m",2);
AGR.TOC("perm","L34G1-p280B0.m",2);
AGR.TOC("matff","L34G1-f2r9aB0.m",2);
AGR.TOC("matff","L34G1-f2r9bB0.m",2);
AGR.TOC("matff","L34G1-f2r16B0.m",2);
AGR.TOC("matff","L34G1-f2r64B0.m",2);
AGR.TOC("matff","L34G1-f3r15aB0.m",2);
AGR.TOC("matff","L34G1-f3r15bB0.m",2);
AGR.TOC("matff","L34G1-f3r15cB0.m",2);
AGR.TOC("matff","L34G1-f3r19B0.m",2);
AGR.TOC("matff","L34G1-f3r90B0.m",2);
AGR.TOC("matff","L34G1-f3r126B0.m",2);
AGR.TOC("matff","L34G1-f4r8aB0.m",2);
AGR.TOC("matff","L34G1-f4r8bB0.m",2);
AGR.TOC("matff","L34G1-f5r20B0.m",2);
AGR.TOC("matff","L34G1-f5r35aB0.m",2);
AGR.TOC("matff","L34G1-f5r35bB0.m",2);
AGR.TOC("matff","L34G1-f5r35cB0.m",2);
AGR.TOC("matff","L34G1-f5r63B0.m",2);
AGR.TOC("matff","L34G1-f5r90B0.m",2);
AGR.TOC("matff","L34G1-f7r19B0.m",2);
AGR.TOC("matff","L34G1-f7r35aB0.m",2);
AGR.TOC("matff","L34G1-f7r35bB0.m",2);
AGR.TOC("matff","L34G1-f7r35cB0.m",2);
AGR.TOC("matff","L34G1-f7r45B0.m",2);
AGR.TOC("matff","L34G1-f7r126B0.m",2);
AGR.TOC("matff","L34G1-f9r45aB0.m",2);
AGR.TOC("matff","L34G1-f9r45bB0.m",2);
AGR.TOC("matff","L34G1-f9r63aB0.m",2);
AGR.TOC("matff","L34G1-f9r63bB0.m",2);
AGR.TOC("matff","L34G1-f25r45aB0.m",2);
AGR.TOC("matff","L34G1-f25r45bB0.m",2);
AGR.TOC("matff","L34G1-f49r63aB0.m",2);
AGR.TOC("matff","L34G1-f49r63bB0.m",2);
AGR.TOC("matint","L34G1-Zr20B0.g");
AGR.TOC("matint","L34G1-Zr35aB0.g");
AGR.TOC("matint","L34G1-Zr35bB0.g");
AGR.TOC("matint","L34G1-Zr35cB0.g");
AGR.TOC("matint","L34G1-Zr64B0.g");
AGR.TOC("matalg","L34G1-Ar63aB0.g");
AGR.TOC("matalg","L34G1-Ar63bB0.g");
AGR.TOC("maxes","L34G1-max1W1");
AGR.TOC("maxes","L34G1-max2W1");
AGR.TOC("maxes","L34G1-max3W1");
AGR.TOC("maxes","L34G1-max6W1");
AGR.TOC("maxes","L34G1-max7W1");
AGR.TOC("maxes","L34G1-max8W1");
AGR.TOC("maxes","L34G1-max9W1");
AGR.TOC("maxstd","L34G1max6W1-L27G1W1");
AGR.TOC("maxstd","L34G1max7W1-L27G1W1");
AGR.TOC("maxstd","L34G1max8W1-L27G1W1");
AGR.TOC("check","L34G1-check1");
AGR.TOC("pres","L34G1-P1");

# L34d2a
AGR.GRP("lin","L34","L34d2a");
AGR.TOC("matff","L34d2aG1-f2r16aB0.m",2);
AGR.TOC("matff","L34d2aG1-f2r18aB0.m",2);
AGR.TOC("matff","L34d2aG1-f2r64aB0.m",2);
AGR.TOC("matff","L34d2aG1-f3r15aB0.m",2);
AGR.TOC("matff","L34d2aG1-f3r15bB0.m",2);
AGR.TOC("matff","L34d2aG1-f3r15cB0.m",2);
AGR.TOC("matff","L34d2aG1-f3r19aB0.m",2);
AGR.TOC("matff","L34d2aG1-f3r90aB0.m",2);
AGR.TOC("matff","L34d2aG1-f3r126aB0.m",2);
AGR.TOC("matff","L34d2aG1-f5r20aB0.m",2);
AGR.TOC("matff","L34d2aG1-f5r35aB0.m",2);
AGR.TOC("matff","L34d2aG1-f5r35bB0.m",2);
AGR.TOC("matff","L34d2aG1-f5r35cB0.m",2);
AGR.TOC("matff","L34d2aG1-f5r63aB0.m",2);
AGR.TOC("matff","L34d2aG1-f5r90aB0.m",2);
AGR.TOC("matff","L34d2aG1-f7r19aB0.m",2);
AGR.TOC("matff","L34d2aG1-f7r35aB0.m",2);
AGR.TOC("matff","L34d2aG1-f7r35bB0.m",2);
AGR.TOC("matff","L34d2aG1-f7r35cB0.m",2);
AGR.TOC("matff","L34d2aG1-f7r45aB0.m",2);
AGR.TOC("matff","L34d2aG1-f7r126aB0.m",2);
AGR.TOC("cyclic","L34d2aG1-cycW1");

# L35
AGR.GRP("lin","L35","L35");
AGR.TOC("perm","L35G1-p31aB0.m",2);
AGR.TOC("perm","L35G1-p31bB0.m",2);
AGR.TOC("matff","L35G1-f5r3aB0.m",2);
AGR.TOC("matff","L35G1-f5r3bB0.m",2);
AGR.TOC("matff","L35G1-f5r8B0.m",2);
AGR.TOC("matint","L35G1-Zr30B0.g");
AGR.TOC("matint","L35G1-Zr31aB0.g");
AGR.TOC("matint","L35G1-Zr124aB0.g");
AGR.TOC("matint","L35G1-Zr124bB0.g");
AGR.TOC("matint","L35G1-Zr125B0.g");
AGR.TOC("matint","L35G1-Zr155aB0.g");
AGR.TOC("matint","L35G1-Zr186B0.g");
AGR.TOC("matalg","L35G1-Ar31bB0.g");
AGR.TOC("matalg","L35G1-Ar31cB0.g");
AGR.TOC("matalg","L35G1-Ar124cB0.g");
AGR.TOC("matalg","L35G1-Ar124dB0.g");
AGR.TOC("matalg","L35G1-Ar124eB0.g");
AGR.TOC("matalg","L35G1-Ar124fB0.g");
AGR.TOC("matalg","L35G1-Ar124gB0.g");
AGR.TOC("matalg","L35G1-Ar124hB0.g");
AGR.TOC("matalg","L35G1-Ar124iB0.g");
AGR.TOC("matalg","L35G1-Ar124jB0.g");
AGR.TOC("matalg","L35G1-Ar155bB0.g");
AGR.TOC("matalg","L35G1-Ar155cB0.g");
AGR.TOC("switch","L35G1-G2W1");
AGR.TOC("switch","L35G2-G1W1");
AGR.TOC("check","L35G1-check1");
AGR.TOC("pres","L35G1-P1");
AGR.TOC("pres","L35G2-P1");

# L35d2
AGR.GRP("lin","L35","L35d2");
AGR.TOC("perm","L35d2G1-p62B0.m",2);
AGR.TOC("perm","L35d2G1-p186B0.m",2);
AGR.TOC("perm","L35d2G1-p775B0.m",2);
AGR.TOC("perm","L35d2G1-p3100B0.m",2);
AGR.TOC("perm","L35d2G1-p3875B0.m",2);
AGR.TOC("perm","L35d2G1-p4000B0.m",2);
AGR.TOC("matff","L35d2G1-f5r6B0.m",2);
AGR.TOC("matff","L35d2G1-f5r8B0.m",2);
AGR.TOC("maxes","L35d2G1-max1W1");
AGR.TOC("maxes","L35d2G1-max2W1");
AGR.TOC("maxes","L35d2G1-max3W1");
AGR.TOC("maxes","L35d2G1-max4W1");
AGR.TOC("maxes","L35d2G1-max5W1");
AGR.TOC("maxes","L35d2G1-max6W1");
AGR.TOC("pres","L35d2G1-P1");

# 3L37
AGR.GRP("lin","L37","3L37");
AGR.TOC("matff","3L37G1-f7r3B0.m",2);

# 3L37d2
AGR.GRP("lin","L37","3L37d2");
AGR.TOC("matff","3L37d2G1-f7r6B0.m",2);

# L37
AGR.GRP("lin","L37","L37");
AGR.TOC("perm","L37G1-p57B0.m",2);
AGR.TOC("matff","L37G1-f2r152aB0.m",2);
AGR.TOC("matff","L37G1-f3r55B0.m",2);
AGR.TOC("matff","L37G1-f3r57B0.m",2);
AGR.TOC("matff","L37G1-f3r96aB0.m",2);
AGR.TOC("matff","L37G1-f3r96bB0.m",2);
AGR.TOC("matff","L37G1-f3r96cB0.m",2);
AGR.TOC("matff","L37G1-f3r342aB0.m",2);
AGR.TOC("matff","L37G1-f3r399B0.m",2);
AGR.TOC("matff","L37G1-f7r8B0.m",2);
AGR.TOC("matff","L37G1-f7r10aB0.m",2);
AGR.TOC("matff","L37G1-f7r10bB0.m",2);
AGR.TOC("matff","L37G1-f7r27B0.m",2);
AGR.TOC("matint","L37G1-Zr56B0.g");
AGR.TOC("matint","L37G1-Zr57B0.g");
AGR.TOC("matint","L37G1-Zr152aB0.g");
AGR.TOC("matint","L37G1-Zr152bB0.g");
AGR.TOC("matint","L37G1-Zr152cB0.g");
AGR.TOC("cyclic","L37G1-cycW1");
AGR.TOC("cyc2ccl","L37G1cycW1-cclsW1");
AGR.TOC("check","L37G1-check1");

# L37d2
AGR.GRP("lin","L37","L37d2");
AGR.TOC("matff","L37d2G1-f2r56B0.m",2);
AGR.TOC("matff","L37d2G1-f2r152B0.m",2);
AGR.TOC("matff","L37d2G1-f2r342B0.m",2);
AGR.TOC("matff","L37d2G1-f3r55B0.m",2);
AGR.TOC("matff","L37d2G1-f3r57B0.m",2);
AGR.TOC("matff","L37d2G1-f3r96B0.m",2);
AGR.TOC("matff","L37d2G1-f3r192B0.m",2);
AGR.TOC("matff","L37d2G1-f3r399B0.m",2);
AGR.TOC("matff","L37d2G1-f7r8B0.m",2);
AGR.TOC("matff","L37d2G1-f7r20B0.m",2);
AGR.TOC("matff","L37d2G1-f7r27B0.m",2);
AGR.TOC("matff","L37d2G1-f7r37B0.m",2);
AGR.TOC("matff","L37d2G1-f7r56B0.m",2);
AGR.TOC("matff","L37d2G1-f7r70B0.m",2);
AGR.TOC("matff","L37d2G1-f7r308B0.m",2);
AGR.TOC("matff","L37d2G1-f7r343B0.m",2);
AGR.TOC("matff","L37d2G1-f9r342bB0.m",2);
AGR.TOC("matff","L37d2G1-f9r342cB0.m",2);
AGR.TOC("maxes","L37d2G1-max1W1");
AGR.TOC("maxes","L37d2G1-max2W1");
AGR.TOC("cyclic","L37d2G1-cycW1");
AGR.TOC("cyc2ccl","L37d2G1cycW1-cclsW1");

# L38
AGR.GRP("lin","L38","L38");
AGR.TOC("perm","L38G1-p73aB0.m",2);
AGR.TOC("perm","L38G1-p73bB0.m",2);
AGR.TOC("perm","L38G1-p56064B0.m",2);
AGR.TOC("perm","L38G1-p75264B0.m",2);
AGR.TOC("perm","L38G1-p98112B0.m",2);
AGR.TOC("matff","L38G1-f2r27B0.m",2);
AGR.TOC("matff","L38G1-f2r512B0.m",2);
AGR.TOC("matff","L38G1-f3r72B0.m",2);
AGR.TOC("matff","L38G1-f3r511B0.m",2);
AGR.TOC("matff","L38G1-f7r72B0.m",2);
AGR.TOC("matff","L38G1-f7r511B0.m",2);
AGR.TOC("matff","L38G1-f7r512B0.m",2);
AGR.TOC("matff","L38G1-f8r3B0.m",2);
AGR.TOC("matff","L38G1-f8r8B0.m",2);
AGR.TOC("matff","L38G1-f8r9aB0.m",2);
AGR.TOC("matff","L38G1-f8r9bB0.m",2);
AGR.TOC("matff","L38G1-f8r24aB0.m",2);
AGR.TOC("matff","L38G1-f8r24bB0.m",2);
AGR.TOC("matff","L38G1-f8r27B0.m",2);
AGR.TOC("matff","L38G1-f8r64B0.m",2);
AGR.TOC("matff","L38G1-f8r72aB0.m",2);
AGR.TOC("matff","L38G1-f8r72bB0.m",2);
AGR.TOC("matff","L38G1-f8r192B0.m",2);
AGR.TOC("matff","L38G1-f27r657B0.m",2);
AGR.TOC("matff","L38G1-f73r71B0.m",2);
AGR.TOC("matff","L38G1-f73r441B0.m",2);
AGR.TOC("matff","L38G1-f73r511aB0.m",2);
AGR.TOC("matff","L38G1-f73r511bB0.m",2);
AGR.TOC("matff","L38G1-f343r511B0.m",2);
AGR.TOC("matint","L38G1-Zr72B0.g");
AGR.TOC("matalg","L38G1-Ar73aB0.g");
AGR.TOC("matalg","L38G1-Ar73bB0.g");
AGR.TOC("matalg","L38G1-Ar73cB0.g");
AGR.TOC("matalg","L38G1-Ar73dB0.g");
AGR.TOC("matalg","L38G1-Ar73eB0.g");
AGR.TOC("matalg","L38G1-Ar73fB0.g");
AGR.TOC("maxes","L38G1-max1W1");
AGR.TOC("maxes","L38G1-max2W1");
AGR.TOC("maxes","L38G1-max3W1");
AGR.TOC("maxes","L38G1-max4W1");
AGR.TOC("maxes","L38G1-max5W1");
AGR.TOC("cyclic","L38G1-cycW1");
AGR.TOC("out","L38G1-a3W1");
AGR.TOC("out","L38G1-a6W1");
AGR.TOC("check","L38G1-check1");

# L38d2
AGR.GRP("lin","L38","L38d2");
AGR.TOC("perm","L38d2G1-p146B0.m",2);
AGR.TOC("perm","L38d2G1-p657B0.m",2);
AGR.TOC("perm","L38d2G1-p4672B0.m",2);
AGR.TOC("perm","L38d2G1-p56064B0.m",2);
AGR.TOC("perm","L38d2G1-p75264B0.m",2);
AGR.TOC("perm","L38d2G1-p98112B0.m",2);
AGR.TOC("matff","L38d2G1-f2r54B0.m",2);
AGR.TOC("matff","L38d2G1-f3r511B0.m",2);
AGR.TOC("matff","L38d2G1-f7r72B0.m",2);
AGR.TOC("matff","L38d2G1-f7r512B0.m",2);
AGR.TOC("matff","L38d2G1-f8r6B0.m",2);
AGR.TOC("matff","L38d2G1-f8r8B0.m",2);
AGR.TOC("matff","L38d2G1-f8r18aB0.m",2);
AGR.TOC("matff","L38d2G1-f8r18bB0.m",2);
AGR.TOC("matff","L38d2G1-f8r48aB0.m",2);
AGR.TOC("matff","L38d2G1-f8r48bB0.m",2);
AGR.TOC("matff","L38d2G1-f8r54B0.m",2);
AGR.TOC("matff","L38d2G1-f8r64B0.m",2);
AGR.TOC("matff","L38d2G1-f8r144aB0.m",2);
AGR.TOC("matff","L38d2G1-f8r144bB0.m",2);
AGR.TOC("matff","L38d2G1-f8r384B0.m",2);
AGR.TOC("matff","L38d2G1-f9r72B0.m",2);
AGR.TOC("matff","L38d2G1-f73r71B0.m",2);
AGR.TOC("matff","L38d2G1-f73r441B0.m",2);
AGR.TOC("matff","L38d2G1-f73r511aB0.m",2);
AGR.TOC("matff","L38d2G1-f73r511bB0.m",2);
AGR.TOC("maxes","L38d2G1-max1W1");
AGR.TOC("cyclic","L38d2G1-cycW1");

# L38d3
AGR.GRP("lin","L38","L38d3");
AGR.TOC("perm","L38d3G1-p73aB0.m",2);
AGR.TOC("perm","L38d3G1-p73bB0.m",2);
AGR.TOC("perm","L38d3G1-p219aB0.m",2);
AGR.TOC("perm","L38d3G1-p219bB0.m",2);
AGR.TOC("perm","L38d3G1-p56064B0.m",2);
AGR.TOC("perm","L38d3G1-p75264B0.m",2);
AGR.TOC("perm","L38d3G1-p98112B0.m",2);
AGR.TOC("matff","L38d3G1-f2r9B0.m",2);
AGR.TOC("matff","L38d3G1-f2r24B0.m",2);
AGR.TOC("matff","L38d3G1-f2r27aB0.m",2);
AGR.TOC("matff","L38d3G1-f2r27bB0.m",2);
AGR.TOC("matff","L38d3G1-f2r27cB0.m",2);
AGR.TOC("matff","L38d3G1-f2r72aB0.m",2);
AGR.TOC("matff","L38d3G1-f2r72bB0.m",2);
AGR.TOC("matff","L38d3G1-f2r81B0.m",2);
AGR.TOC("matff","L38d3G1-f2r192B0.m",2);
AGR.TOC("matff","L38d3G1-f2r216aB0.m",2);
AGR.TOC("matff","L38d3G1-f2r216bB0.m",2);
AGR.TOC("matff","L38d3G1-f2r576B0.m",2);
AGR.TOC("matff","L38d3G1-f3r72B0.m",2);
AGR.TOC("matff","L38d3G1-f3r511B0.m",2);
AGR.TOC("matff","L38d3G1-f7r72B0.m",2);
AGR.TOC("matff","L38d3G1-f7r511B0.m",2);
AGR.TOC("matff","L38d3G1-f7r512B0.m",2);
AGR.TOC("matff","L38d3G1-f73r71B0.m",2);
AGR.TOC("matff","L38d3G1-f73r441B0.m",2);
AGR.TOC("matff","L38d3G1-f73r511aB0.m",2);
AGR.TOC("maxes","L38d3G1-max1W1");
AGR.TOC("maxes","L38d3G1-max2W1");
AGR.TOC("maxes","L38d3G1-max3W1");
AGR.TOC("maxes","L38d3G1-max4W1");
AGR.TOC("maxes","L38d3G1-max5W1");
AGR.TOC("maxes","L38d3G1-max6W1");
AGR.TOC("cyclic","L38d3G1-cycW1");

# L38d6
AGR.GRP("lin","L38","L38d6");
AGR.TOC("perm","L38d6G1-p438B0.m",2);
AGR.TOC("perm","L38d6G1-p657B0.m",2);
AGR.TOC("perm","L38d6G1-p4672B0.m",2);
AGR.TOC("perm","L38d6G1-p56064B0.m",2);
AGR.TOC("perm","L38d6G1-p75264B0.m",2);
AGR.TOC("perm","L38d6G1-p98112B0.m",2);
AGR.TOC("matff","L38d6G1-f2r18B0.m",2);
AGR.TOC("matff","L38d6G1-f2r24B0.m",2);
AGR.TOC("matff","L38d6G1-f2r54aB0.m",2);
AGR.TOC("matff","L38d6G1-f2r54bB0.m",2);
AGR.TOC("matff","L38d6G1-f2r144aB0.m",2);
AGR.TOC("matff","L38d6G1-f2r144bB0.m",2);
AGR.TOC("matff","L38d6G1-f2r162B0.m",2);
AGR.TOC("matff","L38d6G1-f2r192B0.m",2);
AGR.TOC("matff","L38d6G1-f2r432aB0.m",2);
AGR.TOC("matff","L38d6G1-f2r432bB0.m",2);
AGR.TOC("matff","L38d6G1-f2r512B0.m",2);
AGR.TOC("matff","L38d6G1-f2r1152B0.m",2);
AGR.TOC("matff","L38d6G1-f3r511B0.m",2);
AGR.TOC("matff","L38d6G1-f7r72B0.m",2);
AGR.TOC("matff","L38d6G1-f7r511B0.m",2);
AGR.TOC("matff","L38d6G1-f7r512B0.m",2);
AGR.TOC("matff","L38d6G1-f9r72B0.m",2);
AGR.TOC("matff","L38d6G1-f73r71B0.m",2);
AGR.TOC("matff","L38d6G1-f73r441B0.m",2);
AGR.TOC("matff","L38d6G1-f73r511aB0.m",2);
AGR.TOC("maxes","L38d6G1-max1W1");
AGR.TOC("maxes","L38d6G1-max2W1");
AGR.TOC("maxes","L38d6G1-max3W1");
AGR.TOC("maxes","L38d6G1-max4W1");
AGR.TOC("maxes","L38d6G1-max5W1");
AGR.TOC("maxes","L38d6G1-max6W1");
AGR.TOC("maxes","L38d6G1-max7W1");
AGR.TOC("cyclic","L38d6G1-cycW1");

# L39
AGR.GRP("lin","L39","L39");
AGR.TOC("check","L39G1-check1");

# L43
AGR.GRP("lin","L43","L43");
AGR.TOC("matint","L43G1-Zr26aB0.g");
AGR.TOC("matint","L43G1-Zr26bB0.g");
AGR.TOC("matint","L43G1-Zr39B0.g");
AGR.TOC("matint","L43G1-Zr52B0.g");
AGR.TOC("matint","L43G1-Zr65aB0.g");
AGR.TOC("matint","L43G1-Zr65bB0.g");
AGR.TOC("matint","L43G1-Zr90B0.g");
AGR.TOC("matint","L43G1-Zr234aB0.g");
AGR.TOC("matint","L43G1-Zr234bB0.g");
AGR.TOC("check","L43G1-check1");

# L44
AGR.GRP("lin","L44","L44");
AGR.TOC("perm","L44G1-p85aB0.m",2);
AGR.TOC("perm","L44G1-p85bB0.m",2);
AGR.TOC("matint","L44G1-Zr84B0.g");
AGR.TOC("matint","L44G1-Zr378B0.g");
AGR.TOC("matalg","L44G1-Ar85aB0.g");
AGR.TOC("matalg","L44G1-Ar85bB0.g");
AGR.TOC("check","L44G1-check1");

# L45
AGR.GRP("lin","L45","L45");
AGR.TOC("perm","L45G1-p156aB0.m",2);
AGR.TOC("perm","L45G1-p156bB0.m",2);
AGR.TOC("matint","L45G1-Zr155B0.g");
AGR.TOC("check","L45G1-check1");

# L52
AGR.GRP("lin","L52","L52");
AGR.TOC("perm","L52G1-p31aB0.m",2);
AGR.TOC("perm","L52G1-p155aB0.m",2);
AGR.TOC("matff","L52G1-f2r5aB0.m",2);
AGR.TOC("matff","L52G1-f2r5bB0.m",2);
AGR.TOC("matff","L52G1-f2r10aB0.m",2);
AGR.TOC("matff","L52G1-f2r10bB0.m",2);
AGR.TOC("matff","L52G1-f2r24B0.m",2);
AGR.TOC("matff","L52G1-f3r30B0.m",2);
AGR.TOC("matff","L52G1-f3r124B0.m",2);
AGR.TOC("matff","L52G1-f3r155B0.m",2);
AGR.TOC("matff","L52G1-f5r30B0.m",2);
AGR.TOC("matff","L52G1-f5r123B0.m",2);
AGR.TOC("matff","L52G1-f5r155B0.m",2);
AGR.TOC("matff","L52G1-f5r280B0.m",2);
AGR.TOC("matff","L52G1-f7r30B0.m",2);
AGR.TOC("matff","L52G1-f7r94B0.m",2);
AGR.TOC("matff","L52G1-f7r280B0.m",2);
AGR.TOC("matff","L52G1-f31r29B0.m",2);
AGR.TOC("matff","L52G1-f31r251B0.m",2);
AGR.TOC("matint","L52G1-Zr30B0.g");
AGR.TOC("matint","L52G1-Zr124B0.g");
AGR.TOC("matint","L52G1-Zr155B0.g");
AGR.TOC("matint","L52G1-Zr217B0.g");
AGR.TOC("cyclic","L52G1-cycW1");
AGR.TOC("cyc2ccl","L52G1cycW1-cclsW1");
AGR.TOC("check","L52G1-check1");

# L52d2
AGR.GRP("lin","L52","L52d2");
AGR.TOC("perm","L52d2G1-p62B0.m",2);
AGR.TOC("matff","L52d2G1-f2r10B0.m",2);
AGR.TOC("matff","L52d2G1-f2r20B0.m",2);
AGR.TOC("matff","L52d2G1-f2r24B0.m",2);
AGR.TOC("matff","L52d2G1-f7r30aB0.m",2);
AGR.TOC("matff","L52d2G1-f9r30aB0.m",2);
AGR.TOC("matff","L52d2G1-f25r30aB0.m",2);
AGR.TOC("matff","L52d2G1-f31r29aB0.m",2);
AGR.TOC("matalg","L52d2G1-Ar30B0.g");
AGR.TOC("maxes","L52d2G1-max1W1");

# L53
AGR.GRP("lin","L53","L53");
AGR.TOC("check","L53G1-check1");

# L62
AGR.GRP("lin","L62","L62");
AGR.TOC("perm","L62G1-p63aB0.m",2);
AGR.TOC("matff","L62G1-f2r6aB0.m",2);
AGR.TOC("matff","L62G1-f2r6bB0.m",2);
AGR.TOC("matff","L62G1-f2r15aB0.m",2);
AGR.TOC("matff","L62G1-f2r15bB0.m",2);
AGR.TOC("matff","L62G1-f2r20B0.m",2);
AGR.TOC("matff","L62G1-f2r34B0.m",2);
AGR.TOC("matff","L62G1-f2r70aB0.m",2);
AGR.TOC("matff","L62G1-f2r84aB0.m",2);
AGR.TOC("matff","L62G1-f2r90aB0.m",2);
AGR.TOC("matff","L62G1-f2r154B0.m",2);
AGR.TOC("matff","L62G1-f2r204aB0.m",2);
AGR.TOC("matff","L62G1-f2r384aB0.m",2);
AGR.TOC("matff","L62G1-f2r400B0.m",2);
AGR.TOC("matff","L62G1-f2r720aB0.m",2);
AGR.TOC("matff","L62G1-f2r896aB0.m",2);
AGR.TOC("matff","L62G1-f2r924aB0.m",2);
AGR.TOC("matff","L62G1-f3r61B0.m",2);
AGR.TOC("matff","L62G1-f3r527aB0.m",2);
AGR.TOC("matff","L62G1-f3r651aB0.m",2);
AGR.TOC("matff","L62G1-f5r62B0.m",2);
AGR.TOC("matff","L62G1-f7r61B0.m",2);
AGR.TOC("matff","L62G1-f31r62B0.m",2);
AGR.TOC("matint","L62G1-Zr62B0.g");
AGR.TOC("matint","L62G1-Zr217B0.g");
AGR.TOC("check","L62G1-check1");

# L62d2
AGR.GRP("lin","L62","L62d2");
AGR.TOC("perm","L62d2G1-p126B0.m",2);
AGR.TOC("matff","L62d2G1-f2r12B0.m",2);
AGR.TOC("matff","L62d2G1-f2r20B0.m",2);
AGR.TOC("matff","L62d2G1-f2r30B0.m",2);
AGR.TOC("matff","L62d2G1-f2r34B0.m",2);
AGR.TOC("matff","L62d2G1-f2r140B0.m",2);
AGR.TOC("matff","L62d2G1-f2r154B0.m",2);
AGR.TOC("matff","L62d2G1-f2r168B0.m",2);
AGR.TOC("matff","L62d2G1-f2r180B0.m",2);
AGR.TOC("matff","L62d2G1-f2r400B0.m",2);
AGR.TOC("matff","L62d2G1-f2r408B0.m",2);
AGR.TOC("matff","L62d2G1-f2r768B0.m",2);
AGR.TOC("matff","L62d2G1-f3r61B0.m",2);
AGR.TOC("matff","L62d2G1-f7r61B0.m",2);

# L72
AGR.GRP("lin","L72","L72");
AGR.TOC("perm","L72G1-p127aB0.m",2);
AGR.TOC("perm","L72G1-p127bB0.m",2);
AGR.TOC("matff","L72G1-f2r7aB0.m",2);
AGR.TOC("matff","L72G1-f2r7bB0.m",2);
AGR.TOC("matff","L72G1-f2r21aB0.m",2);
AGR.TOC("matff","L72G1-f2r21bB0.m",2);
AGR.TOC("matff","L72G1-f2r35aB0.m",2);
AGR.TOC("matff","L72G1-f2r35bB0.m",2);
AGR.TOC("matff","L72G1-f2r48B0.m",2);
AGR.TOC("matff","L72G1-f2r112aB0.m",2);
AGR.TOC("matff","L72G1-f2r112bB0.m",2);
AGR.TOC("matff","L72G1-f2r133aB0.m",2);
AGR.TOC("matff","L72G1-f2r133bB0.m",2);
AGR.TOC("matff","L72G1-f2r175aB0.m",2);
AGR.TOC("matff","L72G1-f2r175bB0.m",2);
AGR.TOC("matff","L72G1-f2r224aB0.m",2);
AGR.TOC("matff","L72G1-f2r224bB0.m",2);
AGR.TOC("matff","L72G1-f2r392aB0.m",2);
AGR.TOC("matff","L72G1-f2r448aB0.m",2);
AGR.TOC("matff","L72G1-f2r448bB0.m",2);
AGR.TOC("matff","L72G1-f2r469aB0.m",2);
AGR.TOC("matff","L72G1-f2r469bB0.m",2);
AGR.TOC("matff","L72G1-f2r707aB0.m",2);
AGR.TOC("matff","L72G1-f2r707bB0.m",2);
AGR.TOC("matff","L72G1-f2r736aB0.m",2);
AGR.TOC("matint","L72G1-Zr126B0.g");
AGR.TOC("out","L72G1-aW1");
AGR.TOC("check","L72G1-check1");

# L72d2
AGR.GRP("lin","L72","L72d2");
AGR.TOC("perm","L72d2G2-p254B0.m",2);
AGR.TOC("matff","L72d2G2-f2r14B0.m",2);
AGR.TOC("matff","L72d2G2-f2r42B0.m",2);
AGR.TOC("matff","L72d2G2-f2r48B0.m",2);
AGR.TOC("matff","L72d2G2-f2r70B0.m",2);
AGR.TOC("matff","L72d2G2-f2r224B0.m",2);
AGR.TOC("matff","L72d2G2-f2r266B0.m",2);
AGR.TOC("matff","L72d2G2-f2r350B0.m",2);
AGR.TOC("matff","L72d2G2-f2r392B0.m",2);
AGR.TOC("matff","L72d2G2-f2r448B0.m",2);
AGR.TOC("matff","L72d2G2-f2r736B0.m",2);
AGR.TOC("matff","L72d2G2-f2r896B0.m",2);
AGR.TOC("matff","L72d2G2-f2r938B0.m",2);
AGR.TOC("maxes","L72d2G2-max1W1");

# 214U72
AGR.GRP("misc","214U72","214U72");
AGR.TOC("perm","214U72G1-p10836B0.m",2);
AGR.TOC("pres","214U72G1-P1");

# 24A8
AGR.GRP("misc","24A8","24A8");
AGR.TOC("perm","24A8G1-p30B0.m",2);
AGR.TOC("perm","24A8G1-p128B0.m",2);
AGR.TOC("matff","24A8G1-f2r11aB0.m",2);
AGR.TOC("matff","24A8G1-f2r11bB0.m",2);
AGR.TOC("matff","24A8G1-f3r15B0.m",2);
AGR.TOC("matff","24A8G1-f5r15B0.m",2);
AGR.TOC("matff","24A8G1-f7r15B0.m",2);
AGR.TOC("matint","24A8G1-Zr15B0.g");
AGR.TOC("pres","24A8G1-P1");

# 25L52
AGR.GRP("misc","25L52","25L52");
AGR.TOC("perm","25L52G1-p7440aB0.m",2);
AGR.TOC("perm","25L52G1-p7440bB0.m",2);
AGR.TOC("perm","25L52G1-p7440cB0.m",2);
AGR.TOC("matff","25L52G1-f2r69aB0.m",2);
AGR.TOC("matff","25L52G1-f3r248B0.m",2);
AGR.TOC("matff","25L52G1-f5r248B0.m",2);
AGR.TOC("matff","25L52G1-f7r248B0.m",2);
AGR.TOC("matff","25L52G1-f31r248B0.m",2);
AGR.TOC("matint","25L52G1-Zr248B0.g");
AGR.TOC("pres","25L52G1-P1");

# 53L35
AGR.GRP("misc","53L35","53L35");
AGR.TOC("perm","53L35G2-p3875aB0.m",2);
AGR.TOC("perm","53L35G2-p3875bB0.m",2);
AGR.TOC("perm","53L35G2-p4650B0.m",2);
AGR.TOC("matff","53L35G2-f2r620B0.m",2);
AGR.TOC("matff","53L35G2-f5r16aB0.m",2);
AGR.TOC("switch","53L35G2-G1W1");
AGR.TOC("pres","53L35G2-P1");

# 2aM20
AGR.GRP("misc","M20","2aM20");
AGR.TOC("perm","2aM20G1-p12aB0.m",2);
AGR.TOC("perm","2aM20G1-p12bB0.m",2);
AGR.TOC("perm","2aM20G1-p20aB0.m",2);
AGR.TOC("perm","2aM20G1-p20bB0.m",2);
AGR.TOC("matint","2aM20G1-Zr6aB0.g");
AGR.TOC("matint","2aM20G1-Zr6bB0.g");
AGR.TOC("matint","2aM20G1-Zr10aB0.g");
AGR.TOC("matint","2aM20G1-Zr10bB0.g");
AGR.TOC("matint","2aM20G1-Zr20B0.g");
AGR.TOC("matint","2aM20G1-Zr24B0.g");
AGR.TOC("matalg","2aM20G1-Ar12aB0.g");
AGR.TOC("matalg","2aM20G1-Ar12bB0.g");
AGR.TOC("matalg","2aM20G1-Ar12bB1.g");

# 2bM20
AGR.GRP("misc","M20","2bM20");
AGR.TOC("perm","2bM20G1-p120aB0.m",2);

# 2cM20
AGR.GRP("misc","M20","2cM20");
AGR.TOC("perm","2cM20G1-p24B0.m",2);

# 4bM20
AGR.GRP("misc","M20","4bM20");
AGR.TOC("matalg","4bM20G1-Ar4aB0.g");
AGR.TOC("matalg","4bM20G1-Ar4aB1.g");
AGR.TOC("matalg","4bM20G1-Ar20aB0.g");

# M20
AGR.GRP("misc","M20","M20");
AGR.TOC("perm","M20G1-p20aB0.m",2);
AGR.TOC("perm","M20G1-p20bB0.m",2);
AGR.TOC("perm","M20G1-p20cB0.m",2);
AGR.TOC("perm","M20G1-p20dB0.m",2);

# WF4
AGR.GRP("misc","WF4","WF4");
AGR.TOC("switch","WF4G1-G2W1");
AGR.TOC("switch","WF4G2-G1W1");

# B
AGR.GRP("spor","B","B");
AGR.TOC("matff","BG1-f2r4370B0.m",2);
AGR.TOC("matff","BG1-f3r4371B0.m",2);
AGR.TOC("matff","BG1-f5r4371B0.m",2);
AGR.TOC("maxes","BG1-max1W1");
AGR.TOC("maxes","BG1-max2W1");
AGR.TOC("maxes","BG1-max3W1");
AGR.TOC("maxes","BG1-max4W1");
AGR.TOC("maxes","BG1-max5W1");
AGR.TOC("maxes","BG1-max6W1");
AGR.TOC("maxes","BG1-max7W1");
AGR.TOC("maxes","BG1-max8W1");
AGR.TOC("maxes","BG1-max9W1");
AGR.TOC("maxes","BG1-max11W1");
AGR.TOC("maxes","BG1-max13W1");
AGR.TOC("maxes","BG1-max15W1");
AGR.TOC("maxes","BG1-max16W1");
AGR.TOC("maxes","BG1-max21W1");
AGR.TOC("maxes","BG1-max30W1");
AGR.TOC("cyclic","BG1-cycW1");
AGR.TOC("find","BG1-find1");
AGR.TOC("check","BG1-check1");

# 2Co1
AGR.GRP("spor","Co1","2Co1");
AGR.TOC("perm","2Co1G1-p196560B0.m",2);
AGR.TOC("matff","2Co1G1-f3r24B0.m",2);
AGR.TOC("matff","2Co1G1-f5r24B0.m",2);
AGR.TOC("matff","2Co1G1-f7r24B0.m",2);
AGR.TOC("matff","2Co1G1-f11r24B0.m",2);
AGR.TOC("matff","2Co1G1-f13r24B0.m",2);
AGR.TOC("matff","2Co1G1-f23r24B0.m",2);

# Co1
AGR.GRP("spor","Co1","Co1");
AGR.TOC("perm","Co1G1-p98280B0.m",2);
AGR.TOC("matff","Co1G1-f2r24B0.m",2);
AGR.TOC("matff","Co1G1-f2r274B0.m",2);
AGR.TOC("matff","Co1G1-f3r276B0.m",2);
AGR.TOC("matff","Co1G1-f3r298B0.m",2);
AGR.TOC("matff","Co1G1-f5r276B0.m",2);
AGR.TOC("matff","Co1G1-f5r299B0.m",2);
AGR.TOC("matff","Co1G1-f7r276B0.m",2);
AGR.TOC("matff","Co1G1-f7r299B0.m",2);
AGR.TOC("matff","Co1G1-f11r276B0.m",2);
AGR.TOC("matff","Co1G1-f11r299B0.m",2);
AGR.TOC("matff","Co1G1-f13r276B0.m",2);
AGR.TOC("matff","Co1G1-f13r299B0.m",2);
AGR.TOC("matff","Co1G1-f23r276B0.m",2);
AGR.TOC("matff","Co1G1-f23r299B0.m",2);
AGR.TOC("maxes","Co1G1-max1W1");
AGR.TOC("maxes","Co1G1-max2W1");
AGR.TOC("maxes","Co1G1-max3W1");
AGR.TOC("maxes","Co1G1-max4W1");
AGR.TOC("maxes","Co1G1-max5W1");
AGR.TOC("maxes","Co1G1-max6W1");
AGR.TOC("cyclic","Co1G1-cycW1");
AGR.TOC("find","Co1G1-find1");
AGR.TOC("check","Co1G1-check1");

# Co2
AGR.GRP("spor","Co2","Co2");
AGR.TOC("perm","Co2G1-p2300B0.m",2);
AGR.TOC("perm","Co2G1-p4600B0.m",2);
AGR.TOC("matff","Co2G1-f2r22B0.m",2);
AGR.TOC("matff","Co2G1-f2r24B0.m",2);
AGR.TOC("matff","Co2G1-f2r230B0.m",2);
AGR.TOC("matff","Co2G1-f2r748aB0.m",2);
AGR.TOC("matff","Co2G1-f2r748bB0.m",2);
AGR.TOC("matff","Co2G1-f3r23B0.m",2);
AGR.TOC("matff","Co2G1-f3r253B0.m",2);
AGR.TOC("matff","Co2G1-f3r275B0.m",2);
AGR.TOC("matff","Co2G1-f5r23B0.m",2);
AGR.TOC("matff","Co2G1-f5r253B0.m",2);
AGR.TOC("matff","Co2G1-f5r275B0.m",2);
AGR.TOC("matff","Co2G1-f7r23B0.m",2);
AGR.TOC("matff","Co2G1-f7r253B0.m",2);
AGR.TOC("matff","Co2G1-f7r275B0.m",2);
AGR.TOC("matff","Co2G1-f11r23B0.m",2);
AGR.TOC("matff","Co2G1-f11r253B0.m",2);
AGR.TOC("matff","Co2G1-f11r275B0.m",2);
AGR.TOC("matff","Co2G1-f23r23B0.m",2);
AGR.TOC("matff","Co2G1-f23r253B0.m",2);
AGR.TOC("matff","Co2G1-f23r274B0.m",2);
AGR.TOC("matint","Co2G1-Zr23B0.g");
AGR.TOC("maxes","Co2G1-max1W1");
AGR.TOC("maxes","Co2G1-max1W2");
AGR.TOC("maxes","Co2G1-max2W1");
AGR.TOC("maxes","Co2G1-max3W1");
AGR.TOC("maxes","Co2G1-max4W1");
AGR.TOC("maxes","Co2G1-max5W1");
AGR.TOC("maxes","Co2G1-max6W1");
AGR.TOC("maxes","Co2G1-max7W1");
AGR.TOC("maxes","Co2G1-max8W1");
AGR.TOC("maxes","Co2G1-max9W1");
AGR.TOC("maxes","Co2G1-max10W1");
AGR.TOC("maxes","Co2G1-max11W1");
AGR.TOC("cyclic","Co2G1-cycW1");
AGR.TOC("cyc2ccl","Co2G1cycW1-cclsW1");
AGR.TOC("find","Co2G1-find1");
AGR.TOC("check","Co2G1-check1");
AGR.TOC("pres","Co2G1-P1");

# Co3
AGR.GRP("spor","Co3","Co3");
AGR.TOC("perm","Co3G1-p276B0.m",2);
AGR.TOC("perm","Co3G1-p552B0.m",2);
AGR.TOC("perm","Co3G1-p11178B0.m",2);
AGR.TOC("perm","Co3G1-p37950B0.m",2);
AGR.TOC("perm","Co3G1-p48600B0.m",2);
AGR.TOC("perm","Co3G1-p128800B0.m",2);
AGR.TOC("matff","Co3G1-f2r22B0.m",2);
AGR.TOC("matff","Co3G1-f2r230B0.m",2);
AGR.TOC("matff","Co3G1-f3r22B0.m",2);
AGR.TOC("matff","Co3G1-f3r126aB0.m",2);
AGR.TOC("matff","Co3G1-f3r126bB0.m",2);
AGR.TOC("matff","Co3G1-f3r231aB0.m",2);
AGR.TOC("matff","Co3G1-f3r231bB0.m",2);
AGR.TOC("matff","Co3G1-f3r770aB0.m",2);
AGR.TOC("matff","Co3G1-f3r770bB0.m",2);
AGR.TOC("matff","Co3G1-f4r896aB0.m",2);
AGR.TOC("matff","Co3G1-f5r23B0.m",2);
AGR.TOC("matff","Co3G1-f5r230B0.m",2);
AGR.TOC("matff","Co3G1-f5r253B0.m",2);
AGR.TOC("matff","Co3G1-f5r275B0.m",2);
AGR.TOC("matff","Co3G1-f5r896bB0.m",2);
AGR.TOC("matff","Co3G1-f7r23B0.m",2);
AGR.TOC("matff","Co3G1-f7r253aB0.m",2);
AGR.TOC("matff","Co3G1-f7r253bB0.m",2);
AGR.TOC("matff","Co3G1-f7r275B0.m",2);
AGR.TOC("matff","Co3G1-f11r23B0.m",2);
AGR.TOC("matff","Co3G1-f11r253aB0.m",2);
AGR.TOC("matff","Co3G1-f11r253bB0.m",2);
AGR.TOC("matff","Co3G1-f11r275B0.m",2);
AGR.TOC("matff","Co3G1-f11r896B0.m",2);
AGR.TOC("matff","Co3G1-f23r23B0.m",2);
AGR.TOC("matff","Co3G1-f23r253aB0.m",2);
AGR.TOC("matff","Co3G1-f23r253bB0.m",2);
AGR.TOC("matff","Co3G1-f23r274B0.m",2);
AGR.TOC("matff","Co3G1-f23r896bB0.m",2);
AGR.TOC("matff","Co3G1-f49r896aB0.m",2);
AGR.TOC("matint","Co3G1-Zr23B0.g");
AGR.TOC("maxes","Co3G1-max1W1");
AGR.TOC("maxes","Co3G1-max2W1");
AGR.TOC("maxes","Co3G1-max3W1");
AGR.TOC("maxes","Co3G1-max4W1");
AGR.TOC("maxes","Co3G1-max5W1");
AGR.TOC("maxes","Co3G1-max6W1");
AGR.TOC("maxes","Co3G1-max7W1");
AGR.TOC("maxes","Co3G1-max8W1");
AGR.TOC("maxes","Co3G1-max9W1");
AGR.TOC("maxes","Co3G1-max10W1");
AGR.TOC("maxes","Co3G1-max11W1");
AGR.TOC("maxes","Co3G1-max12W1");
AGR.TOC("maxes","Co3G1-max12W2");
AGR.TOC("maxes","Co3G1-max13W1");
AGR.TOC("maxes","Co3G1-max14W1");
AGR.TOC("maxes","Co3G1-max14W2");
AGR.TOC("cyclic","Co3G1-cycW1");
AGR.TOC("cyc2ccl","Co3G1cycW1-cclsW1");
AGR.TOC("find","Co3G1-find1");
AGR.TOC("check","Co3G1-check1");

# 2F22
AGR.GRP("spor","F22","2F22");
AGR.TOC("perm","2F22G1-p28160B0.m",2);
AGR.TOC("perm","2F22G1-p123552B0.m",2);
AGR.TOC("matff","2F22G1-f3r176aB0.m",2);
AGR.TOC("matff","2F22G1-f5r352B0.m",2);
AGR.TOC("matff","2F22G1-f7r352B0.m",2);
AGR.TOC("matff","2F22G1-f11r352B0.m",2);
AGR.TOC("matff","2F22G1-f13r352B0.m",2);
AGR.TOC("pres","2F22G1-P1");

# 2F22d2
AGR.GRP("spor","F22","2F22d2");
AGR.TOC("perm","2F22d2G1-p56320B0.m",2);
AGR.TOC("matff","2F22d2G1-f3r352B0.m",2);

# 3F22
AGR.GRP("spor","F22","3F22");
AGR.TOC("perm","3F22G1-p185328B0.m",2);
AGR.TOC("matff","3F22G1-f4r27aB0.m",2);
AGR.TOC("matff","3F22G1-f7r351aB0.m",2);

# 3F22d2
AGR.GRP("spor","F22","3F22d2");
AGR.TOC("perm","3F22d2G1-p185328B0.m",2);
AGR.TOC("matff","3F22d2G1-f2r54B0.m",2);
AGR.TOC("matff","3F22d2G1-f7r702B0.m",2);
AGR.TOC("pres","3F22d2G1-P1");

# F22
AGR.GRP("spor","F22","F22");
AGR.TOC("perm","F22G1-p3510B0.m",2);
AGR.TOC("perm","F22G1-p14080bB0.m",2);
AGR.TOC("perm","F22G1-p61776B0.m",2);
AGR.TOC("perm","F22G1-p142155B0.m",2);
AGR.TOC("perm","F22G1-p694980B0.m",2);
AGR.TOC("matff","F22G1-f2r78B0.m",2);
AGR.TOC("matff","F22G1-f2r350B0.m",2);
AGR.TOC("matff","F22G1-f2r572B0.m",2);
AGR.TOC("matff","F22G1-f3r77B0.m",2);
AGR.TOC("matff","F22G1-f3r351B0.m",2);
AGR.TOC("matff","F22G1-f3r924B0.m",2);
AGR.TOC("matff","F22G1-f5r78B0.m",2);
AGR.TOC("matff","F22G1-f5r428B0.m",2);
AGR.TOC("matff","F22G1-f7r78B0.m",2);
AGR.TOC("matff","F22G1-f7r429B0.m",2);
AGR.TOC("matff","F22G1-f11r78B0.m",2);
AGR.TOC("matff","F22G1-f11r429B0.m",2);
AGR.TOC("matff","F22G1-f13r78B0.m",2);
AGR.TOC("matff","F22G1-f13r429B0.m",2);
AGR.TOC("matint","F22G1-Zr78B0.g");
AGR.TOC("maxes","F22G1-max1W1");
AGR.TOC("maxes","F22G1-max2W1");
AGR.TOC("maxes","F22G1-max3W1");
AGR.TOC("maxes","F22G1-max3W2");
AGR.TOC("maxes","F22G1-max4W1");
AGR.TOC("maxes","F22G1-max5W1");
AGR.TOC("maxes","F22G1-max6W1");
AGR.TOC("maxes","F22G1-max7W1");
AGR.TOC("maxes","F22G1-max8W1");
AGR.TOC("maxes","F22G1-max9W1");
AGR.TOC("maxes","F22G1-max10W1");
AGR.TOC("maxes","F22G1-max11W1");
AGR.TOC("maxes","F22G1-max12W1");
AGR.TOC("maxes","F22G1-max13W2");
AGR.TOC("maxes","F22G1-max13W1");
AGR.TOC("maxes","F22G1-max14W1");
AGR.TOC("cyclic","F22G1-cycW1");
AGR.TOC("find","F22G1-find1");
AGR.TOC("check","F22G1-check1");
AGR.TOC("pres","F22G1-P1");

# F22d2
AGR.GRP("spor","F22","F22d2");
AGR.TOC("perm","F22d2G1-p3510B0.m",2);
AGR.TOC("matff","F22d2G1-f2r78B0.m",2);
AGR.TOC("matff","F22d2G1-f2r350B0.m",2);
AGR.TOC("matff","F22d2G1-f2r572B0.m",2);
AGR.TOC("matff","F22d2G1-f2r1352B0.m",2);
AGR.TOC("matff","F22d2G1-f3r77aB0.m",2);
AGR.TOC("matff","F22d2G1-f3r351B0.m",2);
AGR.TOC("matff","F22d2G1-f3r924B0.m",2);
AGR.TOC("matff","F22d2G1-f5r78aB0.m",2);
AGR.TOC("matff","F22d2G1-f5r428aB0.m",2);
AGR.TOC("matff","F22d2G1-f7r78aB0.m",2);
AGR.TOC("matff","F22d2G1-f7r429aB0.m",2);
AGR.TOC("matff","F22d2G1-f11r78aB0.m",2);
AGR.TOC("matff","F22d2G1-f11r429aB0.m",2);
AGR.TOC("matff","F22d2G1-f13r78aB0.m",2);
AGR.TOC("matff","F22d2G1-f13r429aB0.m",2);
AGR.TOC("matint","F22d2G1-Zr78B0.g");
AGR.TOC("maxes","F22d2G1-max1W1");
AGR.TOC("maxes","F22d2G1-max2W1");
AGR.TOC("maxes","F22d2G1-max2W2");
AGR.TOC("maxes","F22d2G1-max13W1");
AGR.TOC("find","F22d2G1-find1");
AGR.TOC("check","F22d2G1-check1");
AGR.TOC("pres","F22d2G1-P1");

# F23
AGR.GRP("spor","F23","F23");
AGR.TOC("perm","F23G1-p31671B0.m",2);
AGR.TOC("perm","F23G1-p137632B0.m",2);
AGR.TOC("perm","F23G1-p275264B0.m",2);
AGR.TOC("matff","F23G1-f2r782B0.m",2);
AGR.TOC("matff","F23G1-f2r1494B0.m",2);
AGR.TOC("matff","F23G1-f3r253B0.m",2);
AGR.TOC("matff","F23G1-f3r528B0.m",2);
AGR.TOC("matff","F23G1-f5r782B0.m",2);
AGR.TOC("matff","F23G1-f7r782B0.m",2);
AGR.TOC("matff","F23G1-f11r782B0.m",2);
AGR.TOC("matff","F23G1-f13r782B0.m",2);
AGR.TOC("matff","F23G1-f17r782B0.m",2);
AGR.TOC("matff","F23G1-f23r782B0.m",2);
AGR.TOC("maxes","F23G1-max1W1");
AGR.TOC("maxes","F23G1-max1W2");
AGR.TOC("maxes","F23G1-max2W1");
AGR.TOC("maxes","F23G1-max3W1");
AGR.TOC("maxes","F23G1-max4W1");
AGR.TOC("maxes","F23G1-max5W1");
AGR.TOC("maxes","F23G1-max6W1");
AGR.TOC("maxes","F23G1-max9W1");
AGR.TOC("maxes","F23G1-max10W1");
AGR.TOC("maxes","F23G1-max13W1");
AGR.TOC("maxes","F23G1-max14W1");
AGR.TOC("cyclic","F23G1-cycW1");
AGR.TOC("find","F23G1-find1");
AGR.TOC("check","F23G1-check1");

# 3F24
AGR.GRP("spor","F24","3F24");
AGR.TOC("perm","3F24G1-p920808B0.m",2);
AGR.TOC("matff","3F24G1-f4r783B0.m",2);

# 3F24d2
AGR.GRP("spor","F24","3F24d2");
AGR.TOC("perm","3F24d2G1-p920808B0.m",2);
AGR.TOC("matff","3F24d2G1-f2r1566B0.m",2);

# F24
AGR.GRP("spor","F24","F24");
AGR.TOC("perm","F24G1-p306936B0.m",2);
AGR.TOC("matff","F24G1-f2r3774B0.m",2);
AGR.TOC("matff","F24G1-f3r781B0.m",2);
AGR.TOC("cyclic","F24G1-cycW1");
AGR.TOC("find","F24G1-find1");
AGR.TOC("check","F24G1-check1");

# F24d2
AGR.GRP("spor","F24","F24d2");
AGR.TOC("perm","F24d2G1-p306936B0.m",2);
AGR.TOC("matff","F24d2G1-f3r781B0.m",2);
AGR.TOC("maxes","F24d2G1-max1W1");
AGR.TOC("maxes","F24d2G1-max2W1");
AGR.TOC("maxes","F24d2G1-max3W1");
AGR.TOC("maxes","F24d2G1-max4W1");
AGR.TOC("maxes","F24d2G1-max5W1");
AGR.TOC("maxes","F24d2G1-max6W1");
AGR.TOC("maxes","F24d2G1-max7W1");
AGR.TOC("maxes","F24d2G1-max8W1");
AGR.TOC("maxes","F24d2G1-max9W1");
AGR.TOC("maxes","F24d2G1-max10W1");
AGR.TOC("maxes","F24d2G1-max11W1");
AGR.TOC("maxes","F24d2G1-max12W1");
AGR.TOC("maxes","F24d2G1-max13W1");
AGR.TOC("maxes","F24d2G1-max14W1");
AGR.TOC("maxes","F24d2G1-max15W1");
AGR.TOC("maxes","F24d2G1-max16W1");
AGR.TOC("maxes","F24d2G1-max17W1");
AGR.TOC("maxes","F24d2G1-max18W1");
AGR.TOC("maxes","F24d2G1-max19W1");
AGR.TOC("maxes","F24d2G1-max20W1");
AGR.TOC("maxes","F24d2G1-max21W1");
AGR.TOC("find","F24d2G1-find1");
AGR.TOC("check","F24d2G1-check1");

# HN
AGR.GRP("spor","HN","HN");
AGR.TOC("perm","HNG1-p1140000B0.m",2);
AGR.TOC("matff","HNG1-f2r760B0.m",2);
AGR.TOC("matff","HNG1-f3r760B0.m",2);
AGR.TOC("matff","HNG1-f4r132aB0.m",2);
AGR.TOC("matff","HNG1-f4r132bB0.m",2);
AGR.TOC("matff","HNG1-f4r133B0.m",2);
AGR.TOC("matff","HNG1-f4r2650aB0.m",2);
AGR.TOC("matff","HNG1-f5r133B0.m",2);
AGR.TOC("matff","HNG1-f5r626B0.m",2);
AGR.TOC("matff","HNG1-f5r627B0.m",2);
AGR.TOC("matff","HNG1-f7r760B0.m",2);
AGR.TOC("matff","HNG1-f9r133aB0.m",2);
AGR.TOC("matff","HNG1-f9r133bB0.m",2);
AGR.TOC("matff","HNG1-f11r133aB0.m",2);
AGR.TOC("matff","HNG1-f11r133bB0.m",2);
AGR.TOC("matff","HNG1-f11r760B0.m",2);
AGR.TOC("matff","HNG1-f19r133aB0.m",2);
AGR.TOC("matff","HNG1-f19r133bB0.m",2);
AGR.TOC("matff","HNG1-f19r760B0.m",2);
AGR.TOC("matff","HNG1-f49r133aB0.m",2);
AGR.TOC("matff","HNG1-f49r133bB0.m",2);
AGR.TOC("maxes","HNG1-max1W1");
AGR.TOC("maxes","HNG1-max2W1");
AGR.TOC("maxes","HNG1-max3W1");
AGR.TOC("maxes","HNG1-max4W1");
AGR.TOC("maxes","HNG1-max5W1");
AGR.TOC("maxes","HNG1-max6W1");
AGR.TOC("maxes","HNG1-max7W1");
AGR.TOC("maxes","HNG1-max10W1");
AGR.TOC("maxes","HNG1-max11W1");
AGR.TOC("maxes","HNG1-max12W1");
AGR.TOC("maxes","HNG1-max14W1");
AGR.TOC("cyclic","HNG1-cycW1");
AGR.TOC("cyc2ccl","HNG1cycW1-cclsW1");
AGR.TOC("out","HNG1-a2W1");
AGR.TOC("find","HNG1-find1");
AGR.TOC("check","HNG1-check1");

# HNd2
AGR.GRP("spor","HN","HNd2");
AGR.TOC("matff","HNd2G1-f2r264B0.m",2);
AGR.TOC("matff","HNd2G1-f5r133B0.m",2);
AGR.TOC("maxes","HNd2G1-max1W1");
AGR.TOC("maxes","HNd2G1-max2W1");
AGR.TOC("maxes","HNd2G1-max3W1");
AGR.TOC("maxes","HNd2G1-max4W1");
AGR.TOC("maxes","HNd2G1-max5W1");
AGR.TOC("maxes","HNd2G1-max6W1");
AGR.TOC("maxes","HNd2G1-max7W1");
AGR.TOC("maxes","HNd2G1-max8W1");
AGR.TOC("maxes","HNd2G1-max9W1");
AGR.TOC("maxes","HNd2G1-max10W1");
AGR.TOC("maxes","HNd2G1-max11W1");
AGR.TOC("maxes","HNd2G1-max12W1");
AGR.TOC("maxes","HNd2G1-max13W1");
AGR.TOC("find","HNd2G1-find1");
AGR.TOC("check","HNd2G1-check1");

# 2HS
AGR.GRP("spor","HS","2HS");
AGR.TOC("perm","2HSG1-p704B0.m",2);
AGR.TOC("perm","2HSG1-p4400B0.m",2);
AGR.TOC("perm","2HSG1-p11200aB0.m",2);
AGR.TOC("matff","2HSG1-f3r56B0.m",2);
AGR.TOC("matff","2HSG1-f3r440B0.m",2);
AGR.TOC("matff","2HSG1-f5r28bB0.m",2);
AGR.TOC("matff","2HSG1-f5r120bB0.m",2);
AGR.TOC("matff","2HSG1-f5r440bB0.m",2);
AGR.TOC("matff","2HSG1-f7r56B0.m",2);
AGR.TOC("matff","2HSG1-f9r176bB0.m",2);
AGR.TOC("matff","2HSG1-f11r56B0.m",2);

# 2HSd2
AGR.GRP("spor","HS","2HSd2");
AGR.TOC("perm","2HSd2G1-p1408B0.m",2);
AGR.TOC("matff","2HSd2G1-f3r112B0.m",2);
AGR.TOC("matff","2HSd2G1-f5r56B0.m",2);
AGR.TOC("matff","2HSd2G1-f9r56B0.m",2);

# HS
AGR.GRP("spor","HS","HS");
AGR.TOC("perm","HSG1-p100B0.m",2);
AGR.TOC("perm","HSG1-p176bB0.m",2);
AGR.TOC("perm","HSG1-p1100aB0.m",2);
AGR.TOC("perm","HSG1-p1100bB0.m",2);
AGR.TOC("perm","HSG1-p3850B0.m",2);
AGR.TOC("perm","HSG1-p4125B0.m",2);
AGR.TOC("perm","HSG1-p5600aB0.m",2);
AGR.TOC("perm","HSG1-p15400B0.m",2);
AGR.TOC("matff","HSG1-f2r20B0.m",2);
AGR.TOC("matff","HSG1-f2r56B0.m",2);
AGR.TOC("matff","HSG1-f2r132B0.m",2);
AGR.TOC("matff","HSG1-f2r518B0.m",2);
AGR.TOC("matff","HSG1-f2r1000B0.m",2);
AGR.TOC("matff","HSG1-f3r22B0.m",2);
AGR.TOC("matff","HSG1-f3r49aB0.m",2);
AGR.TOC("matff","HSG1-f3r49bB0.m",2);
AGR.TOC("matff","HSG1-f3r77B0.m",2);
AGR.TOC("matff","HSG1-f3r154aB0.m",2);
AGR.TOC("matff","HSG1-f3r154bB0.m",2);
AGR.TOC("matff","HSG1-f3r154cB0.m",2);
AGR.TOC("matff","HSG1-f3r231B0.m",2);
AGR.TOC("matff","HSG1-f3r321B0.m",2);
AGR.TOC("matff","HSG1-f3r693B0.m",2);
AGR.TOC("matff","HSG1-f3r748B0.m",2);
AGR.TOC("matff","HSG1-f3r770aB0.m",2);
AGR.TOC("matff","HSG1-f3r825B0.m",2);
AGR.TOC("matff","HSG1-f4r896aB0.m",2);
AGR.TOC("matff","HSG1-f4r896bB0.m",2);
AGR.TOC("matff","HSG1-f5r21B0.m",2);
AGR.TOC("matff","HSG1-f5r55B0.m",2);
AGR.TOC("matff","HSG1-f5r98B0.m",2);
AGR.TOC("matff","HSG1-f5r133aB0.m",2);
AGR.TOC("matff","HSG1-f5r133bB0.m",2);
AGR.TOC("matff","HSG1-f5r175B0.m",2);
AGR.TOC("matff","HSG1-f5r210B0.m",2);
AGR.TOC("matff","HSG1-f5r280aB0.m",2);
AGR.TOC("matff","HSG1-f5r518B0.m",2);
AGR.TOC("matff","HSG1-f5r650B0.m",2);
AGR.TOC("matff","HSG1-f7r22B0.m",2);
AGR.TOC("matff","HSG1-f7r77B0.m",2);
AGR.TOC("matff","HSG1-f7r154aB0.m",2);
AGR.TOC("matff","HSG1-f7r154bB0.m",2);
AGR.TOC("matff","HSG1-f7r154cB0.m",2);
AGR.TOC("matff","HSG1-f7r175B0.m",2);
AGR.TOC("matff","HSG1-f7r231B0.m",2);
AGR.TOC("matff","HSG1-f7r605B0.m",2);
AGR.TOC("matff","HSG1-f7r693B0.m",2);
AGR.TOC("matff","HSG1-f7r770aB0.m",2);
AGR.TOC("matff","HSG1-f7r770bB0.m",2);
AGR.TOC("matff","HSG1-f7r770cB0.m",2);
AGR.TOC("matff","HSG1-f7r803B0.m",2);
AGR.TOC("matff","HSG1-f11r22B0.m",2);
AGR.TOC("matff","HSG1-f11r77B0.m",2);
AGR.TOC("matff","HSG1-f11r154aB0.m",2);
AGR.TOC("matff","HSG1-f11r154bB0.m",2);
AGR.TOC("matff","HSG1-f11r154cB0.m",2);
AGR.TOC("matff","HSG1-f11r174B0.m",2);
AGR.TOC("matff","HSG1-f11r231B0.m",2);
AGR.TOC("matff","HSG1-f11r693B0.m",2);
AGR.TOC("matff","HSG1-f11r770aB0.m",2);
AGR.TOC("matff","HSG1-f11r825B0.m",2);
AGR.TOC("matff","HSG1-f11r854B0.m",2);
AGR.TOC("matff","HSG1-f11r896B0.m",2);
AGR.TOC("matff","HSG1-f49r896aB0.m",2);
AGR.TOC("matff","HSG1-f49r896bB0.m",2);
AGR.TOC("matff","HSG1-f121r770bB0.m",2);
AGR.TOC("matff","HSG1-f121r770cB0.m",2);
AGR.TOC("matint","HSG1-Zr22B0.g");
AGR.TOC("matint","HSG1-Zr77B0.g");
AGR.TOC("matint","HSG1-Zr154aB0.g");
AGR.TOC("matint","HSG1-Zr154bB0.g");
AGR.TOC("matint","HSG1-Zr154cB0.g");
AGR.TOC("matint","HSG1-Zr175B0.g");
AGR.TOC("matint","HSG1-Zr231B0.g");
AGR.TOC("maxes","HSG1-max1W1");
AGR.TOC("maxes","HSG1-max2W1");
AGR.TOC("maxes","HSG1-max3W1");
AGR.TOC("maxes","HSG1-max4W1");
AGR.TOC("maxes","HSG1-max5W1");
AGR.TOC("maxes","HSG1-max6W1");
AGR.TOC("maxes","HSG1-max7W1");
AGR.TOC("maxes","HSG1-max8W1");
AGR.TOC("maxes","HSG1-max9W1");
AGR.TOC("maxes","HSG1-max10W1");
AGR.TOC("maxes","HSG1-max11W1");
AGR.TOC("maxes","HSG1-max12W1");
AGR.TOC("cyclic","HSG1-cycW1");
AGR.TOC("cyc2ccl","HSG1cycW1-cclsW1");
AGR.TOC("find","HSG1-find1");
AGR.TOC("check","HSG1-check1");
AGR.TOC("pres","HSG1-P1");

# HSd2
AGR.GRP("spor","HS","HSd2");
AGR.TOC("perm","HSd2G1-p100B0.m",2);
AGR.TOC("perm","HSd2G1-p352B0.m",2);
AGR.TOC("perm","HSd2G1-p1100bB0.m",2);
AGR.TOC("perm","HSd2G1-p15400B0.m",2);
AGR.TOC("matff","HSd2G1-f2r20B0.m",2);
AGR.TOC("matff","HSd2G1-f2r22B0.m",2);
AGR.TOC("matff","HSd2G1-f2r56B0.m",2);
AGR.TOC("matff","HSd2G1-f2r132B0.m",2);
AGR.TOC("matff","HSd2G1-f2r518B0.m",2);
AGR.TOC("matff","HSd2G1-f2r1000B0.m",2);
AGR.TOC("matff","HSd2G1-f2r1408B0.m",2);
AGR.TOC("matff","HSd2G1-f2r1792B0.m",2);
AGR.TOC("matff","HSd2G1-f3r22aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r77aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r98aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r154aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r231aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r308aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r321aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r693aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r748aB0.m",2);
AGR.TOC("matff","HSd2G1-f3r825aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r21aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r55aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r98aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r175aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r210aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r266aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r518aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r560aB0.m",2);
AGR.TOC("matff","HSd2G1-f5r650aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r22aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r77aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r154aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r175aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r231aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r308aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r605aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r693B0.m",2);
AGR.TOC("matff","HSd2G1-f7r693aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r770aB0.m",2);
AGR.TOC("matff","HSd2G1-f7r803B0.m",2);
AGR.TOC("matff","HSd2G1-f7r803aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r22aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r77aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r154aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r174aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r231aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r308aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r693aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r770aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r825aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r854aB0.m",2);
AGR.TOC("matff","HSd2G1-f11r896aB0.m",2);
AGR.TOC("maxes","HSd2G1-max1W1");
AGR.TOC("maxes","HSd2G1-max2W1");
AGR.TOC("maxes","HSd2G1-max2W2");
AGR.TOC("maxes","HSd2G1-max3W1");
AGR.TOC("maxes","HSd2G1-max4W1");
AGR.TOC("maxes","HSd2G1-max4W2");
AGR.TOC("maxes","HSd2G1-max5W1");
AGR.TOC("maxes","HSd2G1-max6W1");
AGR.TOC("maxes","HSd2G1-max6W2");
AGR.TOC("maxes","HSd2G1-max7W1");
AGR.TOC("maxes","HSd2G1-max8W1");
AGR.TOC("maxes","HSd2G1-max9W1");
AGR.TOC("maxes","HSd2G1-max10W1");
AGR.TOC("find","HSd2G1-find1");
AGR.TOC("check","HSd2G1-check1");
AGR.TOC("pres","HSd2G1-P1");

# He
AGR.GRP("spor","He","He");
AGR.TOC("perm","HeG1-p2058B0.m",2);
AGR.TOC("perm","HeG1-p8330B0.m",2);
AGR.TOC("perm","HeG1-p29155B0.m",2);
AGR.TOC("perm","HeG1-p244800B0.m",2);
AGR.TOC("matff","HeG1-f2r51B0.m",2);
AGR.TOC("matff","HeG1-f2r101B0.m",2);
AGR.TOC("matff","HeG1-f2r246B0.m",2);
AGR.TOC("matff","HeG1-f2r680B0.m",2);
AGR.TOC("matff","HeG1-f3r679B0.m",2);
AGR.TOC("matff","HeG1-f5r104B0.m",2);
AGR.TOC("matff","HeG1-f5r680B0.m",2);
AGR.TOC("matff","HeG1-f7r50B0.m",2);
AGR.TOC("matff","HeG1-f7r153B0.m",2);
AGR.TOC("matff","HeG1-f7r426B0.m",2);
AGR.TOC("matff","HeG1-f7r798B0.m",2);
AGR.TOC("matff","HeG1-f9r51B0.m",2);
AGR.TOC("matff","HeG1-f9r153aB0.m",2);
AGR.TOC("matff","HeG1-f9r153bB0.m",2);
AGR.TOC("matff","HeG1-f17r102B0.m",2);
AGR.TOC("matff","HeG1-f17r306B0.m",2);
AGR.TOC("matff","HeG1-f17r680B0.m",2);
AGR.TOC("matff","HeG1-f25r51B0.m",2);
AGR.TOC("matff","HeG1-f25r153aB0.m",2);
AGR.TOC("matff","HeG1-f25r153bB0.m",2);
AGR.TOC("matff","HeG1-f25r925aB0.m",2);
AGR.TOC("matff","HeG1-f25r925bB0.m",2);
AGR.TOC("matint","HeG1-Zr102B0.g");
AGR.TOC("maxes","HeG1-max1W1");
AGR.TOC("maxes","HeG1-max2W1");
AGR.TOC("maxes","HeG1-max3W1");
AGR.TOC("maxes","HeG1-max4W1");
AGR.TOC("maxes","HeG1-max5W1");
AGR.TOC("maxes","HeG1-max6W1");
AGR.TOC("maxes","HeG1-max7W1");
AGR.TOC("maxes","HeG1-max8W1");
AGR.TOC("maxes","HeG1-max9W1");
AGR.TOC("maxes","HeG1-max10W1");
AGR.TOC("maxes","HeG1-max11W1");
AGR.TOC("cyclic","HeG1-cycW1");
AGR.TOC("out","HeG1-a2W1");
AGR.TOC("find","HeG1-find1");
AGR.TOC("check","HeG1-check1");
AGR.TOC("pres","HeG1-P1");

# Hed2
AGR.GRP("spor","He","Hed2");
AGR.TOC("perm","Hed2G1-p2058B0.m",2);
AGR.TOC("perm","Hed2G1-p8330B0.m",2);
AGR.TOC("matff","Hed2G1-f2r102B0.m",2);
AGR.TOC("matff","Hed2G1-f2r202B0.m",2);
AGR.TOC("matff","Hed2G1-f2r492B0.m",2);
AGR.TOC("matff","Hed2G1-f2r680B0.m",2);
AGR.TOC("matff","Hed2G1-f3r102B0.m",2);
AGR.TOC("matff","Hed2G1-f3r306aB0.m",2);
AGR.TOC("matff","Hed2G1-f3r679B0.m",2);
AGR.TOC("matff","Hed2G1-f5r102B0.m",2);
AGR.TOC("matff","Hed2G1-f5r104aB0.m",2);
AGR.TOC("matff","Hed2G1-f5r306aB0.m",2);
AGR.TOC("matff","Hed2G1-f5r680B0.m",2);
AGR.TOC("matff","Hed2G1-f7r50B0.m",2);
AGR.TOC("matff","Hed2G1-f7r153B0.m",2);
AGR.TOC("matff","Hed2G1-f7r426B0.m",2);
AGR.TOC("matff","Hed2G1-f17r102B0.m",2);
AGR.TOC("matff","Hed2G1-f17r306aB0.m",2);
AGR.TOC("matff","Hed2G1-f17r680B0.m",2);
AGR.TOC("maxes","Hed2G1-max1W1");
AGR.TOC("maxes","Hed2G1-max2W1");
AGR.TOC("maxes","Hed2G1-max2W2");
AGR.TOC("maxes","Hed2G1-max3W1");
AGR.TOC("maxes","Hed2G1-max3W2");
AGR.TOC("maxes","Hed2G1-max4W1");
AGR.TOC("maxes","Hed2G1-max4W2");
AGR.TOC("maxes","Hed2G1-max5W1");
AGR.TOC("maxes","Hed2G1-max6W1");
AGR.TOC("maxes","Hed2G1-max6W2");
AGR.TOC("maxes","Hed2G1-max7W1");
AGR.TOC("maxes","Hed2G1-max8W1");
AGR.TOC("maxes","Hed2G1-max9W1");
AGR.TOC("maxes","Hed2G1-max10W2");
AGR.TOC("maxes","Hed2G1-max10W1");
AGR.TOC("maxes","Hed2G1-max11W1");
AGR.TOC("maxes","Hed2G1-max12W1");
AGR.TOC("find","Hed2G1-find1");
AGR.TOC("check","Hed2G1-check1");

# J1
AGR.GRP("spor","J1","J1");
AGR.TOC("perm","J1G1-p266B0.m",2);
AGR.TOC("perm","J1G1-p1045B0.m",2);
AGR.TOC("perm","J1G1-p1463B0.m",2);
AGR.TOC("perm","J1G1-p1540B0.m",2);
AGR.TOC("perm","J1G1-p1596B0.m",2);
AGR.TOC("perm","J1G1-p2926B0.m",2);
AGR.TOC("perm","J1G1-p4180B0.m",2);
AGR.TOC("matff","J1G1-f2r20B0.m",2);
AGR.TOC("matff","J1G1-f2r76aB0.m",2);
AGR.TOC("matff","J1G1-f2r76bB0.m",2);
AGR.TOC("matff","J1G1-f2r112aB0.m",2);
AGR.TOC("matff","J1G1-f2r112bB0.m",2);
AGR.TOC("matff","J1G1-f2r360B0.m",2);
AGR.TOC("matff","J1G1-f3r76aB0.m",2);
AGR.TOC("matff","J1G1-f3r76bB0.m",2);
AGR.TOC("matff","J1G1-f3r112B0.m",2);
AGR.TOC("matff","J1G1-f3r133B0.m",2);
AGR.TOC("matff","J1G1-f3r154B0.m",2);
AGR.TOC("matff","J1G1-f3r360B0.m",2);
AGR.TOC("matff","J1G1-f4r56aB0.m",2);
AGR.TOC("matff","J1G1-f4r56bB0.m",2);
AGR.TOC("matff","J1G1-f4r56cB0.m",2);
AGR.TOC("matff","J1G1-f4r56dB0.m",2);
AGR.TOC("matff","J1G1-f5r56B0.m",2);
AGR.TOC("matff","J1G1-f5r76aB0.m",2);
AGR.TOC("matff","J1G1-f5r76bB0.m",2);
AGR.TOC("matff","J1G1-f5r77B0.m",2);
AGR.TOC("matff","J1G1-f5r133B0.m",2);
AGR.TOC("matff","J1G1-f5r360B0.m",2);
AGR.TOC("matff","J1G1-f7r31B0.m",2);
AGR.TOC("matff","J1G1-f7r45B0.m",2);
AGR.TOC("matff","J1G1-f7r75B0.m",2);
AGR.TOC("matff","J1G1-f7r77aB0.m",2);
AGR.TOC("matff","J1G1-f7r89B0.m",2);
AGR.TOC("matff","J1G1-f7r112B0.m",2);
AGR.TOC("matff","J1G1-f7r120B0.m",2);
AGR.TOC("matff","J1G1-f7r133aB0.m",2);
AGR.TOC("matff","J1G1-f7r154B0.m",2);
AGR.TOC("matff","J1G1-f7r266B0.m",2);
AGR.TOC("matff","J1G1-f8r120aB0.m",2);
AGR.TOC("matff","J1G1-f8r120bB0.m",2);
AGR.TOC("matff","J1G1-f8r120cB0.m",2);
AGR.TOC("matff","J1G1-f9r56aB0.m",2);
AGR.TOC("matff","J1G1-f9r56bB0.m",2);
AGR.TOC("matff","J1G1-f9r77aB0.m",2);
AGR.TOC("matff","J1G1-f9r77bB0.m",2);
AGR.TOC("matff","J1G1-f11r7B0.m",2);
AGR.TOC("matff","J1G1-f11r14B0.m",2);
AGR.TOC("matff","J1G1-f11r27B0.m",2);
AGR.TOC("matff","J1G1-f11r49B0.m",2);
AGR.TOC("matff","J1G1-f11r56B0.m",2);
AGR.TOC("matff","J1G1-f11r64B0.m",2);
AGR.TOC("matff","J1G1-f11r69B0.m",2);
AGR.TOC("matff","J1G1-f11r77aB0.m",2);
AGR.TOC("matff","J1G1-f11r77bB0.m",2);
AGR.TOC("matff","J1G1-f11r77cB0.m",2);
AGR.TOC("matff","J1G1-f11r106B0.m",2);
AGR.TOC("matff","J1G1-f11r119B0.m",2);
AGR.TOC("matff","J1G1-f11r209B0.m",2);
AGR.TOC("matff","J1G1-f19r22B0.m",2);
AGR.TOC("matff","J1G1-f19r34B0.m",2);
AGR.TOC("matff","J1G1-f19r43B0.m",2);
AGR.TOC("matff","J1G1-f19r55B0.m",2);
AGR.TOC("matff","J1G1-f19r76aB0.m",2);
AGR.TOC("matff","J1G1-f19r76bB0.m",2);
AGR.TOC("matff","J1G1-f19r77B0.m",2);
AGR.TOC("matff","J1G1-f19r133aB0.m",2);
AGR.TOC("matff","J1G1-f19r133bB0.m",2);
AGR.TOC("matff","J1G1-f19r133cB0.m",2);
AGR.TOC("matff","J1G1-f19r209B0.m",2);
AGR.TOC("matff","J1G1-f27r120aB0.m",2);
AGR.TOC("matff","J1G1-f27r120bB0.m",2);
AGR.TOC("matff","J1G1-f27r120cB0.m",2);
AGR.TOC("matff","J1G1-f49r56aB0.m",2);
AGR.TOC("matff","J1G1-f49r56bB0.m",2);
AGR.TOC("matff","J1G1-f49r77bB0.m",2);
AGR.TOC("matff","J1G1-f49r77cB0.m",2);
AGR.TOC("matff","J1G1-f49r133bB0.m",2);
AGR.TOC("matff","J1G1-f49r133cB0.m",2);
AGR.TOC("matff","J1G1-f125r120aB0.m",2);
AGR.TOC("matff","J1G1-f125r120bB0.m",2);
AGR.TOC("matff","J1G1-f125r120cB0.m",2);
AGR.TOC("matint","J1G1-Zr76aB0.g");
AGR.TOC("matint","J1G1-Zr76bB0.g");
AGR.TOC("matint","J1G1-Zr77aB0.g");
AGR.TOC("matint","J1G1-Zr112B0.g");
AGR.TOC("matint","J1G1-Zr133aB0.g");
AGR.TOC("matint","J1G1-Zr154aB0.g");
AGR.TOC("matint","J1G1-Zr209B0.g");
AGR.TOC("matint","J1G1-Zr266B0.g");
AGR.TOC("matint","J1G1-Zr360B0.g");
AGR.TOC("maxes","J1G1-max1W1");
AGR.TOC("maxes","J1G1-max2W1");
AGR.TOC("maxes","J1G1-max3W1");
AGR.TOC("maxes","J1G1-max4W1");
AGR.TOC("maxes","J1G1-max5W1");
AGR.TOC("maxes","J1G1-max6W1");
AGR.TOC("maxes","J1G1-max7W1");
AGR.TOC("cyclic","J1G1-cycW1");
AGR.TOC("cyc2ccl","J1G1cycW1-cclsW1");
AGR.TOC("maxstd","J1G1max1W1-L211G1W1");
AGR.TOC("find","J1G1-find1");
AGR.TOC("check","J1G1-check1");
AGR.TOC("pres","J1G1-P1");

# 2J2
AGR.GRP("spor","J2","2J2");
AGR.TOC("perm","2J2G1-p200B0.m",2);
AGR.TOC("perm","2J2G1-p1120B0.m",2);
AGR.TOC("matff","2J2G1-f3r14B0.m",2);
AGR.TOC("matff","2J2G1-f3r216B0.m",2);
AGR.TOC("matff","2J2G1-f3r236B0.m",2);
AGR.TOC("matff","2J2G1-f5r6B0.m",2);
AGR.TOC("matff","2J2G1-f5r14B0.m",2);
AGR.TOC("matff","2J2G1-f5r50aB0.m",2);
AGR.TOC("matff","2J2G1-f5r50bB0.m",2);
AGR.TOC("matff","2J2G1-f5r56B0.m",2);
AGR.TOC("matff","2J2G1-f5r64B0.m",2);
AGR.TOC("matff","2J2G1-f7r14B0.m",2);
AGR.TOC("matff","2J2G1-f9r6aB0.m",2);
AGR.TOC("matff","2J2G1-f9r36aB0.m",2);
AGR.TOC("matff","2J2G1-f9r50bB0.m",2);
AGR.TOC("matff","2J2G1-f9r126bB0.m",2);
AGR.TOC("matff","2J2G1-f49r6aB0.m",2);
AGR.TOC("matff","2J2G1-f49r50bB0.m",2);
AGR.TOC("matff","2J2G1-f49r58aB0.m",2);
AGR.TOC("pres","2J2G1-P1");
AGR.TOC("pres","2J2G1-P2");

# 2J2d2
AGR.GRP("spor","J2","2J2d2");
AGR.TOC("matff","2J2d2G1-f3r12B0.m",2);
AGR.TOC("matff","2J2d2G1-f3r72B0.m",2);
AGR.TOC("matff","2J2d2G1-f3r100B0.m",2);
AGR.TOC("matff","2J2d2G1-f3r216aB0.m",2);
AGR.TOC("matff","2J2d2G1-f3r252B0.m",2);
AGR.TOC("matff","2J2d2G1-f5r100aB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r12B0.m",2);
AGR.TOC("matff","2J2d2G1-f7r14aB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r100aB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r112aB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r116aB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r252aB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r336bB0.m",2);
AGR.TOC("matff","2J2d2G1-f7r350aB0.m",2);
AGR.TOC("matff","2J2d2G1-f9r14bB0.m",2);
AGR.TOC("matff","2J2d2G1-f9r236aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r6aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r14aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r56aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r64aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r190aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r202aB0.m",2);
AGR.TOC("matff","2J2d2G1-f25r350aB0.m",2);
AGR.TOC("matff","2J2d2G1-f49r84aB0.m",2);
AGR.TOC("matff","2J2d2G1-f49r252bB0.m",2);
AGR.TOC("pres","2J2d2G1-P1");

# 2J2d2i
AGR.GRP("spor","J2","2J2d2i");
AGR.TOC("pres","2J2d2iG1-P1");

# J2
AGR.GRP("spor","J2","J2");
AGR.TOC("perm","J2G1-p100B0.m",2);
AGR.TOC("perm","J2G1-p280B0.m",2);
AGR.TOC("perm","J2G1-p315B0.m",2);
AGR.TOC("perm","J2G1-p525B0.m",2);
AGR.TOC("perm","J2G1-p840B0.m",2);
AGR.TOC("perm","J2G1-p1008B0.m",2);
AGR.TOC("perm","J2G1-p1800B0.m",2);
AGR.TOC("matff","J2G1-f2r36B0.m",2);
AGR.TOC("matff","J2G1-f2r84B0.m",2);
AGR.TOC("matff","J2G1-f2r160B0.m",2);
AGR.TOC("matff","J2G1-f3r36B0.m",2);
AGR.TOC("matff","J2G1-f3r63B0.m",2);
AGR.TOC("matff","J2G1-f3r90B0.m",2);
AGR.TOC("matff","J2G1-f3r133B0.m",2);
AGR.TOC("matff","J2G1-f3r225B0.m",2);
AGR.TOC("matff","J2G1-f4r6aB0.m",2);
AGR.TOC("matff","J2G1-f4r14aB0.m",2);
AGR.TOC("matff","J2G1-f4r64aB0.m",2);
AGR.TOC("matff","J2G1-f5r14B0.m",2);
AGR.TOC("matff","J2G1-f5r21B0.m",2);
AGR.TOC("matff","J2G1-f5r41B0.m",2);
AGR.TOC("matff","J2G1-f5r70B0.m",2);
AGR.TOC("matff","J2G1-f5r85B0.m",2);
AGR.TOC("matff","J2G1-f5r90B0.m",2);
AGR.TOC("matff","J2G1-f5r175B0.m",2);
AGR.TOC("matff","J2G1-f5r189B0.m",2);
AGR.TOC("matff","J2G1-f5r225B0.m",2);
AGR.TOC("matff","J2G1-f5r300B0.m",2);
AGR.TOC("matff","J2G1-f7r36B0.m",2);
AGR.TOC("matff","J2G1-f7r63B0.m",2);
AGR.TOC("matff","J2G1-f7r89B0.m",2);
AGR.TOC("matff","J2G1-f7r101B0.m",2);
AGR.TOC("matff","J2G1-f7r124B0.m",2);
AGR.TOC("matff","J2G1-f7r126B0.m",2);
AGR.TOC("matff","J2G1-f7r175B0.m",2);
AGR.TOC("matff","J2G1-f7r199B0.m",2);
AGR.TOC("matff","J2G1-f7r336B0.m",2);
AGR.TOC("matff","J2G1-f9r13aB0.m",2);
AGR.TOC("matff","J2G1-f9r21aB0.m",2);
AGR.TOC("matff","J2G1-f9r57aB0.m",2);
AGR.TOC("matff","J2G1-f9r189aB0.m",2);
AGR.TOC("matff","J2G1-f49r14aB0.m",2);
AGR.TOC("matff","J2G1-f49r21aB0.m",2);
AGR.TOC("matff","J2G1-f49r70aB0.m",2);
AGR.TOC("matff","J2G1-f49r189aB0.m",2);
AGR.TOC("matff","J2G1-f49r224bB0.m",2);
AGR.TOC("matint","J2G1-Zr28B0.g");
AGR.TOC("matint","J2G1-Zr36B0.g");
AGR.TOC("matint","J2G1-Zr42B0.g");
AGR.TOC("matint","J2G1-Zr63B0.g");
AGR.TOC("matint","J2G1-Zr90B0.g");
AGR.TOC("matint","J2G1-Zr126B0.g");
AGR.TOC("matint","J2G1-Zr140B0.g");
AGR.TOC("matint","J2G1-Zr160B0.g");
AGR.TOC("matint","J2G1-Zr175B0.g");
AGR.TOC("matint","J2G1-Zr225B0.g");
AGR.TOC("matint","J2G1-Zr378B0.g");
AGR.TOC("matint","J2G1-Zr448B0.g");
AGR.TOC("matalg","J2G1-Ar14aB0.g");
AGR.TOC("matalg","J2G1-Ar14bB0.g");
AGR.TOC("matalg","J2G1-Ar21aB0.g");
AGR.TOC("matalg","J2G1-Ar21bB0.g");
AGR.TOC("maxes","J2G1-max1W1");
AGR.TOC("maxes","J2G1-max2W1");
AGR.TOC("maxes","J2G1-max3W1");
AGR.TOC("maxes","J2G1-max4W1");
AGR.TOC("maxes","J2G1-max5W1");
AGR.TOC("maxes","J2G1-max6W1");
AGR.TOC("maxes","J2G1-max7W1");
AGR.TOC("maxes","J2G1-max8W1");
AGR.TOC("maxes","J2G1-max9W1");
AGR.TOC("cyclic","J2G1-cycW1");
AGR.TOC("cyc2ccl","J2G1cycW1-cclsW1");
AGR.TOC("find","J2G1-find1");
AGR.TOC("check","J2G1-check1");
AGR.TOC("pres","J2G1-P1");
AGR.TOC("pres","J2G1-P2");

# J2d2
AGR.GRP("spor","J2","J2d2");
AGR.TOC("perm","J2d2G1-p100B0.m",2);
AGR.TOC("matff","J2d2G1-f2r12B0.m",2);
AGR.TOC("matff","J2d2G1-f2r28B0.m",2);
AGR.TOC("matff","J2d2G1-f2r36B0.m",2);
AGR.TOC("matff","J2d2G1-f2r84B0.m",2);
AGR.TOC("matff","J2d2G1-f2r128B0.m",2);
AGR.TOC("matff","J2d2G1-f2r160B0.m",2);
AGR.TOC("matff","J2d2G1-f3r26B0.m",2);
AGR.TOC("matff","J2d2G1-f3r36aB0.m",2);
AGR.TOC("matff","J2d2G1-f3r42B0.m",2);
AGR.TOC("matff","J2d2G1-f3r63aB0.m",2);
AGR.TOC("matff","J2d2G1-f3r90aB0.m",2);
AGR.TOC("matff","J2d2G1-f3r114B0.m",2);
AGR.TOC("matff","J2d2G1-f3r133aB0.m",2);
AGR.TOC("matff","J2d2G1-f3r225aB0.m",2);
AGR.TOC("matff","J2d2G1-f3r378B0.m",2);
AGR.TOC("matff","J2d2G1-f5r14aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r21aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r41aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r70aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r85aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r90aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r175aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r189aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r225aB0.m",2);
AGR.TOC("matff","J2d2G1-f5r300aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r28B0.m",2);
AGR.TOC("matff","J2d2G1-f7r28aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r36aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r42aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r63aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r89aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r101aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r124aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r126aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r140aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r175aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r199aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r378aB0.m",2);
AGR.TOC("matff","J2d2G1-f7r448aB0.m",2);
AGR.TOC("matff","J2d2G1-f49r336aB0.m",2);
AGR.TOC("maxes","J2d2G1-max1W1");
AGR.TOC("maxes","J2d2G1-max2W2");
AGR.TOC("maxes","J2d2G1-max2W1");
AGR.TOC("maxes","J2d2G1-max3W1");
AGR.TOC("maxes","J2d2G1-max3W2");
AGR.TOC("maxes","J2d2G1-max4W1");
AGR.TOC("maxes","J2d2G1-max5W1");
AGR.TOC("maxes","J2d2G1-max6W1");
AGR.TOC("maxes","J2d2G1-max7W1");
AGR.TOC("maxes","J2d2G1-max8W2");
AGR.TOC("maxes","J2d2G1-max8W1");
AGR.TOC("maxes","J2d2G1-max9W1");
AGR.TOC("maxes","J2d2G1-max10W1");
AGR.TOC("maxes","J2d2G1-max10W2");
AGR.TOC("cyclic","J2d2G1-cycW1");
AGR.TOC("find","J2d2G1-find1");
AGR.TOC("check","J2d2G1-check1");

# 3J3
AGR.GRP("spor","J3","3J3");
AGR.TOC("matff","3J3G1-f4r9aB0.m",2);
AGR.TOC("matff","3J3G1-f4r18aB0.m",2);
AGR.TOC("matff","3J3G1-f4r18bB0.m",2);
AGR.TOC("matff","3J3G1-f4r126aB0.m",2);
AGR.TOC("matff","3J3G1-f4r153aB0.m",2);
AGR.TOC("matff","3J3G1-f4r153bB0.m",2);
AGR.TOC("matff","3J3G1-f4r324aB0.m",2);
AGR.TOC("matff","3J3G1-f4r720aB0.m",2);
AGR.TOC("matff","3J3G1-f4r1008aB0.m",2);
AGR.TOC("matff","3J3G1-f5r36B0.m",2);
AGR.TOC("matff","3J3G1-f17r36aB0.m",2);
AGR.TOC("matff","3J3G1-f17r36bB0.m",2);
AGR.TOC("matff","3J3G1-f17r342aB0.m",2);
AGR.TOC("matff","3J3G1-f17r648aB0.m",2);
AGR.TOC("matff","3J3G1-f19r18aB0.m",2);
AGR.TOC("matff","3J3G1-f19r18bB0.m",2);
AGR.TOC("matff","3J3G1-f25r18B0.m",2);
AGR.TOC("matff","3J3G1-f25r153B0.m",2);
AGR.TOC("matff","3J3G1-f25r171aB0.m",2);
AGR.TOC("pres","3J3G1-P1");
AGR.TOC("pres","3J3G1-P2");

# 3J3d2
AGR.GRP("spor","J3","3J3d2");
AGR.TOC("matff","3J3d2G1-f2r18B0.m",2);

# J3
AGR.GRP("spor","J3","J3");
AGR.TOC("perm","J3G1-p6156B0.m",2);
AGR.TOC("perm","J3G1-p14688aB0.m",2);
AGR.TOC("perm","J3G1-p14688bB0.m",2);
AGR.TOC("perm","J3G1-p17442B0.m",2);
AGR.TOC("perm","J3G1-p20520B0.m",2);
AGR.TOC("perm","J3G1-p23256B0.m",2);
AGR.TOC("perm","J3G1-p25840B0.m",2);
AGR.TOC("perm","J3G1-p26163B0.m",2);
AGR.TOC("perm","J3G1-p43605B0.m",2);
AGR.TOC("matff","J3G1-f2r80B0.m",2);
AGR.TOC("matff","J3G1-f2r244B0.m",2);
AGR.TOC("matff","J3G1-f2r248B0.m",2);
AGR.TOC("matff","J3G1-f2r966B0.m",2);
AGR.TOC("matff","J3G1-f3r324B0.m",2);
AGR.TOC("matff","J3G1-f3r934B0.m",2);
AGR.TOC("matff","J3G1-f4r78bB0.m",2);
AGR.TOC("matff","J3G1-f4r84aB0.m",2);
AGR.TOC("matff","J3G1-f4r322aB0.m",2);
AGR.TOC("matff","J3G1-f5r85aB0.m",2);
AGR.TOC("matff","J3G1-f5r323B0.m",2);
AGR.TOC("matff","J3G1-f5r646B0.m",2);
AGR.TOC("matff","J3G1-f5r816B0.m",2);
AGR.TOC("matff","J3G1-f9r18bB0.m",2);
AGR.TOC("matff","J3G1-f9r84bB0.m",2);
AGR.TOC("matff","J3G1-f9r153bB0.m",2);
AGR.TOC("matff","J3G1-f17r85bB0.m",2);
AGR.TOC("matff","J3G1-f17r324B0.m",2);
AGR.TOC("matff","J3G1-f17r379B0.m",2);
AGR.TOC("matff","J3G1-f17r646cB0.m",2);
AGR.TOC("matff","J3G1-f17r761B0.m",2);
AGR.TOC("matff","J3G1-f17r816B0.m",2);
AGR.TOC("matff","J3G1-f17r836B0.m",2);
AGR.TOC("matff","J3G1-f17r1292B0.m",2);
AGR.TOC("matff","J3G1-f19r85B0.m",2);
AGR.TOC("matff","J3G1-f19r110B0.m",2);
AGR.TOC("matff","J3G1-f19r214B0.m",2);
AGR.TOC("matff","J3G1-f19r323aB0.m",2);
AGR.TOC("matff","J3G1-f19r646aB0.m",2);
AGR.TOC("matff","J3G1-f19r706B0.m",2);
AGR.TOC("matff","J3G1-f19r919B0.m",2);
AGR.TOC("matff","J3G1-f19r1001B0.m",2);
AGR.TOC("matint","J3G1-Zr170B0.g");
AGR.TOC("maxes","J3G1-max1W1");
AGR.TOC("maxes","J3G1-max2W1");
AGR.TOC("maxes","J3G1-max3W1");
AGR.TOC("maxes","J3G1-max4W1");
AGR.TOC("maxes","J3G1-max5W1");
AGR.TOC("maxes","J3G1-max6W1");
AGR.TOC("maxes","J3G1-max7W1");
AGR.TOC("maxes","J3G1-max8W1");
AGR.TOC("maxes","J3G1-max9W1");
AGR.TOC("cyclic","J3G1-cycW1");
AGR.TOC("cyc2ccl","J3G1cycW1-cclsW1");
AGR.TOC("find","J3G1-find1");
AGR.TOC("check","J3G1-check1");
AGR.TOC("pres","J3G1-P1");

# J3d2
AGR.GRP("spor","J3","J3d2");
AGR.TOC("perm","J3d2G1-p6156B0.m",2);
AGR.TOC("matff","J3d2G1-f2r80aB0.m",2);
AGR.TOC("matff","J3d2G1-f2r156aB0.m",2);
AGR.TOC("matff","J3d2G1-f2r168aB0.m",2);
AGR.TOC("matff","J3d2G1-f2r244aB0.m",2);
AGR.TOC("matff","J3d2G1-f2r644aB0.m",2);
AGR.TOC("matff","J3d2G1-f2r966aB0.m",2);
AGR.TOC("matff","J3d2G1-f3r36B0.m",2);
AGR.TOC("matff","J3d2G1-f3r36aB0.m",2);
AGR.TOC("matff","J3d2G1-f3r168aB0.m",2);
AGR.TOC("matff","J3d2G1-f3r306aB0.m",2);
AGR.TOC("matff","J3d2G1-f3r324aB0.m",2);
AGR.TOC("matff","J3d2G1-f3r934aB0.m",2);
AGR.TOC("matff","J3d2G1-f5r170aB0.m",2);
AGR.TOC("matff","J3d2G1-f5r323bB0.m",2);
AGR.TOC("matff","J3d2G1-f5r646aB0.m",2);
AGR.TOC("matff","J3d2G1-f5r816aB0.m",2);
AGR.TOC("matff","J3d2G1-f17r170aB0.m",2);
AGR.TOC("matff","J3d2G1-f17r324aB0.m",2);
AGR.TOC("matff","J3d2G1-f17r379aB0.m",2);
AGR.TOC("matff","J3d2G1-f17r646aB0.m",2);
AGR.TOC("matff","J3d2G1-f17r836aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r85aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r110aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r214aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r214bB0.m",2);
AGR.TOC("matff","J3d2G1-f19r646aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r706aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r919aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r1001aB0.m",2);
AGR.TOC("matff","J3d2G1-f19r1214aB0.m",2);
AGR.TOC("maxes","J3d2G1-max1W1");
AGR.TOC("maxes","J3d2G1-max1W2");
AGR.TOC("maxes","J3d2G1-max2W1");
AGR.TOC("maxes","J3d2G1-max2W2");
AGR.TOC("maxes","J3d2G1-max3W1");
AGR.TOC("maxes","J3d2G1-max3W2");
AGR.TOC("maxes","J3d2G1-max4W1");
AGR.TOC("maxes","J3d2G1-max4W2");
AGR.TOC("maxes","J3d2G1-max4W3");
AGR.TOC("maxes","J3d2G1-max5W1");
AGR.TOC("maxes","J3d2G1-max5W2");
AGR.TOC("maxes","J3d2G1-max6W1");
AGR.TOC("maxes","J3d2G1-max6W2");
AGR.TOC("maxes","J3d2G1-max7W1");
AGR.TOC("maxes","J3d2G1-max7W2");
AGR.TOC("maxes","J3d2G1-max8W1");
AGR.TOC("maxes","J3d2G1-max8W2");
AGR.TOC("maxes","J3d2G1-max9W1");
AGR.TOC("maxes","J3d2G1-max9W2");
AGR.TOC("cyclic","J3d2G1-cycW1");
AGR.TOC("find","J3d2G1-find1");
AGR.TOC("check","J3d2G1-check1");
AGR.TOC("pres","J3d2G1-P1");

# J4
AGR.GRP("spor","J4","J4");
AGR.TOC("matff","J4G1-f2r112B0.m",2);
AGR.TOC("matff","J4G1-f2r1220aB0.m",2);
AGR.TOC("matff","J4G1-f11r1333B0.m",2);
AGR.TOC("maxes","J4G1-max1W1");
AGR.TOC("maxes","J4G1-max2W1");
AGR.TOC("maxes","J4G1-max3W1");
AGR.TOC("maxes","J4G1-max4W1");
AGR.TOC("maxes","J4G1-max5W1");
AGR.TOC("maxes","J4G1-max6W1");
AGR.TOC("maxes","J4G1-max7W1");
AGR.TOC("maxes","J4G1-max8W1");
AGR.TOC("maxes","J4G1-max9W1");
AGR.TOC("maxes","J4G1-max10W1");
AGR.TOC("maxes","J4G1-max11W1");
AGR.TOC("maxes","J4G1-max12W1");
AGR.TOC("maxes","J4G1-max13W1");
AGR.TOC("cyclic","J4G1-cycW1");
AGR.TOC("switch","J4G1-G2W1");
AGR.TOC("find","J4G1-find1");
AGR.TOC("check","J4G1-check1");

# Ly
AGR.GRP("spor","Ly","Ly");
AGR.TOC("matff","LyG1-f3r651B0.m",2);
AGR.TOC("matff","LyG1-f4r2480B0.m",2);
AGR.TOC("matff","LyG1-f5r111B0.m",2);
AGR.TOC("matff","LyG1-f5r517B0.m",2);
AGR.TOC("matff","LyG1-f5r2480aB0.m",2);
AGR.TOC("matff","LyG1-f5r2480bB0.m",2);
AGR.TOC("maxes","LyG1-max1W1");
AGR.TOC("maxes","LyG1-max2W1");
AGR.TOC("maxes","LyG1-max3W1");
AGR.TOC("maxes","LyG1-max4W1");
AGR.TOC("maxes","LyG1-max5W1");
AGR.TOC("maxes","LyG1-max6W1");
AGR.TOC("maxes","LyG1-max7W1");
AGR.TOC("maxes","LyG1-max8W1");
AGR.TOC("maxes","LyG1-max9W1");
AGR.TOC("cyclic","LyG1-cycW1");
AGR.TOC("cyc2ccl","LyG1cycW1-cclsW1");
AGR.TOC("find","LyG1-find1");
AGR.TOC("check","LyG1-check1");

# M
AGR.GRP("spor","M","M");
AGR.TOC("find","MG1-find1");
AGR.TOC("check","MG1-check1");

# M3max7
AGR.GRP("spor","M","M3max7");
AGR.TOC("matff","M3max7G0-f3r38B0.m",4);

# Mmax10
AGR.GRP("spor","M","Mmax10");
AGR.TOC("perm","Mmax10G0-p1032192B0.m",2);

# Mmax11
AGR.GRP("spor","M","Mmax11");
AGR.TOC("perm","Mmax11G0-p805896B0.m",2);
AGR.TOC("matff","Mmax11G0-f3r204B0.m",2);

# Mmax12
AGR.GRP("spor","M","Mmax12");
AGR.TOC("matff","Mmax12G0-f5r135B0.m",2);

# Mmax13
AGR.GRP("spor","M","Mmax13");
AGR.TOC("perm","Mmax13G0-p3369B0.m",2);

# Mmax14
AGR.GRP("spor","M","Mmax14");
AGR.TOC("perm","Mmax14G0-p34992B0.m",2);
AGR.TOC("perm","Mmax14G0-p69984B0.m",2);

# Mmax15
AGR.GRP("spor","M","Mmax15");
AGR.TOC("perm","Mmax15G0-p85293B0.m",2);
AGR.TOC("perm","Mmax15G0-p113724B0.m",2);
AGR.TOC("perm","Mmax15G0-p227448B0.m",2);

# Mmax15q1
AGR.GRP("spor","M","Mmax15q1");
AGR.TOC("perm","Mmax15q1G0-p6561B0.m",2);

# Mmax15q2
AGR.GRP("spor","M","Mmax15q2");
AGR.TOC("perm","Mmax15q2G0-p1404B0.m",2);

# Mmax15q3
AGR.GRP("spor","M","Mmax15q3");
AGR.TOC("perm","Mmax15q3G0-p108B0.m",2);

# Mmax16
AGR.GRP("spor","M","Mmax16");
AGR.TOC("perm","Mmax16G0-p78125B0.m",2);
AGR.TOC("matff","Mmax16G0-f5r8B0.m",2);

# Mmax17
AGR.GRP("spor","M","Mmax17");
AGR.TOC("perm","Mmax17G0-p2065B0.m",2);

# Mmax18
AGR.GRP("spor","M","Mmax18");
AGR.TOC("perm","Mmax18G0-p17B0.m",2);

# Mmax19
AGR.GRP("spor","M","Mmax19");
AGR.TOC("perm","Mmax19G0-p7750B0.m",2);
AGR.TOC("perm","Mmax19G0-p46500B0.m",2);
AGR.TOC("perm","Mmax19G0-p96875B0.m",2);
AGR.TOC("matff","Mmax19G0-f5r46B0.m",2);

# Mmax20
AGR.GRP("spor","M","Mmax20");
AGR.TOC("perm","Mmax20G0-p30B0.m",2);

# Mmax21
AGR.GRP("spor","M","Mmax21");
AGR.TOC("perm","Mmax21G0-p518B0.m",2);
AGR.TOC("perm","Mmax21G0-p3653B0.m",2);
AGR.TOC("matff","Mmax21G0-f2r28B0.m",2);

# Mmax22
AGR.GRP("spor","M","Mmax22");
AGR.TOC("perm","Mmax22G0-p750B0.m",2);
AGR.TOC("perm","Mmax22G0-p15625B0.m",2);

# Mmax23
AGR.GRP("spor","M","Mmax23");
AGR.TOC("perm","Mmax23G0-p184B0.m",2);
AGR.TOC("perm","Mmax23G0-p524B0.m",2);
AGR.TOC("matff","Mmax23G0-f2r22B0.m",2);

# Mmax24
AGR.GRP("spor","M","Mmax24");
AGR.TOC("perm","Mmax24G0-p16807B0.m",2);
AGR.TOC("matff","Mmax24G0-f7r6B0.m",2);

# Mmax25
AGR.GRP("spor","M","Mmax25");
AGR.TOC("perm","Mmax25G0-p151B0.m",2);

# Mmax26
AGR.GRP("spor","M","Mmax26");
AGR.TOC("perm","Mmax26G0-p36B0.m",2);

# Mmax27
AGR.GRP("spor","M","Mmax27");
AGR.TOC("perm","Mmax27G0-p17B0.m",2);

# Mmax28
AGR.GRP("spor","M","Mmax28");
AGR.TOC("perm","Mmax28G0-p625B0.m",2);
AGR.TOC("matff","Mmax28G0-f5r5B0.m",2);

# Mmax29
AGR.GRP("spor","M","Mmax29");
AGR.TOC("perm","Mmax29G0-p392B0.m",2);
AGR.TOC("perm","Mmax29G0-p2401B0.m",2);
AGR.TOC("matff","Mmax29G0-f7r7B0.m",2);

# Mmax30
AGR.GRP("spor","M","Mmax30");
AGR.TOC("perm","Mmax30G0-p21B0.m",2);

# Mmax31
AGR.GRP("spor","M","Mmax31");
AGR.TOC("perm","Mmax31G0-p15B0.m",2);

# Mmax32
AGR.GRP("spor","M","Mmax32");
AGR.TOC("perm","Mmax32G0-p24B0.m",2);

# Mmax33
AGR.GRP("spor","M","Mmax33");
AGR.TOC("perm","Mmax33G0-p169B0.m",2);
AGR.TOC("matff","Mmax33G0-f13r3B0.m",2);

# Mmax34
AGR.GRP("spor","M","Mmax34");
AGR.TOC("perm","Mmax34G0-p57B0.m",2);

# Mmax35
AGR.GRP("spor","M","Mmax35");
AGR.TOC("perm","Mmax35G0-p39B0.m",2);

# Mmax36
AGR.GRP("spor","M","Mmax36");
AGR.TOC("perm","Mmax36G0-p2197B0.m",2);
AGR.TOC("matff","Mmax36G0-f13r4B0.m",2);

# Mmax39
AGR.GRP("spor","M","Mmax39");
AGR.TOC("perm","Mmax39G0-p121B0.m",2);
AGR.TOC("matff","Mmax39G0-f11r3B0.m",2);

# Mmax4
AGR.GRP("spor","M","Mmax4");
AGR.TOC("matff","Mmax4G0-f2r1708B0.m",2);

# Mmax41
AGR.GRP("spor","M","Mmax41");
AGR.TOC("perm","Mmax41G0-p49B0.m",2);
AGR.TOC("matff","Mmax41G0-f7r3B0.m",2);

# Mmax43
AGR.GRP("spor","M","Mmax43");
AGR.TOC("perm","Mmax43G0-p41B0.m",2);

# Mmax6
AGR.GRP("spor","M","Mmax6");
AGR.TOC("perm","Mmax6G0-p294912B0.m",2);

# Mmax7
AGR.GRP("spor","M","Mmax7");
AGR.TOC("matff","Mmax7G0-f3r78B0.m",3);

# Mmax9
AGR.GRP("spor","M","Mmax9");
AGR.TOC("matff","Mmax9G0-f2r250B0.m",2);

# M11
AGR.GRP("spor","M11","M11");
AGR.TOC("perm","M11G1-p11B0.m",2);
AGR.TOC("perm","M11G1-p12B0.m",2);
AGR.TOC("perm","M11G1-p55B0.m",2);
AGR.TOC("perm","M11G1-p66B0.m",2);
AGR.TOC("perm","M11G1-p165B0.m",2);
AGR.TOC("matff","M11G1-f2r10B0.m",2);
AGR.TOC("matff","M11G1-f2r32B0.m",2);
AGR.TOC("matff","M11G1-f2r44B0.m",2);
AGR.TOC("matff","M11G1-f3r5aB0.m",2);
AGR.TOC("matff","M11G1-f3r5bB0.m",2);
AGR.TOC("matff","M11G1-f3r10aB0.m",2);
AGR.TOC("matff","M11G1-f3r10bB0.m",2);
AGR.TOC("matff","M11G1-f3r10cB0.m",2);
AGR.TOC("matff","M11G1-f3r24B0.m",2);
AGR.TOC("matff","M11G1-f3r45B0.m",2);
AGR.TOC("matff","M11G1-f4r16aB0.m",2);
AGR.TOC("matff","M11G1-f4r16bB0.m",2);
AGR.TOC("matff","M11G1-f5r10aB0.m",2);
AGR.TOC("matff","M11G1-f5r11B0.m",2);
AGR.TOC("matff","M11G1-f5r16aB0.m",2);
AGR.TOC("matff","M11G1-f5r16bB0.m",2);
AGR.TOC("matff","M11G1-f5r20B0.m",2);
AGR.TOC("matff","M11G1-f5r45B0.m",2);
AGR.TOC("matff","M11G1-f5r55B0.m",2);
AGR.TOC("matff","M11G1-f11r9B0.m",2);
AGR.TOC("matff","M11G1-f11r10aB0.m",2);
AGR.TOC("matff","M11G1-f11r10bB0.m",2);
AGR.TOC("matff","M11G1-f11r11B0.m",2);
AGR.TOC("matff","M11G1-f11r16B0.m",2);
AGR.TOC("matff","M11G1-f11r44B0.m",2);
AGR.TOC("matff","M11G1-f11r55B0.m",2);
AGR.TOC("matff","M11G1-f25r10bB0.m",2);
AGR.TOC("matff","M11G1-f25r10cB0.m",2);
AGR.TOC("matint","M11G1-Zr10aB0.g");
AGR.TOC("matint","M11G1-Zr11B0.g");
AGR.TOC("matint","M11G1-Zr20B0.g");
AGR.TOC("matint","M11G1-Zr32B0.g");
AGR.TOC("matint","M11G1-Zr44B0.g");
AGR.TOC("matint","M11G1-Zr45B0.g");
AGR.TOC("matint","M11G1-Zr55B0.g");
AGR.TOC("matalg","M11G1-Ar10bB0.g");
AGR.TOC("matalg","M11G1-Ar10cB0.g");
AGR.TOC("maxes","M11G1-max1W1");
AGR.TOC("maxes","M11G1-max2W1");
AGR.TOC("maxes","M11G1-max3W1");
AGR.TOC("maxes","M11G1-max4W1");
AGR.TOC("maxes","M11G1-max5W1");
AGR.TOC("classes","M11G1-cclsW1");
AGR.TOC("cyclic","M11G1-cycW1");
AGR.TOC("cyc2ccl","M11G1cycW1-cclsW1");
AGR.TOC("maxstd","M11G1max1W1-M10G1W1");
AGR.TOC("maxstd","M11G1max2W1-L211G1W1");
AGR.TOC("maxstd","M11G1max4W1-S5G1W1");
AGR.TOC("find","M11G1-find1");
AGR.TOC("check","M11G1-check1");
AGR.TOC("pres","M11G1-P1");

# 2M12
AGR.GRP("spor","M12","2M12");
AGR.TOC("perm","2M12G1-p24aB0.m",2);
AGR.TOC("matff","2M12G1-f3r6bB0.m",2);
AGR.TOC("matff","2M12G1-f5r12B0.m",2);
AGR.TOC("matint","2M12G1-Zr12B0.g");
AGR.TOC("matint","2M12G1-Zr120B0.g");
AGR.TOC("matint","2M12G1-Zr220B0.g");
AGR.TOC("pres","2M12G1-P1");

# 2M12d2
AGR.GRP("spor","M12","2M12d2");
AGR.TOC("perm","2M12d2G1-p48B0.m",2);
AGR.TOC("matff","2M12d2G1-f3r10aB0.m",2);
AGR.TOC("matff","2M12d2G1-f3r10bB0.m",2);
AGR.TOC("matff","2M12d2G1-f3r10cB0.m",2);
AGR.TOC("matff","2M12d2G1-f3r12B0.m",2);
AGR.TOC("matff","2M12d2G1-f3r12aB0.m",2);
AGR.TOC("matff","2M12d2G1-f3r88aB0.m",2);
AGR.TOC("matff","2M12d2G1-f3r168aB0.m",2);
AGR.TOC("matff","2M12d2G1-f5r120bB0.m",2);
AGR.TOC("matff","2M12d2G1-f5r220aB0.m",2);
AGR.TOC("matff","2M12d2G1-f5r320aB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r10aB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r10bB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r12aB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r32aB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r88aB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r108aB0.m",2);
AGR.TOC("matff","2M12d2G1-f11r220aB0.m",2);
AGR.TOC("matff","2M12d2G1-f25r10aB0.m",2);
AGR.TOC("matff","2M12d2G1-f25r10bB0.m",2);
AGR.TOC("matff","2M12d2G1-f25r12aB0.m",2);
AGR.TOC("matff","2M12d2G1-f25r32bB0.m",2);

# M12
AGR.GRP("spor","M12","M12");
AGR.TOC("perm","M12G1-p12aB0.m",2);
AGR.TOC("perm","M12G1-p12bB0.m",2);
AGR.TOC("perm","M12G1-p66aB0.m",2);
AGR.TOC("perm","M12G1-p66bB0.m",2);
AGR.TOC("matff","M12G1-f2r10B0.m",2);
AGR.TOC("matff","M12G1-f2r44B0.m",2);
AGR.TOC("matff","M12G1-f2r144B0.m",2);
AGR.TOC("matff","M12G1-f3r10aB0.m",2);
AGR.TOC("matff","M12G1-f3r15bB0.m",2);
AGR.TOC("matff","M12G1-f3r34B0.m",2);
AGR.TOC("matff","M12G1-f3r45aB0.m",2);
AGR.TOC("matff","M12G1-f3r45bB0.m",2);
AGR.TOC("matff","M12G1-f3r54B0.m",2);
AGR.TOC("matff","M12G1-f3r99B0.m",2);
AGR.TOC("matff","M12G1-f4r16aB0.m",2);
AGR.TOC("matff","M12G1-f4r16bB0.m",2);
AGR.TOC("matff","M12G1-f5r11aB0.m",2);
AGR.TOC("matff","M12G1-f5r16bB0.m",2);
AGR.TOC("matff","M12G1-f5r45B0.m",2);
AGR.TOC("matff","M12G1-f5r55aB0.m",2);
AGR.TOC("matff","M12G1-f5r55cB0.m",2);
AGR.TOC("matff","M12G1-f5r66B0.m",2);
AGR.TOC("matff","M12G1-f5r78B0.m",2);
AGR.TOC("matff","M12G1-f5r98B0.m",2);
AGR.TOC("matff","M12G1-f5r120B0.m",2);
AGR.TOC("matff","M12G1-f11r11aB0.m",2);
AGR.TOC("matff","M12G1-f11r16B0.m",2);
AGR.TOC("matff","M12G1-f11r29B0.m",2);
AGR.TOC("matff","M12G1-f11r53B0.m",2);
AGR.TOC("matff","M12G1-f11r55aB0.m",2);
AGR.TOC("matff","M12G1-f11r55cB0.m",2);
AGR.TOC("matff","M12G1-f11r66B0.m",2);
AGR.TOC("matff","M12G1-f11r91B0.m",2);
AGR.TOC("matff","M12G1-f11r99B0.m",2);
AGR.TOC("matff","M12G1-f11r176B0.m",2);
AGR.TOC("matint","M12G1-Zr11aB0.g");
AGR.TOC("matint","M12G1-Zr11bB0.g");
AGR.TOC("matint","M12G1-Zr32B0.g");
AGR.TOC("matint","M12G1-Zr45B0.g");
AGR.TOC("matint","M12G1-Zr54B0.g");
AGR.TOC("matint","M12G1-Zr55aB0.g");
AGR.TOC("matint","M12G1-Zr55bB0.g");
AGR.TOC("matint","M12G1-Zr55cB0.g");
AGR.TOC("matint","M12G1-Zr66B0.g");
AGR.TOC("matint","M12G1-Zr99B0.g");
AGR.TOC("matint","M12G1-Zr120B0.g");
AGR.TOC("matint","M12G1-Zr144B0.g");
AGR.TOC("matint","M12G1-Zr176B0.g");
AGR.TOC("maxes","M12G1-max1W1");
AGR.TOC("maxes","M12G1-max2W1");
AGR.TOC("maxes","M12G1-max3W1");
AGR.TOC("maxes","M12G1-max4W1");
AGR.TOC("maxes","M12G1-max5W1");
AGR.TOC("maxes","M12G1-max6W1");
AGR.TOC("maxes","M12G1-max7W1");
AGR.TOC("maxes","M12G1-max8W1");
AGR.TOC("maxes","M12G1-max9W1");
AGR.TOC("maxes","M12G1-max9W2");
AGR.TOC("maxes","M12G1-max10W1");
AGR.TOC("maxes","M12G1-max11W1");
AGR.TOC("cyclic","M12G1-cycW1");
AGR.TOC("cyc2ccl","M12G1cycW1-cclsW1");
AGR.TOC("find","M12G1-find1");
AGR.TOC("check","M12G1-check1");
AGR.TOC("pres","M12G1-P1");

# M12d2
AGR.GRP("spor","M12","M12d2");
AGR.TOC("perm","M12d2G1-p24B0.m",2);
AGR.TOC("matff","M12d2G1-f2r10B0.m",2);
AGR.TOC("matff","M12d2G1-f2r32B0.m",2);
AGR.TOC("matff","M12d2G1-f2r44B0.m",2);
AGR.TOC("matff","M12d2G1-f2r144B0.m",2);
AGR.TOC("matff","M12d2G1-f3r20aB0.m",2);
AGR.TOC("matff","M12d2G1-f3r30aB0.m",2);
AGR.TOC("matff","M12d2G1-f3r34aB0.m",2);
AGR.TOC("matff","M12d2G1-f3r45aB0.m",2);
AGR.TOC("matff","M12d2G1-f3r90aB0.m",2);
AGR.TOC("matff","M12d2G1-f3r99aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r22aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r32aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r45aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r55aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r66aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r78aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r98aB0.m",2);
AGR.TOC("matff","M12d2G1-f5r110aB0.m",2);
AGR.TOC("matff","M12d2G1-f9r54aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r16aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r22aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r29aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r53aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r55aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r66aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r91aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r99aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r110aB0.m",2);
AGR.TOC("matff","M12d2G1-f11r176aB0.m",2);
AGR.TOC("matff","M12d2G1-f25r120aB0.m",2);
AGR.TOC("maxes","M12d2G1-max2W1");
AGR.TOC("maxes","M12d2G1-max2W2");
AGR.TOC("maxes","M12d2G1-max3W1");
AGR.TOC("maxes","M12d2G1-max3W2");
AGR.TOC("maxes","M12d2G1-max4W1");
AGR.TOC("maxes","M12d2G1-max5W1");
AGR.TOC("maxes","M12d2G1-max6W1");
AGR.TOC("maxes","M12d2G1-max7W1");
AGR.TOC("maxes","M12d2G1-max8W1");
AGR.TOC("maxes","M12d2G1-max9W1");
AGR.TOC("cyclic","M12d2G1-cycW1");
AGR.TOC("find","M12d2G1-find1");
AGR.TOC("check","M12d2G1-check1");
AGR.TOC("pres","M12d2G1-P1");
AGR.TOC("pres","M12d2G1-P2");

# 12M22
AGR.GRP("spor","M22","12M22");
AGR.TOC("perm","12M22G1-p31680aB0.m",2);
AGR.TOC("matff","12M22G1-f25r48aB0.m",2);
AGR.TOC("matff","12M22G1-f25r120aB0.m",2);
AGR.TOC("matff","12M22G1-f25r120bB0.m",2);
AGR.TOC("matff","12M22G1-f25r144aB0.m",2);
AGR.TOC("matff","12M22G1-f25r144bB0.m",2);
AGR.TOC("matff","12M22G1-f25r336aB0.m",2);
AGR.TOC("matff","12M22G1-f49r120aB0.m",2);
AGR.TOC("matff","12M22G1-f49r120bB0.m",2);
AGR.TOC("matff","12M22G1-f49r144aB0.m",2);
AGR.TOC("matff","12M22G1-f49r336aB0.m",2);
AGR.TOC("matff","12M22G1-f49r336bB0.m",2);
AGR.TOC("matff","12M22G1-f121r24aB0.m",2);
AGR.TOC("matff","12M22G1-f121r24bB0.m",2);
AGR.TOC("matff","12M22G1-f121r96aB0.m",2);
AGR.TOC("matff","12M22G1-f121r120aB0.m",2);
AGR.TOC("matff","12M22G1-f121r120bB0.m",2);
AGR.TOC("matff","12M22G1-f121r120cB0.m",2);
AGR.TOC("matff","12M22G1-f121r120dB0.m",2);
AGR.TOC("matff","12M22G1-f121r144aB0.m",2);
AGR.TOC("matff","12M22G1-f121r144bB0.m",2);
AGR.TOC("matff","12M22G1-f121r336aB0.m",2);

# 12M22d2
AGR.GRP("spor","M22","12M22d2");
AGR.TOC("matff","12M22d2G1-f11r48B0.m",2);

# 2M22
AGR.GRP("spor","M22","2M22");
AGR.TOC("perm","2M22G1-p352aB0.m",2);
AGR.TOC("perm","2M22G1-p660B0.m",2);
AGR.TOC("matff","2M22G1-f3r56B0.m",2);
AGR.TOC("matff","2M22G1-f3r120B0.m",2);
AGR.TOC("matff","2M22G1-f3r126bB0.m",2);
AGR.TOC("matff","2M22G1-f3r210B0.m",2);
AGR.TOC("matff","2M22G1-f5r28aB0.m",2);
AGR.TOC("matff","2M22G1-f5r28bB0.m",2);
AGR.TOC("matff","2M22G1-f5r120B0.m",2);
AGR.TOC("matff","2M22G1-f5r210B0.m",2);
AGR.TOC("matff","2M22G1-f5r330B0.m",2);
AGR.TOC("matff","2M22G1-f5r440B0.m",2);
AGR.TOC("matff","2M22G1-f7r10B0.m",2);
AGR.TOC("matff","2M22G1-f7r56B0.m",2);
AGR.TOC("matff","2M22G1-f7r120B0.m",2);
AGR.TOC("matff","2M22G1-f7r210B0.m",2);
AGR.TOC("matff","2M22G1-f7r252B0.m",2);
AGR.TOC("matff","2M22G1-f7r308B0.m",2);
AGR.TOC("matff","2M22G1-f7r320B0.m",2);
AGR.TOC("matff","2M22G1-f9r10aB0.m",2);
AGR.TOC("matff","2M22G1-f9r10bB0.m",2);
AGR.TOC("matff","2M22G1-f9r154B0.m",2);
AGR.TOC("matff","2M22G1-f11r10aB0.m",2);
AGR.TOC("matff","2M22G1-f11r10bB0.m",2);
AGR.TOC("matff","2M22G1-f11r56B0.m",2);
AGR.TOC("matff","2M22G1-f11r64B0.m",2);
AGR.TOC("matff","2M22G1-f11r126B0.m",2);
AGR.TOC("matff","2M22G1-f11r308B0.m",2);
AGR.TOC("matff","2M22G1-f11r330B0.m",2);
AGR.TOC("matff","2M22G1-f11r440B0.m",2);
AGR.TOC("matff","2M22G1-f25r10aB0.m",2);
AGR.TOC("matff","2M22G1-f25r10bB0.m",2);
AGR.TOC("matff","2M22G1-f25r126aB0.m",2);
AGR.TOC("matff","2M22G1-f49r126aB0.m",2);
AGR.TOC("matff","2M22G1-f49r126bB0.m",2);
AGR.TOC("matff","2M22G1-f49r154aB0.m",2);
AGR.TOC("matff","2M22G1-f49r154bB0.m",2);
AGR.TOC("matff","2M22G1-f121r154aB0.m",2);
AGR.TOC("matff","2M22G1-f121r154bB0.m",2);
AGR.TOC("matint","2M22G1-Zr20B0.g");
AGR.TOC("matint","2M22G1-Zr56B0.g");
AGR.TOC("matint","2M22G1-Zr120B0.g");
AGR.TOC("matint","2M22G1-Zr210B0.g");
AGR.TOC("matmodn","2M22G1-Z4r10aB0.g");

# 2M22d2
AGR.GRP("spor","M22","2M22d2");
AGR.TOC("matff","2M22d2G1-f7r10aB0.m",2);
AGR.TOC("matff","2M22d2G1-f9r10bB0.m",2);
AGR.TOC("matff","2M22d2G1-f11r10bB0.m",2);
AGR.TOC("matff","2M22d2G1-f25r10bB0.m",2);

# 3M22
AGR.GRP("spor","M22","3M22");
AGR.TOC("perm","3M22G1-p693B0.m",2);
AGR.TOC("perm","3M22G1-p990B0.m",2);
AGR.TOC("perm","3M22G1-p2016B0.m",2);
AGR.TOC("matff","3M22G1-f4r6aB0.m",2);
AGR.TOC("matff","3M22G1-f4r15aB0.m",2);
AGR.TOC("matff","3M22G1-f4r45aB0.m",2);
AGR.TOC("matff","3M22G1-f4r45bB0.m",2);
AGR.TOC("matff","3M22G1-f4r84aB0.m",2);
AGR.TOC("matff","3M22G1-f4r384aB0.m",2);
AGR.TOC("matff","3M22G1-f7r21aB0.m",2);
AGR.TOC("matff","3M22G1-f7r45aB0.m",2);
AGR.TOC("matff","3M22G1-f7r99aB0.m",2);
AGR.TOC("matff","3M22G1-f7r210aB0.m",2);
AGR.TOC("matff","3M22G1-f7r210bB0.m",2);
AGR.TOC("matff","3M22G1-f7r231aB0.m",2);
AGR.TOC("matff","3M22G1-f7r231bB0.m",2);
AGR.TOC("matff","3M22G1-f7r285aB0.m",2);
AGR.TOC("matff","3M22G1-f25r21aB0.m",2);
AGR.TOC("matff","3M22G1-f25r45aB0.m",2);
AGR.TOC("matff","3M22G1-f25r45bB0.m",2);
AGR.TOC("matff","3M22G1-f25r78aB0.m",2);
AGR.TOC("matff","3M22G1-f25r105aB0.m",2);
AGR.TOC("matff","3M22G1-f25r105bB0.m",2);
AGR.TOC("matff","3M22G1-f25r153aB0.m",2);
AGR.TOC("matff","3M22G1-f25r210aB0.m",2);
AGR.TOC("matff","3M22G1-f25r231aB0.m",2);
AGR.TOC("matff","3M22G1-f25r330aB0.m",2);
AGR.TOC("matff","3M22G1-f49r105aB0.m",2);
AGR.TOC("matff","3M22G1-f49r105bB0.m",2);
AGR.TOC("matff","3M22G1-f121r21aB0.m",2);
AGR.TOC("matff","3M22G1-f121r21a1B0.m",2);
AGR.TOC("matff","3M22G1-f121r45aB0.m",2);
AGR.TOC("matff","3M22G1-f121r45bB0.m",2);
AGR.TOC("matff","3M22G1-f121r84aB0.m",2);
AGR.TOC("matff","3M22G1-f121r99aB0.m",2);
AGR.TOC("matff","3M22G1-f121r210aB0.m",2);
AGR.TOC("matff","3M22G1-f121r231aB0.m",2);
AGR.TOC("matff","3M22G1-f121r231bB0.m",2);
AGR.TOC("matff","3M22G1-f121r330aB0.m",2);

# 3M22d2
AGR.GRP("spor","M22","3M22d2");
AGR.TOC("matff","3M22d2G1-f2r12B0.m",2);

# 4M22
AGR.GRP("spor","M22","4M22");
AGR.TOC("perm","4M22G1-p4928aB0.m",2);
AGR.TOC("perm","4M22G1-p4928bB0.m",2);
AGR.TOC("matff","4M22G1-f5r160aB0.m",2);
AGR.TOC("matff","4M22G1-f5r160bB0.m",2);
AGR.TOC("matff","4M22G1-f5r560aB0.m",2);
AGR.TOC("matff","4M22G1-f9r56aB0.m",2);
AGR.TOC("matff","4M22G1-f9r56bB0.m",2);
AGR.TOC("matff","4M22G1-f9r64aB0.m",2);
AGR.TOC("matff","4M22G1-f9r144aB0.m",2);
AGR.TOC("matff","4M22G1-f9r144bB0.m",2);
AGR.TOC("matff","4M22G1-f9r160aB0.m",2);
AGR.TOC("matff","4M22G1-f9r160bB0.m",2);
AGR.TOC("matff","4M22G1-f25r56aB0.m",2);
AGR.TOC("matff","4M22G1-f25r56bB0.m",2);
AGR.TOC("matff","4M22G1-f25r88aB0.m",2);
AGR.TOC("matff","4M22G1-f25r88bB0.m",2);
AGR.TOC("matff","4M22G1-f49r16aB0.m",2);
AGR.TOC("matff","4M22G1-f49r56aB0.m",2);
AGR.TOC("matff","4M22G1-f49r56bB0.m",2);
AGR.TOC("matff","4M22G1-f49r144aB0.m",2);
AGR.TOC("matff","4M22G1-f49r160aB0.m",2);
AGR.TOC("matff","4M22G1-f49r560aB0.m",2);
AGR.TOC("matff","4M22G1-f121r56aB0.m",2);
AGR.TOC("matff","4M22G1-f121r56bB0.m",2);
AGR.TOC("matff","4M22G1-f121r144aB0.m",2);
AGR.TOC("matff","4M22G1-f121r144bB0.m",2);
AGR.TOC("matff","4M22G1-f121r160aB0.m",2);
AGR.TOC("matff","4M22G1-f121r176aB0.m",2);

# 4M22d2
AGR.GRP("spor","M22","4M22d2");
AGR.TOC("matff","4M22d2G1-f7r32B0.m",2);

# 6M22
AGR.GRP("spor","M22","6M22");
AGR.TOC("perm","6M22G1-p1980B0.m",2);
AGR.TOC("matff","6M22G1-f7r54aB0.m",2);
AGR.TOC("matff","6M22G1-f7r66aB0.m",2);
AGR.TOC("matff","6M22G1-f7r210aB0.m",2);
AGR.TOC("matff","6M22G1-f7r252aB0.m",2);
AGR.TOC("matff","6M22G1-f7r330aB0.m",2);
AGR.TOC("matff","6M22G1-f7r420aB0.m",2);
AGR.TOC("matff","6M22G1-f25r66aB0.m",2);
AGR.TOC("matff","6M22G1-f25r66bB0.m",2);
AGR.TOC("matff","6M22G1-f25r120aB0.m",2);
AGR.TOC("matff","6M22G1-f25r126aB0.m",2);
AGR.TOC("matff","6M22G1-f25r126bB0.m",2);
AGR.TOC("matff","6M22G1-f25r210aB0.m",2);
AGR.TOC("matff","6M22G1-f25r210bB0.m",2);
AGR.TOC("matff","6M22G1-f25r210cB0.m",2);
AGR.TOC("matff","6M22G1-f25r330aB0.m",2);
AGR.TOC("matff","6M22G1-f49r126aB0.m",2);
AGR.TOC("matff","6M22G1-f49r126bB0.m",2);
AGR.TOC("matff","6M22G1-f49r210bB0.m",2);
AGR.TOC("matff","6M22G1-f49r210cB0.m",2);
AGR.TOC("matff","6M22G1-f121r36aB0.m",2);
AGR.TOC("matff","6M22G1-f121r36a1B0.m",2);
AGR.TOC("matff","6M22G1-f121r66aB0.m",2);
AGR.TOC("matff","6M22G1-f121r66bB0.m",2);
AGR.TOC("matff","6M22G1-f121r90aB0.m",2);
AGR.TOC("matff","6M22G1-f121r120aB0.m",2);
AGR.TOC("matff","6M22G1-f121r174aB0.m",2);
AGR.TOC("matff","6M22G1-f121r210aB0.m",2);
AGR.TOC("matff","6M22G1-f121r330aB0.m",2);

# 6M22d2
AGR.GRP("spor","M22","6M22d2");
AGR.TOC("matff","6M22d2G1-f11r72B0.m",2);

# M22
AGR.GRP("spor","M22","M22");
AGR.TOC("perm","M22G1-p22B0.m",2);
AGR.TOC("perm","M22G1-p77B0.m",2);
AGR.TOC("perm","M22G1-p176aB0.m",2);
AGR.TOC("perm","M22G1-p176bB0.m",2);
AGR.TOC("perm","M22G1-p231B0.m",2);
AGR.TOC("perm","M22G1-p330B0.m",2);
AGR.TOC("perm","M22G1-p462aB0.m",2);
AGR.TOC("perm","M22G1-p462bB0.m",2);
AGR.TOC("perm","M22G1-p462cB0.m",2);
AGR.TOC("perm","M22G1-p616B0.m",2);
AGR.TOC("perm","M22G1-p672B0.m",2);
AGR.TOC("perm","M22G1-p770B0.m",2);
AGR.TOC("matff","M22G1-f2r10aB0.m",2);
AGR.TOC("matff","M22G1-f2r10bB0.m",2);
AGR.TOC("matff","M22G1-f2r34B0.m",2);
AGR.TOC("matff","M22G1-f2r98B0.m",2);
AGR.TOC("matff","M22G1-f3r21B0.m",2);
AGR.TOC("matff","M22G1-f3r49aB0.m",2);
AGR.TOC("matff","M22G1-f3r49bB0.m",2);
AGR.TOC("matff","M22G1-f3r55B0.m",2);
AGR.TOC("matff","M22G1-f3r99B0.m",2);
AGR.TOC("matff","M22G1-f3r210B0.m",2);
AGR.TOC("matff","M22G1-f3r231B0.m",2);
AGR.TOC("matff","M22G1-f4r70aB0.m",2);
AGR.TOC("matff","M22G1-f4r70bB0.m",2);
AGR.TOC("matff","M22G1-f5r21B0.m",2);
AGR.TOC("matff","M22G1-f5r55B0.m",2);
AGR.TOC("matff","M22G1-f5r98B0.m",2);
AGR.TOC("matff","M22G1-f5r133B0.m",2);
AGR.TOC("matff","M22G1-f5r210B0.m",2);
AGR.TOC("matff","M22G1-f5r280aB0.m",2);
AGR.TOC("matff","M22G1-f5r385B0.m",2);
AGR.TOC("matff","M22G1-f7r21B0.m",2);
AGR.TOC("matff","M22G1-f7r45B0.m",2);
AGR.TOC("matff","M22G1-f7r54B0.m",2);
AGR.TOC("matff","M22G1-f7r154B0.m",2);
AGR.TOC("matff","M22G1-f7r210B0.m",2);
AGR.TOC("matff","M22G1-f7r231B0.m",2);
AGR.TOC("matff","M22G1-f7r385B0.m",2);
AGR.TOC("matff","M22G1-f9r45aB0.m",2);
AGR.TOC("matff","M22G1-f11r20B0.m",2);
AGR.TOC("matff","M22G1-f11r45aB0.m",2);
AGR.TOC("matff","M22G1-f11r45bB0.m",2);
AGR.TOC("matff","M22G1-f11r55B0.m",2);
AGR.TOC("matff","M22G1-f11r99B0.m",2);
AGR.TOC("matff","M22G1-f11r154B0.m",2);
AGR.TOC("matff","M22G1-f11r190B0.m",2);
AGR.TOC("matff","M22G1-f11r231B0.m",2);
AGR.TOC("matff","M22G1-f11r385B0.m",2);
AGR.TOC("matff","M22G1-f25r45aB0.m",2);
AGR.TOC("matff","M22G1-f49r280aB0.m",2);
AGR.TOC("matff","M22G1-f49r280bB0.m",2);
AGR.TOC("matint","M22G1-Zr21B0.g");
AGR.TOC("matint","M22G1-Zr55B0.g");
AGR.TOC("matint","M22G1-Zr99B0.g");
AGR.TOC("matint","M22G1-Zr154B0.g");
AGR.TOC("matint","M22G1-Zr210B0.g");
AGR.TOC("matint","M22G1-Zr231B0.g");
AGR.TOC("maxes","M22G1-max1W1");
AGR.TOC("maxes","M22G1-max2W1");
AGR.TOC("maxes","M22G1-max3W1");
AGR.TOC("maxes","M22G1-max4W1");
AGR.TOC("maxes","M22G1-max5W1");
AGR.TOC("maxes","M22G1-max6W1");
AGR.TOC("maxes","M22G1-max7W1");
AGR.TOC("maxes","M22G1-max7W2");
AGR.TOC("maxes","M22G1-max8W1");
AGR.TOC("cyclic","M22G1-cycW1");
AGR.TOC("cyclic","M22G1-cycW2");
AGR.TOC("cyc2ccl","M22G1cycW1-cclsW1");
AGR.TOC("find","M22G1-find1");
AGR.TOC("check","M22G1-check1");
AGR.TOC("pres","M22G1-P1");

# M22d2
AGR.GRP("spor","M22","M22d2");
AGR.TOC("perm","M22d2G1-p22B0.m",2);
AGR.TOC("perm","M22d2G1-p77B0.m",2);
AGR.TOC("perm","M22d2G1-p231B0.m",2);
AGR.TOC("perm","M22d2G1-p330B0.m",2);
AGR.TOC("perm","M22d2G1-p352B0.m",2);
AGR.TOC("perm","M22d2G1-p616B0.m",2);
AGR.TOC("perm","M22d2G1-p672B0.m",2);
AGR.TOC("matff","M22d2G1-f2r10aB0.m",2);
AGR.TOC("matff","M22d2G1-f2r10bB0.m",2);
AGR.TOC("matff","M22d2G1-f2r34B0.m",2);
AGR.TOC("matff","M22d2G1-f2r98B0.m",2);
AGR.TOC("matff","M22d2G1-f2r140B0.m",2);
AGR.TOC("matff","M22d2G1-f3r21aB0.m",2);
AGR.TOC("matff","M22d2G1-f3r55aB0.m",2);
AGR.TOC("matff","M22d2G1-f3r98B0.m",2);
AGR.TOC("matff","M22d2G1-f3r99aB0.m",2);
AGR.TOC("matff","M22d2G1-f3r210aB0.m",2);
AGR.TOC("matff","M22d2G1-f3r231aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r21aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r55aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r98aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r133aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r210aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r385aB0.m",2);
AGR.TOC("matff","M22d2G1-f5r560B0.m",2);
AGR.TOC("matff","M22d2G1-f7r21aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r45aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r54aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r154aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r210aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r231aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r385aB0.m",2);
AGR.TOC("matff","M22d2G1-f7r560B0.m",2);
AGR.TOC("matff","M22d2G1-f9r45aB0.m",2);
AGR.TOC("matff","M22d2G1-f9r45bB0.m",2);
AGR.TOC("matff","M22d2G1-f11r20aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r45aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r45bB0.m",2);
AGR.TOC("matff","M22d2G1-f11r55aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r99aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r154aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r190aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r231aB0.m",2);
AGR.TOC("matff","M22d2G1-f11r385aB0.m",2);
AGR.TOC("matff","M22d2G1-f25r45aB0.m",2);
AGR.TOC("matff","M22d2G1-f25r45bB0.m",2);
AGR.TOC("maxes","M22d2G1-max1W1");
AGR.TOC("maxes","M22d2G1-max1W2");
AGR.TOC("maxes","M22d2G1-max2W1");
AGR.TOC("maxes","M22d2G1-max2W2");
AGR.TOC("maxes","M22d2G1-max3W1");
AGR.TOC("maxes","M22d2G1-max4W1");
AGR.TOC("maxes","M22d2G1-max5W1");
AGR.TOC("maxes","M22d2G1-max5W2");
AGR.TOC("maxes","M22d2G1-max6W1");
AGR.TOC("maxes","M22d2G1-max7W1");
AGR.TOC("maxes","M22d2G1-max7W2");
AGR.TOC("cyclic","M22d2G1-cycW1");
AGR.TOC("cyc2ccl","M22d2G1cycW1-cclsW1");
AGR.TOC("find","M22d2G1-find1");
AGR.TOC("check","M22d2G1-check1");
AGR.TOC("pres","M22d2G1-P1");

# M23
AGR.GRP("spor","M23","M23");
AGR.TOC("perm","M23G1-p23B0.m",2);
AGR.TOC("perm","M23G1-p253aB0.m",2);
AGR.TOC("perm","M23G1-p253bB0.m",2);
AGR.TOC("perm","M23G1-p506B0.m",2);
AGR.TOC("perm","M23G1-p1288B0.m",2);
AGR.TOC("perm","M23G1-p1771B0.m",2);
AGR.TOC("perm","M23G1-p40320B0.m",2);
AGR.TOC("matff","M23G1-f2r11aB0.m",2);
AGR.TOC("matff","M23G1-f2r11bB0.m",2);
AGR.TOC("matff","M23G1-f2r44aB0.m",2);
AGR.TOC("matff","M23G1-f2r44bB0.m",2);
AGR.TOC("matff","M23G1-f2r120B0.m",2);
AGR.TOC("matff","M23G1-f2r220aB0.m",2);
AGR.TOC("matff","M23G1-f2r220bB0.m",2);
AGR.TOC("matff","M23G1-f2r252B0.m",2);
AGR.TOC("matff","M23G1-f3r22B0.m",2);
AGR.TOC("matff","M23G1-f3r104aB0.m",2);
AGR.TOC("matff","M23G1-f3r104bB0.m",2);
AGR.TOC("matff","M23G1-f3r231B0.m",2);
AGR.TOC("matff","M23G1-f3r253B0.m",2);
AGR.TOC("matff","M23G1-f3r770aB0.m",2);
AGR.TOC("matff","M23G1-f4r896aB0.m",2);
AGR.TOC("matff","M23G1-f4r896bB0.m",2);
AGR.TOC("matff","M23G1-f5r22B0.m",2);
AGR.TOC("matff","M23G1-f5r230B0.m",2);
AGR.TOC("matff","M23G1-f5r231aB0.m",2);
AGR.TOC("matff","M23G1-f5r231bB0.m",2);
AGR.TOC("matff","M23G1-f5r896aB0.m",2);
AGR.TOC("matff","M23G1-f7r22B0.m",2);
AGR.TOC("matff","M23G1-f7r45B0.m",2);
AGR.TOC("matff","M23G1-f7r208B0.m",2);
AGR.TOC("matff","M23G1-f7r231aB0.m",2);
AGR.TOC("matff","M23G1-f7r990B0.m",2);
AGR.TOC("matff","M23G1-f9r45bB0.m",2);
AGR.TOC("matff","M23G1-f9r990bB0.m",2);
AGR.TOC("matff","M23G1-f11r22B0.m",2);
AGR.TOC("matff","M23G1-f11r45bB0.m",2);
AGR.TOC("matff","M23G1-f11r229B0.m",2);
AGR.TOC("matff","M23G1-f11r231aB0.m",2);
AGR.TOC("matff","M23G1-f11r253B0.m",2);
AGR.TOC("matff","M23G1-f11r806B0.m",2);
AGR.TOC("matff","M23G1-f11r990aB0.m",2);
AGR.TOC("matff","M23G1-f23r21B0.m",2);
AGR.TOC("matff","M23G1-f23r45bB0.m",2);
AGR.TOC("matff","M23G1-f23r210B0.m",2);
AGR.TOC("matff","M23G1-f23r230B0.m",2);
AGR.TOC("matff","M23G1-f23r231aB0.m",2);
AGR.TOC("matff","M23G1-f23r253B0.m",2);
AGR.TOC("matff","M23G1-f23r280B0.m",2);
AGR.TOC("matff","M23G1-f23r665bB0.m",2);
AGR.TOC("matff","M23G1-f25r45aB0.m",2);
AGR.TOC("matff","M23G1-f25r770B0.m",2);
AGR.TOC("matff","M23G1-f25r990aB0.m",2);
AGR.TOC("matff","M23G1-f49r231bB0.m",2);
AGR.TOC("matff","M23G1-f49r231cB0.m",2);
AGR.TOC("matff","M23G1-f49r770aB0.m",2);
AGR.TOC("matff","M23G1-f49r770bB0.m",2);
AGR.TOC("matff","M23G1-f49r896aB0.m",2);
AGR.TOC("matff","M23G1-f49r896bB0.m",2);
AGR.TOC("matff","M23G1-f121r231bB0.m",2);
AGR.TOC("matff","M23G1-f121r231cB0.m",2);
AGR.TOC("matff","M23G1-f121r770aB0.m",2);
AGR.TOC("matff","M23G1-f121r770bB0.m",2);
AGR.TOC("matint","M23G1-Zr22B0.g");
AGR.TOC("matint","M23G1-Zr230B0.g");
AGR.TOC("matint","M23G1-Zr231aB0.g");
AGR.TOC("maxes","M23G1-max1W1");
AGR.TOC("maxes","M23G1-max2W1");
AGR.TOC("maxes","M23G1-max3W1");
AGR.TOC("maxes","M23G1-max4W1");
AGR.TOC("maxes","M23G1-max5W1");
AGR.TOC("maxes","M23G1-max6W1");
AGR.TOC("maxes","M23G1-max7W1");
AGR.TOC("cyclic","M23G1-cycW1");
AGR.TOC("cyc2ccl","M23G1cycW1-cclsW1");
AGR.TOC("find","M23G1-find1");
AGR.TOC("check","M23G1-check1");
AGR.TOC("pres","M23G1-P1");
AGR.TOC("pres","M23G1-P2");

# M24
AGR.GRP("spor","M24","M24");
AGR.TOC("perm","M24G1-p24B0.m",2);
AGR.TOC("perm","M24G1-p276B0.m",2);
AGR.TOC("perm","M24G1-p759B0.m",2);
AGR.TOC("perm","M24G1-p1288B0.m",2);
AGR.TOC("perm","M24G1-p1771B0.m",2);
AGR.TOC("perm","M24G1-p2024B0.m",2);
AGR.TOC("perm","M24G1-p3795B0.m",2);
AGR.TOC("matff","M24G1-f2r11aB0.m",2);
AGR.TOC("matff","M24G1-f2r11bB0.m",2);
AGR.TOC("matff","M24G1-f2r44aB0.m",2);
AGR.TOC("matff","M24G1-f2r44bB0.m",2);
AGR.TOC("matff","M24G1-f2r120B0.m",2);
AGR.TOC("matff","M24G1-f2r220aB0.m",2);
AGR.TOC("matff","M24G1-f2r220bB0.m",2);
AGR.TOC("matff","M24G1-f2r252B0.m",2);
AGR.TOC("matff","M24G1-f2r320aB0.m",2);
AGR.TOC("matff","M24G1-f2r320bB0.m",2);
AGR.TOC("matff","M24G1-f2r1242B0.m",2);
AGR.TOC("matff","M24G1-f2r1792B0.m",2);
AGR.TOC("matff","M24G1-f3r22B0.m",2);
AGR.TOC("matff","M24G1-f3r231B0.m",2);
AGR.TOC("matff","M24G1-f3r252B0.m",2);
AGR.TOC("matff","M24G1-f3r483B0.m",2);
AGR.TOC("matff","M24G1-f3r770aB0.m",2);
AGR.TOC("matff","M24G1-f3r770bB0.m",2);
AGR.TOC("matff","M24G1-f5r23B0.m",2);
AGR.TOC("matff","M24G1-f5r231B0.m",2);
AGR.TOC("matff","M24G1-f5r252B0.m",2);
AGR.TOC("matff","M24G1-f5r253B0.m",2);
AGR.TOC("matff","M24G1-f7r23B0.m",2);
AGR.TOC("matff","M24G1-f7r45B0.m",2);
AGR.TOC("matff","M24G1-f7r252B0.m",2);
AGR.TOC("matff","M24G1-f7r253B0.m",2);
AGR.TOC("matff","M24G1-f7r483B0.m",2);
AGR.TOC("matff","M24G1-f7r990B0.m",2);
AGR.TOC("matff","M24G1-f9r45aB0.m",2);
AGR.TOC("matff","M24G1-f9r45bB0.m",2);
AGR.TOC("matff","M24G1-f9r990bB0.m",2);
AGR.TOC("matff","M24G1-f11r23B0.m",2);
AGR.TOC("matff","M24G1-f11r45B0.m",2);
AGR.TOC("matff","M24G1-f11r229B0.m",2);
AGR.TOC("matff","M24G1-f11r253B0.m",2);
AGR.TOC("matff","M24G1-f11r482B0.m",2);
AGR.TOC("matff","M24G1-f11r806B0.m",2);
AGR.TOC("matff","M24G1-f11r990bB0.m",2);
AGR.TOC("matff","M24G1-f23r23B0.m",2);
AGR.TOC("matff","M24G1-f23r45B0.m",2);
AGR.TOC("matff","M24G1-f23r231bB0.m",2);
AGR.TOC("matff","M24G1-f23r251B0.m",2);
AGR.TOC("matff","M24G1-f23r253B0.m",2);
AGR.TOC("matff","M24G1-f23r483B0.m",2);
AGR.TOC("matff","M24G1-f23r770B0.m",2);
AGR.TOC("matff","M24G1-f23r990bB0.m",2);
AGR.TOC("matff","M24G1-f25r45aB0.m",2);
AGR.TOC("matff","M24G1-f25r45bB0.m",2);
AGR.TOC("matff","M24G1-f25r770aB0.m",2);
AGR.TOC("matff","M24G1-f25r990aB0.m",2);
AGR.TOC("matff","M24G1-f49r231bB0.m",2);
AGR.TOC("matff","M24G1-f49r770aB0.m",2);
AGR.TOC("matff","M24G1-f121r231bB0.m",2);
AGR.TOC("matff","M24G1-f121r770aB0.m",2);
AGR.TOC("matint","M24G1-Zr23B0.g");
AGR.TOC("maxes","M24G1-max1W1");
AGR.TOC("maxes","M24G1-max1W2");
AGR.TOC("maxes","M24G1-max2W1");
AGR.TOC("maxes","M24G1-max3W1");
AGR.TOC("maxes","M24G1-max4W1");
AGR.TOC("maxes","M24G1-max5W1");
AGR.TOC("maxes","M24G1-max6W1");
AGR.TOC("maxes","M24G1-max7W1");
AGR.TOC("maxes","M24G1-max8W1");
AGR.TOC("maxes","M24G1-max9W1");
AGR.TOC("cyclic","M24G1-cycW1");
AGR.TOC("cyc2ccl","M24G1cycW1-cclsW1");
AGR.TOC("find","M24G1-find1");
AGR.TOC("check","M24G1-check1");
AGR.TOC("pres","M24G1-P1");

# 3McL
AGR.GRP("spor","McL","3McL");
AGR.TOC("perm","3McLG1-p66825B0.m",2);
AGR.TOC("perm","3McLG1-p103950B0.m",2);
AGR.TOC("perm","3McLG1-p340200B0.m",2);
AGR.TOC("matff","3McLG1-f3r42B0.m",2);
AGR.TOC("matff","3McLG1-f4r126aB0.m",2);
AGR.TOC("matff","3McLG1-f4r396dB0.m",2);
AGR.TOC("matff","3McLG1-f25r45aB0.m",2);
AGR.TOC("matff","3McLG1-f25r126aB0.m",2);
AGR.TOC("matff","3McLG1-f25r126bB0.m",2);
AGR.TOC("matff","3McLG1-f25r153aB0.m",2);
AGR.TOC("matff","3McLG1-f25r639aB0.m",2);
AGR.TOC("matff","3McLG1-f25r846aB0.m",2);
AGR.TOC("matff","3McLG1-f49r126aB0.m",2);
AGR.TOC("matff","3McLG1-f49r126a1B0.m",2);
AGR.TOC("matff","3McLG1-f49r126bB0.m",2);
AGR.TOC("matff","3McLG1-f49r126b1B0.m",2);
AGR.TOC("matff","3McLG1-f121r126aB0.m",2);

# 3McLd2
AGR.GRP("spor","McL","3McLd2");
AGR.TOC("matff","3McLd2G1-f4r252aB0.m",2);
AGR.TOC("matff","3McLd2G1-f5r90B0.m",2);
AGR.TOC("matff","3McLd2G1-f5r306B0.m",2);
AGR.TOC("matff","3McLd2G1-f5r1278B0.m",2);

# McL
AGR.GRP("spor","McL","McL");
AGR.TOC("perm","McLG1-p275B0.m",2);
AGR.TOC("perm","McLG1-p2025aB0.m",2);
AGR.TOC("perm","McLG1-p2025bB0.m",2);
AGR.TOC("perm","McLG1-p7128B0.m",2);
AGR.TOC("perm","McLG1-p15400aB0.m",2);
AGR.TOC("perm","McLG1-p15400bB0.m",2);
AGR.TOC("perm","McLG1-p22275aB0.m",2);
AGR.TOC("perm","McLG1-p22275bB0.m",2);
AGR.TOC("perm","McLG1-p22275cB0.m",2);
AGR.TOC("perm","McLG1-p22275dB0.m",2);
AGR.TOC("perm","McLG1-p113400B0.m",2);
AGR.TOC("perm","McLG1-p299376B0.m",2);
AGR.TOC("matff","McLG1-f2r22B0.m",2);
AGR.TOC("matff","McLG1-f2r230B0.m",2);
AGR.TOC("matff","McLG1-f2r748aB0.m",2);
AGR.TOC("matff","McLG1-f2r748bB0.m",2);
AGR.TOC("matff","McLG1-f3r21B0.m",2);
AGR.TOC("matff","McLG1-f3r104aB0.m",2);
AGR.TOC("matff","McLG1-f3r104bB0.m",2);
AGR.TOC("matff","McLG1-f3r210B0.m",2);
AGR.TOC("matff","McLG1-f3r560B0.m",2);
AGR.TOC("matff","McLG1-f4r896aB0.m",2);
AGR.TOC("matff","McLG1-f4r896bB0.m",2);
AGR.TOC("matff","McLG1-f5r21B0.m",2);
AGR.TOC("matff","McLG1-f5r210B0.m",2);
AGR.TOC("matff","McLG1-f5r230B0.m",2);
AGR.TOC("matff","McLG1-f5r560B0.m",2);
AGR.TOC("matff","McLG1-f5r896bB0.m",2);
AGR.TOC("matff","McLG1-f7r22B0.m",2);
AGR.TOC("matff","McLG1-f7r231B0.m",2);
AGR.TOC("matff","McLG1-f7r252B0.m",2);
AGR.TOC("matff","McLG1-f9r605aB0.m",2);
AGR.TOC("matff","McLG1-f9r605bB0.m",2);
AGR.TOC("matff","McLG1-f11r22B0.m",2);
AGR.TOC("matff","McLG1-f11r231B0.m",2);
AGR.TOC("matff","McLG1-f11r251B0.m",2);
AGR.TOC("matff","McLG1-f11r896B0.m",2);
AGR.TOC("matff","McLG1-f23r896bB0.m",2);
AGR.TOC("matff","McLG1-f25r1200aB0.m",2);
AGR.TOC("matff","McLG1-f49r770aB0.m",2);
AGR.TOC("matff","McLG1-f49r770bB0.m",2);
AGR.TOC("matff","McLG1-f49r896aB0.m",2);
AGR.TOC("matff","McLG1-f49r896bB0.m",2);
AGR.TOC("matff","McLG1-f121r770aB0.m",2);
AGR.TOC("matff","McLG1-f121r770bB0.m",2);
AGR.TOC("matint","McLG1-Zr231B0.g");
AGR.TOC("maxes","McLG1-max1W1");
AGR.TOC("maxes","McLG1-max2W1");
AGR.TOC("maxes","McLG1-max3W1");
AGR.TOC("maxes","McLG1-max4W1");
AGR.TOC("maxes","McLG1-max5W1");
AGR.TOC("maxes","McLG1-max6W1");
AGR.TOC("maxes","McLG1-max7W1");
AGR.TOC("maxes","McLG1-max8W1");
AGR.TOC("maxes","McLG1-max9W1");
AGR.TOC("maxes","McLG1-max10W1");
AGR.TOC("maxes","McLG1-max11W1");
AGR.TOC("maxes","McLG1-max12W1");
AGR.TOC("cyclic","McLG1-cycW1");
AGR.TOC("cyc2ccl","McLG1cycW1-cclsW1");
AGR.TOC("find","McLG1-find1");
AGR.TOC("check","McLG1-check1");
AGR.TOC("pres","McLG1-P1");

# McLd2
AGR.GRP("spor","McL","McLd2");
AGR.TOC("perm","McLd2G1-p275B0.m",2);
AGR.TOC("perm","McLd2G1-p4050B0.m",2);
AGR.TOC("perm","McLd2G1-p7128B0.m",2);
AGR.TOC("perm","McLd2G1-p22275aB0.m",2);
AGR.TOC("perm","McLd2G1-p44550B0.m",2);
AGR.TOC("matff","McLd2G1-f2r22B0.m",2);
AGR.TOC("matff","McLd2G1-f2r230aB0.m",2);
AGR.TOC("matff","McLd2G1-f2r1496aB0.m",2);
AGR.TOC("matff","McLd2G1-f3r21aB0.m",2);
AGR.TOC("matff","McLd2G1-f3r104aB0.m",2);
AGR.TOC("matff","McLd2G1-f3r104bB0.m",2);
AGR.TOC("matff","McLd2G1-f3r210aB0.m",2);
AGR.TOC("matff","McLd2G1-f3r560aB0.m",2);
AGR.TOC("matff","McLd2G1-f5r21aB0.m",2);
AGR.TOC("matff","McLd2G1-f5r210aB0.m",2);
AGR.TOC("matff","McLd2G1-f5r230aB0.m",2);
AGR.TOC("matff","McLd2G1-f5r560aB0.m",2);
AGR.TOC("matff","McLd2G1-f5r896aB0.m",2);
AGR.TOC("matff","McLd2G1-f5r896bB0.m",2);
AGR.TOC("matff","McLd2G1-f7r22aB0.m",2);
AGR.TOC("matff","McLd2G1-f7r231aB0.m",2);
AGR.TOC("matff","McLd2G1-f7r252aB0.m",2);
AGR.TOC("matff","McLd2G1-f11r22aB0.m",2);
AGR.TOC("matff","McLd2G1-f11r231aB0.m",2);
AGR.TOC("matff","McLd2G1-f11r251aB0.m",2);
AGR.TOC("matff","McLd2G1-f11r896aB0.m",2);
AGR.TOC("matff","McLd2G1-f49r896aB0.m",2);
AGR.TOC("maxes","McLd2G1-max1W1");
AGR.TOC("maxes","McLd2G1-max2W1");
AGR.TOC("maxes","McLd2G1-max3W1");
AGR.TOC("maxes","McLd2G1-max4W1");
AGR.TOC("maxes","McLd2G1-max5W1");
AGR.TOC("maxes","McLd2G1-max6W1");
AGR.TOC("maxes","McLd2G1-max7W1");
AGR.TOC("maxes","McLd2G1-max7W2");
AGR.TOC("maxes","McLd2G1-max8W1");
AGR.TOC("maxes","McLd2G1-max8W2");
AGR.TOC("maxes","McLd2G1-max9W1");
AGR.TOC("maxes","McLd2G1-max10W1");
AGR.TOC("cyclic","McLd2G1-cycW1");
AGR.TOC("find","McLd2G1-find1");
AGR.TOC("check","McLd2G1-check1");
AGR.TOC("pres","McLd2G1-P1");

# 3ON
AGR.GRP("spor","ON","3ON");
AGR.TOC("perm","3ONG1-p368280B0.m",2);
AGR.TOC("matff","3ONG1-f4r153B0.m",2);
AGR.TOC("matff","3ONG1-f7r45aB0.m",2);
AGR.TOC("matff","3ONG1-f7r45bB0.m",2);

# 3ONd2
AGR.GRP("spor","ON","3ONd2");
AGR.TOC("perm","3ONd2G1-p736560B0.m",2);
AGR.TOC("matff","3ONd2G1-f2r306B0.m",2);
AGR.TOC("matff","3ONd2G1-f7r90B0.m",2);

# ON
AGR.GRP("spor","ON","ON");
AGR.TOC("perm","ONG1-p122760aB0.m",2);
AGR.TOC("matff","ONG1-f3r154B0.m",2);
AGR.TOC("matff","ONG1-f3r495B0.m",2);
AGR.TOC("matff","ONG1-f3r684B0.m",2);
AGR.TOC("matff","ONG1-f7r406B0.m",2);
AGR.TOC("matff","ONG1-f7r1618B0.m",2);
AGR.TOC("matff","ONG1-f9r342aB0.m",2);
AGR.TOC("matff","ONG1-f9r342bB0.m",2);
AGR.TOC("matff","ONG1-f31r1869B0.m",2);
AGR.TOC("maxes","ONG1-max1W1");
AGR.TOC("maxes","ONG1-max2W1");
AGR.TOC("maxes","ONG1-max3W1");
AGR.TOC("maxes","ONG1-max4W1");
AGR.TOC("maxes","ONG1-max5W1");
AGR.TOC("maxes","ONG1-max6W1");
AGR.TOC("maxes","ONG1-max7W1");
AGR.TOC("maxes","ONG1-max8W1");
AGR.TOC("maxes","ONG1-max9W1");
AGR.TOC("maxes","ONG1-max10W1");
AGR.TOC("maxes","ONG1-max11W1");
AGR.TOC("maxes","ONG1-max12W1");
AGR.TOC("maxes","ONG1-max13W1");
AGR.TOC("cyclic","ONG1-cycW1");
AGR.TOC("find","ONG1-find1");
AGR.TOC("check","ONG1-check1");

# ONd2
AGR.GRP("spor","ON","ONd2");
AGR.TOC("perm","ONd2G1-p245520B0.m",2);
AGR.TOC("matff","ONd2G1-f3r684B0.m",2);
AGR.TOC("matff","ONd2G1-f3r990B0.m",2);
AGR.TOC("matff","ONd2G1-f7r406B0.m",2);
AGR.TOC("matff","ONd2G1-f7r1618B0.m",2);
AGR.TOC("matff","ONd2G1-f9r154B0.m",2);
AGR.TOC("matff","ONd2G1-f31r1869B0.m",2);
AGR.TOC("maxes","ONd2G1-max1W1");
AGR.TOC("maxes","ONd2G1-max2W1");
AGR.TOC("maxes","ONd2G1-max3W1");
AGR.TOC("maxes","ONd2G1-max4W1");
AGR.TOC("maxes","ONd2G1-max5W1");
AGR.TOC("maxes","ONd2G1-max6W1");
AGR.TOC("maxes","ONd2G1-max7W1");
AGR.TOC("maxes","ONd2G1-max8W1");
AGR.TOC("maxes","ONd2G1-max9W1");
AGR.TOC("maxes","ONd2G1-max10W1");
AGR.TOC("check","ONd2G1-check1");

# ONd4
AGR.GRP("spor","ON","ONd4");
AGR.TOC("matff","ONd4G1-f3r154B0.m",2);

# 2Ru
AGR.GRP("spor","Ru","2Ru");
AGR.TOC("perm","2RuG1-p16240B0.m",2);
AGR.TOC("matff","2RuG1-f3r56B0.m",2);
AGR.TOC("matff","2RuG1-f5r28B0.m",2);
AGR.TOC("matff","2RuG1-f5r912B0.m",2);
AGR.TOC("matff","2RuG1-f7r56B0.m",2);
AGR.TOC("matff","2RuG1-f9r28B0.m",2);
AGR.TOC("matff","2RuG1-f13r28B0.m",2);
AGR.TOC("matff","2RuG1-f29r28B0.m",2);
AGR.TOC("matff","2RuG1-f49r28B0.m",2);

# Ru
AGR.GRP("spor","Ru","Ru");
AGR.TOC("perm","RuG1-p4060B0.m",2);
AGR.TOC("matff","RuG1-f2r28B0.m",2);
AGR.TOC("matff","RuG1-f2r376B0.m",2);
AGR.TOC("matff","RuG1-f2r1246B0.m",2);
AGR.TOC("matff","RuG1-f3r406B0.m",2);
AGR.TOC("matff","RuG1-f3r783B0.m",2);
AGR.TOC("matff","RuG1-f5r133B0.m",2);
AGR.TOC("matff","RuG1-f5r273B0.m",2);
AGR.TOC("matff","RuG1-f5r378B0.m",2);
AGR.TOC("matff","RuG1-f5r783B0.m",2);
AGR.TOC("matff","RuG1-f7r406B0.m",2);
AGR.TOC("matff","RuG1-f7r782B0.m",2);
AGR.TOC("matff","RuG1-f9r378B0.m",2);
AGR.TOC("matff","RuG1-f13r378B0.m",2);
AGR.TOC("matff","RuG1-f13r406B0.m",2);
AGR.TOC("matff","RuG1-f13r783B0.m",2);
AGR.TOC("matff","RuG1-f29r378B0.m",2);
AGR.TOC("matff","RuG1-f29r406B0.m",2);
AGR.TOC("matff","RuG1-f29r783B0.m",2);
AGR.TOC("matff","RuG1-f49r378B0.m",2);
AGR.TOC("maxes","RuG1-max1W1");
AGR.TOC("maxes","RuG1-max1W2");
AGR.TOC("maxes","RuG1-max2W2");
AGR.TOC("maxes","RuG1-max2W1");
AGR.TOC("maxes","RuG1-max3W1");
AGR.TOC("maxes","RuG1-max3W2");
AGR.TOC("maxes","RuG1-max4W2");
AGR.TOC("maxes","RuG1-max4W1");
AGR.TOC("maxes","RuG1-max5W1");
AGR.TOC("maxes","RuG1-max5W2");
AGR.TOC("maxes","RuG1-max6W2");
AGR.TOC("maxes","RuG1-max6W1");
AGR.TOC("maxes","RuG1-max7W1");
AGR.TOC("maxes","RuG1-max7W2");
AGR.TOC("maxes","RuG1-max8W2");
AGR.TOC("maxes","RuG1-max8W1");
AGR.TOC("maxes","RuG1-max9W1");
AGR.TOC("maxes","RuG1-max9W2");
AGR.TOC("maxes","RuG1-max9W3");
AGR.TOC("maxes","RuG1-max10W1");
AGR.TOC("maxes","RuG1-max10W2");
AGR.TOC("maxes","RuG1-max11W1");
AGR.TOC("maxes","RuG1-max11W2");
AGR.TOC("maxes","RuG1-max12W1");
AGR.TOC("maxes","RuG1-max12W2");
AGR.TOC("maxes","RuG1-max13W1");
AGR.TOC("maxes","RuG1-max13W2");
AGR.TOC("maxes","RuG1-max14W1");
AGR.TOC("maxes","RuG1-max14W2");
AGR.TOC("maxes","RuG1-max15W3");
AGR.TOC("maxes","RuG1-max15W1");
AGR.TOC("maxes","RuG1-max15W2");
AGR.TOC("classes","RuG1-cclsW1");
AGR.TOC("cyclic","RuG1-cycW1");
AGR.TOC("maxstd","RuG1max9W2-L229G1W1");
AGR.TOC("find","RuG1-find1");
AGR.TOC("check","RuG1-check1");

# 2Suz
AGR.GRP("spor","Suz","2Suz");
AGR.TOC("perm","2SuzG1-p65520B0.m",2);
AGR.TOC("matff","2SuzG1-f3r12B0.m",2);
AGR.TOC("matff","2SuzG1-f3r208B0.m",2);
AGR.TOC("matff","2SuzG1-f3r352B0.m",2);

# 2Suzd2
AGR.GRP("spor","Suz","2Suzd2");
AGR.TOC("matff","2Suzd2G1-f3r12aB0.m",2);

# 3Suz
AGR.GRP("spor","Suz","3Suz");
AGR.TOC("perm","3SuzG1-p5346B0.m",2);
AGR.TOC("perm","3SuzG1-p98280B0.m",2);
AGR.TOC("perm","3SuzG1-p405405B0.m",2);
AGR.TOC("matff","3SuzG1-f4r12aB0.m",2);
AGR.TOC("matff","3SuzG1-f4r66aB0.m",2);
AGR.TOC("matff","3SuzG1-f4r429aB0.m",2);
AGR.TOC("matff","3SuzG1-f4r825aB0.m",2);
AGR.TOC("matff","3SuzG1-f4r825bB0.m",2);
AGR.TOC("matff","3SuzG1-f25r66aB0.m",2);

# 3Suzd2
AGR.GRP("spor","Suz","3Suzd2");
AGR.TOC("perm","3Suzd2G1-p5346B0.m",2);
AGR.TOC("matff","3Suzd2G1-f2r24B0.m",2);
AGR.TOC("matff","3Suzd2G1-f5r132B0.m",2);
AGR.TOC("matff","3Suzd2G1-f7r132B0.m",2);
AGR.TOC("matff","3Suzd2G1-f11r132B0.m",2);

# 6Suz
AGR.GRP("spor","Suz","6Suz");
AGR.TOC("perm","6SuzG1-p196560B0.m",2);
AGR.TOC("matff","6SuzG1-f7r12aB0.m",2);
AGR.TOC("matff","6SuzG1-f13r12aB0.m",2);
AGR.TOC("matff","6SuzG1-f25r12aB0.m",2);

# 6Suzd2
AGR.GRP("spor","Suz","6Suzd2");
AGR.TOC("matff","6Suzd2G1-f3r24B0.m",2);
AGR.TOC("matff","6Suzd2G1-f5r24B0.m",2);
AGR.TOC("matff","6Suzd2G1-f11r24B0.m",2);

# Suz
AGR.GRP("spor","Suz","Suz");
AGR.TOC("perm","SuzG1-p1782B0.m",2);
AGR.TOC("perm","SuzG1-p22880B0.m",2);
AGR.TOC("perm","SuzG1-p32760B0.m",2);
AGR.TOC("perm","SuzG1-p135135B0.m",2);
AGR.TOC("perm","SuzG1-p232960B0.m",2);
AGR.TOC("perm","SuzG1-p370656B0.m",2);
AGR.TOC("perm","SuzG1-p405405B0.m",2);
AGR.TOC("matff","SuzG1-f2r142B0.m",2);
AGR.TOC("matff","SuzG1-f2r638B0.m",2);
AGR.TOC("matff","SuzG1-f3r64B0.m",2);
AGR.TOC("matff","SuzG1-f3r78B0.m",2);
AGR.TOC("matff","SuzG1-f3r286B0.m",2);
AGR.TOC("matff","SuzG1-f3r429B0.m",2);
AGR.TOC("matff","SuzG1-f3r649B0.m",2);
AGR.TOC("matff","SuzG1-f4r110aB0.m",2);
AGR.TOC("matff","SuzG1-f4r572aB0.m",2);
AGR.TOC("matff","SuzG1-f4r572bB0.m",2);
AGR.TOC("matff","SuzG1-f5r143B0.m",2);
AGR.TOC("matff","SuzG1-f5r363B0.m",2);
AGR.TOC("matff","SuzG1-f5r780B0.m",2);
AGR.TOC("matff","SuzG1-f7r143B0.m",2);
AGR.TOC("matff","SuzG1-f7r364B0.m",2);
AGR.TOC("matff","SuzG1-f7r780B0.m",2);
AGR.TOC("matff","SuzG1-f11r143B0.m",2);
AGR.TOC("matff","SuzG1-f11r364B0.m",2);
AGR.TOC("matff","SuzG1-f11r779B0.m",2);
AGR.TOC("matff","SuzG1-f13r143B0.m",2);
AGR.TOC("matff","SuzG1-f13r364B0.m",2);
AGR.TOC("matff","SuzG1-f13r780B0.m",2);
AGR.TOC("matint","SuzG1-Zr143B0.g");
AGR.TOC("maxes","SuzG1-max1W1");
AGR.TOC("maxes","SuzG1-max2W1");
AGR.TOC("maxes","SuzG1-max3W1");
AGR.TOC("maxes","SuzG1-max4W1");
AGR.TOC("maxes","SuzG1-max5W1");
AGR.TOC("maxes","SuzG1-max6W1");
AGR.TOC("maxes","SuzG1-max7W1");
AGR.TOC("maxes","SuzG1-max8W1");
AGR.TOC("maxes","SuzG1-max9W1");
AGR.TOC("maxes","SuzG1-max10W1");
AGR.TOC("maxes","SuzG1-max11W1");
AGR.TOC("maxes","SuzG1-max12W1");
AGR.TOC("maxes","SuzG1-max13W1");
AGR.TOC("maxes","SuzG1-max14W1");
AGR.TOC("maxes","SuzG1-max15W1");
AGR.TOC("maxes","SuzG1-max16W1");
AGR.TOC("maxes","SuzG1-max17W1");
AGR.TOC("cyclic","SuzG1-cycW1");
AGR.TOC("out","SuzG1-a2W1");
AGR.TOC("out","SuzG1-a2W2");
AGR.TOC("find","SuzG1-find1");
AGR.TOC("check","SuzG1-check1");

# Suzd2
AGR.GRP("spor","Suz","Suzd2");
AGR.TOC("perm","Suzd2G1-p1782B0.m",2);
AGR.TOC("matff","Suzd2G1-f3r64aB0.m",2);
AGR.TOC("matff","Suzd2G1-f5r143aB0.m",2);
AGR.TOC("matff","Suzd2G1-f7r143aB0.m",2);
AGR.TOC("matff","Suzd2G1-f11r143aB0.m",2);
AGR.TOC("maxes","Suzd2G1-max1W1");
AGR.TOC("maxes","Suzd2G1-max2W2");
AGR.TOC("maxes","Suzd2G1-max2W1");
AGR.TOC("maxes","Suzd2G1-max3W1");
AGR.TOC("maxes","Suzd2G1-max4W1");
AGR.TOC("maxes","Suzd2G1-max5W2");
AGR.TOC("maxes","Suzd2G1-max5W1");
AGR.TOC("maxes","Suzd2G1-max6W1");
AGR.TOC("maxes","Suzd2G1-max7W1");
AGR.TOC("maxes","Suzd2G1-max7W2");
AGR.TOC("maxes","Suzd2G1-max8W1");
AGR.TOC("maxes","Suzd2G1-max8W2");
AGR.TOC("maxes","Suzd2G1-max9W1");
AGR.TOC("maxes","Suzd2G1-max10W1");
AGR.TOC("maxes","Suzd2G1-max11W1");
AGR.TOC("maxes","Suzd2G1-max11W2");
AGR.TOC("maxes","Suzd2G1-max12W1");
AGR.TOC("maxes","Suzd2G1-max13W1");
AGR.TOC("maxes","Suzd2G1-max13W2");
AGR.TOC("maxes","Suzd2G1-max14W1");
AGR.TOC("maxes","Suzd2G1-max15W1");
AGR.TOC("maxes","Suzd2G1-max16W1");
AGR.TOC("maxes","Suzd2G1-max16W2");
AGR.TOC("find","Suzd2G1-find1");
AGR.TOC("check","Suzd2G1-check1");

# Th
AGR.GRP("spor","Th","Th");
AGR.TOC("matff","ThG1-f2r248B0.m",2);
AGR.TOC("matff","ThG1-f3r248B0.m",2);
AGR.TOC("matff","ThG1-f3r3875B0.m",2);
AGR.TOC("matff","ThG1-f5r248B0.m",2);
AGR.TOC("matff","ThG1-f7r248B0.m",2);
AGR.TOC("matff","ThG1-f13r248B0.m",2);
AGR.TOC("matff","ThG1-f19r248B0.m",2);
AGR.TOC("matff","ThG1-f31r248B0.m",2);
AGR.TOC("maxes","ThG1-max1W1");
AGR.TOC("maxes","ThG1-max2W1");
AGR.TOC("maxes","ThG1-max3W1");
AGR.TOC("maxes","ThG1-max4W1");
AGR.TOC("maxes","ThG1-max4W2");
AGR.TOC("maxes","ThG1-max5W1");
AGR.TOC("maxes","ThG1-max6W1");
AGR.TOC("maxes","ThG1-max7W1");
AGR.TOC("maxes","ThG1-max8W1");
AGR.TOC("maxes","ThG1-max9W1");
AGR.TOC("maxes","ThG1-max10W1");
AGR.TOC("maxes","ThG1-max11W1");
AGR.TOC("maxes","ThG1-max12W1");
AGR.TOC("maxes","ThG1-max13W1");
AGR.TOC("maxes","ThG1-max14W1");
AGR.TOC("maxes","ThG1-max14W2");
AGR.TOC("maxes","ThG1-max15W2");
AGR.TOC("maxes","ThG1-max15W1");
AGR.TOC("maxes","ThG1-max16W1");
AGR.TOC("cyclic","ThG1-cycW1");
AGR.TOC("maxstd","ThG1max14W1-M10G1W1");
AGR.TOC("find","ThG1-find1");
AGR.TOC("check","ThG1-check1");



#############################################################################
##
##  What follows now are the representation dependent additional data.
##  They must be read after the notification of the representations,
##  in order to give us a chance to check the existence of the underlying
##  representation.
##


#############################################################################
##
##  Store info about compatibility of generators with those of factor groups.
##
AGR.STDCOMP("(2^2x3).U6(2)",[1,"U6(2)",1,true]);
AGR.STDCOMP("12.M22",[1,"M22",1,true]);
AGR.STDCOMP("12.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("12_1.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("12_2.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("2.A11",[1,"A11",1,true]);
AGR.STDCOMP("2.A14.2",[1,"A14.2",1,true]);
AGR.STDCOMP("2.A5",[1,"A5",1,true]);
AGR.STDCOMP("2.A5.2",[1,"A5.2",1,true]);
AGR.STDCOMP("2.A6",[1,"A6",1,true]);
AGR.STDCOMP("2.A6.2_1",[1,"A6.2_1",1,true]);
AGR.STDCOMP("2.A7",[1,"A7",1,true]);
AGR.STDCOMP("2.A8",[1,"A8",1,true]);
AGR.STDCOMP("2.Fi22",[1,"Fi22",1,true]);
AGR.STDCOMP("2.Fi22.2",[1,"Fi22.2",1,true]);
AGR.STDCOMP("2.HS",[1,"HS",1,true]);
AGR.STDCOMP("2.HS.2",[1,"HS.2",1,true]);
AGR.STDCOMP("2.J2",[1,"J2",1,true]);
AGR.STDCOMP("2.L2(11)",[1,"L2(11)",1,true]);
AGR.STDCOMP("2.L3(2)",[1,"L3(2)",1,true]);
AGR.STDCOMP("2.L3(2).2",[1,"L3(2).2",1,true]);
AGR.STDCOMP("2.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("2.M12",[1,"M12",1,true]);
AGR.STDCOMP("2.M12.2",[1,"M12.2",1,true]);
AGR.STDCOMP("2.M22",[1,"M22",1,true]);
AGR.STDCOMP("2.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("2.S6(2)",[1,"S6(2)",1,true]);
AGR.STDCOMP("2.Sz(8)",[1,"Sz(8)",1,true]);
AGR.STDCOMP("2.U4(2)",[1,"U4(2)",1,true]);
AGR.STDCOMP("2^2.Sz(8).3",[1,"Sz(8).3",1,true]);
AGR.STDCOMP("3.A6",[1,"A6",1,true]);
AGR.STDCOMP("3.A6.2_1",[1,"A6.2_1",1,true]);
AGR.STDCOMP("3.Fi22",[1,"Fi22",1,true]);
AGR.STDCOMP("3.Fi22.2",[1,"Fi22.2",1,true]);
AGR.STDCOMP("3.G2(3)",[1,"G2(3)",1,true]);
AGR.STDCOMP("3.J3",[1,"J3",1,true]);
AGR.STDCOMP("3.J3.2",[1,"J3.2",1,true]);
AGR.STDCOMP("3.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("3.M22",[1,"M22",1,true]);
AGR.STDCOMP("3.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("3.McL",[1,"McL",1,true]);
AGR.STDCOMP("3.McL.2",[1,"McL.2",1,true]);
AGR.STDCOMP("3.U3(8)",[1,"U3(8)",1,true]);
AGR.STDCOMP("4.M22",[1,"M22",1,true]);
AGR.STDCOMP("4.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("4_1.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("4_2.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("5^3.L3(5)",[2,"L3(5)",1,false]);
AGR.STDCOMP("6.A6",[1,"A6",1,true]);
AGR.STDCOMP("6.A6.2_1",[1,"A6.2_1",1,true]);
AGR.STDCOMP("6.Fi22",[1,"2.Fi22",1,true]);
AGR.STDCOMP("6.Fi22",[1,"Fi22",1,true]);
AGR.STDCOMP("6.Fi22.2",[1,"3.Fi22.2",1,true]);
AGR.STDCOMP("6.Fi22.2",[1,"Fi22.2",1,true]);
AGR.STDCOMP("6.L3(4)",[1,"L3(4)",1,true]);
AGR.STDCOMP("6.M22",[1,"M22",1,true]);
AGR.STDCOMP("6.M22.2",[1,"M22.2",1,true]);
AGR.STDCOMP("Isoclinic(2.A14.2)",[1,"A14.2",1,true]);
AGR.STDCOMP("Isoclinic(2.A5.2)",[1,"A5.2",1,true]);
AGR.STDCOMP("Isoclinic(2.L3(2).2)",[1,"L3(2).2",1,true]);
AGR.STDCOMP("Isoclinic(2.M12.2)",[1,"M12.2",1,true]);


#############################################################################
##
##  Store information about the rings over which characteristic zero
##  representations are written if known.
##  Note that the filenames do not contain this information,
##  so it has to be stored explicitly.
##
AGR.RNG("2A5G1-Ar2aB0","Field([E(5)])");
AGR.RNG("2A5G1-Ar4aB0","Field([Sqrt(-1)])");
AGR.RNG("2A5G1-Ar4aB2","Field([Sqrt(-6)])");
AGR.RNG("2A5G1-Ar6B0","Field([Sqrt(-1)])");
AGR.RNG("2A5G1-Ar6B1","Field([Sqrt(-3)])");
AGR.RNG("2A5G1-Hr1aB0","QuaternionAlgebra([Sqrt(5)])");
AGR.RNG("2A6G1-Ar4B0","Field([Sqrt(-3)])");
AGR.RNG("2A6G1-Ar4aB0","Field([Sqrt(-3)])");
AGR.RNG("2A6G1-Hr2aB0","QuaternionAlgebra([Sqrt(3)])");
AGR.RNG("2A7G1-Ar20aB0","Field([Sqrt(-7)])");
AGR.RNG("2A7G1-Ar4aB0","Field([Sqrt(-7)])");
AGR.RNG("2A7G1-Ar4bB0","Field([Sqrt(-7)])");
AGR.RNG("2A9G1-Ar8aB0","Field([E(7)])");
AGR.RNG("2G24G1-Ar12B0","Field([Sqrt(-1)])");
AGR.RNG("2L2101G1-Ar102aB0","Field([E(100)])");
AGR.RNG("2L2103G1-Ar104aB0","Field([E(51)])");
AGR.RNG("2L2107G1-Ar108aB0","Field([E(53)])");
AGR.RNG("2L2109G1-Ar110aB0","Field([E(108)])");
AGR.RNG("2L2113G1-Ar114aB0","Field([E(112)])");
AGR.RNG("2L2127G1-Ar128aB0","Field([E(63)])");
AGR.RNG("2L2131G1-Ar132aB0","Field([E(65)])");
AGR.RNG("2L2137G1-Ar138aB0","Field([E(136)])");
AGR.RNG("2L2139G1-Ar140aB0","Field([E(69)])");
AGR.RNG("2L2149G1-Ar150aB0","Field([E(148)])");
AGR.RNG("2L2151G1-Ar152aB0","Field([E(75)])");
AGR.RNG("2L2157G1-Ar158aB0","Field([E(156)])");
AGR.RNG("2L2163G1-Ar164aB0","Field([E(81)])");
AGR.RNG("2L2167G1-Ar168aB0","Field([E(83)])");
AGR.RNG("2L2173G1-Ar174aB0","Field([E(172)])");
AGR.RNG("2L2179G1-Ar180aB0","Field([E(89)])");
AGR.RNG("2L2181G1-Ar182aB0","Field([E(180)])");
AGR.RNG("2L2191G1-Ar192aB0","Field([E(95)])");
AGR.RNG("2L2193G1-Ar194aB0","Field([E(192)])");
AGR.RNG("2L2197G1-Ar198aB0","Field([E(196)])");
AGR.RNG("2L2199G1-Ar200aB0","Field([E(99)])");
AGR.RNG("2L2211G1-Ar212aB0","Field([E(105)])");
AGR.RNG("2L2223G1-Ar224aB0","Field([E(111)])");
AGR.RNG("2L2227G1-Ar228aB0","Field([E(113)])");
AGR.RNG("2L2229G1-Ar230aB0","Field([E(228)])");
AGR.RNG("2L2233G1-Ar234aB0","Field([E(232)])");
AGR.RNG("2L2239G1-Ar240aB0","Field([E(119)])");
AGR.RNG("2L2241G1-Ar242aB0","Field([E(240)])");
AGR.RNG("2L231G1-Ar32aB0","Field([E(15)])");
AGR.RNG("2L237G1-Ar38aB0","Field([E(36)])");
AGR.RNG("2L241G1-Ar42aB0","Field([E(40)])");
AGR.RNG("2L243G1-Ar44aB0","Field([E(21)])");
AGR.RNG("2L247G1-Ar48aB0","Field([E(23)])");
AGR.RNG("2L253G1-Ar54aB0","Field([E(52)])");
AGR.RNG("2L259G1-Ar60aB0","Field([E(29)])");
AGR.RNG("2L261G1-Ar62aB0","Field([E(60)])");
AGR.RNG("2L267G1-Ar68aB0","Field([E(33)])");
AGR.RNG("2L271G1-Ar72aB0","Field([E(35)])");
AGR.RNG("2L273G1-Ar74aB0","Field([E(72)])");
AGR.RNG("2L279G1-Ar80aB0","Field([E(39)])");
AGR.RNG("2L283G1-Ar84aB0","Field([E(41)])");
AGR.RNG("2L289G1-Ar90aB0","Field([E(88)])");
AGR.RNG("2L297G1-Ar98aB0","Field([E(96)])");
AGR.RNG("2S5G1-Ar4bB0","Field([Sqrt(-3)])");
AGR.RNG("2S5iG1-Ar4aB1","Field([Sqrt(-2)])");
AGR.RNG("2S5iG1-Ar4aB2","Field([Sqrt(-5)])");
AGR.RNG("2U42G1-Ar20aB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar20bB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar20cB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar36aB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar36bB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar4aB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar4bB0","Field([Sqrt(-3)])");
AGR.RNG("2U42G1-Ar60bB0","Field([Sqrt(-3)])");
AGR.RNG("2aM20G1-Ar12aB0","Field([Sqrt(5)])");
AGR.RNG("2aM20G1-Ar12bB0","Field([Sqrt(5)])");
AGR.RNG("2aM20G1-Ar12bB1","Field([Sqrt(5)])");
AGR.RNG("3A6G1-Ar15B0","Field([EY(15,1)])");
AGR.RNG("3A6G1-Ar3aB0","Field([EY(15,1)])");
AGR.RNG("3A6G1-Ar6B0","Field([Sqrt(-3)])");
AGR.RNG("3A6G1-Ar9B0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar15aB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar15bB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar21aB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar21bB0","Field([Sqrt(-3)])");
AGR.RNG("3A7G1-Ar6B0","Field([Sqrt(-3)])");
AGR.RNG("4bM20G1-Ar20aB0","Field([Sqrt(-1)])");
AGR.RNG("4bM20G1-Ar4aB0","Field([Sqrt(-1)])");
AGR.RNG("4bM20G1-Ar4aB1","Field([Sqrt(-1)])");
AGR.RNG("6A6G1-Ar12B0","Field([EY(15,1)])");
AGR.RNG("6L34G1-Ar6aB0","Field([Sqrt(-3)])");
AGR.RNG("A5G1-Ar3aB0","Field([Sqrt(5)])");
AGR.RNG("A5G1-Ar3bB0","Field([Sqrt(5)])");
AGR.RNG("A6G1-Ar8aB0","Field([Sqrt(5)])");
AGR.RNG("A6G1-Ar8bB0","Field([Sqrt(5)])");
AGR.RNG("G23d2G1-Ar14B0","Field([Sqrt(-3)])");
AGR.RNG("J2G1-Ar14aB0","Field([Sqrt(5)])");
AGR.RNG("J2G1-Ar14bB0","Field([Sqrt(5)])");
AGR.RNG("J2G1-Ar21aB0","Field([Sqrt(5)])");
AGR.RNG("J2G1-Ar21bB0","Field([Sqrt(5)])");
AGR.RNG("L2101G1-Ar102aB0","Field([E(25)])");
AGR.RNG("L2103G1-Ar104aB0","Field([E(51)])");
AGR.RNG("L2107G1-Ar108aB0","Field([E(53)])");
AGR.RNG("L2109G1-Ar110aB0","Field([E(27)])");
AGR.RNG("L2113G1-Ar114aB0","Field([E(56)])");
AGR.RNG("L211G1-Ar12aB0","Field([E(5)])");
AGR.RNG("L211G1-Ar12bB0","Field([E(5)])");
AGR.RNG("L211G1-Ar5aB0","Field([Sqrt(-11)])");
AGR.RNG("L211G1-Ar5bB0","Field([Sqrt(-11)])");
AGR.RNG("L2127G1-Ar128aB0","Field([E(63)])");
AGR.RNG("L2128G1-Ar129aB0","Field([E(127)])");
AGR.RNG("L2131G1-Ar132aB0","Field([E(65)])");
AGR.RNG("L2137G1-Ar138aB0","Field([E(68)])");
AGR.RNG("L2139G1-Ar140aB0","Field([E(69)])");
AGR.RNG("L213G1-Ar12aB0","Field([EY(7)])");
AGR.RNG("L213G1-Ar12bB0","Field([EY(7)])");
AGR.RNG("L213G1-Ar12cB0","Field([EY(7)])");
AGR.RNG("L2149G1-Ar150aB0","Field([E(37)])");
AGR.RNG("L2151G1-Ar152aB0","Field([E(75)])");
AGR.RNG("L2157G1-Ar158aB0","Field([E(39)])");
AGR.RNG("L2163G1-Ar164aB0","Field([E(81)])");
AGR.RNG("L2167G1-Ar168aB0","Field([E(83)])");
AGR.RNG("L2173G1-Ar174aB0","Field([E(43)])");
AGR.RNG("L2179G1-Ar180aB0","Field([E(89)])");
AGR.RNG("L217G1-Ar9aB0","Field([Sqrt(17)])");
AGR.RNG("L217G1-Ar9bB0","Field([Sqrt(17)])");
AGR.RNG("L2181G1-Ar182aB0","Field([E(45)])");
AGR.RNG("L2191G1-Ar192aB0","Field([E(95)])");
AGR.RNG("L2193G1-Ar194aB0","Field([E(96)])");
AGR.RNG("L2197G1-Ar198aB0","Field([E(49)])");
AGR.RNG("L2199G1-Ar200aB0","Field([E(99)])");
AGR.RNG("L2211G1-Ar212aB0","Field([E(105)])");
AGR.RNG("L2223G1-Ar224aB0","Field([E(111)])");
AGR.RNG("L2227G1-Ar228aB0","Field([E(113)])");
AGR.RNG("L2229G1-Ar230aB0","Field([E(57)])");
AGR.RNG("L2233G1-Ar234aB0","Field([E(116)])");
AGR.RNG("L2239G1-Ar240aB0","Field([E(119)])");
AGR.RNG("L223G1-Ar24aB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24bB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24cB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24dB0","Field([E(11)])");
AGR.RNG("L223G1-Ar24eB0","Field([E(11)])");
AGR.RNG("L2241G1-Ar242aB0","Field([E(120)])");
AGR.RNG("L227G1-Ar13aB0","Field([Sqrt(-3)])");
AGR.RNG("L227G1-Ar13bB0","Field([Sqrt(-3)])");
AGR.RNG("L227G1-Ar28aB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28bB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28cB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28dB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28eB0","Field([E(13)])");
AGR.RNG("L227G1-Ar28fB0","Field([E(13)])");
AGR.RNG("L229G1-Ar30aB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30bB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30cB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30dB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30eB0","Field([E(7)])");
AGR.RNG("L229G1-Ar30fB0","Field([E(7)])");
AGR.RNG("L231G1-Ar32aB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32bB0","Field([E(5)])");
AGR.RNG("L231G1-Ar32cB0","Field([E(5)])");
AGR.RNG("L231G1-Ar32dB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32eB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32fB0","Field([E(15)])");
AGR.RNG("L231G1-Ar32gB0","Field([E(15)])");
AGR.RNG("L232G1-Ar33aB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33bB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33cB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33dB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33eB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33fB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33gB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33hB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33iB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33jB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33kB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33lB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33mB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33nB0","Field([E(31)])");
AGR.RNG("L232G1-Ar33oB0","Field([E(31)])");
AGR.RNG("L237G1-Ar38aB0","Field([E(9)])");
AGR.RNG("L241G1-Ar42aB0","Field([E(20)])");
AGR.RNG("L243G1-Ar44aB0","Field([E(21)])");
AGR.RNG("L247G1-Ar48aB0","Field([E(23)])");
AGR.RNG("L253G1-Ar54aB0","Field([E(13)])");
AGR.RNG("L259G1-Ar60aB0","Field([E(29)])");
AGR.RNG("L261G1-Ar62aB0","Field([E(15)])");
AGR.RNG("L264G1-Ar65aB0","Field([E(63)])");
AGR.RNG("L267G1-Ar68aB0","Field([E(33)])");
AGR.RNG("L271G1-Ar72aB0","Field([E(35)])");
AGR.RNG("L273G1-Ar74aB0","Field([E(36)])");
AGR.RNG("L279G1-Ar80aB0","Field([E(39)])");
AGR.RNG("L27G1-Ar3aB0","Field([Sqrt(-7)])");
AGR.RNG("L27G1-Ar3bB0","Field([Sqrt(-7)])");
AGR.RNG("L283G1-Ar84aB0","Field([E(41)])");
AGR.RNG("L289G1-Ar90aB0","Field([E(44)])");
AGR.RNG("L28G1-Ar7bB0","Field([EY(9)])");
AGR.RNG("L28G1-Ar7cB0","Field([EY(9)])");
AGR.RNG("L28G1-Ar7dB0","Field([EY(9)])");
AGR.RNG("L28G1-Ar9aB0","Field([EY(7)])");
AGR.RNG("L28G1-Ar9bB0","Field([EY(7)])");
AGR.RNG("L28G1-Ar9cB0","Field([EY(7)])");
AGR.RNG("L297G1-Ar98aB0","Field([E(48)])");
AGR.RNG("L311G1-Ar133bB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133cB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133dB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133eB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133fB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133gB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133hB0","Field([E(5)])");
AGR.RNG("L311G1-Ar133iB0","Field([E(5)])");
AGR.RNG("L313G1-Ar183bB0","Field([Sqrt(-1)])");
AGR.RNG("L313G1-Ar183cB0","Field([Sqrt(-1)])");
AGR.RNG("L33G1-Ar26bB0","Field([Sqrt(-2)])");
AGR.RNG("L33G1-Ar26cB0","Field([Sqrt(-2)])");
AGR.RNG("L34G1-Ar63aB0","Field([Sqrt(5)])");
AGR.RNG("L34G1-Ar63bB0","Field([Sqrt(5)])");
AGR.RNG("L35G1-Ar124cB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124dB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124eB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124fB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar124gB0","Field([E(24)])");
AGR.RNG("L35G1-Ar124hB0","Field([E(24)])");
AGR.RNG("L35G1-Ar124iB0","Field([E(24)])");
AGR.RNG("L35G1-Ar124jB0","Field([E(24)])");
AGR.RNG("L35G1-Ar155bB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar155cB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar31bB0","Field([Sqrt(-1)])");
AGR.RNG("L35G1-Ar31cB0","Field([Sqrt(-1)])");
AGR.RNG("L38G1-Ar73aB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73bB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73cB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73dB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73eB0","Field([E(7)])");
AGR.RNG("L38G1-Ar73fB0","Field([E(7)])");
AGR.RNG("L44G1-Ar85aB0","Field([Sqrt(-3)])");
AGR.RNG("L44G1-Ar85bB0","Field([Sqrt(-3)])");
AGR.RNG("L52d2G1-Ar30B0","Field([Sqrt(2)])");
AGR.RNG("M11G1-Ar10bB0","Field([Sqrt(-2)])");
AGR.RNG("M11G1-Ar10cB0","Field([Sqrt(-2)])");
AGR.RNG("S44G1-Ar204aB0","Field([Sqrt(5)])");
AGR.RNG("S44G1-Ar204bB0","Field([Sqrt(5)])");
AGR.RNG("S44G1-Ar51aB0","Field([Sqrt(5)])");
AGR.RNG("S44G1-Ar51bB0","Field([Sqrt(5)])");
AGR.RNG("S45G1-Ar13aB0","Field([Sqrt(5)])");
AGR.RNG("S45G1-Ar13bB0","Field([Sqrt(5)])");
AGR.RNG("S47G1-Ar25aB0","Field([Sqrt(-7)])");
AGR.RNG("S47G1-Ar25bB0","Field([Sqrt(-7)])");
AGR.RNG("S63G1-Ar13aB0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar13bB0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar78B0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar91aB0","Field([Sqrt(-3)])");
AGR.RNG("S63G1-Ar91bB0","Field([Sqrt(-3)])");
AGR.RNG("Sz8G1-Ar14aB0","Field([Sqrt(-1)])");
AGR.RNG("Sz8G1-Ar14bB0","Field([Sqrt(-1)])");
AGR.RNG("Sz8G1-Ar65aB0","Field([E(7)])");
AGR.RNG("Sz8G1-Ar65bB0","Field([E(7)])");
AGR.RNG("Sz8G1-Ar65cB0","Field([E(7)])");
AGR.RNG("U33G1-Ar21bB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar21cB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar28aB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar28bB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar6B0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar7bB0","Field([Sqrt(-1)])");
AGR.RNG("U33G1-Ar7cB0","Field([Sqrt(-1)])");
AGR.RNG("U34G1-Ar12B0","Field([E(13)])");
AGR.RNG("U34G1-Ar13aB0","Field([E(5)])");
AGR.RNG("U34G1-Ar13bB0","Field([E(5)])");
AGR.RNG("U34G1-Ar13cB0","Field([E(5)])");
AGR.RNG("U34G1-Ar13dB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52aB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52bB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52cB0","Field([E(5)])");
AGR.RNG("U34G1-Ar52dB0","Field([E(5)])");
AGR.RNG("U42G1-Ar10B0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar10aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar10bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar30bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar30cB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar40aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar40bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar45aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar45bB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar5aB0","Field([Sqrt(-3)])");
AGR.RNG("U42G1-Ar5bB0","Field([Sqrt(-3)])");
AGR.RNG("U52G1-Ar66aB0","Field([Sqrt(-3)])");
AGR.RNG("U52G1-Ar66bB0","Field([Sqrt(-3)])");


#############################################################################
##
##  Store information which straight line programs for restricting to maximal
##  subgroups of a group can be used also for restricting to maximal
##  subgroups of downward extensions.
##
AGR.TOCEXT("12M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("12M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("12M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("12M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("12M22",1,5,["M22G1-max5W1","M22"]);
AGR.TOCEXT("12M22",1,6,["M22G1-max6W1","M22"]);
AGR.TOCEXT("12M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("12M22",1,8,["M22G1-max8W1","M22"]);
AGR.TOCEXT("12aL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("12aL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("12aL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("12aL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("12bL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("12bL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("12bL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("12bL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("2A5",1,1,["A5G1-max1W1"]);
AGR.TOCEXT("2A5",1,2,["A5G1-max2W1"]);
AGR.TOCEXT("2A5",1,3,["A5G1-max3W1"]);
AGR.TOCEXT("2A6",1,1,["A6G1-max1W1"]);
AGR.TOCEXT("2A6",1,2,["A6G1-max2W1"]);
AGR.TOCEXT("2A6",1,3,["A6G1-max3W1"]);
AGR.TOCEXT("2A6",1,4,["A6G1-max4W1"]);
AGR.TOCEXT("2A6",1,5,["A6G1-max5W1"]);
AGR.TOCEXT("2F22",1,1,["F22G1-max1W1"]);
AGR.TOCEXT("2F22",1,10,["F22G1-max10W1"]);
AGR.TOCEXT("2F22",1,11,["F22G1-max11W1"]);
AGR.TOCEXT("2F22",1,12,["F22G1-max12W1","Fi22"]);
AGR.TOCEXT("2F22",1,13,["F22G1-max13W2","Fi22"]);
AGR.TOCEXT("2F22",1,14,["F22G1-max14W1","Fi22"]);
AGR.TOCEXT("2F22",1,2,["F22G1-max2W1"]);
AGR.TOCEXT("2F22",1,3,["F22G1-max3W1"]);
AGR.TOCEXT("2F22",1,4,["F22G1-max4W1","Fi22"]);
AGR.TOCEXT("2F22",1,5,["F22G1-max5W1"]);
AGR.TOCEXT("2F22",1,6,["F22G1-max6W1"]);
AGR.TOCEXT("2F22",1,7,["F22G1-max7W1"]);
AGR.TOCEXT("2F22",1,8,["F22G1-max8W1"]);
AGR.TOCEXT("2F22",1,9,["F22G1-max9W1","Fi22"]);
AGR.TOCEXT("2F22d2",1,1,["F22d2G1-max1W1"]);
AGR.TOCEXT("2F22d2",1,13,["F22d2G1-max13W1"]);
AGR.TOCEXT("2F22d2",1,2,["F22d2G1-max2W1"]);
AGR.TOCEXT("2HS",1,1,["HSG1-max1W1"]);
AGR.TOCEXT("2HS",1,10,["HSG1-max10W1"]);
AGR.TOCEXT("2HS",1,11,["HSG1-max11W1"]);
AGR.TOCEXT("2HS",1,12,["HSG1-max12W1"]);
AGR.TOCEXT("2HS",1,2,["HSG1-max2W1"]);
AGR.TOCEXT("2HS",1,3,["HSG1-max3W1"]);
AGR.TOCEXT("2HS",1,4,["HSG1-max4W1"]);
AGR.TOCEXT("2HS",1,5,["HSG1-max5W1"]);
AGR.TOCEXT("2HS",1,6,["HSG1-max6W1"]);
AGR.TOCEXT("2HS",1,7,["HSG1-max7W1"]);
AGR.TOCEXT("2HS",1,8,["HSG1-max8W1","HS"]);
AGR.TOCEXT("2HS",1,9,["HSG1-max9W1","HS"]);
AGR.TOCEXT("2HSd2",1,1,["HSd2G1-max1W1"]);
AGR.TOCEXT("2HSd2",1,10,["HSd2G1-max10W1"]);
AGR.TOCEXT("2HSd2",1,2,["HSd2G1-max2W1"]);
AGR.TOCEXT("2HSd2",1,3,["HSd2G1-max3W1"]);
AGR.TOCEXT("2HSd2",1,4,["HSd2G1-max4W1"]);
AGR.TOCEXT("2HSd2",1,5,["HSd2G1-max5W1"]);
AGR.TOCEXT("2HSd2",1,6,["HSd2G1-max6W1"]);
AGR.TOCEXT("2HSd2",1,7,["HSd2G1-max7W1"]);
AGR.TOCEXT("2HSd2",1,8,["HSd2G1-max8W1"]);
AGR.TOCEXT("2HSd2",1,9,["HSd2G1-max9W1"]);
AGR.TOCEXT("2J2",1,1,["J2G1-max1W1","J2"]);
AGR.TOCEXT("2J2",1,2,["J2G1-max2W1"]);
AGR.TOCEXT("2J2",1,3,["J2G1-max3W1"]);
AGR.TOCEXT("2J2",1,4,["J2G1-max4W1"]);
AGR.TOCEXT("2J2",1,5,["J2G1-max5W1"]);
AGR.TOCEXT("2J2",1,6,["J2G1-max6W1"]);
AGR.TOCEXT("2J2",1,7,["J2G1-max7W1"]);
AGR.TOCEXT("2J2",1,8,["J2G1-max8W1"]);
AGR.TOCEXT("2J2",1,9,["J2G1-max9W1"]);
AGR.TOCEXT("2L27",1,1,["L27G1-max1W1"]);
AGR.TOCEXT("2L27",1,2,["L27G1-max2W1"]);
AGR.TOCEXT("2L27",1,3,["L27G1-max3W1","L3(2)"]);
AGR.TOCEXT("2L27d2",1,1,["L27d2G1-max1W1"]);
AGR.TOCEXT("2L27d2",1,2,["L27d2G1-max2W1"]);
AGR.TOCEXT("2L27d2",1,3,["L27d2G1-max3W1"]);
AGR.TOCEXT("2L27d2",1,4,["L27d2G1-max4W1"]);
AGR.TOCEXT("2L27d2i",1,1,["L27d2G1-max1W1"]);
AGR.TOCEXT("2L27d2i",1,2,["L27d2G1-max2W1","L3(2).2"]);
AGR.TOCEXT("2L27d2i",1,3,["L27d2G1-max3W1"]);
AGR.TOCEXT("2L27d2i",1,4,["L27d2G1-max4W1"]);
AGR.TOCEXT("2L34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("2L34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("2L34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("2L34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("2L34",1,7,["L34G1-max7W1"]);
AGR.TOCEXT("2L34",1,8,["L34G1-max8W1"]);
AGR.TOCEXT("2L34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("2M12",1,1,["M12G1-max1W1","M12"]);
AGR.TOCEXT("2M12",1,10,["M12G1-max10W1"]);
AGR.TOCEXT("2M12",1,11,["M12G1-max11W1"]);
AGR.TOCEXT("2M12",1,2,["M12G1-max2W1","M12"]);
AGR.TOCEXT("2M12",1,3,["M12G1-max3W1"]);
AGR.TOCEXT("2M12",1,4,["M12G1-max4W1"]);
AGR.TOCEXT("2M12",1,5,["M12G1-max5W1"]);
AGR.TOCEXT("2M12",1,6,["M12G1-max6W1"]);
AGR.TOCEXT("2M12",1,7,["M12G1-max7W1"]);
AGR.TOCEXT("2M12",1,8,["M12G1-max8W1"]);
AGR.TOCEXT("2M12",1,9,["M12G1-max9W1"]);
AGR.TOCEXT("2M12d2",1,2,["M12d2G1-max2W1","M12.2"]);
AGR.TOCEXT("2M12d2",1,3,["M12d2G1-max3W1"]);
AGR.TOCEXT("2M12d2",1,4,["M12d2G1-max4W1"]);
AGR.TOCEXT("2M12d2",1,5,["M12d2G1-max5W1"]);
AGR.TOCEXT("2M12d2",1,6,["M12d2G1-max6W1"]);
AGR.TOCEXT("2M12d2",1,7,["M12d2G1-max7W1","M12.2"]);
AGR.TOCEXT("2M12d2",1,8,["M12d2G1-max8W1"]);
AGR.TOCEXT("2M12d2",1,9,["M12d2G1-max9W1"]);
AGR.TOCEXT("2M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("2M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("2M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("2M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("2M22",1,5,["M22G1-max5W1"]);
AGR.TOCEXT("2M22",1,6,["M22G1-max6W1"]);
AGR.TOCEXT("2M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("2M22",1,8,["M22G1-max8W1"]);
AGR.TOCEXT("2M22d2",1,1,["M22d2G1-max1W1"]);
AGR.TOCEXT("2M22d2",1,2,["M22d2G1-max2W1"]);
AGR.TOCEXT("2M22d2",1,3,["M22d2G1-max3W1"]);
AGR.TOCEXT("2M22d2",1,4,["M22d2G1-max4W1"]);
AGR.TOCEXT("2M22d2",1,5,["M22d2G1-max5W1"]);
AGR.TOCEXT("2M22d2",1,6,["M22d2G1-max6W1"]);
AGR.TOCEXT("2M22d2",1,7,["M22d2G1-max7W1","M22.2"]);
AGR.TOCEXT("2S5",1,1,["S5G1-max1W1"]);
AGR.TOCEXT("2S5",1,2,["S5G1-max2W1"]);
AGR.TOCEXT("2S5",1,3,["S5G1-max3W1"]);
AGR.TOCEXT("2S5",1,4,["S5G1-max4W1"]);
AGR.TOCEXT("2S5i",1,1,["S5G1-max1W1"]);
AGR.TOCEXT("2S5i",1,2,["S5G1-max2W1"]);
AGR.TOCEXT("2S5i",1,3,["S5G1-max3W1"]);
AGR.TOCEXT("2S5i",1,4,["S5G1-max4W1"]);
AGR.TOCEXT("2S6",1,1,["S6G1-max1W1"]);
AGR.TOCEXT("2S6",1,2,["S6G1-max2W1"]);
AGR.TOCEXT("2S6",1,3,["S6G1-max3W1"]);
AGR.TOCEXT("2S6",1,4,["S6G1-max4W1"]);
AGR.TOCEXT("2S6",1,5,["S6G1-max5W1"]);
AGR.TOCEXT("2S6",1,6,["S6G1-max6W1"]);
AGR.TOCEXT("2S62",1,1,["S62G1-max1W1"]);
AGR.TOCEXT("2S62",1,2,["S62G1-max2W1"]);
AGR.TOCEXT("2S62",1,3,["S62G1-max3W1"]);
AGR.TOCEXT("2S62",1,4,["S62G1-max4W1","S6(2)"]);
AGR.TOCEXT("2S62",1,5,["S62G1-max5W1"]);
AGR.TOCEXT("2S62",1,6,["S62G1-max6W1"]);
AGR.TOCEXT("2S62",1,7,["S62G1-max7W1"]);
AGR.TOCEXT("2S62",1,8,["S62G1-max8W1","S6(2)"]);
AGR.TOCEXT("2Sz8",1,1,["Sz8G1-max1W1"]);
AGR.TOCEXT("2Sz8",1,2,["Sz8G1-max2W1"]);
AGR.TOCEXT("2Sz8",1,3,["Sz8G1-max3W1"]);
AGR.TOCEXT("2Sz8",1,4,["Sz8G1-max4W1","Sz(8)"]);
AGR.TOCEXT("3A6",1,1,["A6G1-max1W1"]);
AGR.TOCEXT("3A6",1,2,["A6G1-max2W1"]);
AGR.TOCEXT("3A6",1,3,["A6G1-max3W1"]);
AGR.TOCEXT("3A6",1,4,["A6G1-max4W1"]);
AGR.TOCEXT("3A6",1,5,["A6G1-max5W1"]);
AGR.TOCEXT("3G23",1,1,["G23G1-max1W1","G2(3)"]);
AGR.TOCEXT("3G23",1,10,["G23G1-max10W1"]);
AGR.TOCEXT("3G23",1,2,["G23G1-max2W1","G2(3)"]);
AGR.TOCEXT("3G23",1,3,["G23G1-max3W1"]);
AGR.TOCEXT("3G23",1,4,["G23G1-max4W1"]);
AGR.TOCEXT("3G23",1,5,["G23G1-max5W1"]);
AGR.TOCEXT("3G23",1,6,["G23G1-max6W1"]);
AGR.TOCEXT("3G23",1,7,["G23G1-max7W1","G2(3)"]);
AGR.TOCEXT("3G23",1,8,["G23G1-max8W1"]);
AGR.TOCEXT("3G23",1,9,["G23G1-max9W1"]);
AGR.TOCEXT("3L34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("3L34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("3L34",1,3,["L34G1-max3W1"]);
AGR.TOCEXT("3L34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("3L34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("3L34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("3L34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("3M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("3M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("3M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("3M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("3M22",1,5,["M22G1-max5W1","M22"]);
AGR.TOCEXT("3M22",1,6,["M22G1-max6W1","M22"]);
AGR.TOCEXT("3M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("3M22",1,8,["M22G1-max8W1","M22"]);
AGR.TOCEXT("3M22d2",1,1,["M22d2G1-max1W1"]);
AGR.TOCEXT("3M22d2",1,2,["M22d2G1-max2W1"]);
AGR.TOCEXT("3M22d2",1,3,["M22d2G1-max3W1"]);
AGR.TOCEXT("3M22d2",1,4,["M22d2G1-max4W1"]);
AGR.TOCEXT("3M22d2",1,5,["M22d2G1-max5W1","M22.2"]);
AGR.TOCEXT("3M22d2",1,6,["M22d2G1-max6W1"]);
AGR.TOCEXT("3M22d2",1,7,["M22d2G1-max7W1","M22.2"]);
AGR.TOCEXT("3McL",1,1,["McLG1-max1W1"]);
AGR.TOCEXT("3McL",1,10,["McLG1-max10W1"]);
AGR.TOCEXT("3McL",1,11,["McLG1-max11W1","McL"]);
AGR.TOCEXT("3McL",1,12,["McLG1-max12W1"]);
AGR.TOCEXT("3McL",1,2,["McLG1-max2W1"]);
AGR.TOCEXT("3McL",1,3,["McLG1-max3W1"]);
AGR.TOCEXT("3McL",1,4,["McLG1-max4W1"]);
AGR.TOCEXT("3McL",1,5,["McLG1-max5W1"]);
AGR.TOCEXT("3McL",1,6,["McLG1-max6W1"]);
AGR.TOCEXT("3McL",1,7,["McLG1-max7W1"]);
AGR.TOCEXT("3McL",1,8,["McLG1-max8W1","McL"]);
AGR.TOCEXT("3McL",1,9,["McLG1-max9W1"]);
AGR.TOCEXT("3McLd2",1,1,["McLd2G1-max1W1"]);
AGR.TOCEXT("3McLd2",1,10,["McLd2G1-max10W1"]);
AGR.TOCEXT("3McLd2",1,2,["McLd2G1-max2W1"]);
AGR.TOCEXT("3McLd2",1,3,["McLd2G1-max3W1"]);
AGR.TOCEXT("3McLd2",1,4,["McLd2G1-max4W1"]);
AGR.TOCEXT("3McLd2",1,5,["McLd2G1-max5W1"]);
AGR.TOCEXT("3McLd2",1,6,["McLd2G1-max6W1"]);
AGR.TOCEXT("3McLd2",1,7,["McLd2G1-max7W1"]);
AGR.TOCEXT("3McLd2",1,8,["McLd2G1-max8W1"]);
AGR.TOCEXT("3McLd2",1,9,["McLd2G1-max9W1"]);
AGR.TOCEXT("3S6",1,1,["S6G1-max1W1"]);
AGR.TOCEXT("3S6",1,2,["S6G1-max2W1","A6.2_1"]);
AGR.TOCEXT("3S6",1,3,["S6G1-max3W1","A6.2_1"]);
AGR.TOCEXT("3S6",1,4,["S6G1-max4W1"]);
AGR.TOCEXT("3S6",1,5,["S6G1-max5W1","A6.2_1"]);
AGR.TOCEXT("3S6",1,6,["S6G1-max6W1","A6.2_1"]);
AGR.TOCEXT("4M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("4M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("4M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("4M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("4M22",1,5,["M22G1-max5W1"]);
AGR.TOCEXT("4M22",1,6,["M22G1-max6W1"]);
AGR.TOCEXT("4M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("4M22",1,8,["M22G1-max8W1"]);
AGR.TOCEXT("4Sz8d3",1,1,["Sz8d3G1-max1W1"]);
AGR.TOCEXT("4Sz8d3",1,2,["Sz8d3G1-max2W1"]);
AGR.TOCEXT("4Sz8d3",1,3,["Sz8d3G1-max3W1"]);
AGR.TOCEXT("4Sz8d3",1,4,["Sz8d3G1-max4W1","Sz(8).3"]);
AGR.TOCEXT("4Sz8d3",1,5,["Sz8d3G1-max5W1"]);
AGR.TOCEXT("4aL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("4aL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("4aL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("4aL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("4aL34",1,7,["L34G1-max7W1"]);
AGR.TOCEXT("4aL34",1,8,["L34G1-max8W1"]);
AGR.TOCEXT("4aL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("4bL34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("4bL34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("4bL34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("4bL34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("4bL34",1,7,["L34G1-max7W1"]);
AGR.TOCEXT("4bL34",1,8,["L34G1-max8W1"]);
AGR.TOCEXT("4bL34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("6A6",1,1,["A6G1-max1W1"]);
AGR.TOCEXT("6A6",1,2,["A6G1-max2W1"]);
AGR.TOCEXT("6A6",1,3,["A6G1-max3W1"]);
AGR.TOCEXT("6A6",1,4,["A6G1-max4W1"]);
AGR.TOCEXT("6A6",1,5,["A6G1-max5W1"]);
AGR.TOCEXT("6L34",1,1,["L34G1-max1W1"]);
AGR.TOCEXT("6L34",1,2,["L34G1-max2W1"]);
AGR.TOCEXT("6L34",1,3,["L34G1-max3W1","L3(4)"]);
AGR.TOCEXT("6L34",1,6,["L34G1-max6W1","L3(4)"]);
AGR.TOCEXT("6L34",1,7,["L34G1-max7W1","L3(4)"]);
AGR.TOCEXT("6L34",1,8,["L34G1-max8W1","L3(4)"]);
AGR.TOCEXT("6L34",1,9,["L34G1-max9W1"]);
AGR.TOCEXT("6M22",1,1,["M22G1-max1W1"]);
AGR.TOCEXT("6M22",1,2,["M22G1-max2W1"]);
AGR.TOCEXT("6M22",1,3,["M22G1-max3W1"]);
AGR.TOCEXT("6M22",1,4,["M22G1-max4W1"]);
AGR.TOCEXT("6M22",1,5,["M22G1-max5W1","M22"]);
AGR.TOCEXT("6M22",1,6,["M22G1-max6W1","M22"]);
AGR.TOCEXT("6M22",1,7,["M22G1-max7W1"]);
AGR.TOCEXT("6M22",1,8,["M22G1-max8W1","M22"]);
AGR.TOCEXT("6M22d2",1,1,["M22d2G1-max1W1"]);
AGR.TOCEXT("6M22d2",1,2,["M22d2G1-max2W1"]);
AGR.TOCEXT("6M22d2",1,3,["M22d2G1-max3W1"]);
AGR.TOCEXT("6M22d2",1,4,["M22d2G1-max4W1"]);
AGR.TOCEXT("6M22d2",1,5,["M22d2G1-max5W1","M22.2"]);
AGR.TOCEXT("6M22d2",1,6,["M22d2G1-max6W1"]);
AGR.TOCEXT("6M22d2",1,7,["M22d2G1-max7W1","M22.2"]);
AGR.TOCEXT("6S6",1,1,["S6G1-max1W1"]);
AGR.TOCEXT("6S6",1,2,["S6G1-max2W1","A6.2_1"]);
AGR.TOCEXT("6S6",1,3,["S6G1-max3W1","A6.2_1"]);
AGR.TOCEXT("6S6",1,4,["S6G1-max4W1"]);
AGR.TOCEXT("6S6",1,5,["S6G1-max5W1","A6.2_1"]);
AGR.TOCEXT("6S6",1,6,["S6G1-max6W1","A6.2_1"]);


#############################################################################
##
##  Store information about the point stabilizers of permutation
##  representations if known.
##  Note that the filenames do not contain this information,
##  so it has to be stored explicitly.
##
AGR.API("12M22G1-p31680aB0",[1,256,"imprim","L3(2) < 3x2.(2^3:L3(2)x2)"]);
AGR.API("12U62G1-p4704B0",[0,[2016,2688]]);
AGR.API("12U62G1-p8064B0",[1,19,"imprim","U5(2) < 2^2x3xU5(2)"]);
AGR.API("12aL34G1-p1440B0",[1,28,"imprim","L2(7) < 12xL2(7)"]);
AGR.API("12bL34G1-p1440B0",[1,34,"imprim","L2(7) < 12xL2(7)"]);
AGR.API("24A8G1-p128B0",[1,4,"imprim","A7 < 2^4:A7"]);
AGR.API("24A8G1-p30B0",[1,3,"imprim","4^3:L3(2) < 2^4.2^3.L3(2)"]);
AGR.API("2A11G1-p5040B0",[1,8,"imprim","M11 < 2xM11"]);
AGR.API("2A5G1-p24B0",[1,8,"imprim","5 < 2.D10"]);
AGR.API("2A5G1-p40B0",[1,16,"imprim","3 < 2.S3"]);
AGR.API("2A6G1-p144B0",[1,32,"imprim","5 < 2.A5"]);
AGR.API("2A6G1-p240aB0",[1,88,"imprim","3 < 3^2:8"]);
AGR.API("2A6G1-p240bB0",[1,88,"imprim","3 < 3^2:8"]);
AGR.API("2A6G1-p80B0",[1,16,"imprim","3^2 < 3^2:8"]);
AGR.API("2A7G1-p240B0",[1,20,"imprim","7:3 < 2.L3(2)"]);
AGR.API("2A8G1-p240aB0",[1,10,"imprim","L3(2) < 2^(1+3):L3(2)"]);
AGR.API("2A8G1-p240bB0",[1,7,"imprim","2^3:7:3 < 2^(1+3):L3(2)"]);
AGR.API("2A8G1-p240cB0",[1,7,"imprim","2^3:7:3 < 2^(1+3):L3(2)"]);
AGR.API("2Co1G1-p196560B0",[1,7,"imprim","Co2 < 2xCo2"]);
AGR.API("2F22G1-p123552B0",[1,6,"imprim","O8+(2):S3 < O8+(2):S3x2"]);
AGR.API("2F22G1-p28160B0",[1,5,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2F22d2G1-p56320B0",[1,9,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2F42G1-p139776B0",[1,9,"imprim","S8(2) < 2xS8(2)"]);
AGR.API("2HSG1-p11200aB0",[1,16,"imprim","M11 < 2xM11"]);
AGR.API("2HSG1-p4400B0",[1,13,"imprim","A8 < Isoclinic(S8x2)"]);
AGR.API("2HSG1-p704B0",[1,6,"imprim","U3(5) < Isoclinic(U3(5).2x2)"]);
AGR.API("2HSd2G1-p1408B0",[1,11,"imprim","U3(5) < U3(5).2"]);
AGR.API("2J2G1-p1120B0",[1,20,"imprim","3.A6 < (2x3.A6).2"]);
AGR.API("2J2G1-p200B0",[1,5,"imprim","U3(3) < 2xU3(3)"]);
AGR.API("2L219G1-p40B0",[1,4,"imprim","19:9 < 2x19:9"]);
AGR.API("2L27G1-p112B0",[1,40,"imprim","3 < 2x7:3"]);
AGR.API("2L27G1-p16B0",[1,4,"imprim","7:3 < 2x7:3"]);
AGR.API("2L27G1-p336B0",[1,336,"imprim","1 < 2x7:3"]);
AGR.API("2L27G1-p48B0",[1,12,"imprim","7 < 2x7:3"]);
AGR.API("2L27d2G1-p224B0",[1,80,"imprim","3 < 2.L2(7)"]);
AGR.API("2L27d2G1-p32B0",[1,8,"imprim","7:3 < 2.L2(7)"]);
AGR.API("2L27d2G1-p672B0",[1,672,"imprim","1 < 2.L2(7)"]);
AGR.API("2L27d2G1-p96B0",[1,24,"imprim","7 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p112aB0",[1,23,"imprim","S3 < 2.D12"]);
AGR.API("2L27d2iG1-p112bB0",[1,21,"imprim","6 < 2x7:6"]);
AGR.API("2L27d2iG1-p16aB0",[1,3,"imprim","7:6 < 2x7:6"]);
AGR.API("2L27d2iG1-p16bB0",[1,3,"imprim","7:6 < 2x7:6"]);
AGR.API("2L27d2iG1-p224B0",[1,80,"imprim","3 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p32B0",[1,8,"imprim","7:3 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p336B0",[1,171,"imprim","2 < 2.D12"]);
AGR.API("2L27d2iG1-p48aB0",[1,9,"imprim","D14 < 2x7:6"]);
AGR.API("2L27d2iG1-p48bB0",[1,9,"imprim","D14 < 2x7:6"]);
AGR.API("2L27d2iG1-p672B0",[1,672,"imprim","1 < 2.L2(7)"]);
AGR.API("2L27d2iG1-p96B0",[1,24,"imprim","7 < 2.L2(7)"]);
AGR.API("2L34G1-p112aB0",[1,6,"imprim","A6 < 2xA6"]);
AGR.API("2L34G1-p112bB0",[1,5,"imprim","A6 < 2xA6"]);
AGR.API("2L34G1-p112cB0",[1,5,"imprim","A6 < 2xA6"]);
AGR.API("2L34G1-p240aB0",[1,8,"imprim","L2(7) < 2xL2(7)"]);
AGR.API("2L34G1-p240bB0",[1,7,"imprim","L2(7) < 2xL2(7)"]);
AGR.API("2L34G1-p240cB0",[1,7,"imprim","L2(7) < 2xL2(7)"]);
AGR.API("2M12G1-p24aB0",[1,3,"imprim","M11 < 2xM11"]);
AGR.API("2M12d2G1-p48B0",[1,5,"imprim","M11 < 2.M12"]);
AGR.API("2M22G1-p352aB0",[1,5,"imprim","A7 < 2xA7"]);
AGR.API("2M22G1-p660B0",[1,7,"imprim","2^3:L3(2) < 2x2^3:L3(2)"]);
AGR.API("2O73G1-p2160B0",[1,5,"imprim","G2(3) < 2xG2(3)"]);
AGR.API("2O8p3G1-p2160aB0",[1,5,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2O8p3G1-p2160bB0",[1,5,"imprim","O7(3) < 2xO7(3)"]);
AGR.API("2O8p3G1-p2240B0",[1,5,"imprim","3^6:L4(3) < 2x3^6:L4(3)"]);
AGR.API("2RuG1-p16240B0",[1,9,"imprim","2F4(2)' < Isoclinic(2F4(2)'.2x2)"]);
AGR.API("2S45G1-p624B0",[1,9,"imprim","5^(1+2)_+:2A5 < 5^(1+2)_+:(4x2.A5)"]);
AGR.API("2S5G1-p40aB0",[1,11,"imprim","S3 < 2.S4"]);
AGR.API("2S5G1-p40bB0",[1,9,"imprim","6 < 2.(2xS3)"]);
AGR.API("2S5G1-p48B0",[1,16,"imprim","5 < 2.A5"]);
AGR.API("2S5iG1-p48B0",[1,16,"imprim","5 < 2.A5"]);
AGR.API("2S5iG1-p80B0",[1,32,"imprim","3 < 2.A5"]);
AGR.API("2S62G1-p1920B0",[1,10,"imprim","L2(8).3 < 2xL2(8).3"]);
AGR.API("2S62G1-p2160B0",[1,13,"imprim","2^3.L3(2) < 2^7.L3(2)"]);
AGR.API("2S62G1-p240aB0",[1,4,"imprim","U3(3).2 < 2xU3(3).2"]);
AGR.API("2S62G1-p240bB0",[1,5,"imprim","U3(3).2 < 2xU3(3).2"]);
AGR.API("2S62G1-p480B0",[1,8,"imprim","U3(3) < 2xU3(3).2"]);
AGR.API("2S63d2G1-p728B0",[1,4,"imprim","3^(1+4)_+:2U4(2) < 2x3^(1+4)_+:2U4(2)"]);
AGR.API("2S6G1-p240aB0",[1,56,"imprim","S3 < 2.S5"]);
AGR.API("2S6G1-p288B0",[1,64,"imprim","5 < 2.S5"]);
AGR.API("2S6G1-p80B0",[1,10,"imprim","3xS3 < 3^2:QD16"]);
AGR.API("2SuzG1-p65520B0",[1,10,"imprim","U5(2) < 2xU5(2)"]);
AGR.API("2Sz8G1-p1040B0",[1,23,"imprim","2^3:7 < 2^(4+3):7"]);
AGR.API("2U42G1-p240B0",[1,9,"imprim","3^(1+2)_+:Q8 < 2x3^(1+2)_+:2A4"]);
AGR.API("2U42G1-p80B0",[1,5,"imprim","3^(1+2)_+:2A4 < 2x3^(1+2)_+:2A4"]);
AGR.API("2U42d2G1-p240B0",[1,6,"imprim","3^(1+2)_+:QD16 < 2x3^(1+2)_+:2S4"]);
AGR.API("2U62G1-p12672aB0",[1,7,"imprim","S6(2) < 2xS6(2)"]);
AGR.API("2U62G1-p12672bB0",[1,6,"imprim","S6(2) < 2xS6(2)"]);
AGR.API("2U62G1-p12672cB0",[1,6,"imprim","S6(2) < 2xS6(2)"]);
AGR.API("2U62G1-p1344B0",[1,5,"imprim","U5(2) < 2xU5(2)"]);
AGR.API("2U62G1-p2816aB0",[1,5,"imprim","U4(3).2_2 < 2xU4(3).2_2"]);
AGR.API("2U62G1-p2816bB0",[1,5,"imprim","U4(3).2_2 < 2xU4(3).2_2"]);
AGR.API("2U62G1-p41472B0",[1,15,"imprim","M22 < 2xM22"]);
AGR.API("2U62G1-p5632B0",[1,9,"imprim","U4(3) < 2xU4(3).2_2"]);
AGR.API("2aM20G1-p12aB0",[1,3,"imprim","2^4:D10 < 2x2^4:D10"]);
AGR.API("2aM20G1-p12bB0",[1,3,"imprim","2^4:D10 < 2x2^4:D10"]);
AGR.API("2aM20G1-p20aB0",[1,4,"imprim","2^4:S3 < 2x2^4:S3"]);
AGR.API("2aM20G1-p20bB0",[1,4,"imprim","2^4:S3 < 2x2^4:S3"]);
AGR.API("2bM20G1-p120aB0",[1,64,"imprim","2^4 < 2^5.A4"]);
AGR.API("2cM20G1-p24B0",[1,6,"imprim","2^4:5 < 2x2^4:5"]);
AGR.API("3A6G1-p18aB0",[1,4,"imprim","A5 < 3xA5"]);
AGR.API("3A6G1-p18bB0",[1,4,"imprim","A5 < 3xA5"]);
AGR.API("3A6G1-p45aB0",[1,7,"imprim","S4 < 3xS4"]);
AGR.API("3A6G1-p45bB0",[1,7,"imprim","S4 < 3xS4"]);
AGR.API("3A7G1-p315B0",[1,28,"imprim","S4 < 3.A6"]);
AGR.API("3A7G1-p45aB0",[1,4,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3A7G1-p45bB0",[1,4,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3A7G1-p63B0",[1,7,"imprim","S5 < 3xS5"]);
AGR.API("3F22G1-p185328B0",[1,10,"imprim","O8+(2):S3 < 3xO8+(2):S3"]);
AGR.API("3F22d2G1-p185328B0",[1,7,"imprim","O8+(2):S3x2 < S3xO8+(2):S3"]);
AGR.API("3F24G1-p920808B0",[1,7,"imprim","Fi23 < 3xFi23"]);
AGR.API("3F24d2G1-p920808B0",[1,5,"imprim","Fi23x2 < Fi23xS3"]);
AGR.API("3G23G1-p1134B0",[1,8,"imprim","L3(3).2 < 3xL3(3).2"]);
AGR.API("3L34G1-p360aB0",[1,10,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3L34G1-p360bB0",[1,10,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3L34G1-p360cB0",[1,10,"imprim","L2(7) < 3xL2(7)"]);
AGR.API("3L34G1-p63aB0",[1,4,"imprim","2^4:A5 < 3x2^4:A5"]);
AGR.API("3L34G1-p63bB0",[1,4,"imprim","2^4:A5 < 3x2^4:A5"]);
AGR.API("3M22G1-p2016B0",[1,16,"imprim","L2(11) < 3xL2(11)"]);
AGR.API("3M22G1-p693B0",[1,10,"imprim","2^4:S5 < 3x2^4:S5"]);
AGR.API("3M22G1-p990B0",[1,13,"imprim","2^3:L3(2) < 3x2^3:L3(2)"]);
AGR.API("3McLG1-p103950B0",[1,36,"imprim","U4(2) < 3_2.U4(3)"]);
AGR.API("3McLG1-p340200B0",[1,111,"imprim","M11 < 3xM11"]);
AGR.API("3McLG1-p66825B0",[1,14,"imprim","2.A8 < 3x2.A8"]);
AGR.API("3ONG1-p368280B0",[1,11,"imprim","L3(7).2 < 3xL3(7).2"]);
AGR.API("3ONd2G1-p736560B0",[1,19,"imprim","L3(7).2 < 3.ON"]);
AGR.API("3S6G1-p18aB0",[1,3,"imprim","S5 < (3xA5):2"]);
AGR.API("3S6G1-p18bB0",[1,3,"imprim","S5 < (3xA5):2"]);
AGR.API("3S6G1-p45aB0",[1,5,"imprim","S4x2 < S4xS3"]);
AGR.API("3S6G1-p45bB0",[1,5,"imprim","S4x2 < S4xS3"]);
AGR.API("3S7G1-p63B0",[1,5,"imprim","S5x2 < S5xS3"]);
AGR.API("3S7G1-p90B0",[1,8,"imprim","L2(7) < 3.A7"]);
AGR.API("3SuzG1-p405405B0",[1,23,"imprim","2^(1+6)_-.U4(2) < 3x2^(1+6)_-.U4(2)"]);
AGR.API("3SuzG1-p5346B0",[1,7,"imprim","G2(4) < 3xG2(4)"]);
AGR.API("3SuzG1-p98280B0",[1,14,"imprim","U5(2) < 3xU5(2)"]);
AGR.API("3Suzd2G1-p5346B0",[1,5,"imprim","G2(4).2 < (3xG2(4)).2"]);
AGR.API("3U38G1-p32832B0",[1,145,"imprim","L2(8) < 9xL2(8)"]);
AGR.API("3U38G1-p4617B0",[1,18,"imprim","2^(3+6):7 < 2^(3+6):63"]);
AGR.API("3U62G1-p18711B0",[1,11,"imprim","2^(4+8):(S3xA5) < 3x2^(4+8):(S3xA5)"]);
AGR.API("3U62G1-p19008aB0",[1,10,"imprim","S6(2) < 3xS6(2)"]);
AGR.API("3U62G1-p19008bB0",[1,10,"imprim","S6(2) < 3xS6(2)"]);
AGR.API("3U62G1-p19008cB0",[1,10,"imprim","S6(2) < 3xS6(2)"]);
AGR.API("3U62G1-p2016B0",[1,7,"imprim","U5(2) < 3xU5(2)"]);
AGR.API("3U62G1-p2079B0",[1,7,"imprim","2^(1+8)_+:U4(2) < 3x2^(1+8)_+:U4(2)"]);
AGR.API("4M22G1-p4928aB0",[1,40,"imprim","A6 < 4_1.L3(4)"]);
AGR.API("4M22G1-p4928bB0",[1,40,"imprim","A6 < (4xA6).2_3"]);
AGR.API("4Sz8d3G1-p2080B0",[1,19,"imprim","2^3:7:3 < 2^2.2^(3+3):7:3"]);
AGR.API("4U62G1-p2688B0",[1,9,"imprim","U5(2) < 2^2xU5(2)"]);
AGR.API("4aL34G1-p224B0",[1,8,"imprim","A6 < 4xA6"]);
AGR.API("4aL34G1-p480B0",[1,12,"imprim","L2(7) < 4xL2(7)"]);
AGR.API("4bL34G1-p224B0",[1,10,"imprim","A6 < 4xA6"]);
AGR.API("4bL34G1-p480B0",[1,14,"imprim","L2(7) < 4xL2(7)"]);
AGR.API("6A6G1-p432B0",[1,96,"imprim","5 < 3x2.A5"]);
AGR.API("6A6G1-p720aB0",[1,248,"imprim","3 < 3x2.A5"]);
AGR.API("6A7G1-p720B0",[1,44,"imprim","7:3 < 3x2.L3(2)"]);
AGR.API("6L34G1-p720aB0",[1,20,"imprim","L2(7) < 6xL2(7)"]);
AGR.API("6L34G1-p720bB0",[1,17,"imprim","L2(7) < 6xL2(7)"]);
AGR.API("6L34G1-p720cB0",[1,17,"imprim","L2(7) < 6xL2(7)"]);
AGR.API("6M22G1-p1980B0",[1,17,"imprim","2^3:L3(2) < 6x2^3:L3(2)"]);
AGR.API("6S6G1-p720aB0",[1,136,"imprim","S3 < (3x2.A5):2"]);
AGR.API("6SuzG1-p196560B0",[1,26,"imprim","U5(2) < 6xU5(2)"]);
AGR.API("6U62G1-p38016aB0",[1,17,"imprim","S6(2) < 6xS6(2)"]);
AGR.API("6U62G1-p38016bB0",[1,14,"imprim","S6(2) < 6xS6(2)"]);
AGR.API("6U62G1-p38016cB0",[1,14,"imprim","S6(2) < 6xS6(2)"]);
AGR.API("6U62G1-p4032B0",[1,11,"imprim","U5(2) < 6xU5(2)"]);
AGR.API("A10G1-p10B0",[8,2,"prim","A9",1]);
AGR.API("A10G1-p120B0",[1,4,"prim","(A7x3):2",3]);
AGR.API("A10G1-p126B0",[1,3,"prim","(A5xA5):4",4]);
AGR.API("A10G1-p210B0",[1,5,"prim","(A6xA4):2",5]);
AGR.API("A10G1-p2520B0",[1,12,"prim","A6.2_3",7]);
AGR.API("A10G1-p45B0",[1,3,"prim","S8",2]);
AGR.API("A10G1-p945B0",[1,7,"prim","2^4:S5",6]);
AGR.API("A11G1-p11B0",[9,2,"prim","A10",1]);
AGR.API("A11G1-p165B0",[1,4,"prim","(A8x3):2",3]);
AGR.API("A11G1-p2520aB0",[1,5,"prim","M11",6]);
AGR.API("A11G1-p2520bB0",[1,5,"prim","M11",7]);
AGR.API("A11G1-p330B0",[1,5,"prim","(A7xA4):2",4]);
AGR.API("A11G1-p462B0",[1,6,"prim","(A6xA5):2",5]);
AGR.API("A11G1-p55B0",[1,3,"prim","S9",2]);
AGR.API("A12G1-p12B0",[10,2,"prim","A11",1]);
AGR.API("A12G1-p220B0",[1,4,"prim","(A9x3):2",3]);
AGR.API("A12G1-p2520B0",[1,4,"prim","M12",7]);
AGR.API("A12G1-p462B0",[1,4,"prim","(A6xA6):2^2",4]);
AGR.API("A12G1-p495B0",[1,5,"prim","(A8xA4):2",5]);
AGR.API("A12G1-p66B0",[1,3,"prim","S10",2]);
AGR.API("A12G1-p792B0",[1,6,"prim","(A7xA5):2",6]);
AGR.API("A13G1-p13B0",[11,2,"prim","A12",1]);
AGR.API("A13G1-p78B0",[1,3,"prim","S11",2]);
AGR.API("A14G1-p1001B0",[1,5,"prim","(A10xA4):2",4]);
AGR.API("A14G1-p14B0",[12,2,"prim","A13",1]);
AGR.API("A14G1-p1716B0",[1,4,"prim","(A7xA7):2^2",5]);
AGR.API("A14G1-p2002B0",[1,6,"prim","(A9xA5):2",6]);
AGR.API("A14G1-p3003B0",[1,7,"prim","(A8xA6):2",7]);
AGR.API("A14G1-p364B0",[1,4,"prim","(A11x3):2",3]);
AGR.API("A14G1-p91B0",[1,3,"prim","S12",2]);
AGR.API("A15G1-p105B0",[1,3,"prim","S13",2]);
AGR.API("A15G1-p1365B0",[1,5,"prim","(A11xA4):2",4]);
AGR.API("A15G1-p15B0",[13,2,"prim","A14",1]);
AGR.API("A15G1-p455B0",[1,4,"prim","(A12x3):2",3]);
AGR.API("A16G1-p120B0",[1,3,"prim","S14",2]);
AGR.API("A16G1-p16B0",[14,2,"prim","A15",1]);
AGR.API("A16G1-p1820B0",[1,5,"prim","(A12xA4):2",4]);
AGR.API("A16G1-p560B0",[1,4,"prim","(A13x3):2",3]);
AGR.API("A17G1-p136B0",[1,3,"prim","S15",2]);
AGR.API("A17G1-p17B0",[15,2,"prim","A16",1]);
AGR.API("A17G1-p2380B0",[1,5,"prim","(A13xA4):2",4]);
AGR.API("A17G1-p680B0",[1,4,"prim","(A14x3):2",3]);
AGR.API("A18G1-p153B0",[1,3,"prim","S16",2]);
AGR.API("A18G1-p18B0",[16,2,"prim","A17",1]);
AGR.API("A18G1-p3060B0",[1,5,"prim","(A14xA4):2",4]);
AGR.API("A18G1-p816B0",[1,4,"prim","(A15x3):2",3]);
AGR.API("A19G1-p171B0",[1,3,"prim","S17",2]);
AGR.API("A19G1-p19B0",[17,2,"prim","A18",1]);
AGR.API("A19G1-p969B0",[1,4,"prim","(A16x3):2",3]);
AGR.API("A20G1-p190B0",[1,3,"prim","S18",2]);
AGR.API("A20G1-p20B0",[18,2,"prim","A19",1]);
AGR.API("A21G1-p210B0",[1,3,"prim","S19",2]);
AGR.API("A21G1-p21B0",[19,2,"prim","A20",1]);
AGR.API("A22G1-p22B0",[20,2,"prim","A21",1]);
AGR.API("A22G1-p231B0",[1,3,"prim","S20",2]);
AGR.API("A23G1-p23B0",[21,2,"prim","A22",1]);
AGR.API("A23G1-p253B0",[1,3,"prim","S21",2]);
AGR.API("A5G1-p10B0",[1,3,"prim","S3",3]);
AGR.API("A5G1-p5B0",[3,2,"prim","A4",1]);
AGR.API("A5G1-p6B0",[2,2,"prim","D10",2]);
AGR.API("A6G1-p10B0",[2,2,"prim","3^2:4",3]);
AGR.API("A6G1-p15aB0",[1,3,"prim","S4",4]);
AGR.API("A6G1-p15bB0",[1,3,"prim","S4",5]);
AGR.API("A6G1-p6aB0",[4,2,"prim","A5",1]);
AGR.API("A6G1-p6bB0",[4,2,"prim","A5",2]);
AGR.API("A6V4G1-p10B0",[3,2,"prim","3^2:Q8.2",4]);
AGR.API("A7G1-p7B0",[5,2,"prim","A6",1]);
AGR.API("A8G1-p15aB0",[2,2,"prim","2^3:L3(2)",2]);
AGR.API("A8G1-p15bB0",[2,2,"prim","2^3:L3(2)",3]);
AGR.API("A8G1-p8B0",[6,2,"prim","A7",1]);
AGR.API("A9G1-p120aB0",[1,3,"prim","L2(8):3",4]);
AGR.API("A9G1-p120bB0",[1,3,"prim","L2(8):3",5]);
AGR.API("A9G1-p126B0",[1,5,"prim","(A5xA4):2",6]);
AGR.API("A9G1-p280B0",[1,5,"prim","3^3:S4",7]);
AGR.API("A9G1-p36B0",[1,3,"prim","S7",2]);
AGR.API("A9G1-p840B0",[1,12,"prim","3^2:2A4",8]);
AGR.API("A9G1-p84B0",[1,4,"prim","(A6x3):2_1",3]);
AGR.API("A9G1-p9B0",[7,2,"prim","A8",1]);
AGR.API("Co1G1-p98280B0",[1,4,"prim","Co2",1]);
AGR.API("Co2G1-p2300B0",[1,3,"prim","U6(2).2",1]);
AGR.API("Co2G1-p4600B0",[1,5,"imprim","U6(2) < U6(2).2"]);
AGR.API("Co3G1-p11178B0",[1,5,"prim","HS",2]);
AGR.API("Co3G1-p128800B0",[1,6,"prim","3^5:(2xM11)",5]);
AGR.API("Co3G1-p276B0",[2,2,"prim","McL.2",1]);
AGR.API("Co3G1-p37950B0",[1,8,"prim","U4(3).(2^2)_{133}",3]);
AGR.API("Co3G1-p48600B0",[1,8,"prim","M23",4]);
AGR.API("Co3G1-p552B0",[1,4,"imprim","McL < McL.2"]);
AGR.API("F22G1-p14080bB0",[1,3,"prim","O7(3)",3]);
AGR.API("F22G1-p142155B0",[1,8,"prim","2^10:M22",5]);
AGR.API("F22G1-p3510B0",[1,3,"prim","2.U6(2)",1]);
AGR.API("F22G1-p61776B0",[1,4,"prim","O8+(2):S3",4]);
AGR.API("F22G1-p694980B0",[1,10,"prim","2^6:S6(2)",6]);
AGR.API("F22d2G1-p3510B0",[1,3,"prim","2.U6(2).2",2]);
AGR.API("F23G1-p137632B0",[1,3,"prim","O8+(3):S3",2]);
AGR.API("F23G1-p275264B0",[1,5,"imprim","O8+(3).3 < O8+(3):S3"]);
AGR.API("F23G1-p31671B0",[1,3,"prim","2.Fi22",1]);
AGR.API("F24G1-p306936B0",[1,3,"prim","Fi23",1]);
AGR.API("F24d2G1-p306936B0",[1,3,"prim","Fi23x2",2]);
AGR.API("F42G1-p69888aB0",[1,5,"prim","S8(2)",3]);
AGR.API("G23d2G1-p756B0",[1,6,"imprim","L3(3) < L3(3):2"]);
AGR.API("G24G1-p1365aB0",[1,4,"prim","2^(2+8):(3xA5)",2]);
AGR.API("G24G1-p1365bB0",[1,4,"prim","2^(4+6):(A5x3)",3]);
AGR.API("G24G1-p2016B0",[1,3,"prim","U3(4).2",4]);
AGR.API("G24G1-p20800B0",[1,14,"prim","U3(3).2",6]);
AGR.API("G24G1-p2080B0",[1,4,"prim","3.L3(4).2_3",5]);
AGR.API("G24G1-p416B0",[1,3,"prim","J2",1]);
AGR.API("G25G1-p3906aB0",[1,4,"prim","5^(1+4)_+:GL(2,5)",1]);
AGR.API("G25G1-p3906bB0",[1,4,"prim","5^(2+3):GL2(5)",2]);
AGR.API("G25G1-p7750B0",[1,4,"prim","3.U3(5).2",3]);
AGR.API("G25G1-p7875B0",[1,5,"prim","L3(5).2",4]);
AGR.API("HNG1-p1140000B0",[1,12,"prim","A12",1]);
AGR.API("HSG1-p100B0",[1,3,"prim","M22",1]);
AGR.API("HSG1-p1100aB0",[1,5,"prim","L3(4).2_1",4]);
AGR.API("HSG1-p1100bB0",[1,5,"prim","A8.2",5]);
AGR.API("HSG1-p15400B0",[1,27,"prim","2xA6.2^2",11]);
AGR.API("HSG1-p176bB0",[2,2,"prim","U3(5):2",3]);
AGR.API("HSG1-p3850B0",[1,12,"prim","2^4.S6",6]);
AGR.API("HSG1-p4125B0",[1,9,"prim","4^3:L3(2)",7]);
AGR.API("HSG1-p5600aB0",[1,9,"prim","M11",8]);
AGR.API("HSd2G1-p100B0",[1,3,"prim","M22.2",2]);
AGR.API("HSd2G1-p1100bB0",[1,5,"prim","S8x2",4]);
AGR.API("HSd2G1-p15400B0",[1,20,"prim","(2xA6.2^2).2",8]);
AGR.API("HSd2G1-p352B0",[1,4,"imprim","U3(5).2 < HS"]);
AGR.API("HeG1-p2058B0",[1,5,"prim","S4(4):2",1]);
AGR.API("HeG1-p244800B0",[1,36,"prim","7^2:2L2(7)",6]);
AGR.API("HeG1-p29155B0",[1,12,"prim","2^6:3.S6",3]);
AGR.API("HeG1-p8330B0",[1,7,"prim","2^2.L3(4).S3",2]);
AGR.API("Hed2G1-p2058B0",[1,4,"prim","S4(4):4",2]);
AGR.API("Hed2G1-p8330B0",[1,6,"prim","2^2.L3(4).D12",3]);
AGR.API("J1G1-p1045B0",[1,11,"prim","2^3:7:3",2]);
AGR.API("J1G1-p1463B0",[1,22,"prim","2xA5",3]);
AGR.API("J1G1-p1540B0",[1,21,"prim","19:6",4]);
AGR.API("J1G1-p1596B0",[1,19,"prim","11:10",5]);
AGR.API("J1G1-p266B0",[1,5,"prim","L2(11)",1]);
AGR.API("J1G1-p2926B0",[1,67,"prim","D6xD10",6]);
AGR.API("J1G1-p4180B0",[1,107,"prim","7:6",7]);
AGR.API("J2G1-p1008B0",[1,11,"prim","A5xD10",6]);
AGR.API("J2G1-p100B0",[1,3,"prim","U3(3)",1]);
AGR.API("J2G1-p1800B0",[1,18,"prim","L3(2).2",7]);
AGR.API("J2G1-p280B0",[1,4,"prim","3.A6.2_2",2]);
AGR.API("J2G1-p315B0",[1,6,"prim","2^(1+4)_-:A5",3]);
AGR.API("J2G1-p525B0",[1,6,"prim","2^(2+4):(3xS3)",4]);
AGR.API("J2G1-p840B0",[1,7,"prim","A4xA5",5]);
AGR.API("J2d2G1-p100B0",[1,3,"prim","U3(3).2",2]);
AGR.API("J3G1-p14688aB0",[1,14,"prim","L2(19)",2]);
AGR.API("J3G1-p14688bB0",[1,14,"prim","L2(19)",3]);
AGR.API("J3G1-p17442B0",[1,19,"prim","2^4:(3xA5)",4]);
AGR.API("J3G1-p20520B0",[1,22,"prim","L2(17)",5]);
AGR.API("J3G1-p23256B0",[1,28,"prim","(3xA6):2_2",6]);
AGR.API("J3G1-p25840B0",[1,20,"prim","3^2.3^(1+2)_+:8",7]);
AGR.API("J3G1-p26163B0",[1,27,"prim","2^(1+4)_-:A5",8]);
AGR.API("J3G1-p43605B0",[1,57,"prim","2^(2+4).(3xS3)",9]);
AGR.API("J3G1-p6156B0",[1,8,"prim","L2(16).2",1]);
AGR.API("J3d2G1-p6156B0",[1,7,"prim","L2(16).4",2]);
AGR.API("L211G1-p11aB0",[2,2,"prim","A5",1]);
AGR.API("L211G1-p11bB0",[2,2,"prim","A5",2]);
AGR.API("L211G1-p12B0",[2,2,"prim","11:5",3]);
AGR.API("L211G1-p55B0",[1,9,"prim","S3x2",4]);
AGR.API("L211d2G1-p12B0",[3,2,"prim","11:10",2]);
AGR.API("L211d2G1-p22B0",[1,4,"imprim","A5 < L2(11)"]);
AGR.API("L211d2G1-p55aB0",[1,6,"prim","D24",3]);
AGR.API("L211d2G1-p55bB0",[1,6,"prim","S4",4]);
AGR.API("L211d2G1-p66B0",[1,7,"prim","D20",5]);
AGR.API("L213G1-p14B0",[2,2,"prim","13:6",1]);
AGR.API("L213d2G1-p14B0",[3,2,"prim","13:12",2]);
AGR.API("L213d2G1-p78B0",[1,7,"prim","D28",3]);
AGR.API("L213d2G1-p91aB0",[1,8,"prim","D24",4]);
AGR.API("L216G1-p17B0",[3,2,"prim","2^4:15",1]);
AGR.API("L217G1-p18B0",[2,2,"prim","17:8",1]);
AGR.API("L217d2G1-p18B0",[3,2,"prim","17:16",2]);
AGR.API("L219G1-p171B0",[1,15,"prim","D20",4]);
AGR.API("L219G1-p190B0",[1,16,"prim","D18",5]);
AGR.API("L219G1-p20B0",[2,2,"prim","19:9",1]);
AGR.API("L219G1-p57aB0",[1,4,"prim","A5",2]);
AGR.API("L219G1-p57bB0",[1,4,"prim","A5",3]);
AGR.API("L219d2G1-p114B0",[1,8,"imprim","A5 < L2(19)"]);
AGR.API("L219d2G1-p171B0",[1,10,"prim","D40",3]);
AGR.API("L219d2G1-p190B0",[1,11,"prim","D36",4]);
AGR.API("L219d2G1-p20B0",[3,2,"prim","19:18",2]);
AGR.API("L219d2G1-p285B0",[1,18,"prim","S4",5]);
AGR.API("L223G1-p24B0",[2,2,"prim","23:11",1]);
AGR.API("L227G1-p28B0",[2,2,"prim","3^3:13",1]);
AGR.API("L229G1-p30B0",[2,2,"prim","29:14",1]);
AGR.API("L231G1-p32B0",[2,2,"prim","31:15",1]);
AGR.API("L232G1-p33B0",[3,2,"prim","2^5:31",1]);
AGR.API("L232G1-p496B0",[1,16,"prim","D66",2]);
AGR.API("L232G1-p528B0",[1,17,"prim","D62",3]);
AGR.API("L232d5G1-p33B0",[3,2,"prim","2^5:31:5",2]);
AGR.API("L232d5G1-p496B0",[1,4,"prim","33:10",3]);
AGR.API("L232d5G1-p528B0",[1,5,"prim","31:10",4]);
AGR.API("L249G1-p1176B0",[1,36,"prim","D50",6]);
AGR.API("L249G1-p1225B0",[1,39,"prim","D48",7]);
AGR.API("L249G1-p175aB0",[1,5,"prim","L3(2).2",2]);
AGR.API("L249G1-p175bB0",[1,5,"prim","L3(2).2",3]);
AGR.API("L249G1-p50B0",[2,2,"prim","7^2:24",1]);
AGR.API("L249G1-p980aB0",[1,24,"prim","A5",4]);
AGR.API("L249G1-p980bB0",[1,24,"prim","A5",5]);
AGR.API("L27G1-p14aB0",[1,3,"imprim","A4 < S4"]);
AGR.API("L27G1-p14bB0",[1,3,"imprim","A4 < S4"]);
AGR.API("L27G1-p168B0",[1,168,"imprim","1 < S4"]);
AGR.API("L27G1-p21B0",[1,6,"imprim","D8 < S4"]);
AGR.API("L27G1-p24B0",[1,6,"imprim","7 < 7:3"]);
AGR.API("L27G1-p28B0",[1,7,"imprim","S3 < S4"]);
AGR.API("L27G1-p42aB0",[1,15,"imprim","2^2 < S4"]);
AGR.API("L27G1-p42bB0",[1,15,"imprim","2^2 < S4"]);
AGR.API("L27G1-p42cB0",[1,12,"imprim","4 < S4"]);
AGR.API("L27G1-p56B0",[1,20,"imprim","3 < S4"]);
AGR.API("L27G1-p7aB0",[2,2,"prim","S4",1]);
AGR.API("L27G1-p7bB0",[2,2,"prim","S4",2]);
AGR.API("L27G1-p84B0",[1,44,"imprim","2 < S4"]);
AGR.API("L27G1-p8B0",[2,2,"prim","7:3",3]);
AGR.API("L27d2G1-p112B0",[1,40,"imprim","3 < 7:3"]);
AGR.API("L27d2G1-p14B0",[1,4,"imprim","S4 < L2(7)"]);
AGR.API("L27d2G1-p168aB0",[1,88,"imprim","2 < S4"]);
AGR.API("L27d2G1-p168bB0",[1,87,"imprim","2 < D12"]);
AGR.API("L27d2G1-p16B0",[1,4,"imprim","7:3 < 7:6"]);
AGR.API("L27d2G1-p21B0",[1,4,"prim","D16",3]);
AGR.API("L27d2G1-p24B0",[1,6,"imprim","D14 < 7:6"]);
AGR.API("L27d2G1-p28B0",[1,5,"prim","D12",4]);
AGR.API("L27d2G1-p28bB0",[1,6,"imprim","A4 < S4"]);
AGR.API("L27d2G1-p336B0",[1,336,"imprim","1 < L2(7)"]);
AGR.API("L27d2G1-p42aB0",[1,12,"imprim","D8 < S4"]);
AGR.API("L27d2G1-p42bB0",[1,9,"imprim","D8 < D16"]);
AGR.API("L27d2G1-p42cB0",[1,7,"imprim","8 < D16"]);
AGR.API("L27d2G1-p48B0",[1,12,"imprim","7 < 7:6"]);
AGR.API("L27d2G1-p56aB0",[1,14,"imprim","S3 < S4"]);
AGR.API("L27d2G1-p56bB0",[1,13,"imprim","S3 < D12"]);
AGR.API("L27d2G1-p56cB0",[1,11,"imprim","6 < D12"]);
AGR.API("L27d2G1-p84aB0",[1,30,"imprim","2^2 < S4"]);
AGR.API("L27d2G1-p84bB0",[1,25,"imprim","2^2 < D12"]);
AGR.API("L27d2G1-p84cB0",[1,24,"imprim","4 < S4"]);
AGR.API("L27d2G1-p8B0",[3,2,"prim","7:6",2]);
AGR.API("L28G1-p28B0",[1,4,"prim","D18",2]);
AGR.API("L28G1-p36B0",[1,5,"prim","D14",3]);
AGR.API("L28G1-p9B0",[3,2,"prim","2^3:7",1]);
AGR.API("L28d3G1-p28B0",[2,2,"prim","9:6",3]);
AGR.API("L28d3G1-p36B0",[1,3,"prim","7:6",4]);
AGR.API("L28d3G1-p9B0",[3,2,"prim","2^3:7:3",2]);
AGR.API("L311G1-p133B0",[2,2,"prim","11^2:(5x2L2(11).2)",1]);
AGR.API("L313G1-p183aB0",[2,2,"prim","13^2:GL(2,13)",1]);
AGR.API("L313G1-p183bB0",[2,2,"prim","13^2:GL(2,13)",2]);
AGR.API("L33G1-p13aB0",[2,2,"prim","3^2:2S4",1]);
AGR.API("L33G1-p13bB0",[2,2,"prim","3^2:2S4",2]);
AGR.API("L33G1-p144B0",[1,8,"prim","13:3",3]);
AGR.API("L33G1-p234B0",[1,18,"prim","S4",4]);
AGR.API("L33d2G1-p117B0",[1,6,"prim","2S4:2",3]);
AGR.API("L33d2G1-p144B0",[1,6,"prim","13:6",4]);
AGR.API("L33d2G1-p234B0",[1,12,"prim","S4x2",5]);
AGR.API("L33d2G1-p26B0",[1,4,"imprim","3^2:2S4 < L3(3)"]);
AGR.API("L33d2G1-p52B0",[1,4,"prim","3^(1+2)_+:D8",2]);
AGR.API("L34G1-p120aB0",[1,4,"prim","L3(2)",6]);
AGR.API("L34G1-p120bB0",[1,4,"prim","L3(2)",7]);
AGR.API("L34G1-p120cB0",[1,4,"prim","L3(2)",8]);
AGR.API("L34G1-p21aB0",[2,2,"prim","2^4:A5",1]);
AGR.API("L34G1-p21bB0",[2,2,"prim","2^4:A5",2]);
AGR.API("L34G1-p280B0",[1,8,"prim","3^2:Q8",9]);
AGR.API("L34G1-p56aB0",[1,3,"prim","A6",3]);
AGR.API("L34G1-p56bB0",[1,3,"prim","A6",4]);
AGR.API("L34G1-p56cB0",[1,3,"prim","A6",5]);
AGR.API("L35G1-p31aB0",[2,2,"prim","5^2:GL2(5)",1]);
AGR.API("L35G1-p31bB0",[2,2,"prim","5^2:GL2(5)",2]);
AGR.API("L35d2G1-p186B0",[1,4,"prim","5^(1+2)_+:[2^5]",2]);
AGR.API("L35d2G1-p3100B0",[1,32,"prim","S5x2",4]);
AGR.API("L35d2G1-p3875B0",[1,35,"prim","4^2:D12",5]);
AGR.API("L35d2G1-p4000B0",[1,35,"prim","31:6",6]);
AGR.API("L35d2G1-p62B0",[1,4,"imprim","5^2:GL2(5) < L3(5)"]);
AGR.API("L35d2G1-p775B0",[1,8,"prim","4S5.2",3]);
AGR.API("L37G1-p57B0",[2,2,"prim","7^2:2.L2(7).2",1]);
AGR.API("L38G1-p56064B0",[1,220,"prim","7^2:S3",3]);
AGR.API("L38G1-p73aB0",[2,2,"prim","2^6:(7xL2(8))",1]);
AGR.API("L38G1-p73bB0",[2,2,"prim","2^6:(7xL2(8))",2]);
AGR.API("L38G1-p75264B0",[1,372,"prim","73:3",4]);
AGR.API("L38G1-p98112B0",[1,653,"prim","L3(2)",5]);
AGR.API("L38d2G1-p146B0",[1,4,"imprim","2^6:(7xL2(8)) < L3(8)"]);
AGR.API("L38d2G1-p4672B0",[1,11,"prim","D14xL2(8)",3]);
AGR.API("L38d2G1-p56064B0",[1,125,"prim","7^2:D12",4]);
AGR.API("L38d2G1-p657B0",[1,4,"prim","2^(3+6):7^2:2",2]);
AGR.API("L38d2G1-p75264B0",[1,216,"prim","73:6",5]);
AGR.API("L38d2G1-p98112B0",[1,335,"prim","L2(7).2",6]);
AGR.API("L38d3G1-p219aB0",[1,6,"imprim","2^6:(7xL2(8)) < 2^6:(7xL2(8)):3"]);
AGR.API("L38d3G1-p219bB0",[1,6,"imprim","2^6:(7xL2(8)) < 2^6:(7xL2(8)):3"]);
AGR.API("L38d3G1-p56064B0",[1,80,"prim","7^2:(3xS3)",4]);
AGR.API("L38d3G1-p73aB0",[2,2,"prim","2^6:(7xL2(8)):3",2]);
AGR.API("L38d3G1-p73bB0",[2,2,"prim","2^6:(7xL2(8)):3",3]);
AGR.API("L38d3G1-p75264B0",[1,126,"prim","73:9",5]);
AGR.API("L38d3G1-p98112B0",[1,381,"imprim","L2(8) < 2^6:(7xL2(8)):3"]);
AGR.API("L38d6G1-p438B0",[1,12,"imprim","2^6:(7xL2(8)) < L3(8)"]);
AGR.API("L38d6G1-p4672B0",[1,7,"prim","(D14xL2(8)):3",3]);
AGR.API("L38d6G1-p56064B0",[1,47,"prim","7^2:(6xS3)",4]);
AGR.API("L38d6G1-p657B0",[1,4,"prim","2^(3+6):7^2:6",2]);
AGR.API("L38d6G1-p75264B0",[1,74,"prim","73:18",5]);
AGR.API("L38d6G1-p98112B0",[1,119,"prim","L2(7).2x3",6]);
AGR.API("L44G1-p85aB0",[2,2,"prim","2^6:GL(3,4)",1]);
AGR.API("L44G1-p85bB0",[2,2,"prim","2^6:GL(3,4)",2]);
AGR.API("L45G1-p156aB0",[2,2,"prim","5^3:L3(5)",1]);
AGR.API("L45G1-p156bB0",[2,2,"prim","5^3:L3(5)",2]);
AGR.API("L52G1-p155aB0",[1,3,"prim","2^6:(S3xL3(2))",3]);
AGR.API("L52G1-p31aB0",[2,2,"prim","2^4:L4(2)",1]);
AGR.API("L52d2G1-p62B0",[1,4,"imprim","2^4:L4(2) < L5(2)"]);
AGR.API("L62G1-p63aB0",[2,2,"prim","2^5:L5(2)",1]);
AGR.API("L62d2G1-p126B0",[1,4,"imprim","2^5:L5(2) < L6(2)"]);
AGR.API("L72G1-p127aB0",[2,2,"prim","2^6:L6(2)",1]);
AGR.API("L72G1-p127bB0",[2,2,"prim","2^6:L6(2)",1]);
AGR.API("L72d2G2-p254B0",[1,4,"imprim","2^6:L6(2) < L7(2)"]);
AGR.API("M10G1-p10B0",[3,2,"prim","3^2:Q8",2]);
AGR.API("M11G1-p11B0",[4,2,"prim","A6.2_3",1]);
AGR.API("M11G1-p12B0",[3,2,"prim","L2(11)",2]);
AGR.API("M11G1-p165B0",[1,8,"prim","2.S4",5]);
AGR.API("M11G1-p55B0",[1,3,"prim","3^2:Q8.2",3]);
AGR.API("M11G1-p66B0",[1,4,"prim","S5",4]);
AGR.API("M12G1-p12aB0",[5,2,"prim","M11",1]);
AGR.API("M12G1-p12bB0",[5,2,"prim","M11",2]);
AGR.API("M12G1-p66aB0",[1,3,"prim","A6.2^2",3]);
AGR.API("M12G1-p66bB0",[1,3,"prim","A6.2^2",4]);
AGR.API("M12d2G1-p24B0",[1,3,"imprim","M11 < M12"]);
AGR.API("M20G1-p20aB0",[1,3,"imprim","2^4:3 < 2^4:A4"]);
AGR.API("M20G1-p20bB0",[1,3,"imprim","4^2:3 < 2^4:A4"]);
AGR.API("M20G1-p20cB0",[1,3,"imprim","4^2:3 < 2^4:A4"]);
AGR.API("M20G1-p20dB0",[1,3,"imprim","4^2:3 < 2^4:A4"]);
AGR.API("M22G1-p176aB0",[1,3,"prim","A7",3]);
AGR.API("M22G1-p176bB0",[1,3,"prim","A7",4]);
AGR.API("M22G1-p22B0",[3,2,"prim","L3(4)",1]);
AGR.API("M22G1-p231B0",[1,4,"prim","2^4:S5",5]);
AGR.API("M22G1-p330B0",[1,5,"prim","2^3:L3(2)",6]);
AGR.API("M22G1-p462aB0",[1,5,"imprim","2^4:A5 < 2^4:A6"]);
AGR.API("M22G1-p462bB0",[1,8,"imprim","2^4:A5 < L3(4), 2^4:S5"]);
AGR.API("M22G1-p462cB0",[1,8,"imprim","2^4:A5 < L3(4), 2^4:A6"]);
AGR.API("M22G1-p616B0",[1,5,"prim","A6.2_3",7]);
AGR.API("M22G1-p672B0",[1,6,"prim","L2(11)",8]);
AGR.API("M22G1-p770B0",[1,9,"imprim","(A4xA4):4 < 2^4:A6"]);
AGR.API("M22G1-p77B0",[1,3,"prim","2^4:A6",2]);
AGR.API("M22d2G1-p22B0",[3,2,"prim","L3(4).2_2",2]);
AGR.API("M22d2G1-p231B0",[1,4,"prim","2^5:S5",4]);
AGR.API("M22d2G1-p330B0",[1,5,"prim","2x2^3:L3(2)",5]);
AGR.API("M22d2G1-p352B0",[1,6,"imprim","A7 < M22"]);
AGR.API("M22d2G1-p616B0",[1,5,"prim","A6.2^2",6]);
AGR.API("M22d2G1-p672B0",[1,6,"prim","L2(11).2",7]);
AGR.API("M22d2G1-p77B0",[1,3,"prim","2^4:S6",3]);
AGR.API("M23G1-p1288B0",[1,4,"prim","M11",5]);
AGR.API("M23G1-p1771B0",[1,8,"prim","2^4:(3xA5):2",6]);
AGR.API("M23G1-p23B0",[4,2,"prim","M22",1]);
AGR.API("M23G1-p253aB0",[1,3,"prim","L3(4).2_2",2]);
AGR.API("M23G1-p253bB0",[1,3,"prim","2^4:A7",3]);
AGR.API("M23G1-p40320B0",[1,164,"prim","23:11",7]);
AGR.API("M23G1-p506B0",[1,4,"prim","A8",4]);
AGR.API("M24G1-p1288B0",[1,3,"prim","M12.2",4]);
AGR.API("M24G1-p1771B0",[1,4,"prim","2^6:3.S6",5]);
AGR.API("M24G1-p2024B0",[1,5,"prim","L3(4).S3",6]);
AGR.API("M24G1-p24B0",[5,2,"prim","M23",1]);
AGR.API("M24G1-p276B0",[1,3,"prim","M22.2",2]);
AGR.API("M24G1-p3795B0",[1,5,"prim","2^6:(L3(2)xS3)",7]);
AGR.API("M24G1-p759B0",[1,4,"prim","2^4:A8",3]);
AGR.API("McLG1-p113400B0",[1,39,"prim","M11",11]);
AGR.API("McLG1-p15400aB0",[1,5,"prim","3^(1+4)_+:2S5",5]);
AGR.API("McLG1-p15400bB0",[1,10,"prim","3^4:M10",6]);
AGR.API("McLG1-p2025aB0",[1,4,"prim","M22",2]);
AGR.API("McLG1-p2025bB0",[1,4,"prim","M22",3]);
AGR.API("McLG1-p22275aB0",[1,13,"prim","L3(4).2_2",7]);
AGR.API("McLG1-p22275bB0",[1,6,"prim","2.A8",8]);
AGR.API("McLG1-p22275cB0",[1,13,"prim","2^4:A7",10]);
AGR.API("McLG1-p22275dB0",[1,13,"prim","2^4:A7",9]);
AGR.API("McLG1-p275B0",[1,3,"prim","U4(3)",1]);
AGR.API("McLG1-p299376B0",[1,114,"prim","5^(1+2)_+:3:8",12]);
AGR.API("McLG1-p7128B0",[1,5,"prim","U3(5)",4]);
AGR.API("McLd2G1-p22275aB0",[1,11,"prim","L3(4).2^2",6]);
AGR.API("McLd2G1-p275B0",[1,3,"prim","U4(3).2_3",2]);
AGR.API("McLd2G1-p4050B0",[1,8,"imprim","M22 < McL"]);
AGR.API("McLd2G1-p44550B0",[1,26,"imprim","2^4:A7 < McL"]);
AGR.API("McLd2G1-p7128B0",[1,5,"prim","U3(5).2",3]);
AGR.API("Mmax13G0-p3369B0",[0,[9,3360]]);
AGR.API("Mmax15q1G0-p6561B0",[1,4,"imprim","3^6:(L3(3)xSD16) < 3^(2+6):(L3(3)xSD16)"]);
AGR.API("Mmax15q2G0-p1404B0",[1,10,"imprim","3^(5+4):(3^2.2.S4x2^2) < 3^(6+6):(3^2.2.S4xSD16)"]);
AGR.API("Mmax15q3G0-p108B0",[1,4,"imprim","2x3^3.(L3(3)x2) < 3^6:(L3(3)xD8)"]);
AGR.API("Mmax16G0-p78125B0",[1,6,"imprim","2.J2.4 < (5x2.J2).4"]);
AGR.API("Mmax17G0-p2065B0",[0,[7,2058]]);
AGR.API("Mmax18G0-p17B0",[0,[5,12]]);
AGR.API("Mmax19G0-p46500B0",[1,115,"imprim","5^(2+2).(2x5^2:(4x2)) < 5^(3+3).(2x5^2:GL2(5))"]);
AGR.API("Mmax19G0-p7750B0",[1,7,"imprim","5^(2+3).GL2(5) < 5^(3+3).(2x5^2:GL2(5))"]);
AGR.API("Mmax19G0-p96875B0",[1,28,"imprim","5^3.(2xGL2(5)) < 5^(3+3).(2x5^2:GL2(5))"]);
AGR.API("Mmax20G0-p30B0",[1,3,"imprim","(A6xA6x3^2:4).(2xD8) < (A6xA6xA6).(2xD8)"]);
AGR.API("Mmax21G0-p3653B0",[0,[5,3648]]);
AGR.API("Mmax21G0-p518B0",[0,[5,513]]);
AGR.API("Mmax22G0-p15625B0",[1,9,"imprim","5^2:(S3xGL2(5)) < 5^4:(S3xGL2(5))"]);
AGR.API("Mmax22G0-p750B0",[1,5,"imprim","5^(3+2):(S3x4x5:4) < 5^(2+2+4):(S3x4x5:4)"]);
AGR.API("Mmax23G0-p184B0",[0,[14,170]]);
AGR.API("Mmax23G0-p524B0",[0,[14,510]]);
AGR.API("Mmax24G0-p16807B0",[1,8,"imprim","3x2.S7 < (7:3x2.A7).2"]);
AGR.API("Mmax25G0-p151B0",[0,[25,126]]);
AGR.API("Mmax26G0-p36B0",[0,[12,24]]);
AGR.API("Mmax27G0-p17B0",[0,[7,10]]);
AGR.API("Mmax28G0-p625B0",[2,2,"prim","(3x2.L2(25)).2","???"]);
AGR.API("Mmax29G0-p2401B0",[1,5,"imprim","(7:3xSL2(7)):2 < 7^3:GL2(7)"]);
AGR.API("Mmax29G0-p392B0",[1,4,"imprim","7^(1+2)_+:(6x7:6) < 7^(2+1+2):(6x7:6)"]);
AGR.API("Mmax30G0-p21B0",[0,[10,11]]);
AGR.API("Mmax31G0-p15B0",[1,3,"imprim","S4x(S5xS5):2 < S5x(S5xS5):2"]);
AGR.API("Mmax32G0-p24B0",[1,3,"imprim","(L2(11)x11:5):2 < (L2(11)xL2(11)):2"]);
AGR.API("Mmax33G0-p169B0",[2,2,"prim","2.L2(13).4","???"]);
AGR.API("Mmax34G0-p57B0",[0,[8,49]]);
AGR.API("Mmax35G0-p39B0",[0,[13,26]]);
AGR.API("Mmax36G0-p2197B0",[1,11,"imprim","3x4S4 < (13x4S4):3"]);
AGR.API("Mmax39G0-p121B0",[2,2,"prim","5x2A5",5]);
AGR.API("Mmax41G0-p49B0",[2,2,"prim","2.L2(7)",4]);
AGR.API("Mmax43G0-p41B0",[2,2,"prim","40",3]);
AGR.API("O10m2G1-p495B0",[1,3,"prim","2^8:O8-(2)",1]);
AGR.API("O10m2G1-p528B0",[1,3,"prim","S8(2)",2]);
AGR.API("O10m2d2G1-p104448B0",[1,6,"prim","S12",8]);
AGR.API("O10m2d2G1-p495B0",[1,3,"prim","2^8:O8-(2):2",2]);
AGR.API("O10m2d2G1-p528B0",[1,3,"prim","S8(2)x2",3]);
AGR.API("O10p2G1-p19840B0",[1,5,"prim","(3xO8-(2)):2",5]);
AGR.API("O10p2G1-p2295aB0",[1,3,"prim","2^10:L5(2)",3]);
AGR.API("O10p2G1-p2295bB0",[1,3,"prim","2^10:L5(2)",4]);
AGR.API("O10p2G1-p23715B0",[1,6,"prim","2^(1+12)_+:(S3xA8)",6]);
AGR.API("O10p2G1-p39680B0",[1,8,"imprim","3xO8-(2)"]);
AGR.API("O10p2G1-p496B0",[1,3,"prim","S8(2)",1]);
AGR.API("O10p2G1-p527B0",[1,3,"prim","2^8:O8+(2)",2]);
AGR.API("O10p2d2G1-p4590B0",[1,6,"imprim","2^10:L5(2) < O10+(2)"]);
AGR.API("O10p2d2G1-p496B0",[1,3,"prim","S8(2)x2",2]);
AGR.API("O10p2d2G1-p527B0",[1,3,"prim","2^8:O8+(2):2",3]);
AGR.API("O73G1-p1080aB0",[1,3,"prim","G2(3)",4]);
AGR.API("O73G1-p1080bB0",[1,3,"prim","G2(3)",5]);
AGR.API("O73G1-p1120B0",[1,4,"prim","3^(3+3):L3(3)",6]);
AGR.API("O73G1-p351B0",[1,3,"prim","2.U4(3).2_2",1]);
AGR.API("O73G1-p3640B0",[1,5,"prim","3^(1+6)_+:(2A4xA4).2",9]);
AGR.API("O73G1-p364B0",[1,3,"prim","3^5:U4(2):2",2]);
AGR.API("O73G1-p378B0",[1,3,"prim","L4(3).2_2",3]);
AGR.API("O73d2G1-p351B0",[1,3,"prim","2.U4(3).(2^2)_{122}",2]);
AGR.API("O8m2G1-p1071B0",[1,5,"prim","2^(1+8)_+:(S3xA5)",4]);
AGR.API("O8m2G1-p119B0",[1,3,"prim","2^6:U4(2)",1]);
AGR.API("O8m2G1-p136B0",[1,3,"prim","S6(2)",2]);
AGR.API("O8m2G1-p1632B0",[1,5,"prim","(3xA8):2",5]);
AGR.API("O8m2G1-p24192B0",[1,16,"prim","L2(16):2",6]);
AGR.API("O8m2G1-p45696B0",[1,47,"prim","(S3xS3xA5):2",7]);
AGR.API("O8m2G1-p765B0",[1,4,"prim","2^(3+6):(L3(2)x3)",3]);
AGR.API("O8m2d2G1-p119B0",[1,3,"prim","2^6:U4(2):2",2]);
AGR.API("O8m3G1-p1066B0",[1,3,"prim","3^6:2.U4(3).2",1]);
AGR.API("O8m3V4G1-p1066B0",[1,3,"prim","3^6:2.U4(3).D8",4]);
AGR.API("O8m3d2aG1-p1066B0",[1,3,"prim","3^6:2.U4(3).(2^2)_{122}",2]);
AGR.API("O8m3d2cG1-p1066B0",[1,3,"prim","3^6:2.U4(3).(2^2)_{133}",2]);
AGR.API("O8m3d2cG2-p1066B0",[1,3,"prim","3^6:2.U4(3).(2^2)_{133}",2]);
AGR.API("O8p3G1-p1080aB0",[1,3,"prim","O7(3)",1]);
AGR.API("O8p3G1-p1080bB0",[1,3,"prim","O7(3)",2]);
AGR.API("O8p3G1-p1080cB0",[1,3,"prim","O7(3)",3]);
AGR.API("O8p3G1-p1080dB0",[1,3,"prim","O7(3)",4]);
AGR.API("O8p3G1-p1080eB0",[1,3,"prim","O7(3)",5]);
AGR.API("O8p3G1-p1080fB0",[1,3,"prim","O7(3)",6]);
AGR.API("O8p3G1-p1120aB0",[1,3,"prim","3^6:L4(3)",7]);
AGR.API("O8p3G1-p1120bB0",[1,3,"prim","3^6:L4(3)",8]);
AGR.API("O8p3G1-p1120cB0",[1,3,"prim","3^6:L4(3)",9]);
AGR.API("O8p3G1-p28431aB0",[1,6,"prim","O8+(2)",10]);
AGR.API("O8p3G1-p28431bB0",[1,6,"prim","O8+(2)",11]);
AGR.API("O8p3G1-p28431cB0",[1,6,"prim","O8+(2)",12]);
AGR.API("O8p3G1-p28431dB0",[1,6,"prim","O8+(2)",13]);
AGR.API("O8p3G1-p36400B0",[1,7,"prim","3^(1+8)_+:2(A4xA4xA4).2",14]);
AGR.API("O8p3S4G2-p3360B0",[1,5,"imprim","3^6:L4(3).D8 < O8+(3).D8"]);
AGR.API("O8p3S4G2-p6480B0",[1,6,"imprim","O7(3).2x2 < O8+(3).(2^2)_{122}"]);
AGR.API("ONG1-p122760aB0",[1,5,"prim","L3(7).2",1]);
AGR.API("ONd2G1-p245520B0",[1,9,"imprim","L3(7).2 < ON"]);
AGR.API("PGL29G1-p10B0",[3,2,"prim","3^2:8",2]);
AGR.API("R27G1-p19684B0",[2,2,"prim","3^(3+6):26",1]);
AGR.API("R27d3G1-p19684B0",[2,2,"prim","3^(3+6):26:3",2]);
AGR.API("RuG1-p4060B0",[1,3,"prim","2F4(2)'.2",1]);
AGR.API("S102G1-p1023B0",[1,3,"prim","2^9.S8(2)",3]);
AGR.API("S102G1-p1056B0",[1,4,"imprim","O10+(2) < O10+(2).2"]);
AGR.API("S102G1-p496B0",[2,2,"prim","O10-(2).2",1]);
AGR.API("S102G1-p528B0",[2,2,"prim","O10+(2).2",2]);
AGR.API("S102G1-p992B0",[1,4,"imprim","O10-(2) < O10-(2).2"]);
AGR.API("S10G1-p10B0",[10,2,"prim","S9",2]);
AGR.API("S11G1-p11B0",[11,2,"prim","S10",2]);
AGR.API("S12G1-p10395B0",[1,11,"prim","2^5:S6",9]);
AGR.API("S12G1-p12B0",[12,2,"prim","S11",2]);
AGR.API("S12G1-p15400B0",[1,12,"prim","3^4:2^3.S4",10]);
AGR.API("S12G1-p220B0",[1,4,"prim","(A9x3):2",4]);
AGR.API("S12G1-p462B0",[1,4,"prim","(A6xA6):2^2",5]);
AGR.API("S12G1-p495B0",[1,5,"prim","(A8xA4):2",6]);
AGR.API("S12G1-p5040B0",[1,8,"imprim","M12 < A12"]);
AGR.API("S12G1-p5775B0",[1,9,"prim","2^6:3^3:S4",8]);
AGR.API("S12G1-p66B0",[1,3,"prim","S10",3]);
AGR.API("S12G1-p792B0",[1,6,"prim","(A7xA5):2",7]);
AGR.API("S13G1-p13B0",[13,2,"prim","S12",2]);
AGR.API("S13G1-p78B0",[1,3,"prim","S11x2",3]);
AGR.API("S14G1-p1001B0",[1,5,"prim","S10xS4",5]);
AGR.API("S14G1-p14B0",[14,2,"prim","S13",2]);
AGR.API("S14G1-p1716B0",[1,4,"prim","(S7xS7):2",6]);
AGR.API("S14G1-p2002B0",[1,6,"prim","S9xS5",7]);
AGR.API("S14G1-p3003B0",[1,7,"prim","S8xS6",8]);
AGR.API("S14G1-p364B0",[1,4,"prim","S11xS3",4]);
AGR.API("S14G1-p91B0",[1,3,"prim","S12x2",3]);
AGR.API("S15G1-p105B0",[1,3,"prim","S13x2",3]);
AGR.API("S15G1-p1365B0",[1,5,"prim","S11xS4",5]);
AGR.API("S15G1-p15B0",[15,2,"prim","S14",2]);
AGR.API("S15G1-p455B0",[1,4,"prim","S12xS3",4]);
AGR.API("S16G1-p120B0",[1,3,"prim","S14x2",3]);
AGR.API("S16G1-p16B0",[16,2,"prim","S15",2]);
AGR.API("S16G1-p1820B0",[1,5,"prim","S12xS4",5]);
AGR.API("S16G1-p560B0",[1,4,"prim","S13xS3",4]);
AGR.API("S17G1-p136B0",[1,3,"prim","S15x2",3]);
AGR.API("S17G1-p17B0",[17,2,"prim","S16",2]);
AGR.API("S17G1-p2380B0",[1,5,"prim","S13xS4",5]);
AGR.API("S17G1-p680B0",[1,4,"prim","S14xS3",4]);
AGR.API("S18G1-p153B0",[1,3,"prim","S16x2",3]);
AGR.API("S18G1-p18B0",[18,2,"prim","S17",2]);
AGR.API("S18G1-p3060B0",[1,5,"prim","S14xS4",5]);
AGR.API("S18G1-p816B0",[1,4,"prim","S15xS3",4]);
AGR.API("S19G1-p171B0",[1,3,"prim","S17x2",3]);
AGR.API("S19G1-p19B0",[19,2,"prim","S18",2]);
AGR.API("S19G1-p969B0",[1,4,"prim","S16xS3",4]);
AGR.API("S20G1-p190B0",[1,3,"prim","S18x2",3]);
AGR.API("S20G1-p20B0",[20,2,"prim","S19",2]);
AGR.API("S21G1-p210B0",[1,3,"prim","S19x2",3]);
AGR.API("S21G1-p21B0",[21,2,"prim","S20",2]);
AGR.API("S22G1-p22B0",[22,2,"prim","S21",2]);
AGR.API("S22G1-p231B0",[1,3,"prim","S20x2",3]);
AGR.API("S23G1-p23B0",[23,2,"prim","S22",2]);
AGR.API("S23G1-p253B0",[1,3,"prim","S21x2",3]);
AGR.API("S44G1-p120bB0",[1,3,"prim","L2(16):2",4]);
AGR.API("S44G1-p85aB0",[1,3,"prim","2^6:(3xA5)",1]);
AGR.API("S44d4G1-p170B0",[1,5,"imprim","2^6:(3xA5):2 < S4(4).2"]);
AGR.API("S45G1-p156aB0",[1,3,"prim","5^(1+2)_+:4A5",1]);
AGR.API("S45G1-p156bB0",[1,3,"prim","5^3:(2xA5).2",2]);
AGR.API("S45G1-p300B0",[1,4,"prim","L2(25):2_2",3]);
AGR.API("S45G1-p325B0",[1,4,"prim","2.(A5xA5).2",4]);
AGR.API("S47G1-p1176B0",[1,5,"prim","L2(49).2_2",3]);
AGR.API("S47G1-p1225B0",[1,5,"prim","2.(L2(7)xL2(7)).2",4]);
AGR.API("S47G1-p400aB0",[1,3,"prim","7^(1+2)_+.(3xSL(2,7))",1]);
AGR.API("S47G1-p400bB0",[1,3,"prim","7^3:(3xPGL(2,7))",2]);
AGR.API("S47d2G1-p400aB0",[1,3,"prim","7^(1+2)_+:GL(2,7)",1]);
AGR.API("S47d2G1-p400bB0",[1,3,"prim","7^3:(6xPGL(2,7))",2]);
AGR.API("S5G1-p10B0",[1,3,"prim","S3x2",4]);
AGR.API("S5G1-p5B0",[5,2,"prim","S4",2]);
AGR.API("S5G1-p6B0",[3,2,"prim","5:4",3]);
AGR.API("S62G1-p120B0",[1,3,"prim","U3(3):2",4]);
AGR.API("S62G1-p126B0",[1,5,"imprim","2^5:A6 < 2^5:S6"]);
AGR.API("S62G1-p135B0",[1,4,"prim","2^6:L3(2)",5]);
AGR.API("S62G1-p240B0",[1,5,"imprim","U3(3) < U3(3):2"]);
AGR.API("S62G1-p288B0",[1,5,"imprim","S7 < S8"]);
AGR.API("S62G1-p28B0",[2,2,"prim","U4(2).2",1]);
AGR.API("S62G1-p315B0",[1,5,"prim","2.[2^6]:(S3xS3)",6]);
AGR.API("S62G1-p336B0",[1,5,"prim","S3xS6",7]);
AGR.API("S62G1-p36B0",[2,2,"prim","S8",2]);
AGR.API("S62G1-p378aB0",[1,8,"imprim","2x2^4:S5 < 2^5:S6"]);
AGR.API("S62G1-p378bB0",[1,6,"imprim","2^5:S5 < 2^5:S6"]);
AGR.API("S62G1-p56B0",[1,4,"imprim","U4(2) < U4(2).2"]);
AGR.API("S62G1-p63B0",[1,3,"prim","2^5:S6",3]);
AGR.API("S62G1-p72B0",[1,4,"imprim","A8 < S8"]);
AGR.API("S62G1-p960B0",[1,6,"prim","L2(8).3",8]);
AGR.API("S63G1-p1120B0",[1,4,"prim","3^6:L3(3)",2]);
AGR.API("S63G1-p3640B0",[1,5,"prim","3^(3+4):2(S4xA4)",3]);
AGR.API("S63G1-p364B0",[1,3,"prim","3^(1+4)_+.2U4(2)",1]);
AGR.API("S63G1-p7371B0",[1,6,"prim","2.(A4xU4(2))",4]);
AGR.API("S63d2G1-p1120B0",[1,4,"prim","3^6:(L3(3)x2)",3]);
AGR.API("S63d2G1-p3640B0",[1,5,"prim","3^(3+4):2(S4xS4)",4]);
AGR.API("S63d2G1-p364B0",[1,3,"prim","3^(1+4)_+:2.U4(2).2",2]);
AGR.API("S63d2G1-p7371B0",[1,6,"prim","2(A4xU4(2)).2",5]);
AGR.API("S6G1-p10B0",[2,2,"prim","3^2:D8",4]);
AGR.API("S6G1-p15aB0",[1,3,"prim","S4x2",5]);
AGR.API("S6G1-p15bB0",[1,3,"prim","S4x2",6]);
AGR.API("S6G1-p6aB0",[6,2,"prim","A5.2",2]);
AGR.API("S6G1-p6bB0",[6,2,"prim","A5.2",3]);
AGR.API("S7G1-p120B0",[1,7,"prim","7:6",5]);
AGR.API("S7G1-p21B0",[1,3,"prim","S5x2",3]);
AGR.API("S7G1-p30B0",[1,4,"imprim","L2(7) < A7"]);
AGR.API("S7G1-p35B0",[1,4,"prim","S4xS3",4]);
AGR.API("S7G1-p7B0",[7,2,"prim","S6",2]);
AGR.API("S82G1-p120B0",[2,2,"prim","O8-(2).2",1]);
AGR.API("S82G1-p136B0",[2,2,"prim","O8+(2).2",2]);
AGR.API("S82G1-p2295B0",[1,5,"prim","2^10:A8",4]);
AGR.API("S82G1-p240B0",[1,4,"imprim","O8-(2) < O8-(2).2"]);
AGR.API("S82G1-p255B0",[1,3,"prim","2^7:S6(2)",3]);
AGR.API("S82G1-p272B0",[1,4,"imprim","O8+(2) < O8+(2).2"]);
AGR.API("S82G1-p5355B0",[1,6,"prim","2^(3+8):(S3xS6)",5]);
AGR.API("S8G1-p8B0",[8,2,"prim","S7",2]);
AGR.API("S9G1-p9B0",[9,2,"prim","S8",2]);
AGR.API("SuzG1-p135135B0",[1,9,"prim","2^(1+6)_-.U4(2)",4]);
AGR.API("SuzG1-p1782B0",[1,3,"prim","G2(4)",1]);
AGR.API("SuzG1-p22880B0",[1,5,"prim","3_2.U4(3).2_3'",2]);
AGR.API("SuzG1-p232960B0",[1,13,"prim","3^5:M11",5]);
AGR.API("SuzG1-p32760B0",[1,6,"prim","U5(2)",3]);
AGR.API("SuzG1-p370656B0",[1,15,"prim","J2:2",6]);
AGR.API("SuzG1-p405405B0",[1,13,"prim","2^(4+6):3A6",7]);
AGR.API("Suzd2G1-p1782B0",[1,3,"prim","G2(4):2",2]);
AGR.API("Sz32G1-p1025B0",[2,2,"prim","2^(5+5):31",1]);
AGR.API("Sz32G1-p198400B0",[1,1282,"prim","41:4",2]);
AGR.API("Sz32d5G1-p1025B0",[2,2,"prim","2^(5+5):31:5",2]);
AGR.API("Sz8G1-p1456B0",[1,79,"prim","5:4",3]);
AGR.API("Sz8G1-p2080B0",[1,165,"prim","D14",4]);
AGR.API("Sz8G1-p520B0",[1,12,"imprim","2^3:7 < 2^(3+3):7"]);
AGR.API("Sz8G1-p560B0",[1,17,"prim","13:4",2]);
AGR.API("Sz8G1-p65B0",[2,2,"prim","2^(3+3):7",1]);
AGR.API("Sz8d3G1-p1456B0",[1,27,"prim","5:4x3",4]);
AGR.API("Sz8d3G1-p2080B0",[1,59,"prim","7:6",5]);
AGR.API("Sz8d3G1-p520B0",[1,8,"imprim","2^3:7:3 < 2^(3+3):7:3"]);
AGR.API("Sz8d3G1-p560B0",[1,7,"prim","13:12",3]);
AGR.API("Sz8d3G1-p65B0",[2,2,"prim","2^(3+3):7:3",2]);
AGR.API("TD42G1-p819B0",[1,4,"prim","2^(1+8)_+:L2(8)",1]);
AGR.API("TF42G1-p12480B0",[1,24,"prim","A6.2^2",7]);
AGR.API("TF42G1-p14976B0",[1,25,"prim","5^2:4A4",8]);
AGR.API("TF42G1-p1600B0",[1,4,"prim","L3(3).2",1]);
AGR.API("TF42G1-p1755B0",[1,5,"prim","2.[2^8]:5:4",3]);
AGR.API("TF42G1-p2304B0",[1,7,"prim","L2(25)",4]);
AGR.API("TF42G1-p2925B0",[1,6,"prim","2^2.[2^8]:S3",5]);
AGR.API("TF42d2G1-p1755B0",[1,5,"prim","2.[2^9]:5:4",2]);
AGR.API("TF42d2G1-p2304B0",[1,6,"prim","L2(25).2_3",3]);
AGR.API("U311G1-p1332B0",[2,2,"prim","11^(1+2)_+:40",1]);
AGR.API("U311d2G1-p1332B0",[2,2,"prim","11^(1+2)_+:(5x8:2)",2]);
AGR.API("U313G1-p2198B0",[2,2,"prim","13^(1+2)_+:168",1]);
AGR.API("U316G1-p4097B0",[2,2,"prim","2^(4+8):255",1]);
AGR.API("U33G1-p28B0",[2,2,"prim","3^(1+2)_+:8",1]);
AGR.API("U33G1-p36B0",[1,4,"prim","L2(7)",2]);
AGR.API("U33G1-p63aB0",[1,4,"prim","4.S4",3]);
AGR.API("U33G1-p63bB0",[1,5,"prim","4^2:S3",4]);
AGR.API("U33d2G1-p63bB0",[1,4,"prim","4^2:D12",5]);
AGR.API("U34G1-p1600B0",[1,48,"prim","13:3",4]);
AGR.API("U34G1-p208B0",[1,5,"prim","5xA5",2]);
AGR.API("U34G1-p416B0",[1,9,"prim","5^2:S3",3]);
AGR.API("U34G1-p65B0",[2,2,"prim","2^(2+4):15",1]);
AGR.API("U34d2G1-p1600B0",[1,28,"prim","13:6",5]);
AGR.API("U34d2G1-p208B0",[1,5,"prim","A5xD10",3]);
AGR.API("U34d2G1-p416B0",[1,7,"prim","5^2:D12",4]);
AGR.API("U34d2G1-p65B0",[2,2,"prim","2^(2+4):(3xD10)",2]);
AGR.API("U34d4G1-p1600B0",[1,15,"prim","13:12",5]);
AGR.API("U34d4G1-p208B0",[1,4,"prim","(D10xA5).2",3]);
AGR.API("U34d4G1-p416B0",[1,5,"prim","5^2:(4xS3)",4]);
AGR.API("U34d4G1-p65B0",[2,2,"prim","2^(2+4):(3xD10).2",2]);
AGR.API("U35G1-p50B0",[1,3,"prim","A7",1]);
AGR.API("U35d2G1-p126B0",[2,2,"prim","5^(1+2)_+:8:2",3]);
AGR.API("U35d2G1-p175B0",[1,4,"prim","A6.2^2",4]);
AGR.API("U35d2G1-p50B0",[1,3,"prim","S7",2]);
AGR.API("U35d2G1-p525B0",[1,7,"prim","2S5.2",5]);
AGR.API("U35d2G1-p750B0",[1,9,"prim","L2(7).2",6]);
AGR.API("U37G1-p1032B0",[1,6,"imprim","7^(1+2):16 < 7^(1+2):48"]);
AGR.API("U37G1-p1376B0",[1,8,"imprim","7^(1+2):12 < 7^(1+2):48"]);
AGR.API("U37G1-p14749B0",[1,60,"prim","8^2:S3",3]);
AGR.API("U37G1-p16856B0",[1,114,"prim","L2(7):2",4]);
AGR.API("U37G1-p2064B0",[1,12,"imprim","7^(1+2):8 < 7^(1+2):48"]);
AGR.API("U37G1-p2107B0",[1,8,"prim","2(L2(7)x4).2",2]);
AGR.API("U37G1-p344B0",[2,2,"prim","7^(1+2):48",1]);
AGR.API("U37G1-p43904B0",[1,362,"prim","43:3",5]);
AGR.API("U37G1-p688B0",[1,4,"imprim","7^(1+2):24 < 7^(1+2):48"]);
AGR.API("U38E9G1-p3648B0",[1,5,"prim","(9xL2(8)):3",3]);
AGR.API("U38E9G1-p513B0",[2,2,"prim","2^(3+6):63:3",2]);
AGR.API("U38G1-p3648B0",[1,11,"prim","3xL2(8)",2]);
AGR.API("U38G1-p513B0",[2,2,"prim","2^(3+6):21",1]);
AGR.API("U38S3G1-p3648B0",[1,9,"prim","D18xL2(8)",4]);
AGR.API("U38S3G1-p513B0",[2,2,"prim","2^(3+6):(7xD18)",3]);
AGR.API("U38S3x3G1-p3648B0",[1,5,"prim","(D18xL2(8)):3",5]);
AGR.API("U38S3x3G1-p513B0",[2,2,"prim","2^(3+6):(7xD18):3",4]);
AGR.API("U38d2G1-p3648B0",[1,10,"prim","S3xL2(8)",3]);
AGR.API("U38d2G1-p513B0",[2,2,"prim","2^(3+6):(7xS3)",2]);
AGR.API("U38d3aG1-p3648B0",[1,7,"prim","3xL2(8):3",3]);
AGR.API("U38d3aG1-p513B0",[2,2,"prim","2^(3+6):(7:3x3)",2]);
AGR.API("U38d3bG1-p3648B0",[1,9,"prim","9xL2(8)",3]);
AGR.API("U38d3bG1-p513B0",[2,2,"prim","2^(3+6):63",2]);
AGR.API("U38d3cG1-p3648B0",[1,5,"prim","L2(8):9",3]);
AGR.API("U38d3cG1-p513B0",[2,2,"prim","2^(3+6):7:9",2]);
AGR.API("U38d6G1-p3648B0",[1,6,"prim","S3xL2(8):3",4]);
AGR.API("U38d6G1-p513B0",[2,2,"prim","2^(3+6):(7:3xS3)",3]);
AGR.API("U39G1-p730B0",[2,2,"prim","3^(2+4):80",1]);
AGR.API("U42G1-p27B0",[1,3,"prim","2^4:A5",1]);
AGR.API("U42G1-p36B0",[1,3,"prim","S6",2]);
AGR.API("U42G1-p40aB0",[1,3,"prim","3^(1+2)+:2A4",3]);
AGR.API("U42G1-p40bB0",[1,3,"prim","3^3:S4",4]);
AGR.API("U42G1-p45B0",[1,3,"prim","2.(A4xA4).2",5]);
AGR.API("U42d2G1-p27B0",[1,3,"prim","2^4:S5",2]);
AGR.API("U42d2G1-p36B0",[1,3,"prim","S6x2",3]);
AGR.API("U42d2G1-p40aB0",[1,3,"prim","3^(1+2)_+:2S4",4]);
AGR.API("U42d2G1-p40bB0",[1,3,"prim","3^3:(S4x2)",5]);
AGR.API("U42d2G1-p45B0",[1,3,"prim","2.(A4xA4).2^2",6]);
AGR.API("U43D8G1-p112B0",[1,3,"prim","3^4:(2xA6.2^2)",4]);
AGR.API("U43D8G1-p1134B0",[1,8,"imprim","2^5:S6 < U4(3).(2^2)_{122}"]);
AGR.API("U43D8G1-p252B0",[1,5,"imprim","U4(2).2x2 < U4(3).(2^2)_{122}"]);
AGR.API("U43D8G1-p280B0",[1,3,"prim","3^(1+4)_+.2^(1+4)_-.D12",5]);
AGR.API("U43D8G1-p2835B0",[1,9,"prim","4(S4xS4).2^2",7]);
AGR.API("U43D8G1-p324B0",[1,5,"imprim","L3(4):2^2 < U4(3).(2^2)_{133}"]);
AGR.API("U43D8G1-p4536B0",[1,15,"prim","(A6.2^2x2).2",8]);
AGR.API("U43D8G1-p5184B0",[1,17,"imprim","S7 < U4(3).(2^2)_{122}"]);
AGR.API("U43D8G1-p540B0",[1,4,"prim","(U3(3)x4):2",6]);
AGR.API("U43D8G1-p8505B0",[1,22,"prim","4^3.(2xS4)",9]);
AGR.API("U43D8G1-p9072B0",[1,24,"imprim","A6.2^2x2 < (A6.2^2x2).2"]);
AGR.API("U44G1-p1040B0",[1,5,"prim","S4(4)",2]);
AGR.API("U44G1-p1105B0",[1,3,"prim","2^(2+8):(15xA5)",3]);
AGR.API("U44G1-p325B0",[1,3,"prim","2^8:(3xL2(16))",1]);
AGR.API("U44G1-p3264B0",[1,5,"prim","5xU3(4)",4]);
AGR.API("U45G1-p1575B0",[1,4,"prim","S4(5).2",2]);
AGR.API("U45G1-p756B0",[1,3,"prim","5^4:(L2(25)x4)",1]);
AGR.API("U52G1-p1408B0",[1,7,"prim","3^4:S5",4]);
AGR.API("U52G1-p165B0",[1,3,"prim","2^(1+6):3^(1+2):2A4",1]);
AGR.API("U52G1-p176B0",[1,3,"prim","3xU4(2)",2]);
AGR.API("U52G1-p20736B0",[1,76,"prim","L2(11)",6]);
AGR.API("U52G1-p297B0",[1,3,"prim","2^(4+4):(3xA5)",3]);
AGR.API("U52G1-p3520B0",[1,12,"prim","S3x3^(1+2)+:2A4",5]);
AGR.API("U52d2G1-p1408B0",[1,6,"prim","3^4:(2xS5)",5]);
AGR.API("U52d2G1-p165B0",[1,3,"prim","2^(1+6)_-:3^(1+2)_+:2S4",2]);
AGR.API("U52d2G1-p176B0",[1,3,"prim","(3xU4(2)):2",3]);
AGR.API("U52d2G1-p20736B0",[1,43,"prim","L2(11).2",7]);
AGR.API("U52d2G1-p297B0",[1,3,"prim","2^(4+4):(3xA5):2",4]);
AGR.API("U52d2G1-p3520B0",[1,12,"prim","S3x3^(1+2)_+:2S4",6]);
AGR.API("U62G1-p12474B0",[1,8,"imprim","2^(4+8):(3xA5) < 2^(4+8):(S3xA5)"]);
AGR.API("U62G1-p1408aB0",[1,3,"prim","U4(3).2_2",4]);
AGR.API("U62G1-p1408bB0",[1,3,"prim","U4(3).2_2",5]);
AGR.API("U62G1-p1408cB0",[1,3,"prim","U4(3).2_2",6]);
AGR.API("U62G1-p20736aB0",[1,8,"prim","M22",11]);
AGR.API("U62G1-p20736bB0",[1,8,"prim","M22",12]);
AGR.API("U62G1-p20736cB0",[1,8,"prim","M22",13]);
AGR.API("U62G1-p2816aB0",[1,5,"imprim","U4(3) < U4(3).2_2"]);
AGR.API("U62G1-p2816bB0",[1,5,"imprim","U4(3) < U4(3).2_2"]);
AGR.API("U62G1-p2816cB0",[1,5,"imprim","U4(3) < U4(3).2_2"]);
AGR.API("U62G1-p59136B0",[1,15,"prim","S3xU4(2)",14]);
AGR.API("U62G1-p6237B0",[1,5,"prim","2^(4+8):(S3xA5)",7]);
AGR.API("U62G1-p6336aB0",[1,4,"prim","S6(2)",8]);
AGR.API("U62G1-p6336bB0",[1,4,"prim","S6(2)",9]);
AGR.API("U62G1-p6336cB0",[1,4,"prim","S6(2)",10]);
AGR.API("U62G1-p672B0",[1,3,"prim","U5(2)",1]);
AGR.API("U62G1-p693B0",[1,3,"prim","2^(1+8)_+:U4(2)",2]);
AGR.API("U62G1-p891B0",[1,4,"prim","2^9.L3(4)",3]);
AGR.API("U62S3G1-p693B0",[1,3,"prim","2^(1+8)_+:(U4(2)x3):2",4]);
AGR.API("U62S3G1-p891B0",[1,4,"prim","2^9.L3(4).S3",5]);
AGR.API("U62d2G1-p1408B0",[1,3,"prim","U4(3).(2^2)_{122}",5]);
AGR.API("U62d2G1-p20736B0",[1,8,"prim","M22.2",8]);
AGR.API("U62d2G1-p6237B0",[1,5,"prim","2^(4+8).(S3xS5)",6]);
AGR.API("U62d2G1-p6336B0",[1,4,"prim","S6(2)x2",7]);
AGR.API("U62d2G1-p672B0",[1,3,"prim","U5(2).2",2]);
AGR.API("U62d2G1-p693B0",[1,3,"prim","2^(1+8)_+:U4(2).2",3]);
AGR.API("U62d2G1-p891B0",[1,4,"prim","2^9.L3(4).2",4]);


#############################################################################
##
##  precomputed character data
##
AGR.CHAR("2F4(2)'","TF42G1-Zr52B0",0,[2,3],"26ab");
AGR.CHAR("2F4(2)'","TF42G1-Zr78B0",0,6,"78a");
AGR.CHAR("2F4(2)'","TF42G1-f13r27aB0",13,4,"27a");
AGR.CHAR("2F4(2)'","TF42G1-f13r27bB0",13,5,"27b");
AGR.CHAR("2F4(2)'","TF42G1-f13r52B0",13,[2,3],"26ab");
AGR.CHAR("2F4(2)'","TF42G1-f13r78B0",13,6,"78a");
AGR.CHAR("2F4(2)'","TF42G1-f169r26B0",13,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f25r109aB0",5,7,"109a");
AGR.CHAR("2F4(2)'","TF42G1-f25r109bB0",5,8,"109b");
AGR.CHAR("2F4(2)'","TF42G1-f25r26aB0",5,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f25r26bB0",5,3,"26b");
AGR.CHAR("2F4(2)'","TF42G1-f2r246B0",2,3,"246a");
AGR.CHAR("2F4(2)'","TF42G1-f2r26B0",2,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f3r124aB0",3,7,"124a");
AGR.CHAR("2F4(2)'","TF42G1-f3r124bB0",3,8,"124b");
AGR.CHAR("2F4(2)'","TF42G1-f3r26aB0",3,2,"26a");
AGR.CHAR("2F4(2)'","TF42G1-f3r26bB0",3,3,"26b");
AGR.CHAR("2F4(2)'","TF42G1-f3r54B0",3,[4,5],"27ab");
AGR.CHAR("2F4(2)'","TF42G1-f3r77B0",3,6,"77a");
AGR.CHAR("2F4(2)'","TF42G1-f4r2048aB0",2,4,"2048a");
AGR.CHAR("2F4(2)'","TF42G1-f5r218B0",5,[7,8],"109ab");
AGR.CHAR("2F4(2)'","TF42G1-f5r27aB0",5,4,"27a");
AGR.CHAR("2F4(2)'","TF42G1-f5r27bB0",5,5,"27b");
AGR.CHAR("2F4(2)'","TF42G1-f5r52B0",5,[2,3],"26ab");
AGR.CHAR("2F4(2)'","TF42G1-f5r78B0",5,6,"78a");
AGR.CHAR("2F4(2)'","TF42G1-f9r27aB0",3,4,"27a");
AGR.CHAR("2F4(2)'","TF42G1-f9r27bB0",3,5,"27b");
AGR.CHAR("2F4(2)'","TF42G1-p12480B0",0,[1,6,[9,3],12,13,14,[15,2],16,17,18,19,21,22],"1a+78a+351a^3+624ab+650a+675a^2+702ab+1300ab+2048ab");
AGR.CHAR("2F4(2)'","TF42G1-p14976B0",0,[1,8,[9,2],12,13,14,[15,2],16,17,[18,2],[19,2],21,22],"1a+325a+351a^2+624ab+650a+675a^2+702ab+1300a^2b^2+2048ab");
AGR.CHAR("2F4(2)'","TF42G1-p1600B0",0,[1,9,12,13],"1a+351a+624ab");
AGR.CHAR("2F4(2)'","TF42G1-p1755B0",0,[1,6,9,14,15],"1a+78a+351a+650a+675a");
AGR.CHAR("2F4(2)'","TF42G1-p2304B0",0,[1,4,5,9,12,13,14],"1a+27ab+351a+624ab+650a");
AGR.CHAR("2F4(2)'","TF42G1-p2925B0",0,[1,9,12,13,14,15],"1a+351a+624ab+650a+675a");
AGR.CHAR("3D4(2)","TD42G1-Zr196B0",0,4,"196a");
AGR.CHAR("3D4(2)","TD42G1-Zr26B0",0,2,"26a");
AGR.CHAR("3D4(2)","TD42G1-Zr52B0",0,3,"52a");
AGR.CHAR("3D4(2)","TD42G1-f13r26B0",13,2,"26a");
AGR.CHAR("3D4(2)","TD42G1-f27r351aB0",3,6,"351a");
AGR.CHAR("3D4(2)","TD42G1-f27r351bB0",3,7,"351b");
AGR.CHAR("3D4(2)","TD42G1-f27r351cB0",3,8,"351c");
AGR.CHAR("3D4(2)","TD42G1-f2r26B0",2,5,"26a");
AGR.CHAR("3D4(2)","TD42G1-f3r1053B0",3,10,"1053a");
AGR.CHAR("3D4(2)","TD42G1-f3r196B0",3,4,"196a");
AGR.CHAR("3D4(2)","TD42G1-f3r25B0",3,2,"25a");
AGR.CHAR("3D4(2)","TD42G1-f3r324B0",3,5,"324a");
AGR.CHAR("3D4(2)","TD42G1-f3r441B0",3,9,"441a");
AGR.CHAR("3D4(2)","TD42G1-f3r52B0",3,3,"52a");
AGR.CHAR("3D4(2)","TD42G1-f7r26B0",7,2,"26a");
AGR.CHAR("3D4(2)","TD42G1-f7r298B0",7,6,"298a");
AGR.CHAR("3D4(2)","TD42G1-f8r8aB0",2,2,"8a");
AGR.CHAR("3D4(2)","TD42G1-p819B0",0,[1,2,6,10],"1a+26a+324a+468a");
AGR.CHAR("3D4(2).3","TD42d3G1-f13r26aB0",13,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r144B0",2,8);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r246aB0",2,10);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r24B0",2,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r26B0",2,5);
AGR.CHAR("3D4(2).3","TD42d3G1-f2r480B0",2,9);
AGR.CHAR("3D4(2).3","TD42d3G1-f3r196B0",3,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f3r52B0",3,3);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r26aB0",7,4);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r273aB0",7,13);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r298aB0",7,16);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r467aB0",7,19);
AGR.CHAR("3D4(2).3","TD42d3G1-f7r52aB0",7,7);
AGR.CHAR("Co1","Co1G1-f11r276B0",11,2,"276a");
AGR.CHAR("Co1","Co1G1-f11r299B0",11,3,"299a");
AGR.CHAR("Co1","Co1G1-f13r276B0",13,2,"276a");
AGR.CHAR("Co1","Co1G1-f13r299B0",13,3,"299a");
AGR.CHAR("Co1","Co1G1-f23r276B0",23,2,"276a");
AGR.CHAR("Co1","Co1G1-f23r299B0",23,3,"299a");
AGR.CHAR("Co1","Co1G1-f7r276B0",7,2,"276a");
AGR.CHAR("Co1","Co1G1-f7r299B0",7,3,"299a");
AGR.CHAR("Co1","Co1G1-p98280B0",0,[1,3,6,10],"1a+299a+17250a+80730a");
AGR.CHAR("Co2","Co2G1-Zr23B0",0,2,"23a");
AGR.CHAR("Co2","Co2G1-f11r23B0",11,2,"23a");
AGR.CHAR("Co2","Co2G1-f11r253B0",11,3,"253a");
AGR.CHAR("Co2","Co2G1-f11r275B0",11,4,"275a");
AGR.CHAR("Co2","Co2G1-f23r23B0",23,2,"23a");
AGR.CHAR("Co2","Co2G1-f23r253B0",23,3,"253a");
AGR.CHAR("Co2","Co2G1-f23r274B0",23,4,"274a");
AGR.CHAR("Co2","Co2G1-f2r22B0",2,2,"22a");
AGR.CHAR("Co2","Co2G1-f2r230B0",2,3,"230a");
AGR.CHAR("Co2","Co2G1-f2r24B0",2,[[1,2],2],"1a^2+22a");
AGR.CHAR("Co2","Co2G1-f2r748aB0",2,4,"748a");
AGR.CHAR("Co2","Co2G1-f2r748bB0",2,5,"748b");
AGR.CHAR("Co2","Co2G1-f3r23B0",3,2,"23a");
AGR.CHAR("Co2","Co2G1-f3r253B0",3,3,"253a");
AGR.CHAR("Co2","Co2G1-f3r275B0",3,4,"275a");
AGR.CHAR("Co2","Co2G1-f5r23B0",5,2,"23a");
AGR.CHAR("Co2","Co2G1-f5r253B0",5,3,"253a");
AGR.CHAR("Co2","Co2G1-f5r275B0",5,4,"275a");
AGR.CHAR("Co2","Co2G1-f7r23B0",7,2,"23a");
AGR.CHAR("Co2","Co2G1-f7r253B0",7,3,"253a");
AGR.CHAR("Co2","Co2G1-f7r275B0",7,4,"275a");
AGR.CHAR("Co2","Co2G1-p2300B0",0,[1,4,6],"1a+275a+2024a");
AGR.CHAR("Co2","Co2G1-p4600B0",0,[1,2,4,6,7],"1a+23a+275a+2024a+2277a");
AGR.CHAR("Co3","Co3G1-Zr23B0",0,2,"23a");
AGR.CHAR("Co3","Co3G1-f11r23B0",11,2,"23a");
AGR.CHAR("Co3","Co3G1-f11r253aB0",11,3,"253a");
AGR.CHAR("Co3","Co3G1-f11r253bB0",11,4,"253b");
AGR.CHAR("Co3","Co3G1-f11r275B0",11,5,"275a");
AGR.CHAR("Co3","Co3G1-f11r896B0",11,6,"896a");
AGR.CHAR("Co3","Co3G1-f23r23B0",23,2,"23a");
AGR.CHAR("Co3","Co3G1-f23r253aB0",23,3,"253a");
AGR.CHAR("Co3","Co3G1-f23r253bB0",23,4,"253b");
AGR.CHAR("Co3","Co3G1-f23r274B0",23,5,"274a");
AGR.CHAR("Co3","Co3G1-f23r896bB0",23,7,"896b");
AGR.CHAR("Co3","Co3G1-f2r22B0",2,2,"22a");
AGR.CHAR("Co3","Co3G1-f2r230B0",2,3,"230a");
AGR.CHAR("Co3","Co3G1-f3r126aB0",3,3,"126a");
AGR.CHAR("Co3","Co3G1-f3r126bB0",3,4,"126b");
AGR.CHAR("Co3","Co3G1-f3r22B0",3,2,"22a");
AGR.CHAR("Co3","Co3G1-f3r231aB0",3,5,"231a");
AGR.CHAR("Co3","Co3G1-f3r231bB0",3,6,"231b");
AGR.CHAR("Co3","Co3G1-f3r770aB0",3,7,"770a");
AGR.CHAR("Co3","Co3G1-f3r770bB0",3,8,"770b");
AGR.CHAR("Co3","Co3G1-f49r896aB0",7,6,"896a");
AGR.CHAR("Co3","Co3G1-f4r896aB0",2,4,"896a");
AGR.CHAR("Co3","Co3G1-f5r230B0",5,3,"230a");
AGR.CHAR("Co3","Co3G1-f5r23B0",5,2,"23a");
AGR.CHAR("Co3","Co3G1-f5r253B0",5,4,"253a");
AGR.CHAR("Co3","Co3G1-f5r275B0",5,5,"275a");
AGR.CHAR("Co3","Co3G1-f5r896bB0",5,7,"896b");
AGR.CHAR("Co3","Co3G1-f7r23B0",7,2,"23a");
AGR.CHAR("Co3","Co3G1-f7r253aB0",7,3,"253a");
AGR.CHAR("Co3","Co3G1-f7r253bB0",7,4,"253b");
AGR.CHAR("Co3","Co3G1-f7r275B0",7,5,"275a");
AGR.CHAR("Co3","Co3G1-p11178B0",0,[1,2,5,9,15],"1a+23a+275a+2024a+8855a");
AGR.CHAR("Co3","Co3G1-p128800B0",0,[1,5,13,15,20,31],"1a+275a+5544a+8855a+23000a+91125a");
AGR.CHAR("Co3","Co3G1-p276B0",0,[1,5],"1a+275a");
AGR.CHAR("Co3","Co3G1-p37950B0",0,[1,[5,2],13,15,20],"1a+275a^2+5544a+8855a+23000a");
AGR.CHAR("Co3","Co3G1-p48600B0",0,[1,2,4,5,9,13,15,24],"1a+23a+253b+275a+2024a+5544a+8855a+31625c");
AGR.CHAR("Co3","Co3G1-p552B0",0,[1,2,4,5],"1a+23a+253b+275a");
AGR.CHAR("Fi22","F22G1-Zr78B0",0,2,"78a");
AGR.CHAR("Fi22","F22G1-f11r429B0",11,3,"429a");
AGR.CHAR("Fi22","F22G1-f11r78B0",11,2,"78a");
AGR.CHAR("Fi22","F22G1-f13r429B0",13,3,"429a");
AGR.CHAR("Fi22","F22G1-f13r78B0",13,2,"78a");
AGR.CHAR("Fi22","F22G1-f2r350B0",2,3,"350a");
AGR.CHAR("Fi22","F22G1-f2r572B0",2,4,"572a");
AGR.CHAR("Fi22","F22G1-f2r78B0",2,2,"78a");
AGR.CHAR("Fi22","F22G1-f3r351B0",3,3,"351a");
AGR.CHAR("Fi22","F22G1-f3r77B0",3,2,"77a");
AGR.CHAR("Fi22","F22G1-f3r924B0",3,4,"924a");
AGR.CHAR("Fi22","F22G1-f5r428B0",5,3,"428a");
AGR.CHAR("Fi22","F22G1-f5r78B0",5,2,"78a");
AGR.CHAR("Fi22","F22G1-f7r429B0",7,3,"429a");
AGR.CHAR("Fi22","F22G1-f7r78B0",7,2,"78a");
AGR.CHAR("Fi22","F22G1-p14080bB0",0,[1,3,9],"1a+429a+13650a");
AGR.CHAR("Fi22","F22G1-p142155B0",0,[1,2,3,5,7,10,11,17],"1a+78a+429a+1430a+3080a+30030a+32032a+75075a");
AGR.CHAR("Fi22","F22G1-p3510B0",0,[1,3,7],"1a+429a+3080a");
AGR.CHAR("Fi22","F22G1-p61776B0",0,[1,7,9,13],"1a+3080a+13650a+45045a");
AGR.CHAR("Fi22","F22G1-p694980B0",0,[1,3,5,7,9,10,13,17,25,28],"1a+429a+1430a+3080a+13650a+30030a+45045a+75075a+205920a+320320a");
AGR.CHAR("Fi23","F23G1-f11r782B0",11,2,"782a");
AGR.CHAR("Fi23","F23G1-f13r782B0",13,2,"782a");
AGR.CHAR("Fi23","F23G1-f2r1494B0",2,3,"1494a");
AGR.CHAR("Fi23","F23G1-f2r782B0",2,2,"782a");
AGR.CHAR("Fi23","F23G1-f5r782B0",5,2,"782a");
AGR.CHAR("Fi23","F23G1-f7r782B0",7,2,"782a");
AGR.CHAR("Fi23","F23G1-p137632B0",0,[1,6,8],"1a+30888a+106743a");
AGR.CHAR("Fi23","F23G1-p275264B0",0,[1,5,6,8,9],"1a+25806a+30888a+106743a+111826a");
AGR.CHAR("Fi23","F23G1-p31671B0",0,[1,2,6],"1a+782a+30888a");
AGR.CHAR("G2(3)","G23G1-Zr104B0",0,9,"104a");
AGR.CHAR("G2(3)","G23G1-Zr128B0",0,[3,4],"64ab");
AGR.CHAR("G2(3)","G23G1-Zr14B0",0,2,"14a");
AGR.CHAR("G2(3)","G23G1-Zr168B0",0,10,"168a");
AGR.CHAR("G2(3)","G23G1-Zr182aB0",0,11,"182a");
AGR.CHAR("G2(3)","G23G1-Zr182bB0",0,12,"182b");
AGR.CHAR("G2(3)","G23G1-Zr78B0",0,5,"78a");
AGR.CHAR("G2(3)","G23G1-Zr91aB0",0,6,"91a");
AGR.CHAR("G2(3)","G23G1-Zr91bB0",0,7,"91b");
AGR.CHAR("G2(3)","G23G1-Zr91cB0",0,8,"91c");
AGR.CHAR("G2(3)","G23G1-f2r14B0",2,2,"14a");
AGR.CHAR("G2(3)","G23G1-f2r378B0",2,9,"378a");
AGR.CHAR("G2(3)","G23G1-f2r78B0",2,5,"78a");
AGR.CHAR("G2(3)","G23G1-f2r90aB0",2,6,"90a");
AGR.CHAR("G2(3)","G23G1-f2r90bB0",2,7,"90b");
AGR.CHAR("G2(3)","G23G1-f2r90cB0",2,8,"90c");
AGR.CHAR("G2(3)","G23G1-f3r189aB0",3,7,"189a");
AGR.CHAR("G2(3)","G23G1-f3r189bB0",3,8,"189b");
AGR.CHAR("G2(3)","G23G1-f3r27aB0",3,5,"27b");
AGR.CHAR("G2(3)","G23G1-f3r27bB0",3,4,"27a");
AGR.CHAR("G2(3)","G23G1-f3r49B0",3,6,"49a");
AGR.CHAR("G2(3)","G23G1-f3r729B0",3,9,"729a");
AGR.CHAR("G2(3)","G23G1-f3r7aB0",3,2,"7a");
AGR.CHAR("G2(3)","G23G1-f3r7bB0",3,3,"7b");
AGR.CHAR("G2(3)","G23G1-f4r64aB0",2,3,"64a");
AGR.CHAR("G2(3).2","G23d2G1-Ar14B0",0,3);
AGR.CHAR("G2(3).2","G23d2G1-f13r14B0",13,3);
AGR.CHAR("G2(3).2","G23d2G1-f13r434aB0",13,21);
AGR.CHAR("G2(3).2","G23d2G1-f2r14B0",2,2);
AGR.CHAR("G2(3).2","G23d2G1-f3r14B0",3,3);
AGR.CHAR("G2(3).2","G23d2G1-f7r14B0",7,3);
AGR.CHAR("G2(3).2","G23d2G1-p756B0",0,[1,2,13,14,15,18]);
AGR.CHAR("G2(4)","G24G1-Zr350B0",0,6,"350a");
AGR.CHAR("G2(4)","G24G1-Zr65B0",0,2,"65a");
AGR.CHAR("G2(4)","G24G1-Zr78B0",0,3,"78a");
AGR.CHAR("G2(4)","G24G1-f13r65B0",13,2,"65a");
AGR.CHAR("G2(4)","G24G1-f13r78B0",13,3,"78a");
AGR.CHAR("G2(4)","G24G1-f2r196B0",2,11,"196a");
AGR.CHAR("G2(4)","G24G1-f2r36B0",2,6,"36a");
AGR.CHAR("G2(4)","G24G1-f3r286B0",3,4,"286a");
AGR.CHAR("G2(4)","G24G1-f3r64B0",3,2,"64a");
AGR.CHAR("G2(4)","G24G1-f3r78B0",3,3,"78a");
AGR.CHAR("G2(4)","G24G1-f4r14aB0",2,4,"14a");
AGR.CHAR("G2(4)","G24G1-f4r14bB0",2,5,"14b");
AGR.CHAR("G2(4)","G24G1-f4r384aB0",2,12,"384a");
AGR.CHAR("G2(4)","G24G1-f4r64aB0",2,7,"64a");
AGR.CHAR("G2(4)","G24G1-f4r64bB0",2,8,"64b");
AGR.CHAR("G2(4)","G24G1-f4r6aB0",2,2,"6a");
AGR.CHAR("G2(4)","G24G1-f4r6bB0",2,3,"6b");
AGR.CHAR("G2(4)","G24G1-f4r84aB0",2,10,"84b");
AGR.CHAR("G2(4)","G24G1-f4r84bB0",2,9,"84a");
AGR.CHAR("G2(4)","G24G1-f4r896aB0",2,14,"896a");
AGR.CHAR("G2(4)","G24G1-f5r350B0",5,6,"350a");
AGR.CHAR("G2(4)","G24G1-f5r363aB0",5,7,"363a");
AGR.CHAR("G2(4)","G24G1-f5r650B0",5,10,"650a");
AGR.CHAR("G2(4)","G24G1-f5r65B0",5,2,"65a");
AGR.CHAR("G2(4)","G24G1-f5r78B0",5,3,"78a");
AGR.CHAR("G2(4)","G24G1-f7r65B0",7,2,"65a");
AGR.CHAR("G2(4)","G24G1-f7r78B0",7,3,"78a");
AGR.CHAR("G2(4)","G24G1-p1365aB0",0,[1,6,7,10],"1a+350a+364a+650a");
AGR.CHAR("G2(4)","G24G1-p1365bB0",0,[1,6,8,10],"1a+350a+364b+650a");
AGR.CHAR("G2(4)","G24G1-p2016B0",0,[1,10,16],"1a+650a+1365a");
AGR.CHAR("G2(4)","G24G1-p20800B0",0,[1,2,[6,2],7,8,15,16,19,28,29,32],"1a+65a+350a^2+364ab+1300a+1365a+2925c+4096a+4160a+5460a");
AGR.CHAR("G2(4)","G24G1-p2080B0",0,[1,6,8,16],"1a+350a+364b+1365a");
AGR.CHAR("G2(4)","G24G1-p416B0",0,[1,2,6],"1a+65a+350a");
AGR.CHAR("G2(4).2","G24d2G1-f13r65B0",13,4);
AGR.CHAR("G2(4).2","G24d2G1-f2r128B0",2,5);
AGR.CHAR("G2(4).2","G24d2G1-f2r12B0",2,2);
AGR.CHAR("G2(4).2","G24d2G1-f2r168B0",2,6);
AGR.CHAR("G2(4).2","G24d2G1-f2r196B0",2,7);
AGR.CHAR("G2(4).2","G24d2G1-f2r28B0",2,3);
AGR.CHAR("G2(4).2","G24d2G1-f2r36B0",2,4);
AGR.CHAR("G2(4).2","G24d2G1-f2r768B0",2,8);
AGR.CHAR("G2(4).2","G24d2G1-f3r64B0",3,3);
AGR.CHAR("G2(4).2","G24d2G1-f5r65B0",5,4);
AGR.CHAR("HN","HNG1-f11r133aB0",11,2,"133a");
AGR.CHAR("HN","HNG1-f11r133bB0",11,3,"133b");
AGR.CHAR("HN","HNG1-f11r760B0",11,4,"760a");
AGR.CHAR("HN","HNG1-f19r133aB0",19,2,"133a");
AGR.CHAR("HN","HNG1-f19r133bB0",19,3,"133b");
AGR.CHAR("HN","HNG1-f19r760B0",19,4,"760a");
AGR.CHAR("HN","HNG1-f2r760B0",2,4,"760a");
AGR.CHAR("HN","HNG1-f3r760B0",3,4,"760a");
AGR.CHAR("HN","HNG1-f49r133aB0",7,2,"133a");
AGR.CHAR("HN","HNG1-f49r133bB0",7,3,"133b");
AGR.CHAR("HN","HNG1-f4r132aB0",2,2,"132a");
AGR.CHAR("HN","HNG1-f4r132bB0",2,3,"132b");
AGR.CHAR("HN","HNG1-f4r133B0",2,[1,2],"1a+132a");
AGR.CHAR("HN","HNG1-f4r2650aB0",2,6,"2650b");
AGR.CHAR("HN","HNG1-f5r133B0",5,2,"133a");
AGR.CHAR("HN","HNG1-f5r626B0",5,3,"626a");
AGR.CHAR("HN","HNG1-f5r627B0",5,[1,3],"1a+626a");
AGR.CHAR("HN","HNG1-f7r760B0",7,4,"760a");
AGR.CHAR("HN","HNG1-f9r133aB0",3,2,"133a");
AGR.CHAR("HN","HNG1-f9r133bB0",3,3,"133b");
AGR.CHAR("HN","HNG1-p1140000B0",0,[1,2,3,4,5,8,10,11,12,18,20,23],"1a+133ab+760a+3344a+8910a+16929a+35112ab+267520a+365750a+406296a");
AGR.CHAR("HS","HSG1-Zr154aB0",0,4,"154a");
AGR.CHAR("HS","HSG1-Zr154bB0",0,5,"154b");
AGR.CHAR("HS","HSG1-Zr154cB0",0,6,"154c");
AGR.CHAR("HS","HSG1-Zr175B0",0,7,"175a");
AGR.CHAR("HS","HSG1-Zr22B0",0,2,"22a");
AGR.CHAR("HS","HSG1-Zr231B0",0,8,"231a");
AGR.CHAR("HS","HSG1-Zr77B0",0,3,"77a");
AGR.CHAR("HS","HSG1-f11r154aB0",11,4,"154a");
AGR.CHAR("HS","HSG1-f11r154bB0",11,5,"154b");
AGR.CHAR("HS","HSG1-f11r154cB0",11,6,"154c");
AGR.CHAR("HS","HSG1-f11r174B0",11,7,"174a");
AGR.CHAR("HS","HSG1-f11r22B0",11,2,"22a");
AGR.CHAR("HS","HSG1-f11r231B0",11,8,"231a");
AGR.CHAR("HS","HSG1-f11r693B0",11,9,"693a");
AGR.CHAR("HS","HSG1-f11r770aB0",11,10,"770a");
AGR.CHAR("HS","HSG1-f11r77B0",11,3,"77a");
AGR.CHAR("HS","HSG1-f11r825B0",11,13,"825a");
AGR.CHAR("HS","HSG1-f11r854B0",11,14,"854a");
AGR.CHAR("HS","HSG1-f11r896B0",11,15,"896a");
AGR.CHAR("HS","HSG1-f121r770bB0",11,11,"770b");
AGR.CHAR("HS","HSG1-f121r770cB0",11,12,"770c");
AGR.CHAR("HS","HSG1-f2r1000B0",2,8,"1000a");
AGR.CHAR("HS","HSG1-f2r132B0",2,4,"132a");
AGR.CHAR("HS","HSG1-f2r20B0",2,2,"20a");
AGR.CHAR("HS","HSG1-f2r518B0",2,5,"518a");
AGR.CHAR("HS","HSG1-f2r56B0",2,3,"56a");
AGR.CHAR("HS","HSG1-f3r154aB0",3,6,"154a");
AGR.CHAR("HS","HSG1-f3r154bB0",3,7,"154b");
AGR.CHAR("HS","HSG1-f3r154cB0",3,8,"154c");
AGR.CHAR("HS","HSG1-f3r22B0",3,2,"22a");
AGR.CHAR("HS","HSG1-f3r231B0",3,9,"231a");
AGR.CHAR("HS","HSG1-f3r321B0",3,10,"321a");
AGR.CHAR("HS","HSG1-f3r49aB0",3,3,"49a");
AGR.CHAR("HS","HSG1-f3r49bB0",3,4,"49b");
AGR.CHAR("HS","HSG1-f3r693B0",3,11,"693a");
AGR.CHAR("HS","HSG1-f3r748B0",3,12,"748a");
AGR.CHAR("HS","HSG1-f3r770aB0",3,13,"770a");
AGR.CHAR("HS","HSG1-f3r77B0",3,5,"77a");
AGR.CHAR("HS","HSG1-f3r825B0",3,15,"825a");
AGR.CHAR("HS","HSG1-f49r896aB0",7,15,"896a");
AGR.CHAR("HS","HSG1-f49r896bB0",7,16,"896b");
AGR.CHAR("HS","HSG1-f4r896aB0",2,6,"896a");
AGR.CHAR("HS","HSG1-f4r896bB0",2,7,"896b");
AGR.CHAR("HS","HSG1-f5r133aB0",5,5,"133a");
AGR.CHAR("HS","HSG1-f5r133bB0",5,6,"133b");
AGR.CHAR("HS","HSG1-f5r175B0",5,7,"175a");
AGR.CHAR("HS","HSG1-f5r210B0",5,8,"210a");
AGR.CHAR("HS","HSG1-f5r21B0",5,2,"21a");
AGR.CHAR("HS","HSG1-f5r280aB0",5,9,"280a");
AGR.CHAR("HS","HSG1-f5r518B0",5,11,"518a");
AGR.CHAR("HS","HSG1-f5r55B0",5,3,"55a");
AGR.CHAR("HS","HSG1-f5r650B0",5,12,"650a");
AGR.CHAR("HS","HSG1-f5r98B0",5,4,"98a");
AGR.CHAR("HS","HSG1-f7r154aB0",7,4,"154a");
AGR.CHAR("HS","HSG1-f7r154bB0",7,5,"154b");
AGR.CHAR("HS","HSG1-f7r154cB0",7,6,"154c");
AGR.CHAR("HS","HSG1-f7r175B0",7,7,"175a");
AGR.CHAR("HS","HSG1-f7r22B0",7,2,"22a");
AGR.CHAR("HS","HSG1-f7r231B0",7,8,"231a");
AGR.CHAR("HS","HSG1-f7r605B0",7,9,"605a");
AGR.CHAR("HS","HSG1-f7r693B0",7,10,"693a");
AGR.CHAR("HS","HSG1-f7r770aB0",7,11,"770a");
AGR.CHAR("HS","HSG1-f7r770bB0",7,12,"770b");
AGR.CHAR("HS","HSG1-f7r770cB0",7,13,"770c");
AGR.CHAR("HS","HSG1-f7r77B0",7,3,"77a");
AGR.CHAR("HS","HSG1-f7r803B0",7,14,"803a");
AGR.CHAR("HS","HSG1-p100B0",0,[1,2,3],"1a+22a+77a");
AGR.CHAR("HS","HSG1-p1100aB0",0,[1,2,3,7,13],"1a+22a+77a+175a+825a");
AGR.CHAR("HS","HSG1-p1100bB0",0,[1,3,4,7,9],"1a+77a+154a+175a+693a");
AGR.CHAR("HS","HSG1-p15400B0",0,[1,3,4,[7,3],[9,2],13,14,15,16,17,18,19,[22,2]],"1a+77a+154a+175a^3+693a^2+825a+896ab+1056a+1386a+1408a+1750a+2520a^2");
AGR.CHAR("HS","HSG1-p176bB0",0,[1,7],"1a+175a");
AGR.CHAR("HS","HSG1-p3850B0",0,[1,2,[3,2],4,7,9,10,13,16],"1a+22a+77a^2+154a+175a+693a+770a+825a+1056a");
AGR.CHAR("HS","HSG1-p4125B0",0,[1,2,3,4,7,9,10,13,18],"1a+22a+77a+154a+175a+693a+770a+825a+1408a");
AGR.CHAR("HS","HSG1-p5600aB0",0,[1,2,3,5,7,10,13,16,22],"1a+22a+77a+154b+175a+770a+825a+1056a+2520a");
AGR.CHAR("He","HeG1-Zr102B0",0,[2,3],"51ab");
AGR.CHAR("He","HeG1-f17r102B0",17,[2,3],"51ab");
AGR.CHAR("He","HeG1-f17r306B0",17,[4,5],"153ab");
AGR.CHAR("He","HeG1-f17r680B0",17,6,"680a");
AGR.CHAR("He","HeG1-f2r680B0",2,8,"680a");
AGR.CHAR("He","HeG1-f3r679B0",3,6,"679a");
AGR.CHAR("He","HeG1-f5r680B0",5,7,"680a");
AGR.CHAR("He","HeG1-f7r153B0",7,3,"153a");
AGR.CHAR("He","HeG1-f7r426B0",7,4,"426a");
AGR.CHAR("He","HeG1-f7r50B0",7,2,"50a");
AGR.CHAR("He","HeG1-f7r798B0",7,5,"798a");
AGR.CHAR("He","HeG1-p2058B0",0,[1,2,3,6,9],"1a+51ab+680a+1275a");
AGR.CHAR("He","HeG1-p244800B0",0,[1,4,5,12,13,14,[15,2],16,[19,2],[22,2],23,24,[26,2],[27,2],[28,2],29,30,31],"1a+153ab+1920a+4080a+4352a+6272a^2+6528a+7650a^2+10880a^2+11475ab+13720a^2+14400a^2+17493a^2+20825a+21504ab");
AGR.CHAR("He","HeG1-p29155B0",0,[1,2,3,6,[9,2],12,14,19,25],"1a+51ab+680a+1275a^2+1920a+4352a+7650a+11900a");
AGR.CHAR("He","HeG1-p8330B0",0,[1,2,3,6,9,12,14],"1a+51ab+680a+1275a+1920a+4352a");
AGR.CHAR("J1","J1G1-Zr112B0",0,[2,3],"56ab");
AGR.CHAR("J1","J1G1-Zr133aB0",0,12,"133a");
AGR.CHAR("J1","J1G1-Zr154aB0",0,[7,8],"77bc");
AGR.CHAR("J1","J1G1-Zr209B0",0,15,"209a");
AGR.CHAR("J1","J1G1-Zr266B0",0,[13,14],"133bc");
AGR.CHAR("J1","J1G1-Zr360B0",0,[9,10,11],"120abc");
AGR.CHAR("J1","J1G1-Zr76aB0",0,4,"76a");
AGR.CHAR("J1","J1G1-Zr76bB0",0,5,"76b");
AGR.CHAR("J1","J1G1-Zr77aB0",0,6,"77a");
AGR.CHAR("J1","J1G1-f11r106B0",11,12,"106a");
AGR.CHAR("J1","J1G1-f11r119B0",11,13,"119a");
AGR.CHAR("J1","J1G1-f11r14B0",11,3,"14a");
AGR.CHAR("J1","J1G1-f11r209B0",11,14,"209a");
AGR.CHAR("J1","J1G1-f11r27B0",11,4,"27a");
AGR.CHAR("J1","J1G1-f11r49B0",11,5,"49a");
AGR.CHAR("J1","J1G1-f11r56B0",11,6,"56a");
AGR.CHAR("J1","J1G1-f11r64B0",11,7,"64a");
AGR.CHAR("J1","J1G1-f11r69B0",11,8,"69a");
AGR.CHAR("J1","J1G1-f11r77aB0",11,9,"77a");
AGR.CHAR("J1","J1G1-f11r77bB0",11,10,"77b");
AGR.CHAR("J1","J1G1-f11r77cB0",11,11,"77c");
AGR.CHAR("J1","J1G1-f11r7B0",11,2,"7a");
AGR.CHAR("J1","J1G1-f125r120aB0",5,6,"120a");
AGR.CHAR("J1","J1G1-f125r120bB0",5,7,"120b");
AGR.CHAR("J1","J1G1-f125r120cB0",5,8,"120c");
AGR.CHAR("J1","J1G1-f19r133aB0",19,9,"133a");
AGR.CHAR("J1","J1G1-f19r133bB0",19,10,"133b");
AGR.CHAR("J1","J1G1-f19r133cB0",19,11,"133c");
AGR.CHAR("J1","J1G1-f19r209B0",19,12,"209a");
AGR.CHAR("J1","J1G1-f19r22B0",19,2,"22a");
AGR.CHAR("J1","J1G1-f19r34B0",19,3,"34a");
AGR.CHAR("J1","J1G1-f19r43B0",19,4,"43a");
AGR.CHAR("J1","J1G1-f19r55B0",19,5,"55a");
AGR.CHAR("J1","J1G1-f19r76aB0",19,6,"76a");
AGR.CHAR("J1","J1G1-f19r76bB0",19,7,"76b");
AGR.CHAR("J1","J1G1-f19r77B0",19,8,"77a");
AGR.CHAR("J1","J1G1-f27r120aB0",3,8,"120a");
AGR.CHAR("J1","J1G1-f27r120bB0",3,9,"120b");
AGR.CHAR("J1","J1G1-f27r120cB0",3,10,"120c");
AGR.CHAR("J1","J1G1-f2r112aB0",2,[3,4],"56ab");
AGR.CHAR("J1","J1G1-f2r112bB0",2,[5,6],"56cd");
AGR.CHAR("J1","J1G1-f2r20B0",2,2,"20a");
AGR.CHAR("J1","J1G1-f2r360B0",2,[9,10,11],"120abc");
AGR.CHAR("J1","J1G1-f2r76aB0",2,7,"76a");
AGR.CHAR("J1","J1G1-f2r76bB0",2,8,"76b");
AGR.CHAR("J1","J1G1-f3r112B0",3,[2,3],"56ab");
AGR.CHAR("J1","J1G1-f3r133B0",3,11,"133a");
AGR.CHAR("J1","J1G1-f3r154B0",3,[6,7],"77ab");
AGR.CHAR("J1","J1G1-f3r360B0",3,[8,9,10],"120abc");
AGR.CHAR("J1","J1G1-f3r76aB0",3,4,"76a");
AGR.CHAR("J1","J1G1-f3r76bB0",3,5,"76b");
AGR.CHAR("J1","J1G1-f49r133bB0",7,13,"133b");
AGR.CHAR("J1","J1G1-f49r133cB0",7,14,"133c");
AGR.CHAR("J1","J1G1-f49r56aB0",7,4,"56a");
AGR.CHAR("J1","J1G1-f49r56bB0",7,5,"56b");
AGR.CHAR("J1","J1G1-f49r77bB0",7,8,"77b");
AGR.CHAR("J1","J1G1-f49r77cB0",7,9,"77c");
AGR.CHAR("J1","J1G1-f4r56aB0",2,3,"56a");
AGR.CHAR("J1","J1G1-f4r56bB0",2,4,"56b");
AGR.CHAR("J1","J1G1-f4r56cB0",2,5,"56c");
AGR.CHAR("J1","J1G1-f4r56dB0",2,6,"56d");
AGR.CHAR("J1","J1G1-f5r133B0",5,9,"133a");
AGR.CHAR("J1","J1G1-f5r360B0",5,[6,7,8],"120abc");
AGR.CHAR("J1","J1G1-f5r56B0",5,2,"56a");
AGR.CHAR("J1","J1G1-f5r76aB0",5,3,"76a");
AGR.CHAR("J1","J1G1-f5r76bB0",5,4,"76b");
AGR.CHAR("J1","J1G1-f5r77B0",5,5,"77a");
AGR.CHAR("J1","J1G1-f7r112B0",7,[4,5],"56ab");
AGR.CHAR("J1","J1G1-f7r120B0",7,11,"120a");
AGR.CHAR("J1","J1G1-f7r133aB0",7,12,"133a");
AGR.CHAR("J1","J1G1-f7r154B0",7,[8,9],"77bc");
AGR.CHAR("J1","J1G1-f7r266B0",7,[13,14],"133bc");
AGR.CHAR("J1","J1G1-f7r31B0",7,2,"31a");
AGR.CHAR("J1","J1G1-f7r45B0",7,3,"45a");
AGR.CHAR("J1","J1G1-f7r75B0",7,6,"75a");
AGR.CHAR("J1","J1G1-f7r77aB0",7,7,"77a");
AGR.CHAR("J1","J1G1-f7r89B0",7,10,"89a");
AGR.CHAR("J1","J1G1-f8r120aB0",2,9,"120a");
AGR.CHAR("J1","J1G1-f8r120bB0",2,10,"120b");
AGR.CHAR("J1","J1G1-f8r120cB0",2,11,"120c");
AGR.CHAR("J1","J1G1-f9r56aB0",3,2,"56a");
AGR.CHAR("J1","J1G1-f9r56bB0",3,3,"56b");
AGR.CHAR("J1","J1G1-f9r77aB0",3,6,"77a");
AGR.CHAR("J1","J1G1-f9r77bB0",3,7,"77b");
AGR.CHAR("J1","J1G1-p1045B0",0,[1,2,3,4,7,8,9,10,11,12,15],"1a+56ab+76a+77bc+120abc+133a+209a");
AGR.CHAR("J1","J1G1-p1463B0",0,[1,2,3,[4,2],[6,2],9,10,11,[12,2],[15,2]],"1a+56ab+76a^2+77a^2+120abc+133a^2+209a^2");
AGR.CHAR("J1","J1G1-p1540B0",0,[1,2,3,[4,2],6,7,8,9,10,11,[12,2],[15,2]],"1a+56ab+76a^2+77abc+120abc+133a^2+209a^2");
AGR.CHAR("J1","J1G1-p1596B0",0,[1,2,3,4,5,[6,2],9,10,11,12,13,14,[15,2]],"1a+56ab+76ab+77a^2+120abc+133abc+209a^2");
AGR.CHAR("J1","J1G1-p266B0",0,[1,2,3,4,6],"1a+56ab+76a+77a");
AGR.CHAR("J1","J1G1-p2926B0",0,[1,2,3,[4,3],[6,3],[9,2],[10,2],[11,2],[12,4],13,14,[15,4]],"1a+56ab+76a^3+77a^3+120a^2b^2c^2+133a^4bc+209a^4");
AGR.CHAR("J1","J1G1-p4180B0",0,[1,[2,2],[3,2],[4,3],5,[6,2],[7,2],[8,2],[9,3],[10,3],[11,3],[12,4],[13,2],[14,2],[15,5]],"1a+56a^2b^2+76a^3b+77a^2b^2c^2+120a^3b^3c^3+133a^4b^2c^2+209a^5");
AGR.CHAR("J2","J2G1-Ar14aB0",0,2,"14a");
AGR.CHAR("J2","J2G1-Ar14bB0",0,3,"14b");
AGR.CHAR("J2","J2G1-Ar21aB0",0,4,"21a");
AGR.CHAR("J2","J2G1-Ar21bB0",0,5,"21b");
AGR.CHAR("J2","J2G1-Zr126B0",0,11,"126a");
AGR.CHAR("J2","J2G1-Zr140B0",0,[8,9],"70ab");
AGR.CHAR("J2","J2G1-Zr160B0",0,12,"160a");
AGR.CHAR("J2","J2G1-Zr175B0",0,13,"175a");
AGR.CHAR("J2","J2G1-Zr225B0",0,18,"225a");
AGR.CHAR("J2","J2G1-Zr28B0",0,[2,3],"14ab");
AGR.CHAR("J2","J2G1-Zr36B0",0,6,"36a");
AGR.CHAR("J2","J2G1-Zr378B0",0,[14,15],"189ab");
AGR.CHAR("J2","J2G1-Zr42B0",0,[4,5],"21ab");
AGR.CHAR("J2","J2G1-Zr448B0",0,[16,17],"224ab");
AGR.CHAR("J2","J2G1-Zr63B0",0,7,"63a");
AGR.CHAR("J2","J2G1-Zr90B0",0,10,"90a");
AGR.CHAR("J2","J2G1-f2r160B0",2,10,"160a");
AGR.CHAR("J2","J2G1-f2r36B0",2,6,"36a");
AGR.CHAR("J2","J2G1-f2r84B0",2,9,"84a");
AGR.CHAR("J2","J2G1-f3r133B0",3,11,"133a");
AGR.CHAR("J2","J2G1-f3r225B0",3,14,"225a");
AGR.CHAR("J2","J2G1-f3r36B0",3,6,"36a");
AGR.CHAR("J2","J2G1-f3r63B0",3,9,"63a");
AGR.CHAR("J2","J2G1-f3r90B0",3,10,"90a");
AGR.CHAR("J2","J2G1-f49r14aB0",7,2,"14a");
AGR.CHAR("J2","J2G1-f49r189aB0",7,15,"189a");
AGR.CHAR("J2","J2G1-f49r21aB0",7,4,"21a");
AGR.CHAR("J2","J2G1-f49r224bB0",7,19,"224b");
AGR.CHAR("J2","J2G1-f49r70aB0",7,8,"70a");
AGR.CHAR("J2","J2G1-f4r14aB0",2,4,"14a");
AGR.CHAR("J2","J2G1-f4r64aB0",2,7,"64a");
AGR.CHAR("J2","J2G1-f4r6aB0",2,2,"6a");
AGR.CHAR("J2","J2G1-f5r14B0",5,2,"14a");
AGR.CHAR("J2","J2G1-f5r175B0",5,8,"175a");
AGR.CHAR("J2","J2G1-f5r189B0",5,9,"189a");
AGR.CHAR("J2","J2G1-f5r21B0",5,3,"21a");
AGR.CHAR("J2","J2G1-f5r225B0",5,10,"225a");
AGR.CHAR("J2","J2G1-f5r300B0",5,11,"300a");
AGR.CHAR("J2","J2G1-f5r41B0",5,4,"41a");
AGR.CHAR("J2","J2G1-f5r70B0",5,5,"70a");
AGR.CHAR("J2","J2G1-f5r85B0",5,6,"85a");
AGR.CHAR("J2","J2G1-f5r90B0",5,7,"90a");
AGR.CHAR("J2","J2G1-f7r101B0",7,11,"101a");
AGR.CHAR("J2","J2G1-f7r124B0",7,12,"124a");
AGR.CHAR("J2","J2G1-f7r126B0",7,13,"126a");
AGR.CHAR("J2","J2G1-f7r175B0",7,14,"175a");
AGR.CHAR("J2","J2G1-f7r199B0",7,17,"199a");
AGR.CHAR("J2","J2G1-f7r336B0",7,20,"336a");
AGR.CHAR("J2","J2G1-f7r36B0",7,6,"36a");
AGR.CHAR("J2","J2G1-f7r63B0",7,7,"63a");
AGR.CHAR("J2","J2G1-f7r89B0",7,10,"89a");
AGR.CHAR("J2","J2G1-f9r13aB0",3,2,"13a");
AGR.CHAR("J2","J2G1-f9r189aB0",3,12,"189a");
AGR.CHAR("J2","J2G1-f9r21aB0",3,4,"21a");
AGR.CHAR("J2","J2G1-f9r57aB0",3,7,"57a");
AGR.CHAR("J2","J2G1-p1008B0",0,[1,2,3,[10,2],11,12,18,19],"1a+14ab+90a^2+126a+160a+225a+288a");
AGR.CHAR("J2","J2G1-p100B0",0,[1,6,7],"1a+36a+63a");
AGR.CHAR("J2","J2G1-p1800B0",0,[1,6,[7,2],10,[11,2],12,13,19,[21,2]],"1a+36a+63a^2+90a+126a^2+160a+175a+288a+336a^2");
AGR.CHAR("J2","J2G1-p280B0",0,[1,7,10,11],"1a+63a+90a+126a");
AGR.CHAR("J2","J2G1-p315B0",0,[1,2,3,6,10,12],"1a+14ab+36a+90a+160a");
AGR.CHAR("J2","J2G1-p525B0",0,[1,6,7,10,12,13],"1a+36a+63a+90a+160a+175a");
AGR.CHAR("J2","J2G1-p840B0",0,[1,7,10,11,12,13,18],"1a+63a+90a+126a+160a+175a+225a");
AGR.CHAR("J2.2","J2d2G1-f2r128B0",2,5);
AGR.CHAR("J2.2","J2d2G1-f2r12B0",2,2);
AGR.CHAR("J2.2","J2d2G1-f2r160B0",2,7);
AGR.CHAR("J2.2","J2d2G1-f2r28B0",2,3);
AGR.CHAR("J2.2","J2d2G1-f2r36B0",2,4);
AGR.CHAR("J2.2","J2d2G1-f2r84B0",2,6);
AGR.CHAR("J2.2","J2d2G1-f3r114B0",3,7);
AGR.CHAR("J2.2","J2d2G1-f3r133aB0",3,12);
AGR.CHAR("J2.2","J2d2G1-f3r225aB0",3,15);
AGR.CHAR("J2.2","J2d2G1-f3r26B0",3,3);
AGR.CHAR("J2.2","J2d2G1-f3r36aB0",3,5);
AGR.CHAR("J2.2","J2d2G1-f3r378B0",3,14);
AGR.CHAR("J2.2","J2d2G1-f3r42B0",3,4);
AGR.CHAR("J2.2","J2d2G1-f3r63aB0",3,8);
AGR.CHAR("J2.2","J2d2G1-f3r90aB0",3,10);
AGR.CHAR("J2.2","J2d2G1-f49r336aB0",7,24);
AGR.CHAR("J2.2","J2d2G1-f5r14aB0",5,3);
AGR.CHAR("J2.2","J2d2G1-f5r175aB0",5,15);
AGR.CHAR("J2.2","J2d2G1-f5r189aB0",5,17);
AGR.CHAR("J2.2","J2d2G1-f5r21aB0",5,5);
AGR.CHAR("J2.2","J2d2G1-f5r225aB0",5,19);
AGR.CHAR("J2.2","J2d2G1-f5r300aB0",5,21);
AGR.CHAR("J2.2","J2d2G1-f5r41aB0",5,7);
AGR.CHAR("J2.2","J2d2G1-f5r70aB0",5,9);
AGR.CHAR("J2.2","J2d2G1-f5r85aB0",5,11);
AGR.CHAR("J2.2","J2d2G1-f5r90aB0",5,13);
AGR.CHAR("J2.2","J2d2G1-f7r101aB0",7,12);
AGR.CHAR("J2.2","J2d2G1-f7r124aB0",7,14);
AGR.CHAR("J2.2","J2d2G1-f7r126aB0",7,16);
AGR.CHAR("J2.2","J2d2G1-f7r140aB0",7,9);
AGR.CHAR("J2.2","J2d2G1-f7r175aB0",7,18);
AGR.CHAR("J2.2","J2d2G1-f7r199aB0",7,21);
AGR.CHAR("J2.2","J2d2G1-f7r28B0",7,3);
AGR.CHAR("J2.2","J2d2G1-f7r28aB0",7,3);
AGR.CHAR("J2.2","J2d2G1-f7r36aB0",7,5);
AGR.CHAR("J2.2","J2d2G1-f7r378aB0",7,20);
AGR.CHAR("J2.2","J2d2G1-f7r42aB0",7,4);
AGR.CHAR("J2.2","J2d2G1-f7r448aB0",7,23);
AGR.CHAR("J2.2","J2d2G1-f7r63aB0",7,7);
AGR.CHAR("J2.2","J2d2G1-f7r89aB0",7,10);
AGR.CHAR("J2.2","J2d2G1-p100B0",0,[1,5,7]);
AGR.CHAR("J3","J3G1-Zr170B0",0,[2,3],"85ab");
AGR.CHAR("J3","J3G1-f17r1292B0",17,[8,9],"646ab");
AGR.CHAR("J3","J3G1-f17r324B0",17,6,"324a");
AGR.CHAR("J3","J3G1-f17r379B0",17,7,"379a");
AGR.CHAR("J3","J3G1-f17r646cB0",17,[4,5],"323ab");
AGR.CHAR("J3","J3G1-f17r761B0",17,10,"761a");
AGR.CHAR("J3","J3G1-f17r816B0",17,11,"816a");
AGR.CHAR("J3","J3G1-f17r836B0",17,12,"836a");
AGR.CHAR("J3","J3G1-f17r85bB0",17,3,"85b");
AGR.CHAR("J3","J3G1-f19r1001B0",19,11,"1001a");
AGR.CHAR("J3","J3G1-f19r323aB0",19,5,"323a");
AGR.CHAR("J3","J3G1-f19r646aB0",19,7,"646a");
AGR.CHAR("J3","J3G1-f19r85B0",19,2,"85a");
AGR.CHAR("J3","J3G1-f19r919B0",19,10,"919a");
AGR.CHAR("J3","J3G1-f2r244B0",2,7,"244a");
AGR.CHAR("J3","J3G1-f2r248B0",2,[4,5,6],"80a+84ab");
AGR.CHAR("J3","J3G1-f2r80B0",2,4,"80a");
AGR.CHAR("J3","J3G1-f2r966B0",2,10,"966a");
AGR.CHAR("J3","J3G1-f3r324B0",3,8,"324a");
AGR.CHAR("J3","J3G1-f3r934B0",3,9,"934a");
AGR.CHAR("J3","J3G1-f4r322aB0",2,8,"322a");
AGR.CHAR("J3","J3G1-f4r78bB0",2,3,"78b");
AGR.CHAR("J3","J3G1-f4r84aB0",2,5,"84a");
AGR.CHAR("J3","J3G1-f5r323B0",5,4,"323a");
AGR.CHAR("J3","J3G1-f5r646B0",5,5,"646a");
AGR.CHAR("J3","J3G1-f5r816B0",5,6,"816a");
AGR.CHAR("J3","J3G1-f5r85aB0",5,2,"85a");
AGR.CHAR("J3","J3G1-f9r153bB0",3,7,"153b");
AGR.CHAR("J3","J3G1-f9r18bB0",3,3,"18b");
AGR.CHAR("J3","J3G1-f9r84bB0",3,5,"84b");
AGR.CHAR("J3","J3G1-p14688aB0",0,[1,2,3,[10,2],11,12,13,14,15,16,19],"1a+85ab+1140a^2+1215ab+1615a+1920abc+2432a");
AGR.CHAR("J3","J3G1-p14688bB0",0,[1,2,3,[10,2],11,12,13,14,15,16,19],"1a+85ab+1140a^2+1215ab+1615a+1920abc+2432a");
AGR.CHAR("J3","J3G1-p17442B0",0,[1,4,5,6,[9,2],[10,2],11,12,13,14,15,16,20],"1a+323ab+324a+816a^2+1140a^2+1215ab+1615a+1920abc+2754a");
AGR.CHAR("J3","J3G1-p20520B0",0,[1,2,3,6,[10,2],[11,2],[12,2],13,14,15,16,19,21],"1a+85ab+324a+1140a^2+1215a^2b^2+1615a+1920abc+2432a+3078a");
AGR.CHAR("J3","J3G1-p23256B0",0,[1,4,5,6,[10,3],[11,2],[12,2],13,14,15,16,17,18,20],"1a+323ab+324a+1140a^3+1215a^2b^2+1615a+1920abc+1938ab+2754a");
AGR.CHAR("J3","J3G1-p25840B0",0,[1,6,10,[11,2],[12,2],13,14,15,16,17,18,19,20,21],"1a+324a+1140a+1215a^2b^2+1615a+1920abc+1938ab+2432a+2754a+3078a");
AGR.CHAR("J3","J3G1-p26163B0",0,[1,4,5,6,[10,2],[11,2],[12,2],[13,2],14,15,16,17,18,19,20],"1a+323ab+324a+1140a^2+1215a^2b^2+1615a^2+1920abc+1938ab+2432a+2754a");
AGR.CHAR("J3","J3G1-p43605B0",0,[1,4,5,[6,2],[9,2],[10,3],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],17,18,19,[20,3],21],"1a+323ab+324a^2+816a^2+1140a^3+1215a^2b^2+1615a^2+1920a^2b^2c^2+1938ab+2432a+2754a^3+3078a");
AGR.CHAR("J3","J3G1-p6156B0",0,[1,4,5,6,10,11,12,13],"1a+323ab+324a+1140a+1215ab+1615a");
AGR.CHAR("J3.2","J3d2G1-f17r170aB0",17,3);
AGR.CHAR("J3.2","J3d2G1-f17r324aB0",17,5);
AGR.CHAR("J3.2","J3d2G1-f17r379aB0",17,7);
AGR.CHAR("J3.2","J3d2G1-f17r646aB0",17,4);
AGR.CHAR("J3.2","J3d2G1-f17r836aB0",17,14);
AGR.CHAR("J3.2","J3d2G1-f19r1001aB0",19,15);
AGR.CHAR("J3.2","J3d2G1-f19r110aB0",19,5);
AGR.CHAR("J3.2","J3d2G1-f19r1214aB0",19,19);
AGR.CHAR("J3.2","J3d2G1-f19r214aB0",19,7);
AGR.CHAR("J3.2","J3d2G1-f19r214bB0",19,8);
AGR.CHAR("J3.2","J3d2G1-f19r646aB0",19,9);
AGR.CHAR("J3.2","J3d2G1-f19r706aB0",19,11);
AGR.CHAR("J3.2","J3d2G1-f19r85aB0",19,3);
AGR.CHAR("J3.2","J3d2G1-f19r919aB0",19,13);
AGR.CHAR("J3.2","J3d2G1-f2r168aB0",2,4);
AGR.CHAR("J3.2","J3d2G1-f2r644aB0",2,6);
AGR.CHAR("J3.2","J3d2G1-f3r168aB0",3,4);
AGR.CHAR("J3.2","J3d2G1-f3r306aB0",3,5);
AGR.CHAR("J3.2","J3d2G1-f3r324aB0",3,6);
AGR.CHAR("J3.2","J3d2G1-f3r36B0",3,3);
AGR.CHAR("J3.2","J3d2G1-f3r36aB0",3,3);
AGR.CHAR("J3.2","J3d2G1-f3r934aB0",3,8);
AGR.CHAR("J3.2","J3d2G1-f5r170aB0",5,3);
AGR.CHAR("J3.2","J3d2G1-f5r323bB0",5,5);
AGR.CHAR("J3.2","J3d2G1-f5r646aB0",5,6);
AGR.CHAR("J3.2","J3d2G1-f5r816aB0",5,8);
AGR.CHAR("J3.2","J3d2G1-p6156B0",0,[1,4,6,10,13,15,16]);
AGR.CHAR("L2(11)","L211G1-Ar12aB0",0,7,"12a");
AGR.CHAR("L2(11)","L211G1-Ar12bB0",0,8,"12b");
AGR.CHAR("L2(11)","L211G1-Ar5aB0",0,2,"5a");
AGR.CHAR("L2(11)","L211G1-Ar5bB0",0,3,"5b");
AGR.CHAR("L2(11)","L211G1-Zr10aB0",0,4,"10a");
AGR.CHAR("L2(11)","L211G1-Zr10bB0",0,5,"10b");
AGR.CHAR("L2(11)","L211G1-Zr10cB0",0,[2,3],"5ab");
AGR.CHAR("L2(11)","L211G1-Zr11B0",0,6,"11a");
AGR.CHAR("L2(11)","L211G1-f11r11B0",11,6,"11a");
AGR.CHAR("L2(11)","L211G1-f11r3B0",11,2,"3a");
AGR.CHAR("L2(11)","L211G1-f11r5B0",11,3,"5a");
AGR.CHAR("L2(11)","L211G1-f11r7B0",11,4,"7a");
AGR.CHAR("L2(11)","L211G1-f11r9B0",11,5,"9a");
AGR.CHAR("L2(11)","L211G1-f2r10B0",2,4,"10a");
AGR.CHAR("L2(11)","L211G1-f2r10bB0",2,[2,3],"5ab");
AGR.CHAR("L2(11)","L211G1-f2r24B0",2,[5,6],"12ab");
AGR.CHAR("L2(11)","L211G1-f3r10B0",3,4,"10a");
AGR.CHAR("L2(11)","L211G1-f3r24B0",3,[5,6],"12ab");
AGR.CHAR("L2(11)","L211G1-f3r5aB0",3,2,"5a");
AGR.CHAR("L2(11)","L211G1-f3r5bB0",3,3,"5b");
AGR.CHAR("L2(11)","L211G1-f4r12aB0",2,5,"12a");
AGR.CHAR("L2(11)","L211G1-f4r12bB0",2,6,"12b");
AGR.CHAR("L2(11)","L211G1-f4r5aB0",2,2,"5a");
AGR.CHAR("L2(11)","L211G1-f4r5bB0",2,3,"5b");
AGR.CHAR("L2(11)","L211G1-f5r10aB0",5,4,"10a");
AGR.CHAR("L2(11)","L211G1-f5r10bB0",5,5,"10b");
AGR.CHAR("L2(11)","L211G1-f5r11B0",5,6,"11a");
AGR.CHAR("L2(11)","L211G1-f5r5aB0",5,2,"5a");
AGR.CHAR("L2(11)","L211G1-f5r5bB0",5,3,"5b");
AGR.CHAR("L2(11)","L211G1-f9r12aB0",3,5,"12a");
AGR.CHAR("L2(11)","L211G1-f9r12bB0",3,6,"12b");
AGR.CHAR("L2(11)","L211G1-p11aB0",0,[1,5],"1a+10b");
AGR.CHAR("L2(11)","L211G1-p11bB0",0,[1,5],"1a+10b");
AGR.CHAR("L2(11)","L211G1-p12B0",0,[1,6],"1a+11a");
AGR.CHAR("L2(11)","L211G1-p55B0",0,[1,2,3,[5,2],7,8],"1a+5ab+10b^2+12ab");
AGR.CHAR("L2(11).2","L211d2G1-f11r11B0",11,11);
AGR.CHAR("L2(11).2","L211d2G1-f11r3B0",11,3);
AGR.CHAR("L2(11).2","L211d2G1-f11r5B0",11,5);
AGR.CHAR("L2(11).2","L211d2G1-f11r7B0",11,7);
AGR.CHAR("L2(11).2","L211d2G1-f11r9B0",11,9);
AGR.CHAR("L2(11).2","L211d2G1-f2r10aB0",2,2);
AGR.CHAR("L2(11).2","L211d2G1-f2r10bB0",2,3);
AGR.CHAR("L2(11).2","L211d2G1-f4r12aB0",2,4);
AGR.CHAR("L2(11).2","L211d2G1-f4r12bB0",2,5);
AGR.CHAR("L2(11).2","L211d2G1-p12B0",0,[1,8]);
AGR.CHAR("L2(11).2","L211d2G1-p22B0",0,[1,2,6,7]);
AGR.CHAR("L2(11).2","L211d2G1-p55aB0",0,[1,4,6,7,10,12]);
AGR.CHAR("L2(11).2","L211d2G1-p55bB0",0,[1,3,6,7,10,12]);
AGR.CHAR("L2(11).2","L211d2G1-p66B0",0,[1,3,6,7,8,10,12]);
AGR.CHAR("L2(13)","L213G1-Ar12aB0",0,4,"12a");
AGR.CHAR("L2(13)","L213G1-Ar12bB0",0,5,"12b");
AGR.CHAR("L2(13)","L213G1-Ar12cB0",0,6,"12c");
AGR.CHAR("L2(13)","L213G1-Zr13B0",0,7,"13a");
AGR.CHAR("L2(13)","L213G1-Zr14aB0",0,8,"14a");
AGR.CHAR("L2(13)","L213G1-Zr14bB0",0,9,"14b");
AGR.CHAR("L2(13)","L213G1-Zr14cB0",0,[2,3],"7ab");
AGR.CHAR("L2(13)","L213G1-Zr36B0",0,[4,5,6],"12abc");
AGR.CHAR("L2(13)","L213G1-f13r11B0",13,6,"11a");
AGR.CHAR("L2(13)","L213G1-f13r13B0",13,7,"13a");
AGR.CHAR("L2(13)","L213G1-f13r3B0",13,2,"3a");
AGR.CHAR("L2(13)","L213G1-f13r5B0",13,3,"5a");
AGR.CHAR("L2(13)","L213G1-f13r7B0",13,4,"7a");
AGR.CHAR("L2(13)","L213G1-f13r9B0",13,5,"9a");
AGR.CHAR("L2(13)","L213G1-f2r14B0",2,7,"14a");
AGR.CHAR("L2(13)","L213G1-f3r13B0",3,7,"13a");
AGR.CHAR("L2(13)","L213G1-f4r6aB0",2,3,"6b");
AGR.CHAR("L2(13)","L213G1-f4r6bB0",2,2,"6a");
AGR.CHAR("L2(13)","L213G1-f7r12B0",7,4,"12a");
AGR.CHAR("L2(13)","L213G1-f8r12aB0",2,4,"12a");
AGR.CHAR("L2(13)","L213G1-f8r12bB0",2,5,"12b");
AGR.CHAR("L2(13)","L213G1-f8r12cB0",2,6,"12c");
AGR.CHAR("L2(13)","L213G1-p14B0",0,[1,7],"1a+13a");
AGR.CHAR("L2(13).2","L213d2G1-f13r3aB0",13,3);
AGR.CHAR("L2(13).2","L213d2G1-f2r12aB0",2,2);
AGR.CHAR("L2(13).2","L213d2G1-f2r14B0",2,6);
AGR.CHAR("L2(13).2","L213d2G1-p14B0",0,[1,11]);
AGR.CHAR("L2(13).2","L213d2G1-p78B0",0,[1,4,6,8,10,12,13]);
AGR.CHAR("L2(13).2","L213d2G1-p91aB0",0,[1,4,6,8,10,11,12,13]);
AGR.CHAR("L2(16)","L216G1-Zr120B0",0,[2,3,4,5,6,7,8,9],"15abcdefgh");
AGR.CHAR("L2(16)","L216G1-Zr16B0",0,10,"16a");
AGR.CHAR("L2(16)","L216G1-Zr17aB0",0,11,"17a");
AGR.CHAR("L2(16)","L216G1-Zr34B0",0,[12,13],"17bc");
AGR.CHAR("L2(16)","L216G1-Zr68B0",0,[14,15,16,17],"17defg");
AGR.CHAR("L2(16)","L216G1-f16r2aB0",2,2,"2a");
AGR.CHAR("L2(16)","L216G1-f17r15B0",17,2,"15a");
AGR.CHAR("L2(16)","L216G1-f17r17B0",17,3,"17a");
AGR.CHAR("L2(16)","L216G1-f17r34B0",17,[4,5],"17bc");
AGR.CHAR("L2(16)","L216G1-f17r68B0",17,[6,7,8,9],"17defg");
AGR.CHAR("L2(16)","L216G1-f3r16B0",3,10,"16a");
AGR.CHAR("L2(16)","L216G1-f5r16B0",5,10,"16a");
AGR.CHAR("L2(16)","L216G1-f9r17aB0",3,11,"17a");
AGR.CHAR("L2(16)","L216G1-f9r17bB0",3,12,"17b");
AGR.CHAR("L2(16)","L216G1-p17B0",0,[1,10],"1a+16a");
AGR.CHAR("L2(16).2","L216d2G1-f4r4aB0",2,2);
AGR.CHAR("L2(16).4","L216d4G1-f17r15aB0",17,5);
AGR.CHAR("L2(16).4","L216d4G1-f17r17aB0",17,9);
AGR.CHAR("L2(16).4","L216d4G1-f17r34aB0",17,13);
AGR.CHAR("L2(16).4","L216d4G1-f17r68B0",17,15);
AGR.CHAR("L2(16).4","L216d4G1-f25r60aB0",5,5);
AGR.CHAR("L2(16).4","L216d4G1-f25r60bB0",5,6);
AGR.CHAR("L2(16).4","L216d4G1-f2r16aB0",2,4);
AGR.CHAR("L2(16).4","L216d4G1-f2r16bB0",2,6);
AGR.CHAR("L2(16).4","L216d4G1-f2r32B0",2,5);
AGR.CHAR("L2(16).4","L216d4G1-f2r8aB0",2,2);
AGR.CHAR("L2(16).4","L216d4G1-f2r8bB0",2,3);
AGR.CHAR("L2(16).4","L216d4G1-f3r16aB0",3,7);
AGR.CHAR("L2(16).4","L216d4G1-f5r16aB0",5,7);
AGR.CHAR("L2(16).4","L216d4G1-f5r17aB0",5,11);
AGR.CHAR("L2(16).4","L216d4G1-f9r60aB0",3,5);
AGR.CHAR("L2(16).4","L216d4G1-f9r60bB0",3,6);
AGR.CHAR("L2(17)","L217G1-Ar9aB0",0,2,"9a");
AGR.CHAR("L2(17)","L217G1-Ar9bB0",0,3,"9b");
AGR.CHAR("L2(17)","L217G1-Zr16aB0",0,4,"16a");
AGR.CHAR("L2(17)","L217G1-Zr17B0",0,8,"17a");
AGR.CHAR("L2(17)","L217G1-Zr18aB0",0,9,"18a");
AGR.CHAR("L2(17)","L217G1-Zr18dB0",0,[2,3],"9ab");
AGR.CHAR("L2(17)","L217G1-Zr48B0",0,[5,6,7],"16bcd");
AGR.CHAR("L2(17)","L217G1-f17r11B0",17,6,"11a");
AGR.CHAR("L2(17)","L217G1-f17r13B0",17,7,"13a");
AGR.CHAR("L2(17)","L217G1-f17r15B0",17,8,"15a");
AGR.CHAR("L2(17)","L217G1-f17r17B0",17,9,"17a");
AGR.CHAR("L2(17)","L217G1-f17r3B0",17,2,"3a");
AGR.CHAR("L2(17)","L217G1-f17r5B0",17,3,"5a");
AGR.CHAR("L2(17)","L217G1-f17r7B0",17,4,"7a");
AGR.CHAR("L2(17)","L217G1-f17r9B0",17,5,"9a");
AGR.CHAR("L2(17)","L217G1-f2r16aB0",2,4,"16a");
AGR.CHAR("L2(17)","L217G1-f2r48B0",2,[5,6,7],"16bcd");
AGR.CHAR("L2(17)","L217G1-f2r8aB0",2,2,"8a");
AGR.CHAR("L2(17)","L217G1-f2r8bB0",2,3,"8b");
AGR.CHAR("L2(17)","L217G1-f3r16B0",3,4,"16a");
AGR.CHAR("L2(17)","L217G1-f3r18aB0",3,5,"18a");
AGR.CHAR("L2(17)","L217G1-f8r16bB0",2,5,"16b");
AGR.CHAR("L2(17)","L217G1-f8r16cB0",2,6,"16c");
AGR.CHAR("L2(17)","L217G1-f8r16dB0",2,7,"16d");
AGR.CHAR("L2(17)","L217G1-f9r18bB0",3,6,"18b");
AGR.CHAR("L2(17)","L217G1-f9r18cB0",3,7,"18c");
AGR.CHAR("L2(17)","L217G1-f9r9aB0",3,2,"9a");
AGR.CHAR("L2(17)","L217G1-f9r9bB0",3,3,"9b");
AGR.CHAR("L2(17)","L217G1-p18B0",0,[1,8],"1a+17a");
AGR.CHAR("L2(19)","L219G1-Zr18eB0",0,[2,3],"9ab");
AGR.CHAR("L2(19)","L219G1-Zr19B0",0,8,"19a");
AGR.CHAR("L2(19)","L219G1-Zr20aB0",0,9,"20a");
AGR.CHAR("L2(19)","L219G1-Zr36aB0",0,[4,5],"18ab");
AGR.CHAR("L2(19)","L219G1-f125r20bB0",5,6,"20b");
AGR.CHAR("L2(19)","L219G1-f125r20cB0",5,7,"20c");
AGR.CHAR("L2(19)","L219G1-f125r20dB0",5,8,"20d");
AGR.CHAR("L2(19)","L219G1-f19r11B0",19,6,"11a");
AGR.CHAR("L2(19)","L219G1-f19r13B0",19,7,"13a");
AGR.CHAR("L2(19)","L219G1-f19r15B0",19,8,"15a");
AGR.CHAR("L2(19)","L219G1-f19r17B0",19,9,"17a");
AGR.CHAR("L2(19)","L219G1-f19r19B0",19,10,"19a");
AGR.CHAR("L2(19)","L219G1-f19r3B0",19,2,"3a");
AGR.CHAR("L2(19)","L219G1-f19r5B0",19,3,"5a");
AGR.CHAR("L2(19)","L219G1-f19r7B0",19,4,"7a");
AGR.CHAR("L2(19)","L219G1-f19r9B0",19,5,"9a");
AGR.CHAR("L2(19)","L219G1-f2r20aB0",2,6,"20a");
AGR.CHAR("L2(19)","L219G1-f3r19B0",3,8,"19a");
AGR.CHAR("L2(19)","L219G1-f4r18aB0",2,4,"18a");
AGR.CHAR("L2(19)","L219G1-f4r18bB0",2,5,"18b");
AGR.CHAR("L2(19)","L219G1-f4r9aB0",2,2,"9a");
AGR.CHAR("L2(19)","L219G1-f4r9bB0",2,3,"9b");
AGR.CHAR("L2(19)","L219G1-f5r18B0",5,4,"18a");
AGR.CHAR("L2(19)","L219G1-f5r20aB0",5,5,"20a");
AGR.CHAR("L2(19)","L219G1-f5r9aB0",5,2,"9a");
AGR.CHAR("L2(19)","L219G1-f5r9bB0",5,3,"9b");
AGR.CHAR("L2(19)","L219G1-f8r20bB0",2,7,"20b");
AGR.CHAR("L2(19)","L219G1-f8r20cB0",2,8,"20c");
AGR.CHAR("L2(19)","L219G1-f8r20dB0",2,9,"20d");
AGR.CHAR("L2(19)","L219G1-f9r18aB0",3,4,"18a");
AGR.CHAR("L2(19)","L219G1-f9r18bB0",3,5,"18b");
AGR.CHAR("L2(19)","L219G1-f9r18cB0",3,6,"18c");
AGR.CHAR("L2(19)","L219G1-f9r18dB0",3,7,"18d");
AGR.CHAR("L2(19)","L219G1-f9r9aB0",3,2,"9a");
AGR.CHAR("L2(19)","L219G1-f9r9bB0",3,3,"9b");
AGR.CHAR("L2(19)","L219G1-p171B0",0,[1,2,3,[6,2],[7,2],9,10,11,12],"1a+9ab+18c^2d^2+20abcd");
AGR.CHAR("L2(19)","L219G1-p190B0",0,[1,2,3,[6,2],[7,2],8,9,10,11,12],"1a+9ab+18c^2d^2+19a+20abcd");
AGR.CHAR("L2(19)","L219G1-p20B0",0,[1,8],"1a+19a");
AGR.CHAR("L2(19)","L219G1-p57aB0",0,[1,6,7,9],"1a+18cd+20a");
AGR.CHAR("L2(19)","L219G1-p57bB0",0,[1,6,7,9],"1a+18cd+20a");
AGR.CHAR("L2(19).2","L219d2G1-f19r3B0",19,3);
AGR.CHAR("L2(19).2","L219d2G1-p114B0",0,[1,2,8,9,10,11,14,15]);
AGR.CHAR("L2(19).2","L219d2G1-p171B0",0,[1,3,8,9,10,11,14,16,18,20]);
AGR.CHAR("L2(19).2","L219d2G1-p190B0",0,[1,3,8,9,10,11,12,14,16,18,20]);
AGR.CHAR("L2(19).2","L219d2G1-p20B0",0,[1,12]);
AGR.CHAR("L2(19).2","L219d2G1-p285B0",0,[1,3,4,6,8,9,10,11,12,13,[14,2],15,16,18,20]);
AGR.CHAR("L2(23)","L223G1-Ar24aB0",0,10,"24a");
AGR.CHAR("L2(23)","L223G1-Ar24bB0",0,11,"24b");
AGR.CHAR("L2(23)","L223G1-Ar24cB0",0,12,"24c");
AGR.CHAR("L2(23)","L223G1-Ar24dB0",0,13,"24d");
AGR.CHAR("L2(23)","L223G1-Ar24eB0",0,14,"24e");
AGR.CHAR("L2(23)","L223G1-Zr22aB0",0,4,"22a");
AGR.CHAR("L2(23)","L223G1-Zr22bB0",0,5,"22b");
AGR.CHAR("L2(23)","L223G1-Zr22cB0",0,6,"22c");
AGR.CHAR("L2(23)","L223G1-Zr23B0",0,9,"23a");
AGR.CHAR("L2(23)","L223G1-f11r23B0",11,9,"23a");
AGR.CHAR("L2(23)","L223G1-f23r11B0",23,6,"11a");
AGR.CHAR("L2(23)","L223G1-f23r13B0",23,7,"13a");
AGR.CHAR("L2(23)","L223G1-f23r15B0",23,8,"15a");
AGR.CHAR("L2(23)","L223G1-f23r17B0",23,9,"17a");
AGR.CHAR("L2(23)","L223G1-f23r19B0",23,10,"19a");
AGR.CHAR("L2(23)","L223G1-f23r21B0",23,11,"21a");
AGR.CHAR("L2(23)","L223G1-f23r23B0",23,12,"23a");
AGR.CHAR("L2(23)","L223G1-f23r3B0",23,2,"3a");
AGR.CHAR("L2(23)","L223G1-f23r5B0",23,3,"5a");
AGR.CHAR("L2(23)","L223G1-f23r7B0",23,4,"7a");
AGR.CHAR("L2(23)","L223G1-f23r9B0",23,5,"9a");
AGR.CHAR("L2(23)","L223G1-f2r11aB0",2,2,"11a");
AGR.CHAR("L2(23)","L223G1-f2r11bB0",2,3,"11b");
AGR.CHAR("L2(23)","L223G1-f2r22B0",2,4,"22a");
AGR.CHAR("L2(23)","L223G1-f32r24aB0",2,5,"24a");
AGR.CHAR("L2(23)","L223G1-f32r24bB0",2,6,"24b");
AGR.CHAR("L2(23)","L223G1-f32r24cB0",2,7,"24c");
AGR.CHAR("L2(23)","L223G1-f32r24dB0",2,8,"24d");
AGR.CHAR("L2(23)","L223G1-f32r24eB0",2,9,"24e");
AGR.CHAR("L2(23)","L223G1-f3r22aB0",3,4,"22a");
AGR.CHAR("L2(23)","L223G1-p24B0",0,[1,9],"1a+23a");
AGR.CHAR("L2(23).2","L223d2G1-f23r3aB0",23,3);
AGR.CHAR("L2(23).2","L223d2G1-f2r22aB0",2,2);
AGR.CHAR("L2(27)","L227G1-Ar13aB0",0,2,"13a");
AGR.CHAR("L2(27)","L227G1-Ar13bB0",0,3,"13b");
AGR.CHAR("L2(27)","L227G1-Ar28aB0",0,11,"28a");
AGR.CHAR("L2(27)","L227G1-Ar28bB0",0,12,"28b");
AGR.CHAR("L2(27)","L227G1-Ar28cB0",0,13,"28c");
AGR.CHAR("L2(27)","L227G1-Ar28dB0",0,14,"28d");
AGR.CHAR("L2(27)","L227G1-Ar28eB0",0,15,"28e");
AGR.CHAR("L2(27)","L227G1-Ar28fB0",0,16,"28f");
AGR.CHAR("L2(27)","L227G1-Zr26gB0",0,[2,3],"13ab");
AGR.CHAR("L2(27)","L227G1-Zr27B0",0,10,"27a");
AGR.CHAR("L2(27)","L227G1-Zr78aB0",0,[4,5,6],"26abc");
AGR.CHAR("L2(27)","L227G1-f13r27B0",13,10,"27a");
AGR.CHAR("L2(27)","L227G1-f27r3aB0",3,2,"3a");
AGR.CHAR("L2(27)","L227G1-f3r27B0",3,14,"27a");
AGR.CHAR("L2(27)","L227G1-f4r13aB0",2,2,"13a");
AGR.CHAR("L2(27)","L227G1-f4r13bB0",2,3,"13b");
AGR.CHAR("L2(27)","L227G1-f7r26B0",7,4,"26a");
AGR.CHAR("L2(27)","L227G1-p28B0",0,[1,10],"1a+27a");
AGR.CHAR("L2(29)","L229G1-Ar30aB0",0,12,"30a");
AGR.CHAR("L2(29)","L229G1-Ar30bB0",0,13,"30b");
AGR.CHAR("L2(29)","L229G1-Ar30cB0",0,14,"30c");
AGR.CHAR("L2(29)","L229G1-Ar30dB0",0,15,"30d");
AGR.CHAR("L2(29)","L229G1-Ar30eB0",0,16,"30e");
AGR.CHAR("L2(29)","L229G1-Ar30fB0",0,17,"30f");
AGR.CHAR("L2(29)","L229G1-Zr112B0",0,[7,8,9,10],"28defg");
AGR.CHAR("L2(29)","L229G1-Zr28aB0",0,4,"28a");
AGR.CHAR("L2(29)","L229G1-Zr29B0",0,11,"29a");
AGR.CHAR("L2(29)","L229G1-Zr30gB0",0,[2,3],"15ab");
AGR.CHAR("L2(29)","L229G1-Zr56B0",0,[5,6],"28bc");
AGR.CHAR("L2(29)","L229G1-f29r11B0",29,6,"11a");
AGR.CHAR("L2(29)","L229G1-f29r13B0",29,7,"13a");
AGR.CHAR("L2(29)","L229G1-f29r15B0",29,8,"15a");
AGR.CHAR("L2(29)","L229G1-f29r17B0",29,9,"17a");
AGR.CHAR("L2(29)","L229G1-f29r19B0",29,10,"19a");
AGR.CHAR("L2(29)","L229G1-f29r21B0",29,11,"21a");
AGR.CHAR("L2(29)","L229G1-f29r23B0",29,12,"23a");
AGR.CHAR("L2(29)","L229G1-f29r25B0",29,13,"25a");
AGR.CHAR("L2(29)","L229G1-f29r27B0",29,14,"27a");
AGR.CHAR("L2(29)","L229G1-f29r29B0",29,15,"29a");
AGR.CHAR("L2(29)","L229G1-f29r3B0",29,2,"3a");
AGR.CHAR("L2(29)","L229G1-f29r5B0",29,3,"5a");
AGR.CHAR("L2(29)","L229G1-f29r7B0",29,4,"7a");
AGR.CHAR("L2(29)","L229G1-f29r9B0",29,5,"9a");
AGR.CHAR("L2(29)","L229G1-f3r28aB0",3,4,"28a");
AGR.CHAR("L2(29)","L229G1-f4r14aB0",2,2,"14a");
AGR.CHAR("L2(29)","L229G1-f4r14bB0",2,3,"14b");
AGR.CHAR("L2(29)","L229G1-f5r28bB0",5,5,"28b");
AGR.CHAR("L2(29)","L229G1-f7r29B0",7,11,"29a");
AGR.CHAR("L2(29)","L229G1-p30B0",0,[1,11],"1a+29a");
AGR.CHAR("L2(31)","L231G1-Ar32aB0",0,16,"32e");
AGR.CHAR("L2(31)","L231G1-Ar32bB0",0,13,"32b");
AGR.CHAR("L2(31)","L231G1-Ar32cB0",0,14,"32c");
AGR.CHAR("L2(31)","L231G1-Ar32dB0",0,15,"32d");
AGR.CHAR("L2(31)","L231G1-Ar32eB0",0,16,"32e");
AGR.CHAR("L2(31)","L231G1-Ar32fB0",0,17,"32f");
AGR.CHAR("L2(31)","L231G1-Ar32gB0",0,18,"32g");
AGR.CHAR("L2(31)","L231G1-Zr120B0",0,[7,8,9,10],"30defg");
AGR.CHAR("L2(31)","L231G1-Zr30aB0",0,4,"30a");
AGR.CHAR("L2(31)","L231G1-Zr30hB0",0,[2,3],"15ab");
AGR.CHAR("L2(31)","L231G1-Zr31B0",0,11,"31a");
AGR.CHAR("L2(31)","L231G1-Zr32aB0",0,12,"32a");
AGR.CHAR("L2(31)","L231G1-Zr60B0",0,[5,6],"30bc");
AGR.CHAR("L2(31)","L231G1-f16r32dB0",2,7,"32d");
AGR.CHAR("L2(31)","L231G1-f16r32eB0",2,8,"32e");
AGR.CHAR("L2(31)","L231G1-f16r32fB0",2,9,"32f");
AGR.CHAR("L2(31)","L231G1-f16r32gB0",2,10,"32g");
AGR.CHAR("L2(31)","L231G1-f2r15aB0",2,2,"15a");
AGR.CHAR("L2(31)","L231G1-f2r15bB0",2,3,"15b");
AGR.CHAR("L2(31)","L231G1-f2r32B0",2,4,"32a");
AGR.CHAR("L2(31)","L231G1-f31r31B0",31,16,"31a");
AGR.CHAR("L2(31)","L231G1-f31r3B0",31,2,"3a");
AGR.CHAR("L2(31)","L231G1-f3r31B0",3,11,"31a");
AGR.CHAR("L2(31)","L231G1-f4r32bB0",2,5,"32b");
AGR.CHAR("L2(31)","L231G1-f4r32cB0",2,6,"32c");
AGR.CHAR("L2(31)","L231G1-f5r31B0",5,11,"31a");
AGR.CHAR("L2(31)","L231G1-p32B0",0,[1,11],"1a+31a");
AGR.CHAR("L2(32)","L232G1-Ar33aB0",0,19,"33a");
AGR.CHAR("L2(32)","L232G1-Ar33bB0",0,20,"33b");
AGR.CHAR("L2(32)","L232G1-Ar33cB0",0,21,"33c");
AGR.CHAR("L2(32)","L232G1-Ar33dB0",0,22,"33d");
AGR.CHAR("L2(32)","L232G1-Ar33eB0",0,23,"33e");
AGR.CHAR("L2(32)","L232G1-Ar33fB0",0,24,"33f");
AGR.CHAR("L2(32)","L232G1-Ar33gB0",0,25,"33g");
AGR.CHAR("L2(32)","L232G1-Ar33hB0",0,26,"33h");
AGR.CHAR("L2(32)","L232G1-Ar33iB0",0,27,"33i");
AGR.CHAR("L2(32)","L232G1-Ar33jB0",0,28,"33j");
AGR.CHAR("L2(32)","L232G1-Ar33kB0",0,29,"33k");
AGR.CHAR("L2(32)","L232G1-Ar33lB0",0,30,"33l");
AGR.CHAR("L2(32)","L232G1-Ar33mB0",0,31,"33m");
AGR.CHAR("L2(32)","L232G1-Ar33nB0",0,32,"33n");
AGR.CHAR("L2(32)","L232G1-Ar33oB0",0,33,"33o");
AGR.CHAR("L2(32)","L232G1-Zr155B0",0,[3,4,5,6,7],"31bcdef");
AGR.CHAR("L2(32)","L232G1-Zr310B0",0,[8,9,10,11,12,13,14,15,16,17],"31ghijklmnop");
AGR.CHAR("L2(32)","L232G1-Zr31aB0",0,2,"31a");
AGR.CHAR("L2(32)","L232G1-Zr32B0",0,18,"32a");
AGR.CHAR("L2(32)","L232G1-f11r31bB0",11,3,"31b");
AGR.CHAR("L2(32)","L232G1-f31r32B0",31,18,"32a");
AGR.CHAR("L2(32)","L232G1-f32r2aB0",2,2,"2a");
AGR.CHAR("L2(32)","L232G1-f3r31aB0",3,2,"31a");
AGR.CHAR("L2(32)","L232G1-p33B0",0,[1,18],"1a+32a");
AGR.CHAR("L2(32)","L232G1-p496B0",0,[1,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33],"1a+33abcdefghijklmno");
AGR.CHAR("L2(32)","L232G1-p528B0",0,[1,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33],"1a+32a+33abcdefghijklmno");
AGR.CHAR("L2(32).5","L232d5G1-f2r10B0",2,6);
AGR.CHAR("L2(32).5","L232d5G1-f2r20aB0",2,7);
AGR.CHAR("L2(32).5","L232d5G1-f2r20bB0",2,8);
AGR.CHAR("L2(32).5","L232d5G1-f2r32B0",2,12);
AGR.CHAR("L2(32).5","L232d5G1-f2r40aB0",2,9);
AGR.CHAR("L2(32).5","L232d5G1-f2r40bB0",2,10);
AGR.CHAR("L2(32).5","L232d5G1-f2r80B0",2,11);
AGR.CHAR("L2(32).5","L232d5G1-p33B0",0,[1,14]);
AGR.CHAR("L2(32).5","L232d5G1-p496B0",0,[1,19,20,21]);
AGR.CHAR("L2(32).5","L232d5G1-p528B0",0,[1,14,19,20,21]);
AGR.CHAR("L2(8)","L28G1-Ar7bB0",0,3,"7b");
AGR.CHAR("L2(8)","L28G1-Ar7cB0",0,4,"7c");
AGR.CHAR("L2(8)","L28G1-Ar7dB0",0,5,"7d");
AGR.CHAR("L2(8)","L28G1-Ar9aB0",0,7,"9a");
AGR.CHAR("L2(8)","L28G1-Ar9bB0",0,8,"9b");
AGR.CHAR("L2(8)","L28G1-Ar9cB0",0,9,"9c");
AGR.CHAR("L2(8)","L28G1-Zr27B0",0,[7,8,9],"9abc");
AGR.CHAR("L2(8)","L28G1-Zr7aB0",0,2,"7a");
AGR.CHAR("L2(8)","L28G1-Zr8B0",0,6,"8a");
AGR.CHAR("L2(8)","L28G1-f27r9aB0",3,3,"9a");
AGR.CHAR("L2(8)","L28G1-f27r9bB0",3,4,"9b");
AGR.CHAR("L2(8)","L28G1-f27r9cB0",3,5,"9c");
AGR.CHAR("L2(8)","L28G1-f2r12B0",2,[5,6,7],"4abc");
AGR.CHAR("L2(8)","L28G1-f2r6B0",2,[2,3,4],"2abc");
AGR.CHAR("L2(8)","L28G1-f2r8B0",2,8,"8a");
AGR.CHAR("L2(8)","L28G1-f3r27B0",3,[3,4,5],"9abc");
AGR.CHAR("L2(8)","L28G1-f3r7B0",3,2,"7a");
AGR.CHAR("L2(8)","L28G1-f7r21B0",7,[3,4,5],"7bcd");
AGR.CHAR("L2(8)","L28G1-f7r7aB0",7,2,"7a");
AGR.CHAR("L2(8)","L28G1-f7r8B0",7,6,"8a");
AGR.CHAR("L2(8)","L28G1-f8r2aB0",2,2,"2a");
AGR.CHAR("L2(8)","L28G1-f8r2bB0",2,3,"2b");
AGR.CHAR("L2(8)","L28G1-f8r2cB0",2,4,"2c");
AGR.CHAR("L2(8)","L28G1-f8r4aB0",2,5,"4a");
AGR.CHAR("L2(8)","L28G1-f8r4bB0",2,6,"4b");
AGR.CHAR("L2(8)","L28G1-f8r4cB0",2,7,"4c");
AGR.CHAR("L2(8)","L28G1-p28B0",0,[1,7,8,9],"1a+9abc");
AGR.CHAR("L2(8)","L28G1-p36B0",0,[1,6,7,8,9],"1a+8a+9abc");
AGR.CHAR("L2(8)","L28G1-p9B0",0,[1,6],"1a+8a");
AGR.CHAR("L2(8).3","L28d3G1-Zr21B0",0,7);
AGR.CHAR("L2(8).3","L28d3G1-Zr27B0",0,11);
AGR.CHAR("L2(8).3","L28d3G1-Zr7B0",0,4);
AGR.CHAR("L2(8).3","L28d3G1-Zr8B0",0,8);
AGR.CHAR("L2(8).3","L28d3G1-f2r12B0",2,5);
AGR.CHAR("L2(8).3","L28d3G1-f2r6B0",2,4);
AGR.CHAR("L2(8).3","L28d3G1-f2r8B0",2,6);
AGR.CHAR("L2(8).3","L28d3G1-f3r27B0",3,3);
AGR.CHAR("L2(8).3","L28d3G1-f3r7B0",3,2);
AGR.CHAR("L2(8).3","L28d3G1-f7r21B0",7,7);
AGR.CHAR("L2(8).3","L28d3G1-f7r7B0",7,4);
AGR.CHAR("L2(8).3","L28d3G1-f7r8B0",7,8);
AGR.CHAR("L2(8).3","L28d3G1-p28B0",0,[1,11]);
AGR.CHAR("L2(8).3","L28d3G1-p36B0",0,[1,8,11]);
AGR.CHAR("L2(8).3","L28d3G1-p9B0",0,[1,8]);
AGR.CHAR("L3(4).2_1","L34d2aG1-f2r16aB0",2,2);
AGR.CHAR("L3(4).2_1","L34d2aG1-f2r18aB0",2,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f2r64aB0",2,4);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r126aB0",3,12);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r15aB0",3,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r15bB0",3,5);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r15cB0",3,7);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r19aB0",3,9);
AGR.CHAR("L3(4).2_1","L34d2aG1-f3r90aB0",3,11);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r20aB0",5,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r35aB0",5,5);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r35bB0",5,7);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r35cB0",5,9);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r63aB0",5,12);
AGR.CHAR("L3(4).2_1","L34d2aG1-f5r90aB0",5,11);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r126aB0",7,13);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r19aB0",7,3);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r35aB0",7,5);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r35bB0",7,7);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r35cB0",7,9);
AGR.CHAR("L3(4).2_1","L34d2aG1-f7r45aB0",7,11);
AGR.CHAR("L3(7)","L37G1-Zr152aB0",0,4,"152a");
AGR.CHAR("L3(7)","L37G1-Zr152bB0",0,5,"152b");
AGR.CHAR("L3(7)","L37G1-Zr152cB0",0,6,"152c");
AGR.CHAR("L3(7)","L37G1-Zr56B0",0,2,"56a");
AGR.CHAR("L3(7)","L37G1-Zr57B0",0,3,"57a");
AGR.CHAR("L3(7)","L37G1-f2r152aB0",2,3,"152a");
AGR.CHAR("L3(7)","L37G1-f3r342aB0",3,13,"342a");
AGR.CHAR("L3(7)","L37G1-f3r399B0",3,20,"399a");
AGR.CHAR("L3(7)","L37G1-f3r55B0",3,2,"55a");
AGR.CHAR("L3(7)","L37G1-f3r57B0",3,3,"57a");
AGR.CHAR("L3(7)","L37G1-f3r96aB0",3,4,"96a");
AGR.CHAR("L3(7)","L37G1-f3r96bB0",3,5,"96b");
AGR.CHAR("L3(7)","L37G1-f3r96cB0",3,6,"96c");
AGR.CHAR("L3(7)","L37G1-f7r10aB0",7,3,"10a");
AGR.CHAR("L3(7)","L37G1-f7r10bB0",7,4,"10b");
AGR.CHAR("L3(7)","L37G1-f7r27B0",7,5,"27a");
AGR.CHAR("L3(7)","L37G1-f7r8B0",7,2,"8a");
AGR.CHAR("L3(7)","L37G1-p57B0",0,[1,2],"1a+56a");
AGR.CHAR("L3(7).2","L37d2G1-f2r152B0",2,3);
AGR.CHAR("L3(7).2","L37d2G1-f2r342B0",2,8);
AGR.CHAR("L3(7).2","L37d2G1-f2r56B0",2,2);
AGR.CHAR("L3(7).2","L37d2G1-f3r192B0",3,9);
AGR.CHAR("L3(7).2","L37d2G1-f3r399B0",3,21);
AGR.CHAR("L3(7).2","L37d2G1-f3r55B0",3,3);
AGR.CHAR("L3(7).2","L37d2G1-f3r57B0",3,5);
AGR.CHAR("L3(7).2","L37d2G1-f3r96B0",3,7);
AGR.CHAR("L3(7).2","L37d2G1-f7r343B0",7,18);
AGR.CHAR("L3(7).2","L37d2G1-f7r56B0",7,8);
AGR.CHAR("L3(8)","L38G1-Zr72B0",0,2,"72a");
AGR.CHAR("L3(8)","L38G1-f2r27B0",2,35,"27a");
AGR.CHAR("L3(8)","L38G1-f2r512B0",2,64,"512a");
AGR.CHAR("L3(8)","L38G1-f343r511B0",7,28,"511b");
AGR.CHAR("L3(8)","L38G1-f3r511B0",3,33,"511a");
AGR.CHAR("L3(8)","L38G1-f3r72B0",3,2,"72a");
AGR.CHAR("L3(8)","L38G1-f73r441B0",73,9,"441a");
AGR.CHAR("L3(8)","L38G1-f73r511aB0",73,10,"511a");
AGR.CHAR("L3(8)","L38G1-f73r511bB0",73,11,"511b");
AGR.CHAR("L3(8)","L38G1-f73r71B0",73,2,"71a");
AGR.CHAR("L3(8)","L38G1-f7r511B0",7,27,"511a");
AGR.CHAR("L3(8)","L38G1-f7r512B0",7,31,"512a");
AGR.CHAR("L3(8)","L38G1-f7r72B0",7,2,"72a");
AGR.CHAR("L3(8)","L38G1-p56064B0",0,[1,[2,2],3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,[34,2],[35,2],[36,2],37,38,39,40,41,42,[43,2],[44,2],[45,2],[46,2],[47,2],[48,2],[49,2],[50,2],[51,2],[52,2],[53,2],[54,2],[55,2],[56,2],[57,2],[58,2],[59,2],[60,2],[61,2],[62,2],[63,2],[64,2],[65,2],[66,2],[67,2],[68,3],[69,3],[70,4],[71,4],[72,4]],"1a+72a^2+73abcdef+441abcdefghijklmnopqrstuvwx+511ab^2c^2d^2efghijk^2l^2m^2n^2o^2p^2q^2r^2s^2t^2u^2v^2w^2x^2y^2z^2(a')^2(b')^2+512a^2+584a^2b^2c^2d^2e^2f^2+657a^3b^3c^4d^4e^4");
AGR.CHAR("L3(8)","L38G1-p73aB0",0,[1,2],"1a+72a");
AGR.CHAR("L3(8)","L38G1-p73bB0",0,[1,2],"1a+72a");
AGR.CHAR("L3(8)","L38G1-p75264B0",0,[1,3,4,5,6,7,8,[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],[20,2],[21,2],[22,2],[23,2],[24,2],[25,2],[26,2],[27,2],[28,2],[29,2],[30,2],[31,2],[32,2],33,[34,3],[35,3],[36,3],37,38,39,40,41,42,[43,3],[44,3],[45,3],[46,3],[47,3],[48,3],[49,3],[50,3],[51,3],[52,3],[53,3],[54,3],[55,3],[56,3],[57,3],[58,3],[59,3],[60,3],[61,2],[62,2],[63,2],[64,2],[65,2],[66,2],[67,2],[68,3],[69,3],[70,3],[71,3],[72,3]],"1a+73abcdef+441a^2b^2c^2d^2e^2f^2g^2h^2i^2j^2k^2l^2m^2n^2o^2p^2q^2r^2s^2t^2u^2v^2w^2x^2+511ab^3c^3d^3efghijk^3l^3m^3n^3o^3p^3q^3r^3s^3t^3u^3v^3w^3x^3y^3z^3(a')^3(b')^3+512a^2+584a^2b^2c^2d^2e^2f^2+657a^3b^3c^3d^3e^3");
AGR.CHAR("L3(8)","L38G1-p98112B0",0,[1,[2,2],[3,2],[4,2],[5,2],[6,2],[7,2],[8,2],[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],[20,2],[21,2],[22,2],[23,2],[24,2],[25,2],[26,2],[27,2],[28,2],[29,2],[30,2],[31,2],[32,2],[33,2],[34,3],[35,3],[36,3],[37,2],[38,2],[39,2],[40,2],[41,2],[42,2],[43,3],[44,3],[45,3],[46,3],[47,3],[48,3],[49,3],[50,3],[51,3],[52,3],[53,3],[54,3],[55,3],[56,3],[57,3],[58,3],[59,3],[60,3],[61,3],[62,4],[63,4],[64,4],[65,4],[66,4],[67,4],[68,7],[69,7],[70,6],[71,6],[72,6]],"1a+72a^2+73a^2b^2c^2d^2e^2f^2+441a^2b^2c^2d^2e^2f^2g^2h^2i^2j^2k^2l^2m^2n^2o^2p^2q^2r^2s^2t^2u^2v^2w^2x^2+511a^2b^3c^3d^3e^2f^2g^2h^2i^2j^2k^3l^3m^3n^3o^3p^3q^3r^3s^3t^3u^3v^3w^3x^3y^3z^3(a')^3(b')^3+512a^3+584a^4b^4c^4d^4e^4f^4+657a^7b^7c^6d^6e^6");
AGR.CHAR("L3(8).2","L38d2G1-f2r54B0",2,20);
AGR.CHAR("L3(8).2","L38d2G1-f3r511B0",3,20);
AGR.CHAR("L3(8).2","L38d2G1-f73r511aB0",73,10);
AGR.CHAR("L3(8).2","L38d2G1-f7r512B0",7,25);
AGR.CHAR("L3(8).2","L38d2G1-p146B0",0,[1,2,3,4]);
AGR.CHAR("L3(8).2","L38d2G1-p4672B0",0,[1,3,4,20,22,24,26,40,46,48,50]);
AGR.CHAR("L3(8).2","L38d2G1-p56064B0",0,[1,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,[22,2],[24,2],[26,2],28,29,30,[31,2],[32,2],[33,2],[34,2],[35,2],[36,2],[37,2],[38,2],[39,2],[40,2],[42,2],[43,2],[44,2],[45,3],[46,3],47,[48,3],49,[50,3],51]);
AGR.CHAR("L3(8).2","L38d2G1-p657B0",0,[1,3,4,40]);
AGR.CHAR("L3(8).2","L38d2G1-p75264B0",0,[1,5,6,7,[8,2],[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],20,[22,3],[24,3],[26,3],28,29,30,[31,3],[32,3],[33,3],[34,3],[35,3],[36,3],[37,3],[38,3],[39,3],[40,2],[42,2],[43,2],[44,2],[45,3],[46,3],[48,3],[50,3]]);
AGR.CHAR("L3(8).2","L38d2G1-p98112B0",0,[1,3,4,[5,2],[6,2],[7,2],[8,2],[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],[17,2],[18,2],[19,2],20,21,[22,2],23,[24,2],25,[26,2],27,[28,2],[29,2],[30,2],[31,3],[32,3],[33,3],[34,3],[35,3],[36,3],[37,3],[38,3],[39,3],[40,2],41,[42,4],[43,4],[44,4],[45,7],[46,4],[47,2],[48,4],[49,2],[50,4],[51,2]]);
AGR.CHAR("L3(8).3","L38d3G1-f2r192B0",2,23);
AGR.CHAR("L3(8).3","L38d3G1-f2r216aB0",2,24);
AGR.CHAR("L3(8).3","L38d3G1-f2r216bB0",2,26);
AGR.CHAR("L3(8).3","L38d3G1-f2r24B0",2,6);
AGR.CHAR("L3(8).3","L38d3G1-f2r27aB0",2,7);
AGR.CHAR("L3(8).3","L38d3G1-f2r27bB0",2,10);
AGR.CHAR("L3(8).3","L38d3G1-f2r27cB0",2,15);
AGR.CHAR("L3(8).3","L38d3G1-f2r576B0",2,28);
AGR.CHAR("L3(8).3","L38d3G1-f2r72aB0",2,11);
AGR.CHAR("L3(8).3","L38d3G1-f2r72bB0",2,13);
AGR.CHAR("L3(8).3","L38d3G1-f2r81B0",2,21);
AGR.CHAR("L3(8).3","L38d3G1-f2r9B0",2,4);
AGR.CHAR("L3(8).3","L38d3G1-f3r511B0",3,13);
AGR.CHAR("L3(8).3","L38d3G1-f3r72B0",3,2);
AGR.CHAR("L3(8).3","L38d3G1-f73r441B0",73,9);
AGR.CHAR("L3(8).3","L38d3G1-f73r511aB0",73,12);
AGR.CHAR("L3(8).3","L38d3G1-f73r71B0",73,4);
AGR.CHAR("L3(8).3","L38d3G1-f7r511B0",7,15);
AGR.CHAR("L3(8).3","L38d3G1-f7r512B0",7,19);
AGR.CHAR("L3(8).3","L38d3G1-f7r72B0",7,4);
AGR.CHAR("L3(8).3","L38d3G1-p219aB0",0,[1,2,3,4,5,6]);
AGR.CHAR("L3(8).3","L38d3G1-p219bB0",0,[1,2,3,4,5,6]);
AGR.CHAR("L3(8).3","L38d3G1-p56064B0",0,[1,[4,2],7,8,9,10,11,12,13,14,15,16,17,[20,2],21,22,[23,2],[24,2],[25,2],[26,2],[27,2],[28,2],[29,2],[32,2],[33,2],34,35,36,37,38,39,[40,4]]);
AGR.CHAR("L3(8).3","L38d3G1-p73aB0",0,[1,4]);
AGR.CHAR("L3(8).3","L38d3G1-p73bB0",0,[1,4]);
AGR.CHAR("L3(8).3","L38d3G1-p75264B0",0,[1,7,8,[9,2],[10,2],[11,2],[12,2],[13,2],[14,2],[15,2],[16,2],17,[20,3],21,22,[23,3],[24,3],[25,3],[26,3],[27,3],[28,3],30,31,[32,2],[33,2],34,35,36,37,38,39,[40,3]]);
AGR.CHAR("L3(8).3","L38d3G1-p98112B0",0,[1,2,3,[4,2],[5,2],[6,2],[7,6],[8,6],17,18,19,[20,3],[21,3],[22,3],[23,3],[24,3],[25,3],[26,3],[27,3],[28,3],29,30,31,[32,6],[33,6],[34,3],[35,3],[36,3],[37,3],[38,3],[39,3],[40,9]]);
AGR.CHAR("L3(8).6","L38d6G1-f2r1152B0",2,17);
AGR.CHAR("L3(8).6","L38d6G1-f2r144aB0",2,8);
AGR.CHAR("L3(8).6","L38d6G1-f2r144bB0",2,9);
AGR.CHAR("L3(8).6","L38d6G1-f2r162B0",2,13);
AGR.CHAR("L3(8).6","L38d6G1-f2r18B0",2,4);
AGR.CHAR("L3(8).6","L38d6G1-f2r192B0",2,14);
AGR.CHAR("L3(8).6","L38d6G1-f2r24B0",2,5);
AGR.CHAR("L3(8).6","L38d6G1-f2r432aB0",2,15);
AGR.CHAR("L3(8).6","L38d6G1-f2r432bB0",2,16);
AGR.CHAR("L3(8).6","L38d6G1-f2r512B0",2,18);
AGR.CHAR("L3(8).6","L38d6G1-f2r54aB0",2,6);
AGR.CHAR("L3(8).6","L38d6G1-f2r54bB0",2,7);
AGR.CHAR("L3(8).6","L38d6G1-f3r511B0",3,10);
AGR.CHAR("L3(8).6","L38d6G1-f73r511aB0",73,20);
AGR.CHAR("L3(8).6","L38d6G1-f7r511B0",7,17);
AGR.CHAR("L3(8).6","L38d6G1-f7r512B0",7,25);
AGR.CHAR("L3(8).6","L38d6G1-p438B0",0,[1,2,3,4,5,6,7,8,9,10,11,12]);
AGR.CHAR("L3(8).6","L38d6G1-p4672B0",0,[1,7,10,18,24,30,40]);
AGR.CHAR("L3(8).6","L38d6G1-p56064B0",0,[1,7,10,13,14,15,16,17,18,[24,2],26,[27,2],[28,2],[29,2],[30,2],[36,2],37,38,39,[40,3],41]);
AGR.CHAR("L3(8).6","L38d6G1-p657B0",0,[1,7,10,30]);
AGR.CHAR("L3(8).6","L38d6G1-p75264B0",0,[1,13,[14,2],[15,2],[16,2],[17,2],18,[24,3],26,[27,3],[28,3],[29,3],32,34,[36,2],37,38,39,[40,3]]);
AGR.CHAR("L3(8).6","L38d6G1-p98112B0",0,[1,7,10,[13,2],[14,2],[15,2],[16,2],[17,2],18,21,[24,2],25,[26,2],[27,3],[28,3],[29,3],[30,2],33,[36,4],[37,3],[38,2],[39,2],[40,4],[41,2]]);
AGR.CHAR("L5(2)","L52G1-Zr124B0",0,3,"124a");
AGR.CHAR("L5(2)","L52G1-Zr155B0",0,4,"155a");
AGR.CHAR("L5(2)","L52G1-Zr217B0",0,5,"217a");
AGR.CHAR("L5(2)","L52G1-Zr30B0",0,2,"30a");
AGR.CHAR("L5(2)","L52G1-f2r10aB0",2,4,"10a");
AGR.CHAR("L5(2)","L52G1-f2r10bB0",2,5,"10b");
AGR.CHAR("L5(2)","L52G1-f2r24B0",2,6,"24a");
AGR.CHAR("L5(2)","L52G1-f2r5aB0",2,2,"5a");
AGR.CHAR("L5(2)","L52G1-f2r5bB0",2,3,"5b");
AGR.CHAR("L5(2)","L52G1-f31r251B0",31,6,"251a");
AGR.CHAR("L5(2)","L52G1-f31r29B0",31,2,"29a");
AGR.CHAR("L5(2)","L52G1-f3r124B0",3,3,"124a");
AGR.CHAR("L5(2)","L52G1-f3r155B0",3,4,"155a");
AGR.CHAR("L5(2)","L52G1-f3r30B0",3,2,"30a");
AGR.CHAR("L5(2)","L52G1-f5r123B0",5,3,"123a");
AGR.CHAR("L5(2)","L52G1-f5r155B0",5,4,"155a");
AGR.CHAR("L5(2)","L52G1-f5r280B0",5,6,"280a");
AGR.CHAR("L5(2)","L52G1-f5r30B0",5,2,"30a");
AGR.CHAR("L5(2)","L52G1-f7r280B0",7,6,"280a");
AGR.CHAR("L5(2)","L52G1-f7r30B0",7,2,"30a");
AGR.CHAR("L5(2)","L52G1-f7r94B0",7,3,"94a");
AGR.CHAR("L5(2)","L52G1-p155aB0",0,[1,2,3],"1a+30a+124a");
AGR.CHAR("L5(2)","L52G1-p31aB0",0,[1,2],"1a+30a");
AGR.CHAR("M11","M11G1-Ar10bB0",0,3,"10b");
AGR.CHAR("M11","M11G1-Ar10cB0",0,4,"10c");
AGR.CHAR("M11","M11G1-Zr10aB0",0,2,"10a");
AGR.CHAR("M11","M11G1-Zr11B0",0,5,"11a");
AGR.CHAR("M11","M11G1-Zr20B0",0,[3,4],"10bc");
AGR.CHAR("M11","M11G1-Zr32B0",0,[6,7],"16ab");
AGR.CHAR("M11","M11G1-Zr44B0",0,8,"44a");
AGR.CHAR("M11","M11G1-Zr45B0",0,9,"45a");
AGR.CHAR("M11","M11G1-Zr55B0",0,10,"55a");
AGR.CHAR("M11","M11G1-f11r10aB0",11,3,"10a");
AGR.CHAR("M11","M11G1-f11r10bB0",11,4,"10b");
AGR.CHAR("M11","M11G1-f11r11B0",11,5,"11a");
AGR.CHAR("M11","M11G1-f11r16B0",11,6,"16a");
AGR.CHAR("M11","M11G1-f11r44B0",11,7,"44a");
AGR.CHAR("M11","M11G1-f11r55B0",11,8,"55a");
AGR.CHAR("M11","M11G1-f11r9B0",11,2,"9a");
AGR.CHAR("M11","M11G1-f25r10bB0",5,3,"10b");
AGR.CHAR("M11","M11G1-f25r10cB0",5,4,"10c");
AGR.CHAR("M11","M11G1-f2r10B0",2,2,"10a");
AGR.CHAR("M11","M11G1-f2r32B0",2,[3,4],"16ab");
AGR.CHAR("M11","M11G1-f2r44B0",2,5,"44a");
AGR.CHAR("M11","M11G1-f3r10aB0",3,4,"10a");
AGR.CHAR("M11","M11G1-f3r10bB0",3,5,"10b");
AGR.CHAR("M11","M11G1-f3r10cB0",3,6,"10c");
AGR.CHAR("M11","M11G1-f3r24B0",3,7,"24a");
AGR.CHAR("M11","M11G1-f3r45B0",3,8,"45a");
AGR.CHAR("M11","M11G1-f3r5aB0",3,2,"5a");
AGR.CHAR("M11","M11G1-f3r5bB0",3,3,"5b");
AGR.CHAR("M11","M11G1-f4r16aB0",2,3,"16a");
AGR.CHAR("M11","M11G1-f4r16bB0",2,4,"16b");
AGR.CHAR("M11","M11G1-f5r10aB0",5,2,"10a");
AGR.CHAR("M11","M11G1-f5r11B0",5,5,"11a");
AGR.CHAR("M11","M11G1-f5r16aB0",5,6,"16a");
AGR.CHAR("M11","M11G1-f5r16bB0",5,7,"16b");
AGR.CHAR("M11","M11G1-f5r20B0",5,[3,4],"10bc");
AGR.CHAR("M11","M11G1-f5r45B0",5,8,"45a");
AGR.CHAR("M11","M11G1-f5r55B0",5,9,"55a");
AGR.CHAR("M11","M11G1-p11B0",0,[1,2],"1a+10a");
AGR.CHAR("M11","M11G1-p12B0",0,[1,5],"1a+11a");
AGR.CHAR("M11","M11G1-p165B0",0,[1,2,5,[8,2],10],"1a+10a+11a+44a^2+55a");
AGR.CHAR("M11","M11G1-p55B0",0,[1,2,8],"1a+10a+44a");
AGR.CHAR("M11","M11G1-p66B0",0,[1,2,5,8],"1a+10a+11a+44a");
AGR.CHAR("M12","M12G1-Zr11aB0",0,2,"11a");
AGR.CHAR("M12","M12G1-Zr11bB0",0,3,"11b");
AGR.CHAR("M12","M12G1-Zr120B0",0,13,"120a");
AGR.CHAR("M12","M12G1-Zr144B0",0,14,"144a");
AGR.CHAR("M12","M12G1-Zr176B0",0,15,"176a");
AGR.CHAR("M12","M12G1-Zr32B0",0,[4,5],"16ab");
AGR.CHAR("M12","M12G1-Zr45B0",0,6,"45a");
AGR.CHAR("M12","M12G1-Zr54B0",0,7,"54a");
AGR.CHAR("M12","M12G1-Zr55aB0",0,8,"55a");
AGR.CHAR("M12","M12G1-Zr55bB0",0,9,"55b");
AGR.CHAR("M12","M12G1-Zr55cB0",0,10,"55c");
AGR.CHAR("M12","M12G1-Zr66B0",0,11,"66a");
AGR.CHAR("M12","M12G1-Zr99B0",0,12,"99a");
AGR.CHAR("M12","M12G1-f11r11aB0",11,2,"11a");
AGR.CHAR("M12","M12G1-f11r16B0",11,4,"16a");
AGR.CHAR("M12","M12G1-f11r176B0",11,13,"176a");
AGR.CHAR("M12","M12G1-f11r29B0",11,5,"29a");
AGR.CHAR("M12","M12G1-f11r53B0",11,6,"53a");
AGR.CHAR("M12","M12G1-f11r55aB0",11,7,"55a");
AGR.CHAR("M12","M12G1-f11r55cB0",11,9,"55c");
AGR.CHAR("M12","M12G1-f11r66B0",11,10,"66a");
AGR.CHAR("M12","M12G1-f11r91B0",11,11,"91a");
AGR.CHAR("M12","M12G1-f11r99B0",11,12,"99a");
AGR.CHAR("M12","M12G1-f2r10B0",2,2,"10a");
AGR.CHAR("M12","M12G1-f2r144B0",2,6,"144a");
AGR.CHAR("M12","M12G1-f2r44B0",2,5,"44a");
AGR.CHAR("M12","M12G1-f3r10aB0",3,2,"10a");
AGR.CHAR("M12","M12G1-f3r15bB0",3,5,"15b");
AGR.CHAR("M12","M12G1-f3r34B0",3,6,"34a");
AGR.CHAR("M12","M12G1-f3r45aB0",3,7,"45a");
AGR.CHAR("M12","M12G1-f3r45bB0",3,8,"45b");
AGR.CHAR("M12","M12G1-f3r54B0",3,10,"54a");
AGR.CHAR("M12","M12G1-f3r99B0",3,11,"99a");
AGR.CHAR("M12","M12G1-f4r16aB0",2,3,"16a");
AGR.CHAR("M12","M12G1-f4r16bB0",2,4,"16b");
AGR.CHAR("M12","M12G1-f5r11aB0",5,2,"11a");
AGR.CHAR("M12","M12G1-f5r120B0",5,13,"120a");
AGR.CHAR("M12","M12G1-f5r16bB0",5,5,"16b");
AGR.CHAR("M12","M12G1-f5r45B0",5,6,"45a");
AGR.CHAR("M12","M12G1-f5r55aB0",5,7,"55a");
AGR.CHAR("M12","M12G1-f5r55cB0",5,9,"55c");
AGR.CHAR("M12","M12G1-f5r66B0",5,10,"66a");
AGR.CHAR("M12","M12G1-f5r78B0",5,11,"78a");
AGR.CHAR("M12","M12G1-f5r98B0",5,12,"98a");
AGR.CHAR("M12","M12G1-p12aB0",0,[1,2],"1a+11a");
AGR.CHAR("M12","M12G1-p12bB0",0,[1,3],"1a+11b");
AGR.CHAR("M12","M12G1-p66aB0",0,[1,2,7],"1a+11a+54a");
AGR.CHAR("M12","M12G1-p66bB0",0,[1,3,7],"1a+11b+54a");
AGR.CHAR("M12.2","M12d2G1-f11r110aB0",11,12);
AGR.CHAR("M12.2","M12d2G1-f11r16aB0",11,4);
AGR.CHAR("M12.2","M12d2G1-f11r176aB0",11,19);
AGR.CHAR("M12.2","M12d2G1-f11r22aB0",11,3);
AGR.CHAR("M12.2","M12d2G1-f11r29aB0",11,6);
AGR.CHAR("M12.2","M12d2G1-f11r53aB0",11,8);
AGR.CHAR("M12.2","M12d2G1-f11r55aB0",11,10);
AGR.CHAR("M12.2","M12d2G1-f11r66aB0",11,13);
AGR.CHAR("M12.2","M12d2G1-f11r91aB0",11,15);
AGR.CHAR("M12.2","M12d2G1-f11r99aB0",11,17);
AGR.CHAR("M12.2","M12d2G1-f25r120aB0",5,16);
AGR.CHAR("M12.2","M12d2G1-f2r10B0",2,2);
AGR.CHAR("M12.2","M12d2G1-f2r144B0",2,5);
AGR.CHAR("M12.2","M12d2G1-f2r32B0",2,3);
AGR.CHAR("M12.2","M12d2G1-f2r44B0",2,4);
AGR.CHAR("M12.2","M12d2G1-f3r20aB0",3,3);
AGR.CHAR("M12.2","M12d2G1-f3r30aB0",3,4);
AGR.CHAR("M12.2","M12d2G1-f3r34aB0",3,5);
AGR.CHAR("M12.2","M12d2G1-f3r45aB0",3,7);
AGR.CHAR("M12.2","M12d2G1-f3r90aB0",3,9);
AGR.CHAR("M12.2","M12d2G1-f3r99aB0",3,12);
AGR.CHAR("M12.2","M12d2G1-f5r110aB0",5,9);
AGR.CHAR("M12.2","M12d2G1-f5r22aB0",5,3);
AGR.CHAR("M12.2","M12d2G1-f5r32aB0",5,4);
AGR.CHAR("M12.2","M12d2G1-f5r45aB0",5,5);
AGR.CHAR("M12.2","M12d2G1-f5r55aB0",5,7);
AGR.CHAR("M12.2","M12d2G1-f5r66aB0",5,10);
AGR.CHAR("M12.2","M12d2G1-f5r78aB0",5,12);
AGR.CHAR("M12.2","M12d2G1-f5r98aB0",5,14);
AGR.CHAR("M12.2","M12d2G1-f9r54aB0",3,10);
AGR.CHAR("M12.2","M12d2G1-p24B0",0,[1,2,3]);
AGR.CHAR("M22","M22G1-Zr154B0",0,7,"154a");
AGR.CHAR("M22","M22G1-Zr210B0",0,8,"210a");
AGR.CHAR("M22","M22G1-Zr21B0",0,2,"21a");
AGR.CHAR("M22","M22G1-Zr231B0",0,9,"231a");
AGR.CHAR("M22","M22G1-Zr55B0",0,5,"55a");
AGR.CHAR("M22","M22G1-Zr99B0",0,6,"99a");
AGR.CHAR("M22","M22G1-f11r154B0",11,7,"154a");
AGR.CHAR("M22","M22G1-f11r190B0",11,8,"190a");
AGR.CHAR("M22","M22G1-f11r20B0",11,2,"20a");
AGR.CHAR("M22","M22G1-f11r231B0",11,9,"231a");
AGR.CHAR("M22","M22G1-f11r385B0",11,10,"385a");
AGR.CHAR("M22","M22G1-f11r45aB0",11,3,"45a");
AGR.CHAR("M22","M22G1-f11r45bB0",11,4,"45b");
AGR.CHAR("M22","M22G1-f11r55B0",11,5,"55a");
AGR.CHAR("M22","M22G1-f11r99B0",11,6,"99a");
AGR.CHAR("M22","M22G1-f25r45aB0",5,3,"45a");
AGR.CHAR("M22","M22G1-f2r10aB0",2,2,"10a");
AGR.CHAR("M22","M22G1-f2r10bB0",2,3,"10b");
AGR.CHAR("M22","M22G1-f2r34B0",2,4,"34a");
AGR.CHAR("M22","M22G1-f2r98B0",2,7,"98a");
AGR.CHAR("M22","M22G1-f3r210B0",3,9,"210a");
AGR.CHAR("M22","M22G1-f3r21B0",3,2,"21a");
AGR.CHAR("M22","M22G1-f3r231B0",3,10,"231a");
AGR.CHAR("M22","M22G1-f3r49aB0",3,5,"49a");
AGR.CHAR("M22","M22G1-f3r49bB0",3,6,"49b");
AGR.CHAR("M22","M22G1-f3r55B0",3,7,"55a");
AGR.CHAR("M22","M22G1-f3r99B0",3,8,"99a");
AGR.CHAR("M22","M22G1-f49r280aB0",7,8,"280a");
AGR.CHAR("M22","M22G1-f49r280bB0",7,9,"280b");
AGR.CHAR("M22","M22G1-f4r70aB0",2,5,"70a");
AGR.CHAR("M22","M22G1-f4r70bB0",2,6,"70b");
AGR.CHAR("M22","M22G1-f5r133B0",5,7,"133a");
AGR.CHAR("M22","M22G1-f5r210B0",5,8,"210a");
AGR.CHAR("M22","M22G1-f5r21B0",5,2,"21a");
AGR.CHAR("M22","M22G1-f5r280aB0",5,9,"280a");
AGR.CHAR("M22","M22G1-f5r385B0",5,11,"385a");
AGR.CHAR("M22","M22G1-f5r55B0",5,5,"55a");
AGR.CHAR("M22","M22G1-f5r98B0",5,6,"98a");
AGR.CHAR("M22","M22G1-f7r154B0",7,5,"154a");
AGR.CHAR("M22","M22G1-f7r210B0",7,6,"210a");
AGR.CHAR("M22","M22G1-f7r21B0",7,2,"21a");
AGR.CHAR("M22","M22G1-f7r231B0",7,7,"231a");
AGR.CHAR("M22","M22G1-f7r385B0",7,10,"385a");
AGR.CHAR("M22","M22G1-f7r45B0",7,3,"45a");
AGR.CHAR("M22","M22G1-f7r54B0",7,4,"54a");
AGR.CHAR("M22","M22G1-f9r45aB0",3,3,"45a");
AGR.CHAR("M22","M22G1-p176aB0",0,[1,2,7],"1a+21a+154a");
AGR.CHAR("M22","M22G1-p176bB0",0,[1,2,7],"1a+21a+154a");
AGR.CHAR("M22","M22G1-p22B0",0,[1,2],"1a+21a");
AGR.CHAR("M22","M22G1-p231B0",0,[1,2,5,7],"1a+21a+55a+154a");
AGR.CHAR("M22","M22G1-p330B0",0,[1,2,5,6,7],"1a+21a+55a+99a+154a");
AGR.CHAR("M22","M22G1-p462aB0",0,[1,2,5,7,9],"1a+21a+55a+154a+231a");
AGR.CHAR("M22","M22G1-p462bB0",0,[1,[2,2],5,7,8],"1a+21a^2+55a+154a+210a");
AGR.CHAR("M22","M22G1-p462cB0",0,[1,[2,2],5,7,8],"1a+21a^2+55a+154a+210a");
AGR.CHAR("M22","M22G1-p616B0",0,[1,2,5,7,12],"1a+21a+55a+154a+385a");
AGR.CHAR("M22","M22G1-p672B0",0,[1,2,5,7,8,9],"1a+21a+55a+154a+210a+231a");
AGR.CHAR("M22","M22G1-p770B0",0,[1,2,[5,2],6,7,12],"1a+21a+55a^2+99a+154a+385a");
AGR.CHAR("M22","M22G1-p77B0",0,[1,2,5],"1a+21a+55a");
AGR.CHAR("M22.2","M22d2G1-f11r154aB0",11,13);
AGR.CHAR("M22.2","M22d2G1-f11r190aB0",11,15);
AGR.CHAR("M22.2","M22d2G1-f11r20aB0",11,3);
AGR.CHAR("M22.2","M22d2G1-f11r231aB0",11,17);
AGR.CHAR("M22.2","M22d2G1-f11r385aB0",11,19);
AGR.CHAR("M22.2","M22d2G1-f11r45aB0",11,5);
AGR.CHAR("M22.2","M22d2G1-f11r45bB0",11,7);
AGR.CHAR("M22.2","M22d2G1-f11r55aB0",11,9);
AGR.CHAR("M22.2","M22d2G1-f11r99aB0",11,11);
AGR.CHAR("M22.2","M22d2G1-f25r45aB0",5,5);
AGR.CHAR("M22.2","M22d2G1-f25r45bB0",5,7);
AGR.CHAR("M22.2","M22d2G1-f2r10aB0",2,2);
AGR.CHAR("M22.2","M22d2G1-f2r10bB0",2,3);
AGR.CHAR("M22.2","M22d2G1-f2r140B0",2,5);
AGR.CHAR("M22.2","M22d2G1-f2r34B0",2,4);
AGR.CHAR("M22.2","M22d2G1-f2r98B0",2,6);
AGR.CHAR("M22.2","M22d2G1-f3r210aB0",3,14);
AGR.CHAR("M22.2","M22d2G1-f3r21aB0",3,3);
AGR.CHAR("M22.2","M22d2G1-f3r231aB0",3,16);
AGR.CHAR("M22.2","M22d2G1-f3r55aB0",3,10);
AGR.CHAR("M22.2","M22d2G1-f3r98B0",3,9);
AGR.CHAR("M22.2","M22d2G1-f3r99aB0",3,12);
AGR.CHAR("M22.2","M22d2G1-f5r133aB0",5,13);
AGR.CHAR("M22.2","M22d2G1-f5r210aB0",5,15);
AGR.CHAR("M22.2","M22d2G1-f5r21aB0",5,3);
AGR.CHAR("M22.2","M22d2G1-f5r385aB0",5,18);
AGR.CHAR("M22.2","M22d2G1-f5r55aB0",5,9);
AGR.CHAR("M22.2","M22d2G1-f5r560B0",5,17);
AGR.CHAR("M22.2","M22d2G1-f5r98aB0",5,11);
AGR.CHAR("M22.2","M22d2G1-f7r154aB0",7,9);
AGR.CHAR("M22.2","M22d2G1-f7r210aB0",7,11);
AGR.CHAR("M22.2","M22d2G1-f7r21aB0",7,3);
AGR.CHAR("M22.2","M22d2G1-f7r231aB0",7,13);
AGR.CHAR("M22.2","M22d2G1-f7r385aB0",7,16);
AGR.CHAR("M22.2","M22d2G1-f7r45aB0",7,5);
AGR.CHAR("M22.2","M22d2G1-f7r54aB0",7,7);
AGR.CHAR("M22.2","M22d2G1-f7r560B0",7,15);
AGR.CHAR("M22.2","M22d2G1-f9r45aB0",3,5);
AGR.CHAR("M22.2","M22d2G1-f9r45bB0",3,7);
AGR.CHAR("M22.2","M22d2G1-p22B0",0,[1,3]);
AGR.CHAR("M22.2","M22d2G1-p231B0",0,[1,3,9,13]);
AGR.CHAR("M22.2","M22d2G1-p330B0",0,[1,3,9,11,13]);
AGR.CHAR("M22.2","M22d2G1-p352B0",0,[1,2,3,4,13,14]);
AGR.CHAR("M22.2","M22d2G1-p616B0",0,[1,3,9,13,20]);
AGR.CHAR("M22.2","M22d2G1-p672B0",0,[1,4,9,13,16,18]);
AGR.CHAR("M22.2","M22d2G1-p77B0",0,[1,3,9]);
AGR.CHAR("M23","M23G1-Zr22B0",0,2,"22a");
AGR.CHAR("M23","M23G1-Zr230B0",0,5,"230a");
AGR.CHAR("M23","M23G1-Zr231aB0",0,6,"231a");
AGR.CHAR("M23","M23G1-f11r229B0",11,5,"229a");
AGR.CHAR("M23","M23G1-f11r22B0",11,2,"22a");
AGR.CHAR("M23","M23G1-f11r231aB0",11,6,"231a");
AGR.CHAR("M23","M23G1-f11r253B0",11,9,"253a");
AGR.CHAR("M23","M23G1-f11r45bB0",11,4,"45b");
AGR.CHAR("M23","M23G1-f11r806B0",11,12,"806a");
AGR.CHAR("M23","M23G1-f11r990aB0",11,13,"990a");
AGR.CHAR("M23","M23G1-f121r231bB0",11,7,"231b");
AGR.CHAR("M23","M23G1-f121r231cB0",11,8,"231c");
AGR.CHAR("M23","M23G1-f121r770aB0",11,10,"770a");
AGR.CHAR("M23","M23G1-f121r770bB0",11,11,"770b");
AGR.CHAR("M23","M23G1-f23r210B0",23,5,"210a");
AGR.CHAR("M23","M23G1-f23r21B0",23,2,"21a");
AGR.CHAR("M23","M23G1-f23r230B0",23,6,"230a");
AGR.CHAR("M23","M23G1-f23r231aB0",23,7,"231a");
AGR.CHAR("M23","M23G1-f23r253B0",23,9,"253a");
AGR.CHAR("M23","M23G1-f23r280B0",23,10,"280a");
AGR.CHAR("M23","M23G1-f23r45bB0",23,4,"45b");
AGR.CHAR("M23","M23G1-f23r665bB0",23,13,"665b");
AGR.CHAR("M23","M23G1-f25r45aB0",5,4,"45b");
AGR.CHAR("M23","M23G1-f25r770B0",5,8,"770a");
AGR.CHAR("M23","M23G1-f25r990aB0",5,13,"990b");
AGR.CHAR("M23","M23G1-f2r11aB0",2,2,"11a");
AGR.CHAR("M23","M23G1-f2r11bB0",2,3,"11b");
AGR.CHAR("M23","M23G1-f2r120B0",2,6,"120a");
AGR.CHAR("M23","M23G1-f2r220aB0",2,7,"220a");
AGR.CHAR("M23","M23G1-f2r220bB0",2,8,"220b");
AGR.CHAR("M23","M23G1-f2r252B0",2,9,"252a");
AGR.CHAR("M23","M23G1-f2r44aB0",2,4,"44a");
AGR.CHAR("M23","M23G1-f2r44bB0",2,5,"44b");
AGR.CHAR("M23","M23G1-f3r104aB0",3,5,"104a");
AGR.CHAR("M23","M23G1-f3r104bB0",3,6,"104b");
AGR.CHAR("M23","M23G1-f3r22B0",3,2,"22a");
AGR.CHAR("M23","M23G1-f3r231B0",3,7,"231a");
AGR.CHAR("M23","M23G1-f3r253B0",3,8,"253a");
AGR.CHAR("M23","M23G1-f3r770aB0",3,9,"770a");
AGR.CHAR("M23","M23G1-f49r231bB0",7,6,"231b");
AGR.CHAR("M23","M23G1-f49r231cB0",7,7,"231c");
AGR.CHAR("M23","M23G1-f49r770aB0",7,8,"770a");
AGR.CHAR("M23","M23G1-f49r770bB0",7,9,"770b");
AGR.CHAR("M23","M23G1-f49r896aB0",7,10,"896a");
AGR.CHAR("M23","M23G1-f49r896bB0",7,11,"896b");
AGR.CHAR("M23","M23G1-f4r896aB0",2,10,"896a");
AGR.CHAR("M23","M23G1-f4r896bB0",2,11,"896b");
AGR.CHAR("M23","M23G1-f5r22B0",5,2,"22a");
AGR.CHAR("M23","M23G1-f5r230B0",5,5,"230a");
AGR.CHAR("M23","M23G1-f5r231aB0",5,6,"231a");
AGR.CHAR("M23","M23G1-f5r231bB0",5,7,"231b");
AGR.CHAR("M23","M23G1-f5r896aB0",5,10,"896a");
AGR.CHAR("M23","M23G1-f7r208B0",7,4,"208a");
AGR.CHAR("M23","M23G1-f7r22B0",7,2,"22a");
AGR.CHAR("M23","M23G1-f7r231aB0",7,5,"231a");
AGR.CHAR("M23","M23G1-f7r45B0",7,3,"45a");
AGR.CHAR("M23","M23G1-f7r990B0",7,12,"990a");
AGR.CHAR("M23","M23G1-f9r45bB0",3,4,"45b");
AGR.CHAR("M23","M23G1-f9r990bB0",3,12,"990b");
AGR.CHAR("M23","M23G1-p1288B0",0,[1,2,5,16],"1a+22a+230a+1035a");
AGR.CHAR("M23","M23G1-p1771B0",0,[1,2,[5,2],9,16],"1a+22a+230a^2+253a+1035a");
AGR.CHAR("M23","M23G1-p23B0",0,[1,2],"1a+22a");
AGR.CHAR("M23","M23G1-p253aB0",0,[1,2,5],"1a+22a+230a");
AGR.CHAR("M23","M23G1-p253bB0",0,[1,2,5],"1a+22a+230a");
AGR.CHAR("M23","M23G1-p40320B0",0,[1,3,4,6,7,8,9,[10,3],[11,3],[12,3],[13,3],[14,4],[15,4],[16,5],[17,8]],"1a+45ab+231abc+253a+770a^3b^3+896a^3b^3+990a^4b^4+1035a^5+2024a^8");
AGR.CHAR("M23","M23G1-p506B0",0,[1,2,5,9],"1a+22a+230a+253a");
AGR.CHAR("M24","M24G1-Zr23B0",0,2,"23a");
AGR.CHAR("M24","M24G1-f11r229B0",11,5,"229a");
AGR.CHAR("M24","M24G1-f11r23B0",11,2,"23a");
AGR.CHAR("M24","M24G1-f11r253B0",11,8,"253a");
AGR.CHAR("M24","M24G1-f11r45B0",11,3,"45a");
AGR.CHAR("M24","M24G1-f11r482B0",11,9,"482a");
AGR.CHAR("M24","M24G1-f11r806B0",11,12,"806a");
AGR.CHAR("M24","M24G1-f11r990bB0",11,14,"990b");
AGR.CHAR("M24","M24G1-f121r231bB0",11,7,"231b");
AGR.CHAR("M24","M24G1-f121r770aB0",11,10,"770a");
AGR.CHAR("M24","M24G1-f23r231bB0",23,6,"231b");
AGR.CHAR("M24","M24G1-f23r23B0",23,2,"23a");
AGR.CHAR("M24","M24G1-f23r251B0",23,7,"251a");
AGR.CHAR("M24","M24G1-f23r253B0",23,8,"253a");
AGR.CHAR("M24","M24G1-f23r45B0",23,3,"45a");
AGR.CHAR("M24","M24G1-f23r483B0",23,9,"483a");
AGR.CHAR("M24","M24G1-f23r770B0",23,10,"770a");
AGR.CHAR("M24","M24G1-f23r990bB0",23,12,"990b");
AGR.CHAR("M24","M24G1-f25r45aB0",5,3,"45a");
AGR.CHAR("M24","M24G1-f25r45bB0",5,4,"45b");
AGR.CHAR("M24","M24G1-f25r770aB0",5,8,"770a");
AGR.CHAR("M24","M24G1-f25r990aB0",5,10,"990a");
AGR.CHAR("M24","M24G1-f2r11aB0",2,2,"11a");
AGR.CHAR("M24","M24G1-f2r11bB0",2,3,"11b");
AGR.CHAR("M24","M24G1-f2r120B0",2,6,"120a");
AGR.CHAR("M24","M24G1-f2r1242B0",2,12,"1242a");
AGR.CHAR("M24","M24G1-f2r1792B0",2,13,"1792a");
AGR.CHAR("M24","M24G1-f2r220aB0",2,7,"220a");
AGR.CHAR("M24","M24G1-f2r220bB0",2,8,"220b");
AGR.CHAR("M24","M24G1-f2r252B0",2,9,"252a");
AGR.CHAR("M24","M24G1-f2r320aB0",2,10,"320a");
AGR.CHAR("M24","M24G1-f2r320bB0",2,11,"320b");
AGR.CHAR("M24","M24G1-f2r44aB0",2,4,"44a");
AGR.CHAR("M24","M24G1-f2r44bB0",2,5,"44b");
AGR.CHAR("M24","M24G1-f3r22B0",3,2,"22a");
AGR.CHAR("M24","M24G1-f3r231B0",3,5,"231a");
AGR.CHAR("M24","M24G1-f3r252B0",3,6,"252a");
AGR.CHAR("M24","M24G1-f3r483B0",3,7,"483a");
AGR.CHAR("M24","M24G1-f3r770aB0",3,8,"770a");
AGR.CHAR("M24","M24G1-f3r770bB0",3,9,"770b");
AGR.CHAR("M24","M24G1-f49r231bB0",7,5,"231b");
AGR.CHAR("M24","M24G1-f49r770aB0",7,9,"770a");
AGR.CHAR("M24","M24G1-f5r231B0",5,5,"231a");
AGR.CHAR("M24","M24G1-f5r23B0",5,2,"23a");
AGR.CHAR("M24","M24G1-f5r252B0",5,6,"252a");
AGR.CHAR("M24","M24G1-f5r253B0",5,7,"253a");
AGR.CHAR("M24","M24G1-f7r23B0",7,2,"23a");
AGR.CHAR("M24","M24G1-f7r252B0",7,6,"252a");
AGR.CHAR("M24","M24G1-f7r253B0",7,7,"253a");
AGR.CHAR("M24","M24G1-f7r45B0",7,3,"45a");
AGR.CHAR("M24","M24G1-f7r483B0",7,8,"483a");
AGR.CHAR("M24","M24G1-f7r990B0",7,11,"990a");
AGR.CHAR("M24","M24G1-f9r45aB0",3,3,"45a");
AGR.CHAR("M24","M24G1-f9r45bB0",3,4,"45b");
AGR.CHAR("M24","M24G1-f9r990bB0",3,11,"990b");
AGR.CHAR("M24","M24G1-p1288B0",0,[1,7,14],"1a+252a+1035a");
AGR.CHAR("M24","M24G1-p1771B0",0,[1,7,9,14],"1a+252a+483a+1035a");
AGR.CHAR("M24","M24G1-p2024B0",0,[1,2,7,9,17],"1a+23a+252a+483a+1265a");
AGR.CHAR("M24","M24G1-p24B0",0,[1,2],"1a+23a");
AGR.CHAR("M24","M24G1-p276B0",0,[1,2,7],"1a+23a+252a");
AGR.CHAR("M24","M24G1-p3795B0",0,[1,7,9,14,19],"1a+252a+483a+1035a+2024a");
AGR.CHAR("M24","M24G1-p759B0",0,[1,2,7,9],"1a+23a+252a+483a");
AGR.CHAR("McL","McLG1-Zr231B0",0,3,"231a");
AGR.CHAR("McL","McLG1-f11r22B0",11,2,"22a");
AGR.CHAR("McL","McLG1-f11r231B0",11,3,"231a");
AGR.CHAR("McL","McLG1-f11r251B0",11,4,"251a");
AGR.CHAR("McL","McLG1-f11r896B0",11,7,"896a");
AGR.CHAR("McL","McLG1-f121r770aB0",11,5,"770a");
AGR.CHAR("McL","McLG1-f121r770bB0",11,6,"770b");
AGR.CHAR("McL","McLG1-f23r896bB0",23,8,"896b");
AGR.CHAR("McL","McLG1-f25r1200aB0",5,8,"1200a");
AGR.CHAR("McL","McLG1-f2r22B0",2,2,"22a");
AGR.CHAR("McL","McLG1-f2r230B0",2,3,"230a");
AGR.CHAR("McL","McLG1-f2r748aB0",2,4,"748a");
AGR.CHAR("McL","McLG1-f2r748bB0",2,5,"748b");
AGR.CHAR("McL","McLG1-f3r104aB0",3,3,"104a");
AGR.CHAR("McL","McLG1-f3r104bB0",3,4,"104b");
AGR.CHAR("McL","McLG1-f3r210B0",3,5,"210a");
AGR.CHAR("McL","McLG1-f3r21B0",3,2,"21a");
AGR.CHAR("McL","McLG1-f3r560B0",3,6,"560a");
AGR.CHAR("McL","McLG1-f49r770aB0",7,5,"770a");
AGR.CHAR("McL","McLG1-f49r770bB0",7,6,"770b");
AGR.CHAR("McL","McLG1-f49r896aB0",7,7,"896a");
AGR.CHAR("McL","McLG1-f49r896bB0",7,8,"896b");
AGR.CHAR("McL","McLG1-f4r896aB0",2,6,"896a");
AGR.CHAR("McL","McLG1-f4r896bB0",2,7,"896b");
AGR.CHAR("McL","McLG1-f5r210B0",5,3,"210a");
AGR.CHAR("McL","McLG1-f5r21B0",5,2,"21a");
AGR.CHAR("McL","McLG1-f5r230B0",5,4,"230a");
AGR.CHAR("McL","McLG1-f5r560B0",5,5,"560a");
AGR.CHAR("McL","McLG1-f5r896bB0",5,7,"896b");
AGR.CHAR("McL","McLG1-f7r22B0",7,2,"22a");
AGR.CHAR("McL","McLG1-f7r231B0",7,3,"231a");
AGR.CHAR("McL","McLG1-f7r252B0",7,4,"252a");
AGR.CHAR("McL","McLG1-f9r605aB0",3,7,"605a");
AGR.CHAR("McL","McLG1-f9r605bB0",3,8,"605b");
AGR.CHAR("McL","McLG1-p113400B0",0,[1,2,[4,2],[9,3],[10,2],12,[14,2],18,19,[20,3],21,22,23,24],"1a+22a+252a^2+1750a^3+3520a^2+4500a+5103a^2+8250ab+9625a^3+9856ab+10395ab");
AGR.CHAR("McL","McLG1-p15400aB0",0,[1,4,12,14,15],"1a+252a+4500a+5103a+5544a");
AGR.CHAR("McL","McLG1-p15400bB0",0,[1,2,[4,2],9,10,12,14],"1a+22a+252a^2+1750a+3520a+4500a+5103a");
AGR.CHAR("McL","McLG1-p2025aB0",0,[1,2,4,9],"1a+22a+252a+1750a");
AGR.CHAR("McL","McLG1-p2025bB0",0,[1,2,4,9],"1a+22a+252a+1750a");
AGR.CHAR("McL","McLG1-p22275aB0",0,[1,2,[4,2],[9,2],10,14,20],"1a+22a+252a^2+1750a^2+3520a+5103a+9625a");
AGR.CHAR("McL","McLG1-p22275bB0",0,[1,4,9,14,15,20],"1a+252a+1750a+5103a+5544a+9625a");
AGR.CHAR("McL","McLG1-p22275cB0",0,[1,2,[4,2],[9,2],10,14,20],"1a+22a+252a^2+1750a^2+3520a+5103a+9625a");
AGR.CHAR("McL","McLG1-p22275dB0",0,[1,2,[4,2],[9,2],10,14,20],"1a+22a+252a^2+1750a^2+3520a+5103a+9625a");
AGR.CHAR("McL","McLG1-p275B0",0,[1,2,4],"1a+22a+252a");
AGR.CHAR("McL","McLG1-p299376B0",0,[1,4,7,8,9,10,[12,3],[13,2],[14,3],[15,2],[16,2],[17,2],[18,3],[19,3],[20,4],[21,2],[22,2],[23,4],[24,4]],"1a+252a+896ab+1750a+3520a+4500a^3+4752a^2+5103a^3+5544a^2+8019a^2b^2+8250a^3b^3+9625a^4+9856a^2b^2+10395a^4b^4");
AGR.CHAR("McL","McLG1-p7128B0",0,[1,2,4,9,14],"1a+22a+252a+1750a+5103a");
AGR.CHAR("McL.2","McLd2G1-f11r22aB0",11,3);
AGR.CHAR("McL.2","McLd2G1-f11r231aB0",11,5);
AGR.CHAR("McL.2","McLd2G1-f11r251aB0",11,7);
AGR.CHAR("McL.2","McLd2G1-f11r896aB0",11,10);
AGR.CHAR("McL.2","McLd2G1-f2r1496aB0",2,4);
AGR.CHAR("McL.2","McLd2G1-f2r22B0",2,2);
AGR.CHAR("McL.2","McLd2G1-f2r230aB0",2,3);
AGR.CHAR("McL.2","McLd2G1-f3r104aB0",3,5);
AGR.CHAR("McL.2","McLd2G1-f3r104bB0",3,7);
AGR.CHAR("McL.2","McLd2G1-f3r210aB0",3,9);
AGR.CHAR("McL.2","McLd2G1-f3r21aB0",3,3);
AGR.CHAR("McL.2","McLd2G1-f3r560aB0",3,11);
AGR.CHAR("McL.2","McLd2G1-f49r896aB0",7,10);
AGR.CHAR("McL.2","McLd2G1-f5r210aB0",5,5);
AGR.CHAR("McL.2","McLd2G1-f5r21aB0",5,3);
AGR.CHAR("McL.2","McLd2G1-f5r230aB0",5,7);
AGR.CHAR("McL.2","McLd2G1-f5r560aB0",5,9);
AGR.CHAR("McL.2","McLd2G1-f5r896aB0",5,11);
AGR.CHAR("McL.2","McLd2G1-f5r896bB0",5,13);
AGR.CHAR("McL.2","McLd2G1-f7r22aB0",7,3);
AGR.CHAR("McL.2","McLd2G1-f7r231aB0",7,5);
AGR.CHAR("McL.2","McLd2G1-f7r252aB0",7,7);
AGR.CHAR("McL.2","McLd2G1-p22275aB0",0,[1,3,[7,2],14,15,16,24,30]);
AGR.CHAR("McL.2","McLd2G1-p275B0",0,[1,3,7]);
AGR.CHAR("McL.2","McLd2G1-p4050B0",0,[1,2,3,4,7,8,14,15]);
AGR.CHAR("McL.2","McLd2G1-p44550B0",0,[1,2,3,4,[7,2],[8,2],[14,2],[15,2],16,17,24,25,30,31]);
AGR.CHAR("McL.2","McLd2G1-p7128B0",0,[1,4,7,14,24]);
AGR.CHAR("O8-(2)","O8m2G1-Zr204aB0",0,5,"204a");
AGR.CHAR("O8-(2)","O8m2G1-Zr204bB0",0,6,"204b");
AGR.CHAR("O8-(2)","O8m2G1-Zr34B0",0,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-Zr51B0",0,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-Zr84B0",0,4,"84a");
AGR.CHAR("O8-(2)","O8m2G1-f17r34B0",17,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-f17r51B0",17,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-f17r83B0",17,4,"83a");
AGR.CHAR("O8-(2)","O8m2G1-f2r26B0",2,5,"26a");
AGR.CHAR("O8-(2)","O8m2G1-f2r48B0",2,6,"48a");
AGR.CHAR("O8-(2)","O8m2G1-f2r8B0",2,2,"8a");
AGR.CHAR("O8-(2)","O8m2G1-f3r34B0",3,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-f3r50B0",3,3,"50a");
AGR.CHAR("O8-(2)","O8m2G1-f4r48bB0",2,7,"48b");
AGR.CHAR("O8-(2)","O8m2G1-f4r48cB0",2,8,"48c");
AGR.CHAR("O8-(2)","O8m2G1-f4r8bB0",2,3,"8b");
AGR.CHAR("O8-(2)","O8m2G1-f4r8cB0",2,4,"8c");
AGR.CHAR("O8-(2)","O8m2G1-f5r34B0",5,2,"34a");
AGR.CHAR("O8-(2)","O8m2G1-f5r51B0",5,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-f5r84B0",5,4,"84a");
AGR.CHAR("O8-(2)","O8m2G1-f7r33B0",7,2,"33a");
AGR.CHAR("O8-(2)","O8m2G1-f7r51B0",7,3,"51a");
AGR.CHAR("O8-(2)","O8m2G1-f7r84B0",7,4,"84a");
AGR.CHAR("O8-(2)","O8m2G1-p1071B0",0,[1,2,4,8,9],"1a+34a+84a+476ab");
AGR.CHAR("O8-(2)","O8m2G1-p119B0",0,[1,2,4],"1a+34a+84a");
AGR.CHAR("O8-(2)","O8m2G1-p136B0",0,[1,3,4],"1a+51a+84a");
AGR.CHAR("O8-(2)","O8m2G1-p1632B0",0,[1,3,4,8,13],"1a+51a+84a+476a+1020a");
AGR.CHAR("O8-(2)","O8m2G1-p24192B0",0,[1,2,3,8,9,10,11,12,13,14,23,24,33,34,37,38],"1a+34a+51a+476ab+595a+714ab+1020a+1071a+2142cd+2856ab+4284a+4760a");
AGR.CHAR("O8-(2)","O8m2G1-p45696B0",0,[1,2,3,[4,2],[8,2],[9,2],10,11,12,[13,3],14,[19,2],23,24,25,[33,2],34,[35,2],36,37,38],"1a+34a+51a+84a^2+476a^2b^2+595a+714ab+1020a^3+1071a+1344a^2+2142cd+2176a+2856a^2b+3264a^2+4096a+4284a+4760a");
AGR.CHAR("O8-(2)","O8m2G1-p765B0",0,[1,4,6,8],"1a+84a+204b+476a");
AGR.CHAR("O8-(2).2","O8m2d2G1-f3r34B0",3,3);
AGR.CHAR("O8-(2).2","O8m2d2G1-f3r50B0",3,5);
AGR.CHAR("O8-(2).2","O8m2d2G1-p119B0",0,[1,3,7]);
AGR.CHAR("ON","ONG1-f3r495B0",3,6,"495b");
AGR.CHAR("ON","ONG1-f3r684B0",3,[3,4],"342ab");
AGR.CHAR("ON","ONG1-p122760aB0",0,[1,2,7,9,11],"1a+10944a+26752a+32395b+52668a");
AGR.CHAR("R(27)","R27G1-f27r7aB0",3,2,"7a");
AGR.CHAR("R(27)","R27G1-f2r702B0",2,2,"702a");
AGR.CHAR("R(27)","R27G1-p19684B0",0,[1,20],"1a+19683a");
AGR.CHAR("R(27).3","R27d3G1-f2r702B0",2,4);
AGR.CHAR("R(27).3","R27d3G1-f3r21B0",3,2);
AGR.CHAR("R(27).3","R27d3G1-f4r741B0",2,12);
AGR.CHAR("R(27).3","R27d3G1-p19684B0",0,[1,34]);
AGR.CHAR("Ru","RuG1-f13r378B0",13,2,"378a");
AGR.CHAR("Ru","RuG1-f13r406B0",13,4,"406a");
AGR.CHAR("Ru","RuG1-f13r783B0",13,5,"783a");
AGR.CHAR("Ru","RuG1-f29r378B0",29,3,"378b");
AGR.CHAR("Ru","RuG1-f29r406B0",29,4,"406a");
AGR.CHAR("Ru","RuG1-f29r783B0",29,5,"783a");
AGR.CHAR("Ru","RuG1-f2r1246B0",2,4,"1246a");
AGR.CHAR("Ru","RuG1-f2r28B0",2,2,"28a");
AGR.CHAR("Ru","RuG1-f2r376B0",2,3,"376a");
AGR.CHAR("Ru","RuG1-f3r406B0",3,4,"406a");
AGR.CHAR("Ru","RuG1-f3r783B0",3,5,"783a");
AGR.CHAR("Ru","RuG1-f49r378B0",7,2,"378a");
AGR.CHAR("Ru","RuG1-f5r133B0",5,2,"133a");
AGR.CHAR("Ru","RuG1-f5r273B0",5,3,"273a");
AGR.CHAR("Ru","RuG1-f5r378B0",5,4,"378a");
AGR.CHAR("Ru","RuG1-f5r783B0",5,6,"783a");
AGR.CHAR("Ru","RuG1-f7r406B0",7,4,"406a");
AGR.CHAR("Ru","RuG1-f7r782B0",7,5,"782a");
AGR.CHAR("Ru","RuG1-f9r378B0",3,3,"378b");
AGR.CHAR("Ru","RuG1-p4060B0",0,[1,5,6],"1a+783a+3276a");
AGR.CHAR("S6(2)","S62G1-Zr105aB0",0,12,"105a");
AGR.CHAR("S6(2)","S62G1-Zr105bB0",0,13,"105b");
AGR.CHAR("S6(2)","S62G1-Zr105cB0",0,14,"105c");
AGR.CHAR("S6(2)","S62G1-Zr120B0",0,15,"120a");
AGR.CHAR("S6(2)","S62G1-Zr15B0",0,3,"15a");
AGR.CHAR("S6(2)","S62G1-Zr168B0",0,16,"168a");
AGR.CHAR("S6(2)","S62G1-Zr189aB0",0,17,"189a");
AGR.CHAR("S6(2)","S62G1-Zr189bB0",0,18,"189b");
AGR.CHAR("S6(2)","S62G1-Zr189cB0",0,19,"189c");
AGR.CHAR("S6(2)","S62G1-Zr210aB0",0,20,"210a");
AGR.CHAR("S6(2)","S62G1-Zr210bB0",0,21,"210b");
AGR.CHAR("S6(2)","S62G1-Zr216B0",0,22,"216a");
AGR.CHAR("S6(2)","S62G1-Zr21aB0",0,4,"21a");
AGR.CHAR("S6(2)","S62G1-Zr21bB0",0,5,"21b");
AGR.CHAR("S6(2)","S62G1-Zr27B0",0,6,"27a");
AGR.CHAR("S6(2)","S62G1-Zr35aB0",0,7,"35a");
AGR.CHAR("S6(2)","S62G1-Zr35bB0",0,8,"35b");
AGR.CHAR("S6(2)","S62G1-Zr56B0",0,9,"56a");
AGR.CHAR("S6(2)","S62G1-Zr70B0",0,10,"70a");
AGR.CHAR("S6(2)","S62G1-Zr7B0",0,2,"7a");
AGR.CHAR("S6(2)","S62G1-Zr84B0",0,11,"84a");
AGR.CHAR("S6(2)","S62G1-f2r112B0",2,7,"112a");
AGR.CHAR("S6(2)","S62G1-f2r14B0",2,4,"14a");
AGR.CHAR("S6(2)","S62G1-f2r48B0",2,5,"48a");
AGR.CHAR("S6(2)","S62G1-f2r512B0",2,8,"512a");
AGR.CHAR("S6(2)","S62G1-f2r64B0",2,6,"64a");
AGR.CHAR("S6(2)","S62G1-f2r6B0",2,2,"6a");
AGR.CHAR("S6(2)","S62G1-f2r8B0",2,3,"8a");
AGR.CHAR("S6(2)","S62G1-f3r14B0",3,3,"14a");
AGR.CHAR("S6(2)","S62G1-f3r189aB0",3,11,"189a");
AGR.CHAR("S6(2)","S62G1-f3r189bB0",3,12,"189b");
AGR.CHAR("S6(2)","S62G1-f3r189cB0",3,13,"189c");
AGR.CHAR("S6(2)","S62G1-f3r196B0",3,14,"196a");
AGR.CHAR("S6(2)","S62G1-f3r21B0",3,4,"21a");
AGR.CHAR("S6(2)","S62G1-f3r27B0",3,5,"27a");
AGR.CHAR("S6(2)","S62G1-f3r34B0",3,6,"34a");
AGR.CHAR("S6(2)","S62G1-f3r35B0",3,7,"35a");
AGR.CHAR("S6(2)","S62G1-f3r405B0",3,15,"405a");
AGR.CHAR("S6(2)","S62G1-f3r49B0",3,8,"49a");
AGR.CHAR("S6(2)","S62G1-f3r7B0",3,2,"7a");
AGR.CHAR("S6(2)","S62G1-f3r91B0",3,9,"91a");
AGR.CHAR("S6(2)","S62G1-f3r98B0",3,10,"98a");
AGR.CHAR("S6(2)","S62G1-p120B0",0,[1,7,11],"1a+35a+84a");
AGR.CHAR("S6(2)","S62G1-p126B0",0,[1,2,6,8,9],"1a+7a+27a+35b+56a");
AGR.CHAR("S6(2)","S62G1-p135B0",0,[1,3,8,11],"1a+15a+35b+84a");
AGR.CHAR("S6(2)","S62G1-p240B0",0,[1,3,7,11,14],"1a+15a+35a+84a+105c");
AGR.CHAR("S6(2)","S62G1-p288B0",0,[1,6,8,13,15],"1a+27a+35b+105b+120a");
AGR.CHAR("S6(2)","S62G1-p28B0",0,[1,6],"1a+27a");
AGR.CHAR("S6(2)","S62G1-p315B0",0,[1,6,8,11,16],"1a+27a+35b+84a+168a");
AGR.CHAR("S6(2)","S62G1-p336B0",0,[1,6,8,13,16],"1a+27a+35b+105b+168a");
AGR.CHAR("S6(2)","S62G1-p36B0",0,[1,8],"1a+35b");
AGR.CHAR("S6(2)","S62G1-p378aB0",0,[1,[6,2],8,15,16],"1a+27a^2+35b+120a+168a");
AGR.CHAR("S6(2)","S62G1-p378bB0",0,[1,3,6,8,11,22],"1a+15a+27a+35b+84a+216a");
AGR.CHAR("S6(2)","S62G1-p56B0",0,[1,2,5,6],"1a+7a+21b+27a");
AGR.CHAR("S6(2)","S62G1-p63B0",0,[1,6,8],"1a+27a+35b");
AGR.CHAR("S6(2)","S62G1-p72B0",0,[1,3,5,8],"1a+15a+21b+35b");
AGR.CHAR("S6(2)","S62G1-p960B0",0,[1,10,11,13,23,29],"1a+70a+84a+105b+280a+420a");
AGR.CHAR("Suz","SuzG1-Zr143B0",0,2,"143a");
AGR.CHAR("Suz","SuzG1-f11r143B0",11,2,"143a");
AGR.CHAR("Suz","SuzG1-f11r364B0",11,3,"364a");
AGR.CHAR("Suz","SuzG1-f11r779B0",11,4,"779a");
AGR.CHAR("Suz","SuzG1-f13r143B0",13,2,"143a");
AGR.CHAR("Suz","SuzG1-f13r364B0",13,3,"364a");
AGR.CHAR("Suz","SuzG1-f13r780B0",13,4,"780a");
AGR.CHAR("Suz","SuzG1-f2r142B0",2,4,"142a");
AGR.CHAR("Suz","SuzG1-f2r638B0",2,7,"638a");
AGR.CHAR("Suz","SuzG1-f3r286B0",3,4,"286a");
AGR.CHAR("Suz","SuzG1-f3r429B0",3,5,"429a");
AGR.CHAR("Suz","SuzG1-f3r649B0",3,6,"649a");
AGR.CHAR("Suz","SuzG1-f3r64B0",3,2,"64a");
AGR.CHAR("Suz","SuzG1-f3r78B0",3,3,"78a");
AGR.CHAR("Suz","SuzG1-f5r143B0",5,2,"143a");
AGR.CHAR("Suz","SuzG1-f5r363B0",5,3,"363a");
AGR.CHAR("Suz","SuzG1-f5r780B0",5,4,"780a");
AGR.CHAR("Suz","SuzG1-f7r143B0",7,2,"143a");
AGR.CHAR("Suz","SuzG1-f7r364B0",7,3,"364a");
AGR.CHAR("Suz","SuzG1-f7r780B0",7,4,"780a");
AGR.CHAR("Suz","SuzG1-p135135B0",0,[1,2,4,6,9,12,16,17,27],"1a+143a+780a+3432a+5940a+14300a+18954a+25025a+66560a");
AGR.CHAR("Suz","SuzG1-p1782B0",0,[1,4,5],"1a+780a+1001a");
AGR.CHAR("Suz","SuzG1-p22880B0",0,[1,3,4,9,15],"1a+364a+780a+5940a+15795a");
AGR.CHAR("Suz","SuzG1-p232960B0",0,[1,[3,2],9,11,12,13,14,15,23,33],"1a+364a^2+5940a+12012a+14300a+15015ab+15795a+54054a+100100a");
AGR.CHAR("Suz","SuzG1-p32760B0",0,[1,2,3,9,11,12],"1a+143a+364a+5940a+12012a+14300a");
AGR.CHAR("Suz","SuzG1-p370656B0",0,[1,[4,2],5,6,9,15,16,17,24,27,29,30],"1a+780a^2+1001a+3432a+5940a+15795a+18954a+25025a+64064a+66560a+79872a+88452a");
AGR.CHAR("Suz","SuzG1-p405405B0",0,[1,3,4,5,9,11,12,15,17,27,28,30,33],"1a+364a+780a+1001a+5940a+12012a+14300a+15795a+25025a+66560a+75075a+88452a+100100a");
AGR.CHAR("Sz(32)","Sz32G1-f41r124bB0",41,3,"124b");
AGR.CHAR("Sz(32)","Sz32G1-f5r124aB0",5,2,"124a");
AGR.CHAR("Sz(32)","Sz32G1-p1025B0",0,[1,14],"1a+1024a");
AGR.CHAR("Sz(32)","Sz32G1-p198400B0",0,[1,[4,6],[5,6],[6,6],[7,6],[8,6],[9,6],[10,6],[11,6],[12,6],[13,6],[14,6],[15,7],[16,7],[17,7],[18,7],[19,7],[20,7],[21,7],[22,7],[23,7],[24,7],[25,7],[26,7],[27,7],[28,7],[29,7],[30,5],[31,5],[32,5],[33,5],[34,5],[35,5]],"1a+775a^6b^6c^6d^6e^6f^6g^6h^6i^6j^6+1024a^6+1025a^7b^7c^7d^7e^7f^7g^7h^7i^7j^7k^7l^7m^7n^7o^7+1271a^5b^5c^5d^5e^5f^5");
AGR.CHAR("Sz(8)","Sz8G1-Ar14aB0",0,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-Ar14bB0",0,3,"14b");
AGR.CHAR("Sz(8)","Sz8G1-Ar65aB0",0,8,"65a");
AGR.CHAR("Sz(8)","Sz8G1-Ar65bB0",0,9,"65b");
AGR.CHAR("Sz(8)","Sz8G1-Ar65cB0",0,10,"65c");
AGR.CHAR("Sz(8)","Sz8G1-Zr64B0",0,7,"64a");
AGR.CHAR("Sz(8)","Sz8G1-Zr91B0",0,11,"91a");
AGR.CHAR("Sz(8)","Sz8G1-f125r65aB0",5,8,"65a");
AGR.CHAR("Sz(8)","Sz8G1-f125r65bB0",5,10,"65c");
AGR.CHAR("Sz(8)","Sz8G1-f125r65cB0",5,9,"65b");
AGR.CHAR("Sz(8)","Sz8G1-f13r14aB0",13,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-f13r14bB0",13,3,"14b");
AGR.CHAR("Sz(8)","Sz8G1-f13r35B0",13,4,"35a");
AGR.CHAR("Sz(8)","Sz8G1-f13r65aB0",13,5,"65a");
AGR.CHAR("Sz(8)","Sz8G1-f13r65bB0",13,6,"65b");
AGR.CHAR("Sz(8)","Sz8G1-f13r65cB0",13,7,"65c");
AGR.CHAR("Sz(8)","Sz8G1-f13r91B0",13,8,"91a");
AGR.CHAR("Sz(8)","Sz8G1-f2r64B0",2,8,"64a");
AGR.CHAR("Sz(8)","Sz8G1-f49r14aB0",7,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-f5r14aB0",5,2,"14a");
AGR.CHAR("Sz(8)","Sz8G1-f5r14bB0",5,3,"14b");
AGR.CHAR("Sz(8)","Sz8G1-f5r195B0",5,[8,9,10],"65abc");
AGR.CHAR("Sz(8)","Sz8G1-f5r35aB0",5,4,"35a");
AGR.CHAR("Sz(8)","Sz8G1-f5r35bB0",5,5,"35b");
AGR.CHAR("Sz(8)","Sz8G1-f5r35cB0",5,6,"35c");
AGR.CHAR("Sz(8)","Sz8G1-f5r63B0",5,7,"63a");
AGR.CHAR("Sz(8)","Sz8G1-f7r105B0",7,[4,5,6],"35abc");
AGR.CHAR("Sz(8)","Sz8G1-f7r64B0",7,7,"64a");
AGR.CHAR("Sz(8)","Sz8G1-f7r91B0",7,8,"91a");
AGR.CHAR("Sz(8)","Sz8G1-f8r16aB0",2,5,"16a");
AGR.CHAR("Sz(8)","Sz8G1-f8r4aB0",2,2,"4a");
AGR.CHAR("Sz(8)","Sz8G1-p1456B0",0,[1,[4,2],[5,2],[6,2],[7,3],[8,4],[9,4],[10,4],[11,3]],"1a+35a^2b^2c^2+64a^3+65a^4b^4c^4+91a^3");
AGR.CHAR("Sz(8)","Sz8G1-p2080B0",0,[1,[4,4],[5,4],[6,4],[7,5],[8,5],[9,5],[10,5],[11,4]],"1a+35a^4b^4c^4+64a^5+65a^5b^5c^5+91a^4");
AGR.CHAR("Sz(8)","Sz8G1-p520B0",0,[1,4,5,6,[7,2],8,9,10,11],"1a+35abc+64a^2+65abc+91a");
AGR.CHAR("Sz(8)","Sz8G1-p560B0",0,[1,4,5,6,7,[8,2],[9,2],[10,2]],"1a+35abc+64a+65a^2b^2c^2");
AGR.CHAR("Sz(8)","Sz8G1-p65B0",0,[1,7],"1a+64a");
AGR.CHAR("Sz(8).3","Sz8d3G1-f13r14B0",13,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f2r12B0",2,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f2r48B0",2,5);
AGR.CHAR("Sz(8).3","Sz8d3G1-f2r64B0",2,6);
AGR.CHAR("Sz(8).3","Sz8d3G1-f49r14B0",7,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r105B0",5,10);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r14B0",5,4);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r195B0",5,14);
AGR.CHAR("Sz(8).3","Sz8d3G1-f5r63B0",5,11);
AGR.CHAR("Sz(8).3","Sz8d3G1-p1456B0",0,[1,[10,2],11,12,13,[14,4],15,16,17]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p2080B0",0,[1,[10,4],[11,3],12,13,[14,5],[15,2],16,17]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p520B0",0,[1,10,[11,2],14,15]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p560B0",0,[1,10,11,[14,2]]);
AGR.CHAR("Sz(8).3","Sz8d3G1-p65B0",0,[1,11]);
AGR.CHAR("Th","ThG1-f13r248B0",13,2,"248a");
AGR.CHAR("U4(2)","U42G1-Ar10B0",0,5,"10a");
AGR.CHAR("U4(2)","U42G1-Ar10aB0",0,5,"10a");
AGR.CHAR("U4(2)","U42G1-Ar10bB0",0,6,"10b");
AGR.CHAR("U4(2)","U42G1-Ar30bB0",0,12,"30b");
AGR.CHAR("U4(2)","U42G1-Ar30cB0",0,13,"30c");
AGR.CHAR("U4(2)","U42G1-Ar40aB0",0,14,"40a");
AGR.CHAR("U4(2)","U42G1-Ar40bB0",0,15,"40b");
AGR.CHAR("U4(2)","U42G1-Ar45aB0",0,16,"45a");
AGR.CHAR("U4(2)","U42G1-Ar45bB0",0,17,"45b");
AGR.CHAR("U4(2)","U42G1-Ar5aB0",0,2,"5a");
AGR.CHAR("U4(2)","U42G1-Ar5bB0",0,3,"5b");
AGR.CHAR("U4(2)","U42G1-Zr15aB0",0,7,"15a");
AGR.CHAR("U4(2)","U42G1-Zr15bB0",0,8,"15b");
AGR.CHAR("U4(2)","U42G1-Zr20B0",0,9,"20a");
AGR.CHAR("U4(2)","U42G1-Zr24B0",0,10,"24a");
AGR.CHAR("U4(2)","U42G1-Zr30aB0",0,11,"30a");
AGR.CHAR("U4(2)","U42G1-Zr60B0",0,18,"60a");
AGR.CHAR("U4(2)","U42G1-Zr64B0",0,19,"64a");
AGR.CHAR("U4(2)","U42G1-Zr6B0",0,4,"6a");
AGR.CHAR("U4(2)","U42G1-Zr80B0",0,[14,15],"40ab");
AGR.CHAR("U4(2)","U42G1-Zr81B0",0,20,"81a");
AGR.CHAR("U4(2)","U42G1-f25r10bB0",5,6,"10b");
AGR.CHAR("U4(2)","U42G1-f25r5aB0",5,2,"5a");
AGR.CHAR("U4(2)","U42G1-f3r10B0",3,3,"10a");
AGR.CHAR("U4(2)","U42G1-f3r14B0",3,4,"14a");
AGR.CHAR("U4(2)","U42G1-f3r25B0",3,5,"25a");
AGR.CHAR("U4(2)","U42G1-f3r5B0",3,2,"5a");
AGR.CHAR("U4(2)","U42G1-f3r81B0",3,6,"81a");
AGR.CHAR("U4(2)","U42G1-f4r4aB0",2,2,"4a");
AGR.CHAR("U4(2)","U42G1-f5r6B0",5,4,"6a");
AGR.CHAR("U4(2)","U42G1-p27B0",0,[1,4,9],"1a+6a+20a");
AGR.CHAR("U4(2)","U42G1-p36B0",0,[1,8,9],"1a+15b+20a");
AGR.CHAR("U4(2)","U42G1-p40aB0",0,[1,7,10],"1a+15a+24a");
AGR.CHAR("U4(2)","U42G1-p40bB0",0,[1,8,10],"1a+15b+24a");
AGR.CHAR("U4(2)","U42G1-p45B0",0,[1,9,10],"1a+20a+24a");
AGR.CHAR("U4(2).2","U42d2G1-f2r14B0",2,4);
AGR.CHAR("U4(2).2","U42d2G1-f2r40B0",2,5);
AGR.CHAR("U4(2).2","U42d2G1-f2r64B0",2,6);
AGR.CHAR("U4(2).2","U42d2G1-f2r6B0",2,3);
AGR.CHAR("U4(2).2","U42d2G1-f2r8B0",2,2);
AGR.CHAR("U4(2).2","U42d2G1-f3r5B0",3,3);
AGR.CHAR("U4(2).2","U42d2G1-p27B0",0,[1,4,11]);
AGR.CHAR("U4(2).2","U42d2G1-p36B0",0,[1,9,11]);
AGR.CHAR("U4(2).2","U42d2G1-p40aB0",0,[1,8,13]);
AGR.CHAR("U4(2).2","U42d2G1-p40bB0",0,[1,9,13]);
AGR.CHAR("U4(2).2","U42d2G1-p45B0",0,[1,11,13]);
AGR.CHAR("U5(2)","U52G1-Ar66aB0",0,9,"66a");
AGR.CHAR("U5(2)","U52G1-Ar66bB0",0,10,"66b");
AGR.CHAR("U5(2)","U52G1-Zr120B0",0,16,"120a");
AGR.CHAR("U5(2)","U52G1-Zr165B0",0,17,"165a");
AGR.CHAR("U5(2)","U52G1-Zr176B0",0,18,"176a");
AGR.CHAR("U5(2)","U52G1-Zr55B0",0,6,"55a");
AGR.CHAR("U5(2)","U52G1-f11r119B0",11,16,"119a");
AGR.CHAR("U5(2)","U52G1-f11r176B0",11,18,"176a");
AGR.CHAR("U5(2)","U52G1-f11r44B0",11,5,"44a");
AGR.CHAR("U5(2)","U52G1-f2r24B0",2,6,"24a");
AGR.CHAR("U5(2)","U52G1-f2r74B0",2,11,"74a");
AGR.CHAR("U5(2)","U52G1-f3r100B0",3,5,"100a");
AGR.CHAR("U5(2)","U52G1-f3r10B0",3,2,"10a");
AGR.CHAR("U5(2)","U52G1-f3r110B0",3,6,"110a");
AGR.CHAR("U5(2)","U52G1-f3r44B0",3,3,"44a");
AGR.CHAR("U5(2)","U52G1-f3r55B0",3,4,"55a");
AGR.CHAR("U5(2)","U52G1-f4r10aB0",2,4,"10a");
AGR.CHAR("U5(2)","U52G1-f4r10bB0",2,5,"10b");
AGR.CHAR("U5(2)","U52G1-f4r5aB0",2,2,"5a");
AGR.CHAR("U5(2)","U52G1-f4r5bB0",2,3,"5b");
AGR.CHAR("U5(2)","U52G1-f5r120B0",5,16,"120a");
AGR.CHAR("U5(2)","U52G1-f5r176B0",5,18,"176a");
AGR.CHAR("U5(2)","U52G1-f5r43B0",5,5,"43a");
AGR.CHAR("U5(2)","U52G1-f5r55aB0",5,6,"55a");
AGR.CHAR("U5(2)","U52G1-p1408B0",0,[1,6,9,10,16,28,35],"1a+55a+66ab+120a+440a+660a");
AGR.CHAR("U5(2)","U52G1-p165B0",0,[1,5,16],"1a+44a+120a");
AGR.CHAR("U5(2)","U52G1-p176B0",0,[1,6,16],"1a+55a+120a");
AGR.CHAR("U5(2)","U52G1-p20736B0",0,[1,3,4,6,[9,2],[10,2],14,15,16,[18,3],[21,2],[22,2],28,29,30,[31,2],[32,2],[35,3],36,37,[38,2],[39,2],[43,2],[44,2],[45,2],46,47],"1a+11ab+55a+66a^2b^2+110de+120a+176a^3+220c^2d^2+440abc+495a^2b^2+660a^3+704ab+880a^2b^2+990a^2b^2+1024a^2+1215ab");
AGR.CHAR("U5(2)","U52G1-p297B0",0,[1,16,18],"1a+120a+176a");
AGR.CHAR("U5(2)","U52G1-p3520B0",0,[1,5,6,[16,2],17,28,35,40,45],"1a+44a+55a+120a^2+165a+440a+660a+891a+1024a");
AGR.CHAR("U5(2).2","U52d2G1-f2r1024B0",2,10);
AGR.CHAR("U5(2).2","U52d2G1-f2r10B0",2,2);
AGR.CHAR("U5(2).2","U52d2G1-f2r20B0",2,3);
AGR.CHAR("U5(2).2","U52d2G1-f2r24B0",2,4);
AGR.CHAR("U5(2).2","U52d2G1-f2r320B0",2,8);
AGR.CHAR("U5(2).2","U52d2G1-f2r560B0",2,9);
AGR.CHAR("U5(2).2","U52d2G1-f2r74B0",2,7);
AGR.CHAR("U5(2).2","U52d2G1-f2r80aB0",2,5);
AGR.CHAR("U5(2).2","U52d2G1-f2r80bB0",2,6);
AGR.CHAR("U5(2).2","U52d2G1-f3r10aB0",3,4);
AGR.CHAR("U5(2).2","U52d2G1-p1408B0",0,[1,8,11,16,28,33]);
AGR.CHAR("U5(2).2","U52d2G1-p165B0",0,[1,6,16]);
AGR.CHAR("U5(2).2","U52d2G1-p176B0",0,[1,8,16]);
AGR.CHAR("U5(2).2","U52d2G1-p20736B0",0,[1,5,8,[11,2],15,16,[20,2],21,[23,2],28,30,[31,2],[33,2],34,35,[36,2],[40,2],[41,2],43]);
AGR.CHAR("U5(2).2","U52d2G1-p297B0",0,[1,16,20]);
AGR.CHAR("U5(2).2","U52d2G1-p3520B0",0,[1,6,8,[16,2],18,28,33,37,41]);


AtlasOfGroupRepresentationsInfo.TableOfContents.( "remote" ).lastupdated:=
  "14-Jan-2009, 16:31:24.000 UTC";

#############################################################################
##
#E

