#############################################################################
#0
#F	HomotopyTuple
##	
InstallGlobalFunction(HomotopyTuple, function(C)
local
	s,t,Kers,Kert,
	A,G,AG,Nat,AutA,
	GensA,GensG,GensAutA,alpha,phi;
	
	s:=C!.sourceMap;
	t:=C!.targetMap;
	Kers:=Kernel(s);
	Kert:=Kernel(t);
	
	Nat:=NaturalHomomorphismByNormalSubgroup(Image(s),Image(t,Kers));
	A:=Intersection(Kers,Kert);
	G:=Range(Nat);
	AutA:=AutomorphismGroup(A);
	GensA:=GeneratorsOfGroup(A);
	GensG:=GeneratorsOfGroup(G);
	GensAutA:=GeneratorsOfGroup(AutA);
	
	#################################################################
	##
	alpha:=function(g,a)
	local x;
		
		x:=PreImagesRepresentative(Nat,g);
		return x^(-1)*a*x;
	end;
	##
	#################################################################
	
	phi:= GroupHomomorphismByImages(G,AutA,GensG,List(GensG,g->
			GroupHomomorphismByImages(A,A,GensA,List(GensA,a->alpha(g,a)))));
	AG:=SemidirectProduct(G,phi,A);
	return [IdGroup(G),AbelianInvariants(A),IdGroup(AG)];
end);
##
################### end of HomotopyTuple ####################################

#############################################################################
##
#F	IdQuasiCatOneGroup
##	
InstallGlobalFunction(IdQuasiCatOneGroup, function(C)
local 
	D,n,k,HomoTuple;
	
	HomoTuple:=[ [ [ [ 1, 1 ], [  ], [ 1, 1 ] ] ], [ [ [ 2, 1 ], [  ], [ 2, 1 ] ], [ [ 1, 1 ], [ 2 ], [ 2, 1 ] ] ], [ [ [ 3, 1 ], [  ], [ 3, 1 ] ], [ [ 1, 1 ], [ 3 ], [ 3, 1 ] ] ],
	[ [ [ 4, 1 ], [  ], [ 4, 1 ] ], [ [ 1, 1 ], [ 4 ], [ 4, 1 ] ], [ [ 4, 2 ], [  ], [ 4, 2 ] ], [ [ 2, 1 ], [ 2 ], [ 4, 2 ] ], [ [ 1, 1 ], [ 2, 2 ], [ 4, 2 ] ] ],
	[ [ [ 5, 1 ], [  ], [ 5, 1 ] ], [ [ 1, 1 ], [ 5 ], [ 5, 1 ] ] ], [ [ [ 6, 1 ], [  ], [ 6, 1 ] ], [ [ 2, 1 ], [ 3 ], [ 6, 1 ] ], [ [ 6, 2 ], [  ], [ 6, 2 ] ],
	[ [ 3, 1 ], [ 2 ], [ 6, 2 ] ], [ [ 2, 1 ], [ 3 ], [ 6, 2 ] ], [ [ 1, 1 ], [ 2, 3 ], [ 6, 2 ] ] ], [ [ [ 7, 1 ], [  ], [ 7, 1 ] ], [ [ 1, 1 ], [ 7 ], [ 7, 1 ] ] ],
	[ [ [ 8, 1 ], [  ], [ 8, 1 ] ], [ [ 1, 1 ], [ 8 ], [ 8, 1 ] ], [ [ 8, 2 ], [  ], [ 8, 2 ] ], [ [ 4, 1 ], [ 2 ], [ 8, 2 ] ], [ [ 2, 1 ], [ 4 ], [ 8, 2 ] ],
	[ [ 1, 1 ], [ 2, 4 ], [ 8, 2 ] ], [ [ 8, 3 ], [  ], [ 8, 3 ] ], [ [ 2, 1 ], [ 2, 2 ], [ 8, 3 ] ], [ [ 2, 1 ], [ 4 ], [ 8, 3 ] ], [ [ 8, 4 ], [  ], [ 8, 4 ] ],
	[ [ 8, 5 ], [  ], [ 8, 5 ] ], [ [ 4, 2 ], [ 2 ], [ 8, 5 ] ], [ [ 2, 1 ], [ 2, 2 ], [ 8, 5 ] ], [ [ 1, 1 ], [ 2, 2, 2 ], [ 8, 5 ] ] ],
	[ [ [ 9, 1 ], [  ], [ 9, 1 ] ], [ [ 1, 1 ], [ 9 ], [ 9, 1 ] ], [ [ 9, 2 ], [  ], [ 9, 2 ] ], [ [ 3, 1 ], [ 3 ], [ 9, 2 ] ], [ [ 1, 1 ], [ 3, 3 ], [ 9, 2 ] ] ],
	[ [ [ 10, 1 ], [  ], [ 10, 1 ] ], [ [ 2, 1 ], [ 5 ], [ 10, 1 ] ], [ [ 10, 2 ], [  ], [ 10, 2 ] ], [ [ 5, 1 ], [ 2 ], [ 10, 2 ] ], [ [ 2, 1 ], [ 5 ], [ 10, 2 ] ],
	[ [ 1, 1 ], [ 2, 5 ], [ 10, 2 ] ] ], [ [ [ 11, 1 ], [  ], [ 11, 1 ] ], [ [ 1, 1 ], [ 11 ], [ 11, 1 ] ] ],
	[ [ [ 12, 1 ], [  ], [ 12, 1 ] ], [ [ 4, 1 ], [ 3 ], [ 12, 1 ] ], [ [ 12, 2 ], [  ], [ 12, 2 ] ], [ [ 4, 1 ], [ 3 ], [ 12, 2 ] ],
	[ [ 3, 1 ], [ 4 ], [ 12, 2 ] ], [ [ 1, 1 ], [ 3, 4 ], [ 12, 2 ] ], [ [ 12, 3 ], [  ], [ 12, 3 ] ], [ [ 3, 1 ], [ 2, 2 ], [ 12, 3 ] ], [ [ 12, 4 ], [  ], [ 12, 4 ] ],
	[ [ 6, 1 ], [ 2 ], [ 12, 4 ] ], [ [ 4, 2 ], [ 3 ], [ 12, 4 ] ], [ [ 2, 1 ], [ 2, 3 ], [ 12, 4 ] ], [ [ 12, 5 ], [  ], [ 12, 5 ] ], [ [ 6, 2 ], [ 2 ], [ 12, 5 ] ],
	[ [ 4, 2 ], [ 3 ], [ 12, 5 ] ], [ [ 3, 1 ], [ 2, 2 ], [ 12, 5 ] ], [ [ 2, 1 ], [ 2, 3 ], [ 12, 5 ] ], [ [ 1, 1 ], [ 2, 2, 3 ], [ 12, 5 ] ] ],
	[ [ [ 13, 1 ], [  ], [ 13, 1 ] ], [ [ 1, 1 ], [ 13 ], [ 13, 1 ] ] ], [ [ [ 14, 1 ], [  ], [ 14, 1 ] ], [ [ 2, 1 ], [ 7 ], [ 14, 1 ] ], [ [ 14, 2 ], [  ], [ 14, 2 ] ],
	[ [ 7, 1 ], [ 2 ], [ 14, 2 ] ], [ [ 2, 1 ], [ 7 ], [ 14, 2 ] ], [ [ 1, 1 ], [ 2, 7 ], [ 14, 2 ] ] ], [ [ [ 15, 1 ], [  ], [ 15, 1 ] ], [ [ 5, 1 ], [ 3 ], [ 15, 1 ] ],
	[ [ 3, 1 ], [ 5 ], [ 15, 1 ] ], [ [ 1, 1 ], [ 3, 5 ], [ 15, 1 ] ] ], [ [ [ 16, 1 ], [  ], [ 16, 1 ] ], [ [ 1, 1 ], [ 16 ], [ 16, 1 ] ], [ [ 16, 2 ], [  ], [ 16, 2 ] ],
	[ [ 4, 1 ], [ 4 ], [ 16, 2 ] ], [ [ 1, 1 ], [ 4, 4 ], [ 16, 2 ] ], [ [ 16, 3 ], [  ], [ 16, 3 ] ], [ [ 4, 1 ], [ 2, 2 ], [ 16, 3 ] ], [ [ 2, 1 ], [ 2, 4 ], [ 16, 3 ] ],
	[ [ 2, 1 ], [ 2 ], [ 4, 2 ] ], [ [ 16, 4 ], [  ], [ 16, 4 ] ], [ [ 4, 1 ], [ 4 ], [ 16, 4 ] ], [ [ 16, 5 ], [  ], [ 16, 5 ] ], [ [ 8, 1 ], [ 2 ], [ 16, 5 ] ],
	[ [ 2, 1 ], [ 8 ], [ 16, 5 ] ], [ [ 1, 1 ], [ 2, 8 ], [ 16, 5 ] ], [ [ 16, 6 ], [  ], [ 16, 6 ] ], [ [ 2, 1 ], [ 8 ], [ 16, 6 ] ], [ [ 16, 7 ], [  ], [ 16, 7 ] ],
	[ [ 2, 1 ], [ 8 ], [ 16, 7 ] ], [ [ 16, 8 ], [  ], [ 16, 8 ] ], [ [ 2, 1 ], [ 8 ], [ 16, 8 ] ], [ [ 16, 9 ], [  ], [ 16, 9 ] ], [ [ 16, 10 ], [  ], [ 16, 10 ] ],
	[ [ 8, 2 ], [ 2 ], [ 16, 10 ] ], [ [ 4, 2 ], [ 4 ], [ 16, 10 ] ], [ [ 4, 1 ], [ 2, 2 ], [ 16, 10 ] ], [ [ 2, 1 ], [ 2, 4 ], [ 16, 10 ] ],
	[ [ 1, 1 ], [ 2, 2, 4 ], [ 16, 10 ] ], [ [ 16, 11 ], [  ], [ 16, 11 ] ], [ [ 8, 3 ], [ 2 ], [ 16, 11 ] ], [ [ 4, 2 ], [ 2, 2 ], [ 16, 11 ] ],
	[ [ 4, 2 ], [ 4 ], [ 16, 11 ] ], [ [ 2, 1 ], [ 2, 2, 2 ], [ 16, 11 ] ], [ [ 2, 1 ], [ 2, 4 ], [ 16, 11 ] ], [ [ 16, 12 ], [  ], [ 16, 12 ] ],
	[ [ 8, 4 ], [ 2 ], [ 16, 12 ] ], [ [ 16, 13 ], [  ], [ 16, 13 ] ], [ [ 2, 1 ], [ 2, 4 ], [ 16, 13 ] ], [ [ 16, 14 ], [  ], [ 16, 14 ] ], [ [ 8, 5 ], [ 2 ], [ 16, 14 ] ],
	[ [ 4, 2 ], [ 2, 2 ], [ 16, 14 ] ], [ [ 2, 1 ], [ 2, 2, 2 ], [ 16, 14 ] ], [ [ 1, 1 ], [ 2, 2, 2, 2 ], [ 16, 14 ] ] ],
	[ [ [ 17, 1 ], [  ], [ 17, 1 ] ], [ [ 1, 1 ], [ 17 ], [ 17, 1 ] ] ], [ [ [ 18, 1 ], [  ], [ 18, 1 ] ], [ [ 2, 1 ], [ 9 ], [ 18, 1 ] ],
	[ [ 18, 2 ], [  ], [ 18, 2 ] ], [ [ 9, 1 ], [ 2 ], [ 18, 2 ] ], [ [ 2, 1 ], [ 9 ], [ 18, 2 ] ], [ [ 1, 1 ], [ 2, 9 ], [ 18, 2 ] ], [ [ 18, 3 ], [  ], [ 18, 3 ] ],
	[ [ 6, 1 ], [ 3 ], [ 18, 3 ] ], [ [ 6, 2 ], [ 3 ], [ 18, 3 ] ], [ [ 2, 1 ], [ 3, 3 ], [ 18, 3 ] ], [ [ 18, 4 ], [  ], [ 18, 4 ] ], [ [ 6, 1 ], [ 3 ], [ 18, 4 ] ],
	[ [ 2, 1 ], [ 3, 3 ], [ 18, 4 ] ], [ [ 18, 5 ], [  ], [ 18, 5 ] ], [ [ 9, 2 ], [ 2 ], [ 18, 5 ] ], [ [ 6, 2 ], [ 3 ], [ 18, 5 ] ], [ [ 3, 1 ], [ 2, 3 ], [ 18, 5 ] ],
	[ [ 2, 1 ], [ 3, 3 ], [ 18, 5 ] ], [ [ 1, 1 ], [ 2, 3, 3 ], [ 18, 5 ] ] ], [ [ [ 19, 1 ], [  ], [ 19, 1 ] ], [ [ 1, 1 ], [ 19 ], [ 19, 1 ] ] ],
	[ [ [ 20, 1 ], [  ], [ 20, 1 ] ], [ [ 4, 1 ], [ 5 ], [ 20, 1 ] ], [ [ 20, 2 ], [  ], [ 20, 2 ] ], [ [ 5, 1 ], [ 4 ], [ 20, 2 ] ],
	[ [ 4, 1 ], [ 5 ], [ 20, 2 ] ], [ [ 1, 1 ], [ 4, 5 ], [ 20, 2 ] ], [ [ 20, 3 ], [  ], [ 20, 3 ] ], [ [ 4, 1 ], [ 5 ], [ 20, 3 ] ], [ [ 20, 4 ], [  ], [ 20, 4 ] ],
	[ [ 10, 1 ], [ 2 ], [ 20, 4 ] ], [ [ 4, 2 ], [ 5 ], [ 20, 4 ] ], [ [ 2, 1 ], [ 2, 5 ], [ 20, 4 ] ], [ [ 20, 5 ], [  ], [ 20, 5 ] ], [ [ 10, 2 ], [ 2 ], [ 20, 5 ] ],
	[ [ 5, 1 ], [ 2, 2 ], [ 20, 5 ] ], [ [ 4, 2 ], [ 5 ], [ 20, 5 ] ], [ [ 2, 1 ], [ 2, 5 ], [ 20, 5 ] ], [ [ 1, 1 ], [ 2, 2, 5 ], [ 20, 5 ] ] ],
	[ [ [ 21, 1 ], [  ], [ 21, 1 ] ], [ [ 3, 1 ], [ 7 ], [ 21, 1 ] ], [ [ 21, 2 ], [  ], [ 21, 2 ] ], [ [ 7, 1 ], [ 3 ], [ 21, 2 ] ], [ [ 3, 1 ], [ 7 ], [ 21, 2 ] ],
	[ [ 1, 1 ], [ 3, 7 ], [ 21, 2 ] ] ], [ [ [ 22, 1 ], [  ], [ 22, 1 ] ], [ [ 2, 1 ], [ 11 ], [ 22, 1 ] ], [ [ 22, 2 ], [  ], [ 22, 2 ] ], [ [ 11, 1 ], [ 2 ], [ 22, 2 ] ],
	[ [ 2, 1 ], [ 11 ], [ 22, 2 ] ], [ [ 1, 1 ], [ 2, 11 ], [ 22, 2 ] ] ], [ [ [ 23, 1 ], [  ], [ 23, 1 ] ], [ [ 1, 1 ], [ 23 ], [ 23, 1 ] ] ],
	[ [ [ 24, 1 ], [  ], [ 24, 1 ] ], [ [ 8, 1 ], [ 3 ], [ 24, 1 ] ], [ [ 24, 2 ], [  ], [ 24, 2 ] ], [ [ 8, 1 ], [ 3 ], [ 24, 2 ] ],
	[ [ 3, 1 ], [ 8 ], [ 24, 2 ] ], [ [ 1, 1 ], [ 3, 8 ], [ 24, 2 ] ], [ [ 24, 3 ], [  ], [ 24, 3 ] ], [ [ 24, 4 ], [  ], [ 24, 4 ] ], [ [ 8, 4 ], [ 3 ], [ 24, 4 ] ],
	[ [ 24, 5 ], [  ], [ 24, 5 ] ], [ [ 8, 2 ], [ 3 ], [ 24, 5 ] ], [ [ 6, 1 ], [ 4 ], [ 24, 5 ] ], [ [ 2, 1 ], [ 3, 4 ], [ 24, 5 ] ], [ [ 24, 6 ], [  ], [ 24, 6 ] ],
	[ [ 8, 3 ], [ 3 ], [ 24, 6 ] ], [ [ 6, 1 ], [ 4 ], [ 24, 6 ] ], [ [ 2, 1 ], [ 3, 4 ], [ 24, 6 ] ], [ [ 24, 7 ], [  ], [ 24, 7 ] ], [ [ 12, 1 ], [ 2 ], [ 24, 7 ] ],
	[ [ 8, 2 ], [ 3 ], [ 24, 7 ] ], [ [ 4, 1 ], [ 2, 3 ], [ 24, 7 ] ], [ [ 24, 8 ], [  ], [ 24, 8 ] ], [ [ 8, 3 ], [ 3 ], [ 24, 8 ] ], [ [ 6, 1 ], [ 2, 2 ], [ 24, 8 ] ],
	[ [ 2, 1 ], [ 2, 2, 3 ], [ 24, 8 ] ], [ [ 24, 9 ], [  ], [ 24, 9 ] ], [ [ 12, 2 ], [ 2 ], [ 24, 9 ] ], [ [ 8, 2 ], [ 3 ], [ 24, 9 ] ], [ [ 6, 2 ], [ 4 ], [ 24, 9 ] ],
	[ [ 4, 1 ], [ 2, 3 ], [ 24, 9 ] ], [ [ 3, 1 ], [ 2, 4 ], [ 24, 9 ] ], [ [ 2, 1 ], [ 3, 4 ], [ 24, 9 ] ], [ [ 1, 1 ], [ 2, 3, 4 ], [ 24, 9 ] ],
	[ [ 24, 10 ], [  ], [ 24, 10 ] ], [ [ 8, 3 ], [ 3 ], [ 24, 10 ] ], [ [ 6, 2 ], [ 2, 2 ], [ 24, 10 ] ], [ [ 6, 2 ], [ 4 ], [ 24, 10 ] ],
	[ [ 2, 1 ], [ 2, 2, 3 ], [ 24, 10 ] ], [ [ 2, 1 ], [ 3, 4 ], [ 24, 10 ] ], [ [ 24, 11 ], [  ], [ 24, 11 ] ], [ [ 8, 4 ], [ 3 ], [ 24, 11 ] ],
	[ [ 24, 12 ], [  ], [ 24, 12 ] ], [ [ 6, 1 ], [ 2, 2 ], [ 24, 12 ] ], [ [ 24, 13 ], [  ], [ 24, 13 ] ], [ [ 12, 3 ], [ 2 ], [ 24, 13 ] ],
	[ [ 6, 2 ], [ 2, 2 ], [ 24, 13 ] ], [ [ 3, 1 ], [ 2, 2, 2 ], [ 24, 13 ] ], [ [ 24, 14 ], [  ], [ 24, 14 ] ], [ [ 12, 4 ], [ 2 ], [ 24, 14 ] ],
	[ [ 8, 5 ], [ 3 ], [ 24, 14 ] ], [ [ 6, 1 ], [ 2, 2 ], [ 24, 14 ] ], [ [ 4, 2 ], [ 2, 3 ], [ 24, 14 ] ], [ [ 2, 1 ], [ 2, 2, 3 ], [ 24, 14 ] ],
	[ [ 24, 15 ], [  ], [ 24, 15 ] ], [ [ 12, 5 ], [ 2 ], [ 24, 15 ] ], [ [ 8, 5 ], [ 3 ], [ 24, 15 ] ], [ [ 6, 2 ], [ 2, 2 ], [ 24, 15 ] ], [ [ 4, 2 ], [ 2, 3 ], [ 24, 15 ] ]
	, [ [ 3, 1 ], [ 2, 2, 2 ], [ 24, 15 ] ], [ [ 2, 1 ], [ 2, 2, 3 ], [ 24, 15 ] ], [ [ 1, 1 ], [ 2, 2, 2, 3 ], [ 24, 15 ] ] ],
	[ [ [ 25, 1 ], [  ], [ 25, 1 ] ], [ [ 1, 1 ], [ 25 ], [ 25, 1 ] ], [ [ 25, 2 ], [  ], [ 25, 2 ] ], [ [ 5, 1 ], [ 5 ], [ 25, 2 ] ], [ [ 1, 1 ], [ 5, 5 ], [ 25, 2 ] ] ],
	[ [ [ 26, 1 ], [  ], [ 26, 1 ] ], [ [ 2, 1 ], [ 13 ], [ 26, 1 ] ], [ [ 26, 2 ], [  ], [ 26, 2 ] ], [ [ 13, 1 ], [ 2 ], [ 26, 2 ] ], [ [ 2, 1 ], [ 13 ], [ 26, 2 ] ],
	[ [ 1, 1 ], [ 2, 13 ], [ 26, 2 ] ] ], [ [ [ 27, 1 ], [  ], [ 27, 1 ] ], [ [ 1, 1 ], [ 27 ], [ 27, 1 ] ], [ [ 27, 2 ], [  ], [ 27, 2 ] ], [ [ 9, 1 ], [ 3 ], [ 27, 2 ] ],
	[ [ 3, 1 ], [ 9 ], [ 27, 2 ] ], [ [ 1, 1 ], [ 3, 9 ], [ 27, 2 ] ], [ [ 27, 3 ], [  ], [ 27, 3 ] ], [ [ 3, 1 ], [ 3, 3 ], [ 27, 3 ] ], [ [ 27, 4 ], [  ], [ 27, 4 ] ],
	[ [ 3, 1 ], [ 9 ], [ 27, 4 ] ], [ [ 27, 5 ], [  ], [ 27, 5 ] ], [ [ 9, 2 ], [ 3 ], [ 27, 5 ] ], [ [ 3, 1 ], [ 3, 3 ], [ 27, 5 ] ], [ [ 1, 1 ], [ 3, 3, 3 ], [ 27, 5 ] ] ],
	[ [ [ 28, 1 ], [  ], [ 28, 1 ] ], [ [ 4, 1 ], [ 7 ], [ 28, 1 ] ], [ [ 28, 2 ], [  ], [ 28, 2 ] ], [ [ 7, 1 ], [ 4 ], [ 28, 2 ] ], [ [ 4, 1 ], [ 7 ], [ 28, 2 ] ],
	[ [ 1, 1 ], [ 4, 7 ], [ 28, 2 ] ], [ [ 28, 3 ], [  ], [ 28, 3 ] ], [ [ 14, 1 ], [ 2 ], [ 28, 3 ] ], [ [ 4, 2 ], [ 7 ], [ 28, 3 ] ], [ [ 2, 1 ], [ 2, 7 ], [ 28, 3 ] ],
	[ [ 28, 4 ], [  ], [ 28, 4 ] ], [ [ 14, 2 ], [ 2 ], [ 28, 4 ] ], [ [ 7, 1 ], [ 2, 2 ], [ 28, 4 ] ], [ [ 4, 2 ], [ 7 ], [ 28, 4 ] ], [ [ 2, 1 ], [ 2, 7 ], [ 28, 4 ] ],
	[ [ 1, 1 ], [ 2, 2, 7 ], [ 28, 4 ] ] ], [ [ [ 29, 1 ], [  ], [ 29, 1 ] ], [ [ 1, 1 ], [ 29 ], [ 29, 1 ] ] ],
	[ [ [ 30, 1 ], [  ], [ 30, 1 ] ], [ [ 10, 2 ], [ 3 ], [ 30, 1 ] ], [ [ 6, 1 ], [ 5 ], [ 30, 1 ] ], [ [ 2, 1 ], [ 3, 5 ], [ 30, 1 ] ],
	[ [ 30, 2 ], [  ], [ 30, 2 ] ], [ [ 10, 1 ], [ 3 ], [ 30, 2 ] ], [ [ 6, 2 ], [ 5 ], [ 30, 2 ] ], [ [ 2, 1 ], [ 3, 5 ], [ 30, 2 ] ], [ [ 30, 3 ], [  ], [ 30, 3 ] ],
	[ [ 10, 1 ], [ 3 ], [ 30, 3 ] ], [ [ 6, 1 ], [ 5 ], [ 30, 3 ] ], [ [ 2, 1 ], [ 3, 5 ], [ 30, 3 ] ], [ [ 30, 4 ], [  ], [ 30, 4 ] ], [ [ 15, 1 ], [ 2 ], [ 30, 4 ] ],
	[ [ 10, 2 ], [ 3 ], [ 30, 4 ] ], [ [ 6, 2 ], [ 5 ], [ 30, 4 ] ], [ [ 5, 1 ], [ 2, 3 ], [ 30, 4 ] ], [ [ 3, 1 ], [ 2, 5 ], [ 30, 4 ] ], [ [ 2, 1 ], [ 3, 5 ], [ 30, 4 ] ],
	[ [ 1, 1 ], [ 2, 3, 5 ], [ 30, 4 ] ] ], [ [ [ 31, 1 ], [  ], [ 31, 1 ] ], [ [ 1, 1 ], [ 31 ], [ 31, 1 ] ] ] ];

	D:=QuasiIsomorph(C);
	n:=Order(D);
	if n>Length(HomoTuple) then
		Print("The function has not applied for this cat-1-group\n");
		return fail;
	fi;
	k:=Position(HomoTuple[n],HomotopyTuple(D));
	if n=16 and k=9 then
		if Homology(D,2)=[2] then
			return [4,4];
		fi;
	fi;
	return [n,k];
end);
##
################### end of IdQuasiCatOneGroup ###############################

#############################################################################
#0
#F	SmallQuasiCatOneGroup
##
InstallGlobalFunction(SmallQuasiCatOneGroup, function(n,k)
local	x,PositionCats,nP;

	PositionCats:=[ [ [ 1, 1, 1 ] ], [ [ 2, 1, 1 ], [ 2, 1, 2 ] ], [ [ 3, 1, 1 ], [ 3, 1, 2 ] ], [ [ 4, 1, 1 ], [ 4, 1, 2 ], [ 4, 2, 1 ], [ 4, 2, 2 ], [ 4, 2, 3 ] ],
	[ [ 5, 1, 1 ], [ 5, 1, 2 ] ], [ [ 6, 1, 1 ], [ 6, 1, 2 ], [ 6, 2, 1 ], [ 6, 2, 2 ], [ 6, 2, 3 ], [ 6, 2, 4 ] ], [ [ 7, 1, 1 ], [ 7, 1, 2 ] ],
	[ [ 8, 1, 1 ], [ 8, 1, 2 ], [ 8, 2, 1 ], [ 8, 2, 2 ], [ 8, 2, 3 ], [ 8, 2, 4 ], [ 8, 3, 1 ], [ 8, 3, 2 ],
	[ 8, 3, 3 ], [ 8, 4, 1 ], [ 8, 5, 1 ], [ 8, 5, 2 ], [ 8, 5, 3 ], [ 8, 5, 4 ] ], [ [ 9, 1, 1 ], [ 9, 1, 2 ], [ 9, 2, 1 ], [ 9, 2, 2 ], [ 9, 2, 3 ] ],
	[ [ 10, 1, 1 ], [ 10, 1, 2 ], [ 10, 2, 1 ], [ 10, 2, 2 ], [ 10, 2, 3 ], [ 10, 2, 4 ] ], [ [ 11, 1, 1 ], [ 11, 1, 2 ] ],
	[ [ 12, 1, 1 ], [ 12, 1, 2 ], [ 12, 2, 1 ], [ 12, 2, 2 ], [ 12, 2, 3 ], [ 12, 2, 4 ], [ 12, 3, 1 ],
	[ 12, 3, 2 ], [ 12, 4, 1 ], [ 12, 4, 2 ], [ 12, 4, 3 ], [ 12, 4, 4 ], [ 12, 5, 1 ], [ 12, 5, 2 ], [ 12, 5, 3 ], [ 12, 5, 4 ], [ 12, 5, 5 ], [ 12, 5, 6 ] ],
	[ [ 13, 1, 1 ], [ 13, 1, 2 ] ], [ [ 14, 1, 1 ], [ 14, 1, 2 ], [ 14, 2, 1 ], [ 14, 2, 2 ], [ 14, 2, 3 ], [ 14, 2, 4 ] ],
	[ [ 15, 1, 1 ], [ 15, 1, 2 ], [ 15, 1, 3 ], [ 15, 1, 4 ] ], [ [ 16, 1, 1 ], [ 16, 1, 2 ],
	[ 16, 2, 1 ], [ 16, 2, 2 ], [ 16, 2, 3 ], [ 16, 3, 1 ], [ 16, 3, 2 ], [ 16, 3, 3 ], [ 16, 3, 4 ], [ 16, 4, 1 ], [ 16, 4, 2 ], [ 16, 5, 1 ], [ 16, 5, 2 ], [ 16, 5, 3 ],
	[ 16, 5, 4 ], [ 16, 6, 1 ], [ 16, 6, 2 ], [ 16, 7, 1 ], [ 16, 7, 2 ], [ 16, 8, 1 ], [ 16, 8, 2 ], [ 16, 9, 1 ], [ 16, 10, 1 ], [ 16, 10, 2 ],
	[ 16, 10, 3 ], [ 16, 10, 4 ], [ 16, 10, 5 ], [ 16, 10, 6 ], [ 16, 11, 1 ], [ 16, 11, 2 ], [ 16, 11, 3 ], [ 16, 11, 4 ], [ 16, 11, 5 ], [ 16, 11, 6 ], [ 16, 12, 1 ],
	[ 16, 12, 2 ], [ 16, 13, 1 ], [ 16, 13, 2 ], [ 16, 14, 1 ], [ 16, 14, 2 ], [ 16, 14, 3 ], [ 16, 14, 4 ], [ 16, 14, 5 ] ], [ [ 17, 1, 1 ], [ 17, 1, 2 ] ],
	[ [ 18, 1, 1 ], [ 18, 1, 2 ], [ 18, 2, 1 ], [ 18, 2, 2 ], [ 18, 2, 3 ], [ 18, 2, 4 ], [ 18, 3, 1 ], [ 18, 3, 2 ], [ 18, 3, 3 ], [ 18, 3, 4 ], [ 18, 4, 1 ],
	[ 18, 4, 2 ], [ 18, 4, 3 ], [ 18, 5, 1 ], [ 18, 5, 2 ], [ 18, 5, 3 ], [ 18, 5, 4 ], [ 18, 5, 5 ], [ 18, 5, 6 ] ], [ [ 19, 1, 1 ], [ 19, 1, 2 ] ],
	[ [ 20, 1, 1 ], [ 20, 1, 2 ], [ 20, 2, 1 ], [ 20, 2, 2 ], [ 20, 2, 3 ], [ 20, 2, 4 ], [ 20, 3, 1 ], [ 20, 3, 2 ],
	[ 20, 4, 1 ], [ 20, 4, 2 ], [ 20, 4, 3 ], [ 20, 4, 4 ], [ 20, 5, 1 ], [ 20, 5, 2 ], [ 20, 5, 3 ], [ 20, 5, 4 ], [ 20, 5, 5 ], [ 20, 5, 6 ] ],
	[ [ 21, 1, 1 ], [ 21, 1, 2 ], [ 21, 2, 1 ], [ 21, 2, 2 ], [ 21, 2, 3 ], [ 21, 2, 4 ] ], [ [ 22, 1, 1 ], [ 22, 1, 2 ], [ 22, 2, 1 ], [ 22, 2, 2 ], [ 22, 2, 3 ], [ 22, 2, 4 ] ],
	[ [ 23, 1, 1 ], [ 23, 1, 2 ] ], [ [ 24, 1, 1 ], [ 24, 1, 2 ], [ 24, 2, 1 ], [ 24, 2, 2 ], [ 24, 2, 3 ], [ 24, 2, 4 ], [ 24, 3, 1 ], [ 24, 4, 1 ],
	[ 24, 4, 2 ], [ 24, 5, 1 ], [ 24, 5, 2 ], [ 24, 5, 3 ], [ 24, 5, 4 ], [ 24, 6, 1 ], [ 24, 6, 2 ], [ 24, 6, 3 ], [ 24, 6, 4 ], [ 24, 7, 1 ], [ 24, 7, 2 ], [ 24, 7, 3 ],
	[ 24, 7, 4 ], [ 24, 8, 1 ], [ 24, 8, 2 ], [ 24, 8, 3 ], [ 24, 8, 4 ], [ 24, 9, 1 ], [ 24, 9, 2 ], [ 24, 9, 3 ], [ 24, 9, 4 ], [ 24, 9, 5 ],
	[ 24, 9, 6 ], [ 24, 9, 7 ], [ 24, 9, 8 ], [ 24, 10, 1 ], [ 24, 10, 2 ], [ 24, 10, 3 ], [ 24, 10, 4 ], [ 24, 10, 5 ], [ 24, 10, 6 ], [ 24, 11, 1 ], [ 24, 11, 2 ],
	[ 24, 12, 1 ], [ 24, 12, 2 ], [ 24, 13, 1 ], [ 24, 13, 2 ], [ 24, 13, 3 ], [ 24, 13, 4 ], [ 24, 14, 1 ], [ 24, 14, 2 ], [ 24, 14, 3 ],
	[ 24, 14, 4 ], [ 24, 14, 5 ], [ 24, 14, 6 ], [ 24, 15, 1 ], [ 24, 15, 2 ], [ 24, 15, 3 ], [ 24, 15, 4 ], [ 24, 15, 5 ], [ 24, 15, 6 ], [ 24, 15, 7 ], [ 24, 15, 8 ] ],
	[ [ 25, 1, 1 ], [ 25, 1, 2 ], [ 25, 2, 1 ], [ 25, 2, 2 ], [ 25, 2, 3 ] ], [ [ 26, 1, 1 ], [ 26, 1, 2 ], [ 26, 2, 1 ], [ 26, 2, 2 ], [ 26, 2, 3 ], [ 26, 2, 4 ] ],
	[ [ 27, 1, 1 ], [ 27, 1, 2 ], [ 27, 2, 1 ], [ 27, 2, 2 ], [ 27, 2, 3 ], [ 27, 2, 4 ], [ 27, 3, 1 ], [ 27, 3, 2 ], [ 27, 4, 1 ], [ 27, 4, 2 ],
	[ 27, 5, 1 ], [ 27, 5, 2 ], [ 27, 5, 3 ], [ 27, 5, 4 ] ], [ [ 28, 1, 1 ], [ 28, 1, 2 ], [ 28, 2, 1 ], [ 28, 2, 2 ], [ 28, 2, 3 ], [ 28, 2, 4 ], [ 28, 3, 1 ],
	[ 28, 3, 2 ], [ 28, 3, 3 ], [ 28, 3, 4 ], [ 28, 4, 1 ], [ 28, 4, 2 ], [ 28, 4, 3 ], [ 28, 4, 4 ], [ 28, 4, 5 ], [ 28, 4, 6 ] ],
	[ [ 29, 1, 1 ], [ 29, 1, 2 ] ], [ [ 30, 1, 1 ], [ 30, 1, 2 ], [ 30, 1, 3 ], [ 30, 1, 4 ], [ 30, 2, 1 ], [ 30, 2, 2 ], [ 30, 2, 3 ], [ 30, 2, 4 ], [ 30, 3, 1 ], [ 30, 3, 2 ],
	[ 30, 3, 3 ], [ 30, 3, 4 ], [ 30, 4, 1 ], [ 30, 4, 2 ], [ 30, 4, 3 ], [ 30, 4, 4 ], [ 30, 4, 5 ], [ 30, 4, 6 ], [ 30, 4, 7 ], [ 30, 4, 8 ] ],
	[ [ 31, 1, 1 ], [ 31, 1, 2 ] ] ];
	
	nP:=Length(PositionCats);
	if n> Length(PositionCats) then
		Print("This function only applied for order less than ",nP+1,"\n");
		return fail;
	fi;
	if k> Length(PositionCats[n]) then
		Print("There are only ",Length(PositionCats[n]), " cat-1-groups of order ",n,"\n"); 
		return fail;
	fi;
	x:=PositionCats[n][k];
	return SmallCatOneGroup(x[1],x[2],x[3]);
end);
##
################### end of SmallQuasiCatOneGroup ############################










