\documentclass{article}
\usepackage{axiom}
\begin{document}
\title{\$SPAD/src/algebra nrc.as}
\author{Michael Richardson}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{NagResultChecks}
<<NagResultChecks>>=
+++ Author: M.G. Richardson
+++ Date Created: 1995 Dec. 06
+++ Date Last Updated:
+++ Basic Functions:
+++ Related Constructors:
+++ Also See:
+++ AMS Classifications:
+++ Keywords:
+++ References:
+++ Description:

NagResultChecks: with {

  checkResult   : (RSLT, STRG, STRG) -> DF ;
  checkCxResult : (RSLT, STRG, STRG) -> CDF ;
  checkMxCDF    : (RSLT, STRG, STRG) -> MCDF ;
  checkMxDF     : (RSLT, STRG, STRG) -> MDF ;

} == add {

  import from DF ;
  import from SMBL ;
  import from INT ;
  import from AnyFunctions1 INT ;
  import from AnyFunctions1 DF ;
  import from AnyFunctions1 CDF ;
  import from AnyFunctions1 MDF ;
  import from AnyFunctions1 MCDF ;
  import from ErrorFunctions ;
  import from STRG ;
  import from List STRG ;

  checkResult(returnValue : RSLT, returnKey : STRG, routine : STRG) : DF ==
    if not zero?(retract(returnValue."ifail") @ INT)
       then nagError(routine, retract(returnValue."ifail") @ INT)
       else retract(returnValue.(returnKey::SMBL)) @ DF ;

  checkCxResult(returnValue : RSLT, returnKey : STRG, routine : STRG) : CDF ==
    if not zero?(retract(returnValue."ifail") @ INT)
       then nagError(routine, retract(returnValue."ifail") @ INT)
       else retract(returnValue.(returnKey::SMBL)) @ CDF ;

  checkMxDF(returnValue : RSLT, returnKey : STRG, routine : STRG) : MDF ==
    if not zero?(retract(returnValue."ifail") @ INT)
       then nagError(routine, retract(returnValue."ifail") @ INT)
       else retract(returnValue.(returnKey::SMBL)) @ MDF ;

  checkMxCDF(returnValue : RSLT, returnKey : STRG, routine : STRG) : MCDF ==
    if not zero?(retract(returnValue."ifail") @ INT)
       then nagError(routine, retract(returnValue."ifail") @ INT)
       else retract(returnValue.(returnKey::SMBL)) @ MCDF ;

  nagError(routine : STRG, opIfail : INT) : Exit ==
    error ["An error was detected when calling the NAG Library routine ",
           routine,
           ".  The error number (IFAIL value) is ",
           string(opIfail),
           ", please consult the NAG manual via the Browser for",
	   " diagnostic information."] ;
}

@
\section{License}
<<license>>=
--Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
--All rights reserved.
--
--Redistribution and use in source and binary forms, with or without
--modification, are permitted provided that the following conditions are
--met:
--
--    - Redistributions of source code must retain the above copyright
--      notice, this list of conditions and the following disclaimer.
--
--    - Redistributions in binary form must reproduce the above copyright
--      notice, this list of conditions and the following disclaimer in
--      the documentation and/or other materials provided with the
--      distribution.
--
--    - Neither the name of The Numerical ALgorithms Group Ltd. nor the
--      names of its contributors may be used to endorse or promote products
--      derived from this software without specific prior written permission.
--
--THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
--IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
--TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
--PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
--OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
--EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
--PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
--PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
--LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
--NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
--SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
@
<<*>>=
<<license>>

-- N.B. ndftip.as, nqip.as and nsfip.as inline from nrc
-- and must be recompiled if this is.

#include "axiom.as"

DF   ==> DoubleFloat ;
CDF  ==> Complex DoubleFloat ;
MDF  ==> Matrix DoubleFloat ;
MCDF ==> Matrix Complex DoubleFloat ;
INT  ==> Integer ;
RSLT ==> Result ;
SMBL ==> Symbol ;
STRG ==> String ;

<<NagResultChecks>>
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
