\documentclass{article}
\usepackage{axiom}
\begin{document}
\title{\$SPAD/src/algebra noptip.as}
\author{Michael Richardson}
\maketitle
\begin{abstract}
\end{abstract}
\eject
\tableofcontents
\eject
\section{NagOptimisationInterfacePackage}
<<NagOptimisationInterfacePackage>>=
+++ Author: M.G. Richardson
+++ Date Created: 1996 Feb. 01
+++ Date Last Updated:
+++ Basic Functions:
+++ Related Constructors:
+++ Also See:
+++ AMS Classifications:
+++ Keywords:
+++ References:
+++ Description:
+++ This package provides Axiom-like interfaces to some of the NAG
+++ optimisation routines in the NAGlink.

NagOptimisationInterfacePackage: with {

  nagMin : (EDF,LEQPDF) -> LEQPDF ;

} == add {

  import from MINT ;
  import from BOOL ;
  import from LLDF ;
  import from VDF ;
  import from PDF ;
  import from LEQEDF ;
  import from MDF ;
  import from EDF ;
  import from FL ;
  import from SMBL ;
  import from A49 ;
  import from A55 ;
  import from U49 ;
  import from U55 ;
  import from NagOptimisationPackage ;
  import from OF ;
  import from LOF ;
  import from LLOF ;
  import from ListFunctions2(INT,OF) ;
  import from NagResultChecks ;
  import from EF2DFFL ;

  local (..)(a:INT,b:INT):Generator INT == {
    generate {
      t := a ;
      while (t <= b) repeat {
        yield t ;
        t := t + 1 ;
        }
      }
    }

  -- to avoid unrecognised versions of U49 type for e04dgf:
  e04dgflocal := e04dgf$NagOptimisationPackage pretend
   ((INT,DF,DF,INT,DF,BOOL, DF,DF,INT,INT,INT,INT,MDF,INT, U49)->RSLT) ;

  nagMin(objective:EDF,startList:LEQPDF) : LEQPDF == {

  -- Note that, as objective is an EDF, subst and eval
  -- for this have as 2nd parameters LEQEDFs.

    local nv : INT ;
    local substList : LEQEDF ;
    local indxOb : EF ;
    local startVals : LDF ;
    local startListXDF : LEQEDF ;
    local startFVal : DF ;
    local e04dgfResult : RSLT ;
    local location : LDF  ;


     nv := ((# startList)@NNI pretend INT) ; -- @ avoids SI

     substList := [lhs(startList.i)::EDF
	             = (script("x"::SMBL,[[i::OF]]@LLOF))::EDF
		                                for i in 1..nv] ;
     -- [x=x[1], y=x[2], etc.]

     indxOb := map(convert$Float,subst(objective,substList)) ;
     -- objective function as an EF with x[i]'s, as required by A49

     startVals := [retract(rhs(startList.i))@DF for i in 1..nv] ;

     startListXDF := [lhs(startList.i)::EDF = rhs(startList.i)::EDF
					            for i in 1..nv] ;
     startFVal := ground(eval(objective,startListXDF))::DF ;
     startFVal := startFVal * 1.015625 ;

-- Note that there appears to be a problem running the standard NAG
-- example on Suns with an exact value for startFVal.  It looks as if
-- this causes too large a stepsize, perhaps due to exception code
-- being obeyed in the Fortran.  Until this is fixed, using the above
-- slightly perturbed value (adding 1/64) seems to avoid the problem.

     e04dgfResult := e04dgflocal(
		nv,                        -- No.vbls.
                                           --
                                           -- "optional" params next:
                                           --
                startFVal,                 -- es(timated obj've fn val)
                -1.0,                      -- fun:
                -1,                        -- it:
                -1.0,                      -- lin:
                false,                     -- list:
                -1.0,                      -- ma:
                -2.0,                      -- opt: made < fun for safety
                0,                         -- pr:
                -1,                        -- sta:
                -1,                        -- sto:
                -1,                        -- ve:
                                           --
                matrix [startVals],        -- initial position estimate
                -1,                        -- IFAIL
                [retract(indxOb)@A49]@U49  -- objective function
                ) ;

     location := entries(row(checkMxDF(e04dgfResult,"x","E04DGF"),1)) ;

     [ ((retract(lhs(startList.i))@SMBL)::PDF
	  = (location.i)::PDF)@EQPDF for i in 1..nv ]

  }

}

#if NeverAssertThis

-- Note that the conversions of results from DoubleFloat to Float
-- will become unnecessary if outputGeneral is extended to apply to
-- DoubleFloat quantities.

)lib nrc

outputGeneral 5

f := %e^x*(4*x^2 + 2*y^2 + 4*x*y + 2*y + 1);
start := [x=-1.0, y=1.0];
nagMin(f,start) :: List Equation Polynomial Float

--       [x= 0.5,y= - 1.0]

outputGeneral()

output "End of tests"

#endif

@
\section{License}
<<license>>=
--Copyright (c) 1991-2002, The Numerical ALgorithms Group Ltd.
--All rights reserved.
--
--Redistribution and use in source and binary forms, with or without
--modification, are permitted provided that the following conditions are
--met:
--
--    - Redistributions of source code must retain the above copyright
--      notice, this list of conditions and the following disclaimer.
--
--    - Redistributions in binary form must reproduce the above copyright
--      notice, this list of conditions and the following disclaimer in
--      the documentation and/or other materials provided with the
--      distribution.
--
--    - Neither the name of The Numerical ALgorithms Group Ltd. nor the
--      names of its contributors may be used to endorse or promote products
--      derived from this software without specific prior written permission.
--
--THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
--IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
--TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
--PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
--OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
--EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
--PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
--PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
--LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
--NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
--SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
@
<<*>>=
<<license>>

-- To test:
-- sed '1,/^#if NeverAssertThis/d;/#endif/d' < noptip.as > noptip.input
-- axiom
-- )set nag host <some machine running nagd>
-- )r noptip.input

#unassert saturn

#include "axiom.as"

INT     ==> Integer ;
NNI     ==> NonNegativeInteger ;
MINT    ==> Matrix INT ;
DF      ==> DoubleFloat ;
EDF     ==> Expression DF ;
EQEDF   ==> Equation EDF ;
LEQEDF  ==> List EQEDF ;
LDF     ==> List DF ;
LLDF    ==> List LDF ;
VDF     ==> Vector DF ;
MDF     ==> Matrix DF ;
PDF     ==> Polynomial DF ;
EQPDF   ==> Equation PDF ;
LEQPDF  ==> List EQPDF ;
FL      ==> Float ;
EF      ==> Expression FL ;
BOOL    ==> Boolean ;
A49     ==> Asp49("OBJFUN") ;
A55     ==> Asp55("CONFUN") ;
U49     ==> Union(fn: FileName, fp: A49) ;
U55     ==> Union(fn: FileName, fp: A55) ;
SMBL    ==> Symbol ;
RSLT    ==> Result ;
OF      ==> OutputForm ;
LOF     ==> List OF ;
LLOF    ==> List LOF ;
EF2DFFL ==> ExpressionFunctions2(DF,FL) ;

<<NagOptimisationInterfacePackage>>
@
\eject
\begin{thebibliography}{99}
\bibitem{1} nothing
\end{thebibliography}
\end{document}
