#include<cstdlib>
#include<iostream>
#include <sys/stat.h>
#include <errno.h>
#include <dyn/config.hh>

namespace wali { namespace dyn {
  namespace loading {

    std::string get_user_directory() {
      /*#ifdef WALI_OTF_LIB_PATH
       * #define STR_VALUE(arg)      #arg
       * #define STR(name) STR_VALUE(name)
       * return std::string(STR(WALI_OTF_LIB_PATH));
       * #undef STR
       * #undef STR_VALUE
       * #else*/
      std::string dir(std::getenv("HOME"));
      dir.append("/.wali/");
      return dir;
      /*#endif*/
    }

    std::string get_lib_directory() {
      /*#ifdef WALI_OTF_LIB_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
      return std::string(STR(WALI_OTF_LIB_PATH));
      #undef STR
      #undef STR_VALUE
      #else*/
      std::string dir(get_user_directory());
      dir.append("lib/");
      return dir;
      /*#endif*/
    }

    std::string get_dynlib_directory() {
      #ifdef WALI_DYNLIB_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
      return std::string(STR(WALI_DYNLIB_PATH));
      #undef STR
      #undef STR_VALUE
      #else
      std::string dir(std::getenv("HOME"));
      dir.append("/.wali");
      return dir;
      #endif
    }

    std::string get_share_directory() {
      #ifdef WALI_SHARE_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
      return std::string(STR(WALI_SHARE_PATH));
      #undef STR
      #undef STR_VALUE
      #else
      return (get_lib_directory()+"/share");
      #endif
    }

    std::string get_include_directory() {
      #ifdef WALI_INCLUDE_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
      return std::string(STR(WALI_INCLUDE_PATH));
      #undef STR
      #undef STR_VALUE
      #else
      return (get_wali_directory());
      #endif
    }

    std::string get_source_directory() {
      #ifdef WALI_SOURCE_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
      return std::string(STR(WALI_SOURCE_PATH));
      #undef STR
      #undef STR_VALUE
      #else
      return (get_wali_directory());
      #endif
    }

    std::string get_wali_directory() {
      #ifdef WALI_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
      return std::string(STR(WALI_PATH));
      #undef STR
      #undef STR_VALUE
      #else
      const char* dir=std::getenv("WALI_PATH");
      if(dir==NULL) {
        std::cerr << "Environment variable WALI_PATH is not set" << std::endl;
        std::cerr << "Please define : export WALI_PATH=[...]/wali" << std::endl;
        exit(0);
      }
      return std::string(dir);
      #endif
    }

    int make_wali_dir() {
      struct stat st;
      for(std::string dir : { get_user_directory(), get_lib_directory()} ) {
        if(stat(dir.data(), &st)==-1)
        {
          if(errno == ENOENT) {
            if(mkdir(dir.data(), S_IRWXU)==0)
              return 0;
          }
          std::cerr << "Unable to create directory in the home directory" << std::endl;
          std::cerr << dir << std::endl;
          return -1;
        }
        if(!S_ISDIR(st.st_mode))
          std::cerr << dir << "is not a directory in the home directory" << std::endl;

      }
      return 0;
    }

    std::string get_dyn_config_hh_directory() {
      #ifdef WALI_DYN_CONFIG_HH_PATH
      #define STR_VALUE(arg)      #arg
      #define STR(name) STR_VALUE(name)
        return std::string(STR(WALI_DYN_CONFIG_HH_PATH));
      #undef STR
      #undef STR_VALUE
      #else
        return get_include_directory();
      #endif
    }
  }

}}//end of ns wali::dyn
