# This file is part of Awali.
# Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
#
# Awali is a free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

cdef RatExp _RatExp(simple_ratexp_t ratexp):
    r= RatExp("","hack!!")
    r._this= ratexp
    return r

#cdef RatExp _eventually_build_RatExp(expression, weightset=None):
  #if type(expression) is RatExp:
    #return expression
  #else:
    #return RatExp(expression, weightset)

  ##

cdef class RatExp:

## ========================================================================= ##
    cdef simple_ratexp_t _this

## ========================================================================= ##
    cdef void _set_cpp_class(self, simple_ratexp_t other):
        """
        Modify wrapped object. Internal use only.
        This seems to be quite fragile. Modify the code with caution.
        """
        self._this.rewrap_into_me_(other)

## ========================================================================= ##
    cdef simple_ratexp_t _to_cpp_class(self):
        return (<simple_ratexp_t>self._this)

## ========================================================================= ##
    def __init__(self, expression, weightset = None, str alphabet = None):
        if type(expression) is RatExp:
          self._this= (<RatExp>expression)._this.copy();
        elif type(expression) is not str:
          raise TypeError ("Argument 'expression' has incorrect type (expected awalipy.RatExp or str, got "+type(expression)+")")
        else:
          n = len(expression)
          if (n > 1) and (expression[0] == '<') \
                                   and (expression[n-1] == '>') :
            expression+= '\\e'
          if weightset is None:
              if alphabet is None:
                  self._this = make_simple_ratexp1(expression)
              else:
                  self._this = make_simple_ratexp2bis(expression, alphabet)
          else:
              if weightset == "hack!!":
                  pass
              else:
                if isinstance(weightset, WeightSet):
                    weightset = str(weightset);
                if alphabet is None:
                    self._this = make_simple_ratexp2(expression, weightset)
                else:
                    self._this = make_simple_ratexp3(expression, weightset, alphabet)

## ========================================================================= ##
    def copy(self):
      return _RatExp(self._this.copy())


## ========================================================================= ##
    def __add__(self, RatExp other):
        if isinstance(self, RatExp):
            return self.add(other)
        else:
            self.__add__(other);

    def __invert__(self):
        return self.star()

    def __xor__(self, other):
        if type(self) is RatExp:
          return self.mult(other)
        else:
          return RatExp(self, other.get_weightset()).mult(other)


    def __str__(self):
        return self._this.print_()

    def __repr__(self):
        return self._this.print_()


## ========================================================================= ##
    def add(self, re):
        """
        Usage. re.add(other_re)

        Description:  returns the sum (ie union) of <re/self> and <other_re>

        Args:  other_re (RatExp)

        Returns: RatExp
        """
        return _RatExp(self._this.add(RatExp(re,self.get_weightset())._this))


## ========================================================================= ##
    def add_here(self, RatExp re):
        """
        Usage:  re.add_here(other_re)

        Description:  computes the sum  (ie union) of <re/self> and <other_re> and reassign the result to <re/self>

        Args:  other_re (RatExp)

        Note:  convenience function written at the python layer
        """
        self._set_cpp_class(self._this.add(re._this))


## ========================================================================= ##
    def mult(self, re):
        """
        Usage:  re.mult(other_re)

        Description:  returns the multiplication (or concatenation) of <re/self> and <other_re>

        Args:  other_re (RatExp)

        Returns: RatExp
        """
        return _RatExp(self._this.mult(RatExp(re,self.get_weightset())._this))



## ========================================================================= ##
    def mult_here(self, RatExp re):
        """
        Usage:  re.mult(other_re)

        Description:  computes the multiplication (or concatenation) of <re/self> and <other_re> and reassign the result to <re/self>

        Args:  other_re (RatExp)

        Note:  convenience function written at the python layer
        """
        self._set_cpp_class(self._this.mult(re._this))


## ========================================================================= ##
    def star(self):
        """
        Usage:  re.star()

        Description:  returns the star of <re/self>

        Returns:  RatExp
        """
        return _RatExp(self._this.star())


## ========================================================================= ##
    def star_here(self):
        """
        Usage:  re.star_here()

        Description:  computes the star of <re/self> and reassign the result to <re/self>

        Note:  convenience function written at the python layer
        """
        return self._set_cpp_class(self._this.star())


## ========================================================================= ##
    def derivation(self, str word, bool breaking=False):
        return _from_map_ratexp_s(derivation_(self._this, word, breaking))


## ========================================================================= ##
    def derived_term(self, bool breaking=False, bool keep_history=True):
        """
        Usage:  re.derived_term( [breaking=False [, keep_history=True] ] )

        Description:  computes an automaton accepting <re/self> using the derived term algorithm

        Args:
            breaking (bool, optional)
                defaults to False
            keep_history
                defaults to False

        Returns:  Automaton
        """
        return _Automaton(derived_term_(self._this, breaking=False, keep_history=True))


## ========================================================================= ##
    def exp_to_aut(self):
        """
        Usage:  re.exp_to_aut()

        Description:  computes an automaton accepting <re/self> (using the derived term algorithm)

        Returns:  Automaton
        """
        return self.derived_term()


## ========================================================================= ##
    def thompson(self):
        """
        Usage:  re.thompson()

        Description:  computes the Thompson automaton of <re/self>

        Returns:  Automaton
        """
        return _Automaton(thompson_(self._this))


## ========================================================================= ##
    def standard(self):
        """
        Usage:  re.standard()

        Description:  builds a standard automaton accepting <re/self>

        Returns:  Automaton
        """
        return _Automaton(standard_(self._this))


## ========================================================================= ##
    def expand(self):
        """
        Usage:  re.expand()

        Description: builds a new expression by distributing the products over the sums of the input

        Returns:  RatExp
        """
        return _RatExp(expand_(self._this))


## ========================================================================= ##
    def star_normal_form(self):
        """
        Usage:  re.star_normal_form()

        Description:  builds a new equivalent expression in star normal form

        Precondition:  weighset of <re/self> must be B

        Returns:  RatExp
        """
        return _RatExp(star_normal_form_(self._this))


## ========================================================================= ##
    def star_height(self):
        """
        Usage:  re.star_height()

        Description:  computes the star-height of the expression

        Returns:  int
        """
        return star_height_(self._this)


## ========================================================================= ##
    def get_weightset(self):
        """
        Usage:  re.get_weightset()

        Description:  returns the weightset of <re/self>

        Returns:  WeightSet
        """
        return WeightSet(self._this.get_weightset())


## ========================================================================= ##
    def display(self):
        """
        Usage:  re.display
        """
        a = _BasicAutomaton_(display_rat_(self._this))
        a.display(history=True)


## ========================================================================= ##
    def is_valid(self):
        """
        Usage:  ratexp.is_valid()

        Description:  Tests whether epsilon is properly weighted in every sub-expression.

        Returns:  bool
        """
        return self._this.is_valid()


## ========================================================================= ##
    cpdef str constant_term(self):
        """
        Usage:  ratexp.constant_term()

        Description:  Returns the weight of epsilon.

        Returns: str, representing a weight
        """
        return self._this.constant_term()
