// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include<awali/algos/js_print.hh>
#include<awali/algos/exp_parser.hh>
#include<awali/labelset/traits.hh>// ratexpset_of
#include<awali/algos/derivation.hh>// ratexpset_of
#include<awali/algos/aut-to-exp.hh>

//We work with NFAs (thus the "weight" is Boolean"):
#include<awali/weightset/b.hh>
//The labels are letters implemented by char:
#include<awali/ctx/lal_char.hh>
#include<awali/ctx/lan.hh>
#include<awali/ctx/lat.hh>

//Static features are defined in the awali::stc namespace
using namespace awali::stc;

using letterset_t = ctx::lal_char;
using labelset_t = ctx::lat<ctx::lal_char, ctx::lal_char>;
using weightset_t = b;
using context_t = context<labelset_t, weightset_t>;

int main() {
  weightset_t b;
  labelset_t alph{letterset_t{'a','b'},letterset_t{'x','y'}};
  context_t ctx(alph,b);
  
  using ratset_t = ratexpset_of<context_t>; 
  ratset_t ratset(get_rat_context(ctx), ratset_t::identities_t::trivial);
  auto exp = parse_exp(ratset,"(a,x)*(b,y)");
  std::cout << "Expression:" << std::endl;
  js_print(ratset, exp, std::cout) << std::endl;

  auto aut=derived_term(ratset, exp);
  std::cout << "Automate:" << std::endl;
  js_print(aut, std::cout) << std::endl;

  auto e=aut_to_exp_naive(aut);
  ratset.print(e, std::cout) << std::endl;
}
