// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_CTX_LAL_INT_HH
# define AWALI_CTX_LAL_INT_HH

#include <awali/sttc/alphabets/basic_letter.hh>
#include <awali/sttc/alphabets/set_basicalpha.hh>
#include <awali/sttc/labelset/letterset.hh>

namespace awali {
  namespace sttc {
    template <>
    template <>
    typename basic_letters<int>::letter_t
    basic_letters<int>::special<basic_letters<int>::letter_t>()
    {
      return special_letter();
    }

    template <>
    template <>
    typename basic_letters<int>::word_t
    basic_letters<int>::special<basic_letters<int>::word_t>()
    {
      return {special_letter()};
    }

    template<>
    struct alpha_name<sttc::basic_letters<int>> {
      static std::string name() {
	return "int";
      }

      static std::string jsname() {
	return "Int Letters";
      }
    };

    namespace ctx
    {
      using lal_int = letterset<sttc::set_basic_alphabet<sttc::basic_letters<int>>>;
    }
  }
}//end of ns awali::stc

#endif // !AWALI_CTX_LAL_INT_HH
