// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_ALGOS_UNION_HH
# define AWALI_ALGOS_UNION_HH

# include <unordered_map>

#include <awali/sttc/algos/copy.hh>
#include <awali/sttc/algos/product.hh> // join_automata
#include <awali/sttc/core/mutable-automaton.hh>

namespace awali { namespace sttc {

  /*----------.
  | union_a.  |
  `----------*/

  /// Merge transitions of \a b into those of \a res.
  ///
  /// \pre AutIn <: AutOut.
  template <typename A, typename B>
  inline
  A&
  union_here(A& res, const B& b)
  {
    sttc::copy_into(b, res);
    return res;
  }

  /// Union of two automata.
  template <typename A, typename B>
  inline
  auto
  union_a(const A& lhs, const B& rhs)
    -> decltype(join_automata(lhs, rhs))
  {
    auto res = join_automata(lhs, rhs);
    union_here(res, lhs);
    union_here(res, rhs);
    return res;
  }

}}//end of ns awali::stc

#endif // !AWALI_ALGOS_UNION_HH
