// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_ALGOS_FACTOR_HH
#define AWALI_ALGOS_FACTOR_HH

#include <awali/sttc/algos/copy.hh>

namespace awali { namespace sttc {


  /*-------.
  | Prefix |
  `-------*/

  template <typename Aut>
  void
  prefix_here(Aut& a)
  {
    for(auto s : a->states())
      a->set_final(s);
  }

  template <typename Aut>
  typename Aut::element_type::automaton_nocv_t
  prefix(const Aut& a)
  {
    auto r = copy(a);
    prefix_here(r);
    return r;
  }

  /*-------.
  | Suffix |
  `-------*/

  template <typename Aut>
  void
  suffix_here(Aut& a)
  {
    for(auto s : a->states())
      a->set_initial(s);
  }

  template <typename Aut>
  typename Aut::element_type::automaton_nocv_t
  suffix(const Aut& a)
  {
    auto r = copy(a);
    suffix_here(r);
    return r;
  }

  /*-------.
  | Factor |
  `-------*/

  template <typename Aut>
  void
  factor_here(Aut& a)
  {
    prefix_here(a);
    suffix_here(a);
  }

  template <typename Aut>
  typename Aut::element_type::automaton_nocv_t
  factor(const Aut& a)
  {
    auto r = copy(a);
    factor_here(r);
    return r;
  }

}}//end of ns awali::stc

#endif // !AWALI_ALGOS_FACTOR_HH
