// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/dyn.hh>

using namespace awali::dyn;
using namespace awali;

int main() {
  automaton_t a = ladybird(4);
  //a->json(std::cout) << std::endl;
  //std::cout << "------------------------------------" << std::endl;
  ratexp_t e = aut_to_exp(a);
  e->json(std::cout) << std::endl;
  e->json(std::cout) << std::endl;
  automaton_t t=thompson(e);
  t->json(std::cout) << std::endl;

  ratexp_t ef = aut_to_exp(t);
  ef->json(std::cout) << std::endl;
  /*
  automaton_t s=standard(e);
  s->json(std::cout) << std::endl;
  */
//  std::cout << "------------------------------------" << std::endl;
  automaton_t b = lift(a);
  b->json(std::cout) << std::endl;
// dot(b,std::cout);
//  std::cout << "------------------------------------" << std::endl;
  automaton_t c = make_automaton_with_eps("ab");
  c->set_eps_transition(c->add_state(), c->add_state());
  c->json(std::cout) << std::endl;

  std::cout << "------------------------------------" << std::endl;
  automaton_t d = make_automaton("ab","Z");
  d->set_initial(d->add_state(),-5);
  d->set_transition(d->add_state(), d->add_state(),'a',3);
  d->json(std::cout) << std::endl;

  std::cout << "------------------------------------" << std::endl;
  automaton_t q = make_automaton("ab","Q");
  state_t sq[2];
  q->set_transition(sq[0]=q->add_state(), sq[1]=q->add_state(),'a',q_fraction_t(3,4));
  q->set_initial(sq[0],q_fraction_t(-5));
  q->set_final(sq[1]);
  q->json(std::cout) << std::endl;
  json(q, std::cout) << std::endl;
  ratexp_t eq = aut_to_exp(q);
  eq->json(std::cout) << std::endl;
  return 0;
}

