// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_RATEXP_CC
#define DYN_MODULES_RATEXP_CC

#include <iostream>
#include <set>
#include <unordered_map>
#include <awali/dyn/core/abstract-ratexp.hh>
#include <awali/dyn/loading/handler.hh>
#include <awali/dyn/core/context-description.hh>

#include <awali/dyn/modules/ratexp.hh>

namespace awali { namespace dyn {

  ratexp_t aut_to_exp(automaton_t aut) {
    return loading::call<ratexp_t, &aut_to_exp>("aut_to_exp","ratexp", aut);
  }

   automaton_t lift(automaton_t aut) {
    return loading::call<automaton_t, &lift>("lift","ratexp", aut);
  }

  ratexp_t expand(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();
    typedef ratexp_t (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("expand", "ratexp", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }

  ratexp_t star_normal_form(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();
    typedef ratexp_t (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("star_normal_form", "ratexp", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }

  unsigned star_height(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();;
    typedef unsigned (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("star_height", "ratexp", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }

    bool is_valid(ratexp_t exp) {
      std::string stat_ctx = exp->get_context()->sname();;
      typedef bool (*bridge_t)(ratexp_t);
      static std::unordered_map<std::string, bridge_t> bridges;
      auto it = bridges.find(stat_ctx);
      if(it == bridges.end()) {
	auto bridge = (bridge_t) loading::get_handler("is_valid", "ratexp", stat_ctx);
	bridges.emplace(stat_ctx, bridge);
	return bridge(exp);
      }
      else
	return it->second(exp);
    }
      
    weight_t constant_term(ratexp_t exp) {
      std::string stat_ctx = exp->get_context()->sname();;
      typedef weight_t (*bridge_t)(ratexp_t);
      static std::unordered_map<std::string, bridge_t> bridges;
      auto it = bridges.find(stat_ctx);
      if(it == bridges.end()) {
	auto bridge = (bridge_t) loading::get_handler("constant_term", "ratexp", stat_ctx);
	bridges.emplace(stat_ctx, bridge);
	return bridge(exp);
      }
      else
	return it->second(exp);
    }

    


}}//end of ns awali::dyn

#endif
