// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_PROPER_CC
#define DYN_MODULES_PROPER_CC

#include <unordered_map>
#include <awali/common/direction.hh>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/core/abstract-ratexp.hh>
#include <awali/dyn/loading/handler.hh>

#include <awali/dyn/modules/proper.hh>

namespace awali { namespace dyn {
  void proper_here(automaton_t aut, param_t dir, bool prune) {
    loading::call3<void, param_t, bool, &proper_here>("proper_here", "proper", aut, dir, prune);
  }

  automaton_t proper(automaton_t aut, param_t dir, bool prune) {
    return loading::call3<automaton_t, param_t, bool, &proper>("proper", "proper", aut, dir, prune);
  }

  bool is_proper(automaton_t aut) {
    return loading::call<bool, &is_proper>("is_proper", "proper", aut);
  }

  bool is_valid(automaton_t aut) {
    return loading::call<bool, &is_valid>("is_valid", "proper", aut);
  }

  automaton_t allow_eps_transition(automaton_t aut) {
    return loading::call<automaton_t, &allow_eps_transition>("allow_eps_transition", "proper", aut);
  }

  automaton_t thompson(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();
    typedef automaton_t (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("thompson", "proper", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }

  automaton_t zpc(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();
    typedef automaton_t (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("zpc", "proper", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }

  automaton_t draw_exp(ratexp_t exp) {
    std::string stat_ctx = exp->get_context()->sname();
    typedef automaton_t (*bridge_t)(ratexp_t);
    static std::unordered_map<std::string, bridge_t> bridges;
    auto it = bridges.find(stat_ctx);
    if(it == bridges.end()) {
      auto bridge = (bridge_t) loading::get_handler("draw_exp", "proper", stat_ctx);
      bridges.emplace(stat_ctx, bridge);
      return bridge(exp);
    }
    else
      return it->second(exp);
  }
}}//end of ns awali::dyn

#endif
