// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_HISTORY_HH
#define DYN_MODULES_HISTORY_HH

#include <awali/dyn/core/automaton.hh>
#include <awali/common/history-kind.hh>

namespace awali {
  namespace dyn {

  history_kind_t get_history_kind(automaton_t aut);

  //For SINGLE
  state_t get_origin_state(automaton_t aut, state_t s);

  //For PARTITION and TUPLE
  std::vector<state_t> get_origin_states(automaton_t aut, state_t s);

  }
}//end of ns awali::dyn


#endif
