// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_FACTORIES_HH
#define DYN_FACTORIES_HH

#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/core/abstract-context.hh>
#include <awali/dyn/loading/handler.hh>
#include <vector>

namespace awali { namespace dyn {

  //(a+b)*a(a+b){n}
  automaton_t de_bruijn(unsigned n, char first_letter) {
    typedef automaton_t (*bridge_t)(unsigned, char);
    static auto bridge = (bridge_t) loading::get_handler("de_bruijn", "factories", "lal_char_b");
    return bridge(n, first_letter);
  }

  automaton_t divkbaseb(unsigned k, unsigned b, char first_letter) {
    typedef automaton_t (*bridge_t)(unsigned, unsigned, char);
    static auto bridge = (bridge_t) loading::get_handler("divkbaseb", "factories", "lal_char_b");
    return bridge(k, b, first_letter);
  }

  automaton_t double_ring(unsigned n, const std::vector<unsigned>& finals, char first_letter) {
    typedef automaton_t (*bridge_t)(unsigned, const std::vector<unsigned>, char);
    static auto bridge = (bridge_t) loading::get_handler("double_ring", "factories", "lal_char_b");
    return bridge(n, finals, first_letter);
  }

  automaton_t ladybird(unsigned n, char first_letter) {
    typedef automaton_t (*bridge_t)(unsigned, char);
    static auto bridge = (bridge_t) loading::get_handler("ladybird", "factories", "lal_char_b");
    return bridge(n, first_letter);
  }

  automaton_t cerny(unsigned n, char first_letter) {
    typedef automaton_t (*bridge_t)(unsigned, char);
    static auto bridge = (bridge_t) loading::get_handler("cerny", "factories", "lal_char_b");
    return bridge(n, first_letter);
  }

  //Brzozowski universal witness
  automaton_t witness(unsigned n, char first_letter) {
    typedef automaton_t (*bridge_t)(unsigned, char);
    static auto bridge = (bridge_t) loading::get_handler("witness", "factories", "lal_char_b");
    return bridge(n, first_letter);
  }

}}//end of ns awali::dyn

#endif
