// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_CONTEXT_HH
#define DYN_MODULES_CONTEXT_HH

#include<string>

#include <awali/dyn/core/context-description.hh>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/core/abstract-ratexp.hh>

namespace awali {
  namespace dyn {

    automaton_t make_automaton_from_context(context_t ctx);
    automaton_t make_automaton_from_context(context_description cd);
    automaton_t make_automaton_from_context(labelset_description ls, weightset_description ws);

    context_t make_context(context_description cd);

    automaton_t make_automaton(std::string alphabet, std::string semiring);
    automaton_t make_automaton(std::string alphabet);
    automaton_t make_automaton_with_eps(std::string alphabet, std::string semiring);
    automaton_t make_automaton_with_eps(std::string alphabet);

    automaton_t make_int_automaton(int a, int b, std::string semiring);
    automaton_t make_int_automaton(int n, std::string semiring);
    automaton_t make_automaton_with_eps(std::string alphabet);
    automaton_t make_int_automaton_with_eps(int a, int b, std::string semiring);
    automaton_t make_int_automaton_with_eps(int n, std::string semiring);
    
    automaton_t parse_automaton(std::istream& i);

  ratexp_t make_int_ratexp_with_range(const std::string& exp, int a, int b, const std::string& sr) ;
  ratexp_t make_int_ratexp_with_range(const std::string& exp, int a, int b);

    ratexp_t make_ratexp_with_context(const std::string& exp,
				      context_description cd);
    ratexp_t make_ratexp_with_context(const std::string& exp,
				      labelset_description ls,
				      weightset_description ws);
    ratexp_t make_ratexp_with_alphabet(const std::string& exp,
				       const std::string& alph,
				       const std::string& sr);
    ratexp_t make_ratexp_with_alphabet(const std::string& exp, const std::string& alph);
    ratexp_t parse_ratexp(std::istream& i);

  }
}//end of ns awali::dyn

#endif
