// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_CYCLIC_WEIGHTSET_HH
#define DYN_CYCLIC_WEIGHTSET_HH
#include <awali/dyn/core/context-description/weightsets/abstract-weightset.hh>
#include<sstream>

namespace awali {
  namespace dyn {

    struct cyclic_weightset : abstract_weightset {
      


      const std::string& tostring(weightset_description ws, bool dynamic) const {
	static std::string res;
	std::ostringstream o;
	o << "zz" << ws->characteristic ;
	res=o.str();
	return res;
      }

  std::string static_pub_name = "Z/<int>Z";

  const std::string& static_public_name() const {
    return static_pub_name;
  }
      virtual weightset_description fromstring(const std::string &k) const {
	weightset_description ws;
	if(k[0] == 'Z' && k[1] == '/') {
	  std::istringstream i(k.substr(2));
	  int n;
	  i >> n;
	  char c;
	  i >> c;
	  if (c=='Z') {
	    ws = make_weightset_description();
	    ws->type_ = index;
	    ws->characteristic= n;
	  }
	}
	return ws;
      }

      virtual weightset_description parse_weightset(std::istream& i) const {
	weightset_description ws;
	if(sttc::parsestring(i)=="Cyclic") {
	  ws = make_weightset_description();
	  ws->type_ = index;
	  std::string key = sttc::parsestring(i);
	  if (key == "Characteristic") {
	    sttc::check(i, ':');
	    ws->characteristic=std::stoi(sttc::parsestring(i));
	  } else
	    throw std::runtime_error("json: expected \"Characteristic\", got \""+key+"\"");
	}
	return ws;
      }

    };
  }
}

#endif
