// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/sttc/algos/proper.hh>
#include <awali/sttc/labelset/traits.hh>
#include <awali/sttc/algos/thompson.hh>
#include <awali/sttc/algos/draw_exp.hh>
#include <awali/sttc/algos/zpc.hh>
#include <awali/sttc/algos/copy.hh>
#include <awali/dyn/bridge-sttc/explicit-automaton.cc>
#include <awali/dyn/bridge-sttc/explicit-ratexp.cc>

#include<set-types.hh>

namespace awali {

  extern "C" void proper_here(dyn::automaton_t aut, param_t dir, bool prune) {
    auto a = dyn::get_stc_automaton<context_t>(aut);
    sttc::proper_here(a, dir, prune);
  }

  template<typename Cold, typename Cnew>
  struct dispatch {
    static const dyn::automaton_t proper_(dyn::automaton_t aut, param_t dir, bool prune) {
      auto a = dyn::get_stc_automaton<Cold>(aut);
      auto tmp = sttc::proper(a, dir, prune);
      auto res = sttc::make_mutable_automaton<Cnew>(sttc::get_not_nullable_context(a->context()));
      sttc::copy_into(tmp,res);
      return dyn::make_automaton(res);
    }

    static const dyn::automaton_t allow_eps_(dyn::automaton_t aut) {
      auto a = dyn::get_stc_automaton<Cold>(aut);
      auto res = sttc::make_mutable_automaton<Cnew>(sttc::get_nullable_context(a->context()));
      sttc::copy_into(a,res);
      return dyn::make_automaton(res);
    }
  };

  template<typename Context>
  struct dispatch<Context, Context> {
    static const dyn::automaton_t proper_(dyn::automaton_t aut, param_t dir, bool prune) {
      auto a = dyn::get_stc_automaton<Context>(aut);
      auto res = sttc::proper(a, dir, prune);
      return dyn::make_automaton(res);
    }

    static const dyn::automaton_t allow_eps_(dyn::automaton_t aut) {
      auto a = dyn::get_stc_automaton<Context>(aut);
      return dyn::make_automaton(sttc::copy(a));
    }
  };

  extern "C" dyn::automaton_t proper(dyn::automaton_t aut, param_t dir, bool prune) {
    using new_context_t = sttc::not_nullable_of<context_t>;
    return dispatch<context_t, new_context_t>::proper_(aut, dir, prune);
  }

  extern "C" dyn::automaton_t allow_eps_transition(dyn::automaton_t aut) {
    using new_context_t = sttc::nullable_of<context_t>;
    return dispatch<context_t, new_context_t>::allow_eps_(aut);
  }


  extern "C" bool is_proper(dyn::automaton_t aut) {
    auto a = dyn::get_stc_automaton<context_t>(aut);
    return sttc::is_proper(a);
  }

  extern "C" bool is_valid(dyn::automaton_t aut) {
    auto a = dyn::get_stc_automaton<context_t>(aut);
    return sttc::is_valid(a);
  }

  extern "C" dyn::automaton_t thompson(dyn::ratexp_t exp) {
    auto e= get_stc_ratexp<context_t>(exp);
    auto rs = get_stc_ratexpset<context_t>(exp);
    using aut_t = sttc::mutable_automaton<sttc::nullable_of<context_t>>;
    return dyn::make_automaton(sttc::thompson<aut_t>(sttc::get_nullable_context(rs.context()), e));
  }

  extern "C" dyn::automaton_t zpc(dyn::ratexp_t exp) {
    auto e= get_stc_ratexp<context_t>(exp);
    auto rs = get_stc_ratexpset<context_t>(exp);
    using aut_t = sttc::mutable_automaton<sttc::nullable_of<context_t>>;
    return dyn::make_automaton(sttc::zpc<aut_t>(sttc::get_nullable_context(rs.context()), e));
  }

  extern "C" dyn::automaton_t draw_exp(dyn::ratexp_t exp) {
    auto e= get_stc_ratexp<context_t>(exp);
    auto rs = get_stc_ratexpset<context_t>(exp);
    return dyn::make_automaton(sttc::draw_exp(rs.context(), e));
  }
}

#include <awali/dyn/core/any.cc>
