// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include<memory>

#include <awali/dyn/core/abstract-ratexp.cc>

#include <awali/dyn/modules/accessible.cc>
#include <awali/dyn/modules/are-equivalent.cc>
#include <awali/dyn/modules/automaton.cc>
#include <awali/dyn/modules/context.cc>
#include <awali/dyn/modules/derivation.cc>
#include <awali/dyn/modules/determinize.cc>
#include <awali/dyn/modules/eliminate.cc>
#include <awali/dyn/modules/eval.cc>
#include <awali/dyn/modules/factor.cc>
#include <awali/dyn/modules/factories.cc>
#include <awali/dyn/modules/graph.cc>
#include <awali/dyn/modules/history.cc>
#include <awali/dyn/modules/minimize.cc>
#include <awali/dyn/modules/output.cc>
#include <awali/dyn/modules/partial-id.cc>
#include <awali/dyn/modules/product.cc>
#include <awali/dyn/modules/proper.cc>
#include <awali/dyn/modules/quotient.cc>
#include <awali/dyn/modules/ratexp.cc>
#include <awali/dyn/modules/singleproduct.cc>
#include <awali/dyn/modules/standard.cc>
#include <awali/dyn/modules/transducer.cc>
#include <awali/dyn/modules/transpose.cc>

#include <awali/dyn/algos/aliases.cc>
#include <awali/dyn/algos/tdc-eval.cc>
#include <awali/dyn/algos/random.hh>
#include <awali/dyn/algos/tdc-circulation.cc>
#include <awali/dyn/algos/sys.cc>

#include <awali/dyn/loading/locations.cc>
#include <awali/dyn/loading/compile.cc>
#include <awali/dyn/loading/handler.cc>
