// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/dyn/modules/partial-id.hh>

#include <awali/dyn/algos/aliases.hh>

namespace awali { namespace dyn {


  automaton_t
  min_coquotient (automaton_t aut, param_t dir)
  {
    automaton_t res = min_quotient(transpose(aut),dir);
    transpose_here(res);
    return res;
  }


  automaton_t
  coquotient (automaton_t aut, std::vector<std::vector<state_t>>& equiv)
  {
    automaton_t res = quotient(transpose(aut), equiv);
    transpose_here(res);
    return res;
  }

  automaton_t
  right_reduce (automaton_t aut)
  {
      automaton_t res = left_reduce(transpose(aut));
      transpose_here(res);
      return res;
  }

}}
