// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef COMMON_METHOD_HH
#define COMMON_METHOD_HH

#include <vector>
#include <string>
namespace awali {

  const unsigned int TYPE_MASK= 0xfff0;
  const unsigned int VALUE_MASK= 0xf;
  bool is_of_type(unsigned int value, unsigned int type) {
    return ((value & TYPE_MASK) == type);
  }

  using minimize_method_t = unsigned int;
  const minimize_method_t MINIMIZE_METHOD = 1 << 4;
  const minimize_method_t BRZOZOWSKI = 1 | MINIMIZE_METHOD;
  const minimize_method_t MOORE = 2 | MINIMIZE_METHOD;
  const minimize_method_t HOPCROFT = 3 | MINIMIZE_METHOD;
  const minimize_method_t SIGNATURE = 4 | MINIMIZE_METHOD;
  const minimize_method_t MINIMIZE_METHOD_END = 5 | MINIMIZE_METHOD;
  const std::vector<std::string> minimize_method_names=
  {"MINIMIZE_METHOD", "BRZOZOWSKI", "MOORE", "HOPCROFT", "SIGNATURE"};

  using file_format_t = unsigned int;
  const file_format_t FILE_FORMAT = 2 << 4;
  const file_format_t JSON = 1 | FILE_FORMAT;
  const file_format_t DOT = 2 | FILE_FORMAT;
  const file_format_t DAUT = 3 | FILE_FORMAT;
  const file_format_t GRAIL = 4 | FILE_FORMAT;
  const file_format_t FADO = 5 | FILE_FORMAT;
  const file_format_t EFSM = 6 | FILE_FORMAT;
  const file_format_t FILE_FORMAT_END = 7 | FILE_FORMAT;
  const std::vector<std::string> file_format_names=
    {"FILE_FORMAT", "JSON", "DOT", "DAUT", "GRAIL", "FADO", "EFSM" };

  using aut_to_exp_method_t = unsigned int;
  const aut_to_exp_method_t AUT_TO_EXP_METHOD = 3 << 4;
  const aut_to_exp_method_t DERIVED_TERM = 1 | AUT_TO_EXP_METHOD;
  const aut_to_exp_method_t THOMPSON = 2 | AUT_TO_EXP_METHOD;
  const aut_to_exp_method_t STANDARD = 3 | AUT_TO_EXP_METHOD;
  const aut_to_exp_method_t AUT_TO_EXP_METHOD_END = 4 | AUT_TO_EXP_METHOD;
  const std::vector<std::string> aut_to_exp_method_names=
  {"AUT_TO_EXP_METHOD", "DERIVED_TERM", "THOMPSON", "STANDARD"};

  const std::vector<std::vector<std::string>> names=
  { {}, minimize_method_names, file_format_names, aut_to_exp_method_names };

  std::string method_to_string(unsigned int i) {
    unsigned int type= (i & TYPE_MASK) >> 4;
    std::string result;
    if (type <= 0 || type >= names.size())
      return "UKNOWN";
    else {
      result= names[type][0];
      unsigned int value= (i & VALUE_MASK);
      if (value == 0)
        return result;
      else if (value < names[type].size()) {
        result+= "::";
        result+=names[type][value];
      } else {
        result+= "::UNKNOWN";
      }
    }
    return result;

  }
}

#endif
