Compilation and Installation of Awali
=====================================

Build Requirements
------------------

Awali uses the C++11 standard; it has been tested with g++ 4.8, 4.9 and Clang++ 6.0,
It should compile with higher versions.
It may probably be used only on Linux or BSD OS (including MacOS).

* GNU Compiler Collection (GCC): `http://gcc.gnu.org/`

* CMake: Compilation process uses CMake : `https://cmake.org/`

* Cython: Used for the compilation of the Python front-end of Awali (module `awalipy`) 

* Graphviz: `http://www.research.att.com/sw/tools/graphviz/`  
The `display` command in Cora uses the export of Awali
into Dot format and launches the `dotty` command from the
Graphviz_ suite:

* Doxygen: `http://doxygen.org`  
Doxygen is used to generate the C++ reference documentation.

* ncurses library 
ncurses is used for automaton edition in the `cora` command-line interface to Awali

Compilation
-----------

In any directory (preferably NOT in the awali directory itself), write:

If the tarball has been downloaded and decompressed in `some/local/directory` then run the following commands

		cd /some/local/directory/awali
		mkdir _build
		cd _build
		cmake ..
		make 		
		

Installation
------------

We recommend you to install Awali by running the following command

	sudo make install 

  
To reverse this operation execute:

	sudo make uninstall
        
        
Where files are installed:
--------------------------

- Headers (ie: {awali,dyn}/**/*.{hh,hxx} ) in:  /usr/local/include/awali/
- Sources (ie: {awali,dyn}/**/*.cc ) in:  /usr/local/share/awali/
- Examples (ie: share/automata/* )  in:  /usr/local/share/awali/automata
- Dynamic Library (ie: libawalidyn.so ) in:  /usr/local/lib/
- Static libraries will be compiled on-the-fly in:  /usr/local/lib/awali_otf/
- Cora executable in:  /usr/local/bin/
- Cora completion 
  - executable in:  /usr/local/bin/
  - bash-script in:  "bash_completion.d"  if it could be found.
  - zsh autocompletion file in:  "site-functions"  if it could be found.
- Python library is installed using "setup" from "distutils.core" hence is installed at different locations depending on OS.



