# NConvex, single 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("nconvex01.tst");

# /doc/_Chunks.xml:2-129
gap> P:= Cone( [ [ 2, 7 ], [ 0, 12 ], [ -2, 5 ] ] );
<A cone in |R^2>
gap> d:= DefiningInequalities( P );
[ [ -7, 2 ], [ 5, 2 ] ]
gap> Q:= ConeByInequalities( d );
<A cone in |R^2>
gap> P=Q;
true
gap> IsPointed( P );
true
gap> RayGenerators( P );
[ [ -2, 5 ], [ 2, 7 ] ]
gap> HilbertBasis( P );
[ [ -2, 5 ], [ -1, 3 ], [ 0, 1 ], [ 1, 4 ], [ 2, 7 ] ]
gap> HilbertBasis( Q );
[ [ -2, 5 ], [ -1, 3 ], [ 0, 1 ], [ 1, 4 ], [ 2, 7 ] ]
gap> P_dual:= DualCone( P );
<A cone in |R^2>
gap> RayGenerators( P_dual );
[ [ -7, 2 ], [ 5, 2 ] ]
gap> Dimension( P );
2
gap> List( Facets( P ), RayGenerators );
[ [ [ -2, 5 ] ], [ [ 2, 7 ] ] ]
gap> faces := FacesOfCone( P );
[ <A cone in |R^2>, <A cone in |R^2>, <A ray in |R^2>, 
 <A ray in |R^2> ]
gap> RelativeInteriorRay( P );
[ -2, 41 ]
gap> IsRelativeInteriorRay( [ -2, 41 ], P );
true
gap> IsRelativeInteriorRay( [ 2, 7 ], P );
false
gap> LinealitySpaceGenerators( P );
[  ]
gap> IsRegularCone( P );
false
gap> IsRay( P );
false
gap> proj_x1:= FourierProjection( P, 2 );
<A cone in |R^1>
gap> RayGenerators( proj_x1 );
[ [ -1 ], [ 1 ] ]
gap> DefiningInequalities( proj_x1 );
[ [ 0 ] ]
gap> R:= Cone( [ [ 4, 5 ], [ -2, 1 ] ] );
<A cone in |R^2>
gap> T:= IntersectionOfCones( P, R );
<A cone in |R^2>
gap> RayGenerators( T );
[ [ -2, 5 ], [ 2, 7 ] ]
gap> W:= Cone( [ [-3,-4 ] ] );
<A ray in |R^2>
gap> I:= IntersectionOfCones( P, W );
<A cone in |R^2>
gap> RayGenerators( I );
[  ]
gap> Contains( P, I );
true
gap> Contains( W, I );
true
gap> Contains( P, R );
false
gap> Contains( R, P );
true
gap> cdd_cone:= ExternalCddCone( P );
< Polyhedron given by its V-representation >
gap> Display( cdd_cone );
V-representation 
begin 
3 X 3  rational
               
   0   2   7 
   0   0  12 
   0  -2   5 
end
gap> Cdd_Dimension( cdd_cone );
2
gap> H:= Cdd_H_Rep( cdd_cone );
< Polyhedron given by its H-representation >
gap> Display( H );
H-representation 
begin 
   2 X 3  rational
               
   0   5   2 
   0  -7   2 
end
gap> P:= Cone( [ [ 1, 1, -3 ], [ -1, -1, 3 ], [ 1, 2, 1 ], [ 2, 1, 2 ] ] );
< A cone in |R^3>
gap> IsPointed( P );
false
gap> Dimension( P );
3
gap> IsRegularCone( P );
false
gap> P;
< A cone in |R^3 of dimension 3 with 4 ray generators>
gap> RayGenerators( P );
[ [ -1, -1, 3 ], [ 1, 1, -3 ], [ 1, 2, 1 ], [ 2, 1, 2 ] ]
gap> d:= DefiningInequalities( P );
[ [ -5, 8, 1 ], [ 7, -4, 1 ] ]
gap> facets:= Facets( P );
[ <A cone in |R^3>, <A cone in |R^3> ]
gap> faces := FacesOfCone( P );
[ <A cone in |R^3>, <A cone in |R^3>, <A cone in |R^3>, 
 <A cone in |R^3>, <A cone in |R^3> ]
gap> FVector( P );
[ 1, 2, 1 ]
gap> List( faces, Dimension );
[ 0, 3, 2, 1, 2 ]
gap> L_using_4ti2 := [ [ [ 0, 0, 0 ] ], [ [ -2, -1, 10 ], 
> [ 0, 0, 1 ], [ 2, 1, 2 ] ],  [ [ 1, 1, -3 ] ] ];;
gap> L_using_Normaliz := [ [ [ 0, 0, 0 ] ], [ [ -1, 0, 7 ], 
> [ 0, 0, 1 ], [ 1, 0, 5 ] ], [ [ 1, 1, -3 ] ] ];;
gap> L := LatticePointsGenerators( P );;
gap> L = L_using_4ti2 or L = L_using_Normaliz;
true
gap> DualCone( P );
< A cone in |R^3>
gap> RayGenerators( DualCone( P ) );
[ [ -5, 8, 1 ], [ 7, -4, 1 ] ]
gap> Q_x1x3:= FourierProjection(P, 2 );
<A cone in |R^2>
gap> RayGenerators( Q_x1x3 );
[ [ -1, 3 ], [ 1, -3 ], [ 1, 1 ] ]

#
gap> STOP_TEST("nconvex01.tst", 1);
