# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Declarations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecord.gi

#! @Chapter Monoidal Categories

#! @Section Add-methods

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDistributivityExpanding`.
#! $F: ( a, L ) \mapsto \mathtt{LeftDistributivityExpanding}(a, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDistributivityExpanding",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDistributivityExpanding",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDistributivityExpanding",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDistributivityExpanding",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDistributivityExpandingWithGivenObjects`.
#! $F: ( s, a, L, r ) \mapsto \mathtt{LeftDistributivityExpandingWithGivenObjects}(s, a, L, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDistributivityFactoring`.
#! $F: ( a, L ) \mapsto \mathtt{LeftDistributivityFactoring}(a, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDistributivityFactoring",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDistributivityFactoring",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDistributivityFactoring",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDistributivityFactoring",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDistributivityFactoringWithGivenObjects`.
#! $F: ( s, a, L, r ) \mapsto \mathtt{LeftDistributivityFactoringWithGivenObjects}(s, a, L, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RightDistributivityExpanding`.
#! $F: ( L, a ) \mapsto \mathtt{RightDistributivityExpanding}(L, a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRightDistributivityExpanding",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRightDistributivityExpanding",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRightDistributivityExpanding",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRightDistributivityExpanding",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RightDistributivityExpandingWithGivenObjects`.
#! $F: ( s, L, a, r ) \mapsto \mathtt{RightDistributivityExpandingWithGivenObjects}(s, L, a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRightDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRightDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRightDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRightDistributivityExpandingWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RightDistributivityFactoring`.
#! $F: ( L, a ) \mapsto \mathtt{RightDistributivityFactoring}(L, a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRightDistributivityFactoring",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRightDistributivityFactoring",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRightDistributivityFactoring",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRightDistributivityFactoring",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RightDistributivityFactoringWithGivenObjects`.
#! $F: ( s, L, a, r ) \mapsto \mathtt{RightDistributivityFactoringWithGivenObjects}(s, L, a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRightDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddRightDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddRightDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddRightDistributivityFactoringWithGivenObjects",
                  [ IsCapCategory, IsList ] );
