# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: BSD-3-Clause

qt_commandline_subconfig(src/corelib)
qt_commandline_subconfig(src/network)
qt_commandline_subconfig(src/gui)
qt_commandline_subconfig(src/sql)
qt_commandline_subconfig(src/xml)
qt_commandline_subconfig(src/widgets)
qt_commandline_subconfig(src/printsupport)
qt_commandline_subconfig(src/plugins/sqldrivers)
qt_commandline_subconfig(src/testlib)
qt_commandline_subconfig(src/tools)
qt_commandline_option(prefix TYPE path CMAKE_VARIABLE CMAKE_INSTALL_PREFIX)
qt_commandline_option(extprefix TYPE path CMAKE_VARIABLE CMAKE_STAGING_PREFIX)
qt_commandline_option(archdatadir TYPE path CMAKE_VARIABLE CMAKE_ARCHDATADIR)
qt_commandline_option(bindir TYPE path CMAKE_VARIABLE INSTALL_BINDIR)
qt_commandline_option(datadir TYPE path CMAKE_VARIABLE INSTALL_DATADIR)
qt_commandline_option(docdir TYPE path CMAKE_VARIABLE INSTALL_DOCDIR)
qt_commandline_option(examplesdir TYPE path CMAKE_VARIABLE INSTALL_EXAMPLESDIR)
qt_commandline_option(headerdir TYPE path CMAKE_VARIABLE INSTALL_INCLUDEDIR)
qt_commandline_option(hostdatadir TYPE string)  # handled specially in QtProcessConfigureArgs.cmake
qt_commandline_option(libdir TYPE path CMAKE_VARIABLE INSTALL_LIBDIR)
qt_commandline_option(libexecdir TYPE path CMAKE_VARIABLE INSTALL_LIBEXECDIR)
qt_commandline_option(plugindir TYPE path CMAKE_VARIABLE INSTALL_PLUGINSDIR)
qt_commandline_option(qmldir TYPE path CMAKE_VARIABLE INSTALL_QMLDIR)
qt_commandline_option(sbomdir TYPE path CMAKE_VARIABLE INSTALL_SBOMDIR)
qt_commandline_option(settingsdir TYPE path NAME sysconfdir CMAKE_VARIABLE INSTALL_SYSCONFDIR)
qt_commandline_option(sysconfdir TYPE path CMAKE_VARIABLE INSTALL_SYSCONFDIR)
qt_commandline_option(testsdir TYPE path CMAKE_VARIABLE INSTALL_TESTSDIR)
qt_commandline_option(translationdir TYPE path CMAKE_VARIABLE INSTALL_TRANSLATIONSDIR)
qt_commandline_option(android-arch TYPE string)
qt_commandline_option(android-abis TYPE string)
qt_commandline_option(android-ndk TYPE path CMAKE_VARIABLE ANDROID_NDK_ROOT)
qt_commandline_option(android-ndk-platform TYPE string)
qt_commandline_option(android-sdk TYPE path CMAKE_VARIABLE ANDROID_SDK_ROOT)
qt_commandline_option(android-javac-target
    TYPE string
    CMAKE_VARIABLE QT_ANDROID_JAVAC_TARGET
)
qt_commandline_option(android-javac-source
    TYPE string
    CMAKE_VARIABLE QT_ANDROID_JAVAC_SOURCE
)
qt_commandline_option(android-style-assets TYPE boolean)
qt_commandline_option(appstore-compliant TYPE boolean)
qt_commandline_option(avx TYPE boolean)
qt_commandline_option(avx2 TYPE boolean)
qt_commandline_option(avx512 TYPE boolean NAME avx512f)
qt_commandline_option(c++std TYPE cxxstd)
qt_commandline_option(unity-build TYPE boolean NAME unity_build CMAKE_VARIABLE QT_UNITY_BUILD)
qt_commandline_option(unity-build-batch-size
    TYPE string
    NAME unity_build_batch_size
    CMAKE_VARIABLE QT_UNITY_BUILD_BATCH_SIZE
)
qt_commandline_option(ccache TYPE boolean NAME ccache CMAKE_VARIABLE QT_USE_CCACHE)
qt_commandline_option(commercial TYPE void)
qt_commandline_option(confirm-license TYPE void)
qt_commandline_option(dbus TYPE optionalString VALUES no yes linked runtime)
qt_commandline_option(dbus-linked TYPE void NAME dbus VALUE linked)
qt_commandline_option(dbus-runtime TYPE void NAME dbus VALUE runtime)
qt_commandline_option(debug TYPE void)
qt_commandline_option(debug-and-release TYPE boolean NAME debug_and_release)
qt_commandline_option(device TYPE string)
qt_commandline_option(device-option TYPE addString CMAKE_VARIABLE QT_QMAKE_DEVICE_OPTIONS)
qt_commandline_option(f16c TYPE boolean)
qt_commandline_option(force-asserts TYPE boolean NAME force_asserts)
qt_commandline_option(force-debug-info TYPE boolean NAME force_debug_info)
qt_commandline_option(force-pkg-config TYPE void NAME pkg-config)
qt_commandline_option(force-bundled-libs TYPE boolean)
qt_commandline_option(force-system-libs TYPE boolean)
qt_commandline_option(framework TYPE boolean)
qt_commandline_option(gc-binaries TYPE boolean NAME gc_binaries)
qt_commandline_option(gdb-index TYPE boolean NAME enable_gdb_index)
qt_commandline_option(gcov TYPE boolean)
qt_commandline_option(gnumake TYPE boolean NAME GNUmake)
qt_commandline_option(gui TYPE boolean)
qt_commandline_option(incredibuild-xge TYPE boolean NAME incredibuild_xge)
qt_commandline_option(libudev TYPE boolean)
qt_commandline_option(openssl TYPE optionalString VALUES no yes linked runtime)
qt_commandline_option(openssl-linked TYPE void NAME openssl VALUE linked)
qt_commandline_option(openssl-runtime TYPE void NAME openssl VALUE runtime)
qt_commandline_option(linker TYPE optionalString VALUES bfd gold lld mold)
qt_commandline_option(ltcg TYPE boolean)
qt_commandline_option(intelcet TYPE boolean)
qt_commandline_option(glibc-fortify-source TYPE boolean NAME glibc_fortify_source)
qt_commandline_option(trivial-auto-var-init-pattern TYPE boolean NAME trivial_auto_var_init_pattern)
qt_commandline_option(stack-protector TYPE boolean NAME stack_protector)
qt_commandline_option(stack-clash-protection TYPE boolean NAME stack_clash_protection)
qt_commandline_option(libstdcpp-assertions TYPE boolean NAME libstdcpp_assertions)
qt_commandline_option(libcpp-hardening TYPE boolean NAME libcpp_hardening)
qt_commandline_option(relro-now-linker TYPE boolean NAME relro_now_linker)
set(allowed_build_parts examples tests benchmarks manual-tests minimal-static-tests doc-snippets)
qt_commandline_option(make TYPE addString VALUES ${allowed_build_parts})
qt_commandline_option(nomake TYPE addString VALUES ${allowed_build_parts})
qt_commandline_option(install-examples-sources
    TYPE boolean
    CMAKE_VARIABLE QT_INSTALL_EXAMPLES_SOURCES
)
qt_commandline_option(mips_dsp TYPE boolean)
qt_commandline_option(mips_dspr2 TYPE boolean)
qt_commandline_option(opensource TYPE void NAME commercial VALUE no)
qt_commandline_option(optimize-debug TYPE boolean NAME optimize_debug)
qt_commandline_option(optimize-size TYPE boolean NAME optimize_size)
qt_commandline_option(optimized-qmake TYPE boolean NAME release_tools)
qt_commandline_option(optimized-tools TYPE boolean NAME release_tools)
qt_commandline_option(pch TYPE boolean CMAKE_VARIABLE BUILD_WITH_PCH)
qt_commandline_option(pkg-config TYPE boolean)
qt_commandline_option(platform TYPE string CMAKE_VARIABLE QT_QMAKE_TARGET_MKSPEC)
qt_commandline_option(plugin-manifests TYPE boolean)
qt_commandline_option(profile TYPE boolean)
qt_commandline_option(qreal TYPE string CMAKE_VARIABLE QT_COORD_TYPE)
qt_commandline_option(qtinlinenamespace TYPE boolean CMAKE_VARIABLE QT_INLINE_NAMESPACE)
qt_commandline_option(qtlibinfix
    TYPE string
    NAME qt_libinfix
    CMAKE_VARIABLE QT_LIBINFIX
)
qt_commandline_option(qtnamespace
    TYPE string
    NAME qt_namespace
    CMAKE_VARIABLE QT_NAMESPACE
)
qt_commandline_option(reduce-exports TYPE boolean NAME reduce_exports)
qt_commandline_option(reduce-relocations TYPE boolean NAME reduce_relocations)
qt_commandline_option(release TYPE enum NAME debug MAPPING yes no no yes)
qt_commandline_option(rpath TYPE boolean)
qt_commandline_option(sanitize TYPE sanitize)
qt_commandline_option(sdk TYPE string CMAKE_VARIABLE QT_APPLE_SDK)
qt_commandline_option(separate-debug-info TYPE boolean NAME separate_debug_info)
qt_commandline_option(shared TYPE boolean)
qt_commandline_option(silent TYPE void)
qt_commandline_option(qdbus TYPE boolean NAME dbus)
qt_commandline_option(sse2 TYPE boolean)
qt_commandline_option(sse3 TYPE boolean)
qt_commandline_option(sse4.1 TYPE boolean NAME sse4_1)
qt_commandline_option(sse4.2 TYPE boolean NAME sse4_2)
qt_commandline_option(ssse3 TYPE boolean)
qt_commandline_option(static TYPE enum NAME shared MAPPING yes no no yes)
qt_commandline_option(static-runtime TYPE boolean NAME static_runtime)
qt_commandline_option(strip TYPE boolean)
qt_commandline_option(sysroot TYPE string)
qt_commandline_option(use-gold-linker TYPE boolean NAME use_gold_linker_alias)
qt_commandline_option(warnings-are-errors
    TYPE boolean
    NAME warnings_are_errors
    CMAKE_VARIABLE WARNINGS_ARE_ERRORS
)
qt_commandline_option(Werror TYPE boolean NAME warnings_are_errors)
qt_commandline_option(widgets TYPE boolean)
qt_commandline_option(xplatform TYPE string CMAKE_VARIABLE QT_QMAKE_TARGET_MKSPEC)
qt_commandline_option(zlib CONTROLS_FEATURE TYPE enum NAME system-zlib MAPPING system yes qt no)
qt_commandline_option(zstd TYPE boolean)
qt_commandline_option(coverage TYPE optionalString VALUES gcov)
qt_commandline_option(ffmpeg-dir TYPE path CMAKE_VARIABLE FFMPEG_DIR)
qt_commandline_option(ffmpeg-deploy TYPE boolean CMAKE_VARIABLE QT_DEPLOY_FFMPEG)
qt_commandline_prefix(D defines)
qt_commandline_prefix(F fpaths)
qt_commandline_prefix(I includes)
qt_commandline_prefix(L lpaths)
qt_commandline_prefix(R rpaths)

function(qt_commandline_cxxstd arg val nextok)
    if("${val}" STREQUAL "")
        qtConfGetNextCommandlineArg(val)
    endif()
    if("${val}" STREQUAL "" OR val MATCHES "^-.*")
        qtConfAddError("Missing argument to command line parameter '${arg}'.")
        return()
    endif()
    if(val MATCHES "(c\\+\\+)?(17|1z)")
        qtConfCommandlineDisableFeature(c++20)
        qtConfCommandlineDisableFeature(c++2b)
        qtConfCommandlineDisableFeature(c++2c)
    elseif(val MATCHES "(c\\+\\+)?(20|2a)")
        qtConfCommandlineEnableFeature(c++20)
        qtConfCommandlineDisableFeature(c++2b)
        qtConfCommandlineDisableFeature(c++2c)
    elseif(val MATCHES "(c\\+\\+)?(23|2b)")
        qtConfCommandlineEnableFeature(c++20)
        qtConfCommandlineEnableFeature(c++2b)
        qtConfCommandlineDisableFeature(c++2c)
    elseif(val MATCHES "(c\\+\\+)?(2c)")
        qtConfCommandlineEnableFeature(c++20)
        qtConfCommandlineEnableFeature(c++2b)
        qtConfCommandlineEnableFeature(c++2c)
    else()
        qtConfAddError("Invalid argument '${val}' to command line parameter '${arg}'")
    endif()
endfunction()

function(qt_commandline_sanitize arg val nextok)
    if("${val}" STREQUAL "")
        qtConfGetNextCommandlineArg(val)
    endif()
    if("${val}" STREQUAL "" OR val MATCHES "^-.*")
        qtConfAddError("Missing argument to command line parameter '${arg}'.")
        return()
    endif()
    if(val STREQUAL "address")
        qtConfCommandlineEnableFeature(sanitize_address)
    elseif(val STREQUAL "thread")
        qtConfCommandlineEnableFeature(sanitize_thread)
    elseif(val STREQUAL "memory")
        qtConfCommandlineEnableFeature(sanitize_memory)
    elseif(val STREQUAL "fuzzer-no-link")
        qtConfCommandlineEnableFeature(sanitize_fuzzer_no_link)
    elseif(val STREQUAL "undefined")
        qtConfCommandlineEnableFeature(sanitize_undefined)
    else()
        qtConfAddError("Invalid argument '${val}' to command line parameter '${arg}'")
    endif()
endfunction()
