/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SVDPOEV_HXX
#define _SVDPOEV_HXX

#include "svx/svxdllapi.h"
#include <svx/svdedtv.hxx>

#include "svx/ipolypolygoneditorcontroller.hxx"

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
//
// @@@@@   @@@@  @@  @@  @@  @@@@@ @@@@@  @@ @@@@@@  @@ @@ @@ @@@@@ @@   @@
// @@  @@ @@  @@ @@  @@  @@  @@    @@  @@ @@   @@    @@ @@ @@ @@    @@   @@
// @@  @@ @@  @@ @@  @@  @@  @@    @@  @@ @@   @@    @@ @@ @@ @@    @@ @ @@
// @@@@@  @@  @@ @@   @@@@   @@@@  @@  @@ @@   @@    @@@@@ @@ @@@@  @@@@@@@
// @@     @@  @@ @@    @@    @@    @@  @@ @@   @@     @@@  @@ @@    @@@@@@@
// @@     @@  @@ @@    @@    @@    @@  @@ @@   @@     @@@  @@ @@    @@@ @@@
// @@      @@@@  @@@@@ @@    @@@@@ @@@@@  @@   @@      @   @@ @@@@@ @@   @@
//
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

class SVX_DLLPUBLIC SdrPolyEditView: public SdrEditView, public IPolyPolygonEditorController
{
	friend class				SdrEditView;

protected:
	BOOL						bSetMarkedPointsSmoothPossible : 1;
	BOOL						bSetMarkedSegmentsKindPossible : 1;

	SdrPathSmoothKind			eMarkedPointsSmooth;
	SdrPathSegmentKind			eMarkedSegmentsKind;

private:
	SVX_DLLPRIVATE void ImpClearVars();
	SVX_DLLPRIVATE void ImpResetPolyPossibilityFlags();
	SVX_DLLPRIVATE void ImpCheckPolyPossibilities();

	// Markierte Punkte kopieren und anstelle der alten markieren
	// ist noch nicht implementiert!
	SVX_DLLPRIVATE void ImpCopyMarkedPoints();
	typedef void (*PPolyTrFunc)(Point&, Point*, Point*, const void*, const void*, const void*, const void*, const void*);
	SVX_DLLPRIVATE void ImpTransformMarkedPoints(PPolyTrFunc pTrFunc, const void* p1=NULL, const void* p2=NULL, const void* p3=NULL, const void* p4=NULL, const void* p5=NULL);

protected:
	// #i71538# make constructors of SdrView sub-components protected to avoid incomplete incarnations which may get casted to SdrView
	SdrPolyEditView(SdrModel* pModel1, OutputDevice* pOut = 0L);
	virtual ~SdrPolyEditView();

public:
	BOOL IsSetMarkedPointsSmoothPossible() const;
	SdrPathSmoothKind GetMarkedPointsSmooth() const;
	void SetMarkedPointsSmooth(SdrPathSmoothKind eKind);

	// Ein PolySegment kann eine Strecke oder eine Bezierkurve sein.
	BOOL IsSetMarkedSegmentsKindPossible() const;
	SdrPathSegmentKind GetMarkedSegmentsKind() const;
	void SetMarkedSegmentsKind(SdrPathSegmentKind eKind);

	// Moeglicherweise ist das Obj hinterher geloescht:
	void DeleteMarkedPoints();
	BOOL IsDeleteMarkedPointsPossible() const;

	void MoveMarkedPoints(const Size& rSiz, bool bCopy=false);
	void ResizeMarkedPoints(const Point& rRef, const Fraction& xFact, const Fraction& yFact, bool bCopy=false);
	void RotateMarkedPoints(const Point& rRef, long nWink, bool bCopy=false);

	// Hierbei entstehen eventuell beliebig viele neue Objekte:
	void RipUpAtMarkedPoints();
	bool IsRipUpAtMarkedPointsPossible() const;

	// Alle markierten Polylines werden zu Polygonen, alle offenen
	// Bezierkurven zu geschlossenen.
	void ShutMarkedObjects();
	void CloseMarkedObjects(BOOL bToggle=FALSE, BOOL bOpen=FALSE); // , long nOpenDistance=0);
	bool IsOpenCloseMarkedObjectsPossible() const;
	SdrObjClosedKind GetMarkedObjectsClosedState() const;

	void CheckPolyPossibilitiesHelper( SdrMark* pM, bool& b1stSmooth, bool& b1stSegm, bool& bCurve, bool& bSmoothFuz, bool& bSegmFuz, basegfx::B2VectorContinuity& eSmooth );
};

#endif //_SVDPOEV_HXX

