/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef SD_CLIENT_VIEW_HXX
#define SD_CLIENT_VIEW_HXX

#include "drawview.hxx"

namespace sd {

class DrawViewShell;

/************************************************************************
|*
|* Die SdClientView wird fuer DrawDocShell::Draw() verwendet
|*
\************************************************************************/

class ClientView 
    : public DrawView
{
public:
	ClientView (
        DrawDocShell* pDocSh, 
        OutputDevice* pOutDev,
        DrawViewShell* pShell);
	virtual ~ClientView (void);

	virtual void CompleteRedraw(OutputDevice* pOutDev, const Region& rReg, sdr::contact::ViewObjectContactRedirector* pRedirector = 0L);

	// Wenn die View kein Invalidate() an den Fenstern durchfuehren soll, muss
	// man diese beiden folgenden Methoden ueberladen und entsprechend anders
	// reagieren.
	virtual void InvalidateOneWin(::Window& rWin);
	virtual void InvalidateOneWin(::Window& rWin, const Rectangle& rRect);
};

} // end of namespace sd

#endif

