/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _XMLOFF_FORMS_CONTROLELEMENT_HXX_
#include "controlelement.hxx"
#endif
namespace binfilter {

//.........................................................................
namespace xmloff
{
//.........................................................................

	//=====================================================================
	//= OControlElement
	//=====================================================================
	//---------------------------------------------------------------------
	const sal_Char* OControlElement::getElementName(ElementType _eType)
	{
		switch (_eType)
		{
			case TEXT: return "text";
			case TEXT_AREA: return "textarea";
			case PASSWORD: return "password";
			case FILE: return "file";
			case FORMATTED_TEXT: return "formatted-text";
			case FIXED_TEXT: return "fixed-text";
			case COMBOBOX: return "combobox";
			case LISTBOX: return "listbox";
			case BUTTON: return "button";
			case IMAGE: return "image";
			case CHECKBOX: return "checkbox";
			case RADIO: return "radio";
			case FRAME: return "frame";
			case IMAGE_FRAME: return "image-frame";
			case HIDDEN: return "hidden";
			case GRID: return "grid";

			default: return "generic-control";
		}
	}

//.........................................................................
}	// namespace xmloff
//.........................................................................


}//end of namespace binfilter
