/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef	_NOTEURL_HXX
#define	_NOTEURL_HXX


#ifndef _SVARRAY_HXX //autogen
#include <bf_svtools/svarray.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SWRECT_HXX
#include "swrect.hxx"
#endif
class MapMode;

namespace binfilter {

class ImageMap;

class SwURLNote
{
	String aURL;
	String aTarget;
	SwRect aRect;
public:
	SwURLNote( const String& rURL, const String& rTarget, const SwRect& rRect )
	: aURL( rURL ), aTarget( rTarget ), aRect( rRect )
	{}
	const String& GetURL() 		const { return aURL; }
	const String& GetTarget() 	const { return aTarget; }
	const SwRect& GetRect() 	const { return aRect; }
	BOOL operator==( const SwURLNote& rSwURLNote ) const
	{ return aRect == rSwURLNote.aRect; }
};

typedef SwURLNote* SwURLNotePtr;
SV_DECL_PTRARR_DEL(SwURLNoteList, SwURLNotePtr, 0, 5)

class SwNoteURL
{
	SwURLNoteList aList;
public:
	SwNoteURL() {}
	USHORT Count() const { return aList.Count(); }
	const SwURLNote& GetURLNote( USHORT nPos ) const
		{ return *aList.GetObject( nPos ); }
};

// globale Variable, in NoteURL.Cxx angelegt
extern SwNoteURL *pNoteURL;


} //namespace binfilter
#endif

