/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Serializer;

public abstract class AbstractSerializer
implements Serializer {
    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? (byte)1 : 0);
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeShort(short s) throws IOException {
        this.writeByte((byte)(s >>> 8));
        this.writeByte((byte)s);
    }

    public void writeChar(char c) throws IOException {
        this.writeShort((short)c);
    }

    public void writeInt(int n) throws IOException {
        this.writeByte((byte)(n >>> 24));
        this.writeByte((byte)(n >>> 16));
        this.writeByte((byte)(n >>> 8));
        this.writeByte((byte)n);
    }

    public void writeLong(long l) throws IOException {
        this.writeByte((byte)(l >>> 56));
        this.writeByte((byte)(l >>> 48));
        this.writeByte((byte)(l >>> 40));
        this.writeByte((byte)(l >>> 32));
        this.writeByte((byte)(l >>> 24));
        this.writeByte((byte)(l >>> 16));
        this.writeByte((byte)(l >>> 8));
        this.writeByte((byte)l);
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToRawIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    public void writeByteArray(byte[] byArray) throws IOException {
        this.writeByteArray(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public void writeByteArray(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeByte(byArray[n + i]);
        }
    }

    public void writeCharArray(char[] cArray) throws IOException {
        this.writeCharArray(cArray, 0, cArray == null ? 0 : cArray.length);
    }

    public void writeCharArray(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(n2);
        for (int i = 0; i < n2; ++i) {
            this.writeChar(cArray[n + i]);
        }
    }

    public void writeIntegerArray(Integer[] integerArray) throws IOException {
        if (integerArray == null || integerArray.length == 0) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(integerArray.length);
        for (int i = 0; i < integerArray.length; ++i) {
            this.writeInt(integerArray[i]);
        }
    }

    public void writeUTF(String string) throws IOException {
        if (string == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        int n = string.length();
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeUTFArray(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        this.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.writeUTF(stringArray[i]);
        }
    }

    public void writeConversation(Conversation conversation) throws IOException {
        if (conversation == null) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        conversation.writeFields(this);
    }

    public abstract void flush() throws IOException;

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public abstract byte readByte() throws IOException;

    public short readShort() throws IOException {
        short s = (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
        return s;
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public int readInt() throws IOException {
        int n = this.readByte() & 0xFF;
        n = n << 8 | this.readByte() & 0xFF;
        n = n << 8 | this.readByte() & 0xFF;
        n = n << 8 | this.readByte() & 0xFF;
        return n;
    }

    public long readLong() throws IOException {
        long l = this.readByte() & 0xFF;
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        l = l << 8 | (long)(this.readByte() & 0xFF);
        return l;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public ByteBuffer readByteBuffer() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        for (int i = 0; i < n; ++i) {
            byteBuffer.put(this.readByte());
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    public byte[] readByteArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        byte[] byArray = new byte[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.readByte();
        }
        return byArray;
    }

    public char[] readCharArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = this.readChar();
        }
        return cArray;
    }

    public Integer[] readIntegerArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = new Integer(this.readInt());
        }
        return integerArray;
    }

    public String readUTF() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.readChar());
        }
        return stringBuffer.toString();
    }

    public String[] readUTFArray() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        int n = this.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readUTF();
        }
        return stringArray;
    }

    public Conversation readConversation() throws IOException {
        if (!this.readBoolean()) {
            return null;
        }
        Conversation conversation = new Conversation();
        conversation.readFields(this);
        return conversation;
    }
}

