/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Arrays;
import sun.security.jca.JCAUtil;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

abstract class DSA
extends SignatureSpi {
    private static final boolean debug = false;
    private DSAParams params;
    private BigInteger presetP;
    private BigInteger presetQ;
    private BigInteger presetG;
    private BigInteger presetY;
    private BigInteger presetX;
    private int[] Kseed;
    private byte[] KseedAsByteArray;
    private int[] previousKseed;
    private SecureRandom signingRandom;
    private static final int round1_kt = 1518500249;
    private static final int round2_kt = 1859775393;
    private static final int round3_kt = -1894007588;
    private static final int round4_kt = -899497514;

    DSA() {
    }

    abstract byte[] getDigest() throws SignatureException;

    abstract void resetDigest();

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("not a DSA private key: " + privateKey);
        }
        DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
        this.presetX = dSAPrivateKey.getX();
        this.presetY = null;
        this.initialize(dSAPrivateKey.getParams());
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("not a DSA public key: " + publicKey);
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.presetY = dSAPublicKey.getY();
        this.presetX = null;
        this.initialize(dSAPublicKey.getParams());
    }

    private void initialize(DSAParams dSAParams) throws InvalidKeyException {
        this.resetDigest();
        this.setParams(dSAParams);
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.generateK(this.presetQ);
        BigInteger bigInteger2 = this.generateR(this.presetP, this.presetQ, this.presetG, bigInteger);
        BigInteger bigInteger3 = this.generateS(this.presetX, this.presetQ, bigInteger2, bigInteger);
        try {
            DerOutputStream derOutputStream = new DerOutputStream(100);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        Object object;
        Object object2;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        try {
            object2 = new DerInputStream(byArray, n, n2);
            object = ((DerInputStream)object2).getSequence(2);
            bigInteger = object[0].getBigInteger();
            bigInteger2 = object[1].getBigInteger();
        }
        catch (IOException iOException) {
            throw new SignatureException("invalid encoding for signature");
        }
        if (bigInteger.signum() < 0) {
            bigInteger = new BigInteger(1, bigInteger.toByteArray());
        }
        if (bigInteger2.signum() < 0) {
            bigInteger2 = new BigInteger(1, bigInteger2.toByteArray());
        }
        if (bigInteger.compareTo(this.presetQ) == -1 && bigInteger2.compareTo(this.presetQ) == -1) {
            object2 = this.generateW(this.presetP, this.presetQ, this.presetG, bigInteger2);
            object = this.generateV(this.presetY, this.presetP, this.presetQ, this.presetG, (BigInteger)object2, bigInteger);
            return ((BigInteger)object).equals(bigInteger);
        }
        throw new SignatureException("invalid signature: out of range values");
    }

    private BigInteger generateR(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger4, bigInteger);
        return bigInteger5.remainder(bigInteger2);
    }

    private BigInteger generateS(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws SignatureException {
        byte[] byArray = this.getDigest();
        BigInteger bigInteger5 = new BigInteger(1, byArray);
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger2);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger3);
        bigInteger7 = bigInteger5.add(bigInteger7);
        bigInteger7 = bigInteger6.multiply(bigInteger7);
        return bigInteger7.remainder(bigInteger2);
    }

    private BigInteger generateW(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        return bigInteger4.modInverse(bigInteger2);
    }

    private BigInteger generateV(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) throws SignatureException {
        byte[] byArray = this.getDigest();
        BigInteger bigInteger7 = new BigInteger(1, byArray);
        bigInteger7 = bigInteger7.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.remainder(bigInteger3);
        BigInteger bigInteger9 = bigInteger6.multiply(bigInteger5).remainder(bigInteger3);
        BigInteger bigInteger10 = bigInteger4.modPow(bigInteger8, bigInteger2);
        BigInteger bigInteger11 = bigInteger.modPow(bigInteger9, bigInteger2);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger11);
        BigInteger bigInteger13 = bigInteger12.remainder(bigInteger2);
        return bigInteger13.remainder(bigInteger3);
    }

    private BigInteger generateK(BigInteger bigInteger) {
        int[] nArray;
        BigInteger bigInteger2 = null;
        if (this.Kseed != null && !Arrays.equals(this.Kseed, this.previousKseed) && (bigInteger2 = this.generateK(this.Kseed, bigInteger)).signum() > 0 && bigInteger2.compareTo(bigInteger) < 0) {
            this.previousKseed = new int[this.Kseed.length];
            System.arraycopy(this.Kseed, 0, this.previousKseed, 0, this.Kseed.length);
            return bigInteger2;
        }
        SecureRandom secureRandom = this.getSigningRandom();
        do {
            nArray = new int[5];
            for (int i = 0; i < 5; ++i) {
                nArray[i] = secureRandom.nextInt();
            }
        } while ((bigInteger2 = this.generateK(nArray, bigInteger)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0);
        this.previousKseed = new int[nArray.length];
        System.arraycopy(nArray, 0, this.previousKseed, 0, nArray.length);
        return bigInteger2;
    }

    private SecureRandom getSigningRandom() {
        if (this.signingRandom == null) {
            this.signingRandom = this.appRandom != null ? this.appRandom : JCAUtil.getSecureRandom();
        }
        return this.signingRandom;
    }

    private BigInteger generateK(int[] nArray, BigInteger bigInteger) {
        int[] nArray2 = new int[]{-271733879, -1732584194, 271733878, -1009589776, 1732584193};
        int[] nArray3 = DSA.SHA_7(nArray, nArray2);
        byte[] byArray = new byte[nArray3.length * 4];
        for (int i = 0; i < nArray3.length; ++i) {
            int n = nArray3[i];
            for (int j = 0; j < 4; ++j) {
                byArray[i * 4 + j] = (byte)(n >>> 24 - j * 8);
            }
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray).mod(bigInteger);
        return bigInteger2;
    }

    static int[] SHA_7(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int[] nArray3 = new int[80];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        int n3 = 0;
        for (n2 = 16; n2 <= 79; ++n2) {
            n3 = nArray3[n2 - 3] ^ nArray3[n2 - 8] ^ nArray3[n2 - 14] ^ nArray3[n2 - 16];
            nArray3[n2] = n3 << 1 | n3 >>> 31;
        }
        n2 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray2[2];
        int n6 = nArray2[3];
        int n7 = nArray2[4];
        for (n = 0; n < 20; ++n) {
            n3 = (n2 << 5 | n2 >>> 27) + (n4 & n5 | ~n4 & n6) + n7 + nArray3[n] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n2;
            n2 = n3;
        }
        for (n = 20; n < 40; ++n) {
            n3 = (n2 << 5 | n2 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n2;
            n2 = n3;
        }
        for (n = 40; n < 60; ++n) {
            n3 = (n2 << 5 | n2 >>> 27) + (n4 & n5 | n4 & n6 | n5 & n6) + n7 + nArray3[n] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n2;
            n2 = n3;
        }
        for (n = 60; n < 80; ++n) {
            n3 = (n2 << 5 | n2 >>> 27) + (n4 ^ n5 ^ n6) + n7 + nArray3[n] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = n4 << 30 | n4 >>> 2;
            n4 = n2;
            n2 = n3;
        }
        int[] nArray4 = new int[]{nArray2[0] + n2, nArray2[1] + n4, nArray2[2] + n5, nArray2[3] + n6, nArray2[4] + n7};
        return nArray4;
    }

    @Deprecated
    protected void engineSetParameter(String string, Object object) {
        if (string.equals("KSEED")) {
            if (!(object instanceof byte[])) {
                DSA.debug("unrecognized param: " + string);
                throw new InvalidParameterException("Kseed not a byte array");
            }
        } else {
            throw new InvalidParameterException("invalid parameter");
        }
        this.Kseed = this.byteArray2IntArray((byte[])object);
        this.KseedAsByteArray = (byte[])object;
    }

    @Deprecated
    protected Object engineGetParameter(String string) {
        if (string.equals("KSEED")) {
            return this.KseedAsByteArray;
        }
        return null;
    }

    private void setParams(DSAParams dSAParams) throws InvalidKeyException {
        if (dSAParams == null) {
            throw new InvalidKeyException("DSA public key lacks parameters");
        }
        this.params = dSAParams;
        this.presetP = dSAParams.getP();
        this.presetQ = dSAParams.getQ();
        this.presetG = dSAParams.getG();
    }

    public String toString() {
        String string = "DSA Signature";
        if (this.presetP != null && this.presetQ != null && this.presetG != null) {
            string = string + "\n\tp: " + Debug.toHexString(this.presetP);
            string = string + "\n\tq: " + Debug.toHexString(this.presetQ);
            string = string + "\n\tg: " + Debug.toHexString(this.presetG);
        } else {
            string = string + "\n\t P, Q or G not initialized.";
        }
        if (this.presetY != null) {
            string = string + "\n\ty: " + Debug.toHexString(this.presetY);
        }
        if (this.presetY == null && this.presetX == null) {
            string = string + "\n\tUNINIIALIZED";
        }
        return string;
    }

    private int[] byteArray2IntArray(byte[] byArray) {
        byte[] byArray2;
        int n = 0;
        int n2 = byArray.length % 4;
        switch (n2) {
            case 3: {
                byArray2 = new byte[byArray.length + 1];
                break;
            }
            case 2: {
                byArray2 = new byte[byArray.length + 2];
                break;
            }
            case 1: {
                byArray2 = new byte[byArray.length + 3];
                break;
            }
            default: {
                byArray2 = new byte[byArray.length + 0];
            }
        }
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int[] nArray = new int[byArray2.length / 4];
        for (int i = 0; i < byArray2.length; i += 4) {
            nArray[n] = byArray2[i + 3] & 0xFF;
            int n3 = n;
            nArray[n3] = nArray[n3] | byArray2[i + 2] << 8 & 0xFF00;
            int n4 = n;
            nArray[n4] = nArray[n4] | byArray2[i + 1] << 16 & 0xFF0000;
            int n5 = n++;
            nArray[n5] = nArray[n5] | byArray2[i + 0] << 24 & 0xFF000000;
        }
        return nArray;
    }

    private static void debug(Exception exception) {
    }

    private static void debug(String string) {
    }

    public static final class RawDSA
    extends DSA {
        private static final int SHA1_LEN = 20;
        private final byte[] digestBuffer = new byte[20];
        private int ofs;

        protected void engineUpdate(byte by) {
            if (this.ofs == 20) {
                this.ofs = 21;
                return;
            }
            this.digestBuffer[this.ofs++] = by;
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            if (this.ofs + n2 > 20) {
                this.ofs = 21;
                return;
            }
            System.arraycopy(byArray, n, this.digestBuffer, this.ofs, n2);
            this.ofs += n2;
        }

        byte[] getDigest() throws SignatureException {
            if (this.ofs != 20) {
                throw new SignatureException("Data for RawDSA must be exactly 20 bytes long");
            }
            this.ofs = 0;
            return this.digestBuffer;
        }

        void resetDigest() {
            this.ofs = 0;
        }
    }

    public static final class SHA1withDSA
    extends DSA {
        private final MessageDigest dataSHA = MessageDigest.getInstance("SHA-1");

        protected void engineUpdate(byte by) {
            this.dataSHA.update(by);
        }

        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.dataSHA.update(byArray, n, n2);
        }

        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.dataSHA.update(byteBuffer);
        }

        byte[] getDigest() {
            return this.dataSHA.digest();
        }

        void resetDigest() {
            this.dataSHA.reset();
        }
    }
}

