/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;
import sun.text.SupplementaryCharacterData;

class RuleBasedBreakIterator
extends BreakIterator {
    protected static final byte IGNORE = -1;
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    static final byte[] LABEL = new byte[]{66, 73, 100, 97, 116, 97, 0};
    static final int LABEL_LENGTH = LABEL.length;
    static final byte supportedVersion = 1;
    private static final int HEADER_LENGTH = 36;
    private static final int BMP_INDICES_LENGTH = 512;
    private CompactByteArray charCategoryTable = null;
    private SupplementaryCharacterData supplementaryCharCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private byte[] additionalData = null;
    private int numCategories;
    private CharacterIterator text = null;
    private long checksum;
    private int cachedLastKnownBreak = -1;

    public RuleBasedBreakIterator(String string) throws IOException, MissingResourceException {
        this.readTables(string);
    }

    protected void readTables(String string) throws IOException, MissingResourceException {
        byte[] byArray = this.readFile(string);
        int n = BreakIterator.getInt(byArray, 0);
        int n2 = BreakIterator.getInt(byArray, 4);
        int n3 = BreakIterator.getInt(byArray, 8);
        int n4 = BreakIterator.getInt(byArray, 12);
        int n5 = BreakIterator.getInt(byArray, 16);
        int n6 = BreakIterator.getInt(byArray, 20);
        int n7 = BreakIterator.getInt(byArray, 24);
        this.checksum = BreakIterator.getLong(byArray, 28);
        this.stateTable = new short[n];
        int n8 = 36;
        int n9 = 0;
        while (n9 < n) {
            this.stateTable[n9] = BreakIterator.getShort(byArray, n8);
            ++n9;
            n8 += 2;
        }
        this.backwardsStateTable = new short[n2];
        n9 = 0;
        while (n9 < n2) {
            this.backwardsStateTable[n9] = BreakIterator.getShort(byArray, n8);
            ++n9;
            n8 += 2;
        }
        this.endStates = new boolean[n3];
        n9 = 0;
        while (n9 < n3) {
            this.endStates[n9] = byArray[n8] == 1;
            ++n9;
            ++n8;
        }
        this.lookaheadStates = new boolean[n4];
        n9 = 0;
        while (n9 < n4) {
            this.lookaheadStates[n9] = byArray[n8] == 1;
            ++n9;
            ++n8;
        }
        short[] sArray = new short[512];
        int n10 = 0;
        while (n10 < 512) {
            sArray[n10] = BreakIterator.getShort(byArray, n8);
            ++n10;
            n8 += 2;
        }
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n8, byArray2, 0, n5);
        n8 += n5;
        this.charCategoryTable = new CompactByteArray(sArray, byArray2);
        int[] nArray = new int[n6];
        int n11 = 0;
        while (n11 < n6) {
            nArray[n11] = BreakIterator.getInt(byArray, n8);
            ++n11;
            n8 += 4;
        }
        this.supplementaryCharCategoryTable = new SupplementaryCharacterData(nArray);
        if (n7 > 0) {
            this.additionalData = new byte[n7];
            System.arraycopy(byArray, n8, this.additionalData, 0, n7);
        }
        this.numCategories = this.stateTable.length / this.endStates.length;
    }

    protected byte[] readFile(final String string) throws IOException, MissingResourceException {
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = (BufferedInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new BufferedInputStream(this.getClass().getResourceAsStream("/sun/text/resources/" + string));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new InternalError(privilegedActionException.toString());
        }
        int n = 0;
        int n2 = LABEL_LENGTH + 5;
        byte[] byArray = new byte[n2];
        if (bufferedInputStream.read(byArray) != n2) {
            throw new MissingResourceException("Wrong header length", string, "");
        }
        int n3 = 0;
        while (n3 < LABEL_LENGTH) {
            if (byArray[n] != LABEL[n]) {
                throw new MissingResourceException("Wrong magic number", string, "");
            }
            ++n3;
            ++n;
        }
        if (byArray[n] != 1) {
            throw new MissingResourceException("Unsupported version(" + byArray[n] + ")", string, "");
        }
        if (bufferedInputStream.read(byArray = new byte[n2 = BreakIterator.getInt(byArray, ++n)]) != n2) {
            throw new MissingResourceException("Wrong data length", string, "");
        }
        bufferedInputStream.close();
        return byArray;
    }

    byte[] getAdditionalData() {
        return this.additionalData;
    }

    void setAdditionalData(byte[] byArray) {
        this.additionalData = byArray;
    }

    public Object clone() {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)super.clone();
        if (this.text != null) {
            ruleBasedBreakIterator.text = (CharacterIterator)this.text.clone();
        }
        return ruleBasedBreakIterator;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)object;
            if (this.checksum != ruleBasedBreakIterator.checksum) {
                return false;
            }
            if (this.text == null) {
                return ruleBasedBreakIterator.text == null;
            }
            return this.text.equals(ruleBasedBreakIterator.text);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append("checksum=0x" + Long.toHexString(this.checksum));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)this.checksum;
    }

    public int first() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.first();
        return characterIterator.getIndex();
    }

    public int last() {
        CharacterIterator characterIterator = this.getText();
        characterIterator.setIndex(characterIterator.getEndIndex());
        return characterIterator.getIndex();
    }

    public int next(int n) {
        int n2 = this.current();
        while (n > 0) {
            n2 = this.handleNext();
            --n;
        }
        while (n < 0) {
            n2 = this.previous();
            ++n;
        }
        return n2;
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        CharacterIterator characterIterator = this.getText();
        if (this.current() == characterIterator.getBeginIndex()) {
            return -1;
        }
        int n = this.cachedLastKnownBreak;
        int n2 = this.current();
        if (n >= n2 || n <= -1) {
            this.getPrevious();
            n = this.handlePrevious();
        } else {
            characterIterator.setIndex(n);
        }
        int n3 = n;
        while (n3 != -1 && n3 < n2) {
            n = n3;
            n3 = this.handleNext();
        }
        characterIterator.setIndex(n);
        this.cachedLastKnownBreak = n;
        return n;
    }

    private int getPrevious() {
        char c = this.text.previous();
        if (Character.isLowSurrogate(c) && this.text.getIndex() > this.text.getBeginIndex()) {
            char c2 = this.text.previous();
            if (Character.isHighSurrogate(c2)) {
                return Character.toCodePoint(c2, c);
            }
            this.text.next();
        }
        return c;
    }

    int getCurrent() {
        char c = this.text.current();
        if (Character.isHighSurrogate(c) && this.text.getIndex() < this.text.getEndIndex()) {
            char c2 = this.text.next();
            this.text.previous();
            if (Character.isLowSurrogate(c2)) {
                return Character.toCodePoint(c, c2);
            }
        }
        return c;
    }

    private int getCurrentCodePointCount() {
        char c = this.text.current();
        if (Character.isHighSurrogate(c) && this.text.getIndex() < this.text.getEndIndex()) {
            char c2 = this.text.next();
            this.text.previous();
            if (Character.isLowSurrogate(c2)) {
                return 2;
            }
        }
        return 1;
    }

    int getNext() {
        int n;
        int n2 = this.text.getIndex();
        if (n2 == (n = this.text.getEndIndex()) || (n2 += this.getCurrentCodePointCount()) >= n) {
            return 65535;
        }
        this.text.setIndex(n2);
        return this.getCurrent();
    }

    private int getNextIndex() {
        int n;
        int n2 = this.text.getIndex() + this.getCurrentCodePointCount();
        if (n2 > (n = this.text.getEndIndex())) {
            return n;
        }
        return n2;
    }

    protected static final void checkOffset(int n, CharacterIterator characterIterator) {
        if (n < characterIterator.getBeginIndex() || n > characterIterator.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    public int following(int n) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n, characterIterator);
        characterIterator.setIndex(n);
        if (n == characterIterator.getBeginIndex()) {
            this.cachedLastKnownBreak = this.handleNext();
            return this.cachedLastKnownBreak;
        }
        int n2 = this.cachedLastKnownBreak;
        if (n2 >= n || n2 <= -1) {
            n2 = this.handlePrevious();
        } else {
            characterIterator.setIndex(n2);
        }
        while (n2 != -1 && n2 <= n) {
            n2 = this.handleNext();
        }
        this.cachedLastKnownBreak = n2;
        return n2;
    }

    public int preceding(int n) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n, characterIterator);
        characterIterator.setIndex(n);
        return this.previous();
    }

    public boolean isBoundary(int n) {
        CharacterIterator characterIterator = this.getText();
        RuleBasedBreakIterator.checkOffset(n, characterIterator);
        if (n == characterIterator.getBeginIndex()) {
            return true;
        }
        return this.following(n - 1) == n;
    }

    public int current() {
        return this.getText().getIndex();
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    public void setText(CharacterIterator characterIterator) {
        boolean bl;
        int n = characterIterator.getEndIndex();
        try {
            characterIterator.setIndex(n);
            bl = characterIterator.getIndex() == n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        this.text = bl ? characterIterator : new SafeCharIterator(characterIterator);
        this.text.first();
        this.cachedLastKnownBreak = -1;
    }

    protected int handleNext() {
        CharacterIterator characterIterator = this.getText();
        if (characterIterator.getIndex() == characterIterator.getEndIndex()) {
            return -1;
        }
        int n = this.getNextIndex();
        int n2 = 0;
        int n3 = 1;
        int n4 = this.getCurrent();
        while (n4 != 65535 && n3 != 0) {
            int n5 = this.lookupCategory(n4);
            if (n5 != -1) {
                n3 = this.lookupState(n3, n5);
            }
            if (this.lookaheadStates[n3]) {
                if (this.endStates[n3]) {
                    n = n2;
                } else {
                    n2 = this.getNextIndex();
                }
            } else if (this.endStates[n3]) {
                n = this.getNextIndex();
            }
            n4 = this.getNext();
        }
        if (n4 == 65535 && n2 == characterIterator.getEndIndex()) {
            n = n2;
        }
        characterIterator.setIndex(n);
        return n;
    }

    protected int handlePrevious() {
        CharacterIterator characterIterator = this.getText();
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getCurrent();
        while (n4 != 65535 && n != 0) {
            n3 = n2;
            n2 = this.lookupCategory(n4);
            if (n2 != -1) {
                n = this.lookupBackwardState(n, n2);
            }
            n4 = this.getPrevious();
        }
        if (n4 != 65535) {
            if (n3 != -1) {
                this.getNext();
                this.getNext();
            } else {
                this.getNext();
            }
        }
        return characterIterator.getIndex();
    }

    protected int lookupCategory(int n) {
        if (n < 65536) {
            return this.charCategoryTable.elementAt((char)n);
        }
        return this.supplementaryCharCategoryTable.getValue(n);
    }

    protected int lookupState(int n, int n2) {
        return this.stateTable[n * this.numCategories + n2];
    }

    protected int lookupBackwardState(int n, int n2) {
        return this.backwardsStateTable[n * this.numCategories + n2];
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        SafeCharIterator(CharacterIterator characterIterator) {
            this.base = characterIterator;
            this.rangeStart = characterIterator.getBeginIndex();
            this.rangeLimit = characterIterator.getEndIndex();
            this.currentIndex = characterIterator.getIndex();
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char setIndex(int n) {
            if (n < this.rangeStart || n > this.rangeLimit) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.currentIndex = n;
            return this.current();
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public Object clone() {
            CharacterIterator characterIterator;
            SafeCharIterator safeCharIterator = null;
            try {
                safeCharIterator = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error("Clone not supported: " + cloneNotSupportedException);
            }
            safeCharIterator.base = characterIterator = (CharacterIterator)this.base.clone();
            return safeCharIterator;
        }
    }
}

