/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.XmlErrorHandler;
import com.sun.rowset.internal.XmlReaderContentHandler;
import com.sun.rowset.internal.XmlResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.XmlReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class WebRowSetXmlReader
implements XmlReader,
Serializable {
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = -9127058392819008014L;

    public WebRowSetXmlReader() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void readXML(WebRowSet webRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            XmlReaderContentHandler xmlReaderContentHandler = new XmlReaderContentHandler(webRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new XmlResolver());
            xMLReader.setContentHandler(xmlReaderContentHandler);
            xMLReader.setErrorHandler(xmlErrorHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.parseerr").toString(), sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getSystemId()));
            sAXParseException.printStackTrace();
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw new SQLException(exception.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException(this.resBundle.handleGetObject("wrsxmlreader.invalidcp").toString());
        }
        catch (Throwable throwable) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.readxml").toString(), throwable.getMessage()));
        }
    }

    public void readXML(WebRowSet webRowSet, InputStream inputStream) throws SQLException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
            XmlReaderContentHandler xmlReaderContentHandler = new XmlReaderContentHandler(webRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setEntityResolver(new XmlResolver());
            xMLReader.setContentHandler(xmlReaderContentHandler);
            xMLReader.setErrorHandler(xmlErrorHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.parseerr").toString(), sAXParseException.getLineNumber(), sAXParseException.getSystemId()));
            System.out.println("   " + sAXParseException.getMessage());
            sAXParseException.printStackTrace();
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            throw new SQLException(exception.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException(this.resBundle.handleGetObject("wrsxmlreader.invalidcp").toString());
        }
        catch (Throwable throwable) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlreader.readxml").toString(), throwable.getMessage()));
        }
    }

    public void readData(RowSetInternal rowSetInternal) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

