/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortInfo
implements WSPortInfo {
    @NotNull
    private final WSServiceDelegate owner;
    @NotNull
    public final QName portName;
    @NotNull
    public final EndpointAddress targetEndpoint;
    @NotNull
    public final BindingID bindingId;
    @Nullable
    public final WSDLPort portModel;

    public PortInfo(WSServiceDelegate wSServiceDelegate, EndpointAddress endpointAddress, QName qName, BindingID bindingID) {
        this.owner = wSServiceDelegate;
        this.targetEndpoint = endpointAddress;
        this.portName = qName;
        this.bindingId = bindingID;
        this.portModel = this.getPortModel(wSServiceDelegate, qName);
    }

    public PortInfo(@NotNull WSServiceDelegate wSServiceDelegate, @NotNull WSDLPort wSDLPort) {
        this.owner = wSServiceDelegate;
        this.targetEndpoint = wSDLPort.getAddress();
        this.portName = wSDLPort.getName();
        this.bindingId = wSDLPort.getBinding().getBindingId();
        this.portModel = wSDLPort;
    }

    public BindingImpl createBinding(WebServiceFeature[] webServiceFeatureArray, Class<?> clazz) {
        WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(webServiceFeatureArray);
        if (this.portModel != null) {
            webServiceFeatureList.mergeFeatures(this.portModel, clazz == null, false);
        }
        for (WebServiceFeature webServiceFeature : this.owner.serviceInterceptor.preCreateBinding(this, clazz, webServiceFeatureList)) {
            webServiceFeatureList.add(webServiceFeature);
        }
        BindingImpl bindingImpl = BindingImpl.create(this.bindingId, webServiceFeatureList.toArray());
        this.owner.getHandlerConfigurator().configureHandlers(this, bindingImpl);
        return bindingImpl;
    }

    private WSDLPort getPortModel(WSServiceDelegate wSServiceDelegate, QName qName) {
        if (wSServiceDelegate.getWsdlService() != null) {
            Iterable<WSDLPortImpl> iterable = wSServiceDelegate.getWsdlService().getPorts();
            for (WSDLPortImpl wSDLPortImpl : iterable) {
                if (!wSDLPortImpl.getName().equals(qName)) continue;
                return wSDLPortImpl;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public WSDLPort getPort() {
        return this.portModel;
    }

    @Override
    @NotNull
    public WSService getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    @NotNull
    public EndpointAddress getEndpointAddress() {
        return this.targetEndpoint;
    }

    @Override
    public QName getServiceName() {
        return this.owner.getServiceName();
    }

    @Override
    public QName getPortName() {
        return this.portName;
    }

    @Override
    public String getBindingID() {
        return this.bindingId.toString();
    }
}

