/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.activation;

import com.sun.corba.se.impl.activation.CommandHandler;
import com.sun.corba.se.impl.activation.ServerTool;
import com.sun.corba.se.impl.orbutil.CorbaResourceUtil;
import com.sun.corba.se.spi.activation.ActivatorHelper;
import com.sun.corba.se.spi.activation.RepositoryHelper;
import com.sun.corba.se.spi.activation.ServerHeldDown;
import com.sun.corba.se.spi.activation.ServerNotRegistered;
import java.io.PrintStream;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.IDLEntity;

class UnRegisterServer
implements CommandHandler {
    static final int illegalServerId = -1;

    UnRegisterServer() {
    }

    public String getCommandName() {
        return "unregister";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl) {
        if (!bl) {
            printStream.println(CorbaResourceUtil.getText("servertool.unregister"));
        } else {
            printStream.println(CorbaResourceUtil.getText("servertool.unregister1"));
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n = -1;
        try {
            IDLEntity iDLEntity;
            if (stringArray.length == 2) {
                if (stringArray[0].equals("-serverid")) {
                    n = Integer.valueOf(stringArray[1]);
                } else if (stringArray[0].equals("-applicationName")) {
                    n = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
                }
            }
            if (n == -1) {
                return true;
            }
            try {
                iDLEntity = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
                iDLEntity.uninstall(n);
            }
            catch (ServerHeldDown serverHeldDown) {
                // empty catch block
            }
            iDLEntity = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            iDLEntity.unregisterServer(n);
            printStream.println(CorbaResourceUtil.getText("servertool.unregister2"));
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println(CorbaResourceUtil.getText("servertool.nosuchserver"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

