/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import sun.jkernel.StandaloneSHA;

public abstract class StandaloneMessageDigest {
    public static final boolean debug = false;
    private String algorithm;
    private static final int INITIAL = 0;
    private static final int IN_PROGRESS = 1;
    private int state = 0;
    private byte[] oneByte;
    private final int digestLength;
    private final int blockSize;
    final byte[] buffer;
    private int bufOfs;
    long bytesProcessed;
    static final byte[] padding = new byte[136];

    private StandaloneMessageDigest() {
        this.digestLength = 0;
        this.blockSize = 0;
        this.algorithm = null;
        this.buffer = null;
    }

    public static StandaloneMessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        if (!string.equals("SHA-1")) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
        return new StandaloneSHA();
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("No input buffer given");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Input buffer too short");
        }
        this.engineUpdate(byArray, n, n2);
        this.state = 1;
    }

    public byte[] digest() {
        byte[] byArray = this.engineDigest();
        this.state = 0;
        return byArray;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
        this.state = 0;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    StandaloneMessageDigest(String string, int n, int n2) {
        this.algorithm = string;
        this.digestLength = n;
        this.blockSize = n2;
        this.buffer = new byte[n2];
    }

    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    protected final void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    protected final void engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.bytesProcessed += (long)n2;
        if (this.bufOfs != 0) {
            int n3 = Math.min(n2, this.blockSize - this.bufOfs);
            System.arraycopy(byArray, n, this.buffer, this.bufOfs, n3);
            this.bufOfs += n3;
            n += n3;
            n2 -= n3;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        while (n2 >= this.blockSize) {
            this.implCompress(byArray, n);
            n2 -= this.blockSize;
            n += this.blockSize;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.bufOfs = n2;
        }
    }

    protected final void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
    }

    protected final byte[] engineDigest() throws ProviderException {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (ProviderException)new ProviderException("Internal error").initCause(digestException);
        }
        return byArray;
    }

    protected final int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests");
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new DigestException("Buffer too short to store digest");
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(byArray, n);
        this.bytesProcessed = -1L;
        return this.digestLength;
    }

    abstract void implCompress(byte[] var1, int var2);

    abstract void implDigest(byte[] var1, int var2);

    abstract void implReset();

    static {
        StandaloneMessageDigest.padding[0] = -128;
    }
}

