/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleDataMetaInfo;
import sun.util.resources.OpenListResourceBundle;

public class LocaleData {
    private static final String localeDataJarName = "localedata.jar";

    public static Locale[] getAvailableLocales() {
        return (Locale[])AvailableLocales.localeList.clone();
    }

    public static ResourceBundle getCalendarData(Locale locale) {
        return LocaleData.getBundle("sun.util.resources.CalendarData", locale);
    }

    public static ResourceBundle getCurrencyNames(Locale locale) {
        return LocaleData.getBundle("sun.util.resources.CurrencyNames", locale);
    }

    public static OpenListResourceBundle getLocaleNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.LocaleNames", locale);
    }

    public static OpenListResourceBundle getTimeZoneNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle("sun.util.resources.TimeZoneNames", locale);
    }

    public static ResourceBundle getCollationData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.CollationData", locale);
    }

    public static ResourceBundle getDateFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    public static ResourceBundle getNumberFormatData(Locale locale) {
        return LocaleData.getBundle("sun.text.resources.FormatData", locale);
    }

    private static ResourceBundle getBundle(final String string, final Locale locale) {
        return (ResourceBundle)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResourceBundle.getBundle(string, locale, LocaleDataResourceBundleControl.getRBControlInstance());
            }
        });
    }

    private static boolean isNonEuroLangSupported() {
        String string = File.separator;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("java.home")) + string + "lib" + string + "ext" + string + localeDataJarName;
        final File file = new File(string2);
        boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.exists();
            }
        });
        return bl;
    }

    private static Locale[] createLocaleList() {
        String string = LocaleDataMetaInfo.getSupportedLocaleString("sun.text.resources.FormatData");
        if (string.length() == 0) {
            return null;
        }
        int n = string.indexOf("|");
        StringTokenizer stringTokenizer = null;
        stringTokenizer = LocaleData.isNonEuroLangSupported() ? new StringTokenizer(string.substring(0, n) + string.substring(n + 1)) : new StringTokenizer(string.substring(0, n));
        Locale[] localeArray = new Locale[stringTokenizer.countTokens()];
        for (int i = 0; i < localeArray.length; ++i) {
            String string2 = stringTokenizer.nextToken();
            int n2 = 0;
            int n3 = string2.indexOf(95);
            String string3 = "";
            String string4 = "";
            String string5 = "";
            if (n3 == -1) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, n3);
                n2 = string2.indexOf(95, n3 + 1);
                if (n2 == -1) {
                    string4 = string2.substring(n3 + 1);
                } else {
                    string4 = string2.substring(n3 + 1, n2);
                    if (n2 < string2.length()) {
                        string5 = string2.substring(n2 + 1);
                    }
                }
            }
            localeArray[i] = new Locale(string3, string4, string5);
        }
        return localeArray;
    }

    static /* synthetic */ Locale[] access$000() {
        return LocaleData.createLocaleList();
    }

    private static class AvailableLocales {
        static final Locale[] localeList = LocaleData.access$000();

        private AvailableLocales() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocaleDataResourceBundleControl
    extends ResourceBundle.Control {
        private static LocaleDataResourceBundleControl rbControlInstance = new LocaleDataResourceBundleControl();

        LocaleDataResourceBundleControl() {
        }

        public static LocaleDataResourceBundleControl getRBControlInstance() {
            return rbControlInstance;
        }

        @Override
        public List<Locale> getCandidateLocales(String string, Locale locale) {
            List<Locale> list = super.getCandidateLocales(string, locale);
            String string2 = LocaleDataMetaInfo.getSupportedLocaleString(string);
            if (string2.length() == 0) {
                return list;
            }
            Iterator<Locale> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next().toString();
                if (string3.length() == 0 || string2.indexOf(" " + string3 + " ") != -1) continue;
                iterator.remove();
            }
            return list;
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }
}

