/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowFilter<M, I> {
    private static void checkIndices(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] >= 0) continue;
            throw new IllegalArgumentException("Index must be >= 0");
        }
    }

    public static <M, I> RowFilter<M, I> regexFilter(String string, int ... nArray) {
        return new RegexFilter(Pattern.compile(string), nArray);
    }

    public static <M, I> RowFilter<M, I> dateFilter(ComparisonType comparisonType, Date date, int ... nArray) {
        return new DateFilter(comparisonType, date.getTime(), nArray);
    }

    public static <M, I> RowFilter<M, I> numberFilter(ComparisonType comparisonType, Number number, int ... nArray) {
        return new NumberFilter(comparisonType, number, nArray);
    }

    public static <M, I> RowFilter<M, I> orFilter(Iterable<? extends RowFilter<? super M, ? super I>> iterable) {
        return new OrFilter(iterable);
    }

    public static <M, I> RowFilter<M, I> andFilter(Iterable<? extends RowFilter<? super M, ? super I>> iterable) {
        return new AndFilter(iterable);
    }

    public static <M, I> RowFilter<M, I> notFilter(RowFilter<M, I> rowFilter) {
        return new NotFilter<M, I>(rowFilter);
    }

    public abstract boolean include(Entry<? extends M, ? extends I> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndFilter<M, I>
    extends OrFilter<M, I> {
        AndFilter(Iterable<? extends RowFilter<? super M, ? super I>> iterable) {
            super(iterable);
        }

        @Override
        public boolean include(Entry<? extends M, ? extends I> entry) {
            for (RowFilter rowFilter : this.filters) {
                if (rowFilter.include(entry)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonType {
        BEFORE,
        AFTER,
        EQUAL,
        NOT_EQUAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateFilter
    extends GeneralFilter {
        private long date;
        private ComparisonType type;

        DateFilter(ComparisonType comparisonType, long l, int[] nArray) {
            super(nArray);
            if (comparisonType == null) {
                throw new IllegalArgumentException("type must be non-null");
            }
            this.type = comparisonType;
            this.date = l;
        }

        @Override
        protected boolean include(Entry<? extends Object, ? extends Object> entry, int n) {
            Object object = entry.getValue(n);
            if (object instanceof Date) {
                long l = ((Date)object).getTime();
                switch (this.type) {
                    case BEFORE: {
                        return l < this.date;
                    }
                    case AFTER: {
                        return l > this.date;
                    }
                    case EQUAL: {
                        return l == this.date;
                    }
                    case NOT_EQUAL: {
                        return l != this.date;
                    }
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry<M, I> {
        public abstract M getModel();

        public abstract int getValueCount();

        public abstract Object getValue(int var1);

        public String getStringValue(int n) {
            Object object = this.getValue(n);
            return object == null ? "" : object.toString();
        }

        public abstract I getIdentifier();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class GeneralFilter
    extends RowFilter<Object, Object> {
        private int[] columns;

        GeneralFilter(int[] nArray) {
            RowFilter.checkIndices(nArray);
            this.columns = nArray;
        }

        @Override
        public boolean include(Entry<? extends Object, ? extends Object> entry) {
            int n = entry.getValueCount();
            if (this.columns.length > 0) {
                for (int i = this.columns.length - 1; i >= 0; --i) {
                    int n2 = this.columns[i];
                    if (n2 >= n || !this.include(entry, n2)) continue;
                    return true;
                }
            } else {
                while (--n >= 0) {
                    if (!this.include(entry, n)) continue;
                    return true;
                }
            }
            return false;
        }

        protected abstract boolean include(Entry<? extends Object, ? extends Object> var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotFilter<M, I>
    extends RowFilter<M, I> {
        private RowFilter<M, I> filter;

        NotFilter(RowFilter<M, I> rowFilter) {
            if (rowFilter == null) {
                throw new IllegalArgumentException("filter must be non-null");
            }
            this.filter = rowFilter;
        }

        @Override
        public boolean include(Entry<? extends M, ? extends I> entry) {
            return !this.filter.include(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberFilter
    extends GeneralFilter {
        private boolean isComparable;
        private Number number;
        private ComparisonType type;

        NumberFilter(ComparisonType comparisonType, Number number, int[] nArray) {
            super(nArray);
            if (comparisonType == null || number == null) {
                throw new IllegalArgumentException("type and number must be non-null");
            }
            this.type = comparisonType;
            this.number = number;
            this.isComparable = number instanceof Comparable;
        }

        @Override
        protected boolean include(Entry<? extends Object, ? extends Object> entry, int n) {
            Object object = entry.getValue(n);
            if (object instanceof Number) {
                boolean bl = true;
                Class<?> clazz = object.getClass();
                int n2 = this.number.getClass() == clazz && this.isComparable ? ((Comparable)((Object)this.number)).compareTo(object) : this.longCompare((Number)object);
                switch (this.type) {
                    case BEFORE: {
                        return n2 > 0;
                    }
                    case AFTER: {
                        return n2 < 0;
                    }
                    case EQUAL: {
                        return n2 == 0;
                    }
                    case NOT_EQUAL: {
                        return n2 != 0;
                    }
                }
            }
            return false;
        }

        private int longCompare(Number number) {
            long l = this.number.longValue() - number.longValue();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrFilter<M, I>
    extends RowFilter<M, I> {
        List<RowFilter<? super M, ? super I>> filters = new ArrayList<RowFilter<? super M, ? super I>>();

        OrFilter(Iterable<? extends RowFilter<? super M, ? super I>> iterable) {
            for (RowFilter<M, I> rowFilter : iterable) {
                if (rowFilter == null) {
                    throw new IllegalArgumentException("Filter must be non-null");
                }
                this.filters.add(rowFilter);
            }
        }

        @Override
        public boolean include(Entry<? extends M, ? extends I> entry) {
            for (RowFilter<? extends M, ? extends I> rowFilter : this.filters) {
                if (!rowFilter.include(entry)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegexFilter
    extends GeneralFilter {
        private Matcher matcher;

        RegexFilter(Pattern pattern, int[] nArray) {
            super(nArray);
            if (pattern == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matcher = pattern.matcher("");
        }

        @Override
        protected boolean include(Entry<? extends Object, ? extends Object> entry, int n) {
            this.matcher.reset(entry.getStringValue(n));
            return this.matcher.find();
        }
    }
}

