/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class InflaterOutputStream
extends FilterOutputStream {
    protected final Inflater inf;
    protected final byte[] buf;
    private final byte[] wbuf = new byte[1];
    private boolean usesDefaultInflater = false;
    private boolean closed = false;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public InflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Inflater());
        this.usesDefaultInflater = true;
    }

    public InflaterOutputStream(OutputStream outputStream, Inflater inflater) {
        this(outputStream, inflater, 512);
    }

    public InflaterOutputStream(OutputStream outputStream, Inflater inflater, int n) {
        super(outputStream);
        if (outputStream == null) {
            throw new NullPointerException("Null output");
        }
        if (inflater == null) {
            throw new NullPointerException("Null inflater");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size < 1");
        }
        this.inf = inflater;
        this.buf = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.out.close();
                this.closed = true;
                throw throwable;
            }
            this.out.close();
            this.closed = true;
            {
            }
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        if (!this.inf.finished()) {
            try {
                int n;
                while (!this.inf.finished() && !this.inf.needsInput() && (n = this.inf.inflate(this.buf, 0, this.buf.length)) >= 1) {
                    this.out.write(this.buf, 0, n);
                }
                super.flush();
            }
            catch (DataFormatException dataFormatException) {
                String string = dataFormatException.getMessage();
                if (string == null) {
                    string = "Invalid ZLIB data format";
                }
                throw new ZipException(string);
            }
        }
    }

    public void finish() throws IOException {
        this.ensureOpen();
        this.flush();
        if (this.usesDefaultInflater) {
            this.inf.end();
        }
    }

    public void write(int n) throws IOException {
        this.wbuf[0] = (byte)n;
        this.write(this.wbuf, 0, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException("Null buffer for read");
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        try {
            do {
                int n3;
                if (this.inf.needsInput()) {
                    if (n2 < 1) return;
                    int n4 = n2 < 512 ? n2 : 512;
                    this.inf.setInput(byArray, n, n4);
                    n += n4;
                    n2 -= n4;
                }
                do {
                    if ((n3 = this.inf.inflate(this.buf, 0, this.buf.length)) <= 0) continue;
                    this.out.write(this.buf, 0, n3);
                } while (n3 > 0);
                if (this.inf.finished()) return;
            } while (!this.inf.needsDictionary());
            throw new ZipException("ZLIB dictionary missing");
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            if (string != null) throw new ZipException(string);
            string = "Invalid ZLIB data format";
            throw new ZipException(string);
        }
    }
}

