/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private Locale locale;
    private String pattern = "";
    private static final int INITIAL_FORMATS = 10;
    private Format[] formats = new Format[10];
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private int maxOffset = -1;
    private static final String[] typeList = new String[]{"", "", "number", "", "date", "", "time", "", "choice"};
    private static final String[] modifierList = new String[]{"", "", "currency", "", "percent", "", "integer"};
    private static final String[] dateModifierList = new String[]{"", "", "short", "", "medium", "", "long", "", "full"};

    public MessageFormat(String string) {
        this.locale = Locale.getDefault();
        this.applyPattern(string);
    }

    public MessageFormat(String string, Locale locale) {
        this.locale = locale;
        this.applyPattern(string);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void applyPattern(String string) {
        int n;
        StringBuffer[] stringBufferArray = new StringBuffer[4];
        for (n = 0; n < stringBufferArray.length; ++n) {
            stringBufferArray[n] = new StringBuffer();
        }
        n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        this.maxOffset = -1;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n == 0) {
                if (c == '\'') {
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                        stringBufferArray[n].append(c);
                        ++i;
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (c == '{' && !bl) {
                    n = 1;
                    continue;
                }
                stringBufferArray[n].append(c);
                continue;
            }
            if (bl) {
                stringBufferArray[n].append(c);
                if (c != '\'') continue;
                bl = false;
                continue;
            }
            switch (c) {
                case ',': {
                    if (n < 3) {
                        ++n;
                        continue block7;
                    }
                    stringBufferArray[n].append(c);
                    continue block7;
                }
                case '{': {
                    ++n3;
                    stringBufferArray[n].append(c);
                    continue block7;
                }
                case '}': {
                    if (n3 == 0) {
                        n = 0;
                        this.makeFormat(i, n2, stringBufferArray);
                        ++n2;
                        continue block7;
                    }
                    --n3;
                    stringBufferArray[n].append(c);
                    continue block7;
                }
                case '\'': {
                    bl = true;
                }
                default: {
                    stringBufferArray[n].append(c);
                }
            }
        }
        if (n3 == 0 && n != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        this.pattern = stringBufferArray[0].toString();
    }

    public String toPattern() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= this.maxOffset; ++i) {
            MessageFormat.copyAndFixQuotes(this.pattern, n, this.offsets[i], stringBuffer);
            n = this.offsets[i];
            stringBuffer.append('{');
            stringBuffer.append(this.argumentNumbers[i]);
            if (this.formats[i] != null) {
                if (this.formats[i] instanceof DecimalFormat) {
                    if (this.formats[i].equals(NumberFormat.getInstance(this.locale))) {
                        stringBuffer.append(",number");
                    } else if (this.formats[i].equals(NumberFormat.getCurrencyInstance(this.locale))) {
                        stringBuffer.append(",number,currency");
                    } else if (this.formats[i].equals(NumberFormat.getPercentInstance(this.locale))) {
                        stringBuffer.append(",number,percent");
                    } else if (this.formats[i].equals(NumberFormat.getIntegerInstance(this.locale))) {
                        stringBuffer.append(",number,integer");
                    } else {
                        stringBuffer.append(",number," + ((DecimalFormat)this.formats[i]).toPattern());
                    }
                } else if (this.formats[i] instanceof SimpleDateFormat) {
                    if (this.formats[i].equals(DateFormat.getDateInstance(2, this.locale))) {
                        stringBuffer.append(",date");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(3, this.locale))) {
                        stringBuffer.append(",date,short");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(2, this.locale))) {
                        stringBuffer.append(",date,medium");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(1, this.locale))) {
                        stringBuffer.append(",date,long");
                    } else if (this.formats[i].equals(DateFormat.getDateInstance(0, this.locale))) {
                        stringBuffer.append(",date,full");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        stringBuffer.append(",time");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(3, this.locale))) {
                        stringBuffer.append(",time,short");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(2, this.locale))) {
                        stringBuffer.append(",time,medium");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(1, this.locale))) {
                        stringBuffer.append(",time,long");
                    } else if (this.formats[i].equals(DateFormat.getTimeInstance(0, this.locale))) {
                        stringBuffer.append(",time,full");
                    } else {
                        stringBuffer.append(",date," + ((SimpleDateFormat)this.formats[i]).toPattern());
                    }
                } else if (this.formats[i] instanceof ChoiceFormat) {
                    stringBuffer.append(",choice," + ((ChoiceFormat)this.formats[i]).toPattern());
                }
            }
            stringBuffer.append('}');
        }
        MessageFormat.copyAndFixQuotes(this.pattern, n, this.pattern.length(), stringBuffer);
        return stringBuffer.toString();
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        for (int i = 0; i <= this.maxOffset; ++i) {
            int n = this.argumentNumbers[i];
            if (n >= formatArray.length) continue;
            this.formats[i] = formatArray[n];
        }
    }

    public void setFormats(Format[] formatArray) {
        int n = formatArray.length;
        if (n > this.maxOffset + 1) {
            n = this.maxOffset + 1;
        }
        for (int i = 0; i < n; ++i) {
            this.formats[i] = formatArray[i];
        }
    }

    public void setFormatByArgumentIndex(int n, Format format) {
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] != n) continue;
            this.formats[i] = format;
        }
    }

    public void setFormat(int n, Format format) {
        this.formats[n] = format;
    }

    public Format[] getFormatsByArgumentIndex() {
        int n = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] <= n) continue;
            n = this.argumentNumbers[i];
        }
        Format[] formatArray = new Format[n + 1];
        for (int i = 0; i <= this.maxOffset; ++i) {
            formatArray[this.argumentNumbers[i]] = this.formats[i];
        }
        return formatArray;
    }

    public Format[] getFormats() {
        Format[] formatArray = new Format[this.maxOffset + 1];
        System.arraycopy(this.formats, 0, formatArray, 0, this.maxOffset + 1);
        return formatArray;
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.subformat(objectArray, stringBuffer, fieldPosition, null);
    }

    public static String format(String string, Object ... objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.subformat((Object[])object, stringBuffer, fieldPosition, null);
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        if (object == null) {
            throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
        }
        this.subformat((Object[])object, stringBuffer, null, arrayList);
        if (arrayList.size() == 0) {
            return this.createAttributedCharacterIterator("");
        }
        return this.createAttributedCharacterIterator(arrayList.toArray(new AttributedCharacterIterator[arrayList.size()]));
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n;
        if (string == null) {
            Object[] objectArray = new Object[]{};
            return objectArray;
        }
        int n2 = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] <= n2) continue;
            n2 = this.argumentNumbers[i];
        }
        Object[] objectArray = new Object[n2 + 1];
        int n3 = 0;
        int n4 = parsePosition.index;
        ParsePosition parsePosition2 = new ParsePosition(0);
        for (n = 0; n <= this.maxOffset; ++n) {
            int n5 = this.offsets[n] - n3;
            if (n5 == 0 || this.pattern.regionMatches(n3, string, n4, n5)) {
                n4 += n5;
                n3 += n5;
            } else {
                parsePosition.errorIndex = n4;
                return null;
            }
            if (this.formats[n] == null) {
                int n6 = n != this.maxOffset ? this.offsets[n + 1] : this.pattern.length();
                int n7 = n3 >= n6 ? string.length() : string.indexOf(this.pattern.substring(n3, n6), n4);
                if (n7 < 0) {
                    parsePosition.errorIndex = n4;
                    return null;
                }
                String string2 = string.substring(n4, n7);
                if (!string2.equals("{" + this.argumentNumbers[n] + "}")) {
                    objectArray[this.argumentNumbers[n]] = string.substring(n4, n7);
                }
                n4 = n7;
                continue;
            }
            parsePosition2.index = n4;
            objectArray[this.argumentNumbers[n]] = this.formats[n].parseObject(string, parsePosition2);
            if (parsePosition2.index == n4) {
                parsePosition.errorIndex = n4;
                return null;
            }
            n4 = parsePosition2.index;
        }
        n = this.pattern.length() - n3;
        if (n != 0 && !this.pattern.regionMatches(n3, string, n4, n)) {
            parsePosition.errorIndex = n4;
            return null;
        }
        parsePosition.index = n4 + n;
        return objectArray;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("MessageFormat parse error!", parsePosition.errorIndex);
        }
        return objectArray;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        messageFormat.formats = (Format[])this.formats.clone();
        for (int i = 0; i < this.formats.length; ++i) {
            if (this.formats[i] == null) continue;
            messageFormat.formats[i] = (Format)this.formats[i].clone();
        }
        messageFormat.offsets = (int[])this.offsets.clone();
        messageFormat.argumentNumbers = (int[])this.argumentNumbers.clone();
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return this.maxOffset == messageFormat.maxOffset && this.pattern.equals(messageFormat.pattern) && (this.locale != null && this.locale.equals(messageFormat.locale) || this.locale == null && messageFormat.locale == null) && Arrays.equals(this.offsets, messageFormat.offsets) && Arrays.equals(this.argumentNumbers, messageFormat.argumentNumbers) && Arrays.equals(this.formats, messageFormat.formats);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private StringBuffer subformat(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition, List list) {
        int n = 0;
        int n2 = stringBuffer.length();
        for (int i = 0; i <= this.maxOffset; ++i) {
            stringBuffer.append(this.pattern.substring(n, this.offsets[i]));
            n = this.offsets[i];
            int n3 = this.argumentNumbers[i];
            if (objectArray == null || n3 >= objectArray.length) {
                stringBuffer.append("{" + n3 + "}");
                continue;
            }
            Object[] objectArray2 = objectArray[n3];
            String string = null;
            Format format = null;
            if (objectArray2 == null) {
                string = "null";
            } else if (this.formats[i] != null) {
                format = this.formats[i];
                if (format instanceof ChoiceFormat && (string = this.formats[i].format(objectArray2)).indexOf(123) >= 0) {
                    format = new MessageFormat(string, this.locale);
                    objectArray2 = objectArray;
                    string = null;
                }
            } else if (objectArray2 instanceof Number) {
                format = NumberFormat.getInstance(this.locale);
            } else if (objectArray2 instanceof Date) {
                format = DateFormat.getDateTimeInstance(3, 3, this.locale);
            } else if (objectArray2 instanceof String) {
                string = (String)objectArray2;
            } else {
                string = objectArray2.toString();
                if (string == null) {
                    string = "null";
                }
            }
            if (list != null) {
                if (n2 != stringBuffer.length()) {
                    list.add(this.createAttributedCharacterIterator(stringBuffer.substring(n2)));
                    n2 = stringBuffer.length();
                }
                if (format != null) {
                    AttributedCharacterIterator attributedCharacterIterator = format.formatToCharacterIterator(objectArray2);
                    this.append(stringBuffer, attributedCharacterIterator);
                    if (n2 != stringBuffer.length()) {
                        list.add(this.createAttributedCharacterIterator(attributedCharacterIterator, (AttributedCharacterIterator.Attribute)Field.ARGUMENT, (Object)new Integer(n3)));
                        n2 = stringBuffer.length();
                    }
                    string = null;
                }
                if (string == null || string.length() <= 0) continue;
                stringBuffer.append(string);
                list.add(this.createAttributedCharacterIterator(string, (AttributedCharacterIterator.Attribute)Field.ARGUMENT, (Object)new Integer(n3)));
                n2 = stringBuffer.length();
                continue;
            }
            if (format != null) {
                string = format.format(objectArray2);
            }
            n2 = stringBuffer.length();
            stringBuffer.append(string);
            if (i == 0 && fieldPosition != null && Field.ARGUMENT.equals(fieldPosition.getFieldAttribute())) {
                fieldPosition.setBeginIndex(n2);
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            n2 = stringBuffer.length();
        }
        stringBuffer.append(this.pattern.substring(n, this.pattern.length()));
        if (list != null && n2 != stringBuffer.length()) {
            list.add(this.createAttributedCharacterIterator(stringBuffer.substring(n2)));
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, CharacterIterator characterIterator) {
        if (characterIterator.first() != '\uffff') {
            char c;
            stringBuffer.append(characterIterator.first());
            while ((c = characterIterator.next()) != '\uffff') {
                stringBuffer.append(c);
            }
        }
    }

    private void makeFormat(int n, int n2, StringBuffer[] stringBufferArray) {
        Object object;
        int n3;
        int n4;
        try {
            n4 = Integer.parseInt(stringBufferArray[1].toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("can't parse argument number " + stringBufferArray[1]);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("negative argument number " + n4);
        }
        if (n2 >= this.formats.length) {
            n3 = this.formats.length * 2;
            object = new Format[n3];
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            System.arraycopy(this.formats, 0, object, 0, this.maxOffset + 1);
            System.arraycopy(this.offsets, 0, nArray, 0, this.maxOffset + 1);
            System.arraycopy(this.argumentNumbers, 0, nArray2, 0, this.maxOffset + 1);
            this.formats = object;
            this.offsets = nArray;
            this.argumentNumbers = nArray2;
        }
        n3 = this.maxOffset;
        this.maxOffset = n2;
        this.offsets[n2] = stringBufferArray[0].length();
        this.argumentNumbers[n2] = n4;
        object = null;
        block2 : switch (MessageFormat.findKeyword(stringBufferArray[2].toString(), typeList)) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), modifierList)) {
                    case 0: {
                        object = NumberFormat.getInstance(this.locale);
                        break block2;
                    }
                    case 1: 
                    case 2: {
                        object = NumberFormat.getCurrencyInstance(this.locale);
                        break block2;
                    }
                    case 3: 
                    case 4: {
                        object = NumberFormat.getPercentInstance(this.locale);
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        object = NumberFormat.getIntegerInstance(this.locale);
                        break block2;
                    }
                }
                object = new DecimalFormat(stringBufferArray[3].toString(), DecimalFormatSymbols.getInstance(this.locale));
                break;
            }
            case 3: 
            case 4: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), dateModifierList)) {
                    case 0: {
                        object = DateFormat.getDateInstance(2, this.locale);
                        break block2;
                    }
                    case 1: 
                    case 2: {
                        object = DateFormat.getDateInstance(3, this.locale);
                        break block2;
                    }
                    case 3: 
                    case 4: {
                        object = DateFormat.getDateInstance(2, this.locale);
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        object = DateFormat.getDateInstance(1, this.locale);
                        break block2;
                    }
                    case 7: 
                    case 8: {
                        object = DateFormat.getDateInstance(0, this.locale);
                        break block2;
                    }
                }
                object = new SimpleDateFormat(stringBufferArray[3].toString(), this.locale);
                break;
            }
            case 5: 
            case 6: {
                switch (MessageFormat.findKeyword(stringBufferArray[3].toString(), dateModifierList)) {
                    case 0: {
                        object = DateFormat.getTimeInstance(2, this.locale);
                        break block2;
                    }
                    case 1: 
                    case 2: {
                        object = DateFormat.getTimeInstance(3, this.locale);
                        break block2;
                    }
                    case 3: 
                    case 4: {
                        object = DateFormat.getTimeInstance(2, this.locale);
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        object = DateFormat.getTimeInstance(1, this.locale);
                        break block2;
                    }
                    case 7: 
                    case 8: {
                        object = DateFormat.getTimeInstance(0, this.locale);
                        break block2;
                    }
                }
                object = new SimpleDateFormat(stringBufferArray[3].toString(), this.locale);
                break;
            }
            case 7: 
            case 8: {
                try {
                    object = new ChoiceFormat(stringBufferArray[3].toString());
                    break;
                }
                catch (Exception exception) {
                    this.maxOffset = n3;
                    throw new IllegalArgumentException("Choice Pattern incorrect");
                }
            }
            default: {
                this.maxOffset = n3;
                throw new IllegalArgumentException("unknown format type at ");
            }
        }
        this.formats[n2] = object;
        stringBufferArray[1].setLength(0);
        stringBufferArray[2].setLength(0);
        stringBufferArray[3].setLength(0);
    }

    private static final int findKeyword(String string, String[] stringArray) {
        string = string.trim().toLowerCase();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static final void copyAndFixQuotes(String string, int n, int n2, StringBuffer stringBuffer) {
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                stringBuffer.append("'{'");
                continue;
            }
            if (c == '}') {
                stringBuffer.append("'}'");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("''");
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        objectInputStream.defaultReadObject();
        boolean bl2 = bl = this.maxOffset >= -1 && this.formats.length > this.maxOffset && this.offsets.length > this.maxOffset && this.argumentNumbers.length > this.maxOffset;
        if (bl) {
            int n = this.pattern.length() + 1;
            for (int i = this.maxOffset; i >= 0; --i) {
                if (this.offsets[i] < 0 || this.offsets[i] > n) {
                    bl = false;
                    break;
                }
                n = this.offsets[i];
            }
        }
        if (!bl) {
            throw new InvalidObjectException("Could not reconstruct MessageFormat from corrupt stream.");
        }
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String string) {
            super(string);
        }

        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("subclass didn't correctly implement readResolve");
            }
            return ARGUMENT;
        }
    }
}

